/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.pageload;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.service.ThreadLocale;
import org.apache.hivemind.util.ContextResource;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.ITemplateComponent;
import org.apache.tapestry.asset.AssetSource;
import org.apache.tapestry.binding.BindingSource;
import org.apache.tapestry.coerce.ValueConverter;
import org.apache.tapestry.engine.IPageLoader;
import org.apache.tapestry.pageload.ComponentClassProvider;
import org.apache.tapestry.pageload.ComponentClassProviderContext;
import org.apache.tapestry.pageload.ComponentTreeWalker;
import org.apache.tapestry.pageload.IComponentVisitor;
import org.apache.tapestry.pageload.IQueuedInheritedBinding;
import org.apache.tapestry.pageload.PageloadMessages;
import org.apache.tapestry.pageload.QueuedInheritInformalBindings;
import org.apache.tapestry.pageload.QueuedInheritedBinding;
import org.apache.tapestry.pageload.VerifyRequiredParametersVisitor;
import org.apache.tapestry.resolver.ComponentSpecificationResolver;
import org.apache.tapestry.services.ComponentConstructor;
import org.apache.tapestry.services.ComponentConstructorFactory;
import org.apache.tapestry.services.ComponentPropertySource;
import org.apache.tapestry.services.ComponentTemplateLoader;
import org.apache.tapestry.spec.BindingType;
import org.apache.tapestry.spec.ContainedComponent;
import org.apache.tapestry.spec.IAssetSpecification;
import org.apache.tapestry.spec.IBindingSpecification;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IContainedComponent;
import org.apache.tapestry.spec.IParameterSpecification;
import org.apache.tapestry.web.WebContextResource;

public class PageLoader
implements IPageLoader {
    private Log _log;
    private ComponentSpecificationResolver _componentResolver;
    private BindingSource _bindingSource;
    private ComponentTemplateLoader _componentTemplateLoader;
    private List _inheritedBindingQueue = new ArrayList();
    private IComponentVisitor _establishDefaultParameterValuesVisitor;
    private ComponentTreeWalker _establishDefaultParameterValuesWalker;
    private ComponentTreeWalker _verifyRequiredParametersWalker;
    private ComponentConstructorFactory _componentConstructorFactory;
    private ValueConverter _valueConverter;
    private AssetSource _assetSource;
    private ComponentClassProvider _pageClassProvider;
    private ComponentClassProvider _componentClassProvider;
    private ComponentPropertySource _componentPropertySource;
    private ThreadLocale _threadLocale;
    private Locale _locale;
    private int _count;
    private int _depth;
    private int _maxDepth;
    private ClassResolver _classResolver;
    static /* synthetic */ Class class$org$apache$tapestry$BaseComponent;
    static /* synthetic */ Class class$org$apache$tapestry$IComponent;
    static /* synthetic */ Class class$org$apache$tapestry$IPage;

    public void initializeService() {
        VerifyRequiredParametersVisitor verifyRequiredParametersVisitor = new VerifyRequiredParametersVisitor();
        this._verifyRequiredParametersWalker = new ComponentTreeWalker(new IComponentVisitor[]{verifyRequiredParametersVisitor});
        this._establishDefaultParameterValuesWalker = new ComponentTreeWalker(new IComponentVisitor[]{this._establishDefaultParameterValuesVisitor});
    }

    void bind(IComponent container, IComponent component, IContainedComponent contained, String defaultBindingPrefix) {
        boolean formalOnly;
        IComponentSpecification spec = component.getSpecification();
        boolean bl = formalOnly = !spec.getAllowInformalParameters();
        if (contained.getInheritInformalParameters()) {
            if (formalOnly) {
                throw new ApplicationRuntimeException(PageloadMessages.inheritInformalInvalidComponentFormalOnly(component), (Object)component, contained.getLocation(), null);
            }
            IComponentSpecification containerSpec = container.getSpecification();
            if (!containerSpec.getAllowInformalParameters()) {
                throw new ApplicationRuntimeException(PageloadMessages.inheritInformalInvalidContainerFormalOnly(container, component), (Object)component, contained.getLocation(), null);
            }
            QueuedInheritInformalBindings queued = new QueuedInheritInformalBindings(component);
            this._inheritedBindingQueue.add(queued);
        }
        Iterator i = contained.getBindingNames().iterator();
        while (i.hasNext()) {
            BindingType type;
            String name = (String)i.next();
            IParameterSpecification pspec = spec.getParameter(name);
            boolean isFormal = pspec != null;
            String parameterName = isFormal ? pspec.getParameterName() : name;
            IBindingSpecification bspec = contained.getBinding(name);
            if (formalOnly && !isFormal) {
                throw new ApplicationRuntimeException(PageloadMessages.formalParametersOnly(component, name), (Object)component, bspec.getLocation(), null);
            }
            if (!isFormal && spec.isReservedParameterName(name)) continue;
            if (isFormal) {
                if (!name.equals(parameterName)) {
                    this._log.warn((Object)PageloadMessages.usedParameterAlias(contained, name, parameterName, bspec.getLocation()));
                } else if (pspec.isDeprecated()) {
                    this._log.warn((Object)PageloadMessages.deprecatedParameter(name, bspec.getLocation(), contained.getType()));
                }
            }
            if ((type = bspec.getType()) == BindingType.INHERITED) {
                QueuedInheritedBinding queued = new QueuedInheritedBinding(component, bspec.getValue(), parameterName);
                this._inheritedBindingQueue.add(queued);
                continue;
            }
            String description = PageloadMessages.parameterName(name);
            IBinding binding = this.convert(container, description, defaultBindingPrefix, bspec);
            PageLoader.addBindingToComponent(component, parameterName, binding);
        }
    }

    static void addBindingToComponent(IComponent component, String parameterName, IBinding binding) {
        IBinding existing = component.getBinding(parameterName);
        if (existing != null) {
            throw new ApplicationRuntimeException(PageloadMessages.duplicateParameter(parameterName, existing), (Object)component, binding.getLocation(), null);
        }
        component.setBinding(parameterName, binding);
    }

    private IBinding convert(IComponent container, String description, String defaultBindingType, IBindingSpecification spec) {
        Location location = spec.getLocation();
        String bindingReference = spec.getValue();
        return this._bindingSource.createBinding(container, description, bindingReference, defaultBindingType, location);
    }

    private void constructComponent(IRequestCycle cycle, IPage page, IComponent container, IComponentSpecification containerSpec, INamespace namespace) {
        ++this._depth;
        if (this._depth > this._maxDepth) {
            this._maxDepth = this._depth;
        }
        String defaultBindingPrefix = this._componentPropertySource.getComponentProperty(container, "org.apache.tapestry.default-binding-prefix");
        ArrayList ids = new ArrayList(containerSpec.getComponentIds());
        int count = ids.size();
        try {
            for (int i = 0; i < count; ++i) {
                String id = (String)ids.get(i);
                IContainedComponent contained = containerSpec.getComponent(id);
                String type = contained.getType();
                Location location = contained.getLocation();
                this._componentResolver.resolve(cycle, namespace, type, location);
                IComponentSpecification componentSpecification = this._componentResolver.getSpecification();
                INamespace componentNamespace = this._componentResolver.getNamespace();
                IComponent component = this.instantiateComponent(page, container, id, componentSpecification, this._componentResolver.getType(), componentNamespace, contained);
                container.addComponent(component);
                this.bind(container, component, contained, defaultBindingPrefix);
                this.constructComponent(cycle, page, component, componentSpecification, componentNamespace);
            }
            this.addAssets(container, containerSpec);
            container.finishLoad(cycle, this, containerSpec);
            container.enterActiveState();
        }
        catch (ApplicationRuntimeException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new ApplicationRuntimeException(PageloadMessages.unableToInstantiateComponent(container, ex), (Object)container, null, (Throwable)ex);
        }
        --this._depth;
    }

    public IComponent createImplicitComponent(IRequestCycle cycle, IComponent container, String componentId, String componentType, Location location) {
        IPage page = container.getPage();
        this._componentResolver.resolve(cycle, container.getNamespace(), componentType, location);
        INamespace componentNamespace = this._componentResolver.getNamespace();
        IComponentSpecification spec = this._componentResolver.getSpecification();
        ContainedComponent contained = new ContainedComponent();
        contained.setLocation(location);
        contained.setType(componentType);
        IComponent result = this.instantiateComponent(page, container, componentId, spec, this._componentResolver.getType(), componentNamespace, contained);
        container.addComponent(result);
        this.constructComponent(cycle, page, result, spec, componentNamespace);
        return result;
    }

    private IComponent instantiateComponent(IPage page, IComponent container, String id, IComponentSpecification spec, String type, INamespace namespace, IContainedComponent containedComponent) {
        ComponentClassProviderContext context = new ComponentClassProviderContext(type, spec, namespace);
        String className = this._componentClassProvider.provideComponentClassName(context);
        if (HiveMind.isBlank((String)className)) {
            className = (class$org$apache$tapestry$BaseComponent == null ? (class$org$apache$tapestry$BaseComponent = PageLoader.class$("org.apache.tapestry.BaseComponent")) : class$org$apache$tapestry$BaseComponent).getName();
        } else {
            Class componentClass;
            if (!(class$org$apache$tapestry$IComponent == null ? (class$org$apache$tapestry$IComponent = PageLoader.class$("org.apache.tapestry.IComponent")) : class$org$apache$tapestry$IComponent).isAssignableFrom(componentClass = this._classResolver.findClass(className))) {
                throw new ApplicationRuntimeException(PageloadMessages.classNotComponent(componentClass), (Object)container, spec.getLocation(), null);
            }
            if ((class$org$apache$tapestry$IPage == null ? (class$org$apache$tapestry$IPage = PageLoader.class$("org.apache.tapestry.IPage")) : class$org$apache$tapestry$IPage).isAssignableFrom(componentClass)) {
                throw new ApplicationRuntimeException(PageloadMessages.pageNotAllowed(id), (Object)container, spec.getLocation(), null);
            }
        }
        ComponentConstructor cc = this._componentConstructorFactory.getComponentConstructor(spec, className);
        IComponent result = (IComponent)cc.newInstance();
        result.setNamespace(namespace);
        result.setPage(page);
        result.setContainer(container);
        result.setId(id);
        result.setContainedComponent(containedComponent);
        result.setLocation(containedComponent.getLocation());
        ++this._count;
        return result;
    }

    private IPage instantiatePage(String name, INamespace namespace, IComponentSpecification spec) {
        ComponentClassProviderContext context;
        String className;
        Class pageClass;
        Location location = spec.getLocation();
        if (!(class$org$apache$tapestry$IPage == null ? (class$org$apache$tapestry$IPage = PageLoader.class$("org.apache.tapestry.IPage")) : class$org$apache$tapestry$IPage).isAssignableFrom(pageClass = this._classResolver.findClass(className = this._pageClassProvider.provideComponentClassName(context = new ComponentClassProviderContext(name, spec, namespace))))) {
            throw new ApplicationRuntimeException(PageloadMessages.classNotPage(pageClass), location, null);
        }
        String pageName = namespace.constructQualifiedName(name);
        ComponentConstructor cc = this._componentConstructorFactory.getComponentConstructor(spec, className);
        IPage result = (IPage)cc.newInstance();
        result.setNamespace(namespace);
        result.setPageName(pageName);
        result.setPage(result);
        result.setLocale(this._locale);
        result.setLocation(location);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPage loadPage(String name, INamespace namespace, IRequestCycle cycle, IComponentSpecification specification) {
        IPage page = null;
        this._count = 0;
        this._depth = 0;
        this._maxDepth = 0;
        this._locale = this._threadLocale.getLocale();
        try {
            page = this.instantiatePage(name, namespace, specification);
            page.attach(cycle.getEngine(), cycle);
            this.constructComponent(cycle, page, page, specification, namespace);
            this._establishDefaultParameterValuesWalker.walkComponentTree(page);
            this.establishInheritedBindings();
            this._verifyRequiredParametersWalker.walkComponentTree(page);
            page.firePageAttached();
        }
        finally {
            this._locale = null;
            this._inheritedBindingQueue.clear();
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Loaded page " + page + " with " + this._count + " components (maximum depth " + this._maxDepth + ")"));
        }
        return page;
    }

    public void loadTemplateForComponent(IRequestCycle cycle, ITemplateComponent component) {
        this._componentTemplateLoader.loadTemplate(cycle, component);
    }

    private void establishInheritedBindings() {
        this._log.debug((Object)"Establishing inherited bindings");
        int count = this._inheritedBindingQueue.size();
        for (int i = 0; i < count; ++i) {
            IQueuedInheritedBinding queued = (IQueuedInheritedBinding)this._inheritedBindingQueue.get(i);
            queued.connect();
        }
    }

    private void addAssets(IComponent component, IComponentSpecification specification) {
        List names = specification.getAssetNames();
        if (names.isEmpty()) {
            return;
        }
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            IAssetSpecification assetSpec = specification.getAsset(name);
            IAsset asset = this.convertAsset(assetSpec);
            component.addAsset(name, asset);
        }
    }

    private IAsset convertAsset(IAssetSpecification spec) {
        String path = spec.getPath();
        Location location = spec.getLocation();
        Resource specResource = location.getResource();
        if (this.isContextResource(specResource)) {
            specResource = specResource.getRelativeResource("/");
        }
        return this._assetSource.findAsset(specResource, path, this._locale, location);
    }

    private boolean isContextResource(Resource resource) {
        return resource instanceof WebContextResource || resource instanceof ContextResource;
    }

    public void setLog(Log log) {
        this._log = log;
    }

    public void setComponentResolver(ComponentSpecificationResolver resolver) {
        this._componentResolver = resolver;
    }

    public void setBindingSource(BindingSource bindingSource) {
        this._bindingSource = bindingSource;
    }

    public void setComponentTemplateLoader(ComponentTemplateLoader componentTemplateLoader) {
        this._componentTemplateLoader = componentTemplateLoader;
    }

    public void setEstablishDefaultParameterValuesVisitor(IComponentVisitor establishDefaultParameterValuesVisitor) {
        this._establishDefaultParameterValuesVisitor = establishDefaultParameterValuesVisitor;
    }

    public void setComponentConstructorFactory(ComponentConstructorFactory componentConstructorFactory) {
        this._componentConstructorFactory = componentConstructorFactory;
    }

    public void setValueConverter(ValueConverter valueConverter) {
        this._valueConverter = valueConverter;
    }

    public void setAssetSource(AssetSource assetSource) {
        this._assetSource = assetSource;
    }

    public void setPageClassProvider(ComponentClassProvider pageClassProvider) {
        this._pageClassProvider = pageClassProvider;
    }

    public void setClassResolver(ClassResolver classResolver) {
        this._classResolver = classResolver;
    }

    public void setComponentClassProvider(ComponentClassProvider componentClassProvider) {
        this._componentClassProvider = componentClassProvider;
    }

    public void setThreadLocale(ThreadLocale threadLocale) {
        this._threadLocale = threadLocale;
    }

    public void setComponentPropertySource(ComponentPropertySource componentPropertySource) {
        this._componentPropertySource = componentPropertySource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

