/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.record;

import java.util.Collection;
import java.util.Iterator;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ErrorLog;
import org.apache.hivemind.util.Defense;
import org.apache.hivemind.util.PropertyUtils;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.IPageRecorder;
import org.apache.tapestry.event.ObservedChangeEvent;
import org.apache.tapestry.record.PropertyChange;
import org.apache.tapestry.record.PropertyPersistenceStrategy;
import org.apache.tapestry.record.PropertyPersistenceStrategySource;
import org.apache.tapestry.record.RecordMessages;
import org.apache.tapestry.spec.IPropertySpecification;

public class PageRecorderImpl
implements IPageRecorder {
    private String _pageName;
    private IRequestCycle _requestCycle;
    private PropertyPersistenceStrategySource _strategySource;
    private boolean _locked = false;
    private ErrorLog _log;

    public PageRecorderImpl(String pageName, IRequestCycle requestCycle, PropertyPersistenceStrategySource strategySource, ErrorLog log) {
        Defense.notNull((Object)pageName, (String)"pageName");
        Defense.notNull((Object)requestCycle, (String)"requestCycle");
        Defense.notNull((Object)strategySource, (String)"strategySource");
        Defense.notNull((Object)log, (String)"log");
        this._pageName = pageName;
        this._requestCycle = requestCycle;
        this._strategySource = strategySource;
        this._log = log;
    }

    public void commit() {
        this._locked = true;
    }

    public Collection getChanges() {
        return this._strategySource.getAllStoredChanges(this._pageName);
    }

    public void rollback(IPage page) {
        Collection changes = this.getChanges();
        Iterator i = changes.iterator();
        while (i.hasNext()) {
            PropertyChange change = (PropertyChange)i.next();
            this.applyChange(page, change);
        }
    }

    private void applyChange(IPage page, PropertyChange change) {
        String idPath = change.getComponentPath();
        IPage component = idPath == null ? page : page.getNestedComponent(idPath);
        PropertyUtils.write((Object)component, (String)change.getPropertyName(), (Object)change.getNewValue());
    }

    public void observeChange(ObservedChangeEvent event) {
        IComponent component = event.getComponent();
        String propertyName = event.getPropertyName();
        if (this._locked) {
            this._log.error(RecordMessages.recorderLocked(propertyName, component), null, null);
            return;
        }
        PropertyPersistenceStrategy strategy = this.findStrategy(component, propertyName);
        if (strategy != null) {
            strategy.store(this._pageName, component.getIdPath(), propertyName, event.getNewValue());
        }
    }

    PropertyPersistenceStrategy findStrategy(IComponent component, String propertyName) {
        IPropertySpecification propertySpecification = component.getSpecification().getPropertySpecification(propertyName);
        if (propertySpecification == null) {
            this._log.error(RecordMessages.missingPropertySpecification(propertyName, component), null, null);
            return null;
        }
        String name = propertySpecification.getPersistence();
        try {
            return this._strategySource.getStrategy(name);
        }
        catch (ApplicationRuntimeException ex) {
            this._log.error(ex.getMessage(), propertySpecification.getLocation(), (Throwable)ex);
            return null;
        }
    }
}

