/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.resolver;

import org.apache.commons.logging.Log;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.impl.LocationImpl;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.resolver.AbstractSpecificationResolver;
import org.apache.tapestry.resolver.ComponentSpecificationResolver;
import org.apache.tapestry.resolver.ResolverMessages;
import org.apache.tapestry.services.ClassFinder;
import org.apache.tapestry.spec.ComponentSpecification;
import org.apache.tapestry.spec.IComponentSpecification;

public class ComponentSpecificationResolverImpl
extends AbstractSpecificationResolver
implements ComponentSpecificationResolver {
    private Log _log;
    private String _type;
    private ClassFinder _classFinder;

    protected void reset() {
        this._type = null;
        super.reset();
    }

    public void resolve(IRequestCycle cycle, INamespace containerNamespace, String type, Location location) {
        Defense.notNull((Object)type, (String)"type");
        int colonx = type.indexOf(58);
        if (colonx > 0) {
            String libraryId = type.substring(0, colonx);
            String simpleType = type.substring(colonx + 1);
            this.resolve(cycle, containerNamespace, libraryId, simpleType, location);
        } else {
            this.resolve(cycle, containerNamespace, null, type, location);
        }
        IComponentSpecification spec = this.getSpecification();
        if (spec.isDeprecated()) {
            this._log.warn((Object)ResolverMessages.componentIsDeprecated(type, location));
        }
    }

    public void resolve(IRequestCycle cycle, INamespace containerNamespace, String libraryId, String type, Location location) {
        this.reset();
        this._type = type;
        INamespace namespace = this.findNamespaceForId(containerNamespace, libraryId);
        this.setNamespace(namespace);
        if (namespace.containsComponentType(type)) {
            this.setSpecification(namespace.getComponentSpecification(type));
            return;
        }
        IComponentSpecification spec = this.searchForComponent(cycle);
        if (spec == null) {
            throw new ApplicationRuntimeException(ResolverMessages.noSuchComponentType(type, namespace), location, null);
        }
        this.setSpecification(spec);
        this.install();
    }

    private IComponentSpecification searchForComponent(IRequestCycle cycle) {
        IComponentSpecification result = null;
        INamespace namespace = this.getNamespace();
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)ResolverMessages.resolvingComponent(this._type, namespace));
        }
        String expectedName = this._type + ".jwc";
        Resource namespaceLocation = namespace.getSpecificationLocation();
        result = this.check(namespaceLocation.getRelativeResource(expectedName));
        if (result != null) {
            return result;
        }
        if (namespace.isApplicationNamespace()) {
            result = this.check(this.getWebInfAppLocation().getRelativeResource(expectedName));
            if (result == null) {
                result = this.check(this.getWebInfLocation().getRelativeResource(expectedName));
            }
            if (result == null) {
                result = this.check(this.getContextRoot().getRelativeResource(expectedName));
            }
            if (result != null) {
                return result;
            }
        }
        if ((result = this.searchForComponentClass(namespace, this._type)) != null) {
            return result;
        }
        INamespace framework = this.getSpecificationSource().getFrameworkNamespace();
        if (framework.containsComponentType(this._type)) {
            return framework.getComponentSpecification(this._type);
        }
        return this.getDelegate().findComponentSpecification(cycle, namespace, this._type);
    }

    IComponentSpecification searchForComponentClass(INamespace namespace, String type) {
        String className;
        String packages = namespace.getPropertyValue("org.apache.tapestry.component-class-packages");
        Class componentClass = this._classFinder.findClass(packages, className = type.replace('/', '.'));
        if (componentClass == null) {
            return null;
        }
        ComponentSpecification spec = new ComponentSpecification();
        Resource namespaceResource = namespace.getSpecificationLocation();
        Resource componentResource = namespaceResource.getRelativeResource(type + ".jwc");
        LocationImpl location = new LocationImpl(componentResource);
        spec.setLocation((Location)location);
        spec.setSpecificationLocation(componentResource);
        spec.setComponentClassName(componentClass.getName());
        return spec;
    }

    private IComponentSpecification check(Resource resource) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Checking: " + resource));
        }
        if (resource.getResourceURL() == null) {
            return null;
        }
        return this.getSpecificationSource().getComponentSpecification(resource);
    }

    private void install() {
        INamespace namespace = this.getNamespace();
        IComponentSpecification specification = this.getSpecification();
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)ResolverMessages.installingComponent(this._type, namespace, specification));
        }
        namespace.installComponentSpecification(this._type, specification);
    }

    public String getType() {
        return this._type;
    }

    public void setLog(Log log) {
        this._log = log;
    }

    public void setClassFinder(ClassFinder classFinder) {
        this._classFinder = classFinder;
    }
}

