/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.net.URLCodec;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ErrorLog;
import org.apache.hivemind.order.Orderer;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.EngineServiceLink;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.engine.ServiceEncoder;
import org.apache.tapestry.engine.ServiceEncoding;
import org.apache.tapestry.engine.ServiceEncodingImpl;
import org.apache.tapestry.record.PropertyPersistenceStrategySource;
import org.apache.tapestry.services.DataSqueezer;
import org.apache.tapestry.services.LinkFactory;
import org.apache.tapestry.services.impl.ImplMessages;
import org.apache.tapestry.services.impl.ServiceEncoderContribution;
import org.apache.tapestry.web.WebRequest;

public class LinkFactoryImpl
implements LinkFactory {
    private DataSqueezer _dataSqueezer;
    private ErrorLog _errorLog;
    private List _contributions;
    private ServiceEncoder[] _encoders;
    private String _contextPath;
    private String _servletPath;
    private final Object[] EMPTY = new Object[0];
    private URLCodec _codec = new URLCodec();
    private WebRequest _request;
    private IRequestCycle _requestCycle;
    private PropertyPersistenceStrategySource _persistenceStrategySource;

    public void initializeService() {
        Orderer orderer = new Orderer(this._errorLog, "encoder");
        Iterator i = this._contributions.iterator();
        while (i.hasNext()) {
            ServiceEncoderContribution c = (ServiceEncoderContribution)((Object)i.next());
            orderer.add((Object)c, c.getId(), c.getAfter(), c.getBefore());
        }
        List ordered = orderer.getOrderedObjects();
        int count = ordered.size();
        this._encoders = new ServiceEncoder[count];
        for (int j = 0; j < count; ++j) {
            ServiceEncoderContribution c = (ServiceEncoderContribution)((Object)ordered.get(j));
            this._encoders[j] = c.getEncoder();
        }
    }

    public ILink constructLink(IEngineService service, boolean post, Map parameters, boolean stateful) {
        this.finalizeParameters(service, parameters);
        IEngine engine = this._requestCycle.getEngine();
        ServiceEncoding serviceEncoding = this.createServiceEncoding(parameters);
        if (stateful) {
            this._persistenceStrategySource.addParametersForPersistentProperties(serviceEncoding, post);
        }
        String fullServletPath = this._contextPath + serviceEncoding.getServletPath();
        return new EngineServiceLink(this._requestCycle, fullServletPath, engine.getOutputEncoding(), this._codec, this._request, parameters, stateful);
    }

    protected void finalizeParameters(IEngineService service, Map parameters) {
        Defense.notNull((Object)service, (String)"service");
        Defense.notNull((Object)parameters, (String)"parameters");
        String serviceName = service.getName();
        if (serviceName == null) {
            throw new ApplicationRuntimeException(ImplMessages.serviceNameIsNull());
        }
        parameters.put("service", serviceName);
        this.squeezeServiceParameters(parameters);
    }

    public ServiceEncoder[] getServiceEncoders() {
        return this._encoders;
    }

    private ServiceEncoding createServiceEncoding(Map parameters) {
        ServiceEncodingImpl result = new ServiceEncodingImpl(this._servletPath, parameters);
        for (int i = 0; i < this._encoders.length; ++i) {
            this._encoders[i].encode(result);
            if (result.isModified()) break;
        }
        return result;
    }

    protected void squeezeServiceParameters(Map parameters) {
        Object[] serviceParameters = (Object[])parameters.get("sp");
        if (serviceParameters == null) {
            return;
        }
        String[] squeezed = this.squeeze(serviceParameters);
        parameters.put("sp", squeezed);
    }

    public Object[] extractListenerParameters(IRequestCycle cycle) {
        Object[] squeezed = cycle.getParameters("sp");
        if (Tapestry.size(squeezed) == 0) {
            return this.EMPTY;
        }
        try {
            return this._dataSqueezer.unsqueeze((String[])squeezed);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException((Throwable)ex);
        }
    }

    private String[] squeeze(Object[] input) {
        try {
            return this._dataSqueezer.squeeze(input);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException((Throwable)ex);
        }
    }

    public void setDataSqueezer(DataSqueezer dataSqueezer) {
        this._dataSqueezer = dataSqueezer;
    }

    public void setContributions(List contributions) {
        this._contributions = contributions;
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }

    public void setServletPath(String servletPath) {
        this._servletPath = servletPath;
    }

    public void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    public void setRequest(WebRequest request) {
        this._request = request;
    }

    public void setPersistenceStrategySource(PropertyPersistenceStrategySource persistenceStrategySource) {
        this._persistenceStrategySource = persistenceStrategySource;
    }

    public void setRequestCycle(IRequestCycle requestCycle) {
        this._requestCycle = requestCycle;
    }
}

