/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.markup.MarkupWriterSource;
import org.apache.tapestry.services.RequestLocaleManager;
import org.apache.tapestry.services.ResponseRenderer;
import org.apache.tapestry.util.ContentType;
import org.apache.tapestry.web.WebResponse;

public class ResponseRendererImpl
implements ResponseRenderer {
    private RequestLocaleManager _localeManager;
    private MarkupWriterSource _markupWriterSource;
    private WebResponse _webResponse;
    public static final String ENCODING_KEY = "charset";

    public void renderResponse(IRequestCycle cycle) throws IOException {
        this._localeManager.persistLocale();
        IPage page = cycle.getPage();
        ContentType contentType = page.getResponseContentType();
        String encoding = contentType.getParameter(ENCODING_KEY);
        if (encoding == null) {
            encoding = cycle.getEngine().getOutputEncoding();
            contentType.setParameter(ENCODING_KEY, encoding);
        }
        PrintWriter printWriter = this._webResponse.getPrintWriter(contentType);
        IMarkupWriter writer = this._markupWriterSource.newMarkupWriter(printWriter, contentType);
        cycle.renderPage(writer);
        writer.close();
    }

    public void setLocaleManager(RequestLocaleManager localeManager) {
        this._localeManager = localeManager;
    }

    public void setMarkupWriterSource(MarkupWriterSource markupWriterSource) {
        this._markupWriterSource = markupWriterSource;
    }

    public void setWebResponse(WebResponse webResponse) {
        this._webResponse = webResponse;
    }
}

