/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.ClasspathResource;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.asset.AssetSource;
import org.apache.tapestry.engine.ISpecificationSource;
import org.apache.tapestry.engine.Namespace;
import org.apache.tapestry.event.ReportStatusEvent;
import org.apache.tapestry.event.ReportStatusListener;
import org.apache.tapestry.event.ResetEventListener;
import org.apache.tapestry.parse.ISpecificationParser;
import org.apache.tapestry.services.NamespaceResources;
import org.apache.tapestry.services.impl.ImplMessages;
import org.apache.tapestry.services.impl.NamespaceResourcesImpl;
import org.apache.tapestry.spec.IApplicationSpecification;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.ILibrarySpecification;
import org.apache.tapestry.spec.LibrarySpecification;
import org.apache.tapestry.util.xml.DocumentParseException;

public class SpecificationSourceImpl
implements ISpecificationSource,
ResetEventListener,
ReportStatusListener {
    private ClassResolver _classResolver;
    private IApplicationSpecification _specification;
    private ISpecificationParser _parser;
    private NamespaceResources _namespaceResources;
    private INamespace _applicationNamespace;
    private INamespace _frameworkNamespace;
    private AssetSource _assetSource;
    private String _serviceId;
    private Map _componentCache = new HashMap();
    private Map _pageCache = new HashMap();
    private Map _libraryCache = new HashMap();
    private Map _namespaceCache = new HashMap();

    public void reportStatus(ReportStatusEvent event) {
        event.title(this._serviceId);
        event.property("page specification count", this._pageCache.size());
        event.collection("page specifications", this._pageCache.keySet());
        event.property("component specification count", this._componentCache.size());
        event.collection("component specifications", this._componentCache.keySet());
    }

    public void initializeService() {
        this._namespaceResources = new NamespaceResourcesImpl(this, this._assetSource);
    }

    public synchronized void resetEventDidOccur() {
        this._componentCache.clear();
        this._pageCache.clear();
        this._libraryCache.clear();
        this._namespaceCache.clear();
        this._applicationNamespace = null;
        this._frameworkNamespace = null;
    }

    protected IComponentSpecification parseSpecification(Resource resource, boolean asPage) {
        IComponentSpecification result = null;
        try {
            result = asPage ? this._parser.parsePageSpecification(resource) : this._parser.parseComponentSpecification(resource);
        }
        catch (DocumentParseException ex) {
            throw new ApplicationRuntimeException(ImplMessages.unableToParseSpecification(resource), (Throwable)((Object)ex));
        }
        return result;
    }

    protected ILibrarySpecification parseLibrarySpecification(Resource resource) {
        try {
            return this._parser.parseLibrarySpecification(resource);
        }
        catch (DocumentParseException ex) {
            throw new ApplicationRuntimeException(ImplMessages.unableToParseSpecification(resource), (Throwable)((Object)ex));
        }
    }

    public synchronized IComponentSpecification getComponentSpecification(Resource resourceLocation) {
        IComponentSpecification result = (IComponentSpecification)this._componentCache.get(resourceLocation);
        if (result == null) {
            result = this.parseSpecification(resourceLocation, false);
            this._componentCache.put(resourceLocation, result);
        }
        return result;
    }

    public synchronized IComponentSpecification getPageSpecification(Resource resourceLocation) {
        IComponentSpecification result = (IComponentSpecification)this._pageCache.get(resourceLocation);
        if (result == null) {
            result = this.parseSpecification(resourceLocation, true);
            this._pageCache.put(resourceLocation, result);
        }
        return result;
    }

    public synchronized ILibrarySpecification getLibrarySpecification(Resource resourceLocation) {
        ILibrarySpecification result = (LibrarySpecification)this._libraryCache.get(resourceLocation);
        if (result == null) {
            result = this.parseLibrarySpecification(resourceLocation);
            this._libraryCache.put(resourceLocation, result);
        }
        return result;
    }

    public synchronized INamespace getApplicationNamespace() {
        if (this._applicationNamespace == null) {
            this._applicationNamespace = new Namespace(null, null, this._specification, this._namespaceResources);
        }
        return this._applicationNamespace;
    }

    public synchronized INamespace getFrameworkNamespace() {
        if (this._frameworkNamespace == null) {
            ClasspathResource resource = new ClasspathResource(this._classResolver, "/org/apache/tapestry/Framework.library");
            ILibrarySpecification ls = this.getLibrarySpecification((Resource)resource);
            this._frameworkNamespace = new Namespace("framework", null, ls, this._namespaceResources);
        }
        return this._frameworkNamespace;
    }

    public void setParser(ISpecificationParser parser) {
        this._parser = parser;
    }

    public void setClassResolver(ClassResolver resolver) {
        this._classResolver = resolver;
    }

    public void setSpecification(IApplicationSpecification specification) {
        this._specification = specification;
    }

    public void setAssetSource(AssetSource assetSource) {
        this._assetSource = assetSource;
    }

    public void setServiceId(String serviceId) {
        this._serviceId = serviceId;
    }
}

