/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.hivemind.util.Defense;

public class ContentType {
    private String _baseType = "";
    private String _subType = "";
    private final Map _parameters = new HashMap();

    public ContentType() {
    }

    public ContentType(String contentType) {
        this();
        this.parse(contentType);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ContentType ct = (ContentType)o;
        return this._baseType.equals(ct._baseType) && this._subType.equals(ct._subType) && ((Object)this._parameters).equals(ct._parameters);
    }

    public String getBaseType() {
        return this._baseType;
    }

    public void setBaseType(String baseType) {
        Defense.notNull((Object)baseType, (String)"baseType");
        this._baseType = baseType;
    }

    public String getSubType() {
        return this._subType;
    }

    public void setSubType(String subType) {
        Defense.notNull((Object)subType, (String)"subType");
        this._subType = subType;
    }

    public String getMimeType() {
        return this._baseType + "/" + this._subType;
    }

    public String[] getParameterNames() {
        Set parameterNames = this._parameters.keySet();
        return parameterNames.toArray(new String[parameterNames.size()]);
    }

    public String getParameter(String key) {
        Defense.notNull((Object)key, (String)"key");
        return (String)this._parameters.get(key);
    }

    public void setParameter(String key, String value) {
        Defense.notNull((Object)key, (String)"key");
        Defense.notNull((Object)value, (String)"value");
        this._parameters.put(key.toLowerCase(), value);
    }

    public void parse(String contentType) {
        this._baseType = "";
        this._subType = "";
        this._parameters.clear();
        StringTokenizer tokens = new StringTokenizer(contentType, ";");
        if (!tokens.hasMoreTokens()) {
            return;
        }
        String mimeType = tokens.nextToken();
        StringTokenizer mimeTokens = new StringTokenizer(mimeType, "/");
        this.setBaseType(mimeTokens.hasMoreTokens() ? mimeTokens.nextToken() : "");
        this.setSubType(mimeTokens.hasMoreTokens() ? mimeTokens.nextToken() : "");
        while (tokens.hasMoreTokens()) {
            String parameter = tokens.nextToken();
            StringTokenizer parameterTokens = new StringTokenizer(parameter, "=");
            String key = parameterTokens.hasMoreTokens() ? parameterTokens.nextToken() : "";
            String value = parameterTokens.hasMoreTokens() ? parameterTokens.nextToken() : "";
            this.setParameter(key, value);
        }
    }

    public String unparse() {
        StringBuffer buf = new StringBuffer(this.getMimeType());
        String[] parameterNames = this.getParameterNames();
        for (int i = 0; i < parameterNames.length; ++i) {
            String key = parameterNames[i];
            String value = this.getParameter(key);
            buf.append(";" + key + "=" + value);
        }
        return buf.toString();
    }

    public String toString() {
        return this.unparse();
    }
}

