/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.web;

import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.describe.DescriptionReceiver;
import org.apache.tapestry.web.ServletWebSession;
import org.apache.tapestry.web.WebMessages;
import org.apache.tapestry.web.WebRequest;
import org.apache.tapestry.web.WebSession;
import org.apache.tapestry.web.WebUtils;

public class ServletWebRequest
implements WebRequest {
    private final HttpServletRequest _servletRequest;
    private final HttpServletResponse _servletResponse;
    private WebSession _webSession;

    public ServletWebRequest(HttpServletRequest request, HttpServletResponse response) {
        Defense.notNull((Object)request, (String)"request");
        Defense.notNull((Object)response, (String)"response");
        this._servletRequest = request;
        this._servletResponse = response;
    }

    public List getParameterNames() {
        return WebUtils.toSortedList(this._servletRequest.getParameterNames());
    }

    public String getParameterValue(String parameterName) {
        return this._servletRequest.getParameter(parameterName);
    }

    public String[] getParameterValues(String parameterName) {
        return this._servletRequest.getParameterValues(parameterName);
    }

    public String getContextPath() {
        return this._servletRequest.getContextPath();
    }

    public WebSession getSession(boolean create) {
        if (this._webSession != null) {
            return this._webSession;
        }
        HttpSession session = this._servletRequest.getSession(create);
        if (session != null) {
            this._webSession = new ServletWebSession(session);
        }
        return this._webSession;
    }

    public List getAttributeNames() {
        return WebUtils.toSortedList(this._servletRequest.getAttributeNames());
    }

    public Object getAttribute(String name) {
        return this._servletRequest.getAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        if (attribute == null) {
            this._servletRequest.removeAttribute(name);
        } else {
            this._servletRequest.setAttribute(name, attribute);
        }
    }

    public String getScheme() {
        return this._servletRequest.getScheme();
    }

    public String getServerName() {
        return this._servletRequest.getServerName();
    }

    public int getServerPort() {
        return this._servletRequest.getServerPort();
    }

    public String getRequestURI() {
        return this._servletRequest.getRequestURI();
    }

    public void forward(String URL2) {
        boolean internal;
        if (HiveMind.isBlank((String)URL2)) {
            this.performForward("/");
            return;
        }
        boolean bl = internal = !URL2.startsWith("/") && URL2.indexOf("://") <= 0;
        if (internal) {
            this.performForward("/" + URL2);
        } else {
            this.sendRedirect(URL2);
        }
    }

    private void sendRedirect(String URL2) {
        String finalURL = this._servletResponse.encodeRedirectURL(URL2);
        try {
            this._servletResponse.sendRedirect(finalURL);
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(WebMessages.unableToRedirect(URL2, ex), (Throwable)ex);
        }
    }

    private void performForward(String URL2) {
        RequestDispatcher dispatcher = this._servletRequest.getRequestDispatcher(URL2);
        if (dispatcher == null) {
            throw new ApplicationRuntimeException(WebMessages.unableToFindDispatcher(URL2));
        }
        try {
            dispatcher.forward((ServletRequest)this._servletRequest, (ServletResponse)this._servletResponse);
        }
        catch (ServletException ex) {
            throw new ApplicationRuntimeException(WebMessages.unableToForward(URL2, ex), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(WebMessages.unableToForward(URL2, ex), (Throwable)ex);
        }
    }

    public String getActivationPath() {
        return this._servletRequest.getServletPath();
    }

    public String getPathInfo() {
        return this._servletRequest.getPathInfo();
    }

    public Locale getLocale() {
        return this._servletRequest.getLocale();
    }

    public void describeTo(DescriptionReceiver receiver) {
        receiver.describeAlternate(this._servletRequest);
    }

    public String getHeader(String name) {
        return this._servletRequest.getHeader(name);
    }

    public String getRemoteUser() {
        return this._servletRequest.getRemoteUser();
    }

    public Principal getUserPrincipal() {
        return this._servletRequest.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this._servletRequest.isUserInRole(role);
    }
}

