## Gentoo csh.cshrc
##
## 2005-09-29 -- Fabian Groffen (grobian@gentoo.org)
##   * Initial version of a complete redo of this file to fix many bugs
##     and resolve many annoyances experienced by numerous users
##

##
## Load the environment defaults.
##
if ( -r /etc/csh.env ) then
    source /etc/csh.env
endif

##
## Make sure our path includes the basic stuff for root and normal users.
##
set -f path = ( /usr/local/bin /usr/bin /bin /opt/bin $path )
if ( "$uid" == "0" ) then
    set -f path = ( /sbin /usr/sbin /usr/local/sbin $path )
endif

if ( $?tcsh && $?prompt ) then
	##
	## Set a Gentoo-ish shell prompt with colours
	##
	set promptchars = "%#"
	if ( "$uid" == "0" ) then
		set prompt = "%{\033[0;1;34m%}(%{\033[0;1;31m%}%m%{\033[0m%}:%{\033[0;1;34m%}%c3%{\033[0;1;34m%}) %{\033[0;1;31m%}%#%{\033[0m%} "
	else
		set prompt = "%{\033[0;1;34m%}(%{\033[0;1;32m%}%m%{\033[0m%}:%{\033[0;1;34m%}%c3%{\033[0;1;34m%}) %{\033[0;1;32m%}%n%{\033[0;1;32m%}%#%{\033[0m%} "
	endif

	##
	## Change the window title if appropriate
	##
	if ( $?TERM ) then
		switch ( $TERM )
			case xterm*:
			case rxvt:
			case eterm:
			case Eterm:
			case screen:
			case vt100:
				if ( "$uid" == "0" ) then
					set prompt = "%{\033]0;# %m:%~\007%}$prompt"
				else
					set prompt = "%{\033]0;%m:%~\007%}$prompt"
				endif
			breaksw
		endsw
	endif
endif

##
## Source extensions
##
if ( -d /etc/profile.d ) then
	set nonomatch
	foreach i ( /etc/profile.d/*.csh )
		if ( -r $i ) then
			source $i
		endif
	end
	unset i nonomatch
endif
