## Gentoo system tcsh script
##
## Based on the TCSHRC package (http://tcshrc.sourceforge.net)
##
## Please do not change this file!  Place your personal customizations in
## ~/.tcshrc and system-wide customizations in /etc/profiles.d/local.csh
##
## .tcshrc.set            2Sep2001, Simos Xenitellis (simos@hellug.gr)
##
## 2005-09-27  --  Fabian Groffen (grobian@gentoo.org)
##     Fixed many reported bugs
##     Moved enhancements to get near the tcsh raw defaults
## 2003-01-13  --  Alain Penders (alain@gentoo.org)
##     Renamed to /etc/profile.d/tcsh-settings
##     Major rework - settings are now closer to a normal default.
##


##
## Setup some useful globals.
##
if ( ! $?HOST ) then
    setenv HOST `hostname -s`
endif
if ( -r /etc/inputrc && ! $?INPUTRC ) then
    setenv INPUTRC /etc/inputrc
endif
#setenv COLORTERM 1


##
## Everything beyond this point is for interactive shells only!
##
if (! ${?prompt}) goto end

##
## Handle history
##
set history = 200
set histdup = erase
if ( $?TCSH_SHELL_SAVEHISTORY ) then
    set savehist = ( $history merge )
else
    unset savehist
endif

# Enable editing in EUC encoding for the languages where this make sense:
# (From SuSE's csh.cshrc)
if ( ${?LANG} ) then
  switch ( ${LANG:r} )
    case ja*:
      set dspmbyte=euc
      breaksw
    case ko*:
      set dspmbyte=euc
      breaksw
    case zh_TW*:
      set dspmbyte=big5
      breaksw
    default:
      breaksw
  endsw
endif

end:
