# /etc/csh.login
#
# This file is sourced by all login shells only, after csh.cshrc has
# been sourced!


# Load environment settings from csh.env, which is created by
# env-update from the files in /etc/env.d
if ( -r /etc/csh.env ) then
    source /etc/csh.env
endif

# 077 would be more secure, but 022 is generally quite realistic
umask 022

# Set up PATH depending on whether we're root or a normal user.
# There's no real reason to exclude sbin paths from the normal user,
# but it can make tab-completion easier when they aren't in the user's
# PATH to pollute the executable namespace.
#
# It is intentional below to use setenv PATH instead of set -f path.
# This way we can use the PATHs generated by portage.
if ( "$uid" == "0" ) then
    setenv PATH "/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:${ROOTPATH}"
else
	setenv PATH "/usr/local/bin:/usr/bin:/bin:${PATH}"
endif
unsetenv ROOTPATH

# Extract the value of EDITOR
if ( ! $?EDITOR ) then
	if ( -r /etc/rc.conf ) then
		setenv EDITOR `egrep "^EDITOR=" /etc/rc.conf | sed -e 's/^.*="//' -e 's/"$//'`
	endif
	if ( ! $?EDITOR ) then
		setenv EDITOR "/bin/nano"
	endif
endif

# Default terminal initialization
if ( -o /dev/$tty && ${?prompt} ) then
    # Console
    if ( ! ${?TERM} )           setenv TERM linux
    if ( "$TERM" == "unknown" ) setenv TERM linux
    if ( -x "`which stty`" ) stty sane cr0 pass8 dec
    unsetenv TERMCAP
    settc km yes
endif

# Setup a default MAIL variable
if ( -f /var/mail/$USER ) then
    setenv MAIL /var/mail/$USER
    set mail = $MAIL
endif

# If we're root, report who's logging in and out.
if ( "$uid" == "0" ) then
    set who = ( "%n has %a %l from %M." )
    set watch = ( any any )
endif

if ( -d /etc/profile.d ) then
	set nonomatch
	foreach i ( /etc/profile.d/*.csh )
		if ( -r $i ) then
			source $i
		endif
	end
	unset i nonomatch
endif
