# /etc/profile.d/tcsh-settings.csh
#
# Setup some useful globals.


if ( ! $?HOST ) then
    setenv HOST `hostname -s`
endif
if ( -r /etc/inputrc && ! $?INPUTRC ) then
    setenv INPUTRC /etc/inputrc
endif

# Everything beyond this point is for interactive shells only!
if ( "$?0" != "0" ) goto end

# Handle history
set history = 200
set histdup = erase

# Enable editing in EUC encoding for the languages where this make sense:
# (From SuSE's csh.cshrc)
if ( ${?LANG} ) then
  switch ( ${LANG:r} )
    case ja*:
      set dspmbyte=euc
      breaksw
    case ko*:
      set dspmbyte=euc
      breaksw
    case zh_TW*:
      set dspmbyte=big5
      breaksw
    default:
      breaksw
  endsw
endif

end:
