# @GENTOO_PORTAGE_EPREFIX@/etc/csh.login
#
# This file is sourced by all login shells only, after csh.cshrc has
# been sourced!


# Load environment settings from csh.env, which is created by
# env-update from the files in /etc/env.d
if ( -r "@GENTOO_PORTAGE_EPREFIX@/etc/csh.env" ) then
	source "@GENTOO_PORTAGE_EPREFIX@/etc/csh.env"
endif

# 077 would be more secure, but 022 is generally quite realistic
umask 022

# Set up PATH depending on whether we're root or a normal user.
# There's no real reason to exclude sbin paths from the normal user,
# but it can make tab-completion easier when they aren't in the user's
# PATH to pollute the executable namespace.
#
# It is intentional below to use setenv PATH instead of set -f path.
# This way we can use the PATHs generated by portage.
if ( "$uid" == "0" ) then
#MAIN	setenv PATH "/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:${ROOTPATH}"
#PREFIX	setenv PATH "@GENTOO_PORTAGE_EPREFIX@/usr/sbin:@GENTOO_PORTAGE_EPREFIX@/usr/bin:@GENTOO_PORTAGE_EPREFIX@/sbin:@GENTOO_PORTAGE_EPREFIX@/bin:${ROOTPATH}:/usr/sbin:/usr/bin:/sbin:/bin"
else
#MAIN	setenv PATH "/usr/local/bin:/usr/bin:/bin:${PATH}"
#PREFIX	setenv PATH "@GENTOO_PORTAGE_EPREFIX@/usr/bin:@GENTOO_PORTAGE_EPREFIX@/bin:${PATH}:/usr/bin:/bin"
endif
unsetenv ROOTPATH

# Extract the value of EDITOR
if ( ! $?EDITOR ) then
	if ( -r "@GENTOO_PORTAGE_EPREFIX@"/etc/rc.conf ) then
		setenv EDITOR `egrep "^EDITOR=" "@GENTOO_PORTAGE_EPREFIX@/etc/rc.conf" | sed -e 's/^.*="//' -e 's/"$//'`
	endif
	if ( ! $?EDITOR ) then
		setenv EDITOR "@GENTOO_PORTAGE_EPREFIX@/bin/nano"
	endif
endif

# Default terminal initialization
if ( -o /dev/$tty && ${?prompt} ) then
	# Console
	if ( ! ${?TERM} )           setenv TERM linux
	if ( "$TERM" == "unknown" ) setenv TERM linux
	if ( -x "@GENTOO_PORTAGE_EPREFIX@/bin/stty" ) "@GENTOO_PORTAGE_EPREFIX@/bin/stty" sane pass8 dec
	unsetenv TERMCAP
	settc km yes
endif

# Setup HOST and INPUTRC variables
if ( ! $?HOST ) then
	setenv HOST `hostname -s`
endif
if ( -r /etc/inputrc && ! $?INPUTRC ) then
	setenv INPUTRC /etc/inputrc
endif

# If we're root, report who's logging in and out.
if ( "$uid" == "0" ) then
	set who = ( "%n has %a %l from %M." )
	set watch = ( any any )
endif

# Source csh (environment) scripts from @GENTOO_PORTAGE_EPREFIX@/etc/profile.d
if ( -d "@GENTOO_PORTAGE_EPREFIX@/etc/profile.d" ) then
	set nonomatch
	foreach i ( "@GENTOO_PORTAGE_EPREFIX@/etc/profile.d/"*.csh )
		if ( -r $i ) then
			source $i
		endif
	end
	unset i nonomatch
endif
