# pb_AC_ASM_UNDERSCORE
# --------------------
# Check if gcc asm for i386 needs external symbols with an underscore.
# Peter Breitenlohner, April 15, 1996.


AC_DEFUN([pb_AC_ASM_UNDERSCORE],
[AC_REQUIRE_CPP()dnl
AC_CACHE_CHECK([whether gcc asm needs underscore], [pb_cv_asm_underscore],
[
# Older versions of GCC asm for i386 need an underscore prepended to
# external symbols. Figure out if this is so.
AC_TRY_LINK([
extern char val ;
extern void sub () ;
#if defined (__i386__) && defined (__GNUC__) 
asm("        .align 4\n"
".globl sub\n"
"sub:\n"
"        movb \$][1,val\n"
"        ret\n");
#else
void sub () { val = 1; }
#endif /* assembler */
char val ;
], [sub], [pb_cv_asm_underscore=no], [pb_cv_asm_underscore=yes])])
if test "x$pb_cv_asm_underscore" = xyes; then
  AC_DEFINE(ASM_NEEDS_UNDERSCORE)
fi
])

