# Find a program when cross-compiling, or use a default when not.
# $1 = variable which records the outcome
# $2 = program to look for when cross-compiling
# $3 = program to use when not cross-compiling
AC_DEFUN([KPSE_CROSS_PATH_PROG],
  [if test "$cross_compiling" = yes; then
AC_PATH_PROG([$1], [$2])
if test -z "${$1}"; then
  AC_MSG_ERROR([$2 was not found but is required when cross-compiling.
  Install $2 or set \$$1 to the full pathname.])
fi
else
  $1=$3
fi])

# Set BUILD$1 to $2 when cross-compiling, to $($1) if not.
# Example: KPSE_CROSS_BUILD_VAR([CC], [cc]) sets 'BUILDCC' to 'cc'
# if cross-compiling, and to '$(CC)' if not.
AC_DEFUN([KPSE_CROSS_BUILD_VAR],
  [if test "$cross_compiling" = yes; then
  if test -z "${BUILD$1}"; then
    BUILD$1='$2'
  fi
  AC_MSG_RESULT([setting \$BUILD$1 to ${BUILD$1}])
else
  if test -n "${BUILD$1}"; then
    AC_MSG_WARN([\$BUILD$1 set but not cross-compiling.])
  fi
  BUILD$1='$($1)'
fi
AC_SUBST(BUILD$1)
])

