/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.model;

import com.github.cereda.arara.controller.ConfigurationController;
import com.github.cereda.arara.controller.LanguageController;
import com.github.cereda.arara.model.AraraException;
import com.github.cereda.arara.model.FileType;
import com.github.cereda.arara.model.FileTypeResource;
import com.github.cereda.arara.model.Language;
import com.github.cereda.arara.model.Messages;
import com.github.cereda.arara.model.Resource;
import com.github.cereda.arara.utils.CommonUtils;
import com.github.cereda.arara.utils.ConfigurationUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class Configuration {
    private static final LanguageController messages = LanguageController.getInstance();

    public static void load() throws AraraException {
        FileType.init();
        Language.init();
        Configuration.reset();
        File file = ConfigurationUtils.getConfigFile();
        if (file != null) {
            ConfigurationController.getInstance().put("execution.configuration.name", CommonUtils.getCanonicalPath(file));
            Resource resource = ConfigurationUtils.validateConfiguration(file);
            Configuration.update(resource);
        }
        Locale locale = ((Language)ConfigurationController.getInstance().get("execution.language")).getLocale();
        LanguageController.getInstance().setLocale(locale);
    }

    private static void reset() throws AraraException {
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mapping.put("execution.loops", 10L);
        mapping.put("directives.charset", Charset.forName("UTF-8"));
        mapping.put("execution.errors.halt", true);
        mapping.put("execution.timeout", false);
        mapping.put("execution.timeout.value", 0L);
        mapping.put("execution.timeout.unit", (Object)TimeUnit.MILLISECONDS);
        mapping.put("application.version", "4.0");
        mapping.put("application.revision", "1");
        mapping.put("directives.linebreak.pattern", "^\\s*-->\\s(.*)$");
        String directive = "^\\s*(\\w+)\\s*(:\\s*(\\{.*\\})\\s*)?";
        String pattern = "(\\s+(if|while|until|unless)\\s+(\\S.*))?$";
        mapping.put("directives.pattern", directive.concat(pattern));
        mapping.put("application.pattern", "arara:\\s");
        mapping.put("application.width", 65);
        mapping.put("execution.database.name", "arara");
        mapping.put("execution.log.name", "arara");
        mapping.put("execution.verbose", false);
        mapping.put("trigger.halt", false);
        mapping.put("execution.language", new Language("en"));
        mapping.put("execution.logging", false);
        mapping.put("execution.dryrun", false);
        mapping.put("execution.status", 0);
        mapping.put("application.copyright.year", "2012-2018");
        mapping.put("execution.filetypes", ConfigurationUtils.getDefaultFileTypes());
        mapping.put("execution.rule.paths", Arrays.asList(CommonUtils.buildPath(ConfigurationUtils.getApplicationPath(), "rules")));
        mapping.put("execution.preambles", new HashMap());
        mapping.put("execution.preamble.active", false);
        mapping.put("execution.configuration.name", "[none]");
        mapping.put("execution.header", false);
        mapping.put("ui.lookandfeel", "none");
        ConfigurationController controller = ConfigurationController.getInstance();
        for (String key : mapping.keySet()) {
            controller.put(key, mapping.get(key));
        }
    }

    private static void update(Resource resource) throws AraraException {
        long loops;
        ConfigurationController controller = ConfigurationController.getInstance();
        if (resource.getPaths() != null) {
            List<String> paths = resource.getPaths();
            paths = ConfigurationUtils.normalizePaths(paths);
            controller.put("execution.rule.paths", paths);
        }
        if (resource.getFiletypes() != null) {
            List<FileTypeResource> resources = resource.getFiletypes();
            List<FileType> filetypes = new ArrayList<FileType>();
            for (FileTypeResource type : resources) {
                if (type.getPattern() != null) {
                    filetypes.add(new FileType(type.getExtension(), type.getPattern()));
                    continue;
                }
                filetypes.add(new FileType(type.getExtension()));
            }
            filetypes = ConfigurationUtils.normalizeFileTypes(filetypes);
            controller.put("execution.filetypes", filetypes);
        }
        controller.put("execution.verbose", resource.isVerbose());
        controller.put("execution.logging", resource.isLogging());
        controller.put("execution.header", resource.isHeader());
        if (resource.getDbname() != null) {
            controller.put("execution.database.name", ConfigurationUtils.cleanFileName(resource.getDbname()));
        }
        if (resource.getLogname() != null) {
            controller.put("execution.log.name", ConfigurationUtils.cleanFileName(resource.getLogname()));
        }
        if (resource.getLanguage() != null) {
            controller.put("execution.language", new Language(resource.getLanguage()));
        }
        if ((loops = resource.getLoops()) > 0L) {
            controller.put("execution.loops", loops);
        } else if (loops < 0L) {
            throw new AraraException(messages.getMessage(Messages.ERROR_CONFIGURATION_LOOPS_INVALID_RANGE));
        }
        if (resource.getPreambles() != null) {
            controller.put("execution.preambles", resource.getPreambles());
        }
        if (resource.getLaf() != null) {
            controller.put("ui.lookandfeel", resource.getLaf());
        }
    }
}

