/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara;

import com.github.cereda.arara.controller.LanguageController;
import com.github.cereda.arara.controller.LoggingController;
import com.github.cereda.arara.model.AraraException;
import com.github.cereda.arara.model.Configuration;
import com.github.cereda.arara.model.Directive;
import com.github.cereda.arara.model.Extractor;
import com.github.cereda.arara.model.Interpreter;
import com.github.cereda.arara.model.Parser;
import com.github.cereda.arara.model.StopWatch;
import com.github.cereda.arara.utils.CommonUtils;
import com.github.cereda.arara.utils.DirectiveUtils;
import com.github.cereda.arara.utils.DisplayUtils;
import java.util.List;

public class Arara {
    public static void main(String[] args) {
        LanguageController.init();
        LoggingController.init();
        DisplayUtils.printLogo();
        try {
            Configuration.load();
            Parser parser = new Parser(args);
            if (parser.parse()) {
                DisplayUtils.printFileInformation();
                Extractor extractor = new Extractor();
                List<Directive> directives = extractor.extract();
                directives = DirectiveUtils.validate(directives);
                StopWatch.start();
                Interpreter interpreter = new Interpreter();
                interpreter.setDirectives(directives);
                interpreter.execute();
            }
        }
        catch (AraraException exception) {
            DisplayUtils.printException(exception);
        }
        StopWatch.stop();
        DisplayUtils.printTime();
        System.exit(CommonUtils.getExitStatus());
    }
}

