/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.utils;

import com.github.cereda.arara.controller.ConfigurationController;
import com.github.cereda.arara.controller.LanguageController;
import com.github.cereda.arara.model.AraraException;
import com.github.cereda.arara.model.Command;
import com.github.cereda.arara.model.Messages;
import com.github.cereda.arara.model.Pair;
import com.github.cereda.arara.model.Session;
import com.github.cereda.arara.model.Trigger;
import com.github.cereda.arara.utils.ClassLoadingUtils;
import com.github.cereda.arara.utils.CommonUtils;
import com.github.cereda.arara.utils.FileHandlingUtils;
import com.github.cereda.arara.utils.FileSearchingUtils;
import com.github.cereda.arara.utils.MessageUtils;
import com.github.cereda.arara.utils.UnsafeUtils;
import com.github.cereda.arara.utils.VelocityUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Methods {
    private static final LanguageController messages = LanguageController.getInstance();
    private static final Session session = new Session();

    public static void addRuleMethods(Map<String, Object> map) {
        Methods.addConditionalMethods(map);
        try {
            map.put("getOriginalFile", Methods.class.getMethod("getOriginalFile", new Class[0]));
            map.put("getOriginalReference", Methods.class.getMethod("getOriginalReference", new Class[0]));
            map.put("isEmpty", Methods.class.getMethod("isEmpty", String.class));
            map.put("isNotEmpty", Methods.class.getMethod("isNotEmpty", String.class));
            map.put("isEmpty", Methods.class.getMethod("isEmpty", String.class, Object.class));
            map.put("isNotEmpty", Methods.class.getMethod("isNotEmpty", String.class, Object.class));
            map.put("isEmpty", Methods.class.getMethod("isEmpty", String.class, Object.class, Object.class));
            map.put("isNotEmpty", Methods.class.getMethod("isNotEmpty", String.class, Object.class, Object.class));
            map.put("isTrue", Methods.class.getMethod("isTrue", String.class));
            map.put("isFalse", Methods.class.getMethod("isFalse", String.class));
            map.put("isTrue", Methods.class.getMethod("isTrue", String.class, Object.class));
            map.put("isFalse", Methods.class.getMethod("isFalse", String.class, Object.class));
            map.put("isTrue", Methods.class.getMethod("isTrue", String.class, Object.class, Object.class));
            map.put("isFalse", Methods.class.getMethod("isFalse", String.class, Object.class, Object.class));
            map.put("isTrue", Methods.class.getMethod("isTrue", String.class, Object.class, Object.class, Object.class));
            map.put("isFalse", Methods.class.getMethod("isFalse", String.class, Object.class, Object.class, Object.class));
            map.put("trimSpaces", Methods.class.getMethod("trimSpaces", String.class));
            map.put("isTrue", Methods.class.getMethod("isTrue", Boolean.TYPE, Object.class));
            map.put("isFalse", Methods.class.getMethod("isFalse", Boolean.TYPE, Object.class));
            map.put("isTrue", Methods.class.getMethod("isTrue", Boolean.TYPE, Object.class, Object.class));
            map.put("isFalse", Methods.class.getMethod("isFalse", Boolean.TYPE, Object.class, Object.class));
            map.put("getBasename", Methods.class.getMethod("getBasename", File.class));
            map.put("getBasename", Methods.class.getMethod("getBasename", String.class));
            map.put("getFullBasename", Methods.class.getMethod("getFullBasename", File.class));
            map.put("getFullBasename", Methods.class.getMethod("getFullBasename", String.class));
            map.put("getFiletype", Methods.class.getMethod("getFiletype", File.class));
            map.put("getFiletype", Methods.class.getMethod("getFiletype", String.class));
            map.put("throwError", Methods.class.getMethod("throwError", String.class));
            map.put("getSession", Methods.class.getMethod("getSession", new Class[0]));
            map.put("isWindows", Methods.class.getMethod("isWindows", new Class[0]));
            map.put("isLinux", Methods.class.getMethod("isLinux", new Class[0]));
            map.put("isMac", Methods.class.getMethod("isMac", new Class[0]));
            map.put("isUnix", Methods.class.getMethod("isUnix", new Class[0]));
            map.put("isAIX", Methods.class.getMethod("isAIX", new Class[0]));
            map.put("isIrix", Methods.class.getMethod("isIrix", new Class[0]));
            map.put("isOS2", Methods.class.getMethod("isOS2", new Class[0]));
            map.put("isSolaris", Methods.class.getMethod("isSolaris", new Class[0]));
            map.put("isCygwin", Methods.class.getMethod("isCygwin", new Class[0]));
            map.put("isWindows", Methods.class.getMethod("isWindows", Object.class, Object.class));
            map.put("isLinux", Methods.class.getMethod("isLinux", Object.class, Object.class));
            map.put("isMac", Methods.class.getMethod("isMac", Object.class, Object.class));
            map.put("isUnix", Methods.class.getMethod("isUnix", Object.class, Object.class));
            map.put("isAIX", Methods.class.getMethod("isAIX", Object.class, Object.class));
            map.put("isIrix", Methods.class.getMethod("isIrix", Object.class, Object.class));
            map.put("isOS2", Methods.class.getMethod("isOS2", Object.class, Object.class));
            map.put("isSolaris", Methods.class.getMethod("isSolaris", Object.class, Object.class));
            map.put("isCygwin", Methods.class.getMethod("isCygwin", Object.class, Object.class));
            map.put("replicatePattern", Methods.class.getMethod("replicatePattern", String.class, List.class));
            map.put("buildString", Methods.class.getMethod("buildString", Object[].class));
            map.put("addQuotes", Methods.class.getMethod("addQuotes", Object.class));
            map.put("getCommand", Methods.class.getMethod("getCommand", List.class));
            map.put("getCommand", Methods.class.getMethod("getCommand", Object[].class));
            map.put("getTrigger", Methods.class.getMethod("getTrigger", String.class));
            map.put("getTrigger", Methods.class.getMethod("getTrigger", String.class, Object[].class));
            map.put("checkClass", Methods.class.getMethod("checkClass", Class.class, Object.class));
            map.put("isString", Methods.class.getMethod("isString", Object.class));
            map.put("isList", Methods.class.getMethod("isList", Object.class));
            map.put("isMap", Methods.class.getMethod("isMap", Object.class));
            map.put("isBoolean", Methods.class.getMethod("isBoolean", Object.class));
            map.put("isVerboseMode", Methods.class.getMethod("isVerboseMode", new Class[0]));
            map.put("showMessage", Methods.class.getMethod("showMessage", Integer.TYPE, String.class, String.class));
            map.put("showMessage", Methods.class.getMethod("showMessage", Integer.TYPE, Integer.TYPE, String.class, String.class));
            map.put("isOnPath", Methods.class.getMethod("isOnPath", String.class));
            map.put("unsafelyExecuteSystemCommand", Methods.class.getMethod("unsafelyExecuteSystemCommand", Command.class));
            map.put("mergeVelocityTemplate", Methods.class.getMethod("mergeVelocityTemplate", File.class, File.class, Map.class));
            map.put("getCommandWithWorkingDirectory", Methods.class.getMethod("getCommandWithWorkingDirectory", String.class, List.class));
            map.put("getCommandWithWorkingDirectory", Methods.class.getMethod("getCommandWithWorkingDirectory", String.class, Object[].class));
            map.put("getCommandWithWorkingDirectory", Methods.class.getMethod("getCommandWithWorkingDirectory", File.class, List.class));
            map.put("getCommandWithWorkingDirectory", Methods.class.getMethod("getCommandWithWorkingDirectory", File.class, Object[].class));
            map.put("listFilesByExtensions", Methods.class.getMethod("listFilesByExtensions", File.class, List.class, Boolean.TYPE));
            map.put("listFilesByExtensions", Methods.class.getMethod("listFilesByExtensions", String.class, List.class, Boolean.TYPE));
            map.put("listFilesByPatterns", Methods.class.getMethod("listFilesByPatterns", File.class, List.class, Boolean.TYPE));
            map.put("listFilesByPatterns", Methods.class.getMethod("listFilesByPatterns", String.class, List.class, Boolean.TYPE));
            map.put("writeToFile", Methods.class.getMethod("writeToFile", File.class, String.class, Boolean.TYPE));
            map.put("writeToFile", Methods.class.getMethod("writeToFile", File.class, List.class, Boolean.TYPE));
            map.put("writeToFile", Methods.class.getMethod("writeToFile", String.class, String.class, Boolean.TYPE));
            map.put("writeToFile", Methods.class.getMethod("writeToFile", String.class, List.class, Boolean.TYPE));
            map.put("readFromFile", Methods.class.getMethod("readFromFile", File.class));
            map.put("readFromFile", Methods.class.getMethod("readFromFile", String.class));
            map.put("isSubdirectory", Methods.class.getMethod("isSubdirectory", File.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addConditionalMethods(Map<String, Object> map) {
        try {
            map.put("exists", Methods.class.getMethod("exists", String.class));
            map.put("exists", Methods.class.getMethod("exists", File.class));
            map.put("missing", Methods.class.getMethod("missing", String.class));
            map.put("missing", Methods.class.getMethod("missing", File.class));
            map.put("changed", Methods.class.getMethod("changed", String.class));
            map.put("changed", Methods.class.getMethod("changed", File.class));
            map.put("unchanged", Methods.class.getMethod("unchanged", String.class));
            map.put("unchanged", Methods.class.getMethod("unchanged", File.class));
            map.put("found", Methods.class.getMethod("found", String.class, String.class));
            map.put("found", Methods.class.getMethod("found", File.class, String.class));
            map.put("toFile", Methods.class.getMethod("toFile", String.class));
            map.put("showDropdown", Methods.class.getMethod("showDropdown", Integer.TYPE, String.class, String.class, Object[].class));
            map.put("showDropdown", Methods.class.getMethod("showDropdown", Integer.TYPE, Integer.TYPE, String.class, String.class, Object[].class));
            map.put("showInput", Methods.class.getMethod("showInput", Integer.TYPE, String.class, String.class));
            map.put("showInput", Methods.class.getMethod("showInput", Integer.TYPE, Integer.TYPE, String.class, String.class));
            map.put("showOptions", Methods.class.getMethod("showOptions", Integer.TYPE, String.class, String.class, Object[].class));
            map.put("showOptions", Methods.class.getMethod("showOptions", Integer.TYPE, Integer.TYPE, String.class, String.class, Object[].class));
            map.put("currentFile", Methods.class.getMethod("currentFile", new Class[0]));
            map.put("loadClass", Methods.class.getMethod("loadClass", File.class, String.class));
            map.put("loadClass", Methods.class.getMethod("loadClass", String.class, String.class));
            map.put("loadObject", Methods.class.getMethod("loadObject", File.class, String.class));
            map.put("loadObject", Methods.class.getMethod("loadObject", String.class, String.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getOriginalFile() {
        File file = (File)ConfigurationController.getInstance().get("execution.reference");
        return file.getName();
    }

    public static File getOriginalReference() {
        return (File)ConfigurationController.getInstance().get("execution.reference");
    }

    public static boolean isEmpty(String string) {
        return CommonUtils.checkEmptyString(string);
    }

    public static boolean isNotEmpty(String string) {
        return !Methods.isEmpty(string);
    }

    public static Object isEmpty(String string, Object yes) {
        return Methods.isEmpty(string) ? yes : "";
    }

    public static Object isNotEmpty(String string, Object yes) {
        return Methods.isNotEmpty(string) ? yes : "";
    }

    public static Object isEmpty(String string, Object yes, Object no) {
        return Methods.isEmpty(string) ? yes : no;
    }

    public static Object isNotEmpty(String string, Object yes, Object no) {
        return Methods.isNotEmpty(string) ? yes : no;
    }

    public static boolean isTrue(String string) throws AraraException {
        return Methods.isEmpty(string) ? false : CommonUtils.checkBoolean(string);
    }

    public static boolean isFalse(String string) throws AraraException {
        return Methods.isEmpty(string) ? false : !CommonUtils.checkBoolean(string);
    }

    public static Object isTrue(String string, Object yes) throws AraraException {
        return Methods.isTrue(string) ? yes : "";
    }

    public static Object isFalse(String string, Object yes) throws AraraException {
        return Methods.isFalse(string) ? yes : "";
    }

    public static Object isTrue(String string, Object yes, Object no) throws AraraException {
        return Methods.isTrue(string) ? yes : no;
    }

    public static Object isFalse(String string, Object yes, Object no) throws AraraException {
        return Methods.isFalse(string) ? yes : no;
    }

    public static Object isTrue(String string, Object yes, Object no, Object fallback) throws AraraException {
        return Methods.isEmpty(string) ? fallback : (Methods.isTrue(string) ? yes : no);
    }

    public static Object isFalse(String string, Object yes, Object no, Object fallback) throws AraraException {
        return Methods.isEmpty(string) ? fallback : (Methods.isFalse(string) ? yes : no);
    }

    public static String trimSpaces(String string) {
        return string.trim();
    }

    public static Object isTrue(boolean value, Object yes) {
        return value ? yes : "";
    }

    public static Object isFalse(boolean value, Object yes) {
        return !value ? yes : "";
    }

    public static Object isTrue(boolean value, Object yes, Object no) {
        return value ? yes : no;
    }

    public static Object isFalse(boolean value, Object yes, Object no) {
        return !value ? yes : no;
    }

    public static String getBasename(File file) throws AraraException {
        if (file.isFile()) {
            return CommonUtils.getBasename(file);
        }
        throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_BASENAME_NOT_A_FILE, file.getName())));
    }

    public static String getBasename(String filename) {
        return CommonUtils.getBasename(filename);
    }

    public static String getFiletype(File file) throws AraraException {
        if (file.isFile()) {
            return CommonUtils.getFiletype(file);
        }
        throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_FILETYPE_NOT_A_FILE, file.getName())));
    }

    public static String getFiletype(String filename) {
        return CommonUtils.getFiletype(filename);
    }

    public static List<Object> replicatePattern(String pattern, List<Object> values) throws AraraException {
        return CommonUtils.replicateList(pattern, values);
    }

    public static void throwError(String text) throws AraraException {
        throw new AraraException(text);
    }

    public static Session getSession() {
        return session;
    }

    public static boolean isWindows() throws AraraException {
        return CommonUtils.checkOS("windows");
    }

    public static boolean isCygwin() throws AraraException {
        return CommonUtils.checkOS("cygwin");
    }

    public static boolean isLinux() throws AraraException {
        return CommonUtils.checkOS("linux");
    }

    public static boolean isMac() throws AraraException {
        return CommonUtils.checkOS("mac");
    }

    public static boolean isUnix() throws AraraException {
        return CommonUtils.checkOS("unix");
    }

    public static boolean isAIX() throws AraraException {
        return CommonUtils.checkOS("aix");
    }

    public static boolean isIrix() throws AraraException {
        return CommonUtils.checkOS("irix");
    }

    public static boolean isOS2() throws AraraException {
        return CommonUtils.checkOS("os2");
    }

    public static boolean isSolaris() throws AraraException {
        return CommonUtils.checkOS("solaris");
    }

    public static Object isWindows(Object yes, Object no) throws AraraException {
        return CommonUtils.checkOS("windows") ? yes : no;
    }

    public static Object isCygwin(Object yes, Object no) throws AraraException {
        return CommonUtils.checkOS("cygwin") ? yes : no;
    }

    public static Object isLinux(Object yes, Object no) throws AraraException {
        return CommonUtils.checkOS("linux") ? yes : no;
    }

    public static Object isMac(Object yes, Object no) throws AraraException {
        return CommonUtils.checkOS("mac") ? yes : no;
    }

    public static Object isUnix(Object yes, Object no) throws AraraException {
        return CommonUtils.checkOS("unix") ? yes : no;
    }

    public static Object isAIX(Object yes, Object no) throws AraraException {
        return CommonUtils.checkOS("aix") ? yes : no;
    }

    public static Object isIrix(Object yes, Object no) throws AraraException {
        return CommonUtils.checkOS("irix") ? yes : no;
    }

    public static Object isOS2(Object yes, Object no) throws AraraException {
        return CommonUtils.checkOS("os2") ? yes : no;
    }

    public static Object isSolaris(Object yes, Object no) throws AraraException {
        return CommonUtils.checkOS("solaris") ? yes : no;
    }

    public static boolean exists(String extension) throws AraraException {
        return CommonUtils.exists(extension);
    }

    public static boolean missing(String extension) throws AraraException {
        return !Methods.exists(extension);
    }

    public static boolean changed(String extension) throws AraraException {
        return CommonUtils.hasChanged(extension);
    }

    public static boolean unchanged(String extension) throws AraraException {
        return !Methods.changed(extension);
    }

    public static boolean exists(File filename) {
        return CommonUtils.exists(filename);
    }

    public static boolean missing(File filename) {
        return !Methods.exists(filename);
    }

    public static boolean changed(File filename) throws AraraException {
        return CommonUtils.hasChanged(filename);
    }

    public static boolean unchanged(File filename) throws AraraException {
        return !Methods.changed(filename);
    }

    public static String buildString(Object ... objects) {
        return CommonUtils.generateString(objects);
    }

    public static String addQuotes(Object object) {
        return CommonUtils.addQuotes(object);
    }

    public static boolean found(String extension, String regex) throws AraraException {
        return CommonUtils.checkRegex(extension, regex);
    }

    public static boolean found(File file, String regex) throws AraraException {
        return CommonUtils.checkRegex(file, regex);
    }

    public static Command getCommand(List<String> elements) {
        return new Command(elements);
    }

    public static Command getCommand(Object ... elements) {
        return new Command(elements);
    }

    public static Command getCommandWithWorkingDirectory(String path, Object ... elements) {
        Command command = new Command(elements);
        command.setWorkingDirectory(new File(path));
        return command;
    }

    public static Command getCommandWithWorkingDirectory(File file, Object ... elements) {
        Command command = new Command(elements);
        command.setWorkingDirectory(file);
        return command;
    }

    public static Command getCommandWithWorkingDirectory(String path, List<String> elements) {
        Command command = new Command(elements);
        command.setWorkingDirectory(new File(path));
        return command;
    }

    public static Command getCommandWithWorkingDirectory(File file, List<String> elements) {
        Command command = new Command(elements);
        command.setWorkingDirectory(file);
        return command;
    }

    public static Trigger getTrigger(String action) {
        return new Trigger(action, null);
    }

    public static Trigger getTrigger(String action, Object ... parameters) {
        return new Trigger(action, Arrays.asList(parameters));
    }

    public static boolean checkClass(Class clazz, Object object) {
        return CommonUtils.checkClass(clazz, object);
    }

    public static boolean isString(Object object) {
        return Methods.checkClass(String.class, object);
    }

    public static boolean isList(Object object) {
        return Methods.checkClass(List.class, object);
    }

    public static boolean isMap(Object object) {
        return Methods.checkClass(Map.class, object);
    }

    public static boolean isBoolean(Object object) {
        return Methods.checkClass(Boolean.class, object);
    }

    public static boolean isVerboseMode() {
        return (Boolean)ConfigurationController.getInstance().get("execution.verbose");
    }

    public static File toFile(String name) {
        return new File(name);
    }

    public static void showMessage(int width, int type, String title, String text) {
        MessageUtils.showMessage(width, type, title, text);
    }

    public static void showMessage(int type, String title, String text) {
        MessageUtils.showMessage(type, title, text);
    }

    public static int showOptions(int width, int type, String title, String text, Object ... buttons) {
        return MessageUtils.showOptions(width, type, title, text, buttons);
    }

    public static int showOptions(int type, String title, String text, Object ... buttons) {
        return MessageUtils.showOptions(type, title, text, buttons);
    }

    public static String showInput(int width, int type, String title, String text) {
        return MessageUtils.showInput(width, type, title, text);
    }

    public static String showInput(int type, String title, String text) {
        return MessageUtils.showInput(type, title, text);
    }

    public static int showDropdown(int width, int type, String title, String text, Object ... elements) {
        return MessageUtils.showDropdown(width, type, title, text, elements);
    }

    public static int showDropdown(int type, String title, String text, Object ... elements) {
        return MessageUtils.showDropdown(type, title, text, elements);
    }

    public static boolean isOnPath(String command) {
        return CommonUtils.isOnPath(command);
    }

    public static String getFullBasename(File file) throws AraraException {
        if (file.isFile()) {
            return CommonUtils.getFullBasename(file);
        }
        throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_BASENAME_NOT_A_FILE, file.getName())));
    }

    public static String getFullBasename(String name) throws AraraException {
        return Methods.getFullBasename(new File(name));
    }

    public static Pair<Integer, String> unsafelyExecuteSystemCommand(Command command) {
        return UnsafeUtils.executeSystemCommand(command);
    }

    public static void mergeVelocityTemplate(File input, File output, Map<String, Object> map) throws AraraException {
        VelocityUtils.mergeVelocityTemplate(input, output, map);
    }

    public static File currentFile() {
        return (File)ConfigurationController.getInstance().get("execution.directive.reference");
    }

    public static Pair<Integer, Class> loadClass(File file, String name) {
        return ClassLoadingUtils.loadClass(file, name);
    }

    public static Pair<Integer, Class> loadClass(String ref, String name) {
        return ClassLoadingUtils.loadClass(new File(ref), name);
    }

    public static Pair<Integer, Object> loadObject(File file, String name) {
        return ClassLoadingUtils.loadObject(file, name);
    }

    public static Pair<Integer, Object> loadObject(String ref, String name) {
        return ClassLoadingUtils.loadObject(new File(ref), name);
    }

    public static List<File> listFilesByExtensions(File directory, List<String> extensions, boolean recursive) {
        return FileSearchingUtils.listFilesByExtensions(directory, extensions, recursive);
    }

    public static List<File> listFilesByExtensions(String path, List<String> extensions, boolean recursive) {
        return FileSearchingUtils.listFilesByExtensions(new File(path), extensions, recursive);
    }

    public static List<File> listFilesByPatterns(File directory, List<String> patterns, boolean recursive) {
        return FileSearchingUtils.listFilesByPatterns(directory, patterns, recursive);
    }

    public static List<File> listFilesByPatterns(String path, List<String> patterns, boolean recursive) {
        return FileSearchingUtils.listFilesByPatterns(new File(path), patterns, recursive);
    }

    public static boolean writeToFile(File file, String text, boolean append) {
        return FileHandlingUtils.writeToFile(file, text, append);
    }

    public static boolean writeToFile(String path, String text, boolean append) {
        return FileHandlingUtils.writeToFile(new File(path), text, append);
    }

    public static boolean writeToFile(File file, List<String> lines, boolean append) {
        return FileHandlingUtils.writeToFile(file, lines, append);
    }

    public static boolean writeToFile(String path, List<String> lines, boolean append) {
        return FileHandlingUtils.writeToFile(new File(path), lines, append);
    }

    public static List<String> readFromFile(File file) {
        return FileHandlingUtils.readFromFile(file);
    }

    public static List<String> readFromFile(String path) {
        return FileHandlingUtils.readFromFile(new File(path));
    }

    public static boolean isSubdirectory(File directory) throws AraraException {
        return CommonUtils.isSubDirectory(directory, Methods.getOriginalReference());
    }
}

