#!/usr/bin/env perl
# Copyright 2008 Tomasz Luczak, Norbert Preining
#
# GUI for tlmgr
#
# This wrapper is a strange thing: If we do
# 	require Tk;
# we get errors when calling Tk::DoOneEvent(Tk::Event::DONT_WAIT):
#   Tk::Error: Usage [$object->]DoOneEvent([flags]) got 'Tk::Event::DONT_WAIT'
# If I do
# 	use Tk;
# it goes away, but we cannot catch errors there.
# Also, doing
# 	BEGIN { require Tk; }
# does work, but has the same problems.
#
# Now, the strange thing is that if I use a wrapper and require the real
# script the error goes away. Dont ask me why ....
#
$^W = 1;
use strict;

BEGIN {
  $^W = 1;
  my $Master = `kpsewhich -var-value=SELFAUTOPARENT`;
  chomp($Master);
  unshift (@INC, "$Master/tlpkg", "$Master/texmf/scripts/texlive/tlmgrgui");
}

eval { require Tk; };
if ($@) {
  # that didn't work out, give some usefull error message and stop
  my $tkmissing = 0;
  if ($@ =~ /^Can\'t locate Tk\.pm/) {
    $tkmissing = 1;
  }
  if ($tkmissing) {
    if ($^O=~/^MSWin(32|64)$/i) {
      # that should not happen, we are shipping Tk!!
      require Win32;
      my $msg = "Cannot load Tk, that should not happen as we ship it!\nHow did you start tlmgrgui??\n(Error message: $@)\n";
      Win32::MsgBox($msg, 1|Win32::MB_ICONSTOP(), "Warning");
    } else {
      printf STDERR "
Cannot load Tk, thus the GUI cannot be started!
The Perl/Tk module is not shipped with the TeX Live installation.
You have to install it to get tlmgr GUI running. See
http://tug.org/texlive/distro.html for more details.

";
    }
  } else {
    printf STDERR "Problem loading Tk: $@\n";
  }
  exit 1;
}

# now check that we can actually create a top level window, 
# on darwin the X server might not be started, or on unix we are working
# on a console, or whatever.
eval { my $foo = Tk::MainWindow->new; $foo->destroy; };
if ($@) {
  printf STDERR "perl/Tk unusable, cannot create main windows.
That could be a consequence of not having X Windows installed or started!
Error message from creating MainWindow:
  $@
";
  exit 1;
}


require("tlmgrgui-real.pl");

# should not be reached ...
#
exit 0;

# vim:set tabstop=2 expandtab: #
