#!/bin/sh
set -e

#DEBHELPER#

case "${1}" in
  configure)
    if [ `uname -r` = "$KVERS" ]; then
      # This is the module package for the running kernel
      # Try to remove old versions of modules here because
      # earlier postrms failed to do so
      # (Our new versions will be auto-loaded if & when necessary)
      modprobe -r thinkpadpm || true
      modprobe -r rtcmosram || true
      modprobe -r superio || true
      modprobe -r smapi || true
      modprobe -r thinkpad || true
      # Update dependency file
      depmod -a || true
    fi
    ;;

  abort-upgrade|abort-remove|abort-deconfigure)
    ;;

  *)
    echo "postinst called with unknown argument \`$1'" >&2
    ;;
esac
