#!/bin/sh
set -e

#DEBHELPER#

case "${1}" in
  remove)
    if [ `uname -r` = "$KVERS" ]; then
      # This was the module package for the running kernel
      # Try to unload the driver modules.
      modprobe -r thinkpadpm || true
      modprobe -r rtcmosram || true
      modprobe -r superio || true
      modprobe -r smapi || true
      modprobe -r thinkpad || true
      # Update dependency file
      depmod -a || true
    fi
    ;;

  upgrade)
    if [ `uname -r` = "$KVERS" ]; then
      # This was the module package for the running kernel
      # Try to unload the driver modules.
      modprobe -r thinkpadpm || true
      modprobe -r rtcmosram || true
      modprobe -r superio || true
      modprobe -r smapi || true
      modprobe -r thinkpad || true
      # Don't update dependency file -- new postinst will do it.
    fi
    ;;

  purge)
    ;;

  failed-upgrade|abort-install|abort-upgrade|disappear)
    ;;
  *)
    echo "postrm called with unknown argument \`$1'" >&2
    ;;
esac

