/* automatically generated by rust-bindgen */

pub use self::root::*;
pub use self::root::mozilla::*;
pub use self::root::mozilla::css::*;
pub use self::root::mozilla::dom::*;
use atomic_refcell::AtomicRefCell;
use data::ElementData;
pub type ServoUnsafeCell<T> = ::std::cell::UnsafeCell<T>;
pub type ServoCell<T> = ::std::cell::Cell<T>;
pub type ServoNodeData = AtomicRefCell<ElementData>;
pub type ServoWritingMode = ::logical_geometry::WritingMode;
pub type ServoCustomPropertiesMap =
    Option<::servo_arc::Arc<::custom_properties::CustomPropertiesMap>>;
pub type ServoRuleNode = Option<::rule_tree::StrongRuleNode>;
pub type ServoVisitedStyle = Option<::servo_arc::RawOffsetArc<::properties::ComputedValues>>;
pub type ServoComputedValueFlags = ::properties::computed_value_flags::ComputedValueFlags;
pub type ServoRawOffsetArc<T> = ::servo_arc::RawOffsetArc<T>;
pub type ServoStyleContextStrong =
    ::gecko_bindings::sugar::ownership::Strong<::properties::ComputedValues>;

#[allow(non_snake_case, non_camel_case_types, non_upper_case_globals)]
pub mod root {
    #[repr(C)]
    #[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
    pub struct __BindgenBitfieldUnit<Storage, Align>
    where
        Storage: AsRef<[u8]> + AsMut<[u8]>,
    {
        storage: Storage,
        align: [Align; 0],
    }

    impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align>
    where
        Storage: AsRef<[u8]> + AsMut<[u8]>,
    {
        #[inline]
        pub fn new(storage: Storage) -> Self {
            Self { storage, align: [] }
        }

        #[inline]
        pub fn get_bit(&self, index: usize) -> bool {
            debug_assert!(index / 8 < self.storage.as_ref().len());

            let byte_index = index / 8;
            let byte = self.storage.as_ref()[byte_index];

            let bit_index = index % 8;
            let mask = 1 << bit_index;

            byte & mask == mask
        }

        #[inline]
        pub fn set_bit(&mut self, index: usize, val: bool) {
            debug_assert!(index / 8 < self.storage.as_ref().len());

            let byte_index = index / 8;
            let byte = &mut self.storage.as_mut()[byte_index];

            let bit_index = index % 8;
            let mask = 1 << bit_index;

            if val {
                *byte |= mask;
            } else {
                *byte &= !mask;
            }
        }

        #[inline]
        pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
            debug_assert!(bit_width <= 64);
            debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
            debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());

            let mut val = 0;

            for i in 0..(bit_width as usize) {
                if self.get_bit(i + bit_offset) {
                    val |= 1 << i;
                }
            }

            val
        }

        #[inline]
        pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
            debug_assert!(bit_width <= 64);
            debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
            debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());

            for i in 0..(bit_width as usize) {
                let mask = 1 << i;
                let val_bit_is_set = val & mask == mask;
                self.set_bit(i + bit_offset, val_bit_is_set);
            }
        }
    }
    #[repr(C)]
    pub struct __BindgenUnionField<T>(::std::marker::PhantomData<T>);
    impl<T> __BindgenUnionField<T> {
        #[inline]
        pub fn new() -> Self {
            __BindgenUnionField(::std::marker::PhantomData)
        }
        #[inline]
        pub unsafe fn as_ref(&self) -> &T {
            ::std::mem::transmute(self)
        }
        #[inline]
        pub unsafe fn as_mut(&mut self) -> &mut T {
            ::std::mem::transmute(self)
        }
    }
    impl<T> ::std::default::Default for __BindgenUnionField<T> {
        #[inline]
        fn default() -> Self {
            Self::new()
        }
    }
    impl<T> ::std::clone::Clone for __BindgenUnionField<T> {
        #[inline]
        fn clone(&self) -> Self {
            Self::new()
        }
    }
    impl<T> ::std::marker::Copy for __BindgenUnionField<T> {}
    impl<T> ::std::fmt::Debug for __BindgenUnionField<T> {
        fn fmt(&self, fmt: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
            fmt.write_str("__BindgenUnionField")
        }
    }
    impl<T> ::std::hash::Hash for __BindgenUnionField<T> {
        fn hash<H: ::std::hash::Hasher>(&self, _state: &mut H) {}
    }
    impl<T> ::std::cmp::PartialEq for __BindgenUnionField<T> {
        fn eq(&self, _other: &__BindgenUnionField<T>) -> bool {
            true
        }
    }
    impl<T> ::std::cmp::Eq for __BindgenUnionField<T> {}
    #[allow(unused_imports)]
    use self::super::root;
    pub const NS_FONT_STYLE_NORMAL: u32 = 0;
    pub const NS_FONT_STYLE_ITALIC: u32 = 1;
    pub const NS_FONT_STYLE_OBLIQUE: u32 = 2;
    pub const NS_FONT_WEIGHT_NORMAL: u32 = 400;
    pub const NS_FONT_WEIGHT_BOLD: u32 = 700;
    pub const NS_FONT_WEIGHT_THIN: u32 = 100;
    pub const NS_FONT_STRETCH_ULTRA_CONDENSED: i32 = -4;
    pub const NS_FONT_STRETCH_EXTRA_CONDENSED: i32 = -3;
    pub const NS_FONT_STRETCH_CONDENSED: i32 = -2;
    pub const NS_FONT_STRETCH_SEMI_CONDENSED: i32 = -1;
    pub const NS_FONT_STRETCH_NORMAL: u32 = 0;
    pub const NS_FONT_STRETCH_SEMI_EXPANDED: u32 = 1;
    pub const NS_FONT_STRETCH_EXPANDED: u32 = 2;
    pub const NS_FONT_STRETCH_EXTRA_EXPANDED: u32 = 3;
    pub const NS_FONT_STRETCH_ULTRA_EXPANDED: u32 = 4;
    pub const NS_FONT_SMOOTHING_AUTO: u32 = 0;
    pub const NS_FONT_SMOOTHING_GRAYSCALE: u32 = 1;
    pub const NS_FONT_KERNING_AUTO: u32 = 0;
    pub const NS_FONT_KERNING_NONE: u32 = 1;
    pub const NS_FONT_KERNING_NORMAL: u32 = 2;
    pub const NS_FONT_SYNTHESIS_WEIGHT: u32 = 1;
    pub const NS_FONT_SYNTHESIS_STYLE: u32 = 2;
    pub const NS_FONT_DISPLAY_AUTO: u32 = 0;
    pub const NS_FONT_DISPLAY_BLOCK: u32 = 1;
    pub const NS_FONT_DISPLAY_SWAP: u32 = 2;
    pub const NS_FONT_DISPLAY_FALLBACK: u32 = 3;
    pub const NS_FONT_DISPLAY_OPTIONAL: u32 = 4;
    pub const NS_FONT_OPTICAL_SIZING_AUTO: u32 = 0;
    pub const NS_FONT_OPTICAL_SIZING_NONE: u32 = 1;
    pub const NS_FONT_VARIANT_ALTERNATES_NORMAL: u32 = 0;
    pub const NS_FONT_VARIANT_ALTERNATES_HISTORICAL: u32 = 1;
    pub const NS_FONT_VARIANT_ALTERNATES_STYLISTIC: u32 = 2;
    pub const NS_FONT_VARIANT_ALTERNATES_STYLESET: u32 = 4;
    pub const NS_FONT_VARIANT_ALTERNATES_CHARACTER_VARIANT: u32 = 8;
    pub const NS_FONT_VARIANT_ALTERNATES_SWASH: u32 = 16;
    pub const NS_FONT_VARIANT_ALTERNATES_ORNAMENTS: u32 = 32;
    pub const NS_FONT_VARIANT_ALTERNATES_ANNOTATION: u32 = 64;
    pub const NS_FONT_VARIANT_ALTERNATES_COUNT: u32 = 7;
    pub const NS_FONT_VARIANT_ALTERNATES_ENUMERATED_MASK: u32 = 1;
    pub const NS_FONT_VARIANT_ALTERNATES_FUNCTIONAL_MASK: u32 = 126;
    pub const NS_FONT_VARIANT_CAPS_NORMAL: u32 = 0;
    pub const NS_FONT_VARIANT_CAPS_SMALLCAPS: u32 = 1;
    pub const NS_FONT_VARIANT_CAPS_ALLSMALL: u32 = 2;
    pub const NS_FONT_VARIANT_CAPS_PETITECAPS: u32 = 3;
    pub const NS_FONT_VARIANT_CAPS_ALLPETITE: u32 = 4;
    pub const NS_FONT_VARIANT_CAPS_TITLING: u32 = 5;
    pub const NS_FONT_VARIANT_CAPS_UNICASE: u32 = 6;
    pub const NS_FONT_VARIANT_EAST_ASIAN_NORMAL: u32 = 0;
    pub const NS_FONT_VARIANT_EAST_ASIAN_JIS78: u32 = 1;
    pub const NS_FONT_VARIANT_EAST_ASIAN_JIS83: u32 = 2;
    pub const NS_FONT_VARIANT_EAST_ASIAN_JIS90: u32 = 4;
    pub const NS_FONT_VARIANT_EAST_ASIAN_JIS04: u32 = 8;
    pub const NS_FONT_VARIANT_EAST_ASIAN_SIMPLIFIED: u32 = 16;
    pub const NS_FONT_VARIANT_EAST_ASIAN_TRADITIONAL: u32 = 32;
    pub const NS_FONT_VARIANT_EAST_ASIAN_FULL_WIDTH: u32 = 64;
    pub const NS_FONT_VARIANT_EAST_ASIAN_PROP_WIDTH: u32 = 128;
    pub const NS_FONT_VARIANT_EAST_ASIAN_RUBY: u32 = 256;
    pub const NS_FONT_VARIANT_EAST_ASIAN_COUNT: u32 = 9;
    pub const NS_FONT_VARIANT_EAST_ASIAN_VARIANT_MASK: u32 = 63;
    pub const NS_FONT_VARIANT_EAST_ASIAN_WIDTH_MASK: u32 = 192;
    pub const NS_FONT_VARIANT_LIGATURES_NORMAL: u32 = 0;
    pub const NS_FONT_VARIANT_LIGATURES_NONE: u32 = 1;
    pub const NS_FONT_VARIANT_LIGATURES_COMMON: u32 = 2;
    pub const NS_FONT_VARIANT_LIGATURES_NO_COMMON: u32 = 4;
    pub const NS_FONT_VARIANT_LIGATURES_DISCRETIONARY: u32 = 8;
    pub const NS_FONT_VARIANT_LIGATURES_NO_DISCRETIONARY: u32 = 16;
    pub const NS_FONT_VARIANT_LIGATURES_HISTORICAL: u32 = 32;
    pub const NS_FONT_VARIANT_LIGATURES_NO_HISTORICAL: u32 = 64;
    pub const NS_FONT_VARIANT_LIGATURES_CONTEXTUAL: u32 = 128;
    pub const NS_FONT_VARIANT_LIGATURES_NO_CONTEXTUAL: u32 = 256;
    pub const NS_FONT_VARIANT_LIGATURES_COUNT: u32 = 9;
    pub const NS_FONT_VARIANT_LIGATURES_COMMON_MASK: u32 = 6;
    pub const NS_FONT_VARIANT_LIGATURES_DISCRETIONARY_MASK: u32 = 24;
    pub const NS_FONT_VARIANT_LIGATURES_HISTORICAL_MASK: u32 = 96;
    pub const NS_FONT_VARIANT_LIGATURES_CONTEXTUAL_MASK: u32 = 384;
    pub const NS_FONT_VARIANT_NUMERIC_NORMAL: u32 = 0;
    pub const NS_FONT_VARIANT_NUMERIC_LINING: u32 = 1;
    pub const NS_FONT_VARIANT_NUMERIC_OLDSTYLE: u32 = 2;
    pub const NS_FONT_VARIANT_NUMERIC_PROPORTIONAL: u32 = 4;
    pub const NS_FONT_VARIANT_NUMERIC_TABULAR: u32 = 8;
    pub const NS_FONT_VARIANT_NUMERIC_DIAGONAL_FRACTIONS: u32 = 16;
    pub const NS_FONT_VARIANT_NUMERIC_STACKED_FRACTIONS: u32 = 32;
    pub const NS_FONT_VARIANT_NUMERIC_SLASHZERO: u32 = 64;
    pub const NS_FONT_VARIANT_NUMERIC_ORDINAL: u32 = 128;
    pub const NS_FONT_VARIANT_NUMERIC_COUNT: u32 = 8;
    pub const NS_FONT_VARIANT_NUMERIC_FIGURE_MASK: u32 = 3;
    pub const NS_FONT_VARIANT_NUMERIC_SPACING_MASK: u32 = 12;
    pub const NS_FONT_VARIANT_NUMERIC_FRACTION_MASK: u32 = 48;
    pub const NS_FONT_VARIANT_POSITION_NORMAL: u32 = 0;
    pub const NS_FONT_VARIANT_POSITION_SUPER: u32 = 1;
    pub const NS_FONT_VARIANT_POSITION_SUB: u32 = 2;
    pub const NS_FONT_VARIANT_WIDTH_NORMAL: u32 = 0;
    pub const NS_FONT_VARIANT_WIDTH_FULL: u32 = 1;
    pub const NS_FONT_VARIANT_WIDTH_HALF: u32 = 2;
    pub const NS_FONT_VARIANT_WIDTH_THIRD: u32 = 3;
    pub const NS_FONT_VARIANT_WIDTH_QUARTER: u32 = 4;
    pub const NS_FONT_SUBSCRIPT_OFFSET_RATIO: f64 = 0.2;
    pub const NS_FONT_SUPERSCRIPT_OFFSET_RATIO: f64 = 0.34;
    pub const NS_FONT_SUB_SUPER_SIZE_RATIO_SMALL: f64 = 0.82;
    pub const NS_FONT_SUB_SUPER_SIZE_RATIO_LARGE: f64 = 0.667;
    pub const NS_FONT_SUB_SUPER_SMALL_SIZE: f64 = 20.;
    pub const NS_FONT_SUB_SUPER_LARGE_SIZE: f64 = 45.;
    pub const NS_FONT_VARIANT_NORMAL: u32 = 0;
    pub const NS_FONT_VARIANT_SMALL_CAPS: u32 = 1;
    pub const NS_STYLE_COLOR_INHERIT_FROM_BODY: u32 = 2;
    pub const NS_STYLE_WILL_CHANGE_STACKING_CONTEXT: u32 = 1;
    pub const NS_STYLE_WILL_CHANGE_TRANSFORM: u32 = 2;
    pub const NS_STYLE_WILL_CHANGE_SCROLL: u32 = 4;
    pub const NS_STYLE_WILL_CHANGE_OPACITY: u32 = 8;
    pub const NS_STYLE_WILL_CHANGE_FIXPOS_CB: u32 = 16;
    pub const NS_STYLE_WILL_CHANGE_ABSPOS_CB: u32 = 32;
    pub const NS_STYLE_ANIMATION_ITERATION_COUNT_INFINITE: u32 = 0;
    pub const NS_STYLE_ANIMATION_PLAY_STATE_RUNNING: u32 = 0;
    pub const NS_STYLE_ANIMATION_PLAY_STATE_PAUSED: u32 = 1;
    pub const NS_STYLE_IMAGELAYER_ATTACHMENT_SCROLL: u32 = 0;
    pub const NS_STYLE_IMAGELAYER_ATTACHMENT_FIXED: u32 = 1;
    pub const NS_STYLE_IMAGELAYER_ATTACHMENT_LOCAL: u32 = 2;
    pub const NS_STYLE_IMAGELAYER_CLIP_MOZ_ALMOST_PADDING: u32 = 127;
    pub const NS_STYLE_IMAGELAYER_POSITION_CENTER: u32 = 1;
    pub const NS_STYLE_IMAGELAYER_POSITION_TOP: u32 = 2;
    pub const NS_STYLE_IMAGELAYER_POSITION_BOTTOM: u32 = 4;
    pub const NS_STYLE_IMAGELAYER_POSITION_LEFT: u32 = 8;
    pub const NS_STYLE_IMAGELAYER_POSITION_RIGHT: u32 = 16;
    pub const NS_STYLE_IMAGELAYER_SIZE_CONTAIN: u32 = 0;
    pub const NS_STYLE_IMAGELAYER_SIZE_COVER: u32 = 1;
    pub const NS_STYLE_MASK_MODE_ALPHA: u32 = 0;
    pub const NS_STYLE_MASK_MODE_LUMINANCE: u32 = 1;
    pub const NS_STYLE_MASK_MODE_MATCH_SOURCE: u32 = 2;
    pub const NS_STYLE_BG_INLINE_POLICY_EACH_BOX: u32 = 0;
    pub const NS_STYLE_BG_INLINE_POLICY_CONTINUOUS: u32 = 1;
    pub const NS_STYLE_BG_INLINE_POLICY_BOUNDING_BOX: u32 = 2;
    pub const NS_STYLE_BORDER_COLLAPSE: u32 = 0;
    pub const NS_STYLE_BORDER_SEPARATE: u32 = 1;
    pub const NS_STYLE_BORDER_WIDTH_THIN: u32 = 0;
    pub const NS_STYLE_BORDER_WIDTH_MEDIUM: u32 = 1;
    pub const NS_STYLE_BORDER_WIDTH_THICK: u32 = 2;
    pub const NS_STYLE_BORDER_STYLE_NONE: u32 = 0;
    pub const NS_STYLE_BORDER_STYLE_GROOVE: u32 = 1;
    pub const NS_STYLE_BORDER_STYLE_RIDGE: u32 = 2;
    pub const NS_STYLE_BORDER_STYLE_DOTTED: u32 = 3;
    pub const NS_STYLE_BORDER_STYLE_DASHED: u32 = 4;
    pub const NS_STYLE_BORDER_STYLE_SOLID: u32 = 5;
    pub const NS_STYLE_BORDER_STYLE_DOUBLE: u32 = 6;
    pub const NS_STYLE_BORDER_STYLE_INSET: u32 = 7;
    pub const NS_STYLE_BORDER_STYLE_OUTSET: u32 = 8;
    pub const NS_STYLE_BORDER_STYLE_HIDDEN: u32 = 9;
    pub const NS_STYLE_BORDER_STYLE_AUTO: u32 = 10;
    pub const NS_STYLE_BORDER_IMAGE_SLICE_NOFILL: u32 = 0;
    pub const NS_STYLE_BORDER_IMAGE_SLICE_FILL: u32 = 1;
    pub const NS_STYLE_CURSOR_AUTO: u32 = 1;
    pub const NS_STYLE_CURSOR_CROSSHAIR: u32 = 2;
    pub const NS_STYLE_CURSOR_DEFAULT: u32 = 3;
    pub const NS_STYLE_CURSOR_POINTER: u32 = 4;
    pub const NS_STYLE_CURSOR_MOVE: u32 = 5;
    pub const NS_STYLE_CURSOR_E_RESIZE: u32 = 6;
    pub const NS_STYLE_CURSOR_NE_RESIZE: u32 = 7;
    pub const NS_STYLE_CURSOR_NW_RESIZE: u32 = 8;
    pub const NS_STYLE_CURSOR_N_RESIZE: u32 = 9;
    pub const NS_STYLE_CURSOR_SE_RESIZE: u32 = 10;
    pub const NS_STYLE_CURSOR_SW_RESIZE: u32 = 11;
    pub const NS_STYLE_CURSOR_S_RESIZE: u32 = 12;
    pub const NS_STYLE_CURSOR_W_RESIZE: u32 = 13;
    pub const NS_STYLE_CURSOR_TEXT: u32 = 14;
    pub const NS_STYLE_CURSOR_WAIT: u32 = 15;
    pub const NS_STYLE_CURSOR_HELP: u32 = 16;
    pub const NS_STYLE_CURSOR_COPY: u32 = 17;
    pub const NS_STYLE_CURSOR_ALIAS: u32 = 18;
    pub const NS_STYLE_CURSOR_CONTEXT_MENU: u32 = 19;
    pub const NS_STYLE_CURSOR_CELL: u32 = 20;
    pub const NS_STYLE_CURSOR_GRAB: u32 = 21;
    pub const NS_STYLE_CURSOR_GRABBING: u32 = 22;
    pub const NS_STYLE_CURSOR_SPINNING: u32 = 23;
    pub const NS_STYLE_CURSOR_ZOOM_IN: u32 = 24;
    pub const NS_STYLE_CURSOR_ZOOM_OUT: u32 = 25;
    pub const NS_STYLE_CURSOR_NOT_ALLOWED: u32 = 26;
    pub const NS_STYLE_CURSOR_COL_RESIZE: u32 = 27;
    pub const NS_STYLE_CURSOR_ROW_RESIZE: u32 = 28;
    pub const NS_STYLE_CURSOR_NO_DROP: u32 = 29;
    pub const NS_STYLE_CURSOR_VERTICAL_TEXT: u32 = 30;
    pub const NS_STYLE_CURSOR_ALL_SCROLL: u32 = 31;
    pub const NS_STYLE_CURSOR_NESW_RESIZE: u32 = 32;
    pub const NS_STYLE_CURSOR_NWSE_RESIZE: u32 = 33;
    pub const NS_STYLE_CURSOR_NS_RESIZE: u32 = 34;
    pub const NS_STYLE_CURSOR_EW_RESIZE: u32 = 35;
    pub const NS_STYLE_CURSOR_NONE: u32 = 36;
    pub const NS_STYLE_DIRECTION_LTR: u32 = 0;
    pub const NS_STYLE_DIRECTION_RTL: u32 = 1;
    pub const NS_STYLE_WRITING_MODE_HORIZONTAL_TB: u32 = 0;
    pub const NS_STYLE_WRITING_MODE_VERTICAL_RL: u32 = 1;
    pub const NS_STYLE_WRITING_MODE_VERTICAL_LR: u32 = 3;
    pub const NS_STYLE_WRITING_MODE_SIDEWAYS_MASK: u32 = 4;
    pub const NS_STYLE_WRITING_MODE_SIDEWAYS_RL: u32 = 5;
    pub const NS_STYLE_WRITING_MODE_SIDEWAYS_LR: u32 = 7;
    pub const NS_STYLE_CONTAIN_NONE: u32 = 0;
    pub const NS_STYLE_CONTAIN_STRICT: u32 = 1;
    pub const NS_STYLE_CONTAIN_LAYOUT: u32 = 2;
    pub const NS_STYLE_CONTAIN_STYLE: u32 = 4;
    pub const NS_STYLE_CONTAIN_PAINT: u32 = 8;
    pub const NS_STYLE_CONTAIN_ALL_BITS: u32 = 14;
    pub const NS_STYLE_ALIGN_AUTO: u32 = 0;
    pub const NS_STYLE_ALIGN_NORMAL: u32 = 1;
    pub const NS_STYLE_ALIGN_START: u32 = 2;
    pub const NS_STYLE_ALIGN_END: u32 = 3;
    pub const NS_STYLE_ALIGN_FLEX_START: u32 = 4;
    pub const NS_STYLE_ALIGN_FLEX_END: u32 = 5;
    pub const NS_STYLE_ALIGN_CENTER: u32 = 6;
    pub const NS_STYLE_ALIGN_LEFT: u32 = 7;
    pub const NS_STYLE_ALIGN_RIGHT: u32 = 8;
    pub const NS_STYLE_ALIGN_BASELINE: u32 = 9;
    pub const NS_STYLE_ALIGN_LAST_BASELINE: u32 = 10;
    pub const NS_STYLE_ALIGN_STRETCH: u32 = 11;
    pub const NS_STYLE_ALIGN_SELF_START: u32 = 12;
    pub const NS_STYLE_ALIGN_SELF_END: u32 = 13;
    pub const NS_STYLE_ALIGN_SPACE_BETWEEN: u32 = 14;
    pub const NS_STYLE_ALIGN_SPACE_AROUND: u32 = 15;
    pub const NS_STYLE_ALIGN_SPACE_EVENLY: u32 = 16;
    pub const NS_STYLE_ALIGN_LEGACY: u32 = 32;
    pub const NS_STYLE_ALIGN_SAFE: u32 = 64;
    pub const NS_STYLE_ALIGN_UNSAFE: u32 = 128;
    pub const NS_STYLE_ALIGN_FLAG_BITS: u32 = 224;
    pub const NS_STYLE_ALIGN_ALL_BITS: u32 = 255;
    pub const NS_STYLE_ALIGN_ALL_SHIFT: u32 = 8;
    pub const NS_STYLE_JUSTIFY_AUTO: u32 = 0;
    pub const NS_STYLE_JUSTIFY_NORMAL: u32 = 1;
    pub const NS_STYLE_JUSTIFY_START: u32 = 2;
    pub const NS_STYLE_JUSTIFY_END: u32 = 3;
    pub const NS_STYLE_JUSTIFY_FLEX_START: u32 = 4;
    pub const NS_STYLE_JUSTIFY_FLEX_END: u32 = 5;
    pub const NS_STYLE_JUSTIFY_CENTER: u32 = 6;
    pub const NS_STYLE_JUSTIFY_LEFT: u32 = 7;
    pub const NS_STYLE_JUSTIFY_RIGHT: u32 = 8;
    pub const NS_STYLE_JUSTIFY_BASELINE: u32 = 9;
    pub const NS_STYLE_JUSTIFY_LAST_BASELINE: u32 = 10;
    pub const NS_STYLE_JUSTIFY_STRETCH: u32 = 11;
    pub const NS_STYLE_JUSTIFY_SELF_START: u32 = 12;
    pub const NS_STYLE_JUSTIFY_SELF_END: u32 = 13;
    pub const NS_STYLE_JUSTIFY_SPACE_BETWEEN: u32 = 14;
    pub const NS_STYLE_JUSTIFY_SPACE_AROUND: u32 = 15;
    pub const NS_STYLE_JUSTIFY_SPACE_EVENLY: u32 = 16;
    pub const NS_STYLE_JUSTIFY_LEGACY: u32 = 32;
    pub const NS_STYLE_JUSTIFY_SAFE: u32 = 64;
    pub const NS_STYLE_JUSTIFY_UNSAFE: u32 = 128;
    pub const NS_STYLE_JUSTIFY_FLAG_BITS: u32 = 224;
    pub const NS_STYLE_JUSTIFY_ALL_BITS: u32 = 255;
    pub const NS_STYLE_JUSTIFY_ALL_SHIFT: u32 = 8;
    pub const NS_STYLE_FLEX_DIRECTION_ROW: u32 = 0;
    pub const NS_STYLE_FLEX_DIRECTION_ROW_REVERSE: u32 = 1;
    pub const NS_STYLE_FLEX_DIRECTION_COLUMN: u32 = 2;
    pub const NS_STYLE_FLEX_DIRECTION_COLUMN_REVERSE: u32 = 3;
    pub const NS_STYLE_FLEX_WRAP_NOWRAP: u32 = 0;
    pub const NS_STYLE_FLEX_WRAP_WRAP: u32 = 1;
    pub const NS_STYLE_FLEX_WRAP_WRAP_REVERSE: u32 = 2;
    pub const NS_STYLE_ORDER_INITIAL: u32 = 0;
    pub const NS_STYLE_JUSTIFY_CONTENT_FLEX_START: u32 = 4;
    pub const NS_STYLE_JUSTIFY_CONTENT_FLEX_END: u32 = 5;
    pub const NS_STYLE_JUSTIFY_CONTENT_CENTER: u32 = 6;
    pub const NS_STYLE_JUSTIFY_CONTENT_SPACE_BETWEEN: u32 = 14;
    pub const NS_STYLE_JUSTIFY_CONTENT_SPACE_AROUND: u32 = 15;
    pub const NS_STYLE_FILTER_NONE: u32 = 0;
    pub const NS_STYLE_FILTER_URL: u32 = 1;
    pub const NS_STYLE_FILTER_BLUR: u32 = 2;
    pub const NS_STYLE_FILTER_BRIGHTNESS: u32 = 3;
    pub const NS_STYLE_FILTER_CONTRAST: u32 = 4;
    pub const NS_STYLE_FILTER_GRAYSCALE: u32 = 5;
    pub const NS_STYLE_FILTER_INVERT: u32 = 6;
    pub const NS_STYLE_FILTER_OPACITY: u32 = 7;
    pub const NS_STYLE_FILTER_SATURATE: u32 = 8;
    pub const NS_STYLE_FILTER_SEPIA: u32 = 9;
    pub const NS_STYLE_FILTER_HUE_ROTATE: u32 = 10;
    pub const NS_STYLE_FILTER_DROP_SHADOW: u32 = 11;
    pub const NS_STYLE_FONT_STYLE_NORMAL: u32 = 0;
    pub const NS_STYLE_FONT_STYLE_ITALIC: u32 = 1;
    pub const NS_STYLE_FONT_STYLE_OBLIQUE: u32 = 2;
    pub const NS_STYLE_FONT_WEIGHT_NORMAL: u32 = 400;
    pub const NS_STYLE_FONT_WEIGHT_BOLD: u32 = 700;
    pub const NS_STYLE_FONT_WEIGHT_BOLDER: i32 = -1;
    pub const NS_STYLE_FONT_WEIGHT_LIGHTER: i32 = -2;
    pub const NS_STYLE_FONT_SIZE_XXSMALL: u32 = 0;
    pub const NS_STYLE_FONT_SIZE_XSMALL: u32 = 1;
    pub const NS_STYLE_FONT_SIZE_SMALL: u32 = 2;
    pub const NS_STYLE_FONT_SIZE_MEDIUM: u32 = 3;
    pub const NS_STYLE_FONT_SIZE_LARGE: u32 = 4;
    pub const NS_STYLE_FONT_SIZE_XLARGE: u32 = 5;
    pub const NS_STYLE_FONT_SIZE_XXLARGE: u32 = 6;
    pub const NS_STYLE_FONT_SIZE_XXXLARGE: u32 = 7;
    pub const NS_STYLE_FONT_SIZE_LARGER: u32 = 8;
    pub const NS_STYLE_FONT_SIZE_SMALLER: u32 = 9;
    pub const NS_STYLE_FONT_SIZE_NO_KEYWORD: u32 = 10;
    pub const NS_STYLE_FONT_STRETCH_ULTRA_CONDENSED: i32 = -4;
    pub const NS_STYLE_FONT_STRETCH_EXTRA_CONDENSED: i32 = -3;
    pub const NS_STYLE_FONT_STRETCH_CONDENSED: i32 = -2;
    pub const NS_STYLE_FONT_STRETCH_SEMI_CONDENSED: i32 = -1;
    pub const NS_STYLE_FONT_STRETCH_NORMAL: u32 = 0;
    pub const NS_STYLE_FONT_STRETCH_SEMI_EXPANDED: u32 = 1;
    pub const NS_STYLE_FONT_STRETCH_EXPANDED: u32 = 2;
    pub const NS_STYLE_FONT_STRETCH_EXTRA_EXPANDED: u32 = 3;
    pub const NS_STYLE_FONT_STRETCH_ULTRA_EXPANDED: u32 = 4;
    pub const NS_STYLE_FONT_CAPTION: u32 = 1;
    pub const NS_STYLE_FONT_ICON: u32 = 2;
    pub const NS_STYLE_FONT_MENU: u32 = 3;
    pub const NS_STYLE_FONT_MESSAGE_BOX: u32 = 4;
    pub const NS_STYLE_FONT_SMALL_CAPTION: u32 = 5;
    pub const NS_STYLE_FONT_STATUS_BAR: u32 = 6;
    pub const NS_STYLE_FONT_WINDOW: u32 = 7;
    pub const NS_STYLE_FONT_DOCUMENT: u32 = 8;
    pub const NS_STYLE_FONT_WORKSPACE: u32 = 9;
    pub const NS_STYLE_FONT_DESKTOP: u32 = 10;
    pub const NS_STYLE_FONT_INFO: u32 = 11;
    pub const NS_STYLE_FONT_DIALOG: u32 = 12;
    pub const NS_STYLE_FONT_BUTTON: u32 = 13;
    pub const NS_STYLE_FONT_PULL_DOWN_MENU: u32 = 14;
    pub const NS_STYLE_FONT_LIST: u32 = 15;
    pub const NS_STYLE_FONT_FIELD: u32 = 16;
    pub const NS_STYLE_GRID_AUTO_FLOW_ROW: u32 = 1;
    pub const NS_STYLE_GRID_AUTO_FLOW_COLUMN: u32 = 2;
    pub const NS_STYLE_GRID_AUTO_FLOW_DENSE: u32 = 4;
    pub const NS_STYLE_GRID_TEMPLATE_SUBGRID: u32 = 0;
    pub const NS_STYLE_GRID_REPEAT_AUTO_FILL: u32 = 0;
    pub const NS_STYLE_GRID_REPEAT_AUTO_FIT: u32 = 1;
    pub const NS_MATHML_DEFAULT_SCRIPT_SIZE_MULTIPLIER: f64 = 0.71;
    pub const NS_MATHML_DEFAULT_SCRIPT_MIN_SIZE_PT: u32 = 8;
    pub const NS_MATHML_MATHVARIANT_NONE: u32 = 0;
    pub const NS_MATHML_MATHVARIANT_NORMAL: u32 = 1;
    pub const NS_MATHML_MATHVARIANT_BOLD: u32 = 2;
    pub const NS_MATHML_MATHVARIANT_ITALIC: u32 = 3;
    pub const NS_MATHML_MATHVARIANT_BOLD_ITALIC: u32 = 4;
    pub const NS_MATHML_MATHVARIANT_SCRIPT: u32 = 5;
    pub const NS_MATHML_MATHVARIANT_BOLD_SCRIPT: u32 = 6;
    pub const NS_MATHML_MATHVARIANT_FRAKTUR: u32 = 7;
    pub const NS_MATHML_MATHVARIANT_DOUBLE_STRUCK: u32 = 8;
    pub const NS_MATHML_MATHVARIANT_BOLD_FRAKTUR: u32 = 9;
    pub const NS_MATHML_MATHVARIANT_SANS_SERIF: u32 = 10;
    pub const NS_MATHML_MATHVARIANT_BOLD_SANS_SERIF: u32 = 11;
    pub const NS_MATHML_MATHVARIANT_SANS_SERIF_ITALIC: u32 = 12;
    pub const NS_MATHML_MATHVARIANT_SANS_SERIF_BOLD_ITALIC: u32 = 13;
    pub const NS_MATHML_MATHVARIANT_MONOSPACE: u32 = 14;
    pub const NS_MATHML_MATHVARIANT_INITIAL: u32 = 15;
    pub const NS_MATHML_MATHVARIANT_TAILED: u32 = 16;
    pub const NS_MATHML_MATHVARIANT_LOOPED: u32 = 17;
    pub const NS_MATHML_MATHVARIANT_STRETCHED: u32 = 18;
    pub const NS_MATHML_DISPLAYSTYLE_INLINE: u32 = 0;
    pub const NS_MATHML_DISPLAYSTYLE_BLOCK: u32 = 1;
    pub const NS_STYLE_WIDTH_MAX_CONTENT: u32 = 0;
    pub const NS_STYLE_WIDTH_MIN_CONTENT: u32 = 1;
    pub const NS_STYLE_WIDTH_FIT_CONTENT: u32 = 2;
    pub const NS_STYLE_WIDTH_AVAILABLE: u32 = 3;
    pub const NS_STYLE_POSITION_STATIC: u32 = 0;
    pub const NS_STYLE_POSITION_RELATIVE: u32 = 1;
    pub const NS_STYLE_POSITION_ABSOLUTE: u32 = 2;
    pub const NS_STYLE_POSITION_FIXED: u32 = 3;
    pub const NS_STYLE_POSITION_STICKY: u32 = 4;
    pub const NS_STYLE_CLIP_AUTO: u32 = 0;
    pub const NS_STYLE_CLIP_RECT: u32 = 1;
    pub const NS_STYLE_CLIP_TYPE_MASK: u32 = 15;
    pub const NS_STYLE_CLIP_LEFT_AUTO: u32 = 16;
    pub const NS_STYLE_CLIP_TOP_AUTO: u32 = 32;
    pub const NS_STYLE_CLIP_RIGHT_AUTO: u32 = 64;
    pub const NS_STYLE_CLIP_BOTTOM_AUTO: u32 = 128;
    pub const NS_STYLE_FRAME_YES: u32 = 0;
    pub const NS_STYLE_FRAME_NO: u32 = 1;
    pub const NS_STYLE_FRAME_0: u32 = 2;
    pub const NS_STYLE_FRAME_1: u32 = 3;
    pub const NS_STYLE_FRAME_ON: u32 = 4;
    pub const NS_STYLE_FRAME_OFF: u32 = 5;
    pub const NS_STYLE_FRAME_AUTO: u32 = 6;
    pub const NS_STYLE_FRAME_SCROLL: u32 = 7;
    pub const NS_STYLE_FRAME_NOSCROLL: u32 = 8;
    pub const NS_STYLE_OVERFLOW_VISIBLE: u32 = 0;
    pub const NS_STYLE_OVERFLOW_HIDDEN: u32 = 1;
    pub const NS_STYLE_OVERFLOW_SCROLL: u32 = 2;
    pub const NS_STYLE_OVERFLOW_AUTO: u32 = 3;
    pub const NS_STYLE_OVERFLOW_CLIP: u32 = 4;
    pub const NS_STYLE_OVERFLOW_SCROLLBARS_HORIZONTAL: u32 = 5;
    pub const NS_STYLE_OVERFLOW_SCROLLBARS_VERTICAL: u32 = 6;
    pub const NS_STYLE_OVERFLOW_CLIP_BOX_PADDING_BOX: u32 = 0;
    pub const NS_STYLE_OVERFLOW_CLIP_BOX_CONTENT_BOX: u32 = 1;
    pub const NS_STYLE_LIST_STYLE_CUSTOM: i32 = -1;
    pub const NS_STYLE_LIST_STYLE_NONE: u32 = 0;
    pub const NS_STYLE_LIST_STYLE_DECIMAL: u32 = 1;
    pub const NS_STYLE_LIST_STYLE_DISC: u32 = 2;
    pub const NS_STYLE_LIST_STYLE_CIRCLE: u32 = 3;
    pub const NS_STYLE_LIST_STYLE_SQUARE: u32 = 4;
    pub const NS_STYLE_LIST_STYLE_DISCLOSURE_CLOSED: u32 = 5;
    pub const NS_STYLE_LIST_STYLE_DISCLOSURE_OPEN: u32 = 6;
    pub const NS_STYLE_LIST_STYLE_HEBREW: u32 = 7;
    pub const NS_STYLE_LIST_STYLE_JAPANESE_INFORMAL: u32 = 8;
    pub const NS_STYLE_LIST_STYLE_JAPANESE_FORMAL: u32 = 9;
    pub const NS_STYLE_LIST_STYLE_KOREAN_HANGUL_FORMAL: u32 = 10;
    pub const NS_STYLE_LIST_STYLE_KOREAN_HANJA_INFORMAL: u32 = 11;
    pub const NS_STYLE_LIST_STYLE_KOREAN_HANJA_FORMAL: u32 = 12;
    pub const NS_STYLE_LIST_STYLE_SIMP_CHINESE_INFORMAL: u32 = 13;
    pub const NS_STYLE_LIST_STYLE_SIMP_CHINESE_FORMAL: u32 = 14;
    pub const NS_STYLE_LIST_STYLE_TRAD_CHINESE_INFORMAL: u32 = 15;
    pub const NS_STYLE_LIST_STYLE_TRAD_CHINESE_FORMAL: u32 = 16;
    pub const NS_STYLE_LIST_STYLE_ETHIOPIC_NUMERIC: u32 = 17;
    pub const NS_STYLE_LIST_STYLE_LOWER_ROMAN: u32 = 100;
    pub const NS_STYLE_LIST_STYLE_UPPER_ROMAN: u32 = 101;
    pub const NS_STYLE_LIST_STYLE_LOWER_ALPHA: u32 = 102;
    pub const NS_STYLE_LIST_STYLE_UPPER_ALPHA: u32 = 103;
    pub const NS_STYLE_LIST_STYLE_POSITION_INSIDE: u32 = 0;
    pub const NS_STYLE_LIST_STYLE_POSITION_OUTSIDE: u32 = 1;
    pub const NS_STYLE_MARGIN_SIZE_AUTO: u32 = 0;
    pub const NS_STYLE_POINTER_EVENTS_NONE: u32 = 0;
    pub const NS_STYLE_POINTER_EVENTS_VISIBLEPAINTED: u32 = 1;
    pub const NS_STYLE_POINTER_EVENTS_VISIBLEFILL: u32 = 2;
    pub const NS_STYLE_POINTER_EVENTS_VISIBLESTROKE: u32 = 3;
    pub const NS_STYLE_POINTER_EVENTS_VISIBLE: u32 = 4;
    pub const NS_STYLE_POINTER_EVENTS_PAINTED: u32 = 5;
    pub const NS_STYLE_POINTER_EVENTS_FILL: u32 = 6;
    pub const NS_STYLE_POINTER_EVENTS_STROKE: u32 = 7;
    pub const NS_STYLE_POINTER_EVENTS_ALL: u32 = 8;
    pub const NS_STYLE_POINTER_EVENTS_AUTO: u32 = 9;
    pub const NS_STYLE_IMAGE_ORIENTATION_FLIP: u32 = 0;
    pub const NS_STYLE_IMAGE_ORIENTATION_FROM_IMAGE: u32 = 1;
    pub const NS_STYLE_ISOLATION_AUTO: u32 = 0;
    pub const NS_STYLE_ISOLATION_ISOLATE: u32 = 1;
    pub const NS_STYLE_OBJECT_FIT_FILL: u32 = 0;
    pub const NS_STYLE_OBJECT_FIT_CONTAIN: u32 = 1;
    pub const NS_STYLE_OBJECT_FIT_COVER: u32 = 2;
    pub const NS_STYLE_OBJECT_FIT_NONE: u32 = 3;
    pub const NS_STYLE_OBJECT_FIT_SCALE_DOWN: u32 = 4;
    pub const NS_STYLE_RESIZE_NONE: u32 = 0;
    pub const NS_STYLE_RESIZE_BOTH: u32 = 1;
    pub const NS_STYLE_RESIZE_HORIZONTAL: u32 = 2;
    pub const NS_STYLE_RESIZE_VERTICAL: u32 = 3;
    pub const NS_STYLE_TEXT_ALIGN_START: u32 = 0;
    pub const NS_STYLE_TEXT_ALIGN_LEFT: u32 = 1;
    pub const NS_STYLE_TEXT_ALIGN_RIGHT: u32 = 2;
    pub const NS_STYLE_TEXT_ALIGN_CENTER: u32 = 3;
    pub const NS_STYLE_TEXT_ALIGN_JUSTIFY: u32 = 4;
    pub const NS_STYLE_TEXT_ALIGN_CHAR: u32 = 5;
    pub const NS_STYLE_TEXT_ALIGN_END: u32 = 6;
    pub const NS_STYLE_TEXT_ALIGN_AUTO: u32 = 7;
    pub const NS_STYLE_TEXT_ALIGN_MOZ_CENTER: u32 = 8;
    pub const NS_STYLE_TEXT_ALIGN_MOZ_RIGHT: u32 = 9;
    pub const NS_STYLE_TEXT_ALIGN_MOZ_LEFT: u32 = 10;
    pub const NS_STYLE_TEXT_ALIGN_MOZ_CENTER_OR_INHERIT: u32 = 11;
    pub const NS_STYLE_TEXT_ALIGN_UNSAFE: u32 = 12;
    pub const NS_STYLE_TEXT_ALIGN_MATCH_PARENT: u32 = 13;
    pub const NS_STYLE_TEXT_DECORATION_LINE_NONE: u32 = 0;
    pub const NS_STYLE_TEXT_DECORATION_LINE_UNDERLINE: u32 = 1;
    pub const NS_STYLE_TEXT_DECORATION_LINE_OVERLINE: u32 = 2;
    pub const NS_STYLE_TEXT_DECORATION_LINE_LINE_THROUGH: u32 = 4;
    pub const NS_STYLE_TEXT_DECORATION_LINE_BLINK: u32 = 8;
    pub const NS_STYLE_TEXT_DECORATION_LINE_OVERRIDE_ALL: u32 = 16;
    pub const NS_STYLE_TEXT_DECORATION_LINE_LINES_MASK: u32 = 7;
    pub const NS_STYLE_TEXT_DECORATION_STYLE_NONE: u32 = 0;
    pub const NS_STYLE_TEXT_DECORATION_STYLE_DOTTED: u32 = 1;
    pub const NS_STYLE_TEXT_DECORATION_STYLE_DASHED: u32 = 2;
    pub const NS_STYLE_TEXT_DECORATION_STYLE_SOLID: u32 = 3;
    pub const NS_STYLE_TEXT_DECORATION_STYLE_DOUBLE: u32 = 4;
    pub const NS_STYLE_TEXT_DECORATION_STYLE_WAVY: u32 = 5;
    pub const NS_STYLE_TEXT_DECORATION_STYLE_MAX: u32 = 5;
    pub const NS_STYLE_TEXT_OVERFLOW_CLIP: u32 = 0;
    pub const NS_STYLE_TEXT_OVERFLOW_ELLIPSIS: u32 = 1;
    pub const NS_STYLE_TEXT_OVERFLOW_STRING: u32 = 2;
    pub const NS_STYLE_TEXT_TRANSFORM_NONE: u32 = 0;
    pub const NS_STYLE_TEXT_TRANSFORM_CAPITALIZE: u32 = 1;
    pub const NS_STYLE_TEXT_TRANSFORM_LOWERCASE: u32 = 2;
    pub const NS_STYLE_TEXT_TRANSFORM_UPPERCASE: u32 = 3;
    pub const NS_STYLE_TEXT_TRANSFORM_FULL_WIDTH: u32 = 4;
    pub const NS_STYLE_TOUCH_ACTION_NONE: u32 = 1;
    pub const NS_STYLE_TOUCH_ACTION_AUTO: u32 = 2;
    pub const NS_STYLE_TOUCH_ACTION_PAN_X: u32 = 4;
    pub const NS_STYLE_TOUCH_ACTION_PAN_Y: u32 = 8;
    pub const NS_STYLE_TOUCH_ACTION_MANIPULATION: u32 = 16;
    pub const NS_STYLE_TOP_LAYER_NONE: u32 = 0;
    pub const NS_STYLE_TOP_LAYER_TOP: u32 = 1;
    pub const NS_STYLE_TRANSITION_TIMING_FUNCTION_EASE: u32 = 0;
    pub const NS_STYLE_TRANSITION_TIMING_FUNCTION_LINEAR: u32 = 1;
    pub const NS_STYLE_TRANSITION_TIMING_FUNCTION_EASE_IN: u32 = 2;
    pub const NS_STYLE_TRANSITION_TIMING_FUNCTION_EASE_OUT: u32 = 3;
    pub const NS_STYLE_TRANSITION_TIMING_FUNCTION_EASE_IN_OUT: u32 = 4;
    pub const NS_STYLE_TRANSITION_TIMING_FUNCTION_STEP_START: u32 = 5;
    pub const NS_STYLE_TRANSITION_TIMING_FUNCTION_STEP_END: u32 = 6;
    pub const NS_STYLE_VERTICAL_ALIGN_BASELINE: u32 = 14;
    pub const NS_STYLE_VERTICAL_ALIGN_SUB: u32 = 15;
    pub const NS_STYLE_VERTICAL_ALIGN_SUPER: u32 = 16;
    pub const NS_STYLE_VERTICAL_ALIGN_TOP: u32 = 17;
    pub const NS_STYLE_VERTICAL_ALIGN_TEXT_TOP: u32 = 18;
    pub const NS_STYLE_VERTICAL_ALIGN_MIDDLE: u32 = 19;
    pub const NS_STYLE_VERTICAL_ALIGN_TEXT_BOTTOM: u32 = 20;
    pub const NS_STYLE_VERTICAL_ALIGN_BOTTOM: u32 = 21;
    pub const NS_STYLE_VERTICAL_ALIGN_MIDDLE_WITH_BASELINE: u32 = 22;
    pub const NS_STYLE_VISIBILITY_HIDDEN: u32 = 0;
    pub const NS_STYLE_VISIBILITY_VISIBLE: u32 = 1;
    pub const NS_STYLE_VISIBILITY_COLLAPSE: u32 = 2;
    pub const NS_STYLE_TABSIZE_INITIAL: u32 = 8;
    pub const NS_STYLE_WORDBREAK_NORMAL: u32 = 0;
    pub const NS_STYLE_WORDBREAK_BREAK_ALL: u32 = 1;
    pub const NS_STYLE_WORDBREAK_KEEP_ALL: u32 = 2;
    pub const NS_STYLE_OVERFLOWWRAP_NORMAL: u32 = 0;
    pub const NS_STYLE_OVERFLOWWRAP_BREAK_WORD: u32 = 1;
    pub const NS_STYLE_RUBY_ALIGN_START: u32 = 0;
    pub const NS_STYLE_RUBY_ALIGN_CENTER: u32 = 1;
    pub const NS_STYLE_RUBY_ALIGN_SPACE_BETWEEN: u32 = 2;
    pub const NS_STYLE_RUBY_ALIGN_SPACE_AROUND: u32 = 3;
    pub const NS_STYLE_RUBY_POSITION_OVER: u32 = 0;
    pub const NS_STYLE_RUBY_POSITION_UNDER: u32 = 1;
    pub const NS_STYLE_RUBY_POSITION_INTER_CHARACTER: u32 = 2;
    pub const NS_STYLE_TEXT_SIZE_ADJUST_NONE: u32 = 0;
    pub const NS_STYLE_TEXT_SIZE_ADJUST_AUTO: u32 = 1;
    pub const NS_STYLE_TEXT_ORIENTATION_MIXED: u32 = 0;
    pub const NS_STYLE_TEXT_ORIENTATION_UPRIGHT: u32 = 1;
    pub const NS_STYLE_TEXT_ORIENTATION_SIDEWAYS: u32 = 2;
    pub const NS_STYLE_TEXT_COMBINE_UPRIGHT_NONE: u32 = 0;
    pub const NS_STYLE_TEXT_COMBINE_UPRIGHT_ALL: u32 = 1;
    pub const NS_STYLE_TEXT_COMBINE_UPRIGHT_DIGITS_2: u32 = 2;
    pub const NS_STYLE_TEXT_COMBINE_UPRIGHT_DIGITS_3: u32 = 3;
    pub const NS_STYLE_TEXT_COMBINE_UPRIGHT_DIGITS_4: u32 = 4;
    pub const NS_STYLE_LINE_HEIGHT_BLOCK_HEIGHT: u32 = 0;
    pub const NS_STYLE_UNICODE_BIDI_NORMAL: u32 = 0;
    pub const NS_STYLE_UNICODE_BIDI_EMBED: u32 = 1;
    pub const NS_STYLE_UNICODE_BIDI_ISOLATE: u32 = 2;
    pub const NS_STYLE_UNICODE_BIDI_BIDI_OVERRIDE: u32 = 4;
    pub const NS_STYLE_UNICODE_BIDI_ISOLATE_OVERRIDE: u32 = 6;
    pub const NS_STYLE_UNICODE_BIDI_PLAINTEXT: u32 = 8;
    pub const NS_STYLE_TABLE_LAYOUT_AUTO: u32 = 0;
    pub const NS_STYLE_TABLE_LAYOUT_FIXED: u32 = 1;
    pub const NS_STYLE_TABLE_EMPTY_CELLS_HIDE: u32 = 0;
    pub const NS_STYLE_TABLE_EMPTY_CELLS_SHOW: u32 = 1;
    pub const NS_STYLE_CAPTION_SIDE_TOP: u32 = 0;
    pub const NS_STYLE_CAPTION_SIDE_RIGHT: u32 = 1;
    pub const NS_STYLE_CAPTION_SIDE_BOTTOM: u32 = 2;
    pub const NS_STYLE_CAPTION_SIDE_LEFT: u32 = 3;
    pub const NS_STYLE_CAPTION_SIDE_TOP_OUTSIDE: u32 = 4;
    pub const NS_STYLE_CAPTION_SIDE_BOTTOM_OUTSIDE: u32 = 5;
    pub const NS_STYLE_CELL_SCOPE_ROW: u32 = 0;
    pub const NS_STYLE_CELL_SCOPE_COL: u32 = 1;
    pub const NS_STYLE_CELL_SCOPE_ROWGROUP: u32 = 2;
    pub const NS_STYLE_CELL_SCOPE_COLGROUP: u32 = 3;
    pub const NS_STYLE_PAGE_MARKS_NONE: u32 = 0;
    pub const NS_STYLE_PAGE_MARKS_CROP: u32 = 1;
    pub const NS_STYLE_PAGE_MARKS_REGISTER: u32 = 2;
    pub const NS_STYLE_PAGE_SIZE_AUTO: u32 = 0;
    pub const NS_STYLE_PAGE_SIZE_PORTRAIT: u32 = 1;
    pub const NS_STYLE_PAGE_SIZE_LANDSCAPE: u32 = 2;
    pub const NS_STYLE_PAGE_BREAK_AUTO: u32 = 0;
    pub const NS_STYLE_PAGE_BREAK_ALWAYS: u32 = 1;
    pub const NS_STYLE_PAGE_BREAK_AVOID: u32 = 2;
    pub const NS_STYLE_PAGE_BREAK_LEFT: u32 = 3;
    pub const NS_STYLE_PAGE_BREAK_RIGHT: u32 = 4;
    pub const NS_STYLE_COLUMN_COUNT_AUTO: u32 = 0;
    pub const NS_STYLE_COLUMN_COUNT_UNLIMITED: i32 = -1;
    pub const NS_STYLE_COLUMN_FILL_AUTO: u32 = 0;
    pub const NS_STYLE_COLUMN_FILL_BALANCE: u32 = 1;
    pub const NS_STYLE_COLUMN_SPAN_NONE: u32 = 0;
    pub const NS_STYLE_COLUMN_SPAN_ALL: u32 = 1;
    pub const NS_STYLE_IME_MODE_AUTO: u32 = 0;
    pub const NS_STYLE_IME_MODE_NORMAL: u32 = 1;
    pub const NS_STYLE_IME_MODE_ACTIVE: u32 = 2;
    pub const NS_STYLE_IME_MODE_DISABLED: u32 = 3;
    pub const NS_STYLE_IME_MODE_INACTIVE: u32 = 4;
    pub const NS_STYLE_GRADIENT_SHAPE_LINEAR: u32 = 0;
    pub const NS_STYLE_GRADIENT_SHAPE_ELLIPTICAL: u32 = 1;
    pub const NS_STYLE_GRADIENT_SHAPE_CIRCULAR: u32 = 2;
    pub const NS_STYLE_GRADIENT_SIZE_CLOSEST_SIDE: u32 = 0;
    pub const NS_STYLE_GRADIENT_SIZE_CLOSEST_CORNER: u32 = 1;
    pub const NS_STYLE_GRADIENT_SIZE_FARTHEST_SIDE: u32 = 2;
    pub const NS_STYLE_GRADIENT_SIZE_FARTHEST_CORNER: u32 = 3;
    pub const NS_STYLE_GRADIENT_SIZE_EXPLICIT_SIZE: u32 = 4;
    pub const NS_STYLE_CONTEXT_PROPERTY_FILL: u32 = 1;
    pub const NS_STYLE_CONTEXT_PROPERTY_STROKE: u32 = 2;
    pub const NS_STYLE_CONTEXT_PROPERTY_FILL_OPACITY: u32 = 4;
    pub const NS_STYLE_CONTEXT_PROPERTY_STROKE_OPACITY: u32 = 8;
    pub const NS_STYLE_WINDOW_SHADOW_NONE: u32 = 0;
    pub const NS_STYLE_WINDOW_SHADOW_DEFAULT: u32 = 1;
    pub const NS_STYLE_WINDOW_SHADOW_MENU: u32 = 2;
    pub const NS_STYLE_WINDOW_SHADOW_TOOLTIP: u32 = 3;
    pub const NS_STYLE_WINDOW_SHADOW_SHEET: u32 = 4;
    pub const NS_STYLE_DOMINANT_BASELINE_AUTO: u32 = 0;
    pub const NS_STYLE_DOMINANT_BASELINE_USE_SCRIPT: u32 = 1;
    pub const NS_STYLE_DOMINANT_BASELINE_NO_CHANGE: u32 = 2;
    pub const NS_STYLE_DOMINANT_BASELINE_RESET_SIZE: u32 = 3;
    pub const NS_STYLE_DOMINANT_BASELINE_IDEOGRAPHIC: u32 = 4;
    pub const NS_STYLE_DOMINANT_BASELINE_ALPHABETIC: u32 = 5;
    pub const NS_STYLE_DOMINANT_BASELINE_HANGING: u32 = 6;
    pub const NS_STYLE_DOMINANT_BASELINE_MATHEMATICAL: u32 = 7;
    pub const NS_STYLE_DOMINANT_BASELINE_CENTRAL: u32 = 8;
    pub const NS_STYLE_DOMINANT_BASELINE_MIDDLE: u32 = 9;
    pub const NS_STYLE_DOMINANT_BASELINE_TEXT_AFTER_EDGE: u32 = 10;
    pub const NS_STYLE_DOMINANT_BASELINE_TEXT_BEFORE_EDGE: u32 = 11;
    pub const NS_STYLE_IMAGE_RENDERING_AUTO: u32 = 0;
    pub const NS_STYLE_IMAGE_RENDERING_OPTIMIZESPEED: u32 = 1;
    pub const NS_STYLE_IMAGE_RENDERING_OPTIMIZEQUALITY: u32 = 2;
    pub const NS_STYLE_IMAGE_RENDERING_CRISPEDGES: u32 = 3;
    pub const NS_STYLE_MASK_TYPE_LUMINANCE: u32 = 0;
    pub const NS_STYLE_MASK_TYPE_ALPHA: u32 = 1;
    pub const NS_STYLE_PAINT_ORDER_NORMAL: u32 = 0;
    pub const NS_STYLE_PAINT_ORDER_FILL: u32 = 1;
    pub const NS_STYLE_PAINT_ORDER_STROKE: u32 = 2;
    pub const NS_STYLE_PAINT_ORDER_MARKERS: u32 = 3;
    pub const NS_STYLE_PAINT_ORDER_LAST_VALUE: u32 = 3;
    pub const NS_STYLE_PAINT_ORDER_BITWIDTH: u32 = 2;
    pub const NS_STYLE_SHAPE_RENDERING_AUTO: u32 = 0;
    pub const NS_STYLE_SHAPE_RENDERING_OPTIMIZESPEED: u32 = 1;
    pub const NS_STYLE_SHAPE_RENDERING_CRISPEDGES: u32 = 2;
    pub const NS_STYLE_SHAPE_RENDERING_GEOMETRICPRECISION: u32 = 3;
    pub const NS_STYLE_STROKE_LINECAP_BUTT: u32 = 0;
    pub const NS_STYLE_STROKE_LINECAP_ROUND: u32 = 1;
    pub const NS_STYLE_STROKE_LINECAP_SQUARE: u32 = 2;
    pub const NS_STYLE_STROKE_LINEJOIN_MITER: u32 = 0;
    pub const NS_STYLE_STROKE_LINEJOIN_ROUND: u32 = 1;
    pub const NS_STYLE_STROKE_LINEJOIN_BEVEL: u32 = 2;
    pub const NS_STYLE_STROKE_PROP_CONTEXT_VALUE: u32 = 0;
    pub const NS_STYLE_TEXT_ANCHOR_START: u32 = 0;
    pub const NS_STYLE_TEXT_ANCHOR_MIDDLE: u32 = 1;
    pub const NS_STYLE_TEXT_ANCHOR_END: u32 = 2;
    pub const NS_STYLE_TEXT_EMPHASIS_POSITION_OVER: u32 = 1;
    pub const NS_STYLE_TEXT_EMPHASIS_POSITION_UNDER: u32 = 2;
    pub const NS_STYLE_TEXT_EMPHASIS_POSITION_LEFT: u32 = 4;
    pub const NS_STYLE_TEXT_EMPHASIS_POSITION_RIGHT: u32 = 8;
    pub const NS_STYLE_TEXT_EMPHASIS_POSITION_DEFAULT: u32 = 9;
    pub const NS_STYLE_TEXT_EMPHASIS_POSITION_DEFAULT_ZH: u32 = 10;
    pub const NS_STYLE_TEXT_EMPHASIS_STYLE_NONE: u32 = 0;
    pub const NS_STYLE_TEXT_EMPHASIS_STYLE_FILL_MASK: u32 = 8;
    pub const NS_STYLE_TEXT_EMPHASIS_STYLE_FILLED: u32 = 0;
    pub const NS_STYLE_TEXT_EMPHASIS_STYLE_OPEN: u32 = 8;
    pub const NS_STYLE_TEXT_EMPHASIS_STYLE_SHAPE_MASK: u32 = 7;
    pub const NS_STYLE_TEXT_EMPHASIS_STYLE_DOT: u32 = 1;
    pub const NS_STYLE_TEXT_EMPHASIS_STYLE_CIRCLE: u32 = 2;
    pub const NS_STYLE_TEXT_EMPHASIS_STYLE_DOUBLE_CIRCLE: u32 = 3;
    pub const NS_STYLE_TEXT_EMPHASIS_STYLE_TRIANGLE: u32 = 4;
    pub const NS_STYLE_TEXT_EMPHASIS_STYLE_SESAME: u32 = 5;
    pub const NS_STYLE_TEXT_EMPHASIS_STYLE_STRING: u32 = 255;
    pub const NS_STYLE_TEXT_RENDERING_AUTO: u32 = 0;
    pub const NS_STYLE_TEXT_RENDERING_OPTIMIZESPEED: u32 = 1;
    pub const NS_STYLE_TEXT_RENDERING_OPTIMIZELEGIBILITY: u32 = 2;
    pub const NS_STYLE_TEXT_RENDERING_GEOMETRICPRECISION: u32 = 3;
    pub const NS_STYLE_COLOR_ADJUST_ECONOMY: u32 = 0;
    pub const NS_STYLE_COLOR_ADJUST_EXACT: u32 = 1;
    pub const NS_STYLE_COLOR_INTERPOLATION_AUTO: u32 = 0;
    pub const NS_STYLE_COLOR_INTERPOLATION_SRGB: u32 = 1;
    pub const NS_STYLE_COLOR_INTERPOLATION_LINEARRGB: u32 = 2;
    pub const NS_STYLE_VECTOR_EFFECT_NONE: u32 = 0;
    pub const NS_STYLE_VECTOR_EFFECT_NON_SCALING_STROKE: u32 = 1;
    pub const NS_STYLE_BACKFACE_VISIBILITY_VISIBLE: u32 = 1;
    pub const NS_STYLE_BACKFACE_VISIBILITY_HIDDEN: u32 = 0;
    pub const NS_STYLE_TRANSFORM_STYLE_FLAT: u32 = 0;
    pub const NS_STYLE_TRANSFORM_STYLE_PRESERVE_3D: u32 = 1;
    pub const NS_STYLE_CONTEXT_FILL_OPACITY: u32 = 0;
    pub const NS_STYLE_CONTEXT_STROKE_OPACITY: u32 = 1;
    pub const NS_STYLE_BLEND_NORMAL: u32 = 0;
    pub const NS_STYLE_BLEND_MULTIPLY: u32 = 1;
    pub const NS_STYLE_BLEND_SCREEN: u32 = 2;
    pub const NS_STYLE_BLEND_OVERLAY: u32 = 3;
    pub const NS_STYLE_BLEND_DARKEN: u32 = 4;
    pub const NS_STYLE_BLEND_LIGHTEN: u32 = 5;
    pub const NS_STYLE_BLEND_COLOR_DODGE: u32 = 6;
    pub const NS_STYLE_BLEND_COLOR_BURN: u32 = 7;
    pub const NS_STYLE_BLEND_HARD_LIGHT: u32 = 8;
    pub const NS_STYLE_BLEND_SOFT_LIGHT: u32 = 9;
    pub const NS_STYLE_BLEND_DIFFERENCE: u32 = 10;
    pub const NS_STYLE_BLEND_EXCLUSION: u32 = 11;
    pub const NS_STYLE_BLEND_HUE: u32 = 12;
    pub const NS_STYLE_BLEND_SATURATION: u32 = 13;
    pub const NS_STYLE_BLEND_COLOR: u32 = 14;
    pub const NS_STYLE_BLEND_LUMINOSITY: u32 = 15;
    pub const NS_STYLE_MASK_COMPOSITE_ADD: u32 = 0;
    pub const NS_STYLE_MASK_COMPOSITE_SUBTRACT: u32 = 1;
    pub const NS_STYLE_MASK_COMPOSITE_INTERSECT: u32 = 2;
    pub const NS_STYLE_MASK_COMPOSITE_EXCLUDE: u32 = 3;
    pub const NS_STYLE_CONTROL_CHARACTER_VISIBILITY_HIDDEN: u32 = 0;
    pub const NS_STYLE_CONTROL_CHARACTER_VISIBILITY_VISIBLE: u32 = 1;
    pub const NS_STYLE_COUNTER_SYSTEM_CYCLIC: u32 = 0;
    pub const NS_STYLE_COUNTER_SYSTEM_NUMERIC: u32 = 1;
    pub const NS_STYLE_COUNTER_SYSTEM_ALPHABETIC: u32 = 2;
    pub const NS_STYLE_COUNTER_SYSTEM_SYMBOLIC: u32 = 3;
    pub const NS_STYLE_COUNTER_SYSTEM_ADDITIVE: u32 = 4;
    pub const NS_STYLE_COUNTER_SYSTEM_FIXED: u32 = 5;
    pub const NS_STYLE_COUNTER_SYSTEM_EXTENDS: u32 = 6;
    pub const NS_STYLE_COUNTER_RANGE_INFINITE: u32 = 0;
    pub const NS_STYLE_COUNTER_SPEAKAS_BULLETS: u32 = 0;
    pub const NS_STYLE_COUNTER_SPEAKAS_NUMBERS: u32 = 1;
    pub const NS_STYLE_COUNTER_SPEAKAS_WORDS: u32 = 2;
    pub const NS_STYLE_COUNTER_SPEAKAS_SPELL_OUT: u32 = 3;
    pub const NS_STYLE_COUNTER_SPEAKAS_OTHER: u32 = 255;
    pub const NS_STYLE_SCROLL_BEHAVIOR_AUTO: u32 = 0;
    pub const NS_STYLE_SCROLL_BEHAVIOR_SMOOTH: u32 = 1;
    pub const NS_STYLE_SCROLL_SNAP_TYPE_NONE: u32 = 0;
    pub const NS_STYLE_SCROLL_SNAP_TYPE_MANDATORY: u32 = 1;
    pub const NS_STYLE_SCROLL_SNAP_TYPE_PROXIMITY: u32 = 2;
    pub const NS_STYLE_ORIENTATION_PORTRAIT: u32 = 0;
    pub const NS_STYLE_ORIENTATION_LANDSCAPE: u32 = 1;
    pub const NS_STYLE_SCAN_PROGRESSIVE: u32 = 0;
    pub const NS_STYLE_SCAN_INTERLACE: u32 = 1;
    pub const NS_STYLE_DISPLAY_MODE_BROWSER: u32 = 0;
    pub const NS_STYLE_DISPLAY_MODE_MINIMAL_UI: u32 = 1;
    pub const NS_STYLE_DISPLAY_MODE_STANDALONE: u32 = 2;
    pub const NS_STYLE_DISPLAY_MODE_FULLSCREEN: u32 = 3;
    pub const CSS_PSEUDO_ELEMENT_IS_CSS2: u32 = 1;
    pub const CSS_PSEUDO_ELEMENT_CONTAINS_ELEMENTS: u32 = 2;
    pub const CSS_PSEUDO_ELEMENT_SUPPORTS_STYLE_ATTRIBUTE: u32 = 4;
    pub const CSS_PSEUDO_ELEMENT_SUPPORTS_USER_ACTION_STATE: u32 = 8;
    pub const CSS_PSEUDO_ELEMENT_ENABLED_IN_UA_SHEETS: u32 = 16;
    pub const CSS_PSEUDO_ELEMENT_ENABLED_IN_CHROME: u32 = 32;
    pub const CSS_PSEUDO_ELEMENT_ENABLED_IN_UA_SHEETS_AND_CHROME: u32 = 48;
    pub const CSS_PSEUDO_ELEMENT_IS_JS_CREATED_NAC: u32 = 64;
    pub const CSS_PSEUDO_ELEMENT_IS_FLEX_OR_GRID_ITEM: u32 = 128;
    pub const kNameSpaceID_Unknown: i32 = -1;
    pub const kNameSpaceID_XMLNS: u32 = 1;
    pub const kNameSpaceID_XML: u32 = 2;
    pub const kNameSpaceID_XHTML: u32 = 3;
    pub const kNameSpaceID_XLink: u32 = 4;
    pub const kNameSpaceID_XSLT: u32 = 5;
    pub const kNameSpaceID_XBL: u32 = 6;
    pub const kNameSpaceID_MathML: u32 = 7;
    pub const kNameSpaceID_RDF: u32 = 8;
    pub const kNameSpaceID_XUL: u32 = 9;
    pub const kNameSpaceID_SVG: u32 = 10;
    pub const kNameSpaceID_disabled_MathML: u32 = 11;
    pub const kNameSpaceID_disabled_SVG: u32 = 12;
    pub const kNameSpaceID_LastBuiltin: u32 = 12;
    pub const kNameSpaceID_Wildcard: i32 = -2147483648;
    pub const NS_AUTHOR_SPECIFIED_BACKGROUND: u32 = 1;
    pub const NS_AUTHOR_SPECIFIED_BORDER: u32 = 2;
    pub const NS_AUTHOR_SPECIFIED_PADDING: u32 = 4;
    pub const NS_STYLE_INHERIT_MASK: u32 = 16777215;
    pub const NS_STYLE_HAS_TEXT_DECORATION_LINES: u32 = 16777216;
    pub const NS_STYLE_HAS_PSEUDO_ELEMENT_DATA: u32 = 33554432;
    pub const NS_STYLE_RELEVANT_LINK_VISITED: u32 = 67108864;
    pub const NS_STYLE_IS_STYLE_IF_VISITED: u32 = 134217728;
    pub const NS_STYLE_CHILD_USES_GRANDANCESTOR_STYLE: u32 = 268435456;
    pub const NS_STYLE_IS_SHARED: u32 = 536870912;
    pub const NS_STYLE_IS_GOING_AWAY: u32 = 1073741824;
    pub const NS_STYLE_SUPPRESS_LINEBREAK: u32 = 2147483648;
    pub const NS_STYLE_IN_DISPLAY_NONE_SUBTREE: u64 = 4294967296;
    pub const NS_STYLE_INELIGIBLE_FOR_SHARING: u64 = 8589934592;
    pub const NS_STYLE_HAS_CHILD_THAT_USES_RESET_STYLE: u64 = 17179869184;
    pub const NS_STYLE_IS_TEXT_COMBINED: u64 = 34359738368;
    pub const NS_STYLE_CONTEXT_IS_GECKO: u64 = 68719476736;
    pub const NS_STYLE_CONTEXT_TYPE_SHIFT: u32 = 37;
    pub mod std {
        #[allow(unused_imports)]
        use self::super::super::root;
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct nothrow_t {
            pub _address: u8,
        }
        #[test]
        fn bindgen_test_layout_nothrow_t() {
            assert_eq!(
                ::std::mem::size_of::<nothrow_t>(),
                1usize,
                concat!("Size of: ", stringify!(nothrow_t))
            );
            assert_eq!(
                ::std::mem::align_of::<nothrow_t>(),
                1usize,
                concat!("Alignment of ", stringify!(nothrow_t))
            );
        }
        impl Clone for nothrow_t {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct pair<_T1, _T2> {
            pub first: _T1,
            pub second: _T2,
            pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<_T1>>,
            pub _phantom_1: ::std::marker::PhantomData<::std::cell::UnsafeCell<_T2>>,
        }
        pub type pair_first_type<_T1> = _T1;
        pub type pair_second_type<_T2> = _T2;
        pub type pair__PCCP = u8;
        pub type pair__PCCFP = u8;
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct input_iterator_tag {
            pub _address: u8,
        }
        #[test]
        fn bindgen_test_layout_input_iterator_tag() {
            assert_eq!(
                ::std::mem::size_of::<input_iterator_tag>(),
                1usize,
                concat!("Size of: ", stringify!(input_iterator_tag))
            );
            assert_eq!(
                ::std::mem::align_of::<input_iterator_tag>(),
                1usize,
                concat!("Alignment of ", stringify!(input_iterator_tag))
            );
        }
        impl Clone for input_iterator_tag {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct iterator {
            pub _address: u8,
        }
        pub type iterator_iterator_category<_Category> = _Category;
        pub type iterator_value_type<_Tp> = _Tp;
        pub type iterator_difference_type<_Distance> = _Distance;
        pub type iterator_pointer<_Pointer> = _Pointer;
        pub type iterator_reference<_Reference> = _Reference;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct atomic {
            pub _address: u8,
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct function {
            pub _address: u8,
        }
        pub type _Base_bitset__WordT = ::std::os::raw::c_ulong;
        pub type bitset__Base = u8;
        pub type bitset__WordT = ::std::os::raw::c_ulong;
        #[repr(C)]
        #[derive(Debug)]
        pub struct bitset_reference {
            pub _M_wp: *mut root::std::bitset__WordT,
            pub _M_bpos: usize,
        }
    }
    pub mod __gnu_cxx {
        #[allow(unused_imports)]
        use self::super::super::root;
    }
    pub type __int8_t = ::std::os::raw::c_schar;
    pub type __uint8_t = ::std::os::raw::c_uchar;
    pub type __int16_t = ::std::os::raw::c_short;
    pub type __uint16_t = ::std::os::raw::c_ushort;
    pub type __int32_t = ::std::os::raw::c_int;
    pub type __uint32_t = ::std::os::raw::c_uint;
    pub type __int64_t = ::std::os::raw::c_long;
    pub type __uint64_t = ::std::os::raw::c_ulong;
    pub mod mozilla {
        #[allow(unused_imports)]
        use self::super::super::root;
        pub type fallible_t = root::std::nothrow_t;
        pub type IntegralConstant_ValueType<T> = T;
        pub type IntegralConstant_Type = u8;
        /// Convenient aliases.
        pub type TrueType = u8;
        pub type FalseType = u8;
        pub mod detail {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            pub const StringDataFlags_TERMINATED: root::mozilla::detail::StringDataFlags = 1;
            pub const StringDataFlags_VOIDED: root::mozilla::detail::StringDataFlags = 2;
            pub const StringDataFlags_SHARED: root::mozilla::detail::StringDataFlags = 4;
            pub const StringDataFlags_OWNED: root::mozilla::detail::StringDataFlags = 8;
            pub const StringDataFlags_INLINE: root::mozilla::detail::StringDataFlags = 16;
            pub const StringDataFlags_LITERAL: root::mozilla::detail::StringDataFlags = 32;
            pub type StringDataFlags = u16;
            pub const StringClassFlags_INLINE: root::mozilla::detail::StringClassFlags = 1;
            pub const StringClassFlags_NULL_TERMINATED: root::mozilla::detail::StringClassFlags = 2;
            pub type StringClassFlags = u16;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct nsTStringRepr<T> {
                pub mData: *mut root::mozilla::detail::nsTStringRepr_char_type<T>,
                pub mLength: root::mozilla::detail::nsTStringRepr_size_type,
                pub mDataFlags: root::mozilla::detail::nsTStringRepr_DataFlags,
                pub mClassFlags: root::mozilla::detail::nsTStringRepr_ClassFlags,
                pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
            }
            pub type nsTStringRepr_fallible_t = root::mozilla::fallible_t;
            pub type nsTStringRepr_char_type<T> = T;
            pub type nsTStringRepr_self_type<T> = root::mozilla::detail::nsTStringRepr<T>;
            pub type nsTStringRepr_base_string_type<T> =
                root::mozilla::detail::nsTStringRepr_self_type<T>;
            pub type nsTStringRepr_substring_type<T> = root::nsTSubstring<T>;
            pub type nsTStringRepr_substring_tuple_type<T> = root::nsTSubstringTuple<T>;
            pub type nsTStringRepr_literalstring_type<T> = root::nsTLiteralString<T>;
            pub type nsTStringRepr_const_iterator<T> =
                root::nsReadingIterator<root::mozilla::detail::nsTStringRepr_char_type<T>>;
            pub type nsTStringRepr_iterator<T> =
                root::nsWritingIterator<root::mozilla::detail::nsTStringRepr_char_type<T>>;
            pub type nsTStringRepr_comparator_type = root::nsTStringComparator;
            pub type nsTStringRepr_char_iterator<T> =
                *mut root::mozilla::detail::nsTStringRepr_char_type<T>;
            pub type nsTStringRepr_const_char_iterator<T> =
                *const root::mozilla::detail::nsTStringRepr_char_type<T>;
            pub type nsTStringRepr_index_type = u32;
            pub type nsTStringRepr_size_type = u32;
            pub use self :: super :: super :: super :: root :: mozilla :: detail :: StringDataFlags as nsTStringRepr_DataFlags;
            pub use self :: super :: super :: super :: root :: mozilla :: detail :: StringClassFlags as nsTStringRepr_ClassFlags;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct nsTStringRepr_raw_type {
                pub _address: u8,
            }
            pub type nsTStringRepr_raw_type_type<U> = *mut U;
            /// LinkedList supports refcounted elements using this adapter class. Clients
            /// using LinkedList<RefPtr<T>> will get a data structure that holds a strong
            /// reference to T as long as T is in the list.
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct LinkedListElementTraits {
                pub _address: u8,
            }
            pub type LinkedListElementTraits_RawType<T> = *mut T;
            pub type LinkedListElementTraits_ConstRawType<T> = *mut T;
            pub type LinkedListElementTraits_ClientType<T> = *mut T;
            pub type LinkedListElementTraits_ConstClientType<T> = *mut T;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct VariantTag {
                pub _address: u8,
            }
            pub type VariantTag_Type = u8;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct WeakReference {
                pub _address: u8,
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct FreePolicy {
                pub _address: u8,
            }
            #[repr(C)]
            #[derive(Debug)]
            pub struct MutexImpl {
                pub platformData_: [*mut ::std::os::raw::c_void; 5usize],
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct MutexImpl_PlatformData {
                _unused: [u8; 0],
            }
            impl Clone for MutexImpl_PlatformData {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[test]
            fn bindgen_test_layout_MutexImpl() {
                assert_eq!(
                    ::std::mem::size_of::<MutexImpl>(),
                    40usize,
                    concat!("Size of: ", stringify!(MutexImpl))
                );
                assert_eq!(
                    ::std::mem::align_of::<MutexImpl>(),
                    8usize,
                    concat!("Alignment of ", stringify!(MutexImpl))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<MutexImpl>())).platformData_ as *const _ as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(MutexImpl),
                        "::",
                        stringify!(platformData_)
                    )
                );
            }
            #[repr(C)]
            #[derive(Debug)]
            pub struct ConditionVariableImpl {
                pub platformData_: [*mut ::std::os::raw::c_void; 6usize],
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct ConditionVariableImpl_PlatformData {
                _unused: [u8; 0],
            }
            impl Clone for ConditionVariableImpl_PlatformData {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[test]
            fn bindgen_test_layout_ConditionVariableImpl() {
                assert_eq!(
                    ::std::mem::size_of::<ConditionVariableImpl>(),
                    48usize,
                    concat!("Size of: ", stringify!(ConditionVariableImpl))
                );
                assert_eq!(
                    ::std::mem::align_of::<ConditionVariableImpl>(),
                    8usize,
                    concat!("Alignment of ", stringify!(ConditionVariableImpl))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ConditionVariableImpl>())).platformData_ as *const _
                            as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ConditionVariableImpl),
                        "::",
                        stringify!(platformData_)
                    )
                );
            }
        }
        pub type Conditional_Type<A> = A;
        pub const ArenaObjectID_eArenaObjectID_DummyBeforeFirstObjectID:
            root::mozilla::ArenaObjectID = 171;
        pub const ArenaObjectID_eArenaObjectID_GeckoStyleContext: root::mozilla::ArenaObjectID =
            172;
        pub const ArenaObjectID_eArenaObjectID_nsLineBox: root::mozilla::ArenaObjectID = 173;
        pub const ArenaObjectID_eArenaObjectID_nsRuleNode: root::mozilla::ArenaObjectID = 174;
        pub const ArenaObjectID_eArenaObjectID_DisplayItemData: root::mozilla::ArenaObjectID = 175;
        pub const ArenaObjectID_eArenaObjectID_nsInheritedStyleData: root::mozilla::ArenaObjectID =
            176;
        pub const ArenaObjectID_eArenaObjectID_nsResetStyleData: root::mozilla::ArenaObjectID = 177;
        pub const ArenaObjectID_eArenaObjectID_nsConditionalResetStyleData:
            root::mozilla::ArenaObjectID = 178;
        pub const ArenaObjectID_eArenaObjectID_nsConditionalResetStyleDataEntry:
            root::mozilla::ArenaObjectID = 179;
        pub const ArenaObjectID_eArenaObjectID_nsFrameList: root::mozilla::ArenaObjectID = 180;
        pub const ArenaObjectID_eArenaObjectID_CustomCounterStyle: root::mozilla::ArenaObjectID =
            181;
        pub const ArenaObjectID_eArenaObjectID_DependentBuiltinCounterStyle:
            root::mozilla::ArenaObjectID = 182;
        pub const ArenaObjectID_eArenaObjectID_nsCallbackEventRequest:
            root::mozilla::ArenaObjectID = 183;
        pub const ArenaObjectID_eArenaObjectID_nsIntervalSet_Interval:
            root::mozilla::ArenaObjectID = 184;
        pub const ArenaObjectID_eArenaObjectID_CellData: root::mozilla::ArenaObjectID = 185;
        pub const ArenaObjectID_eArenaObjectID_BCCellData: root::mozilla::ArenaObjectID = 186;
        pub const ArenaObjectID_eArenaObjectID_nsStyleFont: root::mozilla::ArenaObjectID = 187;
        pub const ArenaObjectID_eArenaObjectID_nsStyleColor: root::mozilla::ArenaObjectID = 188;
        pub const ArenaObjectID_eArenaObjectID_nsStyleList: root::mozilla::ArenaObjectID = 189;
        pub const ArenaObjectID_eArenaObjectID_nsStyleText: root::mozilla::ArenaObjectID = 190;
        pub const ArenaObjectID_eArenaObjectID_nsStyleVisibility: root::mozilla::ArenaObjectID =
            191;
        pub const ArenaObjectID_eArenaObjectID_nsStyleUserInterface: root::mozilla::ArenaObjectID =
            192;
        pub const ArenaObjectID_eArenaObjectID_nsStyleTableBorder: root::mozilla::ArenaObjectID =
            193;
        pub const ArenaObjectID_eArenaObjectID_nsStyleSVG: root::mozilla::ArenaObjectID = 194;
        pub const ArenaObjectID_eArenaObjectID_nsStyleVariables: root::mozilla::ArenaObjectID = 195;
        pub const ArenaObjectID_eArenaObjectID_nsStyleBackground: root::mozilla::ArenaObjectID =
            196;
        pub const ArenaObjectID_eArenaObjectID_nsStylePosition: root::mozilla::ArenaObjectID = 197;
        pub const ArenaObjectID_eArenaObjectID_nsStyleTextReset: root::mozilla::ArenaObjectID = 198;
        pub const ArenaObjectID_eArenaObjectID_nsStyleDisplay: root::mozilla::ArenaObjectID = 199;
        pub const ArenaObjectID_eArenaObjectID_nsStyleContent: root::mozilla::ArenaObjectID = 200;
        pub const ArenaObjectID_eArenaObjectID_nsStyleUIReset: root::mozilla::ArenaObjectID = 201;
        pub const ArenaObjectID_eArenaObjectID_nsStyleTable: root::mozilla::ArenaObjectID = 202;
        pub const ArenaObjectID_eArenaObjectID_nsStyleMargin: root::mozilla::ArenaObjectID = 203;
        pub const ArenaObjectID_eArenaObjectID_nsStylePadding: root::mozilla::ArenaObjectID = 204;
        pub const ArenaObjectID_eArenaObjectID_nsStyleBorder: root::mozilla::ArenaObjectID = 205;
        pub const ArenaObjectID_eArenaObjectID_nsStyleOutline: root::mozilla::ArenaObjectID = 206;
        pub const ArenaObjectID_eArenaObjectID_nsStyleXUL: root::mozilla::ArenaObjectID = 207;
        pub const ArenaObjectID_eArenaObjectID_nsStyleSVGReset: root::mozilla::ArenaObjectID = 208;
        pub const ArenaObjectID_eArenaObjectID_nsStyleColumn: root::mozilla::ArenaObjectID = 209;
        pub const ArenaObjectID_eArenaObjectID_nsStyleEffects: root::mozilla::ArenaObjectID = 210;
        pub const ArenaObjectID_eArenaObjectID_COUNT: root::mozilla::ArenaObjectID = 211;
        pub type ArenaObjectID = u32;
        /// A default deletion policy using plain old operator delete.
        ///
        /// Note that this type can be specialized, but authors should beware of the risk
        /// that the specialization may at some point cease to match (either because it
        /// gets moved to a different compilation unit or the signature changes). If the
        /// non-specialized (|delete|-based) version compiles for that type but does the
        /// wrong thing, bad things could happen.
        ///
        /// This is a non-issue for types which are always incomplete (i.e. opaque handle
        /// types), since |delete|-ing such a type will always trigger a compilation
        /// error.
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct DefaultDelete {
            pub _address: u8,
        }
        pub type MallocSizeOf =
            ::std::option::Option<unsafe extern "C" fn(p: *const ::std::os::raw::c_void) -> usize>;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct ReverseIterator<IteratorT> {
            pub mCurrent: IteratorT,
            pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<IteratorT>>,
        }
        pub type Array_iterator<T> = *mut T;
        pub type Array_const_iterator<T> = *mut T;
        pub type Array_reverse_iterator<T> = root::mozilla::ReverseIterator<T>;
        pub type Array_const_reverse_iterator<T> = root::mozilla::ReverseIterator<T>;
        pub mod css {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            #[repr(u8)]
            /// Enum defining the mode in which a sheet is to be parsed.  This is
            /// usually, but not always, the same as the cascade level at which the
            /// sheet will apply (see nsStyleSet.h).  Most of the Loader APIs only
            /// support loading of author sheets.
            ///
            /// Author sheets are the normal case: styles embedded in or linked
            /// from HTML pages.  They are also the most restricted.
            ///
            /// User sheets can do anything author sheets can do, and also get
            /// access to a few CSS extensions that are not yet suitable for
            /// exposure on the public Web, but are very useful for expressing
            /// user style overrides, such as @-moz-document rules.
            ///
            /// XXX: eUserSheetFeatures was added in bug 1035091, but some patches in
            /// that bug never landed to use this enum value. Currently, all the features
            /// in user sheet are also available in author sheet.
            ///
            /// Agent sheets have access to all author- and user-sheet features
            /// plus more extensions that are necessary for internal use but,
            /// again, not yet suitable for exposure on the public Web.  Some of
            /// these are outright unsafe to expose; in particular, incorrect
            /// styling of anonymous box pseudo-elements can violate layout
            /// invariants.
            ///
            /// Agent sheets that do not use any unsafe rules could use
            /// eSafeAgentSheetFeatures when creating the sheet. This enum value allows
            /// Servo backend to recognize the sheets as the agent level, but Gecko
            /// backend will parse it under _author_ level.
            #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
            pub enum SheetParsingMode {
                eAuthorSheetFeatures = 0,
                eUserSheetFeatures = 1,
                eAgentSheetFeatures = 2,
                eSafeAgentSheetFeatures = 3,
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct GroupRule {
                _unused: [u8; 0],
            }
            impl Clone for GroupRule {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct ImageLoader {
                _unused: [u8; 0],
            }
            impl Clone for ImageLoader {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            pub struct URLValueData__bindgen_vtable(::std::os::raw::c_void);
            #[repr(C)]
            #[derive(Debug)]
            pub struct URLValueData {
                pub vtable_: *const URLValueData__bindgen_vtable,
                pub mRefCnt: root::mozilla::ThreadSafeAutoRefCnt,
                pub mURI: root::nsMainThreadPtrHandle<root::nsIURI>,
                pub mExtraData: root::RefPtr<root::mozilla::URLExtraData>,
                pub mURIResolved: bool,
                pub mIsLocalRef: [u8; 2usize],
                pub mMightHaveRef: [u8; 2usize],
                pub mStrings: root::mozilla::css::URLValueData_RustOrGeckoString,
                pub mUsingRustString: bool,
                pub mLoadedImage: bool,
                pub mCORSMode: root::mozilla::CORSMode,
            }
            pub type URLValueData_HasThreadSafeRefCnt = root::mozilla::TrueType;
            #[repr(C)]
            #[derive(Debug)]
            pub struct URLValueData_RustOrGeckoString {
                pub mString: root::__BindgenUnionField<::nsstring::nsStringRepr>,
                pub mRustString: root::__BindgenUnionField<
                    ::gecko_bindings::structs::ServoRawOffsetArc<root::RustString>,
                >,
                pub bindgen_union_field: [u64; 2usize],
            }
            #[test]
            fn bindgen_test_layout_URLValueData_RustOrGeckoString() {
                assert_eq!(
                    ::std::mem::size_of::<URLValueData_RustOrGeckoString>(),
                    16usize,
                    concat!("Size of: ", stringify!(URLValueData_RustOrGeckoString))
                );
                assert_eq!(
                    ::std::mem::align_of::<URLValueData_RustOrGeckoString>(),
                    8usize,
                    concat!("Alignment of ", stringify!(URLValueData_RustOrGeckoString))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<URLValueData_RustOrGeckoString>())).mString
                            as *const _ as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(URLValueData_RustOrGeckoString),
                        "::",
                        stringify!(mString)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<URLValueData_RustOrGeckoString>())).mRustString
                            as *const _ as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(URLValueData_RustOrGeckoString),
                        "::",
                        stringify!(mRustString)
                    )
                );
            }
            #[test]
            fn bindgen_test_layout_URLValueData() {
                assert_eq!(
                    ::std::mem::size_of::<URLValueData>(),
                    64usize,
                    concat!("Size of: ", stringify!(URLValueData))
                );
                assert_eq!(
                    ::std::mem::align_of::<URLValueData>(),
                    8usize,
                    concat!("Alignment of ", stringify!(URLValueData))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<URLValueData>())).mRefCnt as *const _ as usize
                    },
                    8usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(URLValueData),
                        "::",
                        stringify!(mRefCnt)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<URLValueData>())).mURI as *const _ as usize },
                    16usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(URLValueData),
                        "::",
                        stringify!(mURI)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<URLValueData>())).mExtraData as *const _ as usize
                    },
                    24usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(URLValueData),
                        "::",
                        stringify!(mExtraData)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<URLValueData>())).mURIResolved as *const _ as usize
                    },
                    32usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(URLValueData),
                        "::",
                        stringify!(mURIResolved)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<URLValueData>())).mIsLocalRef as *const _ as usize
                    },
                    33usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(URLValueData),
                        "::",
                        stringify!(mIsLocalRef)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<URLValueData>())).mMightHaveRef as *const _ as usize
                    },
                    35usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(URLValueData),
                        "::",
                        stringify!(mMightHaveRef)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<URLValueData>())).mStrings as *const _ as usize
                    },
                    40usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(URLValueData),
                        "::",
                        stringify!(mStrings)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<URLValueData>())).mUsingRustString as *const _
                            as usize
                    },
                    56usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(URLValueData),
                        "::",
                        stringify!(mUsingRustString)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<URLValueData>())).mLoadedImage as *const _ as usize
                    },
                    57usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(URLValueData),
                        "::",
                        stringify!(mLoadedImage)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<URLValueData>())).mCORSMode as *const _ as usize
                    },
                    58usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(URLValueData),
                        "::",
                        stringify!(mCORSMode)
                    )
                );
            }
            #[repr(C)]
            #[derive(Debug)]
            pub struct URLValue {
                pub _base: root::mozilla::css::URLValueData,
            }
            #[test]
            fn bindgen_test_layout_URLValue() {
                assert_eq!(
                    ::std::mem::size_of::<URLValue>(),
                    64usize,
                    concat!("Size of: ", stringify!(URLValue))
                );
                assert_eq!(
                    ::std::mem::align_of::<URLValue>(),
                    8usize,
                    concat!("Alignment of ", stringify!(URLValue))
                );
            }
            #[repr(C)]
            #[derive(Debug)]
            pub struct ImageValue {
                pub _base: root::mozilla::css::URLValueData,
                pub mRequests: [u64; 4usize],
            }
            #[test]
            fn bindgen_test_layout_ImageValue() {
                assert_eq!(
                    ::std::mem::size_of::<ImageValue>(),
                    96usize,
                    concat!("Size of: ", stringify!(ImageValue))
                );
                assert_eq!(
                    ::std::mem::align_of::<ImageValue>(),
                    8usize,
                    concat!("Alignment of ", stringify!(ImageValue))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ImageValue>())).mRequests as *const _ as usize
                    },
                    64usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ImageValue),
                        "::",
                        stringify!(mRequests)
                    )
                );
            }
            #[repr(C)]
            pub struct GridNamedArea {
                pub mName: ::nsstring::nsStringRepr,
                pub mColumnStart: u32,
                pub mColumnEnd: u32,
                pub mRowStart: u32,
                pub mRowEnd: u32,
            }
            #[test]
            fn bindgen_test_layout_GridNamedArea() {
                assert_eq!(
                    ::std::mem::size_of::<GridNamedArea>(),
                    32usize,
                    concat!("Size of: ", stringify!(GridNamedArea))
                );
                assert_eq!(
                    ::std::mem::align_of::<GridNamedArea>(),
                    8usize,
                    concat!("Alignment of ", stringify!(GridNamedArea))
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<GridNamedArea>())).mName as *const _ as usize },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GridNamedArea),
                        "::",
                        stringify!(mName)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<GridNamedArea>())).mColumnStart as *const _ as usize
                    },
                    16usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GridNamedArea),
                        "::",
                        stringify!(mColumnStart)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<GridNamedArea>())).mColumnEnd as *const _ as usize
                    },
                    20usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GridNamedArea),
                        "::",
                        stringify!(mColumnEnd)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<GridNamedArea>())).mRowStart as *const _ as usize
                    },
                    24usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GridNamedArea),
                        "::",
                        stringify!(mRowStart)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<GridNamedArea>())).mRowEnd as *const _ as usize
                    },
                    28usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GridNamedArea),
                        "::",
                        stringify!(mRowEnd)
                    )
                );
            }
            #[repr(C)]
            pub struct GridTemplateAreasValue {
                pub mNamedAreas: root::nsTArray<root::mozilla::css::GridNamedArea>,
                pub mTemplates: root::nsTArray<::nsstring::nsStringRepr>,
                pub mNColumns: u32,
                pub mRefCnt: root::mozilla::ThreadSafeAutoRefCnt,
            }
            pub type GridTemplateAreasValue_HasThreadSafeRefCnt = root::mozilla::TrueType;
            #[test]
            fn bindgen_test_layout_GridTemplateAreasValue() {
                assert_eq!(
                    ::std::mem::size_of::<GridTemplateAreasValue>(),
                    32usize,
                    concat!("Size of: ", stringify!(GridTemplateAreasValue))
                );
                assert_eq!(
                    ::std::mem::align_of::<GridTemplateAreasValue>(),
                    8usize,
                    concat!("Alignment of ", stringify!(GridTemplateAreasValue))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<GridTemplateAreasValue>())).mNamedAreas as *const _
                            as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GridTemplateAreasValue),
                        "::",
                        stringify!(mNamedAreas)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<GridTemplateAreasValue>())).mTemplates as *const _
                            as usize
                    },
                    8usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GridTemplateAreasValue),
                        "::",
                        stringify!(mTemplates)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<GridTemplateAreasValue>())).mNColumns as *const _
                            as usize
                    },
                    16usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GridTemplateAreasValue),
                        "::",
                        stringify!(mNColumns)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<GridTemplateAreasValue>())).mRefCnt as *const _
                            as usize
                    },
                    24usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GridTemplateAreasValue),
                        "::",
                        stringify!(mRefCnt)
                    )
                );
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct RGBAColorData {
                pub mR: f32,
                pub mG: f32,
                pub mB: f32,
                pub mA: f32,
            }
            #[test]
            fn bindgen_test_layout_RGBAColorData() {
                assert_eq!(
                    ::std::mem::size_of::<RGBAColorData>(),
                    16usize,
                    concat!("Size of: ", stringify!(RGBAColorData))
                );
                assert_eq!(
                    ::std::mem::align_of::<RGBAColorData>(),
                    4usize,
                    concat!("Alignment of ", stringify!(RGBAColorData))
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<RGBAColorData>())).mR as *const _ as usize },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(RGBAColorData),
                        "::",
                        stringify!(mR)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<RGBAColorData>())).mG as *const _ as usize },
                    4usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(RGBAColorData),
                        "::",
                        stringify!(mG)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<RGBAColorData>())).mB as *const _ as usize },
                    8usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(RGBAColorData),
                        "::",
                        stringify!(mB)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<RGBAColorData>())).mA as *const _ as usize },
                    12usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(RGBAColorData),
                        "::",
                        stringify!(mA)
                    )
                );
            }
            impl Clone for RGBAColorData {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct ComplexColorData {
                pub mColor: root::mozilla::css::RGBAColorData,
                pub mForegroundRatio: f32,
            }
            #[test]
            fn bindgen_test_layout_ComplexColorData() {
                assert_eq!(
                    ::std::mem::size_of::<ComplexColorData>(),
                    20usize,
                    concat!("Size of: ", stringify!(ComplexColorData))
                );
                assert_eq!(
                    ::std::mem::align_of::<ComplexColorData>(),
                    4usize,
                    concat!("Alignment of ", stringify!(ComplexColorData))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ComplexColorData>())).mColor as *const _ as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ComplexColorData),
                        "::",
                        stringify!(mColor)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ComplexColorData>())).mForegroundRatio as *const _
                            as usize
                    },
                    16usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ComplexColorData),
                        "::",
                        stringify!(mForegroundRatio)
                    )
                );
            }
            impl Clone for ComplexColorData {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug)]
            pub struct ComplexColorValue {
                pub _base: root::mozilla::css::ComplexColorData,
                pub mRefCnt: root::nsAutoRefCnt,
            }
            pub type ComplexColorValue_HasThreadSafeRefCnt = root::mozilla::FalseType;
            #[test]
            fn bindgen_test_layout_ComplexColorValue() {
                assert_eq!(
                    ::std::mem::size_of::<ComplexColorValue>(),
                    32usize,
                    concat!("Size of: ", stringify!(ComplexColorValue))
                );
                assert_eq!(
                    ::std::mem::align_of::<ComplexColorValue>(),
                    8usize,
                    concat!("Alignment of ", stringify!(ComplexColorValue))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ComplexColorValue>())).mRefCnt as *const _ as usize
                    },
                    24usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ComplexColorValue),
                        "::",
                        stringify!(mRefCnt)
                    )
                );
            }
            /// Style sheet reuse *
            #[repr(C)]
            pub struct LoaderReusableStyleSheets {
                pub mReusableSheets: root::nsTArray<root::RefPtr<root::mozilla::StyleSheet>>,
            }
            #[test]
            fn bindgen_test_layout_LoaderReusableStyleSheets() {
                assert_eq!(
                    ::std::mem::size_of::<LoaderReusableStyleSheets>(),
                    8usize,
                    concat!("Size of: ", stringify!(LoaderReusableStyleSheets))
                );
                assert_eq!(
                    ::std::mem::align_of::<LoaderReusableStyleSheets>(),
                    8usize,
                    concat!("Alignment of ", stringify!(LoaderReusableStyleSheets))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<LoaderReusableStyleSheets>())).mReusableSheets
                            as *const _ as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(LoaderReusableStyleSheets),
                        "::",
                        stringify!(mReusableSheets)
                    )
                );
            }
            #[repr(C)]
            pub struct Loader {
                pub mRefCnt: root::nsCycleCollectingAutoRefCnt,
                pub mSheets: root::nsAutoPtr<root::mozilla::css::Loader_Sheets>,
                pub mPostedEvents: root::mozilla::css::Loader_LoadDataArray,
                pub mObservers: [u64; 2usize],
                pub mDocument: *mut root::nsIDocument,
                pub mDocGroup: root::RefPtr<root::mozilla::dom::DocGroup>,
                pub mDatasToNotifyOn: u32,
                pub mCompatMode: root::nsCompatibility,
                pub mPreferredSheet: ::nsstring::nsStringRepr,
                pub mStyleBackendType: [u8; 2usize],
                pub mEnabled: bool,
                pub mReporter: root::nsCOMPtr,
            }
            pub use self :: super :: super :: super :: root :: mozilla :: net :: ReferrerPolicy as Loader_ReferrerPolicy;
            pub type Loader_HasThreadSafeRefCnt = root::mozilla::FalseType;
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct Loader_cycleCollection {
                pub _base: root::nsCycleCollectionParticipant,
            }
            #[test]
            fn bindgen_test_layout_Loader_cycleCollection() {
                assert_eq!(
                    ::std::mem::size_of::<Loader_cycleCollection>(),
                    16usize,
                    concat!("Size of: ", stringify!(Loader_cycleCollection))
                );
                assert_eq!(
                    ::std::mem::align_of::<Loader_cycleCollection>(),
                    8usize,
                    concat!("Alignment of ", stringify!(Loader_cycleCollection))
                );
            }
            impl Clone for Loader_cycleCollection {
                fn clone(&self) -> Self {
                    *self
                }
            }
            pub type Loader_LoadDataArray =
                root::nsTArray<root::RefPtr<root::mozilla::css::SheetLoadData>>;
            #[repr(C)]
            #[derive(Debug)]
            pub struct Loader_Sheets {
                pub mCompleteSheets: [u64; 4usize],
                pub mLoadingDatas: [u64; 4usize],
                pub mPendingDatas: [u64; 4usize],
            }
            #[test]
            fn bindgen_test_layout_Loader_Sheets() {
                assert_eq!(
                    ::std::mem::size_of::<Loader_Sheets>(),
                    96usize,
                    concat!("Size of: ", stringify!(Loader_Sheets))
                );
                assert_eq!(
                    ::std::mem::align_of::<Loader_Sheets>(),
                    8usize,
                    concat!("Alignment of ", stringify!(Loader_Sheets))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<Loader_Sheets>())).mCompleteSheets as *const _
                            as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Loader_Sheets),
                        "::",
                        stringify!(mCompleteSheets)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<Loader_Sheets>())).mLoadingDatas as *const _ as usize
                    },
                    32usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Loader_Sheets),
                        "::",
                        stringify!(mLoadingDatas)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<Loader_Sheets>())).mPendingDatas as *const _ as usize
                    },
                    64usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Loader_Sheets),
                        "::",
                        stringify!(mPendingDatas)
                    )
                );
            }
            extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3css6Loader21_cycleCollectorGlobalE"]
                pub static mut Loader__cycleCollectorGlobal:
                    root::mozilla::css::Loader_cycleCollection;
            }
            #[test]
            fn bindgen_test_layout_Loader() {
                assert_eq!(
                    ::std::mem::size_of::<Loader>(),
                    96usize,
                    concat!("Size of: ", stringify!(Loader))
                );
                assert_eq!(
                    ::std::mem::align_of::<Loader>(),
                    8usize,
                    concat!("Alignment of ", stringify!(Loader))
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<Loader>())).mRefCnt as *const _ as usize },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Loader),
                        "::",
                        stringify!(mRefCnt)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<Loader>())).mSheets as *const _ as usize },
                    8usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Loader),
                        "::",
                        stringify!(mSheets)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<Loader>())).mPostedEvents as *const _ as usize
                    },
                    16usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Loader),
                        "::",
                        stringify!(mPostedEvents)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<Loader>())).mObservers as *const _ as usize },
                    24usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Loader),
                        "::",
                        stringify!(mObservers)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<Loader>())).mDocument as *const _ as usize },
                    40usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Loader),
                        "::",
                        stringify!(mDocument)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<Loader>())).mDocGroup as *const _ as usize },
                    48usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Loader),
                        "::",
                        stringify!(mDocGroup)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<Loader>())).mDatasToNotifyOn as *const _ as usize
                    },
                    56usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Loader),
                        "::",
                        stringify!(mDatasToNotifyOn)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<Loader>())).mCompatMode as *const _ as usize },
                    60usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Loader),
                        "::",
                        stringify!(mCompatMode)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<Loader>())).mPreferredSheet as *const _ as usize
                    },
                    64usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Loader),
                        "::",
                        stringify!(mPreferredSheet)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<Loader>())).mStyleBackendType as *const _ as usize
                    },
                    80usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Loader),
                        "::",
                        stringify!(mStyleBackendType)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<Loader>())).mEnabled as *const _ as usize },
                    82usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Loader),
                        "::",
                        stringify!(mEnabled)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<Loader>())).mReporter as *const _ as usize },
                    88usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Loader),
                        "::",
                        stringify!(mReporter)
                    )
                );
            }
            #[repr(C)]
            pub struct SheetLoadData {
                pub _base: root::nsIRunnable,
                pub _base_1: root::nsIUnicharStreamLoaderObserver,
                pub _base_2: root::nsIThreadObserver,
                pub mRefCnt: root::nsAutoRefCnt,
                pub mLoader: root::RefPtr<root::mozilla::css::Loader>,
                pub mTitle: ::nsstring::nsStringRepr,
                pub mEncoding: *const root::mozilla::Encoding,
                pub mURI: root::nsCOMPtr,
                pub mLineNumber: u32,
                pub mSheet: root::RefPtr<root::mozilla::StyleSheet>,
                pub mNext: *mut root::mozilla::css::SheetLoadData,
                pub mParentData: root::RefPtr<root::mozilla::css::SheetLoadData>,
                pub mPendingChildren: u32,
                pub _bitfield_1: root::__BindgenBitfieldUnit<[u8; 2usize], u8>,
                pub mOwningElement: root::nsCOMPtr,
                pub mObserver: root::nsCOMPtr,
                pub mLoaderPrincipal: root::nsCOMPtr,
                pub mRequestingNode: root::nsCOMPtr,
                pub mPreloadEncoding: *const root::mozilla::Encoding,
                pub mStatus: root::nsresult,
            }
            pub type SheetLoadData_HasThreadSafeRefCnt = root::mozilla::FalseType;
            #[test]
            fn bindgen_test_layout_SheetLoadData() {
                assert_eq!(
                    ::std::mem::size_of::<SheetLoadData>(),
                    160usize,
                    concat!("Size of: ", stringify!(SheetLoadData))
                );
                assert_eq!(
                    ::std::mem::align_of::<SheetLoadData>(),
                    8usize,
                    concat!("Alignment of ", stringify!(SheetLoadData))
                );
            }
            impl SheetLoadData {
                #[inline]
                pub fn mSyncLoad(&self) -> bool {
                    unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
                }
                #[inline]
                pub fn set_mSyncLoad(&mut self, val: bool) {
                    unsafe {
                        let val: u8 = ::std::mem::transmute(val);
                        self._bitfield_1.set(0usize, 1u8, val as u64)
                    }
                }
                #[inline]
                pub fn mIsNonDocumentSheet(&self) -> bool {
                    unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
                }
                #[inline]
                pub fn set_mIsNonDocumentSheet(&mut self, val: bool) {
                    unsafe {
                        let val: u8 = ::std::mem::transmute(val);
                        self._bitfield_1.set(1usize, 1u8, val as u64)
                    }
                }
                #[inline]
                pub fn mIsLoading(&self) -> bool {
                    unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
                }
                #[inline]
                pub fn set_mIsLoading(&mut self, val: bool) {
                    unsafe {
                        let val: u8 = ::std::mem::transmute(val);
                        self._bitfield_1.set(2usize, 1u8, val as u64)
                    }
                }
                #[inline]
                pub fn mIsBeingParsed(&self) -> bool {
                    unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
                }
                #[inline]
                pub fn set_mIsBeingParsed(&mut self, val: bool) {
                    unsafe {
                        let val: u8 = ::std::mem::transmute(val);
                        self._bitfield_1.set(3usize, 1u8, val as u64)
                    }
                }
                #[inline]
                pub fn mIsCancelled(&self) -> bool {
                    unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
                }
                #[inline]
                pub fn set_mIsCancelled(&mut self, val: bool) {
                    unsafe {
                        let val: u8 = ::std::mem::transmute(val);
                        self._bitfield_1.set(4usize, 1u8, val as u64)
                    }
                }
                #[inline]
                pub fn mMustNotify(&self) -> bool {
                    unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
                }
                #[inline]
                pub fn set_mMustNotify(&mut self, val: bool) {
                    unsafe {
                        let val: u8 = ::std::mem::transmute(val);
                        self._bitfield_1.set(5usize, 1u8, val as u64)
                    }
                }
                #[inline]
                pub fn mWasAlternate(&self) -> bool {
                    unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
                }
                #[inline]
                pub fn set_mWasAlternate(&mut self, val: bool) {
                    unsafe {
                        let val: u8 = ::std::mem::transmute(val);
                        self._bitfield_1.set(6usize, 1u8, val as u64)
                    }
                }
                #[inline]
                pub fn mUseSystemPrincipal(&self) -> bool {
                    unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
                }
                #[inline]
                pub fn set_mUseSystemPrincipal(&mut self, val: bool) {
                    unsafe {
                        let val: u8 = ::std::mem::transmute(val);
                        self._bitfield_1.set(7usize, 1u8, val as u64)
                    }
                }
                #[inline]
                pub fn mSheetAlreadyComplete(&self) -> bool {
                    unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u8) }
                }
                #[inline]
                pub fn set_mSheetAlreadyComplete(&mut self, val: bool) {
                    unsafe {
                        let val: u8 = ::std::mem::transmute(val);
                        self._bitfield_1.set(8usize, 1u8, val as u64)
                    }
                }
                #[inline]
                pub fn mIsCrossOriginNoCORS(&self) -> bool {
                    unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u8) }
                }
                #[inline]
                pub fn set_mIsCrossOriginNoCORS(&mut self, val: bool) {
                    unsafe {
                        let val: u8 = ::std::mem::transmute(val);
                        self._bitfield_1.set(9usize, 1u8, val as u64)
                    }
                }
                #[inline]
                pub fn mBlockResourceTiming(&self) -> bool {
                    unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u8) }
                }
                #[inline]
                pub fn set_mBlockResourceTiming(&mut self, val: bool) {
                    unsafe {
                        let val: u8 = ::std::mem::transmute(val);
                        self._bitfield_1.set(10usize, 1u8, val as u64)
                    }
                }
                #[inline]
                pub fn new_bitfield_1(
                    mSyncLoad: bool,
                    mIsNonDocumentSheet: bool,
                    mIsLoading: bool,
                    mIsBeingParsed: bool,
                    mIsCancelled: bool,
                    mMustNotify: bool,
                    mWasAlternate: bool,
                    mUseSystemPrincipal: bool,
                    mSheetAlreadyComplete: bool,
                    mIsCrossOriginNoCORS: bool,
                    mBlockResourceTiming: bool,
                ) -> root::__BindgenBitfieldUnit<[u8; 2usize], u8> {
                    let mut __bindgen_bitfield_unit : root :: __BindgenBitfieldUnit < [ u8 ; 2usize ] , u8 > = Default :: default ( ) ;
                    __bindgen_bitfield_unit.set(0usize, 1u8, {
                        let mSyncLoad: u8 = unsafe { ::std::mem::transmute(mSyncLoad) };
                        mSyncLoad as u64
                    });
                    __bindgen_bitfield_unit.set(1usize, 1u8, {
                        let mIsNonDocumentSheet: u8 =
                            unsafe { ::std::mem::transmute(mIsNonDocumentSheet) };
                        mIsNonDocumentSheet as u64
                    });
                    __bindgen_bitfield_unit.set(2usize, 1u8, {
                        let mIsLoading: u8 = unsafe { ::std::mem::transmute(mIsLoading) };
                        mIsLoading as u64
                    });
                    __bindgen_bitfield_unit.set(3usize, 1u8, {
                        let mIsBeingParsed: u8 = unsafe { ::std::mem::transmute(mIsBeingParsed) };
                        mIsBeingParsed as u64
                    });
                    __bindgen_bitfield_unit.set(4usize, 1u8, {
                        let mIsCancelled: u8 = unsafe { ::std::mem::transmute(mIsCancelled) };
                        mIsCancelled as u64
                    });
                    __bindgen_bitfield_unit.set(5usize, 1u8, {
                        let mMustNotify: u8 = unsafe { ::std::mem::transmute(mMustNotify) };
                        mMustNotify as u64
                    });
                    __bindgen_bitfield_unit.set(6usize, 1u8, {
                        let mWasAlternate: u8 = unsafe { ::std::mem::transmute(mWasAlternate) };
                        mWasAlternate as u64
                    });
                    __bindgen_bitfield_unit.set(7usize, 1u8, {
                        let mUseSystemPrincipal: u8 =
                            unsafe { ::std::mem::transmute(mUseSystemPrincipal) };
                        mUseSystemPrincipal as u64
                    });
                    __bindgen_bitfield_unit.set(8usize, 1u8, {
                        let mSheetAlreadyComplete: u8 =
                            unsafe { ::std::mem::transmute(mSheetAlreadyComplete) };
                        mSheetAlreadyComplete as u64
                    });
                    __bindgen_bitfield_unit.set(9usize, 1u8, {
                        let mIsCrossOriginNoCORS: u8 =
                            unsafe { ::std::mem::transmute(mIsCrossOriginNoCORS) };
                        mIsCrossOriginNoCORS as u64
                    });
                    __bindgen_bitfield_unit.set(10usize, 1u8, {
                        let mBlockResourceTiming: u8 =
                            unsafe { ::std::mem::transmute(mBlockResourceTiming) };
                        mBlockResourceTiming as u64
                    });
                    __bindgen_bitfield_unit
                }
            }
            #[repr(C)]
            #[derive(Debug)]
            pub struct Rule {
                pub _base: root::nsISupports,
                pub _base_1: root::nsWrapperCache,
                pub mRefCnt: root::nsCycleCollectingAutoRefCnt,
                pub mSheet: *mut root::mozilla::StyleSheet,
                pub mParentRule: *mut root::mozilla::css::GroupRule,
                pub mLineNumber: u32,
                pub mColumnNumber: u32,
            }
            pub type Rule_HasThreadSafeRefCnt = root::mozilla::FalseType;
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct Rule_cycleCollection {
                pub _base: root::nsXPCOMCycleCollectionParticipant,
            }
            #[test]
            fn bindgen_test_layout_Rule_cycleCollection() {
                assert_eq!(
                    ::std::mem::size_of::<Rule_cycleCollection>(),
                    16usize,
                    concat!("Size of: ", stringify!(Rule_cycleCollection))
                );
                assert_eq!(
                    ::std::mem::align_of::<Rule_cycleCollection>(),
                    8usize,
                    concat!("Alignment of ", stringify!(Rule_cycleCollection))
                );
            }
            impl Clone for Rule_cycleCollection {
                fn clone(&self) -> Self {
                    *self
                }
            }
            pub const Rule_UNKNOWN_RULE: root::mozilla::css::Rule__bindgen_ty_1 = 0;
            pub const Rule_CHARSET_RULE: root::mozilla::css::Rule__bindgen_ty_1 = 1;
            pub const Rule_IMPORT_RULE: root::mozilla::css::Rule__bindgen_ty_1 = 2;
            pub const Rule_NAMESPACE_RULE: root::mozilla::css::Rule__bindgen_ty_1 = 3;
            pub const Rule_STYLE_RULE: root::mozilla::css::Rule__bindgen_ty_1 = 4;
            pub const Rule_MEDIA_RULE: root::mozilla::css::Rule__bindgen_ty_1 = 5;
            pub const Rule_FONT_FACE_RULE: root::mozilla::css::Rule__bindgen_ty_1 = 6;
            pub const Rule_PAGE_RULE: root::mozilla::css::Rule__bindgen_ty_1 = 7;
            pub const Rule_KEYFRAME_RULE: root::mozilla::css::Rule__bindgen_ty_1 = 8;
            pub const Rule_KEYFRAMES_RULE: root::mozilla::css::Rule__bindgen_ty_1 = 9;
            pub const Rule_DOCUMENT_RULE: root::mozilla::css::Rule__bindgen_ty_1 = 10;
            pub const Rule_SUPPORTS_RULE: root::mozilla::css::Rule__bindgen_ty_1 = 11;
            pub const Rule_FONT_FEATURE_VALUES_RULE: root::mozilla::css::Rule__bindgen_ty_1 = 12;
            pub const Rule_COUNTER_STYLE_RULE: root::mozilla::css::Rule__bindgen_ty_1 = 13;
            pub type Rule__bindgen_ty_1 = u32;
            extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3css4Rule21_cycleCollectorGlobalE"]
                pub static mut Rule__cycleCollectorGlobal: root::mozilla::css::Rule_cycleCollection;
            }
            #[test]
            fn bindgen_test_layout_Rule() {
                assert_eq!(
                    ::std::mem::size_of::<Rule>(),
                    64usize,
                    concat!("Size of: ", stringify!(Rule))
                );
                assert_eq!(
                    ::std::mem::align_of::<Rule>(),
                    8usize,
                    concat!("Alignment of ", stringify!(Rule))
                );
            }
            #[repr(C)]
            pub struct ErrorReporter {
                pub mError: root::nsAutoString,
                pub mErrorLine: ::nsstring::nsStringRepr,
                pub mFileName: ::nsstring::nsStringRepr,
                pub mScanner: *const root::nsCSSScanner,
                pub mSheet: *const root::mozilla::StyleSheet,
                pub mLoader: *const root::mozilla::css::Loader,
                pub mURI: *mut root::nsIURI,
                pub mInnerWindowID: u64,
                pub mErrorLineNumber: u32,
                pub mPrevErrorLineNumber: u32,
                pub mErrorColNumber: u32,
            }
            #[test]
            fn bindgen_test_layout_ErrorReporter() {
                assert_eq!(
                    ::std::mem::size_of::<ErrorReporter>(),
                    240usize,
                    concat!("Size of: ", stringify!(ErrorReporter))
                );
                assert_eq!(
                    ::std::mem::align_of::<ErrorReporter>(),
                    8usize,
                    concat!("Alignment of ", stringify!(ErrorReporter))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ErrorReporter>())).mError as *const _ as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ErrorReporter),
                        "::",
                        stringify!(mError)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ErrorReporter>())).mErrorLine as *const _ as usize
                    },
                    152usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ErrorReporter),
                        "::",
                        stringify!(mErrorLine)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ErrorReporter>())).mFileName as *const _ as usize
                    },
                    168usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ErrorReporter),
                        "::",
                        stringify!(mFileName)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ErrorReporter>())).mScanner as *const _ as usize
                    },
                    184usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ErrorReporter),
                        "::",
                        stringify!(mScanner)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ErrorReporter>())).mSheet as *const _ as usize
                    },
                    192usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ErrorReporter),
                        "::",
                        stringify!(mSheet)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ErrorReporter>())).mLoader as *const _ as usize
                    },
                    200usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ErrorReporter),
                        "::",
                        stringify!(mLoader)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<ErrorReporter>())).mURI as *const _ as usize },
                    208usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ErrorReporter),
                        "::",
                        stringify!(mURI)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ErrorReporter>())).mInnerWindowID as *const _
                            as usize
                    },
                    216usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ErrorReporter),
                        "::",
                        stringify!(mInnerWindowID)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ErrorReporter>())).mErrorLineNumber as *const _
                            as usize
                    },
                    224usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ErrorReporter),
                        "::",
                        stringify!(mErrorLineNumber)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ErrorReporter>())).mPrevErrorLineNumber as *const _
                            as usize
                    },
                    228usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ErrorReporter),
                        "::",
                        stringify!(mPrevErrorLineNumber)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ErrorReporter>())).mErrorColNumber as *const _
                            as usize
                    },
                    232usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ErrorReporter),
                        "::",
                        stringify!(mErrorColNumber)
                    )
                );
            }
            #[repr(i32)]
            /// Enum defining the type of URL matching function for a @-moz-document rule
            /// condition.
            #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
            pub enum URLMatchingFunction {
                eURL = 0,
                eURLPrefix = 1,
                eDomain = 2,
                eRegExp = 3,
            }
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct ThreadSafeAutoRefCnt {
            pub mValue: u64,
        }
        pub const ThreadSafeAutoRefCnt_isThreadSafe: bool = true;
        #[test]
        fn bindgen_test_layout_ThreadSafeAutoRefCnt() {
            assert_eq!(
                ::std::mem::size_of::<ThreadSafeAutoRefCnt>(),
                8usize,
                concat!("Size of: ", stringify!(ThreadSafeAutoRefCnt))
            );
            assert_eq!(
                ::std::mem::align_of::<ThreadSafeAutoRefCnt>(),
                8usize,
                concat!("Alignment of ", stringify!(ThreadSafeAutoRefCnt))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ThreadSafeAutoRefCnt>())).mValue as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ThreadSafeAutoRefCnt),
                    "::",
                    stringify!(mValue)
                )
            );
        }
        pub type EnumeratedArray_ArrayType = u8;
        pub type EnumeratedArray_iterator = root::mozilla::EnumeratedArray_ArrayType;
        pub type EnumeratedArray_const_iterator = root::mozilla::EnumeratedArray_ArrayType;
        pub type EnumeratedArray_reverse_iterator = root::mozilla::EnumeratedArray_ArrayType;
        pub type EnumeratedArray_const_reverse_iterator = root::mozilla::EnumeratedArray_ArrayType;
        #[repr(C)]
        #[derive(Debug)]
        pub struct LinkedListElement {
            pub mNext: *mut root::mozilla::LinkedListElement,
            pub mPrev: *mut root::mozilla::LinkedListElement,
            pub mIsSentinel: bool,
        }
        pub type LinkedListElement_Traits = root::mozilla::detail::LinkedListElementTraits;
        pub type LinkedListElement_RawType = root::mozilla::LinkedListElement_Traits;
        pub type LinkedListElement_ConstRawType = root::mozilla::LinkedListElement_Traits;
        pub type LinkedListElement_ClientType = root::mozilla::LinkedListElement_Traits;
        pub type LinkedListElement_ConstClientType = root::mozilla::LinkedListElement_Traits;
        pub const LinkedListElement_NodeKind_Normal: root::mozilla::LinkedListElement_NodeKind = 0;
        pub const LinkedListElement_NodeKind_Sentinel: root::mozilla::LinkedListElement_NodeKind =
            0;
        pub type LinkedListElement_NodeKind = i32;
        #[repr(C)]
        #[derive(Debug)]
        pub struct LinkedList {
            pub sentinel: root::mozilla::LinkedListElement,
        }
        pub type LinkedList_Traits = root::mozilla::detail::LinkedListElementTraits;
        pub type LinkedList_RawType = root::mozilla::LinkedList_Traits;
        pub type LinkedList_ConstRawType = root::mozilla::LinkedList_Traits;
        pub type LinkedList_ClientType = root::mozilla::LinkedList_Traits;
        pub type LinkedList_ConstClientType = root::mozilla::LinkedList_Traits;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct LinkedList_Iterator {
            pub mCurrent: root::mozilla::LinkedList_RawType,
        }
        /// # mozilla::Variant
        ///
        /// A variant / tagged union / heterogenous disjoint union / sum-type template
        /// class. Similar in concept to (but not derived from) `boost::variant`.
        ///
        /// Sometimes, you may wish to use a C union with non-POD types. However, this is
        /// forbidden in C++ because it is not clear which type in the union should have
        /// its constructor and destructor run on creation and deletion
        /// respectively. This is the problem that `mozilla::Variant` solves.
        ///
        /// ## Usage
        ///
        /// A `mozilla::Variant` instance is constructed (via move or copy) from one of
        /// its variant types (ignoring const and references). It does *not* support
        /// construction from subclasses of variant types or types that coerce to one of
        /// the variant types.
        ///
        /// Variant<char, uint32_t> v1('a');
        /// Variant<UniquePtr<A>, B, C> v2(MakeUnique<A>());
        /// Variant<bool, char> v3(VariantType<char>, 0); // disambiguation needed
        /// Variant<int, int> v4(VariantIndex<1>, 0); // 2nd int
        ///
        /// Because specifying the full type of a Variant value is often verbose,
        /// there are two easier ways to construct values:
        ///
        /// A. AsVariant() can be used to construct a Variant value using type inference
        /// in contexts such as expressions or when returning values from functions.
        /// Because AsVariant() must copy or move the value into a temporary and this
        /// cannot necessarily be elided by the compiler, it's mostly appropriate only
        /// for use with primitive or very small types.
        ///
        /// Variant<char, uint32_t> Foo() { return AsVariant('x'); }
        /// // ...
        /// Variant<char, uint32_t> v1 = Foo();  // v1 holds char('x').
        ///
        /// B. Brace-construction with VariantType or VariantIndex; this also allows
        /// in-place construction with any number of arguments.
        ///
        /// struct AB { AB(int, int){...} };
        /// static Variant<AB, bool> foo()
        /// {
        /// return {VariantIndex<0>{}, 1, 2};
        /// }
        /// // ...
        /// Variant<AB, bool> v0 = Foo();  // v0 holds AB(1,2).
        ///
        /// All access to the contained value goes through type-safe accessors.
        /// Either the stored type, or the type index may be provided.
        ///
        /// void
        /// Foo(Variant<A, B, C> v)
        /// {
        /// if (v.is<A>()) {
        /// A& ref = v.as<A>();
        /// ...
        /// } else (v.is<1>()) { // Instead of v.is<B>.
        /// ...
        /// } else {
        /// ...
        /// }
        /// }
        ///
        /// In some situation, a Variant may be constructed from templated types, in
        /// which case it is possible that the same type could be given multiple times by
        /// an external developer. Or seemingly-different types could be aliases.
        /// In this case, repeated types can only be accessed through their index, to
        /// prevent ambiguous access by type.
        ///
        /// // Bad!
        /// template <typename T>
        /// struct ResultOrError
        /// {
        /// Variant<T, int> m;
        /// ResultOrError() : m(int(0)) {} // Error '0' by default
        /// ResultOrError(const T& r) : m(r) {}
        /// bool IsResult() const { return m.is<T>(); }
        /// bool IsError() const { return m.is<int>(); }
        /// };
        /// // Now instantiante with the result being an int too:
        /// ResultOrError<int> myResult(123); // Fail!
        /// // In Variant<int, int>, which 'int' are we refering to, from inside
        /// // ResultOrError functions?
        ///
        /// // Good!
        /// template <typename T>
        /// struct ResultOrError
        /// {
        /// Variant<T, int> m;
        /// ResultOrError() : m(VariantIndex<1>{}, 0) {} // Error '0' by default
        /// ResultOrError(const T& r) : m(VariantIndex<0>{}, r) {}
        /// bool IsResult() const { return m.is<0>(); } // 0 -> T
        /// bool IsError() const { return m.is<1>(); } // 1 -> int
        /// };
        /// // Now instantiante with the result being an int too:
        /// ResultOrError<int> myResult(123); // It now works!
        ///
        /// Attempting to use the contained value as type `T1` when the `Variant`
        /// instance contains a value of type `T2` causes an assertion failure.
        ///
        /// A a;
        /// Variant<A, B, C> v(a);
        /// v.as<B>(); // <--- Assertion failure!
        ///
        /// Trying to use a `Variant<Ts...>` instance as some type `U` that is not a
        /// member of the set of `Ts...` is a compiler error.
        ///
        /// A a;
        /// Variant<A, B, C> v(a);
        /// v.as<SomeRandomType>(); // <--- Compiler error!
        ///
        /// Additionally, you can turn a `Variant` that `is<T>` into a `T` by moving it
        /// out of the containing `Variant` instance with the `extract<T>` method:
        ///
        /// Variant<UniquePtr<A>, B, C> v(MakeUnique<A>());
        /// auto ptr = v.extract<UniquePtr<A>>();
        ///
        /// Finally, you can exhaustively match on the contained variant and branch into
        /// different code paths depending on which type is contained. This is preferred
        /// to manually checking every variant type T with is<T>() because it provides
        /// compile-time checking that you handled every type, rather than runtime
        /// assertion failures.
        ///
        /// // Bad!
        /// char* foo(Variant<A, B, C, D>& v) {
        /// if (v.is<A>()) {
        /// return ...;
        /// } else if (v.is<B>()) {
        /// return ...;
        /// } else {
        /// return doSomething(v.as<C>()); // Forgot about case D!
        /// }
        /// }
        ///
        /// // Good!
        /// struct FooMatcher
        /// {
        /// // The return type of all matchers must be identical.
        /// char* match(A& a) { ... }
        /// char* match(B& b) { ... }
        /// char* match(C& c) { ... }
        /// char* match(D& d) { ... } // Compile-time error to forget D!
        /// }
        /// char* foo(Variant<A, B, C, D>& v) {
        /// return v.match(FooMatcher());
        /// }
        ///
        /// ## Examples
        ///
        /// A tree is either an empty leaf, or a node with a value and two children:
        ///
        /// struct Leaf { };
        ///
        /// template<typename T>
        /// struct Node
        /// {
        /// T value;
        /// Tree<T>* left;
        /// Tree<T>* right;
        /// };
        ///
        /// template<typename T>
        /// using Tree = Variant<Leaf, Node<T>>;
        ///
        /// A copy-on-write string is either a non-owning reference to some existing
        /// string, or an owning reference to our copy:
        ///
        /// class CopyOnWriteString
        /// {
        /// Variant<const char*, UniquePtr<char[]>> string;
        ///
        /// ...
        /// };
        ///
        /// Because Variant must be aligned suitable to hold any value stored within it,
        /// and because |alignas| requirements don't affect platform ABI with respect to
        /// how parameters are laid out in memory, Variant can't be used as the type of a
        /// function parameter.  Pass Variant to functions by pointer or reference
        /// instead.
        #[repr(C)]
        #[derive(Debug)]
        pub struct Variant {
            pub rawData: *mut ::std::os::raw::c_uchar,
            pub tag: root::mozilla::Variant_Tag,
        }
        pub type Variant_Tag = root::mozilla::detail::VariantTag;
        pub type Variant_Impl = u8;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct Maybe {
            pub _address: u8,
        }
        pub type Maybe_ValueType<T> = T;
        pub mod gfx {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            pub type Float = f32;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct IntPointTyped {
                pub _address: u8,
            }
            pub type IntPointTyped_ToInt = u32;
            pub type IntPointTyped_Coord = u8;
            pub type IntPointTyped_Super = u8;
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct FontVariation {
                pub mTag: u32,
                pub mValue: f32,
            }
            #[test]
            fn bindgen_test_layout_FontVariation() {
                assert_eq!(
                    ::std::mem::size_of::<FontVariation>(),
                    8usize,
                    concat!("Size of: ", stringify!(FontVariation))
                );
                assert_eq!(
                    ::std::mem::align_of::<FontVariation>(),
                    4usize,
                    concat!("Alignment of ", stringify!(FontVariation))
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<FontVariation>())).mTag as *const _ as usize },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(FontVariation),
                        "::",
                        stringify!(mTag)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<FontVariation>())).mValue as *const _ as usize
                    },
                    4usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(FontVariation),
                        "::",
                        stringify!(mValue)
                    )
                );
            }
            impl Clone for FontVariation {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct UserData {
                pub _bindgen_opaque_blob: [u64; 2usize],
            }
            pub type UserData_destroyFunc = u64;
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct UserData_Entry {
                pub _bindgen_opaque_blob: [u64; 3usize],
            }
            #[test]
            fn bindgen_test_layout_UserData_Entry() {
                assert_eq!(
                    ::std::mem::size_of::<UserData_Entry>(),
                    24usize,
                    concat!("Size of: ", stringify!(UserData_Entry))
                );
                assert_eq!(
                    ::std::mem::align_of::<UserData_Entry>(),
                    8usize,
                    concat!("Alignment of ", stringify!(UserData_Entry))
                );
            }
            impl Clone for UserData_Entry {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[test]
            fn bindgen_test_layout_UserData() {
                assert_eq!(
                    ::std::mem::size_of::<UserData>(),
                    16usize,
                    concat!("Size of: ", stringify!(UserData))
                );
                assert_eq!(
                    ::std::mem::align_of::<UserData>(),
                    8usize,
                    concat!("Alignment of ", stringify!(UserData))
                );
            }
            impl Clone for UserData {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            pub struct SourceSurface__bindgen_vtable(::std::os::raw::c_void);
            /// This is the base class for source surfaces. These objects are surfaces
            /// which may be used as a source in a SurfacePattern or a DrawSurface call.
            /// They cannot be drawn to directly.
            ///
            /// Although SourceSurface has thread-safe refcount, some SourceSurface cannot
            /// be used on random threads at the same time. Only DataSourceSurface can be
            /// used on random threads now. This will be fixed in the future. Eventually
            /// all SourceSurface should be thread-safe.
            #[repr(C)]
            #[derive(Debug)]
            pub struct SourceSurface {
                pub vtable_: *const SourceSurface__bindgen_vtable,
                pub _base: u64,
                pub mUserData: root::mozilla::gfx::UserData,
            }
            #[test]
            fn bindgen_test_layout_SourceSurface() {
                assert_eq!(
                    ::std::mem::size_of::<SourceSurface>(),
                    32usize,
                    concat!("Size of: ", stringify!(SourceSurface))
                );
                assert_eq!(
                    ::std::mem::align_of::<SourceSurface>(),
                    8usize,
                    concat!("Alignment of ", stringify!(SourceSurface))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<SourceSurface>())).mUserData as *const _ as usize
                    },
                    16usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(SourceSurface),
                        "::",
                        stringify!(mUserData)
                    )
                );
            }
        }
        pub mod layers {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct LayerManager {
                _unused: [u8; 0],
            }
            impl Clone for LayerManager {
                fn clone(&self) -> Self {
                    *self
                }
            }
        }
        pub mod dom {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct AllOwningUnionBase {
                pub _address: u8,
            }
            #[test]
            fn bindgen_test_layout_AllOwningUnionBase() {
                assert_eq!(
                    ::std::mem::size_of::<AllOwningUnionBase>(),
                    1usize,
                    concat!("Size of: ", stringify!(AllOwningUnionBase))
                );
                assert_eq!(
                    ::std::mem::align_of::<AllOwningUnionBase>(),
                    1usize,
                    concat!("Alignment of ", stringify!(AllOwningUnionBase))
                );
            }
            impl Clone for AllOwningUnionBase {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug)]
            pub struct GlobalObject {
                pub mGlobalJSObject: [u64; 3usize],
                pub mCx: *mut root::JSContext,
                pub mGlobalObject: *mut root::nsISupports,
            }
            #[test]
            fn bindgen_test_layout_GlobalObject() {
                assert_eq!(
                    ::std::mem::size_of::<GlobalObject>(),
                    40usize,
                    concat!("Size of: ", stringify!(GlobalObject))
                );
                assert_eq!(
                    ::std::mem::align_of::<GlobalObject>(),
                    8usize,
                    concat!("Alignment of ", stringify!(GlobalObject))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<GlobalObject>())).mGlobalJSObject as *const _
                            as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GlobalObject),
                        "::",
                        stringify!(mGlobalJSObject)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<GlobalObject>())).mCx as *const _ as usize },
                    24usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GlobalObject),
                        "::",
                        stringify!(mCx)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<GlobalObject>())).mGlobalObject as *const _ as usize
                    },
                    32usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GlobalObject),
                        "::",
                        stringify!(mGlobalObject)
                    )
                );
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct Sequence {
                pub _address: u8,
            }
            #[repr(u32)]
            #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
            pub enum CallerType {
                System = 0,
                NonSystem = 1,
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct Nullable {
                pub _address: u8,
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct Promise {
                _unused: [u8; 0],
            }
            impl Clone for Promise {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct ClientSource {
                _unused: [u8; 0],
            }
            impl Clone for ClientSource {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct CSSImportRule {
                _unused: [u8; 0],
            }
            impl Clone for CSSImportRule {
                fn clone(&self) -> Self {
                    *self
                }
            }
            /// Struct that stores info on an attribute. The name and value must either both
            /// be null or both be non-null.
            ///
            /// Note that, just as the pointers returned by GetAttrNameAt, the pointers that
            /// this struct hold are only valid until the element or its attributes are
            /// mutated (directly or via script).
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct BorrowedAttrInfo {
                pub mName: *const root::nsAttrName,
                pub mValue: *const root::nsAttrValue,
            }
            #[test]
            fn bindgen_test_layout_BorrowedAttrInfo() {
                assert_eq!(
                    ::std::mem::size_of::<BorrowedAttrInfo>(),
                    16usize,
                    concat!("Size of: ", stringify!(BorrowedAttrInfo))
                );
                assert_eq!(
                    ::std::mem::align_of::<BorrowedAttrInfo>(),
                    8usize,
                    concat!("Alignment of ", stringify!(BorrowedAttrInfo))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<BorrowedAttrInfo>())).mName as *const _ as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(BorrowedAttrInfo),
                        "::",
                        stringify!(mName)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<BorrowedAttrInfo>())).mValue as *const _ as usize
                    },
                    8usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(BorrowedAttrInfo),
                        "::",
                        stringify!(mValue)
                    )
                );
            }
            impl Clone for BorrowedAttrInfo {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            pub struct NodeInfo {
                pub mRefCnt: root::nsCycleCollectingAutoRefCnt,
                pub mDocument: *mut root::nsIDocument,
                pub mInner: root::mozilla::dom::NodeInfo_NodeInfoInner,
                pub mOwnerManager: root::RefPtr<root::nsNodeInfoManager>,
                pub mQualifiedName: ::nsstring::nsStringRepr,
                pub mNodeName: ::nsstring::nsStringRepr,
                pub mLocalName: ::nsstring::nsStringRepr,
            }
            pub type NodeInfo_HasThreadSafeRefCnt = root::mozilla::FalseType;
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct NodeInfo_cycleCollection {
                pub _base: root::nsCycleCollectionParticipant,
            }
            #[test]
            fn bindgen_test_layout_NodeInfo_cycleCollection() {
                assert_eq!(
                    ::std::mem::size_of::<NodeInfo_cycleCollection>(),
                    16usize,
                    concat!("Size of: ", stringify!(NodeInfo_cycleCollection))
                );
                assert_eq!(
                    ::std::mem::align_of::<NodeInfo_cycleCollection>(),
                    8usize,
                    concat!("Alignment of ", stringify!(NodeInfo_cycleCollection))
                );
            }
            impl Clone for NodeInfo_cycleCollection {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct NodeInfo_NodeInfoInner {
                pub mName: *const root::nsAtom,
                pub mPrefix: *mut root::nsAtom,
                pub mNamespaceID: i32,
                pub mNodeType: u16,
                pub mNameString: *const root::nsAString,
                pub mExtraName: *mut root::nsAtom,
                pub mHash: root::PLHashNumber,
                pub mHashInitialized: bool,
            }
            #[test]
            fn bindgen_test_layout_NodeInfo_NodeInfoInner() {
                assert_eq!(
                    ::std::mem::size_of::<NodeInfo_NodeInfoInner>(),
                    48usize,
                    concat!("Size of: ", stringify!(NodeInfo_NodeInfoInner))
                );
                assert_eq!(
                    ::std::mem::align_of::<NodeInfo_NodeInfoInner>(),
                    8usize,
                    concat!("Alignment of ", stringify!(NodeInfo_NodeInfoInner))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<NodeInfo_NodeInfoInner>())).mName as *const _
                            as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(NodeInfo_NodeInfoInner),
                        "::",
                        stringify!(mName)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<NodeInfo_NodeInfoInner>())).mPrefix as *const _
                            as usize
                    },
                    8usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(NodeInfo_NodeInfoInner),
                        "::",
                        stringify!(mPrefix)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<NodeInfo_NodeInfoInner>())).mNamespaceID as *const _
                            as usize
                    },
                    16usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(NodeInfo_NodeInfoInner),
                        "::",
                        stringify!(mNamespaceID)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<NodeInfo_NodeInfoInner>())).mNodeType as *const _
                            as usize
                    },
                    20usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(NodeInfo_NodeInfoInner),
                        "::",
                        stringify!(mNodeType)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<NodeInfo_NodeInfoInner>())).mNameString as *const _
                            as usize
                    },
                    24usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(NodeInfo_NodeInfoInner),
                        "::",
                        stringify!(mNameString)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<NodeInfo_NodeInfoInner>())).mExtraName as *const _
                            as usize
                    },
                    32usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(NodeInfo_NodeInfoInner),
                        "::",
                        stringify!(mExtraName)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<NodeInfo_NodeInfoInner>())).mHash as *const _
                            as usize
                    },
                    40usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(NodeInfo_NodeInfoInner),
                        "::",
                        stringify!(mHash)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<NodeInfo_NodeInfoInner>())).mHashInitialized
                            as *const _ as usize
                    },
                    44usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(NodeInfo_NodeInfoInner),
                        "::",
                        stringify!(mHashInitialized)
                    )
                );
            }
            impl Clone for NodeInfo_NodeInfoInner {
                fn clone(&self) -> Self {
                    *self
                }
            }
            extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom8NodeInfo21_cycleCollectorGlobalE"]
                pub static mut NodeInfo__cycleCollectorGlobal:
                    root::mozilla::dom::NodeInfo_cycleCollection;
            }
            #[test]
            fn bindgen_test_layout_NodeInfo() {
                assert_eq!(
                    ::std::mem::size_of::<NodeInfo>(),
                    120usize,
                    concat!("Size of: ", stringify!(NodeInfo))
                );
                assert_eq!(
                    ::std::mem::align_of::<NodeInfo>(),
                    8usize,
                    concat!("Alignment of ", stringify!(NodeInfo))
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<NodeInfo>())).mRefCnt as *const _ as usize },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(NodeInfo),
                        "::",
                        stringify!(mRefCnt)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<NodeInfo>())).mDocument as *const _ as usize },
                    8usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(NodeInfo),
                        "::",
                        stringify!(mDocument)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<NodeInfo>())).mInner as *const _ as usize },
                    16usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(NodeInfo),
                        "::",
                        stringify!(mInner)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<NodeInfo>())).mOwnerManager as *const _ as usize
                    },
                    64usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(NodeInfo),
                        "::",
                        stringify!(mOwnerManager)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<NodeInfo>())).mQualifiedName as *const _ as usize
                    },
                    72usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(NodeInfo),
                        "::",
                        stringify!(mQualifiedName)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<NodeInfo>())).mNodeName as *const _ as usize },
                    88usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(NodeInfo),
                        "::",
                        stringify!(mNodeName)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<NodeInfo>())).mLocalName as *const _ as usize },
                    104usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(NodeInfo),
                        "::",
                        stringify!(mLocalName)
                    )
                );
            }
            #[repr(C)]
            #[derive(Debug)]
            pub struct EventTarget {
                pub _base: root::nsIDOMEventTarget,
                pub _base_1: root::nsWrapperCache,
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct EventTarget_COMTypeInfo {
                pub _address: u8,
            }
            #[test]
            fn bindgen_test_layout_EventTarget() {
                assert_eq!(
                    ::std::mem::size_of::<EventTarget>(),
                    32usize,
                    concat!("Size of: ", stringify!(EventTarget))
                );
                assert_eq!(
                    ::std::mem::align_of::<EventTarget>(),
                    8usize,
                    concat!("Alignment of ", stringify!(EventTarget))
                );
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct BoxQuadOptions {
                _unused: [u8; 0],
            }
            impl Clone for BoxQuadOptions {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct ConvertCoordinateOptions {
                _unused: [u8; 0],
            }
            impl Clone for ConvertCoordinateOptions {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct DocGroup {
                _unused: [u8; 0],
            }
            impl Clone for DocGroup {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct DOMPoint {
                _unused: [u8; 0],
            }
            impl Clone for DOMPoint {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct DOMQuad {
                _unused: [u8; 0],
            }
            impl Clone for DOMQuad {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct TextOrElementOrDocument {
                _unused: [u8; 0],
            }
            impl Clone for TextOrElementOrDocument {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct DOMPointInit {
                _unused: [u8; 0],
            }
            impl Clone for DOMPointInit {
                fn clone(&self) -> Self {
                    *self
                }
            }
            pub const VisibilityState_Hidden: root::mozilla::dom::VisibilityState = 0;
            pub const VisibilityState_Visible: root::mozilla::dom::VisibilityState = 1;
            pub const VisibilityState_EndGuard_: root::mozilla::dom::VisibilityState = 2;
            pub type VisibilityState = u8;
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct IPCClientInfo {
                _unused: [u8; 0],
            }
            impl Clone for IPCClientInfo {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct TabGroup {
                _unused: [u8; 0],
            }
            impl Clone for TabGroup {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            pub struct DispatcherTrait__bindgen_vtable(::std::os::raw::c_void);
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct DispatcherTrait {
                pub vtable_: *const DispatcherTrait__bindgen_vtable,
            }
            #[test]
            fn bindgen_test_layout_DispatcherTrait() {
                assert_eq!(
                    ::std::mem::size_of::<DispatcherTrait>(),
                    8usize,
                    concat!("Size of: ", stringify!(DispatcherTrait))
                );
                assert_eq!(
                    ::std::mem::align_of::<DispatcherTrait>(),
                    8usize,
                    concat!("Alignment of ", stringify!(DispatcherTrait))
                );
            }
            impl Clone for DispatcherTrait {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct IPCServiceWorkerDescriptor {
                _unused: [u8; 0],
            }
            impl Clone for IPCServiceWorkerDescriptor {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct AudioContext {
                _unused: [u8; 0],
            }
            impl Clone for AudioContext {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct Navigator {
                _unused: [u8; 0],
            }
            impl Clone for Navigator {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct Performance {
                _unused: [u8; 0],
            }
            impl Clone for Performance {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct ServiceWorkerRegistration {
                _unused: [u8; 0],
            }
            impl Clone for ServiceWorkerRegistration {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct TimeoutManager {
                _unused: [u8; 0],
            }
            impl Clone for TimeoutManager {
                fn clone(&self) -> Self {
                    *self
                }
            }
            pub const LargeAllocStatus_NONE: root::mozilla::dom::LargeAllocStatus = 0;
            pub const LargeAllocStatus_SUCCESS: root::mozilla::dom::LargeAllocStatus = 1;
            pub const LargeAllocStatus_NON_GET: root::mozilla::dom::LargeAllocStatus = 2;
            pub const LargeAllocStatus_NON_E10S: root::mozilla::dom::LargeAllocStatus = 3;
            pub const LargeAllocStatus_NOT_ONLY_TOPLEVEL_IN_TABGROUP:
                root::mozilla::dom::LargeAllocStatus = 4;
            pub const LargeAllocStatus_NON_WIN32: root::mozilla::dom::LargeAllocStatus = 5;
            pub type LargeAllocStatus = u8;
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct StyleSheetList {
                _unused: [u8; 0],
            }
            impl Clone for StyleSheetList {
                fn clone(&self) -> Self {
                    *self
                }
            }
            /// A class meant to be shared by ShadowRoot and Document, that holds a list of
            /// stylesheets.
            ///
            /// TODO(emilio, bug 1418159): In the future this should hold most of the
            /// relevant style state, this should allow us to fix bug 548397.
            #[repr(C)]
            pub struct DocumentOrShadowRoot {
                pub mStyleSheets: root::nsTArray<root::RefPtr<root::mozilla::StyleSheet>>,
                pub mDOMStyleSheets: root::RefPtr<root::mozilla::dom::StyleSheetList>,
                pub mIdentifierMap: [u64; 4usize],
                pub mAsNode: *mut root::nsINode,
                pub mKind: root::mozilla::dom::DocumentOrShadowRoot_Kind,
            }
            pub const DocumentOrShadowRoot_Kind_Document:
                root::mozilla::dom::DocumentOrShadowRoot_Kind = 0;
            pub const DocumentOrShadowRoot_Kind_ShadowRoot:
                root::mozilla::dom::DocumentOrShadowRoot_Kind = 1;
            pub type DocumentOrShadowRoot_Kind = i32;
            pub const DocumentOrShadowRoot_ElementsFromPointFlags_IGNORE_ROOT_SCROLL_FRAME:
                root::mozilla::dom::DocumentOrShadowRoot_ElementsFromPointFlags = 1;
            pub const DocumentOrShadowRoot_ElementsFromPointFlags_FLUSH_LAYOUT:
                root::mozilla::dom::DocumentOrShadowRoot_ElementsFromPointFlags = 2;
            pub const DocumentOrShadowRoot_ElementsFromPointFlags_IS_ELEMENT_FROM_POINT:
                root::mozilla::dom::DocumentOrShadowRoot_ElementsFromPointFlags = 4;
            pub type DocumentOrShadowRoot_ElementsFromPointFlags = u32;
            #[test]
            fn bindgen_test_layout_DocumentOrShadowRoot() {
                assert_eq!(
                    ::std::mem::size_of::<DocumentOrShadowRoot>(),
                    64usize,
                    concat!("Size of: ", stringify!(DocumentOrShadowRoot))
                );
                assert_eq!(
                    ::std::mem::align_of::<DocumentOrShadowRoot>(),
                    8usize,
                    concat!("Alignment of ", stringify!(DocumentOrShadowRoot))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<DocumentOrShadowRoot>())).mStyleSheets as *const _
                            as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(DocumentOrShadowRoot),
                        "::",
                        stringify!(mStyleSheets)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<DocumentOrShadowRoot>())).mDOMStyleSheets as *const _
                            as usize
                    },
                    8usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(DocumentOrShadowRoot),
                        "::",
                        stringify!(mDOMStyleSheets)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<DocumentOrShadowRoot>())).mIdentifierMap as *const _
                            as usize
                    },
                    16usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(DocumentOrShadowRoot),
                        "::",
                        stringify!(mIdentifierMap)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<DocumentOrShadowRoot>())).mAsNode as *const _
                            as usize
                    },
                    48usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(DocumentOrShadowRoot),
                        "::",
                        stringify!(mAsNode)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<DocumentOrShadowRoot>())).mKind as *const _ as usize
                    },
                    56usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(DocumentOrShadowRoot),
                        "::",
                        stringify!(mKind)
                    )
                );
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct AnonymousContent {
                _unused: [u8; 0],
            }
            impl Clone for AnonymousContent {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct FontFaceSet {
                _unused: [u8; 0],
            }
            impl Clone for FontFaceSet {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct FullscreenRequest {
                _unused: [u8; 0],
            }
            impl Clone for FullscreenRequest {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct ImageTracker {
                _unused: [u8; 0],
            }
            impl Clone for ImageTracker {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct Link {
                _unused: [u8; 0],
            }
            impl Clone for Link {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct MediaQueryList {
                _unused: [u8; 0],
            }
            impl Clone for MediaQueryList {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct XPathEvaluator {
                _unused: [u8; 0],
            }
            impl Clone for XPathEvaluator {
                fn clone(&self) -> Self {
                    *self
                }
            }
            pub mod prototypes {
                #[allow(unused_imports)]
                use self::super::super::super::super::root;
            }
            pub mod constructors {
                #[allow(unused_imports)]
                use self::super::super::super::super::root;
            }
            pub mod namedpropertiesobjects {
                #[allow(unused_imports)]
                use self::super::super::super::super::root;
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct FrameRequestCallback {
                pub _bindgen_opaque_blob: [u64; 6usize],
            }
            #[test]
            fn bindgen_test_layout_FrameRequestCallback() {
                assert_eq!(
                    ::std::mem::size_of::<FrameRequestCallback>(),
                    48usize,
                    concat!("Size of: ", stringify!(FrameRequestCallback))
                );
                assert_eq!(
                    ::std::mem::align_of::<FrameRequestCallback>(),
                    8usize,
                    concat!("Alignment of ", stringify!(FrameRequestCallback))
                );
            }
            impl Clone for FrameRequestCallback {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            pub struct URLParams {
                pub mParams: root::nsTArray<root::mozilla::dom::URLParams_Param>,
            }
            #[repr(C)]
            pub struct URLParams_ForEachIterator__bindgen_vtable(::std::os::raw::c_void);
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct URLParams_ForEachIterator {
                pub vtable_: *const URLParams_ForEachIterator__bindgen_vtable,
            }
            #[test]
            fn bindgen_test_layout_URLParams_ForEachIterator() {
                assert_eq!(
                    ::std::mem::size_of::<URLParams_ForEachIterator>(),
                    8usize,
                    concat!("Size of: ", stringify!(URLParams_ForEachIterator))
                );
                assert_eq!(
                    ::std::mem::align_of::<URLParams_ForEachIterator>(),
                    8usize,
                    concat!("Alignment of ", stringify!(URLParams_ForEachIterator))
                );
            }
            impl Clone for URLParams_ForEachIterator {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            pub struct URLParams_Param {
                pub mKey: ::nsstring::nsStringRepr,
                pub mValue: ::nsstring::nsStringRepr,
            }
            #[test]
            fn bindgen_test_layout_URLParams_Param() {
                assert_eq!(
                    ::std::mem::size_of::<URLParams_Param>(),
                    32usize,
                    concat!("Size of: ", stringify!(URLParams_Param))
                );
                assert_eq!(
                    ::std::mem::align_of::<URLParams_Param>(),
                    8usize,
                    concat!("Alignment of ", stringify!(URLParams_Param))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<URLParams_Param>())).mKey as *const _ as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(URLParams_Param),
                        "::",
                        stringify!(mKey)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<URLParams_Param>())).mValue as *const _ as usize
                    },
                    16usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(URLParams_Param),
                        "::",
                        stringify!(mValue)
                    )
                );
            }
            #[test]
            fn bindgen_test_layout_URLParams() {
                assert_eq!(
                    ::std::mem::size_of::<URLParams>(),
                    8usize,
                    concat!("Size of: ", stringify!(URLParams))
                );
                assert_eq!(
                    ::std::mem::align_of::<URLParams>(),
                    8usize,
                    concat!("Alignment of ", stringify!(URLParams))
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<URLParams>())).mParams as *const _ as usize },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(URLParams),
                        "::",
                        stringify!(mParams)
                    )
                );
            }
            #[repr(C)]
            pub struct SRIMetadata {
                pub mHashes: root::nsTArray<root::nsCString>,
                pub mIntegrityString: ::nsstring::nsStringRepr,
                pub mAlgorithm: root::nsCString,
                pub mAlgorithmType: i8,
                pub mEmpty: bool,
            }
            pub const SRIMetadata_MAX_ALTERNATE_HASHES: u32 = 256;
            pub const SRIMetadata_UNKNOWN_ALGORITHM: i8 = -1;
            #[test]
            fn bindgen_test_layout_SRIMetadata() {
                assert_eq!(
                    ::std::mem::size_of::<SRIMetadata>(),
                    48usize,
                    concat!("Size of: ", stringify!(SRIMetadata))
                );
                assert_eq!(
                    ::std::mem::align_of::<SRIMetadata>(),
                    8usize,
                    concat!("Alignment of ", stringify!(SRIMetadata))
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<SRIMetadata>())).mHashes as *const _ as usize },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(SRIMetadata),
                        "::",
                        stringify!(mHashes)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<SRIMetadata>())).mIntegrityString as *const _
                            as usize
                    },
                    8usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(SRIMetadata),
                        "::",
                        stringify!(mIntegrityString)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<SRIMetadata>())).mAlgorithm as *const _ as usize
                    },
                    24usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(SRIMetadata),
                        "::",
                        stringify!(mAlgorithm)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<SRIMetadata>())).mAlgorithmType as *const _ as usize
                    },
                    40usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(SRIMetadata),
                        "::",
                        stringify!(mAlgorithmType)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<SRIMetadata>())).mEmpty as *const _ as usize },
                    41usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(SRIMetadata),
                        "::",
                        stringify!(mEmpty)
                    )
                );
            }
            #[repr(C)]
            #[derive(Debug)]
            pub struct OwningNodeOrString {
                pub mType: root::mozilla::dom::OwningNodeOrString_Type,
                pub mValue: root::mozilla::dom::OwningNodeOrString_Value,
            }
            pub const OwningNodeOrString_Type_eUninitialized:
                root::mozilla::dom::OwningNodeOrString_Type = 0;
            pub const OwningNodeOrString_Type_eNode: root::mozilla::dom::OwningNodeOrString_Type =
                1;
            pub const OwningNodeOrString_Type_eString: root::mozilla::dom::OwningNodeOrString_Type =
                2;
            pub type OwningNodeOrString_Type = u32;
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct OwningNodeOrString_Value {
                pub _bindgen_opaque_blob: [u64; 2usize],
            }
            #[test]
            fn bindgen_test_layout_OwningNodeOrString_Value() {
                assert_eq!(
                    ::std::mem::size_of::<OwningNodeOrString_Value>(),
                    16usize,
                    concat!("Size of: ", stringify!(OwningNodeOrString_Value))
                );
                assert_eq!(
                    ::std::mem::align_of::<OwningNodeOrString_Value>(),
                    8usize,
                    concat!("Alignment of ", stringify!(OwningNodeOrString_Value))
                );
            }
            impl Clone for OwningNodeOrString_Value {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[test]
            fn bindgen_test_layout_OwningNodeOrString() {
                assert_eq!(
                    ::std::mem::size_of::<OwningNodeOrString>(),
                    24usize,
                    concat!("Size of: ", stringify!(OwningNodeOrString))
                );
                assert_eq!(
                    ::std::mem::align_of::<OwningNodeOrString>(),
                    8usize,
                    concat!("Alignment of ", stringify!(OwningNodeOrString))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<OwningNodeOrString>())).mType as *const _ as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(OwningNodeOrString),
                        "::",
                        stringify!(mType)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<OwningNodeOrString>())).mValue as *const _ as usize
                    },
                    8usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(OwningNodeOrString),
                        "::",
                        stringify!(mValue)
                    )
                );
            }
            #[repr(u8)]
            #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
            pub enum FillMode {
                None = 0,
                Forwards = 1,
                Backwards = 2,
                Both = 3,
                Auto = 4,
                EndGuard_ = 5,
            }
            #[repr(u8)]
            #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
            pub enum PlaybackDirection {
                Normal = 0,
                Reverse = 1,
                Alternate = 2,
                Alternate_reverse = 3,
                EndGuard_ = 4,
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct XBLChildrenElement {
                _unused: [u8; 0],
            }
            impl Clone for XBLChildrenElement {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct CustomElementData {
                _unused: [u8; 0],
            }
            impl Clone for CustomElementData {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            pub struct FragmentOrElement {
                pub _base: root::nsIContent,
                pub mRefCnt: root::nsCycleCollectingAutoRefCnt,
                /// Array containing all attributes and children for this element
                pub mAttrsAndChildren: root::nsAttrAndChildArray,
            }
            pub type FragmentOrElement_HasThreadSafeRefCnt = root::mozilla::FalseType;
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct FragmentOrElement_cycleCollection {
                pub _base: root::nsXPCOMCycleCollectionParticipant,
            }
            #[test]
            fn bindgen_test_layout_FragmentOrElement_cycleCollection() {
                assert_eq!(
                    ::std::mem::size_of::<FragmentOrElement_cycleCollection>(),
                    16usize,
                    concat!("Size of: ", stringify!(FragmentOrElement_cycleCollection))
                );
                assert_eq!(
                    ::std::mem::align_of::<FragmentOrElement_cycleCollection>(),
                    8usize,
                    concat!(
                        "Alignment of ",
                        stringify!(FragmentOrElement_cycleCollection)
                    )
                );
            }
            impl Clone for FragmentOrElement_cycleCollection {
                fn clone(&self) -> Self {
                    *self
                }
            }
            /// There are a set of DOM- and scripting-specific instance variables
            /// that may only be instantiated when a content object is accessed
            /// through the DOM. Rather than burn actual slots in the content
            /// objects for each of these instance variables, we put them off
            /// in a side structure that's only allocated when the content is
            /// accessed through the DOM.
            #[repr(C)]
            pub struct FragmentOrElement_nsExtendedDOMSlots {
                pub _base: root::nsIContent_nsExtendedContentSlots,
                /// SMIL Overridde style rules (for SMIL animation of CSS properties)
                /// @see Element::GetSMILOverrideStyle
                pub mSMILOverrideStyle: root::RefPtr<root::nsDOMCSSAttributeDeclaration>,
                /// Holds any SMIL override style declaration for this element.
                pub mSMILOverrideStyleDeclaration: root::RefPtr<root::mozilla::DeclarationBlock>,
                /// The controllers of the XUL Element.
                pub mControllers: root::nsCOMPtr,
                /// An object implementing the .labels property for this element.
                pub mLabelsList: root::RefPtr<root::nsLabelsNodeList>,
                /// ShadowRoot bound to the element.
                pub mShadowRoot: root::RefPtr<root::mozilla::dom::ShadowRoot>,
                /// XBL binding installed on the element.
                pub mXBLBinding: root::RefPtr<root::nsXBLBinding>,
                /// Web components custom element data.
                pub mCustomElementData: root::RefPtr<root::mozilla::dom::CustomElementData>,
                /// For XUL to hold either frameloader or opener.
                pub mFrameLoaderOrOpener: root::nsCOMPtr,
            }
            #[test]
            fn bindgen_test_layout_FragmentOrElement_nsExtendedDOMSlots() {
                assert_eq!(
                    ::std::mem::size_of::<FragmentOrElement_nsExtendedDOMSlots>(),
                    104usize,
                    concat!(
                        "Size of: ",
                        stringify!(FragmentOrElement_nsExtendedDOMSlots)
                    )
                );
                assert_eq!(
                    ::std::mem::align_of::<FragmentOrElement_nsExtendedDOMSlots>(),
                    8usize,
                    concat!(
                        "Alignment of ",
                        stringify!(FragmentOrElement_nsExtendedDOMSlots)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<FragmentOrElement_nsExtendedDOMSlots>()))
                            .mSMILOverrideStyle as *const _ as usize
                    },
                    40usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(FragmentOrElement_nsExtendedDOMSlots),
                        "::",
                        stringify!(mSMILOverrideStyle)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<FragmentOrElement_nsExtendedDOMSlots>()))
                            .mSMILOverrideStyleDeclaration as *const _
                            as usize
                    },
                    48usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(FragmentOrElement_nsExtendedDOMSlots),
                        "::",
                        stringify!(mSMILOverrideStyleDeclaration)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<FragmentOrElement_nsExtendedDOMSlots>()))
                            .mControllers as *const _ as usize
                    },
                    56usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(FragmentOrElement_nsExtendedDOMSlots),
                        "::",
                        stringify!(mControllers)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<FragmentOrElement_nsExtendedDOMSlots>())).mLabelsList
                            as *const _ as usize
                    },
                    64usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(FragmentOrElement_nsExtendedDOMSlots),
                        "::",
                        stringify!(mLabelsList)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<FragmentOrElement_nsExtendedDOMSlots>())).mShadowRoot
                            as *const _ as usize
                    },
                    72usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(FragmentOrElement_nsExtendedDOMSlots),
                        "::",
                        stringify!(mShadowRoot)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<FragmentOrElement_nsExtendedDOMSlots>())).mXBLBinding
                            as *const _ as usize
                    },
                    80usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(FragmentOrElement_nsExtendedDOMSlots),
                        "::",
                        stringify!(mXBLBinding)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<FragmentOrElement_nsExtendedDOMSlots>()))
                            .mCustomElementData as *const _ as usize
                    },
                    88usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(FragmentOrElement_nsExtendedDOMSlots),
                        "::",
                        stringify!(mCustomElementData)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<FragmentOrElement_nsExtendedDOMSlots>()))
                            .mFrameLoaderOrOpener as *const _ as usize
                    },
                    96usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(FragmentOrElement_nsExtendedDOMSlots),
                        "::",
                        stringify!(mFrameLoaderOrOpener)
                    )
                );
            }
            #[repr(C)]
            pub struct FragmentOrElement_nsDOMSlots {
                pub _base: root::nsIContent_nsContentSlots,
                /// The .style attribute (an interface that forwards to the actual
                /// style rules)
                /// @see nsGenericHTMLElement::GetStyle
                pub mStyle: root::nsCOMPtr,
                /// The .dataset attribute.
                /// @see nsGenericHTMLElement::GetDataset
                pub mDataset: *mut root::nsDOMStringMap,
                /// @see Element::Attributes
                pub mAttributeMap: root::RefPtr<root::nsDOMAttributeMap>,
                /// An object implementing the .children property for this element.
                pub mChildrenList: root::RefPtr<root::nsContentList>,
                /// An object implementing the .classList property for this element.
                pub mClassList: root::RefPtr<root::nsDOMTokenList>,
            }
            #[test]
            fn bindgen_test_layout_FragmentOrElement_nsDOMSlots() {
                assert_eq!(
                    ::std::mem::size_of::<FragmentOrElement_nsDOMSlots>(),
                    120usize,
                    concat!("Size of: ", stringify!(FragmentOrElement_nsDOMSlots))
                );
                assert_eq!(
                    ::std::mem::align_of::<FragmentOrElement_nsDOMSlots>(),
                    8usize,
                    concat!("Alignment of ", stringify!(FragmentOrElement_nsDOMSlots))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<FragmentOrElement_nsDOMSlots>())).mStyle as *const _
                            as usize
                    },
                    80usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(FragmentOrElement_nsDOMSlots),
                        "::",
                        stringify!(mStyle)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<FragmentOrElement_nsDOMSlots>())).mDataset
                            as *const _ as usize
                    },
                    88usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(FragmentOrElement_nsDOMSlots),
                        "::",
                        stringify!(mDataset)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<FragmentOrElement_nsDOMSlots>())).mAttributeMap
                            as *const _ as usize
                    },
                    96usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(FragmentOrElement_nsDOMSlots),
                        "::",
                        stringify!(mAttributeMap)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<FragmentOrElement_nsDOMSlots>())).mChildrenList
                            as *const _ as usize
                    },
                    104usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(FragmentOrElement_nsDOMSlots),
                        "::",
                        stringify!(mChildrenList)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<FragmentOrElement_nsDOMSlots>())).mClassList
                            as *const _ as usize
                    },
                    112usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(FragmentOrElement_nsDOMSlots),
                        "::",
                        stringify!(mClassList)
                    )
                );
            }
            extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom17FragmentOrElement21_cycleCollectorGlobalE"]
                pub static mut FragmentOrElement__cycleCollectorGlobal:
                    root::mozilla::dom::FragmentOrElement_cycleCollection;
            }
            #[test]
            fn bindgen_test_layout_FragmentOrElement() {
                assert_eq!(
                    ::std::mem::size_of::<FragmentOrElement>(),
                    104usize,
                    concat!("Size of: ", stringify!(FragmentOrElement))
                );
                assert_eq!(
                    ::std::mem::align_of::<FragmentOrElement>(),
                    8usize,
                    concat!("Alignment of ", stringify!(FragmentOrElement))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<FragmentOrElement>())).mRefCnt as *const _ as usize
                    },
                    88usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(FragmentOrElement),
                        "::",
                        stringify!(mRefCnt)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<FragmentOrElement>())).mAttrsAndChildren as *const _
                            as usize
                    },
                    96usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(FragmentOrElement),
                        "::",
                        stringify!(mAttrsAndChildren)
                    )
                );
            }
            #[repr(C)]
            pub struct Attr {
                pub _base: root::nsIAttribute,
                pub _base_1: root::nsIDOMNode,
                pub mRefCnt: root::nsCycleCollectingAutoRefCnt,
                pub mValue: ::nsstring::nsStringRepr,
            }
            pub type Attr_HasThreadSafeRefCnt = root::mozilla::FalseType;
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct Attr_cycleCollection {
                pub _base: root::nsXPCOMCycleCollectionParticipant,
            }
            #[test]
            fn bindgen_test_layout_Attr_cycleCollection() {
                assert_eq!(
                    ::std::mem::size_of::<Attr_cycleCollection>(),
                    16usize,
                    concat!("Size of: ", stringify!(Attr_cycleCollection))
                );
                assert_eq!(
                    ::std::mem::align_of::<Attr_cycleCollection>(),
                    8usize,
                    concat!("Alignment of ", stringify!(Attr_cycleCollection))
                );
            }
            impl Clone for Attr_cycleCollection {
                fn clone(&self) -> Self {
                    *self
                }
            }
            extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom4Attr21_cycleCollectorGlobalE"]
                pub static mut Attr__cycleCollectorGlobal: root::mozilla::dom::Attr_cycleCollection;
            }
            extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom4Attr12sInitializedE"]
                pub static mut Attr_sInitialized: bool;
            }
            #[test]
            fn bindgen_test_layout_Attr() {
                assert_eq!(
                    ::std::mem::size_of::<Attr>(),
                    128usize,
                    concat!("Size of: ", stringify!(Attr))
                );
                assert_eq!(
                    ::std::mem::align_of::<Attr>(),
                    8usize,
                    concat!("Alignment of ", stringify!(Attr))
                );
            }
            #[repr(C)]
            #[derive(Debug)]
            pub struct DOMRectReadOnly {
                pub _base: root::nsISupports,
                pub _base_1: root::nsWrapperCache,
                pub mRefCnt: root::nsCycleCollectingAutoRefCnt,
                pub mParent: root::nsCOMPtr,
            }
            pub type DOMRectReadOnly_HasThreadSafeRefCnt = root::mozilla::FalseType;
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct DOMRectReadOnly_cycleCollection {
                pub _base: root::nsXPCOMCycleCollectionParticipant,
            }
            #[test]
            fn bindgen_test_layout_DOMRectReadOnly_cycleCollection() {
                assert_eq!(
                    ::std::mem::size_of::<DOMRectReadOnly_cycleCollection>(),
                    16usize,
                    concat!("Size of: ", stringify!(DOMRectReadOnly_cycleCollection))
                );
                assert_eq!(
                    ::std::mem::align_of::<DOMRectReadOnly_cycleCollection>(),
                    8usize,
                    concat!("Alignment of ", stringify!(DOMRectReadOnly_cycleCollection))
                );
            }
            impl Clone for DOMRectReadOnly_cycleCollection {
                fn clone(&self) -> Self {
                    *self
                }
            }
            extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom15DOMRectReadOnly21_cycleCollectorGlobalE"]
                pub static mut DOMRectReadOnly__cycleCollectorGlobal:
                    root::mozilla::dom::DOMRectReadOnly_cycleCollection;
            }
            #[test]
            fn bindgen_test_layout_DOMRectReadOnly() {
                assert_eq!(
                    ::std::mem::size_of::<DOMRectReadOnly>(),
                    48usize,
                    concat!("Size of: ", stringify!(DOMRectReadOnly))
                );
                assert_eq!(
                    ::std::mem::align_of::<DOMRectReadOnly>(),
                    8usize,
                    concat!("Alignment of ", stringify!(DOMRectReadOnly))
                );
            }
            pub const ShadowRootMode_Open: root::mozilla::dom::ShadowRootMode = 0;
            pub const ShadowRootMode_Closed: root::mozilla::dom::ShadowRootMode = 1;
            pub const ShadowRootMode_EndGuard_: root::mozilla::dom::ShadowRootMode = 2;
            pub type ShadowRootMode = u8;
            #[repr(C)]
            pub struct Element {
                pub _base: root::mozilla::dom::FragmentOrElement,
                pub mState: root::mozilla::EventStates,
                pub mServoData: ::gecko_bindings::structs::ServoCell<
                    *mut ::gecko_bindings::structs::ServoNodeData,
                >,
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct Element_COMTypeInfo {
                pub _address: u8,
            }
            /// StyleStateLocks is used to specify which event states should be locked,
            /// and whether they should be locked to on or off.
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct Element_StyleStateLocks {
                pub mLocks: root::mozilla::EventStates,
                pub mValues: root::mozilla::EventStates,
            }
            #[test]
            fn bindgen_test_layout_Element_StyleStateLocks() {
                assert_eq!(
                    ::std::mem::size_of::<Element_StyleStateLocks>(),
                    16usize,
                    concat!("Size of: ", stringify!(Element_StyleStateLocks))
                );
                assert_eq!(
                    ::std::mem::align_of::<Element_StyleStateLocks>(),
                    8usize,
                    concat!("Alignment of ", stringify!(Element_StyleStateLocks))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<Element_StyleStateLocks>())).mLocks as *const _
                            as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Element_StyleStateLocks),
                        "::",
                        stringify!(mLocks)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<Element_StyleStateLocks>())).mValues as *const _
                            as usize
                    },
                    8usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Element_StyleStateLocks),
                        "::",
                        stringify!(mValues)
                    )
                );
            }
            impl Clone for Element_StyleStateLocks {
                fn clone(&self) -> Self {
                    *self
                }
            }
            pub const Element_ATTR_MISSING: root::mozilla::dom::Element__bindgen_ty_1 = -1;
            pub const Element_ATTR_VALUE_NO_MATCH: root::mozilla::dom::Element__bindgen_ty_1 = -2;
            pub type Element__bindgen_ty_1 = i32;
            /// Check whether this Element's given attribute has one of a given list of
            /// values. If there is a match, we return the index in the list of the first
            /// matching value. If there was no attribute at all, then we return
            /// ATTR_MISSING. If there was an attribute but it didn't match, we return
            /// ATTR_VALUE_NO_MATCH. A non-negative result always indicates a match.
            ///
            /// @param aNameSpaceID The namespace ID of the attribute.  Must not
            /// be kNameSpaceID_Unknown.
            /// @param aName The name atom of the attribute.  Must not be null.
            /// @param aValues a nullptr-terminated array of pointers to atom values to test
            /// against.
            /// @param aCaseSensitive Whether to do a case-sensitive compare on the values.
            /// @return ATTR_MISSING, ATTR_VALUE_NO_MATCH or the non-negative index
            /// indicating the first value of aValues that matched
            pub type Element_AttrValuesArray = *const *const root::nsStaticAtom;
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct Element_MappedAttributeEntry {
                pub attribute: *mut *mut root::nsStaticAtom,
            }
            #[test]
            fn bindgen_test_layout_Element_MappedAttributeEntry() {
                assert_eq!(
                    ::std::mem::size_of::<Element_MappedAttributeEntry>(),
                    8usize,
                    concat!("Size of: ", stringify!(Element_MappedAttributeEntry))
                );
                assert_eq!(
                    ::std::mem::align_of::<Element_MappedAttributeEntry>(),
                    8usize,
                    concat!("Alignment of ", stringify!(Element_MappedAttributeEntry))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<Element_MappedAttributeEntry>())).attribute
                            as *const _ as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Element_MappedAttributeEntry),
                        "::",
                        stringify!(attribute)
                    )
                );
            }
            impl Clone for Element_MappedAttributeEntry {
                fn clone(&self) -> Self {
                    *self
                }
            }
            /// Define a general matching function that can be passed to
            /// GetElementsByMatching(). Each Element being considered is
            /// passed in.
            pub type Element_nsElementMatchFunc = ::std::option::Option<
                unsafe extern "C" fn(aElement: *mut root::mozilla::dom::Element) -> bool,
            >;
            pub const Element_kAllServoDescendantBits: u32 = 25296896;
            pub const Element_kFireMutationEvent: bool = true;
            pub const Element_kDontFireMutationEvent: bool = false;
            pub const Element_kNotifyDocumentObservers: bool = true;
            pub const Element_kDontNotifyDocumentObservers: bool = false;
            pub const Element_kCallAfterSetAttr: bool = true;
            pub const Element_kDontCallAfterSetAttr: bool = false;
            #[test]
            fn bindgen_test_layout_Element() {
                assert_eq!(
                    ::std::mem::size_of::<Element>(),
                    120usize,
                    concat!("Size of: ", stringify!(Element))
                );
                assert_eq!(
                    ::std::mem::align_of::<Element>(),
                    8usize,
                    concat!("Alignment of ", stringify!(Element))
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<Element>())).mState as *const _ as usize },
                    104usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Element),
                        "::",
                        stringify!(mState)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<Element>())).mServoData as *const _ as usize },
                    112usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(Element),
                        "::",
                        stringify!(mServoData)
                    )
                );
            }
            #[repr(C)]
            pub struct HTMLSlotElement {
                pub _base: root::nsGenericHTMLElement,
                pub mAssignedNodes: root::nsTArray<root::RefPtr<root::nsINode>>,
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct HTMLSlotElement_cycleCollection {
                pub _base: root::mozilla::dom::FragmentOrElement_cycleCollection,
            }
            #[test]
            fn bindgen_test_layout_HTMLSlotElement_cycleCollection() {
                assert_eq!(
                    ::std::mem::size_of::<HTMLSlotElement_cycleCollection>(),
                    16usize,
                    concat!("Size of: ", stringify!(HTMLSlotElement_cycleCollection))
                );
                assert_eq!(
                    ::std::mem::align_of::<HTMLSlotElement_cycleCollection>(),
                    8usize,
                    concat!("Alignment of ", stringify!(HTMLSlotElement_cycleCollection))
                );
            }
            impl Clone for HTMLSlotElement_cycleCollection {
                fn clone(&self) -> Self {
                    *self
                }
            }
            extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom15HTMLSlotElement21_cycleCollectorGlobalE"]
                pub static mut HTMLSlotElement__cycleCollectorGlobal:
                    root::mozilla::dom::HTMLSlotElement_cycleCollection;
            }
            #[test]
            fn bindgen_test_layout_HTMLSlotElement() {
                assert_eq!(
                    ::std::mem::size_of::<HTMLSlotElement>(),
                    136usize,
                    concat!("Size of: ", stringify!(HTMLSlotElement))
                );
                assert_eq!(
                    ::std::mem::align_of::<HTMLSlotElement>(),
                    8usize,
                    concat!("Alignment of ", stringify!(HTMLSlotElement))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<HTMLSlotElement>())).mAssignedNodes as *const _
                            as usize
                    },
                    128usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(HTMLSlotElement),
                        "::",
                        stringify!(mAssignedNodes)
                    )
                );
            }
            #[repr(u8)]
            #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
            pub enum CompositeOperation {
                Replace = 0,
                Add = 1,
                Accumulate = 2,
                EndGuard_ = 3,
            }
            #[repr(u8)]
            #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
            pub enum IterationCompositeOperation {
                Replace = 0,
                Accumulate = 1,
                EndGuard_ = 2,
            }
            #[repr(C)]
            pub struct DocumentFragment {
                pub _base: root::mozilla::dom::FragmentOrElement,
                pub _base_1: root::nsIDOMDocumentFragment,
                pub mHost: root::RefPtr<root::mozilla::dom::Element>,
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct DocumentFragment_cycleCollection {
                pub _base: root::mozilla::dom::FragmentOrElement_cycleCollection,
            }
            #[test]
            fn bindgen_test_layout_DocumentFragment_cycleCollection() {
                assert_eq!(
                    ::std::mem::size_of::<DocumentFragment_cycleCollection>(),
                    16usize,
                    concat!("Size of: ", stringify!(DocumentFragment_cycleCollection))
                );
                assert_eq!(
                    ::std::mem::align_of::<DocumentFragment_cycleCollection>(),
                    8usize,
                    concat!(
                        "Alignment of ",
                        stringify!(DocumentFragment_cycleCollection)
                    )
                );
            }
            impl Clone for DocumentFragment_cycleCollection {
                fn clone(&self) -> Self {
                    *self
                }
            }
            extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom16DocumentFragment21_cycleCollectorGlobalE"]
                pub static mut DocumentFragment__cycleCollectorGlobal:
                    root::mozilla::dom::DocumentFragment_cycleCollection;
            }
            #[test]
            fn bindgen_test_layout_DocumentFragment() {
                assert_eq!(
                    ::std::mem::size_of::<DocumentFragment>(),
                    120usize,
                    concat!("Size of: ", stringify!(DocumentFragment))
                );
                assert_eq!(
                    ::std::mem::align_of::<DocumentFragment>(),
                    8usize,
                    concat!("Alignment of ", stringify!(DocumentFragment))
                );
            }
            #[repr(C)]
            pub struct ShadowRoot {
                pub _base: root::mozilla::dom::DocumentFragment,
                pub _base_1: root::mozilla::dom::DocumentOrShadowRoot,
                pub _base_2: root::nsStubMutationObserver,
                pub mMode: root::mozilla::dom::ShadowRootMode,
                pub mServoStyles: root::mozilla::UniquePtr<root::RawServoAuthorStyles>,
                pub mStyleRuleMap: root::mozilla::UniquePtr<root::mozilla::ServoStyleRuleMap>,
                pub mSlotMap: [u64; 4usize],
                pub mIsComposedDocParticipant: bool,
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct ShadowRoot_cycleCollection {
                pub _base: root::mozilla::dom::DocumentFragment_cycleCollection,
            }
            #[test]
            fn bindgen_test_layout_ShadowRoot_cycleCollection() {
                assert_eq!(
                    ::std::mem::size_of::<ShadowRoot_cycleCollection>(),
                    16usize,
                    concat!("Size of: ", stringify!(ShadowRoot_cycleCollection))
                );
                assert_eq!(
                    ::std::mem::align_of::<ShadowRoot_cycleCollection>(),
                    8usize,
                    concat!("Alignment of ", stringify!(ShadowRoot_cycleCollection))
                );
            }
            impl Clone for ShadowRoot_cycleCollection {
                fn clone(&self) -> Self {
                    *self
                }
            }
            pub type ShadowRoot_SlotArray = u8;
            extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom10ShadowRoot21_cycleCollectorGlobalE"]
                pub static mut ShadowRoot__cycleCollectorGlobal:
                    root::mozilla::dom::ShadowRoot_cycleCollection;
            }
            #[test]
            fn bindgen_test_layout_ShadowRoot() {
                assert_eq!(
                    ::std::mem::size_of::<ShadowRoot>(),
                    256usize,
                    concat!("Size of: ", stringify!(ShadowRoot))
                );
                assert_eq!(
                    ::std::mem::align_of::<ShadowRoot>(),
                    8usize,
                    concat!("Alignment of ", stringify!(ShadowRoot))
                );
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct ExplicitChildIterator {
                pub mParent: *const root::nsIContent,
                pub mParentAsSlot: *const root::mozilla::dom::HTMLSlotElement,
                pub mChild: *mut root::nsIContent,
                pub mDefaultChild: *mut root::nsIContent,
                pub mIsFirst: bool,
                pub mIndexInInserted: u32,
            }
            #[test]
            fn bindgen_test_layout_ExplicitChildIterator() {
                assert_eq!(
                    ::std::mem::size_of::<ExplicitChildIterator>(),
                    40usize,
                    concat!("Size of: ", stringify!(ExplicitChildIterator))
                );
                assert_eq!(
                    ::std::mem::align_of::<ExplicitChildIterator>(),
                    8usize,
                    concat!("Alignment of ", stringify!(ExplicitChildIterator))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ExplicitChildIterator>())).mParent as *const _
                            as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ExplicitChildIterator),
                        "::",
                        stringify!(mParent)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ExplicitChildIterator>())).mParentAsSlot as *const _
                            as usize
                    },
                    8usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ExplicitChildIterator),
                        "::",
                        stringify!(mParentAsSlot)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ExplicitChildIterator>())).mChild as *const _
                            as usize
                    },
                    16usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ExplicitChildIterator),
                        "::",
                        stringify!(mChild)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ExplicitChildIterator>())).mDefaultChild as *const _
                            as usize
                    },
                    24usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ExplicitChildIterator),
                        "::",
                        stringify!(mDefaultChild)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ExplicitChildIterator>())).mIsFirst as *const _
                            as usize
                    },
                    32usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ExplicitChildIterator),
                        "::",
                        stringify!(mIsFirst)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<ExplicitChildIterator>())).mIndexInInserted
                            as *const _ as usize
                    },
                    36usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(ExplicitChildIterator),
                        "::",
                        stringify!(mIndexInInserted)
                    )
                );
            }
            impl Clone for ExplicitChildIterator {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug)]
            pub struct FlattenedChildIterator {
                pub _base: root::mozilla::dom::ExplicitChildIterator,
                pub mOriginalContent: *const root::nsIContent,
                pub mXBLInvolved: [u8; 2usize],
            }
            #[test]
            fn bindgen_test_layout_FlattenedChildIterator() {
                assert_eq!(
                    ::std::mem::size_of::<FlattenedChildIterator>(),
                    56usize,
                    concat!("Size of: ", stringify!(FlattenedChildIterator))
                );
                assert_eq!(
                    ::std::mem::align_of::<FlattenedChildIterator>(),
                    8usize,
                    concat!("Alignment of ", stringify!(FlattenedChildIterator))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<FlattenedChildIterator>())).mOriginalContent
                            as *const _ as usize
                    },
                    40usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(FlattenedChildIterator),
                        "::",
                        stringify!(mOriginalContent)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<FlattenedChildIterator>())).mXBLInvolved as *const _
                            as usize
                    },
                    48usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(FlattenedChildIterator),
                        "::",
                        stringify!(mXBLInvolved)
                    )
                );
            }
            /// AllChildrenIterator traverses the children of an element including before /
            /// after content and optionally XBL children.  The iterator can be initialized
            /// to start at the end by providing false for aStartAtBeginning in order to
            /// start iterating in reverse from the last child.
            ///
            /// Note: it assumes that no mutation of the DOM or frame tree takes place during
            /// iteration, and will break horribly if that is not true.
            #[repr(C)]
            #[derive(Debug)]
            pub struct AllChildrenIterator {
                pub _base: root::mozilla::dom::FlattenedChildIterator,
                pub mAnonKids: root::nsTArray<*mut root::nsIContent>,
                pub mAnonKidsIdx: u32,
                pub mFlags: u32,
                pub mPhase: root::mozilla::dom::AllChildrenIterator_IteratorPhase,
            }
            pub const AllChildrenIterator_IteratorPhase_eAtBegin:
                root::mozilla::dom::AllChildrenIterator_IteratorPhase = 0;
            pub const AllChildrenIterator_IteratorPhase_eAtBeforeKid:
                root::mozilla::dom::AllChildrenIterator_IteratorPhase = 1;
            pub const AllChildrenIterator_IteratorPhase_eAtExplicitKids:
                root::mozilla::dom::AllChildrenIterator_IteratorPhase = 2;
            pub const AllChildrenIterator_IteratorPhase_eAtAnonKids:
                root::mozilla::dom::AllChildrenIterator_IteratorPhase = 3;
            pub const AllChildrenIterator_IteratorPhase_eAtAfterKid:
                root::mozilla::dom::AllChildrenIterator_IteratorPhase = 4;
            pub const AllChildrenIterator_IteratorPhase_eAtEnd:
                root::mozilla::dom::AllChildrenIterator_IteratorPhase = 5;
            pub type AllChildrenIterator_IteratorPhase = u32;
            #[test]
            fn bindgen_test_layout_AllChildrenIterator() {
                assert_eq!(
                    ::std::mem::size_of::<AllChildrenIterator>(),
                    80usize,
                    concat!("Size of: ", stringify!(AllChildrenIterator))
                );
                assert_eq!(
                    ::std::mem::align_of::<AllChildrenIterator>(),
                    8usize,
                    concat!("Alignment of ", stringify!(AllChildrenIterator))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<AllChildrenIterator>())).mAnonKids as *const _
                            as usize
                    },
                    56usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(AllChildrenIterator),
                        "::",
                        stringify!(mAnonKids)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<AllChildrenIterator>())).mAnonKidsIdx as *const _
                            as usize
                    },
                    64usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(AllChildrenIterator),
                        "::",
                        stringify!(mAnonKidsIdx)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<AllChildrenIterator>())).mFlags as *const _ as usize
                    },
                    68usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(AllChildrenIterator),
                        "::",
                        stringify!(mFlags)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<AllChildrenIterator>())).mPhase as *const _ as usize
                    },
                    72usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(AllChildrenIterator),
                        "::",
                        stringify!(mPhase)
                    )
                );
            }
            /// StyleChildrenIterator traverses the children of the element from the
            /// perspective of the style system, particularly the children we need to
            /// traverse during restyle.
            ///
            /// At present, this is identical to AllChildrenIterator with
            /// (eAllChildren | eSkipDocumentLevelNativeAnonymousContent). We used to have
            /// detect and skip any native anonymous children that are used to implement some
            /// special magic in here that went away, but we keep the separate class so
            /// we can reintroduce special magic back if needed.
            ///
            /// Note: it assumes that no mutation of the DOM or frame tree takes place during
            /// iteration, and will break horribly if that is not true.
            ///
            /// We require this to be memmovable since Rust code can create and move
            /// StyleChildrenIterators.
            #[repr(C)]
            #[derive(Debug)]
            pub struct StyleChildrenIterator {
                pub _base: root::mozilla::dom::AllChildrenIterator,
            }
            #[test]
            fn bindgen_test_layout_StyleChildrenIterator() {
                assert_eq!(
                    ::std::mem::size_of::<StyleChildrenIterator>(),
                    80usize,
                    concat!("Size of: ", stringify!(StyleChildrenIterator))
                );
                assert_eq!(
                    ::std::mem::align_of::<StyleChildrenIterator>(),
                    8usize,
                    concat!("Alignment of ", stringify!(StyleChildrenIterator))
                );
            }
            #[repr(C)]
            #[derive(Debug)]
            pub struct MediaList {
                pub _base: root::nsISupports,
                pub _base_1: root::nsWrapperCache,
                pub mRefCnt: root::nsCycleCollectingAutoRefCnt,
                pub mStyleSheet: *mut root::mozilla::StyleSheet,
            }
            pub type MediaList_HasThreadSafeRefCnt = root::mozilla::FalseType;
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct MediaList_cycleCollection {
                pub _base: root::nsXPCOMCycleCollectionParticipant,
            }
            #[test]
            fn bindgen_test_layout_MediaList_cycleCollection() {
                assert_eq!(
                    ::std::mem::size_of::<MediaList_cycleCollection>(),
                    16usize,
                    concat!("Size of: ", stringify!(MediaList_cycleCollection))
                );
                assert_eq!(
                    ::std::mem::align_of::<MediaList_cycleCollection>(),
                    8usize,
                    concat!("Alignment of ", stringify!(MediaList_cycleCollection))
                );
            }
            impl Clone for MediaList_cycleCollection {
                fn clone(&self) -> Self {
                    *self
                }
            }
            extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom9MediaList21_cycleCollectorGlobalE"]
                pub static mut MediaList__cycleCollectorGlobal:
                    root::mozilla::dom::MediaList_cycleCollection;
            }
            #[test]
            fn bindgen_test_layout_MediaList() {
                assert_eq!(
                    ::std::mem::size_of::<MediaList>(),
                    48usize,
                    concat!("Size of: ", stringify!(MediaList))
                );
                assert_eq!(
                    ::std::mem::align_of::<MediaList>(),
                    8usize,
                    concat!("Alignment of ", stringify!(MediaList))
                );
            }
        }
        #[repr(C)]
        pub struct CSSVariableValues {
            /// Map of variable names to IDs.  Variable IDs are indexes into
            /// mVariables.
            pub mVariableIDs: [u64; 4usize],
            /// Array of variables, indexed by variable ID.
            pub mVariables: root::nsTArray<root::mozilla::CSSVariableValues_Variable>,
        }
        #[repr(C)]
        pub struct CSSVariableValues_Variable {
            pub mVariableName: ::nsstring::nsStringRepr,
            pub mValue: ::nsstring::nsStringRepr,
            pub mFirstToken: root::nsCSSTokenSerializationType,
            pub mLastToken: root::nsCSSTokenSerializationType,
        }
        #[test]
        fn bindgen_test_layout_CSSVariableValues_Variable() {
            assert_eq!(
                ::std::mem::size_of::<CSSVariableValues_Variable>(),
                40usize,
                concat!("Size of: ", stringify!(CSSVariableValues_Variable))
            );
            assert_eq!(
                ::std::mem::align_of::<CSSVariableValues_Variable>(),
                8usize,
                concat!("Alignment of ", stringify!(CSSVariableValues_Variable))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CSSVariableValues_Variable>())).mVariableName as *const _
                        as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CSSVariableValues_Variable),
                    "::",
                    stringify!(mVariableName)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CSSVariableValues_Variable>())).mValue as *const _
                        as usize
                },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CSSVariableValues_Variable),
                    "::",
                    stringify!(mValue)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CSSVariableValues_Variable>())).mFirstToken as *const _
                        as usize
                },
                32usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CSSVariableValues_Variable),
                    "::",
                    stringify!(mFirstToken)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CSSVariableValues_Variable>())).mLastToken as *const _
                        as usize
                },
                36usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CSSVariableValues_Variable),
                    "::",
                    stringify!(mLastToken)
                )
            );
        }
        #[test]
        fn bindgen_test_layout_CSSVariableValues() {
            assert_eq!(
                ::std::mem::size_of::<CSSVariableValues>(),
                40usize,
                concat!("Size of: ", stringify!(CSSVariableValues))
            );
            assert_eq!(
                ::std::mem::align_of::<CSSVariableValues>(),
                8usize,
                concat!("Alignment of ", stringify!(CSSVariableValues))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CSSVariableValues>())).mVariableIDs as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CSSVariableValues),
                    "::",
                    stringify!(mVariableIDs)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CSSVariableValues>())).mVariables as *const _ as usize
                },
                32usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CSSVariableValues),
                    "::",
                    stringify!(mVariables)
                )
            );
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum SheetType {
            Agent = 0,
            User = 1,
            PresHint = 2,
            Doc = 3,
            ScopedDoc = 4,
            StyleAttr = 5,
            Override = 6,
            Animation = 7,
            Transition = 8,
            Count = 9,
            Unknown = 255,
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct StaticRefPtr<T> {
            pub mRawPtr: *mut T,
            pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
        }
        /// This struct represents a combined color from a numeric color and
        /// the current foreground color (currentcolor keyword).
        /// Conceptually, the formula is "color * (1 - p) + currentcolor * p"
        /// where p is mForegroundRatio. See mozilla::LinearBlendColors for
        /// the actual algorithm.
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct StyleComplexColor {
            pub mColor: root::nscolor,
            pub mForegroundRatio: u8,
            pub mIsAuto: bool,
        }
        #[test]
        fn bindgen_test_layout_StyleComplexColor() {
            assert_eq!(
                ::std::mem::size_of::<StyleComplexColor>(),
                8usize,
                concat!("Size of: ", stringify!(StyleComplexColor))
            );
            assert_eq!(
                ::std::mem::align_of::<StyleComplexColor>(),
                4usize,
                concat!("Alignment of ", stringify!(StyleComplexColor))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleComplexColor>())).mColor as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleComplexColor),
                    "::",
                    stringify!(mColor)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleComplexColor>())).mForegroundRatio as *const _
                        as usize
                },
                4usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleComplexColor),
                    "::",
                    stringify!(mForegroundRatio)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleComplexColor>())).mIsAuto as *const _ as usize
                },
                5usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleComplexColor),
                    "::",
                    stringify!(mIsAuto)
                )
            );
        }
        impl Clone for StyleComplexColor {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(u32)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum Side {
            eSideTop = 0,
            eSideRight = 1,
            eSideBottom = 2,
            eSideLeft = 3,
        }
        #[repr(u32)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum HalfCorner {
            eCornerTopLeftX = 0,
            eCornerTopLeftY = 1,
            eCornerTopRightX = 2,
            eCornerTopRightY = 3,
            eCornerBottomRightX = 4,
            eCornerBottomRightY = 5,
            eCornerBottomLeftX = 6,
            eCornerBottomLeftY = 7,
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct NotNull<T> {
            pub mBasePtr: T,
            pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
        }
        pub const FontFamilyType_eFamily_generic_first: root::mozilla::FontFamilyType =
            FontFamilyType::eFamily_serif;
        pub const FontFamilyType_eFamily_generic_last: root::mozilla::FontFamilyType =
            FontFamilyType::eFamily_fantasy;
        pub const FontFamilyType_eFamily_generic_count: root::mozilla::FontFamilyType =
            FontFamilyType::eFamily_monospace;
        #[repr(u32)]
        /// type of font family name, either a name (e.g. Helvetica) or a
        /// generic (e.g. serif, sans-serif), with the ability to distinguish
        /// between unquoted and quoted names for serializaiton
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum FontFamilyType {
            eFamily_none = 0,
            eFamily_named = 1,
            eFamily_named_quoted = 2,
            eFamily_serif = 3,
            eFamily_sans_serif = 4,
            eFamily_monospace = 5,
            eFamily_cursive = 6,
            eFamily_fantasy = 7,
            eFamily_moz_variable = 8,
            eFamily_moz_fixed = 9,
            eFamily_moz_emoji = 10,
        }
        /// font family name, a string for the name if not a generic and
        /// a font type indicated named family or which generic family
        #[repr(C)]
        pub struct FontFamilyName {
            pub mType: root::mozilla::FontFamilyType,
            pub mName: ::nsstring::nsStringRepr,
        }
        #[test]
        fn bindgen_test_layout_FontFamilyName() {
            assert_eq!(
                ::std::mem::size_of::<FontFamilyName>(),
                24usize,
                concat!("Size of: ", stringify!(FontFamilyName))
            );
            assert_eq!(
                ::std::mem::align_of::<FontFamilyName>(),
                8usize,
                concat!("Alignment of ", stringify!(FontFamilyName))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<FontFamilyName>())).mType as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(FontFamilyName),
                    "::",
                    stringify!(mType)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<FontFamilyName>())).mName as *const _ as usize },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(FontFamilyName),
                    "::",
                    stringify!(mName)
                )
            );
        }
        /// A refcounted array of FontFamilyNames.  We use this to store the specified
        /// value (in Servo) and the computed value (in both Gecko and Servo) of the
        /// font-family property.
        #[repr(C)]
        pub struct SharedFontList {
            pub mRefCnt: root::mozilla::ThreadSafeAutoRefCnt,
            pub mNames: root::nsTArray<root::mozilla::FontFamilyName>,
        }
        pub type SharedFontList_HasThreadSafeRefCnt = root::mozilla::TrueType;
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla14SharedFontList6sEmptyE"]
            pub static mut SharedFontList_sEmpty:
                root::mozilla::StaticRefPtr<root::mozilla::SharedFontList>;
        }
        #[test]
        fn bindgen_test_layout_SharedFontList() {
            assert_eq!(
                ::std::mem::size_of::<SharedFontList>(),
                16usize,
                concat!("Size of: ", stringify!(SharedFontList))
            );
            assert_eq!(
                ::std::mem::align_of::<SharedFontList>(),
                8usize,
                concat!("Alignment of ", stringify!(SharedFontList))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<SharedFontList>())).mRefCnt as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(SharedFontList),
                    "::",
                    stringify!(mRefCnt)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<SharedFontList>())).mNames as *const _ as usize },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(SharedFontList),
                    "::",
                    stringify!(mNames)
                )
            );
        }
        #[test]
        fn __bindgen_test_layout_StaticRefPtr_open0_SharedFontList_close0_instantiation() {
            assert_eq!(
                ::std::mem::size_of::<root::mozilla::StaticRefPtr<root::mozilla::SharedFontList>>(),
                8usize,
                concat!(
                    "Size of template specialization: ",
                    stringify!(root::mozilla::StaticRefPtr<root::mozilla::SharedFontList>)
                )
            );
            assert_eq ! ( :: std :: mem :: align_of :: < root :: mozilla :: StaticRefPtr < root :: mozilla :: SharedFontList > > ( ) , 8usize , concat ! ( "Alignment of template specialization: " , stringify ! ( root :: mozilla :: StaticRefPtr < root :: mozilla :: SharedFontList > ) ) );
        }
        /// font family list, array of font families and a default font type.
        /// font family names are either named strings or generics. the default
        /// font type is used to preserve the variable font fallback behavior
        #[repr(C)]
        pub struct FontFamilyList {
            pub mFontlist: root::mozilla::NotNull<root::RefPtr<root::mozilla::SharedFontList>>,
            pub mDefaultFontType: root::mozilla::FontFamilyType,
        }
        #[test]
        fn bindgen_test_layout_FontFamilyList() {
            assert_eq!(
                ::std::mem::size_of::<FontFamilyList>(),
                16usize,
                concat!("Size of: ", stringify!(FontFamilyList))
            );
            assert_eq!(
                ::std::mem::align_of::<FontFamilyList>(),
                8usize,
                concat!("Alignment of ", stringify!(FontFamilyList))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<FontFamilyList>())).mFontlist as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(FontFamilyList),
                    "::",
                    stringify!(mFontlist)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<FontFamilyList>())).mDefaultFontType as *const _ as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(FontFamilyList),
                    "::",
                    stringify!(mDefaultFontType)
                )
            );
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleBasicShapeType {
            Polygon = 0,
            Circle = 1,
            Ellipse = 2,
            Inset = 3,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleBoxAlign {
            Stretch = 0,
            Start = 1,
            Center = 2,
            Baseline = 3,
            End = 4,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleBoxDecorationBreak {
            Slice = 0,
            Clone = 1,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleBoxDirection {
            Normal = 0,
            Reverse = 1,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleBoxOrient {
            Horizontal = 0,
            Vertical = 1,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleBoxPack {
            Start = 0,
            Center = 1,
            End = 2,
            Justify = 3,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleBoxSizing {
            Content = 0,
            Border = 1,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleClear {
            None = 0,
            Left = 1,
            Right = 2,
            InlineStart = 3,
            InlineEnd = 4,
            Both = 5,
            Line = 8,
            Max = 13,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleGeometryBox {
            ContentBox = 0,
            PaddingBox = 1,
            BorderBox = 2,
            MarginBox = 3,
            FillBox = 4,
            StrokeBox = 5,
            ViewBox = 6,
            NoClip = 7,
            Text = 8,
            NoBox = 9,
            MozAlmostPadding = 127,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleFillRule {
            Nonzero = 0,
            Evenodd = 1,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleFloat {
            None = 0,
            Left = 1,
            Right = 2,
            InlineStart = 3,
            InlineEnd = 4,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleFloatEdge {
            ContentBox = 0,
            MarginBox = 1,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleHyphens {
            None = 0,
            Manual = 1,
            Auto = 2,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleShapeRadius {
            ClosestSide = 0,
            FarthestSide = 1,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleShapeSourceType {
            None = 0,
            URL = 1,
            Image = 2,
            Shape = 3,
            Box = 4,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleStackSizing {
            Ignore = 0,
            StretchToFit = 1,
            IgnoreHorizontal = 2,
            IgnoreVertical = 3,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleTextJustify {
            None = 0,
            Auto = 1,
            InterWord = 2,
            InterCharacter = 3,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleUserFocus {
            None = 0,
            Ignore = 1,
            Normal = 2,
            SelectAll = 3,
            SelectBefore = 4,
            SelectAfter = 5,
            SelectSame = 6,
            SelectMenu = 7,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleUserSelect {
            None = 0,
            Text = 1,
            Element = 2,
            Elements = 3,
            All = 4,
            Toggle = 5,
            TriState = 6,
            Auto = 7,
            MozAll = 8,
            MozText = 9,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleUserInput {
            None = 0,
            Auto = 1,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleUserModify {
            ReadOnly = 0,
            ReadWrite = 1,
            WriteOnly = 2,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleWindowDragging {
            Default = 0,
            Drag = 1,
            NoDrag = 2,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleOrient {
            Inline = 0,
            Block = 1,
            Horizontal = 2,
            Vertical = 3,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleImageLayerRepeat {
            NoRepeat = 0,
            RepeatX = 1,
            RepeatY = 2,
            Repeat = 3,
            Space = 4,
            Round = 5,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleBorderImageRepeat {
            Stretch = 0,
            Repeat = 1,
            Round = 2,
            Space = 3,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleDisplay {
            None = 0,
            Block = 1,
            FlowRoot = 2,
            Inline = 3,
            InlineBlock = 4,
            ListItem = 5,
            Table = 6,
            InlineTable = 7,
            TableRowGroup = 8,
            TableColumn = 9,
            TableColumnGroup = 10,
            TableHeaderGroup = 11,
            TableFooterGroup = 12,
            TableRow = 13,
            TableCell = 14,
            TableCaption = 15,
            Flex = 16,
            InlineFlex = 17,
            Grid = 18,
            InlineGrid = 19,
            Ruby = 20,
            RubyBase = 21,
            RubyBaseContainer = 22,
            RubyText = 23,
            RubyTextContainer = 24,
            Contents = 25,
            WebkitBox = 26,
            WebkitInlineBox = 27,
            MozBox = 28,
            MozInlineBox = 29,
            MozGrid = 30,
            MozInlineGrid = 31,
            MozGridGroup = 32,
            MozGridLine = 33,
            MozStack = 34,
            MozInlineStack = 35,
            MozDeck = 36,
            MozGroupbox = 37,
            MozPopup = 38,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleGridTrackBreadth {
            MaxContent = 1,
            MinContent = 2,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleWhiteSpace {
            Normal = 0,
            Pre = 1,
            Nowrap = 2,
            PreWrap = 3,
            PreLine = 4,
            PreSpace = 5,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleOverscrollBehavior {
            Auto = 0,
            Contain = 1,
            None = 2,
        }
        pub const MediaFeatureChangeReason_ViewportChange: root::mozilla::MediaFeatureChangeReason =
            1;
        pub const MediaFeatureChangeReason_ZoomChange: root::mozilla::MediaFeatureChangeReason = 2;
        pub const MediaFeatureChangeReason_MinFontSizeChange:
            root::mozilla::MediaFeatureChangeReason = 4;
        pub const MediaFeatureChangeReason_ResolutionChange:
            root::mozilla::MediaFeatureChangeReason = 8;
        pub const MediaFeatureChangeReason_MediumChange: root::mozilla::MediaFeatureChangeReason =
            16;
        pub const MediaFeatureChangeReason_SizeModeChange: root::mozilla::MediaFeatureChangeReason =
            32;
        pub const MediaFeatureChangeReason_SystemMetricsChange:
            root::mozilla::MediaFeatureChangeReason = 64;
        pub const MediaFeatureChangeReason_DeviceSizeIsPageSizeChange:
            root::mozilla::MediaFeatureChangeReason = 128;
        pub const MediaFeatureChangeReason_DisplayModeChange:
            root::mozilla::MediaFeatureChangeReason = 256;
        pub type MediaFeatureChangeReason = i32;
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct MediaFeatureChange {
            pub mRestyleHint: root::nsRestyleHint,
            pub mChangeHint: root::nsChangeHint,
            pub mReason: root::mozilla::MediaFeatureChangeReason,
        }
        #[test]
        fn bindgen_test_layout_MediaFeatureChange() {
            assert_eq!(
                ::std::mem::size_of::<MediaFeatureChange>(),
                12usize,
                concat!("Size of: ", stringify!(MediaFeatureChange))
            );
            assert_eq!(
                ::std::mem::align_of::<MediaFeatureChange>(),
                4usize,
                concat!("Alignment of ", stringify!(MediaFeatureChange))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<MediaFeatureChange>())).mRestyleHint as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(MediaFeatureChange),
                    "::",
                    stringify!(mRestyleHint)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<MediaFeatureChange>())).mChangeHint as *const _ as usize
                },
                4usize,
                concat!(
                    "Offset of field: ",
                    stringify!(MediaFeatureChange),
                    "::",
                    stringify!(mChangeHint)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<MediaFeatureChange>())).mReason as *const _ as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(MediaFeatureChange),
                    "::",
                    stringify!(mReason)
                )
            );
        }
        impl Clone for MediaFeatureChange {
            fn clone(&self) -> Self {
                *self
            }
        }
        pub mod external {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            /// AtomicRefCounted<T> is like RefCounted<T>, with an atomically updated
            /// reference counter.
            ///
            /// NOTE: Please do not use this class, use NS_INLINE_DECL_THREADSAFE_REFCOUNTING
            /// instead.
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct AtomicRefCounted {
                pub _address: u8,
            }
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct SupportsWeakPtr {
            pub _address: u8,
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct WeakPtr {
            pub _address: u8,
        }
        pub type WeakPtr_WeakReference = u8;
        /// Event messages
        pub type EventMessageType = u16;
        pub const EventMessage_eVoidEvent: root::mozilla::EventMessage = 0;
        pub const EventMessage_eAllEvents: root::mozilla::EventMessage = 1;
        pub const EventMessage_eWindowClose: root::mozilla::EventMessage = 2;
        pub const EventMessage_eKeyPress: root::mozilla::EventMessage = 3;
        pub const EventMessage_eKeyUp: root::mozilla::EventMessage = 4;
        pub const EventMessage_eKeyDown: root::mozilla::EventMessage = 5;
        pub const EventMessage_eKeyDownOnPlugin: root::mozilla::EventMessage = 6;
        pub const EventMessage_eKeyUpOnPlugin: root::mozilla::EventMessage = 7;
        pub const EventMessage_eAccessKeyNotFound: root::mozilla::EventMessage = 8;
        pub const EventMessage_eResize: root::mozilla::EventMessage = 9;
        pub const EventMessage_eScroll: root::mozilla::EventMessage = 10;
        pub const EventMessage_eInstall: root::mozilla::EventMessage = 11;
        pub const EventMessage_eAppInstalled: root::mozilla::EventMessage = 12;
        pub const EventMessage_ePluginActivate: root::mozilla::EventMessage = 13;
        pub const EventMessage_ePluginFocus: root::mozilla::EventMessage = 14;
        pub const EventMessage_eOffline: root::mozilla::EventMessage = 15;
        pub const EventMessage_eOnline: root::mozilla::EventMessage = 16;
        pub const EventMessage_eLanguageChange: root::mozilla::EventMessage = 17;
        pub const EventMessage_eMouseMove: root::mozilla::EventMessage = 18;
        pub const EventMessage_eMouseUp: root::mozilla::EventMessage = 19;
        pub const EventMessage_eMouseDown: root::mozilla::EventMessage = 20;
        pub const EventMessage_eMouseEnterIntoWidget: root::mozilla::EventMessage = 21;
        pub const EventMessage_eMouseExitFromWidget: root::mozilla::EventMessage = 22;
        pub const EventMessage_eMouseDoubleClick: root::mozilla::EventMessage = 23;
        pub const EventMessage_eMouseClick: root::mozilla::EventMessage = 24;
        pub const EventMessage_eMouseAuxClick: root::mozilla::EventMessage = 25;
        pub const EventMessage_eMouseActivate: root::mozilla::EventMessage = 26;
        pub const EventMessage_eMouseOver: root::mozilla::EventMessage = 27;
        pub const EventMessage_eMouseOut: root::mozilla::EventMessage = 28;
        pub const EventMessage_eMouseHitTest: root::mozilla::EventMessage = 29;
        pub const EventMessage_eMouseEnter: root::mozilla::EventMessage = 30;
        pub const EventMessage_eMouseLeave: root::mozilla::EventMessage = 31;
        pub const EventMessage_eMouseTouchDrag: root::mozilla::EventMessage = 32;
        pub const EventMessage_eMouseLongTap: root::mozilla::EventMessage = 33;
        pub const EventMessage_eMouseEventFirst: root::mozilla::EventMessage = 18;
        pub const EventMessage_eMouseEventLast: root::mozilla::EventMessage = 33;
        pub const EventMessage_ePointerMove: root::mozilla::EventMessage = 34;
        pub const EventMessage_ePointerUp: root::mozilla::EventMessage = 35;
        pub const EventMessage_ePointerDown: root::mozilla::EventMessage = 36;
        pub const EventMessage_ePointerOver: root::mozilla::EventMessage = 37;
        pub const EventMessage_ePointerOut: root::mozilla::EventMessage = 38;
        pub const EventMessage_ePointerEnter: root::mozilla::EventMessage = 39;
        pub const EventMessage_ePointerLeave: root::mozilla::EventMessage = 40;
        pub const EventMessage_ePointerCancel: root::mozilla::EventMessage = 41;
        pub const EventMessage_ePointerGotCapture: root::mozilla::EventMessage = 42;
        pub const EventMessage_ePointerLostCapture: root::mozilla::EventMessage = 43;
        pub const EventMessage_ePointerEventFirst: root::mozilla::EventMessage = 34;
        pub const EventMessage_ePointerEventLast: root::mozilla::EventMessage = 43;
        pub const EventMessage_eContextMenu: root::mozilla::EventMessage = 44;
        pub const EventMessage_eLoad: root::mozilla::EventMessage = 45;
        pub const EventMessage_eUnload: root::mozilla::EventMessage = 46;
        pub const EventMessage_eHashChange: root::mozilla::EventMessage = 47;
        pub const EventMessage_eImageAbort: root::mozilla::EventMessage = 48;
        pub const EventMessage_eLoadError: root::mozilla::EventMessage = 49;
        pub const EventMessage_eLoadEnd: root::mozilla::EventMessage = 50;
        pub const EventMessage_ePopState: root::mozilla::EventMessage = 51;
        pub const EventMessage_eStorage: root::mozilla::EventMessage = 52;
        pub const EventMessage_eBeforeUnload: root::mozilla::EventMessage = 53;
        pub const EventMessage_eReadyStateChange: root::mozilla::EventMessage = 54;
        pub const EventMessage_eFormSubmit: root::mozilla::EventMessage = 55;
        pub const EventMessage_eFormReset: root::mozilla::EventMessage = 56;
        pub const EventMessage_eFormChange: root::mozilla::EventMessage = 57;
        pub const EventMessage_eFormSelect: root::mozilla::EventMessage = 58;
        pub const EventMessage_eFormInvalid: root::mozilla::EventMessage = 59;
        pub const EventMessage_eFormCheckboxStateChange: root::mozilla::EventMessage = 60;
        pub const EventMessage_eFormRadioStateChange: root::mozilla::EventMessage = 61;
        pub const EventMessage_eFocus: root::mozilla::EventMessage = 62;
        pub const EventMessage_eBlur: root::mozilla::EventMessage = 63;
        pub const EventMessage_eFocusIn: root::mozilla::EventMessage = 64;
        pub const EventMessage_eFocusOut: root::mozilla::EventMessage = 65;
        pub const EventMessage_eDragEnter: root::mozilla::EventMessage = 66;
        pub const EventMessage_eDragOver: root::mozilla::EventMessage = 67;
        pub const EventMessage_eDragExit: root::mozilla::EventMessage = 68;
        pub const EventMessage_eDrag: root::mozilla::EventMessage = 69;
        pub const EventMessage_eDragEnd: root::mozilla::EventMessage = 70;
        pub const EventMessage_eDragStart: root::mozilla::EventMessage = 71;
        pub const EventMessage_eDrop: root::mozilla::EventMessage = 72;
        pub const EventMessage_eDragLeave: root::mozilla::EventMessage = 73;
        pub const EventMessage_eDragDropEventFirst: root::mozilla::EventMessage = 66;
        pub const EventMessage_eDragDropEventLast: root::mozilla::EventMessage = 73;
        pub const EventMessage_eXULPopupShowing: root::mozilla::EventMessage = 74;
        pub const EventMessage_eXULPopupShown: root::mozilla::EventMessage = 75;
        pub const EventMessage_eXULPopupPositioned: root::mozilla::EventMessage = 76;
        pub const EventMessage_eXULPopupHiding: root::mozilla::EventMessage = 77;
        pub const EventMessage_eXULPopupHidden: root::mozilla::EventMessage = 78;
        pub const EventMessage_eXULBroadcast: root::mozilla::EventMessage = 79;
        pub const EventMessage_eXULCommandUpdate: root::mozilla::EventMessage = 80;
        pub const EventMessage_eLegacyMouseLineOrPageScroll: root::mozilla::EventMessage = 81;
        pub const EventMessage_eLegacyMousePixelScroll: root::mozilla::EventMessage = 82;
        pub const EventMessage_eScrollPortUnderflow: root::mozilla::EventMessage = 83;
        pub const EventMessage_eScrollPortOverflow: root::mozilla::EventMessage = 84;
        pub const EventMessage_eLegacySubtreeModified: root::mozilla::EventMessage = 85;
        pub const EventMessage_eLegacyNodeInserted: root::mozilla::EventMessage = 86;
        pub const EventMessage_eLegacyNodeRemoved: root::mozilla::EventMessage = 87;
        pub const EventMessage_eLegacyNodeRemovedFromDocument: root::mozilla::EventMessage = 88;
        pub const EventMessage_eLegacyNodeInsertedIntoDocument: root::mozilla::EventMessage = 89;
        pub const EventMessage_eLegacyAttrModified: root::mozilla::EventMessage = 90;
        pub const EventMessage_eLegacyCharacterDataModified: root::mozilla::EventMessage = 91;
        pub const EventMessage_eLegacyMutationEventFirst: root::mozilla::EventMessage = 85;
        pub const EventMessage_eLegacyMutationEventLast: root::mozilla::EventMessage = 91;
        pub const EventMessage_eUnidentifiedEvent: root::mozilla::EventMessage = 92;
        pub const EventMessage_eCompositionStart: root::mozilla::EventMessage = 93;
        pub const EventMessage_eCompositionEnd: root::mozilla::EventMessage = 94;
        pub const EventMessage_eCompositionUpdate: root::mozilla::EventMessage = 95;
        pub const EventMessage_eCompositionChange: root::mozilla::EventMessage = 96;
        pub const EventMessage_eCompositionCommitAsIs: root::mozilla::EventMessage = 97;
        pub const EventMessage_eCompositionCommit: root::mozilla::EventMessage = 98;
        pub const EventMessage_eCompositionCommitRequestHandled: root::mozilla::EventMessage = 99;
        pub const EventMessage_eLegacyDOMActivate: root::mozilla::EventMessage = 100;
        pub const EventMessage_eLegacyDOMFocusIn: root::mozilla::EventMessage = 101;
        pub const EventMessage_eLegacyDOMFocusOut: root::mozilla::EventMessage = 102;
        pub const EventMessage_ePageShow: root::mozilla::EventMessage = 103;
        pub const EventMessage_ePageHide: root::mozilla::EventMessage = 104;
        pub const EventMessage_eSVGLoad: root::mozilla::EventMessage = 105;
        pub const EventMessage_eSVGUnload: root::mozilla::EventMessage = 106;
        pub const EventMessage_eSVGResize: root::mozilla::EventMessage = 107;
        pub const EventMessage_eSVGScroll: root::mozilla::EventMessage = 108;
        pub const EventMessage_eSVGZoom: root::mozilla::EventMessage = 109;
        pub const EventMessage_eXULCommand: root::mozilla::EventMessage = 110;
        pub const EventMessage_eCopy: root::mozilla::EventMessage = 111;
        pub const EventMessage_eCut: root::mozilla::EventMessage = 112;
        pub const EventMessage_ePaste: root::mozilla::EventMessage = 113;
        pub const EventMessage_ePasteNoFormatting: root::mozilla::EventMessage = 114;
        pub const EventMessage_eQuerySelectedText: root::mozilla::EventMessage = 115;
        pub const EventMessage_eQueryTextContent: root::mozilla::EventMessage = 116;
        pub const EventMessage_eQueryCaretRect: root::mozilla::EventMessage = 117;
        pub const EventMessage_eQueryTextRect: root::mozilla::EventMessage = 118;
        pub const EventMessage_eQueryTextRectArray: root::mozilla::EventMessage = 119;
        pub const EventMessage_eQueryEditorRect: root::mozilla::EventMessage = 120;
        pub const EventMessage_eQueryContentState: root::mozilla::EventMessage = 121;
        pub const EventMessage_eQuerySelectionAsTransferable: root::mozilla::EventMessage = 122;
        pub const EventMessage_eQueryCharacterAtPoint: root::mozilla::EventMessage = 123;
        pub const EventMessage_eQueryDOMWidgetHittest: root::mozilla::EventMessage = 124;
        pub const EventMessage_eLoadStart: root::mozilla::EventMessage = 125;
        pub const EventMessage_eProgress: root::mozilla::EventMessage = 126;
        pub const EventMessage_eSuspend: root::mozilla::EventMessage = 127;
        pub const EventMessage_eEmptied: root::mozilla::EventMessage = 128;
        pub const EventMessage_eStalled: root::mozilla::EventMessage = 129;
        pub const EventMessage_ePlay: root::mozilla::EventMessage = 130;
        pub const EventMessage_ePause: root::mozilla::EventMessage = 131;
        pub const EventMessage_eLoadedMetaData: root::mozilla::EventMessage = 132;
        pub const EventMessage_eLoadedData: root::mozilla::EventMessage = 133;
        pub const EventMessage_eWaiting: root::mozilla::EventMessage = 134;
        pub const EventMessage_ePlaying: root::mozilla::EventMessage = 135;
        pub const EventMessage_eCanPlay: root::mozilla::EventMessage = 136;
        pub const EventMessage_eCanPlayThrough: root::mozilla::EventMessage = 137;
        pub const EventMessage_eSeeking: root::mozilla::EventMessage = 138;
        pub const EventMessage_eSeeked: root::mozilla::EventMessage = 139;
        pub const EventMessage_eTimeUpdate: root::mozilla::EventMessage = 140;
        pub const EventMessage_eEnded: root::mozilla::EventMessage = 141;
        pub const EventMessage_eRateChange: root::mozilla::EventMessage = 142;
        pub const EventMessage_eDurationChange: root::mozilla::EventMessage = 143;
        pub const EventMessage_eVolumeChange: root::mozilla::EventMessage = 144;
        pub const EventMessage_eAfterPaint: root::mozilla::EventMessage = 145;
        pub const EventMessage_eSwipeGestureMayStart: root::mozilla::EventMessage = 146;
        pub const EventMessage_eSwipeGestureStart: root::mozilla::EventMessage = 147;
        pub const EventMessage_eSwipeGestureUpdate: root::mozilla::EventMessage = 148;
        pub const EventMessage_eSwipeGestureEnd: root::mozilla::EventMessage = 149;
        pub const EventMessage_eSwipeGesture: root::mozilla::EventMessage = 150;
        pub const EventMessage_eMagnifyGestureStart: root::mozilla::EventMessage = 151;
        pub const EventMessage_eMagnifyGestureUpdate: root::mozilla::EventMessage = 152;
        pub const EventMessage_eMagnifyGesture: root::mozilla::EventMessage = 153;
        pub const EventMessage_eRotateGestureStart: root::mozilla::EventMessage = 154;
        pub const EventMessage_eRotateGestureUpdate: root::mozilla::EventMessage = 155;
        pub const EventMessage_eRotateGesture: root::mozilla::EventMessage = 156;
        pub const EventMessage_eTapGesture: root::mozilla::EventMessage = 157;
        pub const EventMessage_ePressTapGesture: root::mozilla::EventMessage = 158;
        pub const EventMessage_eEdgeUIStarted: root::mozilla::EventMessage = 159;
        pub const EventMessage_eEdgeUICanceled: root::mozilla::EventMessage = 160;
        pub const EventMessage_eEdgeUICompleted: root::mozilla::EventMessage = 161;
        pub const EventMessage_ePluginInputEvent: root::mozilla::EventMessage = 162;
        pub const EventMessage_eSetSelection: root::mozilla::EventMessage = 163;
        pub const EventMessage_eContentCommandCut: root::mozilla::EventMessage = 164;
        pub const EventMessage_eContentCommandCopy: root::mozilla::EventMessage = 165;
        pub const EventMessage_eContentCommandPaste: root::mozilla::EventMessage = 166;
        pub const EventMessage_eContentCommandDelete: root::mozilla::EventMessage = 167;
        pub const EventMessage_eContentCommandUndo: root::mozilla::EventMessage = 168;
        pub const EventMessage_eContentCommandRedo: root::mozilla::EventMessage = 169;
        pub const EventMessage_eContentCommandPasteTransferable: root::mozilla::EventMessage = 170;
        pub const EventMessage_eContentCommandLookUpDictionary: root::mozilla::EventMessage = 171;
        pub const EventMessage_eContentCommandScroll: root::mozilla::EventMessage = 172;
        pub const EventMessage_eGestureNotify: root::mozilla::EventMessage = 173;
        pub const EventMessage_eScrolledAreaChanged: root::mozilla::EventMessage = 174;
        pub const EventMessage_eTransitionStart: root::mozilla::EventMessage = 175;
        pub const EventMessage_eTransitionRun: root::mozilla::EventMessage = 176;
        pub const EventMessage_eTransitionEnd: root::mozilla::EventMessage = 177;
        pub const EventMessage_eTransitionCancel: root::mozilla::EventMessage = 178;
        pub const EventMessage_eAnimationStart: root::mozilla::EventMessage = 179;
        pub const EventMessage_eAnimationEnd: root::mozilla::EventMessage = 180;
        pub const EventMessage_eAnimationIteration: root::mozilla::EventMessage = 181;
        pub const EventMessage_eAnimationCancel: root::mozilla::EventMessage = 182;
        pub const EventMessage_eWebkitTransitionEnd: root::mozilla::EventMessage = 183;
        pub const EventMessage_eWebkitAnimationStart: root::mozilla::EventMessage = 184;
        pub const EventMessage_eWebkitAnimationEnd: root::mozilla::EventMessage = 185;
        pub const EventMessage_eWebkitAnimationIteration: root::mozilla::EventMessage = 186;
        pub const EventMessage_eSMILBeginEvent: root::mozilla::EventMessage = 187;
        pub const EventMessage_eSMILEndEvent: root::mozilla::EventMessage = 188;
        pub const EventMessage_eSMILRepeatEvent: root::mozilla::EventMessage = 189;
        pub const EventMessage_eAudioProcess: root::mozilla::EventMessage = 190;
        pub const EventMessage_eAudioComplete: root::mozilla::EventMessage = 191;
        pub const EventMessage_eBeforeScriptExecute: root::mozilla::EventMessage = 192;
        pub const EventMessage_eAfterScriptExecute: root::mozilla::EventMessage = 193;
        pub const EventMessage_eBeforePrint: root::mozilla::EventMessage = 194;
        pub const EventMessage_eAfterPrint: root::mozilla::EventMessage = 195;
        pub const EventMessage_eMessage: root::mozilla::EventMessage = 196;
        pub const EventMessage_eMessageError: root::mozilla::EventMessage = 197;
        pub const EventMessage_eOpen: root::mozilla::EventMessage = 198;
        pub const EventMessage_eDeviceOrientation: root::mozilla::EventMessage = 199;
        pub const EventMessage_eAbsoluteDeviceOrientation: root::mozilla::EventMessage = 200;
        pub const EventMessage_eDeviceMotion: root::mozilla::EventMessage = 201;
        pub const EventMessage_eDeviceProximity: root::mozilla::EventMessage = 202;
        pub const EventMessage_eUserProximity: root::mozilla::EventMessage = 203;
        pub const EventMessage_eDeviceLight: root::mozilla::EventMessage = 204;
        pub const EventMessage_eVRDisplayActivate: root::mozilla::EventMessage = 205;
        pub const EventMessage_eVRDisplayDeactivate: root::mozilla::EventMessage = 206;
        pub const EventMessage_eVRDisplayConnect: root::mozilla::EventMessage = 207;
        pub const EventMessage_eVRDisplayDisconnect: root::mozilla::EventMessage = 208;
        pub const EventMessage_eVRDisplayPresentChange: root::mozilla::EventMessage = 209;
        pub const EventMessage_eShow: root::mozilla::EventMessage = 210;
        pub const EventMessage_eFullscreenChange: root::mozilla::EventMessage = 211;
        pub const EventMessage_eFullscreenError: root::mozilla::EventMessage = 212;
        pub const EventMessage_eMozFullscreenChange: root::mozilla::EventMessage = 213;
        pub const EventMessage_eMozFullscreenError: root::mozilla::EventMessage = 214;
        pub const EventMessage_eTouchStart: root::mozilla::EventMessage = 215;
        pub const EventMessage_eTouchMove: root::mozilla::EventMessage = 216;
        pub const EventMessage_eTouchEnd: root::mozilla::EventMessage = 217;
        pub const EventMessage_eTouchCancel: root::mozilla::EventMessage = 218;
        pub const EventMessage_eTouchPointerCancel: root::mozilla::EventMessage = 219;
        pub const EventMessage_ePointerLockChange: root::mozilla::EventMessage = 220;
        pub const EventMessage_ePointerLockError: root::mozilla::EventMessage = 221;
        pub const EventMessage_eMozPointerLockChange: root::mozilla::EventMessage = 222;
        pub const EventMessage_eMozPointerLockError: root::mozilla::EventMessage = 223;
        pub const EventMessage_eWheel: root::mozilla::EventMessage = 224;
        pub const EventMessage_eWheelOperationStart: root::mozilla::EventMessage = 225;
        pub const EventMessage_eWheelOperationEnd: root::mozilla::EventMessage = 226;
        pub const EventMessage_eTimeChange: root::mozilla::EventMessage = 227;
        pub const EventMessage_eNetworkUpload: root::mozilla::EventMessage = 228;
        pub const EventMessage_eNetworkDownload: root::mozilla::EventMessage = 229;
        pub const EventMessage_eMediaRecorderDataAvailable: root::mozilla::EventMessage = 230;
        pub const EventMessage_eMediaRecorderWarning: root::mozilla::EventMessage = 231;
        pub const EventMessage_eMediaRecorderStop: root::mozilla::EventMessage = 232;
        pub const EventMessage_eGamepadButtonDown: root::mozilla::EventMessage = 233;
        pub const EventMessage_eGamepadButtonUp: root::mozilla::EventMessage = 234;
        pub const EventMessage_eGamepadAxisMove: root::mozilla::EventMessage = 235;
        pub const EventMessage_eGamepadConnected: root::mozilla::EventMessage = 236;
        pub const EventMessage_eGamepadDisconnected: root::mozilla::EventMessage = 237;
        pub const EventMessage_eGamepadEventFirst: root::mozilla::EventMessage = 233;
        pub const EventMessage_eGamepadEventLast: root::mozilla::EventMessage = 237;
        pub const EventMessage_eEditorInput: root::mozilla::EventMessage = 238;
        pub const EventMessage_eSelectStart: root::mozilla::EventMessage = 239;
        pub const EventMessage_eSelectionChange: root::mozilla::EventMessage = 240;
        pub const EventMessage_eVisibilityChange: root::mozilla::EventMessage = 241;
        pub const EventMessage_eToggle: root::mozilla::EventMessage = 242;
        pub const EventMessage_eClose: root::mozilla::EventMessage = 243;
        pub const EventMessage_eEventMessage_MaxValue: root::mozilla::EventMessage = 244;
        pub type EventMessage = u16;
        /// Event class IDs
        pub type EventClassIDType = u8;
        pub const EventClassID_eBasicEventClass: root::mozilla::EventClassID = 0;
        pub const EventClassID_eGUIEventClass: root::mozilla::EventClassID = 1;
        pub const EventClassID_eInputEventClass: root::mozilla::EventClassID = 2;
        pub const EventClassID_eUIEventClass: root::mozilla::EventClassID = 3;
        pub const EventClassID_eKeyboardEventClass: root::mozilla::EventClassID = 4;
        pub const EventClassID_eCompositionEventClass: root::mozilla::EventClassID = 5;
        pub const EventClassID_eQueryContentEventClass: root::mozilla::EventClassID = 6;
        pub const EventClassID_eSelectionEventClass: root::mozilla::EventClassID = 7;
        pub const EventClassID_eEditorInputEventClass: root::mozilla::EventClassID = 8;
        pub const EventClassID_eMouseEventBaseClass: root::mozilla::EventClassID = 9;
        pub const EventClassID_eMouseEventClass: root::mozilla::EventClassID = 10;
        pub const EventClassID_eDragEventClass: root::mozilla::EventClassID = 11;
        pub const EventClassID_eMouseScrollEventClass: root::mozilla::EventClassID = 12;
        pub const EventClassID_eWheelEventClass: root::mozilla::EventClassID = 13;
        pub const EventClassID_ePointerEventClass: root::mozilla::EventClassID = 14;
        pub const EventClassID_eGestureNotifyEventClass: root::mozilla::EventClassID = 15;
        pub const EventClassID_eSimpleGestureEventClass: root::mozilla::EventClassID = 16;
        pub const EventClassID_eTouchEventClass: root::mozilla::EventClassID = 17;
        pub const EventClassID_eScrollPortEventClass: root::mozilla::EventClassID = 18;
        pub const EventClassID_eScrollAreaEventClass: root::mozilla::EventClassID = 19;
        pub const EventClassID_eFormEventClass: root::mozilla::EventClassID = 20;
        pub const EventClassID_eClipboardEventClass: root::mozilla::EventClassID = 21;
        pub const EventClassID_eFocusEventClass: root::mozilla::EventClassID = 22;
        pub const EventClassID_eTransitionEventClass: root::mozilla::EventClassID = 23;
        pub const EventClassID_eAnimationEventClass: root::mozilla::EventClassID = 24;
        pub const EventClassID_eSMILTimeEventClass: root::mozilla::EventClassID = 25;
        pub const EventClassID_eCommandEventClass: root::mozilla::EventClassID = 26;
        pub const EventClassID_eContentCommandEventClass: root::mozilla::EventClassID = 27;
        pub const EventClassID_ePluginEventClass: root::mozilla::EventClassID = 28;
        pub const EventClassID_eMutationEventClass: root::mozilla::EventClassID = 29;
        pub type EventClassID = u8;
        pub type AtomArray = root::nsTArray<root::RefPtr<root::nsAtom>>;
        /// EventStates is the class used to represent the event states of nsIContent
        /// instances. These states are calculated by IntrinsicState() and
        /// ContentStatesChanged() has to be called when one of them changes thus
        /// informing the layout/style engine of the change.
        /// Event states are associated with pseudo-classes.
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct EventStates {
            pub mStates: root::mozilla::EventStates_InternalType,
        }
        pub type EventStates_InternalType = u64;
        pub type EventStates_ServoType = u64;
        #[test]
        fn bindgen_test_layout_EventStates() {
            assert_eq!(
                ::std::mem::size_of::<EventStates>(),
                8usize,
                concat!("Size of: ", stringify!(EventStates))
            );
            assert_eq!(
                ::std::mem::align_of::<EventStates>(),
                8usize,
                concat!("Alignment of ", stringify!(EventStates))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<EventStates>())).mStates as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(EventStates),
                    "::",
                    stringify!(mStates)
                )
            );
        }
        impl Clone for EventStates {
            fn clone(&self) -> Self {
                *self
            }
        }
        pub const ServoTraversalFlags_Empty: root::mozilla::ServoTraversalFlags = 0;
        pub const ServoTraversalFlags_AnimationOnly: root::mozilla::ServoTraversalFlags = 1;
        pub const ServoTraversalFlags_ForCSSRuleChanges: root::mozilla::ServoTraversalFlags = 2;
        pub const ServoTraversalFlags_Forgetful: root::mozilla::ServoTraversalFlags = 8;
        pub const ServoTraversalFlags_ClearDirtyBits: root::mozilla::ServoTraversalFlags = 32;
        pub const ServoTraversalFlags_ClearAnimationOnlyDirtyDescendants:
            root::mozilla::ServoTraversalFlags = 64;
        pub const ServoTraversalFlags_ParallelTraversal: root::mozilla::ServoTraversalFlags = 128;
        pub const ServoTraversalFlags_FlushThrottledAnimations: root::mozilla::ServoTraversalFlags =
            256;
        pub type ServoTraversalFlags = u32;
        #[repr(i32)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum StyleRuleInclusion {
            All = 0,
            DefaultOnly = 1,
        }
        pub const UpdateAnimationsTasks_CSSAnimations: root::mozilla::UpdateAnimationsTasks = 1;
        pub const UpdateAnimationsTasks_CSSTransitions: root::mozilla::UpdateAnimationsTasks = 2;
        pub const UpdateAnimationsTasks_EffectProperties: root::mozilla::UpdateAnimationsTasks = 4;
        pub const UpdateAnimationsTasks_CascadeResults: root::mozilla::UpdateAnimationsTasks = 8;
        pub const UpdateAnimationsTasks_DisplayChangedFromNone:
            root::mozilla::UpdateAnimationsTasks = 16;
        pub type UpdateAnimationsTasks = u8;
        pub const ParsingMode_Default: root::mozilla::ParsingMode = 0;
        pub const ParsingMode_AllowUnitlessLength: root::mozilla::ParsingMode = 1;
        pub const ParsingMode_AllowAllNumericValues: root::mozilla::ParsingMode = 2;
        pub type ParsingMode = u8;
        #[repr(i32)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum InheritTarget {
            Text = 0,
            FirstLetterContinuation = 1,
            PlaceholderFrame = 2,
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct ServoStyleSetSizes {
            pub mRuleTree: usize,
            pub mPrecomputedPseudos: usize,
            pub mElementAndPseudosMaps: usize,
            pub mInvalidationMap: usize,
            pub mRevalidationSelectors: usize,
            pub mOther: usize,
        }
        #[test]
        fn bindgen_test_layout_ServoStyleSetSizes() {
            assert_eq!(
                ::std::mem::size_of::<ServoStyleSetSizes>(),
                48usize,
                concat!("Size of: ", stringify!(ServoStyleSetSizes))
            );
            assert_eq!(
                ::std::mem::align_of::<ServoStyleSetSizes>(),
                8usize,
                concat!("Alignment of ", stringify!(ServoStyleSetSizes))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoStyleSetSizes>())).mRuleTree as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoStyleSetSizes),
                    "::",
                    stringify!(mRuleTree)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoStyleSetSizes>())).mPrecomputedPseudos as *const _
                        as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoStyleSetSizes),
                    "::",
                    stringify!(mPrecomputedPseudos)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoStyleSetSizes>())).mElementAndPseudosMaps
                        as *const _ as usize
                },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoStyleSetSizes),
                    "::",
                    stringify!(mElementAndPseudosMaps)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoStyleSetSizes>())).mInvalidationMap as *const _
                        as usize
                },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoStyleSetSizes),
                    "::",
                    stringify!(mInvalidationMap)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoStyleSetSizes>())).mRevalidationSelectors
                        as *const _ as usize
                },
                32usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoStyleSetSizes),
                    "::",
                    stringify!(mRevalidationSelectors)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoStyleSetSizes>())).mOther as *const _ as usize
                },
                40usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoStyleSetSizes),
                    "::",
                    stringify!(mOther)
                )
            );
        }
        impl Clone for ServoStyleSetSizes {
            fn clone(&self) -> Self {
                *self
            }
        }
        pub const StyleBackendType_None: root::mozilla::StyleBackendType = 0;
        pub const StyleBackendType_Gecko: root::mozilla::StyleBackendType = 1;
        pub const StyleBackendType_Servo: root::mozilla::StyleBackendType = 2;
        /// Enumeration that represents one of the two supported style system backends.
        pub type StyleBackendType = u8;
        pub mod profiler {
            #[allow(unused_imports)]
            use self::super::super::super::root;
        }
        pub type TimeStampValue = u64;
        /// Instances of this class represent the length of an interval of time.
        /// Negative durations are allowed, meaning the end is before the start.
        ///
        /// Internally the duration is stored as a int64_t in units of
        /// PR_TicksPerSecond() when building with NSPR interval timers, or a
        /// system-dependent unit when building with system clocks.  The
        /// system-dependent unit must be constant, otherwise the semantics of
        /// this class would be broken.
        ///
        /// The ValueCalculator template parameter determines how arithmetic
        /// operations are performed on the integer count of ticks (mValue).
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct BaseTimeDuration {
            pub mValue: i64,
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct BaseTimeDuration__SomethingVeryRandomHere {
            _unused: [u8; 0],
        }
        /// Perform arithmetic operations on the value of a BaseTimeDuration without
        /// doing strict checks on the range of values.
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct TimeDurationValueCalculator {
            pub _address: u8,
        }
        #[test]
        fn bindgen_test_layout_TimeDurationValueCalculator() {
            assert_eq!(
                ::std::mem::size_of::<TimeDurationValueCalculator>(),
                1usize,
                concat!("Size of: ", stringify!(TimeDurationValueCalculator))
            );
            assert_eq!(
                ::std::mem::align_of::<TimeDurationValueCalculator>(),
                1usize,
                concat!("Alignment of ", stringify!(TimeDurationValueCalculator))
            );
        }
        impl Clone for TimeDurationValueCalculator {
            fn clone(&self) -> Self {
                *self
            }
        }
        /// Specialization of BaseTimeDuration that uses TimeDurationValueCalculator for
        /// arithmetic on the mValue member.
        ///
        /// Use this class for time durations that are *not* expected to hold values of
        /// Forever (or the negative equivalent) or when such time duration are *not*
        /// expected to be used in arithmetic operations.
        pub type TimeDuration = root::mozilla::BaseTimeDuration;
        /// Instances of this class represent moments in time, or a special
        /// "null" moment. We do not use the non-monotonic system clock or
        /// local time, since they can be reset, causing apparent backward
        /// travel in time, which can confuse algorithms. Instead we measure
        /// elapsed time according to the system.  This time can never go
        /// backwards (i.e. it never wraps around, at least not in less than
        /// five million years of system elapsed time). It might not advance
        /// while the system is sleeping. If TimeStamp::SetNow() is not called
        /// at all for hours or days, we might not notice the passage of some
        /// of that time.
        ///
        /// We deliberately do not expose a way to convert TimeStamps to some
        /// particular unit. All you can do is compute a difference between two
        /// TimeStamps to get a TimeDuration. You can also add a TimeDuration
        /// to a TimeStamp to get a new TimeStamp. You can't do something
        /// meaningless like add two TimeStamps.
        ///
        /// Internally this is implemented as either a wrapper around
        /// - high-resolution, monotonic, system clocks if they exist on this
        /// platform
        /// - PRIntervalTime otherwise.  We detect wraparounds of
        /// PRIntervalTime and work around them.
        ///
        /// This class is similar to C++11's time_point, however it is
        /// explicitly nullable and provides an IsNull() method. time_point
        /// is initialized to the clock's epoch and provides a
        /// time_since_epoch() method that functions similiarly. i.e.
        /// t.IsNull() is equivalent to t.time_since_epoch() == decltype(t)::duration::zero();
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct TimeStamp {
            /// When built with PRIntervalTime, a value of 0 means this instance
            /// is "null". Otherwise, the low 32 bits represent a PRIntervalTime,
            /// and the high 32 bits represent a counter of the number of
            /// rollovers of PRIntervalTime that we've seen. This counter starts
            /// at 1 to avoid a real time colliding with the "null" value.
            ///
            /// PR_INTERVAL_MAX is set at 100,000 ticks per second. So the minimum
            /// time to wrap around is about 2^64/100000 seconds, i.e. about
            /// 5,849,424 years.
            ///
            /// When using a system clock, a value is system dependent.
            pub mValue: root::mozilla::TimeStampValue,
        }
        #[test]
        fn bindgen_test_layout_TimeStamp() {
            assert_eq!(
                ::std::mem::size_of::<TimeStamp>(),
                8usize,
                concat!("Size of: ", stringify!(TimeStamp))
            );
            assert_eq!(
                ::std::mem::align_of::<TimeStamp>(),
                8usize,
                concat!("Alignment of ", stringify!(TimeStamp))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<TimeStamp>())).mValue as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(TimeStamp),
                    "::",
                    stringify!(mValue)
                )
            );
        }
        impl Clone for TimeStamp {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct MallocAllocPolicy {
            pub _address: u8,
        }
        #[test]
        fn bindgen_test_layout_MallocAllocPolicy() {
            assert_eq!(
                ::std::mem::size_of::<MallocAllocPolicy>(),
                1usize,
                concat!("Size of: ", stringify!(MallocAllocPolicy))
            );
            assert_eq!(
                ::std::mem::align_of::<MallocAllocPolicy>(),
                1usize,
                concat!("Alignment of ", stringify!(MallocAllocPolicy))
            );
        }
        impl Clone for MallocAllocPolicy {
            fn clone(&self) -> Self {
                *self
            }
        }
        pub type Vector_Impl = u8;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct Vector_CapacityAndReserved {
            pub mCapacity: usize,
        }
        pub type Vector_ElementType<T> = T;
        pub const Vector_InlineLength: root::mozilla::Vector__bindgen_ty_1 = 0;
        pub type Vector__bindgen_ty_1 = i32;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct Vector_Range<T> {
            pub mCur: *mut T,
            pub mEnd: *mut T,
            pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct Vector_ConstRange<T> {
            pub mCur: *mut T,
            pub mEnd: *mut T,
            pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
        }
        pub mod binding_danger {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct AssertAndSuppressCleanupPolicy {
                pub _address: u8,
            }
            pub const AssertAndSuppressCleanupPolicy_assertHandled: bool = true;
            pub const AssertAndSuppressCleanupPolicy_suppress: bool = true;
            #[test]
            fn bindgen_test_layout_AssertAndSuppressCleanupPolicy() {
                assert_eq!(
                    ::std::mem::size_of::<AssertAndSuppressCleanupPolicy>(),
                    1usize,
                    concat!("Size of: ", stringify!(AssertAndSuppressCleanupPolicy))
                );
                assert_eq!(
                    ::std::mem::align_of::<AssertAndSuppressCleanupPolicy>(),
                    1usize,
                    concat!("Alignment of ", stringify!(AssertAndSuppressCleanupPolicy))
                );
            }
            impl Clone for AssertAndSuppressCleanupPolicy {
                fn clone(&self) -> Self {
                    *self
                }
            }
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct OwningNonNull<T> {
            pub mPtr: root::RefPtr<T>,
            pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
        }
        pub mod net {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            pub const ReferrerPolicy_RP_No_Referrer: root::mozilla::net::ReferrerPolicy = 2;
            pub const ReferrerPolicy_RP_Origin: root::mozilla::net::ReferrerPolicy = 3;
            pub const ReferrerPolicy_RP_No_Referrer_When_Downgrade:
                root::mozilla::net::ReferrerPolicy = 1;
            pub const ReferrerPolicy_RP_Origin_When_Crossorigin:
                root::mozilla::net::ReferrerPolicy = 4;
            pub const ReferrerPolicy_RP_Unsafe_URL: root::mozilla::net::ReferrerPolicy = 5;
            pub const ReferrerPolicy_RP_Same_Origin: root::mozilla::net::ReferrerPolicy = 6;
            pub const ReferrerPolicy_RP_Strict_Origin: root::mozilla::net::ReferrerPolicy = 7;
            pub const ReferrerPolicy_RP_Strict_Origin_When_Cross_Origin:
                root::mozilla::net::ReferrerPolicy = 8;
            pub const ReferrerPolicy_RP_Unset: root::mozilla::net::ReferrerPolicy = 0;
            pub type ReferrerPolicy = u32;
        }
        /// The default of not using CORS to validate cross-origin loads.
        pub const CORSMode_CORS_NONE: root::mozilla::CORSMode = 0;
        /// Validate cross-site loads using CORS, but do not send any credentials
        /// (cookies, HTTP auth logins, etc) along with the request.
        pub const CORSMode_CORS_ANONYMOUS: root::mozilla::CORSMode = 1;
        /// Validate cross-site loads using CORS, and send credentials such as cookies
        /// and HTTP auth logins along with the request.
        pub const CORSMode_CORS_USE_CREDENTIALS: root::mozilla::CORSMode = 2;
        pub type CORSMode = u8;
        /// Superclass for data common to CSSStyleSheet and ServoStyleSheet.
        #[repr(C)]
        pub struct StyleSheet {
            pub _base: root::nsICSSLoaderObserver,
            pub _base_1: root::nsWrapperCache,
            pub mRefCnt: root::nsCycleCollectingAutoRefCnt,
            pub mParent: *mut root::mozilla::StyleSheet,
            pub mTitle: ::nsstring::nsStringRepr,
            pub mDocument: *mut root::nsIDocument,
            pub mOwningNode: *mut root::nsINode,
            pub mOwnerRule: *mut root::mozilla::dom::CSSImportRule,
            pub mMedia: root::RefPtr<root::mozilla::dom::MediaList>,
            pub mNext: root::RefPtr<root::mozilla::StyleSheet>,
            pub mParsingMode: root::mozilla::css::SheetParsingMode,
            pub mType: root::mozilla::StyleBackendType,
            pub mDisabled: bool,
            pub mDirtyFlags: u8,
            pub mDocumentAssociationMode: root::mozilla::StyleSheet_DocumentAssociationMode,
            pub mInner: *mut root::mozilla::StyleSheetInfo,
            pub mStyleSets: root::nsTArray<root::mozilla::StyleSetHandle>,
        }
        pub type StyleSheet_HasThreadSafeRefCnt = root::mozilla::FalseType;
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct StyleSheet_cycleCollection {
            pub _base: root::nsXPCOMCycleCollectionParticipant,
        }
        #[test]
        fn bindgen_test_layout_StyleSheet_cycleCollection() {
            assert_eq!(
                ::std::mem::size_of::<StyleSheet_cycleCollection>(),
                16usize,
                concat!("Size of: ", stringify!(StyleSheet_cycleCollection))
            );
            assert_eq!(
                ::std::mem::align_of::<StyleSheet_cycleCollection>(),
                8usize,
                concat!("Alignment of ", stringify!(StyleSheet_cycleCollection))
            );
        }
        impl Clone for StyleSheet_cycleCollection {
            fn clone(&self) -> Self {
                *self
            }
        }
        pub const StyleSheet_ChangeType_Added: root::mozilla::StyleSheet_ChangeType = 0;
        pub const StyleSheet_ChangeType_Removed: root::mozilla::StyleSheet_ChangeType = 1;
        pub const StyleSheet_ChangeType_ApplicableStateChanged:
            root::mozilla::StyleSheet_ChangeType = 2;
        pub const StyleSheet_ChangeType_RuleAdded: root::mozilla::StyleSheet_ChangeType = 3;
        pub const StyleSheet_ChangeType_RuleRemoved: root::mozilla::StyleSheet_ChangeType = 4;
        pub const StyleSheet_ChangeType_RuleChanged: root::mozilla::StyleSheet_ChangeType = 5;
        /// The different changes that a stylesheet may go through.
        ///
        /// Used by the StyleSets in order to handle more efficiently some kinds of
        /// changes.
        pub type StyleSheet_ChangeType = i32;
        pub const StyleSheet_DocumentAssociationMode_OwnedByDocument:
            root::mozilla::StyleSheet_DocumentAssociationMode = 0;
        pub const StyleSheet_DocumentAssociationMode_NotOwnedByDocument:
            root::mozilla::StyleSheet_DocumentAssociationMode = 1;
        pub type StyleSheet_DocumentAssociationMode = u8;
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct StyleSheet_ChildSheetListBuilder {
            pub sheetSlot: *mut root::RefPtr<root::mozilla::StyleSheet>,
            pub parent: *mut root::mozilla::StyleSheet,
        }
        #[test]
        fn bindgen_test_layout_StyleSheet_ChildSheetListBuilder() {
            assert_eq!(
                ::std::mem::size_of::<StyleSheet_ChildSheetListBuilder>(),
                16usize,
                concat!("Size of: ", stringify!(StyleSheet_ChildSheetListBuilder))
            );
            assert_eq!(
                ::std::mem::align_of::<StyleSheet_ChildSheetListBuilder>(),
                8usize,
                concat!(
                    "Alignment of ",
                    stringify!(StyleSheet_ChildSheetListBuilder)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleSheet_ChildSheetListBuilder>())).sheetSlot
                        as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleSheet_ChildSheetListBuilder),
                    "::",
                    stringify!(sheetSlot)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleSheet_ChildSheetListBuilder>())).parent as *const _
                        as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleSheet_ChildSheetListBuilder),
                    "::",
                    stringify!(parent)
                )
            );
        }
        impl Clone for StyleSheet_ChildSheetListBuilder {
            fn clone(&self) -> Self {
                *self
            }
        }
        pub const StyleSheet_dirtyFlagAttributes_FORCED_UNIQUE_INNER:
            root::mozilla::StyleSheet_dirtyFlagAttributes = 1;
        pub const StyleSheet_dirtyFlagAttributes_MODIFIED_RULES:
            root::mozilla::StyleSheet_dirtyFlagAttributes = 2;
        pub type StyleSheet_dirtyFlagAttributes = u32;
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla10StyleSheet21_cycleCollectorGlobalE"]
            pub static mut StyleSheet__cycleCollectorGlobal:
                root::mozilla::StyleSheet_cycleCollection;
        }
        #[test]
        fn bindgen_test_layout_StyleSheet() {
            assert_eq!(
                ::std::mem::size_of::<StyleSheet>(),
                128usize,
                concat!("Size of: ", stringify!(StyleSheet))
            );
            assert_eq!(
                ::std::mem::align_of::<StyleSheet>(),
                8usize,
                concat!("Alignment of ", stringify!(StyleSheet))
            );
        }
        pub const CSSEnabledState_eForAllContent: root::mozilla::CSSEnabledState = 0;
        pub const CSSEnabledState_eInUASheets: root::mozilla::CSSEnabledState = 1;
        pub const CSSEnabledState_eInChrome: root::mozilla::CSSEnabledState = 2;
        pub const CSSEnabledState_eIgnoreEnabledState: root::mozilla::CSSEnabledState = 255;
        pub type CSSEnabledState = i32;
        pub type CSSPseudoElementTypeBase = u8;
        pub const CSSPseudoElementType_InheritingAnonBox: root::mozilla::CSSPseudoElementType =
            CSSPseudoElementType::Count;
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum CSSPseudoElementType {
            after = 0,
            before = 1,
            backdrop = 2,
            cue = 3,
            firstLetter = 4,
            firstLine = 5,
            mozSelection = 6,
            mozFocusInner = 7,
            mozFocusOuter = 8,
            mozListBullet = 9,
            mozListNumber = 10,
            mozMathAnonymous = 11,
            mozNumberWrapper = 12,
            mozNumberText = 13,
            mozNumberSpinBox = 14,
            mozNumberSpinUp = 15,
            mozNumberSpinDown = 16,
            mozProgressBar = 17,
            mozRangeTrack = 18,
            mozRangeProgress = 19,
            mozRangeThumb = 20,
            mozMeterBar = 21,
            mozPlaceholder = 22,
            placeholder = 23,
            mozColorSwatch = 24,
            Count = 25,
            NonInheritingAnonBox = 26,
            XULTree = 27,
            NotPseudo = 28,
            MAX = 29,
        }
        /// Smart pointer class that can hold a pointer to either an nsStyleSet
        /// or a ServoStyleSet.
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct StyleSetHandle {
            pub mPtr: root::mozilla::StyleSetHandle_Ptr,
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct StyleSetHandle_Ptr {
            pub mValue: usize,
        }
        #[test]
        fn bindgen_test_layout_StyleSetHandle_Ptr() {
            assert_eq!(
                ::std::mem::size_of::<StyleSetHandle_Ptr>(),
                8usize,
                concat!("Size of: ", stringify!(StyleSetHandle_Ptr))
            );
            assert_eq!(
                ::std::mem::align_of::<StyleSetHandle_Ptr>(),
                8usize,
                concat!("Alignment of ", stringify!(StyleSetHandle_Ptr))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleSetHandle_Ptr>())).mValue as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleSetHandle_Ptr),
                    "::",
                    stringify!(mValue)
                )
            );
        }
        impl Clone for StyleSetHandle_Ptr {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[test]
        fn bindgen_test_layout_StyleSetHandle() {
            assert_eq!(
                ::std::mem::size_of::<StyleSetHandle>(),
                8usize,
                concat!("Size of: ", stringify!(StyleSetHandle))
            );
            assert_eq!(
                ::std::mem::align_of::<StyleSetHandle>(),
                8usize,
                concat!("Alignment of ", stringify!(StyleSetHandle))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<StyleSetHandle>())).mPtr as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleSetHandle),
                    "::",
                    stringify!(mPtr)
                )
            );
        }
        impl Clone for StyleSetHandle {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct SeenPtrs {
            pub _bindgen_opaque_blob: [u64; 4usize],
        }
        #[test]
        fn bindgen_test_layout_SeenPtrs() {
            assert_eq!(
                ::std::mem::size_of::<SeenPtrs>(),
                32usize,
                concat!("Size of: ", stringify!(SeenPtrs))
            );
            assert_eq!(
                ::std::mem::align_of::<SeenPtrs>(),
                8usize,
                concat!("Alignment of ", stringify!(SeenPtrs))
            );
        }
        impl Clone for SeenPtrs {
            fn clone(&self) -> Self {
                *self
            }
        }
        pub mod widget {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            /// Contains IMEStatus plus information about the current
            /// input context that the IME can use as hints if desired.
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct IMEState {
                pub mEnabled: root::mozilla::widget::IMEState_Enabled,
                pub mOpen: root::mozilla::widget::IMEState_Open,
            }
            /// 'Disabled' means the user cannot use IME. So, the IME open state should
            /// be 'closed' during 'disabled'.
            pub const IMEState_Enabled_DISABLED: root::mozilla::widget::IMEState_Enabled = 0;
            /// 'Enabled' means the user can use IME.
            pub const IMEState_Enabled_ENABLED: root::mozilla::widget::IMEState_Enabled = 1;
            /// 'Password' state is a special case for the password editors.
            /// E.g., on mac, the password editors should disable the non-Roman
            /// keyboard layouts at getting focus. Thus, the password editor may have
            /// special rules on some platforms.
            pub const IMEState_Enabled_PASSWORD: root::mozilla::widget::IMEState_Enabled = 2;
            /// This state is used when a plugin is focused.
            /// When a plug-in is focused content, we should send native events
            /// directly. Because we don't process some native events, but they may
            /// be needed by the plug-in.
            pub const IMEState_Enabled_PLUGIN: root::mozilla::widget::IMEState_Enabled = 3;
            /// 'Unknown' is useful when you cache this enum.  So, this shouldn't be
            /// used with nsIWidget::SetInputContext().
            pub const IMEState_Enabled_UNKNOWN: root::mozilla::widget::IMEState_Enabled = 4;
            /// IME enabled states, the mEnabled value of
            /// SetInputContext()/GetInputContext() should be one value of following
            /// values.
            ///
            /// WARNING: If you change these values, you also need to edit:
            /// nsIDOMWindowUtils.idl
            /// nsContentUtils::GetWidgetStatusFromIMEStatus
            pub type IMEState_Enabled = u32;
            /// 'Unsupported' means the platform cannot return actual IME open state.
            /// This value is used only by GetInputContext().
            pub const IMEState_Open_OPEN_STATE_NOT_SUPPORTED: root::mozilla::widget::IMEState_Open =
                0;
            /// 'Don't change' means the widget shouldn't change IME open state when
            /// SetInputContext() is called.
            pub const IMEState_Open_DONT_CHANGE_OPEN_STATE: root::mozilla::widget::IMEState_Open =
                0;
            /// 'Open' means that IME should compose in its primary language (or latest
            /// input mode except direct ASCII character input mode).  Even if IME is
            /// opened by this value, users should be able to close IME by theirselves.
            /// Web contents can specify this value by |ime-mode: active;|.
            pub const IMEState_Open_OPEN: root::mozilla::widget::IMEState_Open = 1;
            /// 'Closed' means that IME shouldn't handle key events (or should handle
            /// as ASCII character inputs on mobile device).  Even if IME is closed by
            /// this value, users should be able to open IME by theirselves.
            /// Web contents can specify this value by |ime-mode: inactive;|.
            pub const IMEState_Open_CLOSED: root::mozilla::widget::IMEState_Open = 2;
            /// IME open states the mOpen value of SetInputContext() should be one value of
            /// OPEN, CLOSE or DONT_CHANGE_OPEN_STATE.  GetInputContext() should return
            /// OPEN, CLOSE or OPEN_STATE_NOT_SUPPORTED.
            pub type IMEState_Open = u32;
            #[test]
            fn bindgen_test_layout_IMEState() {
                assert_eq!(
                    ::std::mem::size_of::<IMEState>(),
                    8usize,
                    concat!("Size of: ", stringify!(IMEState))
                );
                assert_eq!(
                    ::std::mem::align_of::<IMEState>(),
                    4usize,
                    concat!("Alignment of ", stringify!(IMEState))
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<IMEState>())).mEnabled as *const _ as usize },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(IMEState),
                        "::",
                        stringify!(mEnabled)
                    )
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<IMEState>())).mOpen as *const _ as usize },
                    4usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(IMEState),
                        "::",
                        stringify!(mOpen)
                    )
                );
            }
            impl Clone for IMEState {
                fn clone(&self) -> Self {
                    *self
                }
            }
        }
        /// This class is designed to cause crashes when various kinds of memory
        /// corruption are observed. For instance, let's say we have a class C where we
        /// suspect out-of-bounds writes to some members.  We can insert a member of type
        /// Poison near the members we suspect are being corrupted by out-of-bounds
        /// writes.  Or perhaps we have a class K we suspect is subject to use-after-free
        /// violations, in which case it doesn't particularly matter where in the class
        /// we add the member of type Poison.
        ///
        /// In either case, we then insert calls to Check() throughout the code.  Doing
        /// so enables us to narrow down the location where the corruption is occurring.
        /// A pleasant side-effect of these additional Check() calls is that crash
        /// signatures may become more regular, as crashes will ideally occur
        /// consolidated at the point of a Check(), rather than scattered about at
        /// various uses of the corrupted memory.
        #[repr(C)]
        #[derive(Debug)]
        pub struct CorruptionCanary {
            pub mValue: usize,
        }
        pub const CorruptionCanary_kCanarySet: usize = 252382987;
        #[test]
        fn bindgen_test_layout_CorruptionCanary() {
            assert_eq!(
                ::std::mem::size_of::<CorruptionCanary>(),
                8usize,
                concat!("Size of: ", stringify!(CorruptionCanary))
            );
            assert_eq!(
                ::std::mem::align_of::<CorruptionCanary>(),
                8usize,
                concat!("Alignment of ", stringify!(CorruptionCanary))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<CorruptionCanary>())).mValue as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CorruptionCanary),
                    "::",
                    stringify!(mValue)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct ArenaAllocator_ArenaHeader {
            /// The location in memory of the data portion of the arena.
            pub offset: usize,
            /// The location in memory of the end of the data portion of the arena.
            pub tail: usize,
        }
        impl Clone for ArenaAllocator_ArenaHeader {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct ArenaAllocator_ArenaChunk {
            pub canary: root::mozilla::CorruptionCanary,
            pub header: root::mozilla::ArenaAllocator_ArenaHeader,
            pub next: *mut root::mozilla::ArenaAllocator_ArenaChunk,
        }
        pub type LayoutDeviceIntPoint = [u32; 2usize];
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct LayoutDevicePixel {
            pub _address: u8,
        }
        #[test]
        fn bindgen_test_layout_LayoutDevicePixel() {
            assert_eq!(
                ::std::mem::size_of::<LayoutDevicePixel>(),
                1usize,
                concat!("Size of: ", stringify!(LayoutDevicePixel))
            );
            assert_eq!(
                ::std::mem::align_of::<LayoutDevicePixel>(),
                1usize,
                concat!("Alignment of ", stringify!(LayoutDevicePixel))
            );
        }
        impl Clone for LayoutDevicePixel {
            fn clone(&self) -> Self {
                *self
            }
        }
        pub mod a11y {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct DocAccessible {
                _unused: [u8; 0],
            }
            impl Clone for DocAccessible {
                fn clone(&self) -> Self {
                    *self
                }
            }
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct DOMEventTargetHelper {
            _unused: [u8; 0],
        }
        impl Clone for DOMEventTargetHelper {
            fn clone(&self) -> Self {
                *self
            }
        }
        pub const UseCounter_eUseCounter_UNKNOWN: root::mozilla::UseCounter = -1;
        pub const UseCounter_eUseCounter_SVGSVGElement_getElementById: root::mozilla::UseCounter =
            0;
        pub const UseCounter_eUseCounter_SVGSVGElement_currentScale_getter:
            root::mozilla::UseCounter = 1;
        pub const UseCounter_eUseCounter_SVGSVGElement_currentScale_setter:
            root::mozilla::UseCounter = 2;
        pub const UseCounter_eUseCounter_property_Fill: root::mozilla::UseCounter = 3;
        pub const UseCounter_eUseCounter_property_FillOpacity: root::mozilla::UseCounter = 4;
        pub const UseCounter_eUseCounter_XMLDocument_async_getter: root::mozilla::UseCounter = 5;
        pub const UseCounter_eUseCounter_XMLDocument_async_setter: root::mozilla::UseCounter = 6;
        pub const UseCounter_eUseCounter_DOMError_name_getter: root::mozilla::UseCounter = 7;
        pub const UseCounter_eUseCounter_DOMError_name_setter: root::mozilla::UseCounter = 8;
        pub const UseCounter_eUseCounter_DOMError_message_getter: root::mozilla::UseCounter = 9;
        pub const UseCounter_eUseCounter_DOMError_message_setter: root::mozilla::UseCounter = 10;
        pub const UseCounter_eUseCounter_custom_DOMErrorConstructor: root::mozilla::UseCounter = 11;
        pub const UseCounter_eUseCounter_PushManager_subscribe: root::mozilla::UseCounter = 12;
        pub const UseCounter_eUseCounter_PushSubscription_unsubscribe: root::mozilla::UseCounter =
            13;
        pub const UseCounter_eUseCounter_Window_sidebar_getter: root::mozilla::UseCounter = 14;
        pub const UseCounter_eUseCounter_Window_sidebar_setter: root::mozilla::UseCounter = 15;
        pub const UseCounter_eUseCounter_OfflineResourceList_swapCache: root::mozilla::UseCounter =
            16;
        pub const UseCounter_eUseCounter_OfflineResourceList_update: root::mozilla::UseCounter = 17;
        pub const UseCounter_eUseCounter_OfflineResourceList_status_getter:
            root::mozilla::UseCounter = 18;
        pub const UseCounter_eUseCounter_OfflineResourceList_status_setter:
            root::mozilla::UseCounter = 19;
        pub const UseCounter_eUseCounter_OfflineResourceList_onchecking_getter:
            root::mozilla::UseCounter = 20;
        pub const UseCounter_eUseCounter_OfflineResourceList_onchecking_setter:
            root::mozilla::UseCounter = 21;
        pub const UseCounter_eUseCounter_OfflineResourceList_onerror_getter:
            root::mozilla::UseCounter = 22;
        pub const UseCounter_eUseCounter_OfflineResourceList_onerror_setter:
            root::mozilla::UseCounter = 23;
        pub const UseCounter_eUseCounter_OfflineResourceList_onnoupdate_getter:
            root::mozilla::UseCounter = 24;
        pub const UseCounter_eUseCounter_OfflineResourceList_onnoupdate_setter:
            root::mozilla::UseCounter = 25;
        pub const UseCounter_eUseCounter_OfflineResourceList_ondownloading_getter:
            root::mozilla::UseCounter = 26;
        pub const UseCounter_eUseCounter_OfflineResourceList_ondownloading_setter:
            root::mozilla::UseCounter = 27;
        pub const UseCounter_eUseCounter_OfflineResourceList_onprogress_getter:
            root::mozilla::UseCounter = 28;
        pub const UseCounter_eUseCounter_OfflineResourceList_onprogress_setter:
            root::mozilla::UseCounter = 29;
        pub const UseCounter_eUseCounter_OfflineResourceList_onupdateready_getter:
            root::mozilla::UseCounter = 30;
        pub const UseCounter_eUseCounter_OfflineResourceList_onupdateready_setter:
            root::mozilla::UseCounter = 31;
        pub const UseCounter_eUseCounter_OfflineResourceList_oncached_getter:
            root::mozilla::UseCounter = 32;
        pub const UseCounter_eUseCounter_OfflineResourceList_oncached_setter:
            root::mozilla::UseCounter = 33;
        pub const UseCounter_eUseCounter_OfflineResourceList_onobsolete_getter:
            root::mozilla::UseCounter = 34;
        pub const UseCounter_eUseCounter_OfflineResourceList_onobsolete_setter:
            root::mozilla::UseCounter = 35;
        pub const UseCounter_eUseCounter_IDBDatabase_createMutableFile: root::mozilla::UseCounter =
            36;
        pub const UseCounter_eUseCounter_IDBDatabase_mozCreateFileHandle:
            root::mozilla::UseCounter = 37;
        pub const UseCounter_eUseCounter_IDBMutableFile_open: root::mozilla::UseCounter = 38;
        pub const UseCounter_eUseCounter_IDBMutableFile_getFile: root::mozilla::UseCounter = 39;
        pub const UseCounter_eUseCounter_DataTransfer_addElement: root::mozilla::UseCounter = 40;
        pub const UseCounter_eUseCounter_DataTransfer_mozItemCount_getter:
            root::mozilla::UseCounter = 41;
        pub const UseCounter_eUseCounter_DataTransfer_mozItemCount_setter:
            root::mozilla::UseCounter = 42;
        pub const UseCounter_eUseCounter_DataTransfer_mozCursor_getter: root::mozilla::UseCounter =
            43;
        pub const UseCounter_eUseCounter_DataTransfer_mozCursor_setter: root::mozilla::UseCounter =
            44;
        pub const UseCounter_eUseCounter_DataTransfer_mozTypesAt: root::mozilla::UseCounter = 45;
        pub const UseCounter_eUseCounter_DataTransfer_mozClearDataAt: root::mozilla::UseCounter =
            46;
        pub const UseCounter_eUseCounter_DataTransfer_mozSetDataAt: root::mozilla::UseCounter = 47;
        pub const UseCounter_eUseCounter_DataTransfer_mozGetDataAt: root::mozilla::UseCounter = 48;
        pub const UseCounter_eUseCounter_DataTransfer_mozUserCancelled_getter:
            root::mozilla::UseCounter = 49;
        pub const UseCounter_eUseCounter_DataTransfer_mozUserCancelled_setter:
            root::mozilla::UseCounter = 50;
        pub const UseCounter_eUseCounter_DataTransfer_mozSourceNode_getter:
            root::mozilla::UseCounter = 51;
        pub const UseCounter_eUseCounter_DataTransfer_mozSourceNode_setter:
            root::mozilla::UseCounter = 52;
        pub const UseCounter_eUseCounter_custom_JS_asmjs: root::mozilla::UseCounter = 53;
        pub const UseCounter_eUseCounter_custom_JS_wasm: root::mozilla::UseCounter = 54;
        pub const UseCounter_eUseCounter_EnablePrivilege: root::mozilla::UseCounter = 55;
        pub const UseCounter_eUseCounter_DOMExceptionCode: root::mozilla::UseCounter = 56;
        pub const UseCounter_eUseCounter_MutationEvent: root::mozilla::UseCounter = 57;
        pub const UseCounter_eUseCounter_Components: root::mozilla::UseCounter = 58;
        pub const UseCounter_eUseCounter_PrefixedVisibilityAPI: root::mozilla::UseCounter = 59;
        pub const UseCounter_eUseCounter_NodeIteratorDetach: root::mozilla::UseCounter = 60;
        pub const UseCounter_eUseCounter_LenientThis: root::mozilla::UseCounter = 61;
        pub const UseCounter_eUseCounter_GetSetUserData: root::mozilla::UseCounter = 62;
        pub const UseCounter_eUseCounter_MozGetAsFile: root::mozilla::UseCounter = 63;
        pub const UseCounter_eUseCounter_UseOfCaptureEvents: root::mozilla::UseCounter = 64;
        pub const UseCounter_eUseCounter_UseOfReleaseEvents: root::mozilla::UseCounter = 65;
        pub const UseCounter_eUseCounter_UseOfDOM3LoadMethod: root::mozilla::UseCounter = 66;
        pub const UseCounter_eUseCounter_ChromeUseOfDOM3LoadMethod: root::mozilla::UseCounter = 67;
        pub const UseCounter_eUseCounter_ShowModalDialog: root::mozilla::UseCounter = 68;
        pub const UseCounter_eUseCounter_SyncXMLHttpRequest: root::mozilla::UseCounter = 69;
        pub const UseCounter_eUseCounter_Window_Cc_ontrollers: root::mozilla::UseCounter = 70;
        pub const UseCounter_eUseCounter_ImportXULIntoContent: root::mozilla::UseCounter = 71;
        pub const UseCounter_eUseCounter_PannerNodeDoppler: root::mozilla::UseCounter = 72;
        pub const UseCounter_eUseCounter_NavigatorGetUserMedia: root::mozilla::UseCounter = 73;
        pub const UseCounter_eUseCounter_WebrtcDeprecatedPrefix: root::mozilla::UseCounter = 74;
        pub const UseCounter_eUseCounter_RTCPeerConnectionGetStreams: root::mozilla::UseCounter =
            75;
        pub const UseCounter_eUseCounter_AppCache: root::mozilla::UseCounter = 76;
        pub const UseCounter_eUseCounter_AppCacheInsecure: root::mozilla::UseCounter = 77;
        pub const UseCounter_eUseCounter_PrefixedImageSmoothingEnabled: root::mozilla::UseCounter =
            78;
        pub const UseCounter_eUseCounter_PrefixedFullscreenAPI: root::mozilla::UseCounter = 79;
        pub const UseCounter_eUseCounter_LenientSetter: root::mozilla::UseCounter = 80;
        pub const UseCounter_eUseCounter_FileLastModifiedDate: root::mozilla::UseCounter = 81;
        pub const UseCounter_eUseCounter_ImageBitmapRenderingContext_TransferImageBitmap:
            root::mozilla::UseCounter = 82;
        pub const UseCounter_eUseCounter_URLCreateObjectURL_MediaStream: root::mozilla::UseCounter =
            83;
        pub const UseCounter_eUseCounter_XMLBaseAttribute: root::mozilla::UseCounter = 84;
        pub const UseCounter_eUseCounter_WindowContentUntrusted: root::mozilla::UseCounter = 85;
        pub const UseCounter_eUseCounter_RegisterProtocolHandlerInsecure:
            root::mozilla::UseCounter = 86;
        pub const UseCounter_eUseCounter_MixedDisplayObjectSubrequest: root::mozilla::UseCounter =
            87;
        pub const UseCounter_eUseCounter_MotionEvent: root::mozilla::UseCounter = 88;
        pub const UseCounter_eUseCounter_OrientationEvent: root::mozilla::UseCounter = 89;
        pub const UseCounter_eUseCounter_ProximityEvent: root::mozilla::UseCounter = 90;
        pub const UseCounter_eUseCounter_AmbientLightEvent: root::mozilla::UseCounter = 91;
        pub const UseCounter_eUseCounter_Count: root::mozilla::UseCounter = 92;
        pub type UseCounter = i16;
        pub const LogLevel_Disabled: root::mozilla::LogLevel = 0;
        pub const LogLevel_Error: root::mozilla::LogLevel = 1;
        pub const LogLevel_Warning: root::mozilla::LogLevel = 2;
        pub const LogLevel_Info: root::mozilla::LogLevel = 3;
        pub const LogLevel_Debug: root::mozilla::LogLevel = 4;
        pub const LogLevel_Verbose: root::mozilla::LogLevel = 5;
        pub type LogLevel = i32;
        #[repr(C)]
        #[derive(Debug)]
        pub struct LogModule {
            pub mName: *mut ::std::os::raw::c_char,
            pub mLevel: u32,
        }
        #[test]
        fn bindgen_test_layout_LogModule() {
            assert_eq!(
                ::std::mem::size_of::<LogModule>(),
                16usize,
                concat!("Size of: ", stringify!(LogModule))
            );
            assert_eq!(
                ::std::mem::align_of::<LogModule>(),
                8usize,
                concat!("Alignment of ", stringify!(LogModule))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<LogModule>())).mName as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(LogModule),
                    "::",
                    stringify!(mName)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<LogModule>())).mLevel as *const _ as usize },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(LogModule),
                    "::",
                    stringify!(mLevel)
                )
            );
        }
        /// Helper class that lazy loads the given log module. This is safe to use for
        /// declaring static references to log modules and can be used as a replacement
        /// for accessing a LogModule directly.
        ///
        /// Example usage:
        /// static LazyLogModule sLayoutLog("layout");
        ///
        /// void Foo() {
        /// MOZ_LOG(sLayoutLog, LogLevel::Verbose, ("Entering foo"));
        /// }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct LazyLogModule {
            pub mLogName: *const ::std::os::raw::c_char,
            pub mLog: u64,
        }
        #[test]
        fn bindgen_test_layout_LazyLogModule() {
            assert_eq!(
                ::std::mem::size_of::<LazyLogModule>(),
                16usize,
                concat!("Size of: ", stringify!(LazyLogModule))
            );
            assert_eq!(
                ::std::mem::align_of::<LazyLogModule>(),
                8usize,
                concat!("Alignment of ", stringify!(LazyLogModule))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<LazyLogModule>())).mLogName as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(LazyLogModule),
                    "::",
                    stringify!(mLogName)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<LazyLogModule>())).mLog as *const _ as usize },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(LazyLogModule),
                    "::",
                    stringify!(mLog)
                )
            );
        }
        impl Clone for LazyLogModule {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct Runnable {
            pub _base: root::nsIRunnable,
            pub _base_1: root::nsINamed,
            pub mRefCnt: root::mozilla::ThreadSafeAutoRefCnt,
            pub mName: *const ::std::os::raw::c_char,
        }
        pub type Runnable_HasThreadSafeRefCnt = root::mozilla::TrueType;
        #[test]
        fn bindgen_test_layout_Runnable() {
            assert_eq!(
                ::std::mem::size_of::<Runnable>(),
                32usize,
                concat!("Size of: ", stringify!(Runnable))
            );
            assert_eq!(
                ::std::mem::align_of::<Runnable>(),
                8usize,
                concat!("Alignment of ", stringify!(Runnable))
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct CancelableRunnable {
            pub _base: root::mozilla::Runnable,
            pub _base_1: root::nsICancelableRunnable,
        }
        #[test]
        fn bindgen_test_layout_CancelableRunnable() {
            assert_eq!(
                ::std::mem::size_of::<CancelableRunnable>(),
                40usize,
                concat!("Size of: ", stringify!(CancelableRunnable))
            );
            assert_eq!(
                ::std::mem::align_of::<CancelableRunnable>(),
                8usize,
                concat!("Alignment of ", stringify!(CancelableRunnable))
            );
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct SegmentedVector_SegmentImpl_Storage {
            pub mBuf: root::__BindgenUnionField<*mut ::std::os::raw::c_char>,
            pub mAlign: root::__BindgenUnionField<u8>,
            pub bindgen_union_field: u64,
        }
        pub type SegmentedVector_Segment = u8;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct SegmentedVector_IterImpl {
            pub mSegment: *mut root::mozilla::SegmentedVector_Segment,
            pub mIndex: usize,
        }
        pub type ComputedKeyframeValues =
            root::nsTArray<root::mozilla::PropertyStyleAnimationValuePair>;
        #[test]
        fn __bindgen_test_layout_DefaultDelete_open0_RawServoStyleSet_close0_instantiation() {
            assert_eq!(
                ::std::mem::size_of::<root::mozilla::DefaultDelete>(),
                1usize,
                concat!(
                    "Size of template specialization: ",
                    stringify!(root::mozilla::DefaultDelete)
                )
            );
            assert_eq!(
                ::std::mem::align_of::<root::mozilla::DefaultDelete>(),
                1usize,
                concat!(
                    "Alignment of template specialization: ",
                    stringify!(root::mozilla::DefaultDelete)
                )
            );
        }
        #[test]
        fn __bindgen_test_layout_DefaultDelete_open0_RawServoAuthorStyles_close0_instantiation() {
            assert_eq!(
                ::std::mem::size_of::<root::mozilla::DefaultDelete>(),
                1usize,
                concat!(
                    "Size of template specialization: ",
                    stringify!(root::mozilla::DefaultDelete)
                )
            );
            assert_eq!(
                ::std::mem::align_of::<root::mozilla::DefaultDelete>(),
                1usize,
                concat!(
                    "Alignment of template specialization: ",
                    stringify!(root::mozilla::DefaultDelete)
                )
            );
        }
        #[test]
        fn __bindgen_test_layout_DefaultDelete_open0_RawServoSelectorList_close0_instantiation() {
            assert_eq!(
                ::std::mem::size_of::<root::mozilla::DefaultDelete>(),
                1usize,
                concat!(
                    "Size of template specialization: ",
                    stringify!(root::mozilla::DefaultDelete)
                )
            );
            assert_eq!(
                ::std::mem::align_of::<root::mozilla::DefaultDelete>(),
                1usize,
                concat!(
                    "Alignment of template specialization: ",
                    stringify!(root::mozilla::DefaultDelete)
                )
            );
        }
        #[test]
        fn __bindgen_test_layout_DefaultDelete_open0_RawServoSourceSizeList_close0_instantiation() {
            assert_eq!(
                ::std::mem::size_of::<root::mozilla::DefaultDelete>(),
                1usize,
                concat!(
                    "Size of template specialization: ",
                    stringify!(root::mozilla::DefaultDelete)
                )
            );
            assert_eq!(
                ::std::mem::align_of::<root::mozilla::DefaultDelete>(),
                1usize,
                concat!(
                    "Alignment of template specialization: ",
                    stringify!(root::mozilla::DefaultDelete)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct ScrollbarStyles {
            pub mHorizontal: u8,
            pub mVertical: u8,
            pub mScrollBehavior: u8,
            pub mOverscrollBehaviorX: root::mozilla::StyleOverscrollBehavior,
            pub mOverscrollBehaviorY: root::mozilla::StyleOverscrollBehavior,
            pub mScrollSnapTypeX: u8,
            pub mScrollSnapTypeY: u8,
            pub mScrollSnapPointsX: root::nsStyleCoord,
            pub mScrollSnapPointsY: root::nsStyleCoord,
            pub mScrollSnapDestinationX: root::nsStyleCoord_CalcValue,
            pub mScrollSnapDestinationY: root::nsStyleCoord_CalcValue,
        }
        #[test]
        fn bindgen_test_layout_ScrollbarStyles() {
            assert_eq!(
                ::std::mem::size_of::<ScrollbarStyles>(),
                64usize,
                concat!("Size of: ", stringify!(ScrollbarStyles))
            );
            assert_eq!(
                ::std::mem::align_of::<ScrollbarStyles>(),
                8usize,
                concat!("Alignment of ", stringify!(ScrollbarStyles))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ScrollbarStyles>())).mHorizontal as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ScrollbarStyles),
                    "::",
                    stringify!(mHorizontal)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ScrollbarStyles>())).mVertical as *const _ as usize
                },
                1usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ScrollbarStyles),
                    "::",
                    stringify!(mVertical)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ScrollbarStyles>())).mScrollBehavior as *const _ as usize
                },
                2usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ScrollbarStyles),
                    "::",
                    stringify!(mScrollBehavior)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ScrollbarStyles>())).mOverscrollBehaviorX as *const _
                        as usize
                },
                3usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ScrollbarStyles),
                    "::",
                    stringify!(mOverscrollBehaviorX)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ScrollbarStyles>())).mOverscrollBehaviorY as *const _
                        as usize
                },
                4usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ScrollbarStyles),
                    "::",
                    stringify!(mOverscrollBehaviorY)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ScrollbarStyles>())).mScrollSnapTypeX as *const _
                        as usize
                },
                5usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ScrollbarStyles),
                    "::",
                    stringify!(mScrollSnapTypeX)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ScrollbarStyles>())).mScrollSnapTypeY as *const _
                        as usize
                },
                6usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ScrollbarStyles),
                    "::",
                    stringify!(mScrollSnapTypeY)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ScrollbarStyles>())).mScrollSnapPointsX as *const _
                        as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ScrollbarStyles),
                    "::",
                    stringify!(mScrollSnapPointsX)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ScrollbarStyles>())).mScrollSnapPointsY as *const _
                        as usize
                },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ScrollbarStyles),
                    "::",
                    stringify!(mScrollSnapPointsY)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ScrollbarStyles>())).mScrollSnapDestinationX as *const _
                        as usize
                },
                40usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ScrollbarStyles),
                    "::",
                    stringify!(mScrollSnapDestinationX)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ScrollbarStyles>())).mScrollSnapDestinationY as *const _
                        as usize
                },
                52usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ScrollbarStyles),
                    "::",
                    stringify!(mScrollSnapDestinationY)
                )
            );
        }
        #[repr(C)]
        pub struct LangGroupFontPrefs {
            pub mLangGroup: root::RefPtr<root::nsAtom>,
            pub mMinimumFontSize: root::nscoord,
            pub mDefaultVariableFont: root::nsFont,
            pub mDefaultFixedFont: root::nsFont,
            pub mDefaultSerifFont: root::nsFont,
            pub mDefaultSansSerifFont: root::nsFont,
            pub mDefaultMonospaceFont: root::nsFont,
            pub mDefaultCursiveFont: root::nsFont,
            pub mDefaultFantasyFont: root::nsFont,
            pub mNext: root::nsAutoPtr<root::mozilla::LangGroupFontPrefs>,
        }
        #[test]
        fn bindgen_test_layout_LangGroupFontPrefs() {
            assert_eq!(
                ::std::mem::size_of::<LangGroupFontPrefs>(),
                696usize,
                concat!("Size of: ", stringify!(LangGroupFontPrefs))
            );
            assert_eq!(
                ::std::mem::align_of::<LangGroupFontPrefs>(),
                8usize,
                concat!("Alignment of ", stringify!(LangGroupFontPrefs))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<LangGroupFontPrefs>())).mLangGroup as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(LangGroupFontPrefs),
                    "::",
                    stringify!(mLangGroup)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<LangGroupFontPrefs>())).mMinimumFontSize as *const _
                        as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(LangGroupFontPrefs),
                    "::",
                    stringify!(mMinimumFontSize)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<LangGroupFontPrefs>())).mDefaultVariableFont as *const _
                        as usize
                },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(LangGroupFontPrefs),
                    "::",
                    stringify!(mDefaultVariableFont)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<LangGroupFontPrefs>())).mDefaultFixedFont as *const _
                        as usize
                },
                112usize,
                concat!(
                    "Offset of field: ",
                    stringify!(LangGroupFontPrefs),
                    "::",
                    stringify!(mDefaultFixedFont)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<LangGroupFontPrefs>())).mDefaultSerifFont as *const _
                        as usize
                },
                208usize,
                concat!(
                    "Offset of field: ",
                    stringify!(LangGroupFontPrefs),
                    "::",
                    stringify!(mDefaultSerifFont)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<LangGroupFontPrefs>())).mDefaultSansSerifFont as *const _
                        as usize
                },
                304usize,
                concat!(
                    "Offset of field: ",
                    stringify!(LangGroupFontPrefs),
                    "::",
                    stringify!(mDefaultSansSerifFont)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<LangGroupFontPrefs>())).mDefaultMonospaceFont as *const _
                        as usize
                },
                400usize,
                concat!(
                    "Offset of field: ",
                    stringify!(LangGroupFontPrefs),
                    "::",
                    stringify!(mDefaultMonospaceFont)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<LangGroupFontPrefs>())).mDefaultCursiveFont as *const _
                        as usize
                },
                496usize,
                concat!(
                    "Offset of field: ",
                    stringify!(LangGroupFontPrefs),
                    "::",
                    stringify!(mDefaultCursiveFont)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<LangGroupFontPrefs>())).mDefaultFantasyFont as *const _
                        as usize
                },
                592usize,
                concat!(
                    "Offset of field: ",
                    stringify!(LangGroupFontPrefs),
                    "::",
                    stringify!(mDefaultFantasyFont)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<LangGroupFontPrefs>())).mNext as *const _ as usize
                },
                688usize,
                concat!(
                    "Offset of field: ",
                    stringify!(LangGroupFontPrefs),
                    "::",
                    stringify!(mNext)
                )
            );
        }
        /// Some functionality that has historically lived on nsPresContext does not
        /// actually need to be per-document. This singleton class serves as a host
        /// for that functionality. We delegate to it from nsPresContext where
        /// appropriate, and use it standalone in some cases as well.
        #[repr(C)]
        pub struct StaticPresData {
            pub mLangService: *mut root::nsLanguageAtomService,
            pub mBorderWidthTable: [root::nscoord; 3usize],
            pub mStaticLangGroupFontPrefs: root::mozilla::LangGroupFontPrefs,
        }
        #[test]
        fn bindgen_test_layout_StaticPresData() {
            assert_eq!(
                ::std::mem::size_of::<StaticPresData>(),
                720usize,
                concat!("Size of: ", stringify!(StaticPresData))
            );
            assert_eq!(
                ::std::mem::align_of::<StaticPresData>(),
                8usize,
                concat!("Alignment of ", stringify!(StaticPresData))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StaticPresData>())).mLangService as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StaticPresData),
                    "::",
                    stringify!(mLangService)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StaticPresData>())).mBorderWidthTable as *const _
                        as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StaticPresData),
                    "::",
                    stringify!(mBorderWidthTable)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StaticPresData>())).mStaticLangGroupFontPrefs as *const _
                        as usize
                },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StaticPresData),
                    "::",
                    stringify!(mStaticLangGroupFontPrefs)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct AnimationEventDispatcher {
            _unused: [u8; 0],
        }
        impl Clone for AnimationEventDispatcher {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct EventStateManager {
            _unused: [u8; 0],
        }
        impl Clone for EventStateManager {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct RestyleManager {
            _unused: [u8; 0],
        }
        impl Clone for RestyleManager {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct URLExtraData {
            pub mRefCnt: root::mozilla::ThreadSafeAutoRefCnt,
            pub mBaseURI: root::nsCOMPtr,
            pub mReferrer: root::nsCOMPtr,
            pub mPrincipal: root::nsCOMPtr,
            pub mIsChrome: bool,
        }
        pub type URLExtraData_HasThreadSafeRefCnt = root::mozilla::TrueType;
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla12URLExtraData6sDummyE"]
            pub static mut URLExtraData_sDummy:
                root::mozilla::StaticRefPtr<root::mozilla::URLExtraData>;
        }
        #[test]
        fn bindgen_test_layout_URLExtraData() {
            assert_eq!(
                ::std::mem::size_of::<URLExtraData>(),
                40usize,
                concat!("Size of: ", stringify!(URLExtraData))
            );
            assert_eq!(
                ::std::mem::align_of::<URLExtraData>(),
                8usize,
                concat!("Alignment of ", stringify!(URLExtraData))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<URLExtraData>())).mRefCnt as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(URLExtraData),
                    "::",
                    stringify!(mRefCnt)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<URLExtraData>())).mBaseURI as *const _ as usize },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(URLExtraData),
                    "::",
                    stringify!(mBaseURI)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<URLExtraData>())).mReferrer as *const _ as usize },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(URLExtraData),
                    "::",
                    stringify!(mReferrer)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<URLExtraData>())).mPrincipal as *const _ as usize },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(URLExtraData),
                    "::",
                    stringify!(mPrincipal)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<URLExtraData>())).mIsChrome as *const _ as usize },
                32usize,
                concat!(
                    "Offset of field: ",
                    stringify!(URLExtraData),
                    "::",
                    stringify!(mIsChrome)
                )
            );
        }
        #[test]
        fn __bindgen_test_layout_StaticRefPtr_open0_URLExtraData_close0_instantiation() {
            assert_eq!(
                ::std::mem::size_of::<root::mozilla::StaticRefPtr<root::mozilla::URLExtraData>>(),
                8usize,
                concat!(
                    "Size of template specialization: ",
                    stringify!(root::mozilla::StaticRefPtr<root::mozilla::URLExtraData>)
                )
            );
            assert_eq!(
                ::std::mem::align_of::<root::mozilla::StaticRefPtr<root::mozilla::URLExtraData>>(),
                8usize,
                concat!(
                    "Alignment of template specialization: ",
                    stringify!(root::mozilla::StaticRefPtr<root::mozilla::URLExtraData>)
                )
            );
        }
        /// BlockingResourceBase
        /// Base class of resources that might block clients trying to acquire them.
        /// Does debugging and deadlock detection in DEBUG builds.
        #[repr(C)]
        #[derive(Debug)]
        pub struct BlockingResourceBase {
            pub _address: u8,
        }
        pub const BlockingResourceBase_BlockingResourceType_eMutex:
            root::mozilla::BlockingResourceBase_BlockingResourceType = 0;
        pub const BlockingResourceBase_BlockingResourceType_eReentrantMonitor:
            root::mozilla::BlockingResourceBase_BlockingResourceType = 1;
        pub const BlockingResourceBase_BlockingResourceType_eCondVar:
            root::mozilla::BlockingResourceBase_BlockingResourceType = 2;
        pub const BlockingResourceBase_BlockingResourceType_eRecursiveMutex:
            root::mozilla::BlockingResourceBase_BlockingResourceType = 3;
        pub type BlockingResourceBase_BlockingResourceType = u32;
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla20BlockingResourceBase17kResourceTypeNameE"]
            pub static mut BlockingResourceBase_kResourceTypeName:
                [*const ::std::os::raw::c_char; 0usize];
        }
        #[test]
        fn bindgen_test_layout_BlockingResourceBase() {
            assert_eq!(
                ::std::mem::size_of::<BlockingResourceBase>(),
                1usize,
                concat!("Size of: ", stringify!(BlockingResourceBase))
            );
            assert_eq!(
                ::std::mem::align_of::<BlockingResourceBase>(),
                1usize,
                concat!("Alignment of ", stringify!(BlockingResourceBase))
            );
        }
        /// OffTheBooksMutex is identical to Mutex, except that OffTheBooksMutex doesn't
        /// include leak checking.  Sometimes you want to intentionally "leak" a mutex
        /// until shutdown; in these cases, OffTheBooksMutex is for you.
        #[repr(C)]
        #[derive(Debug)]
        pub struct OffTheBooksMutex {
            pub _base: root::mozilla::detail::MutexImpl,
        }
        #[test]
        fn bindgen_test_layout_OffTheBooksMutex() {
            assert_eq!(
                ::std::mem::size_of::<OffTheBooksMutex>(),
                40usize,
                concat!("Size of: ", stringify!(OffTheBooksMutex))
            );
            assert_eq!(
                ::std::mem::align_of::<OffTheBooksMutex>(),
                8usize,
                concat!("Alignment of ", stringify!(OffTheBooksMutex))
            );
        }
        /// Mutex
        /// When possible, use MutexAutoLock/MutexAutoUnlock to lock/unlock this
        /// mutex within a scope, instead of calling Lock/Unlock directly.
        #[repr(C)]
        #[derive(Debug)]
        pub struct Mutex {
            pub _base: root::mozilla::OffTheBooksMutex,
        }
        #[test]
        fn bindgen_test_layout_Mutex() {
            assert_eq!(
                ::std::mem::size_of::<Mutex>(),
                40usize,
                concat!("Size of: ", stringify!(Mutex))
            );
            assert_eq!(
                ::std::mem::align_of::<Mutex>(),
                8usize,
                concat!("Alignment of ", stringify!(Mutex))
            );
        }
        pub mod image {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct ImageURL {
                _unused: [u8; 0],
            }
            impl Clone for ImageURL {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct Image {
                _unused: [u8; 0],
            }
            impl Clone for Image {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct ProgressTracker {
                _unused: [u8; 0],
            }
            impl Clone for ProgressTracker {
                fn clone(&self) -> Self {
                    *self
                }
            }
            #[repr(C)]
            pub struct IProgressObserver__bindgen_vtable(::std::os::raw::c_void);
            /// An interface for observing changes to image state, as reported by
            /// ProgressTracker.
            ///
            /// This is the ImageLib-internal version of imgINotificationObserver,
            /// essentially, with implementation details that code outside of ImageLib
            /// shouldn't see.
            ///
            /// XXX(seth): It's preferable to avoid adding anything to this interface if
            /// possible.  In the long term, it would be ideal to get to a place where we can
            /// just use the imgINotificationObserver interface internally as well.
            #[repr(C)]
            #[derive(Debug)]
            pub struct IProgressObserver {
                pub vtable_: *const IProgressObserver__bindgen_vtable,
                pub _base: u64,
            }
            #[test]
            fn bindgen_test_layout_IProgressObserver() {
                assert_eq!(
                    ::std::mem::size_of::<IProgressObserver>(),
                    16usize,
                    concat!("Size of: ", stringify!(IProgressObserver))
                );
                assert_eq!(
                    ::std::mem::align_of::<IProgressObserver>(),
                    8usize,
                    concat!("Alignment of ", stringify!(IProgressObserver))
                );
            }
        }
        #[repr(C)]
        pub struct CounterStyle__bindgen_vtable(::std::os::raw::c_void);
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct CounterStyle {
            pub vtable_: *const CounterStyle__bindgen_vtable,
            pub mStyle: i32,
        }
        #[test]
        fn bindgen_test_layout_CounterStyle() {
            assert_eq!(
                ::std::mem::size_of::<CounterStyle>(),
                16usize,
                concat!("Size of: ", stringify!(CounterStyle))
            );
            assert_eq!(
                ::std::mem::align_of::<CounterStyle>(),
                8usize,
                concat!("Alignment of ", stringify!(CounterStyle))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<CounterStyle>())).mStyle as *const _ as usize },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CounterStyle),
                    "::",
                    stringify!(mStyle)
                )
            );
        }
        impl Clone for CounterStyle {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        pub struct AnonymousCounterStyle {
            pub _base: root::mozilla::CounterStyle,
            pub mRefCnt: root::mozilla::ThreadSafeAutoRefCnt,
            pub mSingleString: bool,
            pub mSystem: u8,
            pub mSymbols: root::nsTArray<::nsstring::nsStringRepr>,
        }
        pub type AnonymousCounterStyle_HasThreadSafeRefCnt = root::mozilla::TrueType;
        #[test]
        fn bindgen_test_layout_AnonymousCounterStyle() {
            assert_eq!(
                ::std::mem::size_of::<AnonymousCounterStyle>(),
                40usize,
                concat!("Size of: ", stringify!(AnonymousCounterStyle))
            );
            assert_eq!(
                ::std::mem::align_of::<AnonymousCounterStyle>(),
                8usize,
                concat!("Alignment of ", stringify!(AnonymousCounterStyle))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<AnonymousCounterStyle>())).mRefCnt as *const _ as usize
                },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(AnonymousCounterStyle),
                    "::",
                    stringify!(mRefCnt)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<AnonymousCounterStyle>())).mSingleString as *const _
                        as usize
                },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(AnonymousCounterStyle),
                    "::",
                    stringify!(mSingleString)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<AnonymousCounterStyle>())).mSystem as *const _ as usize
                },
                25usize,
                concat!(
                    "Offset of field: ",
                    stringify!(AnonymousCounterStyle),
                    "::",
                    stringify!(mSystem)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<AnonymousCounterStyle>())).mSymbols as *const _ as usize
                },
                32usize,
                concat!(
                    "Offset of field: ",
                    stringify!(AnonymousCounterStyle),
                    "::",
                    stringify!(mSymbols)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct CounterStylePtr {
            pub mRaw: usize,
        }
        pub const CounterStylePtr_Type_eCounterStyle: root::mozilla::CounterStylePtr_Type = 0;
        pub const CounterStylePtr_Type_eAnonymousCounterStyle: root::mozilla::CounterStylePtr_Type =
            1;
        pub const CounterStylePtr_Type_eUnresolvedAtom: root::mozilla::CounterStylePtr_Type = 2;
        pub const CounterStylePtr_Type_eMask: root::mozilla::CounterStylePtr_Type = 3;
        pub type CounterStylePtr_Type = u64;
        #[test]
        fn bindgen_test_layout_CounterStylePtr() {
            assert_eq!(
                ::std::mem::size_of::<CounterStylePtr>(),
                8usize,
                concat!("Size of: ", stringify!(CounterStylePtr))
            );
            assert_eq!(
                ::std::mem::align_of::<CounterStylePtr>(),
                8usize,
                concat!("Alignment of ", stringify!(CounterStylePtr))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<CounterStylePtr>())).mRaw as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CounterStylePtr),
                    "::",
                    stringify!(mRaw)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct CounterStyleManager {
            pub mRefCnt: root::nsAutoRefCnt,
            pub mPresContext: *mut root::nsPresContext,
            pub mStyles: [u64; 4usize],
            pub mRetiredStyles: root::nsTArray<*mut root::mozilla::CounterStyle>,
        }
        pub type CounterStyleManager_HasThreadSafeRefCnt = root::mozilla::FalseType;
        #[test]
        fn bindgen_test_layout_CounterStyleManager() {
            assert_eq!(
                ::std::mem::size_of::<CounterStyleManager>(),
                56usize,
                concat!("Size of: ", stringify!(CounterStyleManager))
            );
            assert_eq!(
                ::std::mem::align_of::<CounterStyleManager>(),
                8usize,
                concat!("Alignment of ", stringify!(CounterStyleManager))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CounterStyleManager>())).mRefCnt as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CounterStyleManager),
                    "::",
                    stringify!(mRefCnt)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CounterStyleManager>())).mPresContext as *const _
                        as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CounterStyleManager),
                    "::",
                    stringify!(mPresContext)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CounterStyleManager>())).mStyles as *const _ as usize
                },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CounterStyleManager),
                    "::",
                    stringify!(mStyles)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CounterStyleManager>())).mRetiredStyles as *const _
                        as usize
                },
                48usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CounterStyleManager),
                    "::",
                    stringify!(mRetiredStyles)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct Position {
            pub mXPosition: root::mozilla::Position_Coord,
            pub mYPosition: root::mozilla::Position_Coord,
        }
        pub type Position_Coord = root::nsStyleCoord_CalcValue;
        #[test]
        fn bindgen_test_layout_Position() {
            assert_eq!(
                ::std::mem::size_of::<Position>(),
                24usize,
                concat!("Size of: ", stringify!(Position))
            );
            assert_eq!(
                ::std::mem::align_of::<Position>(),
                4usize,
                concat!("Alignment of ", stringify!(Position))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<Position>())).mXPosition as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Position),
                    "::",
                    stringify!(mXPosition)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<Position>())).mYPosition as *const _ as usize },
                12usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Position),
                    "::",
                    stringify!(mYPosition)
                )
            );
        }
        impl Clone for Position {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct StyleTransition {
            pub mTimingFunction: root::nsTimingFunction,
            pub mDuration: f32,
            pub mDelay: f32,
            pub mProperty: root::nsCSSPropertyID,
            pub mUnknownProperty: root::RefPtr<root::nsAtom>,
        }
        #[test]
        fn bindgen_test_layout_StyleTransition() {
            assert_eq!(
                ::std::mem::size_of::<StyleTransition>(),
                40usize,
                concat!("Size of: ", stringify!(StyleTransition))
            );
            assert_eq!(
                ::std::mem::align_of::<StyleTransition>(),
                8usize,
                concat!("Alignment of ", stringify!(StyleTransition))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleTransition>())).mTimingFunction as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleTransition),
                    "::",
                    stringify!(mTimingFunction)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleTransition>())).mDuration as *const _ as usize
                },
                20usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleTransition),
                    "::",
                    stringify!(mDuration)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<StyleTransition>())).mDelay as *const _ as usize },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleTransition),
                    "::",
                    stringify!(mDelay)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleTransition>())).mProperty as *const _ as usize
                },
                28usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleTransition),
                    "::",
                    stringify!(mProperty)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleTransition>())).mUnknownProperty as *const _
                        as usize
                },
                32usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleTransition),
                    "::",
                    stringify!(mUnknownProperty)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct StyleAnimation {
            pub mTimingFunction: root::nsTimingFunction,
            pub mDuration: f32,
            pub mDelay: f32,
            pub mName: root::RefPtr<root::nsAtom>,
            pub mDirection: root::mozilla::dom::PlaybackDirection,
            pub mFillMode: root::mozilla::dom::FillMode,
            pub mPlayState: u8,
            pub mIterationCount: f32,
        }
        #[test]
        fn bindgen_test_layout_StyleAnimation() {
            assert_eq!(
                ::std::mem::size_of::<StyleAnimation>(),
                48usize,
                concat!("Size of: ", stringify!(StyleAnimation))
            );
            assert_eq!(
                ::std::mem::align_of::<StyleAnimation>(),
                8usize,
                concat!("Alignment of ", stringify!(StyleAnimation))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleAnimation>())).mTimingFunction as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimation),
                    "::",
                    stringify!(mTimingFunction)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleAnimation>())).mDuration as *const _ as usize
                },
                20usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimation),
                    "::",
                    stringify!(mDuration)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<StyleAnimation>())).mDelay as *const _ as usize },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimation),
                    "::",
                    stringify!(mDelay)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<StyleAnimation>())).mName as *const _ as usize },
                32usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimation),
                    "::",
                    stringify!(mName)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleAnimation>())).mDirection as *const _ as usize
                },
                40usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimation),
                    "::",
                    stringify!(mDirection)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleAnimation>())).mFillMode as *const _ as usize
                },
                41usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimation),
                    "::",
                    stringify!(mFillMode)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleAnimation>())).mPlayState as *const _ as usize
                },
                42usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimation),
                    "::",
                    stringify!(mPlayState)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleAnimation>())).mIterationCount as *const _ as usize
                },
                44usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimation),
                    "::",
                    stringify!(mIterationCount)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct StyleBasicShape {
            pub mType: root::mozilla::StyleBasicShapeType,
            pub mFillRule: root::mozilla::StyleFillRule,
            pub mCoordinates: root::nsTArray<root::nsStyleCoord>,
            pub mPosition: root::mozilla::Position,
            pub mRadius: root::nsStyleCorners,
        }
        #[test]
        fn bindgen_test_layout_StyleBasicShape() {
            assert_eq!(
                ::std::mem::size_of::<StyleBasicShape>(),
                112usize,
                concat!("Size of: ", stringify!(StyleBasicShape))
            );
            assert_eq!(
                ::std::mem::align_of::<StyleBasicShape>(),
                8usize,
                concat!("Alignment of ", stringify!(StyleBasicShape))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<StyleBasicShape>())).mType as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleBasicShape),
                    "::",
                    stringify!(mType)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleBasicShape>())).mFillRule as *const _ as usize
                },
                1usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleBasicShape),
                    "::",
                    stringify!(mFillRule)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleBasicShape>())).mCoordinates as *const _ as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleBasicShape),
                    "::",
                    stringify!(mCoordinates)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleBasicShape>())).mPosition as *const _ as usize
                },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleBasicShape),
                    "::",
                    stringify!(mPosition)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<StyleBasicShape>())).mRadius as *const _ as usize },
                40usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleBasicShape),
                    "::",
                    stringify!(mRadius)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct StyleShapeSource {
            pub mBasicShape: root::mozilla::UniquePtr<root::mozilla::StyleBasicShape>,
            pub mShapeImage: root::mozilla::UniquePtr<root::nsStyleImage>,
            pub mType: root::mozilla::StyleShapeSourceType,
            pub mReferenceBox: root::mozilla::StyleGeometryBox,
        }
        #[test]
        fn bindgen_test_layout_StyleShapeSource() {
            assert_eq!(
                ::std::mem::size_of::<StyleShapeSource>(),
                24usize,
                concat!("Size of: ", stringify!(StyleShapeSource))
            );
            assert_eq!(
                ::std::mem::align_of::<StyleShapeSource>(),
                8usize,
                concat!("Alignment of ", stringify!(StyleShapeSource))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleShapeSource>())).mBasicShape as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleShapeSource),
                    "::",
                    stringify!(mBasicShape)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleShapeSource>())).mShapeImage as *const _ as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleShapeSource),
                    "::",
                    stringify!(mShapeImage)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<StyleShapeSource>())).mType as *const _ as usize },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleShapeSource),
                    "::",
                    stringify!(mType)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleShapeSource>())).mReferenceBox as *const _ as usize
                },
                17usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleShapeSource),
                    "::",
                    stringify!(mReferenceBox)
                )
            );
        }
        /// <div rustbindgen="true" replaces="mozilla::UniquePtr">
        ///
        /// TODO(Emilio): This is a workaround and we should be able to get rid of this
        /// one.
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct UniquePtr<T> {
            pub mPtr: *mut T,
            pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
        }
        pub const SERVO_PREF_ENABLED_align_content: bool = false;
        pub const SERVO_PREF_ENABLED_align_items: bool = false;
        pub const SERVO_PREF_ENABLED_align_self: bool = false;
        pub const SERVO_PREF_ENABLED_all: bool = true;
        pub const SERVO_PREF_ENABLED_animation: bool = false;
        pub const SERVO_PREF_ENABLED_animation_delay: bool = false;
        pub const SERVO_PREF_ENABLED_animation_direction: bool = false;
        pub const SERVO_PREF_ENABLED_animation_duration: bool = false;
        pub const SERVO_PREF_ENABLED_animation_fill_mode: bool = false;
        pub const SERVO_PREF_ENABLED_animation_iteration_count: bool = false;
        pub const SERVO_PREF_ENABLED_animation_name: bool = false;
        pub const SERVO_PREF_ENABLED_animation_play_state: bool = false;
        pub const SERVO_PREF_ENABLED_animation_timing_function: bool = false;
        pub const SERVO_PREF_ENABLED__moz_appearance: bool = false;
        pub const SERVO_PREF_ENABLED_backface_visibility: bool = false;
        pub const SERVO_PREF_ENABLED_background: bool = false;
        pub const SERVO_PREF_ENABLED_background_attachment: bool = false;
        pub const SERVO_PREF_ENABLED_background_blend_mode: bool = true;
        pub const SERVO_PREF_ENABLED_background_clip: bool = false;
        pub const SERVO_PREF_ENABLED_background_color: bool = false;
        pub const SERVO_PREF_ENABLED_background_image: bool = false;
        pub const SERVO_PREF_ENABLED_background_origin: bool = false;
        pub const SERVO_PREF_ENABLED_background_position: bool = false;
        pub const SERVO_PREF_ENABLED_background_position_x: bool = false;
        pub const SERVO_PREF_ENABLED_background_position_y: bool = false;
        pub const SERVO_PREF_ENABLED_background_repeat: bool = false;
        pub const SERVO_PREF_ENABLED_background_size: bool = false;
        pub const SERVO_PREF_ENABLED__moz_binding: bool = false;
        pub const SERVO_PREF_ENABLED_block_size: bool = false;
        pub const SERVO_PREF_ENABLED_border: bool = false;
        pub const SERVO_PREF_ENABLED_border_block_end: bool = false;
        pub const SERVO_PREF_ENABLED_border_block_end_color: bool = false;
        pub const SERVO_PREF_ENABLED_border_block_end_style: bool = false;
        pub const SERVO_PREF_ENABLED_border_block_end_width: bool = false;
        pub const SERVO_PREF_ENABLED_border_block_start: bool = false;
        pub const SERVO_PREF_ENABLED_border_block_start_color: bool = false;
        pub const SERVO_PREF_ENABLED_border_block_start_style: bool = false;
        pub const SERVO_PREF_ENABLED_border_block_start_width: bool = false;
        pub const SERVO_PREF_ENABLED_border_bottom: bool = false;
        pub const SERVO_PREF_ENABLED_border_bottom_color: bool = false;
        pub const SERVO_PREF_ENABLED_border_bottom_left_radius: bool = false;
        pub const SERVO_PREF_ENABLED_border_bottom_right_radius: bool = false;
        pub const SERVO_PREF_ENABLED_border_bottom_style: bool = false;
        pub const SERVO_PREF_ENABLED_border_bottom_width: bool = false;
        pub const SERVO_PREF_ENABLED_border_collapse: bool = false;
        pub const SERVO_PREF_ENABLED_border_color: bool = false;
        pub const SERVO_PREF_ENABLED_border_image: bool = false;
        pub const SERVO_PREF_ENABLED_border_image_outset: bool = false;
        pub const SERVO_PREF_ENABLED_border_image_repeat: bool = false;
        pub const SERVO_PREF_ENABLED_border_image_slice: bool = false;
        pub const SERVO_PREF_ENABLED_border_image_source: bool = false;
        pub const SERVO_PREF_ENABLED_border_image_width: bool = false;
        pub const SERVO_PREF_ENABLED_border_inline_end: bool = false;
        pub const SERVO_PREF_ENABLED_border_inline_end_color: bool = false;
        pub const SERVO_PREF_ENABLED_border_inline_end_style: bool = false;
        pub const SERVO_PREF_ENABLED_border_inline_end_width: bool = false;
        pub const SERVO_PREF_ENABLED_border_inline_start: bool = false;
        pub const SERVO_PREF_ENABLED_border_inline_start_color: bool = false;
        pub const SERVO_PREF_ENABLED_border_inline_start_style: bool = false;
        pub const SERVO_PREF_ENABLED_border_inline_start_width: bool = false;
        pub const SERVO_PREF_ENABLED_border_left: bool = false;
        pub const SERVO_PREF_ENABLED_border_left_color: bool = false;
        pub const SERVO_PREF_ENABLED_border_left_style: bool = false;
        pub const SERVO_PREF_ENABLED_border_left_width: bool = false;
        pub const SERVO_PREF_ENABLED_border_radius: bool = false;
        pub const SERVO_PREF_ENABLED_border_right: bool = false;
        pub const SERVO_PREF_ENABLED_border_right_color: bool = false;
        pub const SERVO_PREF_ENABLED_border_right_style: bool = false;
        pub const SERVO_PREF_ENABLED_border_right_width: bool = false;
        pub const SERVO_PREF_ENABLED_border_spacing: bool = false;
        pub const SERVO_PREF_ENABLED_border_style: bool = false;
        pub const SERVO_PREF_ENABLED_border_top: bool = false;
        pub const SERVO_PREF_ENABLED_border_top_color: bool = false;
        pub const SERVO_PREF_ENABLED_border_top_left_radius: bool = false;
        pub const SERVO_PREF_ENABLED_border_top_right_radius: bool = false;
        pub const SERVO_PREF_ENABLED_border_top_style: bool = false;
        pub const SERVO_PREF_ENABLED_border_top_width: bool = false;
        pub const SERVO_PREF_ENABLED_border_width: bool = false;
        pub const SERVO_PREF_ENABLED_bottom: bool = false;
        pub const SERVO_PREF_ENABLED__moz_box_align: bool = false;
        pub const SERVO_PREF_ENABLED_box_decoration_break: bool = true;
        pub const SERVO_PREF_ENABLED__moz_box_direction: bool = false;
        pub const SERVO_PREF_ENABLED__moz_box_flex: bool = false;
        pub const SERVO_PREF_ENABLED__moz_box_ordinal_group: bool = false;
        pub const SERVO_PREF_ENABLED__moz_box_orient: bool = false;
        pub const SERVO_PREF_ENABLED__moz_box_pack: bool = false;
        pub const SERVO_PREF_ENABLED_box_shadow: bool = false;
        pub const SERVO_PREF_ENABLED_box_sizing: bool = false;
        pub const SERVO_PREF_ENABLED_caption_side: bool = false;
        pub const SERVO_PREF_ENABLED_caret_color: bool = false;
        pub const SERVO_PREF_ENABLED_clear: bool = false;
        pub const SERVO_PREF_ENABLED_clip: bool = false;
        pub const SERVO_PREF_ENABLED_clip_path: bool = false;
        pub const SERVO_PREF_ENABLED_clip_rule: bool = false;
        pub const SERVO_PREF_ENABLED_color: bool = false;
        pub const SERVO_PREF_ENABLED_color_adjust: bool = true;
        pub const SERVO_PREF_ENABLED_color_interpolation: bool = false;
        pub const SERVO_PREF_ENABLED_color_interpolation_filters: bool = false;
        pub const SERVO_PREF_ENABLED_column_count: bool = false;
        pub const SERVO_PREF_ENABLED_column_fill: bool = false;
        pub const SERVO_PREF_ENABLED_column_gap: bool = false;
        pub const SERVO_PREF_ENABLED_column_rule: bool = false;
        pub const SERVO_PREF_ENABLED_column_rule_color: bool = false;
        pub const SERVO_PREF_ENABLED_column_rule_style: bool = false;
        pub const SERVO_PREF_ENABLED_column_rule_width: bool = false;
        pub const SERVO_PREF_ENABLED_column_span: bool = true;
        pub const SERVO_PREF_ENABLED_column_width: bool = false;
        pub const SERVO_PREF_ENABLED_columns: bool = false;
        pub const SERVO_PREF_ENABLED_contain: bool = true;
        pub const SERVO_PREF_ENABLED_content: bool = false;
        pub const SERVO_PREF_ENABLED__moz_context_properties: bool = false;
        pub const SERVO_PREF_ENABLED__moz_control_character_visibility: bool = false;
        pub const SERVO_PREF_ENABLED_counter_increment: bool = false;
        pub const SERVO_PREF_ENABLED_counter_reset: bool = false;
        pub const SERVO_PREF_ENABLED_cursor: bool = false;
        pub const SERVO_PREF_ENABLED_direction: bool = false;
        pub const SERVO_PREF_ENABLED_display: bool = false;
        pub const SERVO_PREF_ENABLED_dominant_baseline: bool = false;
        pub const SERVO_PREF_ENABLED_empty_cells: bool = false;
        pub const SERVO_PREF_ENABLED_fill: bool = false;
        pub const SERVO_PREF_ENABLED_fill_opacity: bool = false;
        pub const SERVO_PREF_ENABLED_fill_rule: bool = false;
        pub const SERVO_PREF_ENABLED_filter: bool = false;
        pub const SERVO_PREF_ENABLED_flex: bool = false;
        pub const SERVO_PREF_ENABLED_flex_basis: bool = false;
        pub const SERVO_PREF_ENABLED_flex_direction: bool = false;
        pub const SERVO_PREF_ENABLED_flex_flow: bool = false;
        pub const SERVO_PREF_ENABLED_flex_grow: bool = false;
        pub const SERVO_PREF_ENABLED_flex_shrink: bool = false;
        pub const SERVO_PREF_ENABLED_flex_wrap: bool = false;
        pub const SERVO_PREF_ENABLED_float_: bool = false;
        pub const SERVO_PREF_ENABLED__moz_float_edge: bool = false;
        pub const SERVO_PREF_ENABLED_flood_color: bool = false;
        pub const SERVO_PREF_ENABLED_flood_opacity: bool = false;
        pub const SERVO_PREF_ENABLED_font: bool = false;
        pub const SERVO_PREF_ENABLED_font_family: bool = false;
        pub const SERVO_PREF_ENABLED_font_feature_settings: bool = false;
        pub const SERVO_PREF_ENABLED_font_kerning: bool = false;
        pub const SERVO_PREF_ENABLED_font_language_override: bool = false;
        pub const SERVO_PREF_ENABLED_font_optical_sizing: bool = true;
        pub const SERVO_PREF_ENABLED_font_size: bool = false;
        pub const SERVO_PREF_ENABLED_font_size_adjust: bool = false;
        pub const SERVO_PREF_ENABLED__moz_font_smoothing_background_color: bool = false;
        pub const SERVO_PREF_ENABLED_font_stretch: bool = false;
        pub const SERVO_PREF_ENABLED_font_style: bool = false;
        pub const SERVO_PREF_ENABLED_font_synthesis: bool = false;
        pub const SERVO_PREF_ENABLED_font_variant: bool = false;
        pub const SERVO_PREF_ENABLED_font_variant_alternates: bool = false;
        pub const SERVO_PREF_ENABLED_font_variant_caps: bool = false;
        pub const SERVO_PREF_ENABLED_font_variant_east_asian: bool = false;
        pub const SERVO_PREF_ENABLED_font_variant_ligatures: bool = false;
        pub const SERVO_PREF_ENABLED_font_variant_numeric: bool = false;
        pub const SERVO_PREF_ENABLED_font_variant_position: bool = false;
        pub const SERVO_PREF_ENABLED_font_variation_settings: bool = true;
        pub const SERVO_PREF_ENABLED_font_weight: bool = false;
        pub const SERVO_PREF_ENABLED__moz_force_broken_image_icon: bool = false;
        pub const SERVO_PREF_ENABLED_grid: bool = false;
        pub const SERVO_PREF_ENABLED_grid_area: bool = false;
        pub const SERVO_PREF_ENABLED_grid_auto_columns: bool = false;
        pub const SERVO_PREF_ENABLED_grid_auto_flow: bool = false;
        pub const SERVO_PREF_ENABLED_grid_auto_rows: bool = false;
        pub const SERVO_PREF_ENABLED_grid_column: bool = false;
        pub const SERVO_PREF_ENABLED_grid_column_end: bool = false;
        pub const SERVO_PREF_ENABLED_grid_column_gap: bool = false;
        pub const SERVO_PREF_ENABLED_grid_column_start: bool = false;
        pub const SERVO_PREF_ENABLED_grid_gap: bool = false;
        pub const SERVO_PREF_ENABLED_grid_row: bool = false;
        pub const SERVO_PREF_ENABLED_grid_row_end: bool = false;
        pub const SERVO_PREF_ENABLED_grid_row_gap: bool = false;
        pub const SERVO_PREF_ENABLED_grid_row_start: bool = false;
        pub const SERVO_PREF_ENABLED_grid_template: bool = false;
        pub const SERVO_PREF_ENABLED_grid_template_areas: bool = false;
        pub const SERVO_PREF_ENABLED_grid_template_columns: bool = false;
        pub const SERVO_PREF_ENABLED_grid_template_rows: bool = false;
        pub const SERVO_PREF_ENABLED_height: bool = false;
        pub const SERVO_PREF_ENABLED_hyphens: bool = false;
        pub const SERVO_PREF_ENABLED_initial_letter: bool = true;
        pub const SERVO_PREF_ENABLED_image_orientation: bool = true;
        pub const SERVO_PREF_ENABLED__moz_image_region: bool = false;
        pub const SERVO_PREF_ENABLED_image_rendering: bool = false;
        pub const SERVO_PREF_ENABLED_ime_mode: bool = false;
        pub const SERVO_PREF_ENABLED_inline_size: bool = false;
        pub const SERVO_PREF_ENABLED_isolation: bool = true;
        pub const SERVO_PREF_ENABLED_justify_content: bool = false;
        pub const SERVO_PREF_ENABLED_justify_items: bool = false;
        pub const SERVO_PREF_ENABLED_justify_self: bool = false;
        pub const SERVO_PREF_ENABLED__x_lang: bool = false;
        pub const SERVO_PREF_ENABLED_left: bool = false;
        pub const SERVO_PREF_ENABLED_letter_spacing: bool = false;
        pub const SERVO_PREF_ENABLED_lighting_color: bool = false;
        pub const SERVO_PREF_ENABLED_line_height: bool = false;
        pub const SERVO_PREF_ENABLED_list_style: bool = false;
        pub const SERVO_PREF_ENABLED_list_style_image: bool = false;
        pub const SERVO_PREF_ENABLED_list_style_position: bool = false;
        pub const SERVO_PREF_ENABLED_list_style_type: bool = false;
        pub const SERVO_PREF_ENABLED_margin: bool = false;
        pub const SERVO_PREF_ENABLED_margin_block_end: bool = false;
        pub const SERVO_PREF_ENABLED_margin_block_start: bool = false;
        pub const SERVO_PREF_ENABLED_margin_bottom: bool = false;
        pub const SERVO_PREF_ENABLED_margin_inline_end: bool = false;
        pub const SERVO_PREF_ENABLED_margin_inline_start: bool = false;
        pub const SERVO_PREF_ENABLED_margin_left: bool = false;
        pub const SERVO_PREF_ENABLED_margin_right: bool = false;
        pub const SERVO_PREF_ENABLED_margin_top: bool = false;
        pub const SERVO_PREF_ENABLED_marker: bool = false;
        pub const SERVO_PREF_ENABLED_marker_end: bool = false;
        pub const SERVO_PREF_ENABLED_marker_mid: bool = false;
        pub const SERVO_PREF_ENABLED_marker_start: bool = false;
        pub const SERVO_PREF_ENABLED_mask: bool = false;
        pub const SERVO_PREF_ENABLED_mask_clip: bool = false;
        pub const SERVO_PREF_ENABLED_mask_composite: bool = false;
        pub const SERVO_PREF_ENABLED_mask_image: bool = false;
        pub const SERVO_PREF_ENABLED_mask_mode: bool = false;
        pub const SERVO_PREF_ENABLED_mask_origin: bool = false;
        pub const SERVO_PREF_ENABLED_mask_position: bool = false;
        pub const SERVO_PREF_ENABLED_mask_position_x: bool = false;
        pub const SERVO_PREF_ENABLED_mask_position_y: bool = false;
        pub const SERVO_PREF_ENABLED_mask_repeat: bool = false;
        pub const SERVO_PREF_ENABLED_mask_size: bool = false;
        pub const SERVO_PREF_ENABLED_mask_type: bool = false;
        pub const SERVO_PREF_ENABLED__moz_math_display: bool = false;
        pub const SERVO_PREF_ENABLED__moz_math_variant: bool = false;
        pub const SERVO_PREF_ENABLED_max_block_size: bool = false;
        pub const SERVO_PREF_ENABLED_max_height: bool = false;
        pub const SERVO_PREF_ENABLED_max_inline_size: bool = false;
        pub const SERVO_PREF_ENABLED_max_width: bool = false;
        pub const SERVO_PREF_ENABLED_min_block_size: bool = false;
        pub const SERVO_PREF_ENABLED__moz_min_font_size_ratio: bool = false;
        pub const SERVO_PREF_ENABLED_min_height: bool = false;
        pub const SERVO_PREF_ENABLED_min_inline_size: bool = false;
        pub const SERVO_PREF_ENABLED_min_width: bool = false;
        pub const SERVO_PREF_ENABLED_mix_blend_mode: bool = true;
        pub const SERVO_PREF_ENABLED_object_fit: bool = false;
        pub const SERVO_PREF_ENABLED_object_position: bool = false;
        pub const SERVO_PREF_ENABLED_offset_block_end: bool = false;
        pub const SERVO_PREF_ENABLED_offset_block_start: bool = false;
        pub const SERVO_PREF_ENABLED_offset_inline_end: bool = false;
        pub const SERVO_PREF_ENABLED_offset_inline_start: bool = false;
        pub const SERVO_PREF_ENABLED_opacity: bool = false;
        pub const SERVO_PREF_ENABLED_order: bool = false;
        pub const SERVO_PREF_ENABLED__moz_orient: bool = false;
        pub const SERVO_PREF_ENABLED__moz_osx_font_smoothing: bool = true;
        pub const SERVO_PREF_ENABLED_outline: bool = false;
        pub const SERVO_PREF_ENABLED_outline_color: bool = false;
        pub const SERVO_PREF_ENABLED_outline_offset: bool = false;
        pub const SERVO_PREF_ENABLED__moz_outline_radius: bool = false;
        pub const SERVO_PREF_ENABLED__moz_outline_radius_bottomleft: bool = false;
        pub const SERVO_PREF_ENABLED__moz_outline_radius_bottomright: bool = false;
        pub const SERVO_PREF_ENABLED__moz_outline_radius_topleft: bool = false;
        pub const SERVO_PREF_ENABLED__moz_outline_radius_topright: bool = false;
        pub const SERVO_PREF_ENABLED_outline_style: bool = false;
        pub const SERVO_PREF_ENABLED_outline_width: bool = false;
        pub const SERVO_PREF_ENABLED_overflow: bool = false;
        pub const SERVO_PREF_ENABLED_overflow_clip_box: bool = true;
        pub const SERVO_PREF_ENABLED_overflow_clip_box_block: bool = true;
        pub const SERVO_PREF_ENABLED_overflow_clip_box_inline: bool = true;
        pub const SERVO_PREF_ENABLED_overflow_x: bool = false;
        pub const SERVO_PREF_ENABLED_overflow_y: bool = false;
        pub const SERVO_PREF_ENABLED_padding: bool = false;
        pub const SERVO_PREF_ENABLED_padding_block_end: bool = false;
        pub const SERVO_PREF_ENABLED_padding_block_start: bool = false;
        pub const SERVO_PREF_ENABLED_padding_bottom: bool = false;
        pub const SERVO_PREF_ENABLED_padding_inline_end: bool = false;
        pub const SERVO_PREF_ENABLED_padding_inline_start: bool = false;
        pub const SERVO_PREF_ENABLED_padding_left: bool = false;
        pub const SERVO_PREF_ENABLED_padding_right: bool = false;
        pub const SERVO_PREF_ENABLED_padding_top: bool = false;
        pub const SERVO_PREF_ENABLED_page_break_after: bool = false;
        pub const SERVO_PREF_ENABLED_page_break_before: bool = false;
        pub const SERVO_PREF_ENABLED_page_break_inside: bool = false;
        pub const SERVO_PREF_ENABLED_paint_order: bool = false;
        pub const SERVO_PREF_ENABLED_perspective: bool = false;
        pub const SERVO_PREF_ENABLED_perspective_origin: bool = false;
        pub const SERVO_PREF_ENABLED_place_content: bool = false;
        pub const SERVO_PREF_ENABLED_place_items: bool = false;
        pub const SERVO_PREF_ENABLED_place_self: bool = false;
        pub const SERVO_PREF_ENABLED_pointer_events: bool = false;
        pub const SERVO_PREF_ENABLED_position: bool = false;
        pub const SERVO_PREF_ENABLED_quotes: bool = false;
        pub const SERVO_PREF_ENABLED_resize: bool = false;
        pub const SERVO_PREF_ENABLED_right: bool = false;
        pub const SERVO_PREF_ENABLED_rotate: bool = true;
        pub const SERVO_PREF_ENABLED_ruby_align: bool = false;
        pub const SERVO_PREF_ENABLED_ruby_position: bool = false;
        pub const SERVO_PREF_ENABLED__moz_script_level: bool = false;
        pub const SERVO_PREF_ENABLED__moz_script_min_size: bool = false;
        pub const SERVO_PREF_ENABLED__moz_script_size_multiplier: bool = false;
        pub const SERVO_PREF_ENABLED_scroll_behavior: bool = true;
        pub const SERVO_PREF_ENABLED_overscroll_behavior: bool = true;
        pub const SERVO_PREF_ENABLED_overscroll_behavior_x: bool = true;
        pub const SERVO_PREF_ENABLED_overscroll_behavior_y: bool = true;
        pub const SERVO_PREF_ENABLED_scroll_snap_coordinate: bool = true;
        pub const SERVO_PREF_ENABLED_scroll_snap_destination: bool = true;
        pub const SERVO_PREF_ENABLED_scroll_snap_points_x: bool = true;
        pub const SERVO_PREF_ENABLED_scroll_snap_points_y: bool = true;
        pub const SERVO_PREF_ENABLED_scroll_snap_type: bool = true;
        pub const SERVO_PREF_ENABLED_scroll_snap_type_x: bool = true;
        pub const SERVO_PREF_ENABLED_scroll_snap_type_y: bool = true;
        pub const SERVO_PREF_ENABLED_shape_image_threshold: bool = true;
        pub const SERVO_PREF_ENABLED_shape_outside: bool = true;
        pub const SERVO_PREF_ENABLED_shape_rendering: bool = false;
        pub const SERVO_PREF_ENABLED__x_span: bool = false;
        pub const SERVO_PREF_ENABLED__moz_stack_sizing: bool = false;
        pub const SERVO_PREF_ENABLED_stop_color: bool = false;
        pub const SERVO_PREF_ENABLED_stop_opacity: bool = false;
        pub const SERVO_PREF_ENABLED_stroke: bool = false;
        pub const SERVO_PREF_ENABLED_stroke_dasharray: bool = false;
        pub const SERVO_PREF_ENABLED_stroke_dashoffset: bool = false;
        pub const SERVO_PREF_ENABLED_stroke_linecap: bool = false;
        pub const SERVO_PREF_ENABLED_stroke_linejoin: bool = false;
        pub const SERVO_PREF_ENABLED_stroke_miterlimit: bool = false;
        pub const SERVO_PREF_ENABLED_stroke_opacity: bool = false;
        pub const SERVO_PREF_ENABLED_stroke_width: bool = false;
        pub const SERVO_PREF_ENABLED__x_system_font: bool = false;
        pub const SERVO_PREF_ENABLED__moz_tab_size: bool = false;
        pub const SERVO_PREF_ENABLED_table_layout: bool = false;
        pub const SERVO_PREF_ENABLED_text_align: bool = false;
        pub const SERVO_PREF_ENABLED_text_align_last: bool = false;
        pub const SERVO_PREF_ENABLED_text_anchor: bool = false;
        pub const SERVO_PREF_ENABLED_text_combine_upright: bool = true;
        pub const SERVO_PREF_ENABLED_text_decoration: bool = false;
        pub const SERVO_PREF_ENABLED_text_decoration_color: bool = false;
        pub const SERVO_PREF_ENABLED_text_decoration_line: bool = false;
        pub const SERVO_PREF_ENABLED_text_decoration_style: bool = false;
        pub const SERVO_PREF_ENABLED_text_emphasis: bool = false;
        pub const SERVO_PREF_ENABLED_text_emphasis_color: bool = false;
        pub const SERVO_PREF_ENABLED_text_emphasis_position: bool = false;
        pub const SERVO_PREF_ENABLED_text_emphasis_style: bool = false;
        pub const SERVO_PREF_ENABLED__webkit_text_fill_color: bool = true;
        pub const SERVO_PREF_ENABLED_text_indent: bool = false;
        pub const SERVO_PREF_ENABLED_text_justify: bool = true;
        pub const SERVO_PREF_ENABLED_text_orientation: bool = false;
        pub const SERVO_PREF_ENABLED_text_overflow: bool = false;
        pub const SERVO_PREF_ENABLED_text_rendering: bool = false;
        pub const SERVO_PREF_ENABLED_text_shadow: bool = false;
        pub const SERVO_PREF_ENABLED__moz_text_size_adjust: bool = false;
        pub const SERVO_PREF_ENABLED__webkit_text_stroke: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_text_stroke_color: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_text_stroke_width: bool = true;
        pub const SERVO_PREF_ENABLED_scale: bool = true;
        pub const SERVO_PREF_ENABLED_text_transform: bool = false;
        pub const SERVO_PREF_ENABLED__x_text_zoom: bool = false;
        pub const SERVO_PREF_ENABLED_top: bool = false;
        pub const SERVO_PREF_ENABLED__moz_top_layer: bool = false;
        pub const SERVO_PREF_ENABLED_touch_action: bool = true;
        pub const SERVO_PREF_ENABLED_transform: bool = false;
        pub const SERVO_PREF_ENABLED_transform_box: bool = true;
        pub const SERVO_PREF_ENABLED_transform_origin: bool = false;
        pub const SERVO_PREF_ENABLED_transform_style: bool = false;
        pub const SERVO_PREF_ENABLED_transition: bool = false;
        pub const SERVO_PREF_ENABLED_transition_delay: bool = false;
        pub const SERVO_PREF_ENABLED_transition_duration: bool = false;
        pub const SERVO_PREF_ENABLED_transition_property: bool = false;
        pub const SERVO_PREF_ENABLED_transition_timing_function: bool = false;
        pub const SERVO_PREF_ENABLED_translate: bool = true;
        pub const SERVO_PREF_ENABLED_unicode_bidi: bool = false;
        pub const SERVO_PREF_ENABLED__moz_user_focus: bool = false;
        pub const SERVO_PREF_ENABLED__moz_user_input: bool = false;
        pub const SERVO_PREF_ENABLED__moz_user_modify: bool = false;
        pub const SERVO_PREF_ENABLED__moz_user_select: bool = false;
        pub const SERVO_PREF_ENABLED_vector_effect: bool = false;
        pub const SERVO_PREF_ENABLED_vertical_align: bool = false;
        pub const SERVO_PREF_ENABLED_visibility: bool = false;
        pub const SERVO_PREF_ENABLED_white_space: bool = false;
        pub const SERVO_PREF_ENABLED_width: bool = false;
        pub const SERVO_PREF_ENABLED_will_change: bool = false;
        pub const SERVO_PREF_ENABLED__moz_window_dragging: bool = false;
        pub const SERVO_PREF_ENABLED__moz_window_shadow: bool = false;
        pub const SERVO_PREF_ENABLED__moz_window_opacity: bool = false;
        pub const SERVO_PREF_ENABLED__moz_window_transform: bool = false;
        pub const SERVO_PREF_ENABLED__moz_window_transform_origin: bool = false;
        pub const SERVO_PREF_ENABLED_word_break: bool = false;
        pub const SERVO_PREF_ENABLED_word_spacing: bool = false;
        pub const SERVO_PREF_ENABLED_overflow_wrap: bool = false;
        pub const SERVO_PREF_ENABLED_writing_mode: bool = false;
        pub const SERVO_PREF_ENABLED_z_index: bool = false;
        pub const SERVO_PREF_ENABLED_word_wrap: bool = false;
        pub const SERVO_PREF_ENABLED__moz_transform: bool = true;
        pub const SERVO_PREF_ENABLED__moz_transform_origin: bool = true;
        pub const SERVO_PREF_ENABLED__moz_perspective_origin: bool = true;
        pub const SERVO_PREF_ENABLED__moz_perspective: bool = true;
        pub const SERVO_PREF_ENABLED__moz_transform_style: bool = true;
        pub const SERVO_PREF_ENABLED__moz_backface_visibility: bool = true;
        pub const SERVO_PREF_ENABLED__moz_border_image: bool = true;
        pub const SERVO_PREF_ENABLED__moz_transition: bool = true;
        pub const SERVO_PREF_ENABLED__moz_transition_delay: bool = true;
        pub const SERVO_PREF_ENABLED__moz_transition_duration: bool = true;
        pub const SERVO_PREF_ENABLED__moz_transition_property: bool = true;
        pub const SERVO_PREF_ENABLED__moz_transition_timing_function: bool = true;
        pub const SERVO_PREF_ENABLED__moz_animation: bool = true;
        pub const SERVO_PREF_ENABLED__moz_animation_delay: bool = true;
        pub const SERVO_PREF_ENABLED__moz_animation_direction: bool = true;
        pub const SERVO_PREF_ENABLED__moz_animation_duration: bool = true;
        pub const SERVO_PREF_ENABLED__moz_animation_fill_mode: bool = true;
        pub const SERVO_PREF_ENABLED__moz_animation_iteration_count: bool = true;
        pub const SERVO_PREF_ENABLED__moz_animation_name: bool = true;
        pub const SERVO_PREF_ENABLED__moz_animation_play_state: bool = true;
        pub const SERVO_PREF_ENABLED__moz_animation_timing_function: bool = true;
        pub const SERVO_PREF_ENABLED__moz_box_sizing: bool = true;
        pub const SERVO_PREF_ENABLED__moz_font_feature_settings: bool = true;
        pub const SERVO_PREF_ENABLED__moz_font_language_override: bool = true;
        pub const SERVO_PREF_ENABLED__moz_padding_end: bool = false;
        pub const SERVO_PREF_ENABLED__moz_padding_start: bool = false;
        pub const SERVO_PREF_ENABLED__moz_margin_end: bool = false;
        pub const SERVO_PREF_ENABLED__moz_margin_start: bool = false;
        pub const SERVO_PREF_ENABLED__moz_border_end: bool = false;
        pub const SERVO_PREF_ENABLED__moz_border_end_color: bool = false;
        pub const SERVO_PREF_ENABLED__moz_border_end_style: bool = false;
        pub const SERVO_PREF_ENABLED__moz_border_end_width: bool = false;
        pub const SERVO_PREF_ENABLED__moz_border_start: bool = false;
        pub const SERVO_PREF_ENABLED__moz_border_start_color: bool = false;
        pub const SERVO_PREF_ENABLED__moz_border_start_style: bool = false;
        pub const SERVO_PREF_ENABLED__moz_border_start_width: bool = false;
        pub const SERVO_PREF_ENABLED__moz_hyphens: bool = false;
        pub const SERVO_PREF_ENABLED__moz_column_count: bool = false;
        pub const SERVO_PREF_ENABLED__moz_column_fill: bool = false;
        pub const SERVO_PREF_ENABLED__moz_column_gap: bool = false;
        pub const SERVO_PREF_ENABLED__moz_column_rule: bool = false;
        pub const SERVO_PREF_ENABLED__moz_column_rule_color: bool = false;
        pub const SERVO_PREF_ENABLED__moz_column_rule_style: bool = false;
        pub const SERVO_PREF_ENABLED__moz_column_rule_width: bool = false;
        pub const SERVO_PREF_ENABLED__moz_column_span: bool = true;
        pub const SERVO_PREF_ENABLED__moz_column_width: bool = false;
        pub const SERVO_PREF_ENABLED__moz_columns: bool = false;
        pub const SERVO_PREF_ENABLED__webkit_animation: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_animation_delay: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_animation_direction: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_animation_duration: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_animation_fill_mode: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_animation_iteration_count: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_animation_name: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_animation_play_state: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_animation_timing_function: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_filter: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_text_size_adjust: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_transform: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_transform_origin: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_transform_style: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_backface_visibility: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_perspective: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_perspective_origin: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_transition: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_transition_delay: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_transition_duration: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_transition_property: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_transition_timing_function: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_border_radius: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_border_top_left_radius: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_border_top_right_radius: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_border_bottom_left_radius: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_border_bottom_right_radius: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_background_clip: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_background_origin: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_background_size: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_border_image: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_box_shadow: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_box_sizing: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_box_flex: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_box_ordinal_group: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_box_orient: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_box_direction: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_box_align: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_box_pack: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_flex_direction: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_flex_wrap: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_flex_flow: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_order: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_flex: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_flex_grow: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_flex_shrink: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_flex_basis: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_justify_content: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_align_items: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_align_self: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_align_content: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_user_select: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_mask: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_mask_clip: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_mask_composite: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_mask_image: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_mask_origin: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_mask_position: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_mask_position_x: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_mask_position_y: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_mask_repeat: bool = true;
        pub const SERVO_PREF_ENABLED__webkit_mask_size: bool = true;
        /// Utility class to handle animated style values
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct StyleAnimationValue {
            pub _bindgen_opaque_blob: [u64; 2usize],
        }
        pub const StyleAnimationValue_Unit_eUnit_Null: root::mozilla::StyleAnimationValue_Unit = 0;
        pub const StyleAnimationValue_Unit_eUnit_Normal: root::mozilla::StyleAnimationValue_Unit =
            1;
        pub const StyleAnimationValue_Unit_eUnit_Auto: root::mozilla::StyleAnimationValue_Unit = 2;
        pub const StyleAnimationValue_Unit_eUnit_None: root::mozilla::StyleAnimationValue_Unit = 3;
        pub const StyleAnimationValue_Unit_eUnit_Enumerated:
            root::mozilla::StyleAnimationValue_Unit = 4;
        pub const StyleAnimationValue_Unit_eUnit_Visibility:
            root::mozilla::StyleAnimationValue_Unit = 5;
        pub const StyleAnimationValue_Unit_eUnit_Integer: root::mozilla::StyleAnimationValue_Unit =
            6;
        pub const StyleAnimationValue_Unit_eUnit_Coord: root::mozilla::StyleAnimationValue_Unit = 7;
        pub const StyleAnimationValue_Unit_eUnit_Percent: root::mozilla::StyleAnimationValue_Unit =
            8;
        pub const StyleAnimationValue_Unit_eUnit_Float: root::mozilla::StyleAnimationValue_Unit = 9;
        pub const StyleAnimationValue_Unit_eUnit_Color: root::mozilla::StyleAnimationValue_Unit =
            10;
        pub const StyleAnimationValue_Unit_eUnit_CurrentColor:
            root::mozilla::StyleAnimationValue_Unit = 11;
        pub const StyleAnimationValue_Unit_eUnit_ComplexColor:
            root::mozilla::StyleAnimationValue_Unit = 12;
        pub const StyleAnimationValue_Unit_eUnit_Calc: root::mozilla::StyleAnimationValue_Unit = 13;
        pub const StyleAnimationValue_Unit_eUnit_ObjectPosition:
            root::mozilla::StyleAnimationValue_Unit = 14;
        pub const StyleAnimationValue_Unit_eUnit_URL: root::mozilla::StyleAnimationValue_Unit = 15;
        pub const StyleAnimationValue_Unit_eUnit_DiscreteCSSValue:
            root::mozilla::StyleAnimationValue_Unit = 16;
        pub const StyleAnimationValue_Unit_eUnit_CSSValuePair:
            root::mozilla::StyleAnimationValue_Unit = 17;
        pub const StyleAnimationValue_Unit_eUnit_CSSValueTriplet:
            root::mozilla::StyleAnimationValue_Unit = 18;
        pub const StyleAnimationValue_Unit_eUnit_CSSRect: root::mozilla::StyleAnimationValue_Unit =
            19;
        pub const StyleAnimationValue_Unit_eUnit_Dasharray:
            root::mozilla::StyleAnimationValue_Unit = 20;
        pub const StyleAnimationValue_Unit_eUnit_Shadow: root::mozilla::StyleAnimationValue_Unit =
            21;
        pub const StyleAnimationValue_Unit_eUnit_Shape: root::mozilla::StyleAnimationValue_Unit =
            22;
        pub const StyleAnimationValue_Unit_eUnit_Filter: root::mozilla::StyleAnimationValue_Unit =
            23;
        pub const StyleAnimationValue_Unit_eUnit_Transform:
            root::mozilla::StyleAnimationValue_Unit = 24;
        pub const StyleAnimationValue_Unit_eUnit_BackgroundPositionCoord:
            root::mozilla::StyleAnimationValue_Unit = 25;
        pub const StyleAnimationValue_Unit_eUnit_CSSValuePairList:
            root::mozilla::StyleAnimationValue_Unit = 26;
        pub const StyleAnimationValue_Unit_eUnit_UnparsedString:
            root::mozilla::StyleAnimationValue_Unit = 27;
        /// The types and values for the values that we extract and animate.
        pub type StyleAnimationValue_Unit = u32;
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct StyleAnimationValue__bindgen_ty_1 {
            pub mInt: root::__BindgenUnionField<i32>,
            pub mCoord: root::__BindgenUnionField<root::nscoord>,
            pub mFloat: root::__BindgenUnionField<f32>,
            pub mCSSValue: root::__BindgenUnionField<*mut root::nsCSSValue>,
            pub mCSSValuePair: root::__BindgenUnionField<*mut root::nsCSSValuePair>,
            pub mCSSValueTriplet: root::__BindgenUnionField<*mut root::nsCSSValueTriplet>,
            pub mCSSRect: root::__BindgenUnionField<*mut root::nsCSSRect>,
            pub mCSSValueArray: root::__BindgenUnionField<*mut root::nsCSSValue_Array>,
            pub mCSSValueList: root::__BindgenUnionField<*mut root::nsCSSValueList>,
            pub mCSSValueSharedList: root::__BindgenUnionField<*mut root::nsCSSValueSharedList>,
            pub mCSSValuePairList: root::__BindgenUnionField<*mut root::nsCSSValuePairList>,
            pub mString: root::__BindgenUnionField<*mut root::nsStringBuffer>,
            pub mComplexColor:
                root::__BindgenUnionField<*mut root::mozilla::css::ComplexColorValue>,
            pub bindgen_union_field: u64,
        }
        #[test]
        fn bindgen_test_layout_StyleAnimationValue__bindgen_ty_1() {
            assert_eq!(
                ::std::mem::size_of::<StyleAnimationValue__bindgen_ty_1>(),
                8usize,
                concat!("Size of: ", stringify!(StyleAnimationValue__bindgen_ty_1))
            );
            assert_eq!(
                ::std::mem::align_of::<StyleAnimationValue__bindgen_ty_1>(),
                8usize,
                concat!(
                    "Alignment of ",
                    stringify!(StyleAnimationValue__bindgen_ty_1)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleAnimationValue__bindgen_ty_1>())).mInt as *const _
                        as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimationValue__bindgen_ty_1),
                    "::",
                    stringify!(mInt)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleAnimationValue__bindgen_ty_1>())).mCoord as *const _
                        as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimationValue__bindgen_ty_1),
                    "::",
                    stringify!(mCoord)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleAnimationValue__bindgen_ty_1>())).mFloat as *const _
                        as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimationValue__bindgen_ty_1),
                    "::",
                    stringify!(mFloat)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleAnimationValue__bindgen_ty_1>())).mCSSValue
                        as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimationValue__bindgen_ty_1),
                    "::",
                    stringify!(mCSSValue)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleAnimationValue__bindgen_ty_1>())).mCSSValuePair
                        as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimationValue__bindgen_ty_1),
                    "::",
                    stringify!(mCSSValuePair)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleAnimationValue__bindgen_ty_1>())).mCSSValueTriplet
                        as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimationValue__bindgen_ty_1),
                    "::",
                    stringify!(mCSSValueTriplet)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleAnimationValue__bindgen_ty_1>())).mCSSRect
                        as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimationValue__bindgen_ty_1),
                    "::",
                    stringify!(mCSSRect)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleAnimationValue__bindgen_ty_1>())).mCSSValueArray
                        as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimationValue__bindgen_ty_1),
                    "::",
                    stringify!(mCSSValueArray)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleAnimationValue__bindgen_ty_1>())).mCSSValueList
                        as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimationValue__bindgen_ty_1),
                    "::",
                    stringify!(mCSSValueList)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleAnimationValue__bindgen_ty_1>()))
                        .mCSSValueSharedList as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimationValue__bindgen_ty_1),
                    "::",
                    stringify!(mCSSValueSharedList)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleAnimationValue__bindgen_ty_1>())).mCSSValuePairList
                        as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimationValue__bindgen_ty_1),
                    "::",
                    stringify!(mCSSValuePairList)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleAnimationValue__bindgen_ty_1>())).mString
                        as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimationValue__bindgen_ty_1),
                    "::",
                    stringify!(mString)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleAnimationValue__bindgen_ty_1>())).mComplexColor
                        as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleAnimationValue__bindgen_ty_1),
                    "::",
                    stringify!(mComplexColor)
                )
            );
        }
        impl Clone for StyleAnimationValue__bindgen_ty_1 {
            fn clone(&self) -> Self {
                *self
            }
        }
        pub const StyleAnimationValue_IntegerConstructorType_IntegerConstructor:
            root::mozilla::StyleAnimationValue_IntegerConstructorType = 0;
        pub type StyleAnimationValue_IntegerConstructorType = u32;
        pub const StyleAnimationValue_CoordConstructorType_CoordConstructor:
            root::mozilla::StyleAnimationValue_CoordConstructorType = 0;
        pub type StyleAnimationValue_CoordConstructorType = u32;
        pub const StyleAnimationValue_PercentConstructorType_PercentConstructor:
            root::mozilla::StyleAnimationValue_PercentConstructorType = 0;
        pub type StyleAnimationValue_PercentConstructorType = u32;
        pub const StyleAnimationValue_FloatConstructorType_FloatConstructor:
            root::mozilla::StyleAnimationValue_FloatConstructorType = 0;
        pub type StyleAnimationValue_FloatConstructorType = u32;
        pub const StyleAnimationValue_ColorConstructorType_ColorConstructor:
            root::mozilla::StyleAnimationValue_ColorConstructorType = 0;
        pub type StyleAnimationValue_ColorConstructorType = u32;
        #[test]
        fn bindgen_test_layout_StyleAnimationValue() {
            assert_eq!(
                ::std::mem::size_of::<StyleAnimationValue>(),
                16usize,
                concat!("Size of: ", stringify!(StyleAnimationValue))
            );
            assert_eq!(
                ::std::mem::align_of::<StyleAnimationValue>(),
                8usize,
                concat!("Alignment of ", stringify!(StyleAnimationValue))
            );
        }
        impl Clone for StyleAnimationValue {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct AnimationValue {
            pub mGecko: root::mozilla::StyleAnimationValue,
            pub mServo: root::RefPtr<root::RawServoAnimationValue>,
        }
        #[test]
        fn bindgen_test_layout_AnimationValue() {
            assert_eq!(
                ::std::mem::size_of::<AnimationValue>(),
                24usize,
                concat!("Size of: ", stringify!(AnimationValue))
            );
            assert_eq!(
                ::std::mem::align_of::<AnimationValue>(),
                8usize,
                concat!("Alignment of ", stringify!(AnimationValue))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<AnimationValue>())).mGecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(AnimationValue),
                    "::",
                    stringify!(mGecko)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<AnimationValue>())).mServo as *const _ as usize },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(AnimationValue),
                    "::",
                    stringify!(mServo)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct PropertyStyleAnimationValuePair {
            pub mProperty: root::nsCSSPropertyID,
            pub mValue: root::mozilla::AnimationValue,
        }
        #[test]
        fn bindgen_test_layout_PropertyStyleAnimationValuePair() {
            assert_eq!(
                ::std::mem::size_of::<PropertyStyleAnimationValuePair>(),
                32usize,
                concat!("Size of: ", stringify!(PropertyStyleAnimationValuePair))
            );
            assert_eq!(
                ::std::mem::align_of::<PropertyStyleAnimationValuePair>(),
                8usize,
                concat!("Alignment of ", stringify!(PropertyStyleAnimationValuePair))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<PropertyStyleAnimationValuePair>())).mProperty
                        as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(PropertyStyleAnimationValuePair),
                    "::",
                    stringify!(mProperty)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<PropertyStyleAnimationValuePair>())).mValue as *const _
                        as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(PropertyStyleAnimationValuePair),
                    "::",
                    stringify!(mValue)
                )
            );
        }
        #[repr(C)]
        pub struct StyleSheetInfo__bindgen_vtable(::std::os::raw::c_void);
        /// Struct for data common to CSSStyleSheetInner and ServoStyleSheet.
        #[repr(C)]
        pub struct StyleSheetInfo {
            pub vtable_: *const StyleSheetInfo__bindgen_vtable,
            pub mSheetURI: root::nsCOMPtr,
            pub mOriginalSheetURI: root::nsCOMPtr,
            pub mBaseURI: root::nsCOMPtr,
            pub mPrincipal: root::nsCOMPtr,
            pub mCORSMode: root::mozilla::CORSMode,
            pub mReferrerPolicy: root::mozilla::StyleSheetInfo_ReferrerPolicy,
            pub mIntegrity: root::mozilla::dom::SRIMetadata,
            pub mComplete: bool,
            pub mFirstChild: root::RefPtr<root::mozilla::StyleSheet>,
            pub mSheets: [u64; 10usize],
            pub mSourceMapURL: ::nsstring::nsStringRepr,
            pub mSourceMapURLFromComment: ::nsstring::nsStringRepr,
            pub mSourceURL: ::nsstring::nsStringRepr,
        }
        pub use self :: super :: super :: root :: mozilla :: net :: ReferrerPolicy as StyleSheetInfo_ReferrerPolicy;
        #[test]
        fn bindgen_test_layout_StyleSheetInfo() {
            assert_eq!(
                ::std::mem::size_of::<StyleSheetInfo>(),
                240usize,
                concat!("Size of: ", stringify!(StyleSheetInfo))
            );
            assert_eq!(
                ::std::mem::align_of::<StyleSheetInfo>(),
                8usize,
                concat!("Alignment of ", stringify!(StyleSheetInfo))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleSheetInfo>())).mSheetURI as *const _ as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleSheetInfo),
                    "::",
                    stringify!(mSheetURI)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleSheetInfo>())).mOriginalSheetURI as *const _
                        as usize
                },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleSheetInfo),
                    "::",
                    stringify!(mOriginalSheetURI)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<StyleSheetInfo>())).mBaseURI as *const _ as usize },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleSheetInfo),
                    "::",
                    stringify!(mBaseURI)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleSheetInfo>())).mPrincipal as *const _ as usize
                },
                32usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleSheetInfo),
                    "::",
                    stringify!(mPrincipal)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleSheetInfo>())).mCORSMode as *const _ as usize
                },
                40usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleSheetInfo),
                    "::",
                    stringify!(mCORSMode)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleSheetInfo>())).mReferrerPolicy as *const _ as usize
                },
                44usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleSheetInfo),
                    "::",
                    stringify!(mReferrerPolicy)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleSheetInfo>())).mIntegrity as *const _ as usize
                },
                48usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleSheetInfo),
                    "::",
                    stringify!(mIntegrity)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleSheetInfo>())).mComplete as *const _ as usize
                },
                96usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleSheetInfo),
                    "::",
                    stringify!(mComplete)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleSheetInfo>())).mFirstChild as *const _ as usize
                },
                104usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleSheetInfo),
                    "::",
                    stringify!(mFirstChild)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<StyleSheetInfo>())).mSheets as *const _ as usize },
                112usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleSheetInfo),
                    "::",
                    stringify!(mSheets)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleSheetInfo>())).mSourceMapURL as *const _ as usize
                },
                192usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleSheetInfo),
                    "::",
                    stringify!(mSourceMapURL)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleSheetInfo>())).mSourceMapURLFromComment as *const _
                        as usize
                },
                208usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleSheetInfo),
                    "::",
                    stringify!(mSourceMapURLFromComment)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<StyleSheetInfo>())).mSourceURL as *const _ as usize
                },
                224usize,
                concat!(
                    "Offset of field: ",
                    stringify!(StyleSheetInfo),
                    "::",
                    stringify!(mSourceURL)
                )
            );
        }
        /// CondVar
        /// Vanilla condition variable.  Please don't use this unless you have a
        /// compelling reason --- Monitor provides a simpler API.
        #[repr(C)]
        #[derive(Debug)]
        pub struct CondVar {
            pub mLock: *mut root::mozilla::Mutex,
            pub mImpl: root::mozilla::detail::ConditionVariableImpl,
        }
        #[test]
        fn bindgen_test_layout_CondVar() {
            assert_eq!(
                ::std::mem::size_of::<CondVar>(),
                56usize,
                concat!("Size of: ", stringify!(CondVar))
            );
            assert_eq!(
                ::std::mem::align_of::<CondVar>(),
                8usize,
                concat!("Alignment of ", stringify!(CondVar))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<CondVar>())).mLock as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CondVar),
                    "::",
                    stringify!(mLock)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<CondVar>())).mImpl as *const _ as usize },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CondVar),
                    "::",
                    stringify!(mImpl)
                )
            );
        }
        /// Monitor provides a *non*-reentrant monitor: *not* a Java-style
        /// monitor.  If your code needs support for reentrancy, use
        /// ReentrantMonitor instead.  (Rarely should reentrancy be needed.)
        ///
        /// Instead of directly calling Monitor methods, it's safer and simpler
        /// to instead use the RAII wrappers MonitorAutoLock and
        /// MonitorAutoUnlock.
        #[repr(C)]
        #[derive(Debug)]
        pub struct Monitor {
            pub mMutex: root::mozilla::Mutex,
            pub mCondVar: root::mozilla::CondVar,
        }
        #[test]
        fn bindgen_test_layout_Monitor() {
            assert_eq!(
                ::std::mem::size_of::<Monitor>(),
                96usize,
                concat!("Size of: ", stringify!(Monitor))
            );
            assert_eq!(
                ::std::mem::align_of::<Monitor>(),
                8usize,
                concat!("Alignment of ", stringify!(Monitor))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<Monitor>())).mMutex as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Monitor),
                    "::",
                    stringify!(mMutex)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<Monitor>())).mCondVar as *const _ as usize },
                40usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Monitor),
                    "::",
                    stringify!(mCondVar)
                )
            );
        }
        #[repr(C)]
        pub struct MozPromiseRefcountable__bindgen_vtable(::std::os::raw::c_void);
        #[repr(C)]
        #[derive(Debug)]
        pub struct MozPromiseRefcountable {
            pub vtable_: *const MozPromiseRefcountable__bindgen_vtable,
            pub mRefCnt: root::mozilla::ThreadSafeAutoRefCnt,
        }
        pub type MozPromiseRefcountable_HasThreadSafeRefCnt = root::mozilla::TrueType;
        #[test]
        fn bindgen_test_layout_MozPromiseRefcountable() {
            assert_eq!(
                ::std::mem::size_of::<MozPromiseRefcountable>(),
                16usize,
                concat!("Size of: ", stringify!(MozPromiseRefcountable))
            );
            assert_eq!(
                ::std::mem::align_of::<MozPromiseRefcountable>(),
                8usize,
                concat!("Alignment of ", stringify!(MozPromiseRefcountable))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<MozPromiseRefcountable>())).mRefCnt as *const _ as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(MozPromiseRefcountable),
                    "::",
                    stringify!(mRefCnt)
                )
            );
        }
        pub type MozPromise_ResolveValueType<ResolveValueT> = ResolveValueT;
        pub type MozPromise_RejectValueType<RejectValueT> = RejectValueT;
        #[repr(C)]
        #[derive(Debug)]
        pub struct MozPromise_ResolveOrRejectValue {
            pub mValue: root::mozilla::MozPromise_ResolveOrRejectValue_Storage,
        }
        pub const MozPromise_ResolveOrRejectValue_NothingIndex:
            root::mozilla::MozPromise_ResolveOrRejectValue__bindgen_ty_1 = 0;
        pub const MozPromise_ResolveOrRejectValue_ResolveIndex:
            root::mozilla::MozPromise_ResolveOrRejectValue__bindgen_ty_1 = 0;
        pub const MozPromise_ResolveOrRejectValue_RejectIndex:
            root::mozilla::MozPromise_ResolveOrRejectValue__bindgen_ty_1 = 0;
        pub type MozPromise_ResolveOrRejectValue__bindgen_ty_1 = i32;
        pub type MozPromise_ResolveOrRejectValue_Storage = root::mozilla::Variant;
        pub type MozPromise_AllPromiseType = u8;
        #[repr(C)]
        #[derive(Debug)]
        pub struct MozPromise_AllPromiseHolder {
            pub _base: root::mozilla::MozPromiseRefcountable,
            pub mResolveValues: u8,
            pub mPromise: root::RefPtr<root::mozilla::MozPromise_AllPromiseType>,
            pub mOutstandingPromises: usize,
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct MozPromise_Request {
            pub _base: root::mozilla::MozPromiseRefcountable,
            pub mComplete: bool,
            pub mDisconnected: bool,
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct MozPromise_ThenValueBase {
            pub _base: root::mozilla::MozPromise_Request,
            pub mResponseTarget: root::nsCOMPtr,
            pub mMagic1: u32,
            pub mCallSite: *const ::std::os::raw::c_char,
            pub mMagic2: u32,
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct MozPromise_ThenValueBase_ResolveOrRejectRunnable {
            pub _base: root::mozilla::CancelableRunnable,
            pub mThenValue: root::RefPtr<root::mozilla::MozPromise_ThenValueBase>,
            pub mPromise: u8,
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct MozPromise_ThenValue {
            pub _address: u8,
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct MozPromise_ThenCommand<ThenValueType> {
            pub mCallSite: *const ::std::os::raw::c_char,
            pub mThenValue: root::RefPtr<ThenValueType>,
            pub mReceiver: u8,
            pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<ThenValueType>>,
        }
        pub type MozPromise_ThenCommand_PromiseType = [u8; 0usize];
        pub type MozPromise_ThenCommand_Private = [u8; 0usize];
        #[repr(C)]
        #[derive(Debug)]
        pub struct MozPromise_Private {
            pub _base: u8,
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct MozPromiseHolder<PromiseType> {
            pub mMonitor: *mut root::mozilla::Monitor,
            pub mPromise: root::RefPtr<PromiseType>,
            pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<PromiseType>>,
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct ServoCSSRuleList {
            _unused: [u8; 0],
        }
        impl Clone for ServoCSSRuleList {
            fn clone(&self) -> Self {
                *self
            }
        }
        pub type StyleSheetParsePromise = [u64; 16usize];
        #[repr(C)]
        pub struct ServoStyleSheetInner {
            pub _base: root::mozilla::StyleSheetInfo,
            pub mContents: root::RefPtr<root::RawServoStyleSheetContents>,
            pub mURLData: root::RefPtr<root::mozilla::URLExtraData>,
        }
        #[test]
        fn bindgen_test_layout_ServoStyleSheetInner() {
            assert_eq!(
                ::std::mem::size_of::<ServoStyleSheetInner>(),
                256usize,
                concat!("Size of: ", stringify!(ServoStyleSheetInner))
            );
            assert_eq!(
                ::std::mem::align_of::<ServoStyleSheetInner>(),
                8usize,
                concat!("Alignment of ", stringify!(ServoStyleSheetInner))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoStyleSheetInner>())).mContents as *const _ as usize
                },
                240usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoStyleSheetInner),
                    "::",
                    stringify!(mContents)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoStyleSheetInner>())).mURLData as *const _ as usize
                },
                248usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoStyleSheetInner),
                    "::",
                    stringify!(mURLData)
                )
            );
        }
        #[repr(C)]
        pub struct ServoStyleSheet {
            pub _base: root::mozilla::StyleSheet,
            pub mRuleList: root::RefPtr<root::mozilla::ServoCSSRuleList>,
            pub mParsePromise:
                root::mozilla::MozPromiseHolder<root::mozilla::StyleSheetParsePromise>,
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct ServoStyleSheet_cycleCollection {
            pub _base: root::mozilla::StyleSheet_cycleCollection,
        }
        #[test]
        fn bindgen_test_layout_ServoStyleSheet_cycleCollection() {
            assert_eq!(
                ::std::mem::size_of::<ServoStyleSheet_cycleCollection>(),
                16usize,
                concat!("Size of: ", stringify!(ServoStyleSheet_cycleCollection))
            );
            assert_eq!(
                ::std::mem::align_of::<ServoStyleSheet_cycleCollection>(),
                8usize,
                concat!("Alignment of ", stringify!(ServoStyleSheet_cycleCollection))
            );
        }
        impl Clone for ServoStyleSheet_cycleCollection {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct ServoStyleSheet_COMTypeInfo {
            pub _address: u8,
        }
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla15ServoStyleSheet21_cycleCollectorGlobalE"]
            pub static mut ServoStyleSheet__cycleCollectorGlobal:
                root::mozilla::ServoStyleSheet_cycleCollection;
        }
        #[test]
        fn bindgen_test_layout_ServoStyleSheet() {
            assert_eq!(
                ::std::mem::size_of::<ServoStyleSheet>(),
                152usize,
                concat!("Size of: ", stringify!(ServoStyleSheet))
            );
            assert_eq!(
                ::std::mem::align_of::<ServoStyleSheet>(),
                8usize,
                concat!("Alignment of ", stringify!(ServoStyleSheet))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoStyleSheet>())).mRuleList as *const _ as usize
                },
                128usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoStyleSheet),
                    "::",
                    stringify!(mRuleList)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoStyleSheet>())).mParsePromise as *const _ as usize
                },
                136usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoStyleSheet),
                    "::",
                    stringify!(mParsePromise)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct URIPrincipalReferrerPolicyAndCORSModeHashKey {
            pub _base: root::nsURIHashKey,
            pub mPrincipal: root::nsCOMPtr,
            pub mCORSMode: root::mozilla::CORSMode,
            pub mReferrerPolicy:
                root::mozilla::URIPrincipalReferrerPolicyAndCORSModeHashKey_ReferrerPolicy,
        }
        pub type URIPrincipalReferrerPolicyAndCORSModeHashKey_KeyType =
            *mut root::mozilla::URIPrincipalReferrerPolicyAndCORSModeHashKey;
        pub type URIPrincipalReferrerPolicyAndCORSModeHashKey_KeyTypePointer =
            *const root::mozilla::URIPrincipalReferrerPolicyAndCORSModeHashKey;
        pub use self :: super :: super :: root :: mozilla :: net :: ReferrerPolicy as URIPrincipalReferrerPolicyAndCORSModeHashKey_ReferrerPolicy;
        pub const URIPrincipalReferrerPolicyAndCORSModeHashKey_ALLOW_MEMMOVE:
            root::mozilla::URIPrincipalReferrerPolicyAndCORSModeHashKey__bindgen_ty_1 = 1;
        pub type URIPrincipalReferrerPolicyAndCORSModeHashKey__bindgen_ty_1 = u32;
        #[test]
        fn bindgen_test_layout_URIPrincipalReferrerPolicyAndCORSModeHashKey() {
            assert_eq!(
                ::std::mem::size_of::<URIPrincipalReferrerPolicyAndCORSModeHashKey>(),
                32usize,
                concat!(
                    "Size of: ",
                    stringify!(URIPrincipalReferrerPolicyAndCORSModeHashKey)
                )
            );
            assert_eq!(
                ::std::mem::align_of::<URIPrincipalReferrerPolicyAndCORSModeHashKey>(),
                8usize,
                concat!(
                    "Alignment of ",
                    stringify!(URIPrincipalReferrerPolicyAndCORSModeHashKey)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<URIPrincipalReferrerPolicyAndCORSModeHashKey>()))
                        .mPrincipal as *const _ as usize
                },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(URIPrincipalReferrerPolicyAndCORSModeHashKey),
                    "::",
                    stringify!(mPrincipal)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<URIPrincipalReferrerPolicyAndCORSModeHashKey>()))
                        .mCORSMode as *const _ as usize
                },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(URIPrincipalReferrerPolicyAndCORSModeHashKey),
                    "::",
                    stringify!(mCORSMode)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<URIPrincipalReferrerPolicyAndCORSModeHashKey>()))
                        .mReferrerPolicy as *const _ as usize
                },
                28usize,
                concat!(
                    "Offset of field: ",
                    stringify!(URIPrincipalReferrerPolicyAndCORSModeHashKey),
                    "::",
                    stringify!(mReferrerPolicy)
                )
            );
        }
        /// An encoding as defined in the Encoding Standard
        /// (https://encoding.spec.whatwg.org/).
        ///
        /// See https://docs.rs/encoding_rs/ for the Rust API docs.
        ///
        /// An _encoding_ defines a mapping from a byte sequence to a Unicode code point
        /// sequence and, in most cases, vice versa. Each encoding has a name, an output
        /// encoding, and one or more labels.
        ///
        /// _Labels_ are ASCII-case-insensitive strings that are used to identify an
        /// encoding in formats and protocols. The _name_ of the encoding is the
        /// preferred label in the case appropriate for returning from the
        /// `characterSet` property of the `Document` DOM interface, except for
        /// the replacement encoding whose name is not one of its labels.
        ///
        /// The _output encoding_ is the encoding used for form submission and URL
        /// parsing on Web pages in the encoding. This is UTF-8 for the replacement,
        /// UTF-16LE and UTF-16BE encodings and the encoding itself for other
        /// encodings.
        ///
        /// # Streaming vs. Non-Streaming
        ///
        /// When you have the entire input in a single buffer, you can use the
        /// methods `Decode()`, `DecodeWithBOMRemoval()`,
        /// `DecodeWithoutBOMHandling()`,
        /// `DecodeWithoutBOMHandlingAndWithoutReplacement()` and
        /// `Encode()`. Unlike the rest of the API (apart from the `NewDecoder()` and
        /// NewEncoder()` methods), these methods perform heap allocations. You should
        /// the `Decoder` and `Encoder` objects when your input is split into multiple
        /// buffers or when you want to control the allocation of the output buffers.
        ///
        /// # Instances
        ///
        /// All instances of `Encoding` are statically allocated and have the process's
        /// lifetime. There is precisely one unique `Encoding` instance for each
        /// encoding defined in the Encoding Standard.
        ///
        /// To obtain a reference to a particular encoding whose identity you know at
        /// compile time, use a `static` that refers to encoding. There is a `static`
        /// for each encoding. The `static`s are named in all caps with hyphens
        /// replaced with underscores and with `_ENCODING` appended to the
        /// name. For example, if you know at compile time that you will want to
        /// decode using the UTF-8 encoding, use the `UTF_8_ENCODING` `static`.
        ///
        /// If you don't know what encoding you need at compile time and need to
        /// dynamically get an encoding by label, use `Encoding::for_label()`.
        ///
        /// Pointers to `Encoding` can be compared with `==` to check for the sameness
        /// of two encodings.
        ///
        /// A pointer to a `mozilla::Encoding` in C++ is the same thing as a pointer
        /// to an `encoding_rs::Encoding` in Rust. When writing FFI code, use
        /// `const mozilla::Encoding*` in the C signature and
        /// `*const encoding_rs::Encoding` is the corresponding Rust signature.
        #[repr(C)]
        #[derive(Debug)]
        pub struct Encoding {
            pub _address: u8,
        }
        #[test]
        fn bindgen_test_layout_Encoding() {
            assert_eq!(
                ::std::mem::size_of::<Encoding>(),
                1usize,
                concat!("Size of: ", stringify!(Encoding))
            );
            assert_eq!(
                ::std::mem::align_of::<Encoding>(),
                1usize,
                concat!("Alignment of ", stringify!(Encoding))
            );
        }
        /// A converter that decodes a byte stream into Unicode according to a
        /// character encoding in a streaming (incremental) manner.
        ///
        /// The various `Decode*` methods take an input buffer (`aSrc`) and an output
        /// buffer `aDst` both of which are caller-allocated. There are variants for
        /// both UTF-8 and UTF-16 output buffers.
        ///
        /// A `Decode*` method decodes bytes from `aSrc` into Unicode characters stored
        /// into `aDst` until one of the following three things happens:
        ///
        /// 1. A malformed byte sequence is encountered (`*WithoutReplacement`
        /// variants only).
        ///
        /// 2. The output buffer has been filled so near capacity that the decoder
        /// cannot be sure that processing an additional byte of input wouldn't
        /// cause so much output that the output buffer would overflow.
        ///
        /// 3. All the input bytes have been processed.
        ///
        /// The `Decode*` method then returns tuple of a status indicating which one
        /// of the three reasons to return happened, how many input bytes were read,
        /// how many output code units (`uint8_t` when decoding into UTF-8 and `char16_t`
        /// when decoding to UTF-16) were written, and in the case of the
        /// variants performing replacement, a boolean indicating whether an error was
        /// replaced with the REPLACEMENT CHARACTER during the call.
        ///
        /// The number of bytes "written" is what's logically written. Garbage may be
        /// written in the output buffer beyond the point logically written to.
        ///
        /// In the case of the `*WithoutReplacement` variants, the status is a
        /// `uint32_t` whose possible values are packed info about a malformed byte
        /// sequence, `kOutputFull` and `kInputEmpty` corresponding to the three cases
        /// listed above).
        ///
        /// Packed info about malformed sequences has the following format:
        /// The lowest 8 bits, which can have the decimal value 0, 1, 2 or 3,
        /// indicate the number of bytes that were consumed after the malformed
        /// sequence and whose next-lowest 8 bits, when shifted right by 8 indicate
        /// the length of the malformed byte sequence (possible decimal values 1, 2,
        /// 3 or 4). The maximum possible sum of the two is 6.
        ///
        /// In the case of methods whose name does not end with
        /// `*WithoutReplacement`, malformed sequences are automatically replaced
        /// with the REPLACEMENT CHARACTER and errors do not cause the methods to
        /// return early.
        ///
        /// When decoding to UTF-8, the output buffer must have at least 4 bytes of
        /// space. When decoding to UTF-16, the output buffer must have at least two
        /// UTF-16 code units (`char16_t`) of space.
        ///
        /// When decoding to UTF-8 without replacement, the methods are guaranteed
        /// not to return indicating that more output space is needed if the length
        /// of the output buffer is at least the length returned by
        /// `MaxUTF8BufferLengthWithoutReplacement()`. When decoding to UTF-8
        /// with replacement, the length of the output buffer that guarantees the
        /// methods not to return indicating that more output space is needed is given
        /// by `MaxUTF8BufferLength()`. When decoding to UTF-16 with
        /// or without replacement, the length of the output buffer that guarantees
        /// the methods not to return indicating that more output space is needed is
        /// given by `MaxUTF16BufferLength()`.
        ///
        /// The output written into `aDst` is guaranteed to be valid UTF-8 or UTF-16,
        /// and the output after each `Decode*` call is guaranteed to consist of
        /// complete characters. (I.e. the code unit sequence for the last character is
        /// guaranteed not to be split across output buffers.)
        ///
        /// The boolean argument `aLast` indicates that the end of the stream is reached
        /// when all the bytes in `aSrc` have been consumed.
        ///
        /// A `Decoder` object can be used to incrementally decode a byte stream.
        ///
        /// During the processing of a single stream, the caller must call `Decode*`
        /// zero or more times with `aLast` set to `false` and then call `Decode*` at
        /// least once with `aLast` set to `true`. If `Decode*` returns `kInputEmpty`,
        /// the processing of the stream has ended. Otherwise, the caller must call
        /// `Decode*` again with `aLast` set to `true` (or treat a malformed result,
        /// i.e. neither `kInputEmpty` nor `kOutputFull`, as a fatal error).
        ///
        /// Once the stream has ended, the `Decoder` object must not be used anymore.
        /// That is, you need to create another one to process another stream.
        ///
        /// When the decoder returns `kOutputFull` or the decoder returns a malformed
        /// result and the caller does not wish to treat it as a fatal error, the input
        /// buffer `aSrc` may not have been completely consumed. In that case, the caller
        /// must pass the unconsumed contents of `aSrc` to `Decode*` again upon the next
        /// call.
        ///
        /// # Infinite loops
        ///
        /// When converting with a fixed-size output buffer whose size is too small to
        /// accommodate one character of output, an infinite loop ensues. When
        /// converting with a fixed-size output buffer, it generally makes sense to
        /// make the buffer fairly large (e.g. couple of kilobytes).
        #[repr(C)]
        #[derive(Debug)]
        pub struct Decoder {
            pub _address: u8,
        }
        #[test]
        fn bindgen_test_layout_Decoder() {
            assert_eq!(
                ::std::mem::size_of::<Decoder>(),
                1usize,
                concat!("Size of: ", stringify!(Decoder))
            );
            assert_eq!(
                ::std::mem::align_of::<Decoder>(),
                1usize,
                concat!("Alignment of ", stringify!(Decoder))
            );
        }
        /// A converter that encodes a Unicode stream into bytes according to a
        /// character encoding in a streaming (incremental) manner.
        ///
        /// The various `Encode*` methods take an input buffer (`aSrc`) and an output
        /// buffer `aDst` both of which are caller-allocated. There are variants for
        /// both UTF-8 and UTF-16 input buffers.
        ///
        /// An `Encode*` method encode characters from `aSrc` into bytes characters
        /// stored into `aDst` until one of the following three things happens:
        ///
        /// 1. An unmappable character is encountered (`*WithoutReplacement` variants
        /// only).
        ///
        /// 2. The output buffer has been filled so near capacity that the decoder
        /// cannot be sure that processing an additional character of input wouldn't
        /// cause so much output that the output buffer would overflow.
        ///
        /// 3. All the input characters have been processed.
        ///
        /// The `Encode*` method then returns tuple of a status indicating which one
        /// of the three reasons to return happened, how many input code units (`uint8_t`
        /// when encoding from UTF-8 and `char16_t` when encoding from UTF-16) were read,
        /// how many output bytes were written, and in the case of the variants that
        /// perform replacement, a boolean indicating whether an unmappable
        /// character was replaced with a numeric character reference during the call.
        ///
        /// The number of bytes "written" is what's logically written. Garbage may be
        /// written in the output buffer beyond the point logically written to.
        ///
        /// In the case of the methods whose name ends with
        /// `*WithoutReplacement`, the status is a `uint32_t` whose possible values
        /// are an unmappable code point, `kOutputFull` and `kInputEmpty` corresponding
        /// to the three cases listed above).
        ///
        /// In the case of methods whose name does not end with
        /// `*WithoutReplacement`, unmappable characters are automatically replaced
        /// with the corresponding numeric character references and unmappable
        /// characters do not cause the methods to return early.
        ///
        /// When encoding from UTF-8 without replacement, the methods are guaranteed
        /// not to return indicating that more output space is needed if the length
        /// of the output buffer is at least the length returned by
        /// `MaxBufferLengthFromUTF8WithoutReplacement()`. When encoding from
        /// UTF-8 with replacement, the length of the output buffer that guarantees the
        /// methods not to return indicating that more output space is needed in the
        /// absence of unmappable characters is given by
        /// `MaxBufferLengthFromUTF8IfNoUnmappables()`. When encoding from
        /// UTF-16 without replacement, the methods are guaranteed not to return
        /// indicating that more output space is needed if the length of the output
        /// buffer is at least the length returned by
        /// `MaxBufferLengthFromUTF16WithoutReplacement()`. When encoding
        /// from UTF-16 with replacement, the the length of the output buffer that
        /// guarantees the methods not to return indicating that more output space is
        /// needed in the absence of unmappable characters is given by
        /// `MaxBufferLengthFromUTF16IfNoUnmappables()`.
        /// When encoding with replacement, applications are not expected to size the
        /// buffer for the worst case ahead of time but to resize the buffer if there
        /// are unmappable characters. This is why max length queries are only available
        /// for the case where there are no unmappable characters.
        ///
        /// When encoding from UTF-8, each `aSrc` buffer _must_ be valid UTF-8. When
        /// encoding from UTF-16, unpaired surrogates in the input are treated as U+FFFD
        /// REPLACEMENT CHARACTERS. Therefore, in order for astral characters not to
        /// turn into a pair of REPLACEMENT CHARACTERS, the caller must ensure that
        /// surrogate pairs are not split across input buffer boundaries.
        ///
        /// After an `Encode*` call returns, the output produced so far, taken as a
        /// whole from the start of the stream, is guaranteed to consist of a valid
        /// byte sequence in the target encoding. (I.e. the code unit sequence for a
        /// character is guaranteed not to be split across output buffers. However, due
        /// to the stateful nature of ISO-2022-JP, the stream needs to be considered
        /// from the start for it to be valid. For other encodings, the validity holds
        /// on a per-output buffer basis.)
        ///
        /// The boolean argument `aLast` indicates that the end of the stream is reached
        /// when all the characters in `aSrc` have been consumed. This argument is needed
        /// for ISO-2022-JP and is ignored for other encodings.
        ///
        /// An `Encoder` object can be used to incrementally encode a byte stream.
        ///
        /// During the processing of a single stream, the caller must call `Encode*`
        /// zero or more times with `aLast` set to `false` and then call `Encode*` at
        /// least once with `aLast` set to `true`. If `Encode*` returns `kInputEmpty`,
        /// the processing of the stream has ended. Otherwise, the caller must call
        /// `Encode*` again with `aLast` set to `true` (or treat an unmappable result,
        /// i.e. neither `kInputEmpty` nor `kOutputFull`, as a fatal error).
        ///
        /// Once the stream has ended, the `Encoder` object must not be used anymore.
        /// That is, you need to create another one to process another stream.
        ///
        /// When the encoder returns `kOutputFull` or the encoder returns an unmappable
        /// result and the caller does not wish to treat it as a fatal error, the input
        /// buffer `aSrc` may not have been completely consumed. In that case, the caller
        /// must pass the unconsumed contents of `aSrc` to `Encode*` again upon the next
        /// call.
        ///
        /// # Infinite loops
        ///
        /// When converting with a fixed-size output buffer whose size is too small to
        /// accommodate one character of output, an infinite loop ensues. When
        /// converting with a fixed-size output buffer, it generally makes sense to
        /// make the buffer fairly large (e.g. couple of kilobytes).
        #[repr(C)]
        #[derive(Debug)]
        pub struct Encoder {
            pub _address: u8,
        }
        #[test]
        fn bindgen_test_layout_Encoder() {
            assert_eq!(
                ::std::mem::size_of::<Encoder>(),
                1usize,
                concat!("Size of: ", stringify!(Encoder))
            );
            assert_eq!(
                ::std::mem::align_of::<Encoder>(),
                1usize,
                concat!("Alignment of ", stringify!(Encoder))
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct BindingStyleRule {
            pub _base: root::mozilla::css::Rule,
        }
        #[test]
        fn bindgen_test_layout_BindingStyleRule() {
            assert_eq!(
                ::std::mem::size_of::<BindingStyleRule>(),
                64usize,
                concat!("Size of: ", stringify!(BindingStyleRule))
            );
            assert_eq!(
                ::std::mem::align_of::<BindingStyleRule>(),
                8usize,
                concat!("Alignment of ", stringify!(BindingStyleRule))
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct ServoStyleRuleDeclaration {
            pub _base: root::nsDOMCSSDeclaration,
            pub mDecls: root::RefPtr<root::mozilla::ServoDeclarationBlock>,
        }
        #[test]
        fn bindgen_test_layout_ServoStyleRuleDeclaration() {
            assert_eq!(
                ::std::mem::size_of::<ServoStyleRuleDeclaration>(),
                40usize,
                concat!("Size of: ", stringify!(ServoStyleRuleDeclaration))
            );
            assert_eq!(
                ::std::mem::align_of::<ServoStyleRuleDeclaration>(),
                8usize,
                concat!("Alignment of ", stringify!(ServoStyleRuleDeclaration))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoStyleRuleDeclaration>())).mDecls as *const _
                        as usize
                },
                32usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoStyleRuleDeclaration),
                    "::",
                    stringify!(mDecls)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct ServoStyleRule {
            pub _base: root::mozilla::BindingStyleRule,
            pub _base_1: u64,
            pub mRawRule: root::RefPtr<root::RawServoStyleRule>,
            pub mDecls: root::mozilla::ServoStyleRuleDeclaration,
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct ServoStyleRule_cycleCollection {
            pub _base: root::mozilla::css::Rule_cycleCollection,
        }
        #[test]
        fn bindgen_test_layout_ServoStyleRule_cycleCollection() {
            assert_eq!(
                ::std::mem::size_of::<ServoStyleRule_cycleCollection>(),
                16usize,
                concat!("Size of: ", stringify!(ServoStyleRule_cycleCollection))
            );
            assert_eq!(
                ::std::mem::align_of::<ServoStyleRule_cycleCollection>(),
                8usize,
                concat!("Alignment of ", stringify!(ServoStyleRule_cycleCollection))
            );
        }
        impl Clone for ServoStyleRule_cycleCollection {
            fn clone(&self) -> Self {
                *self
            }
        }
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla14ServoStyleRule21_cycleCollectorGlobalE"]
            pub static mut ServoStyleRule__cycleCollectorGlobal:
                root::mozilla::ServoStyleRule_cycleCollection;
        }
        #[test]
        fn bindgen_test_layout_ServoStyleRule() {
            assert_eq!(
                ::std::mem::size_of::<ServoStyleRule>(),
                120usize,
                concat!("Size of: ", stringify!(ServoStyleRule))
            );
            assert_eq!(
                ::std::mem::align_of::<ServoStyleRule>(),
                8usize,
                concat!("Alignment of ", stringify!(ServoStyleRule))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<ServoStyleRule>())).mRawRule as *const _ as usize },
                72usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoStyleRule),
                    "::",
                    stringify!(mRawRule)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<ServoStyleRule>())).mDecls as *const _ as usize },
                80usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoStyleRule),
                    "::",
                    stringify!(mDecls)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct ServoStyleRuleMap {
            pub mTable: root::mozilla::ServoStyleRuleMap_Hashtable,
        }
        pub type ServoStyleRuleMap_Hashtable = [u64; 4usize];
        #[test]
        fn bindgen_test_layout_ServoStyleRuleMap() {
            assert_eq!(
                ::std::mem::size_of::<ServoStyleRuleMap>(),
                32usize,
                concat!("Size of: ", stringify!(ServoStyleRuleMap))
            );
            assert_eq!(
                ::std::mem::align_of::<ServoStyleRuleMap>(),
                8usize,
                concat!("Alignment of ", stringify!(ServoStyleRuleMap))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoStyleRuleMap>())).mTable as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoStyleRuleMap),
                    "::",
                    stringify!(mTable)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct ComputedTimingFunction {
            pub mType: root::nsTimingFunction_Type,
            pub mTimingFunction: root::nsSMILKeySpline,
            pub mStepsOrFrames: u32,
        }
        pub const ComputedTimingFunction_BeforeFlag_Unset:
            root::mozilla::ComputedTimingFunction_BeforeFlag = 0;
        pub const ComputedTimingFunction_BeforeFlag_Set:
            root::mozilla::ComputedTimingFunction_BeforeFlag = 1;
        pub type ComputedTimingFunction_BeforeFlag = i32;
        #[test]
        fn bindgen_test_layout_ComputedTimingFunction() {
            assert_eq!(
                ::std::mem::size_of::<ComputedTimingFunction>(),
                136usize,
                concat!("Size of: ", stringify!(ComputedTimingFunction))
            );
            assert_eq!(
                ::std::mem::align_of::<ComputedTimingFunction>(),
                8usize,
                concat!("Alignment of ", stringify!(ComputedTimingFunction))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ComputedTimingFunction>())).mType as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ComputedTimingFunction),
                    "::",
                    stringify!(mType)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ComputedTimingFunction>())).mTimingFunction as *const _
                        as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ComputedTimingFunction),
                    "::",
                    stringify!(mTimingFunction)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ComputedTimingFunction>())).mStepsOrFrames as *const _
                        as usize
                },
                128usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ComputedTimingFunction),
                    "::",
                    stringify!(mStepsOrFrames)
                )
            );
        }
        impl Clone for ComputedTimingFunction {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct AnimationPropertySegment {
            pub mFromKey: f32,
            pub mToKey: f32,
            pub mFromValue: root::mozilla::AnimationValue,
            pub mToValue: root::mozilla::AnimationValue,
            pub mTimingFunction: [u64; 18usize],
            pub mFromComposite: root::mozilla::dom::CompositeOperation,
            pub mToComposite: root::mozilla::dom::CompositeOperation,
        }
        #[test]
        fn bindgen_test_layout_AnimationPropertySegment() {
            assert_eq!(
                ::std::mem::size_of::<AnimationPropertySegment>(),
                208usize,
                concat!("Size of: ", stringify!(AnimationPropertySegment))
            );
            assert_eq!(
                ::std::mem::align_of::<AnimationPropertySegment>(),
                8usize,
                concat!("Alignment of ", stringify!(AnimationPropertySegment))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<AnimationPropertySegment>())).mFromKey as *const _
                        as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(AnimationPropertySegment),
                    "::",
                    stringify!(mFromKey)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<AnimationPropertySegment>())).mToKey as *const _ as usize
                },
                4usize,
                concat!(
                    "Offset of field: ",
                    stringify!(AnimationPropertySegment),
                    "::",
                    stringify!(mToKey)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<AnimationPropertySegment>())).mFromValue as *const _
                        as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(AnimationPropertySegment),
                    "::",
                    stringify!(mFromValue)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<AnimationPropertySegment>())).mToValue as *const _
                        as usize
                },
                32usize,
                concat!(
                    "Offset of field: ",
                    stringify!(AnimationPropertySegment),
                    "::",
                    stringify!(mToValue)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<AnimationPropertySegment>())).mTimingFunction as *const _
                        as usize
                },
                56usize,
                concat!(
                    "Offset of field: ",
                    stringify!(AnimationPropertySegment),
                    "::",
                    stringify!(mTimingFunction)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<AnimationPropertySegment>())).mFromComposite as *const _
                        as usize
                },
                200usize,
                concat!(
                    "Offset of field: ",
                    stringify!(AnimationPropertySegment),
                    "::",
                    stringify!(mFromComposite)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<AnimationPropertySegment>())).mToComposite as *const _
                        as usize
                },
                201usize,
                concat!(
                    "Offset of field: ",
                    stringify!(AnimationPropertySegment),
                    "::",
                    stringify!(mToComposite)
                )
            );
        }
        /// A ValueCalculator class that performs additional checks before performing
        /// arithmetic operations such that if either operand is Forever (or the
        /// negative equivalent) the result remains Forever (or the negative equivalent
        /// as appropriate).
        ///
        /// Currently this only checks if either argument to each operation is
        /// Forever/-Forever. However, it is possible that, for example,
        /// aA + aB > INT64_MAX (or < INT64_MIN).
        ///
        /// We currently don't check for that case since we don't expect that to
        /// happen often except under test conditions in which case the wrapping
        /// behavior is probably acceptable.
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct StickyTimeDurationValueCalculator {
            pub _address: u8,
        }
        #[test]
        fn bindgen_test_layout_StickyTimeDurationValueCalculator() {
            assert_eq!(
                ::std::mem::size_of::<StickyTimeDurationValueCalculator>(),
                1usize,
                concat!("Size of: ", stringify!(StickyTimeDurationValueCalculator))
            );
            assert_eq!(
                ::std::mem::align_of::<StickyTimeDurationValueCalculator>(),
                1usize,
                concat!(
                    "Alignment of ",
                    stringify!(StickyTimeDurationValueCalculator)
                )
            );
        }
        impl Clone for StickyTimeDurationValueCalculator {
            fn clone(&self) -> Self {
                *self
            }
        }
        /// Specialization of BaseTimeDuration that uses
        /// StickyTimeDurationValueCalculator for arithmetic on the mValue member.
        ///
        /// Use this class when you need a time duration that is expected to hold values
        /// of Forever (or the negative equivalent) *and* when you expect that
        /// time duration to be used in arithmetic operations (and not just value
        /// comparisons).
        pub type StickyTimeDuration = root::mozilla::BaseTimeDuration;
        /// Stores the results of calculating the timing properties of an animation
        /// at a given sample time.
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct ComputedTiming {
            pub mActiveDuration: root::mozilla::StickyTimeDuration,
            pub mActiveTime: root::mozilla::StickyTimeDuration,
            pub mEndTime: root::mozilla::StickyTimeDuration,
            pub mProgress: [u64; 2usize],
            pub mCurrentIteration: u64,
            pub mIterations: f64,
            pub mIterationStart: f64,
            pub mDuration: root::mozilla::StickyTimeDuration,
            pub mFill: root::mozilla::dom::FillMode,
            pub mPhase: root::mozilla::ComputedTiming_AnimationPhase,
            pub mBeforeFlag: root::mozilla::ComputedTimingFunction_BeforeFlag,
        }
        pub const ComputedTiming_AnimationPhase_Idle: root::mozilla::ComputedTiming_AnimationPhase =
            0;
        pub const ComputedTiming_AnimationPhase_Before:
            root::mozilla::ComputedTiming_AnimationPhase = 1;
        pub const ComputedTiming_AnimationPhase_Active:
            root::mozilla::ComputedTiming_AnimationPhase = 2;
        pub const ComputedTiming_AnimationPhase_After:
            root::mozilla::ComputedTiming_AnimationPhase = 3;
        pub type ComputedTiming_AnimationPhase = i32;
        #[test]
        fn bindgen_test_layout_ComputedTiming() {
            assert_eq!(
                ::std::mem::size_of::<ComputedTiming>(),
                88usize,
                concat!("Size of: ", stringify!(ComputedTiming))
            );
            assert_eq!(
                ::std::mem::align_of::<ComputedTiming>(),
                8usize,
                concat!("Alignment of ", stringify!(ComputedTiming))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ComputedTiming>())).mActiveDuration as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ComputedTiming),
                    "::",
                    stringify!(mActiveDuration)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ComputedTiming>())).mActiveTime as *const _ as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ComputedTiming),
                    "::",
                    stringify!(mActiveTime)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<ComputedTiming>())).mEndTime as *const _ as usize },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ComputedTiming),
                    "::",
                    stringify!(mEndTime)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ComputedTiming>())).mProgress as *const _ as usize
                },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ComputedTiming),
                    "::",
                    stringify!(mProgress)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ComputedTiming>())).mCurrentIteration as *const _
                        as usize
                },
                40usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ComputedTiming),
                    "::",
                    stringify!(mCurrentIteration)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ComputedTiming>())).mIterations as *const _ as usize
                },
                48usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ComputedTiming),
                    "::",
                    stringify!(mIterations)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ComputedTiming>())).mIterationStart as *const _ as usize
                },
                56usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ComputedTiming),
                    "::",
                    stringify!(mIterationStart)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ComputedTiming>())).mDuration as *const _ as usize
                },
                64usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ComputedTiming),
                    "::",
                    stringify!(mDuration)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<ComputedTiming>())).mFill as *const _ as usize },
                72usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ComputedTiming),
                    "::",
                    stringify!(mFill)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<ComputedTiming>())).mPhase as *const _ as usize },
                76usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ComputedTiming),
                    "::",
                    stringify!(mPhase)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ComputedTiming>())).mBeforeFlag as *const _ as usize
                },
                80usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ComputedTiming),
                    "::",
                    stringify!(mBeforeFlag)
                )
            );
        }
        impl Clone for ComputedTiming {
            fn clone(&self) -> Self {
                *self
            }
        }
        /// A property-value pair specified on a keyframe.
        #[repr(C)]
        #[derive(Debug)]
        pub struct PropertyValuePair {
            pub mProperty: root::nsCSSPropertyID,
            pub mValue: root::nsCSSValue,
            pub mServoDeclarationBlock: root::RefPtr<root::RawServoDeclarationBlock>,
        }
        #[test]
        fn bindgen_test_layout_PropertyValuePair() {
            assert_eq!(
                ::std::mem::size_of::<PropertyValuePair>(),
                32usize,
                concat!("Size of: ", stringify!(PropertyValuePair))
            );
            assert_eq!(
                ::std::mem::align_of::<PropertyValuePair>(),
                8usize,
                concat!("Alignment of ", stringify!(PropertyValuePair))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<PropertyValuePair>())).mProperty as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(PropertyValuePair),
                    "::",
                    stringify!(mProperty)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<PropertyValuePair>())).mValue as *const _ as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(PropertyValuePair),
                    "::",
                    stringify!(mValue)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<PropertyValuePair>())).mServoDeclarationBlock as *const _
                        as usize
                },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(PropertyValuePair),
                    "::",
                    stringify!(mServoDeclarationBlock)
                )
            );
        }
        /// A single keyframe.
        ///
        /// This is the canonical form in which keyframe effects are stored and
        /// corresponds closely to the type of objects returned via the getKeyframes()
        /// API.
        ///
        /// Before computing an output animation value, however, we flatten these frames
        /// down to a series of per-property value arrays where we also resolve any
        /// overlapping shorthands/longhands, convert specified CSS values to computed
        /// values, etc.
        ///
        /// When the target element or style context changes, however, we rebuild these
        /// per-property arrays from the original list of keyframes objects. As a result,
        /// these objects represent the master definition of the effect's values.
        #[repr(C)]
        #[derive(Debug)]
        pub struct Keyframe {
            pub mOffset: [u64; 2usize],
            pub mComputedOffset: f64,
            pub mTimingFunction: [u64; 18usize],
            pub mComposite: [u8; 2usize],
            pub mPropertyValues: root::nsTArray<root::mozilla::PropertyValuePair>,
        }
        pub const Keyframe_kComputedOffsetNotSet: f64 = -1.;
        #[test]
        fn bindgen_test_layout_Keyframe() {
            assert_eq!(
                ::std::mem::size_of::<Keyframe>(),
                184usize,
                concat!("Size of: ", stringify!(Keyframe))
            );
            assert_eq!(
                ::std::mem::align_of::<Keyframe>(),
                8usize,
                concat!("Alignment of ", stringify!(Keyframe))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<Keyframe>())).mOffset as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Keyframe),
                    "::",
                    stringify!(mOffset)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<Keyframe>())).mComputedOffset as *const _ as usize
                },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Keyframe),
                    "::",
                    stringify!(mComputedOffset)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<Keyframe>())).mTimingFunction as *const _ as usize
                },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Keyframe),
                    "::",
                    stringify!(mTimingFunction)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<Keyframe>())).mComposite as *const _ as usize },
                168usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Keyframe),
                    "::",
                    stringify!(mComposite)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<Keyframe>())).mPropertyValues as *const _ as usize
                },
                176usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Keyframe),
                    "::",
                    stringify!(mPropertyValues)
                )
            );
        }
        /// A structure representing a single attribute name and value.
        ///
        /// This is pretty similar to the private nsAttrAndChildArray::InternalAttr.
        #[repr(C)]
        #[derive(Debug)]
        pub struct ServoAttrSnapshot {
            pub mName: root::nsAttrName,
            pub mValue: root::nsAttrValue,
        }
        #[test]
        fn bindgen_test_layout_ServoAttrSnapshot() {
            assert_eq!(
                ::std::mem::size_of::<ServoAttrSnapshot>(),
                16usize,
                concat!("Size of: ", stringify!(ServoAttrSnapshot))
            );
            assert_eq!(
                ::std::mem::align_of::<ServoAttrSnapshot>(),
                8usize,
                concat!("Alignment of ", stringify!(ServoAttrSnapshot))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<ServoAttrSnapshot>())).mName as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoAttrSnapshot),
                    "::",
                    stringify!(mName)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoAttrSnapshot>())).mValue as *const _ as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoAttrSnapshot),
                    "::",
                    stringify!(mValue)
                )
            );
        }
        #[repr(u8)]
        /// A bitflags enum class used to determine what data does a ServoElementSnapshot
        /// contains.
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum ServoElementSnapshotFlags {
            State = 1,
            Attributes = 2,
            Id = 4,
            MaybeClass = 8,
            OtherPseudoClassState = 16,
        }
        /// This class holds all non-tree-structural state of an element that might be
        /// used for selector matching eventually.
        ///
        /// This means the attributes, and the element state, such as :hover, :active,
        /// etc...
        #[repr(C)]
        #[derive(Debug)]
        pub struct ServoElementSnapshot {
            pub mAttrs: root::nsTArray<root::mozilla::ServoAttrSnapshot>,
            pub mClass: root::nsAttrValue,
            pub mState: root::mozilla::ServoElementSnapshot_ServoStateType,
            pub mContains: root::mozilla::ServoElementSnapshot_Flags,
            pub _bitfield_1: root::__BindgenBitfieldUnit<[u8; 1usize], u8>,
            pub __bindgen_padding_0: [u16; 3usize],
        }
        pub type ServoElementSnapshot_BorrowedAttrInfo = root::mozilla::dom::BorrowedAttrInfo;
        pub type ServoElementSnapshot_Element = root::mozilla::dom::Element;
        pub type ServoElementSnapshot_ServoStateType = root::mozilla::EventStates_ServoType;
        pub use self :: super :: super :: root :: mozilla :: ServoElementSnapshotFlags as ServoElementSnapshot_Flags;
        #[test]
        fn bindgen_test_layout_ServoElementSnapshot() {
            assert_eq!(
                ::std::mem::size_of::<ServoElementSnapshot>(),
                32usize,
                concat!("Size of: ", stringify!(ServoElementSnapshot))
            );
            assert_eq!(
                ::std::mem::align_of::<ServoElementSnapshot>(),
                8usize,
                concat!("Alignment of ", stringify!(ServoElementSnapshot))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoElementSnapshot>())).mAttrs as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoElementSnapshot),
                    "::",
                    stringify!(mAttrs)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoElementSnapshot>())).mClass as *const _ as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoElementSnapshot),
                    "::",
                    stringify!(mClass)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoElementSnapshot>())).mState as *const _ as usize
                },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoElementSnapshot),
                    "::",
                    stringify!(mState)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoElementSnapshot>())).mContains as *const _ as usize
                },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoElementSnapshot),
                    "::",
                    stringify!(mContains)
                )
            );
        }
        impl ServoElementSnapshot {
            #[inline]
            pub fn mIsHTMLElementInHTMLDocument(&self) -> bool {
                unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
            }
            #[inline]
            pub fn set_mIsHTMLElementInHTMLDocument(&mut self, val: bool) {
                unsafe {
                    let val: u8 = ::std::mem::transmute(val);
                    self._bitfield_1.set(0usize, 1u8, val as u64)
                }
            }
            #[inline]
            pub fn mIsInChromeDocument(&self) -> bool {
                unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
            }
            #[inline]
            pub fn set_mIsInChromeDocument(&mut self, val: bool) {
                unsafe {
                    let val: u8 = ::std::mem::transmute(val);
                    self._bitfield_1.set(1usize, 1u8, val as u64)
                }
            }
            #[inline]
            pub fn mSupportsLangAttr(&self) -> bool {
                unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
            }
            #[inline]
            pub fn set_mSupportsLangAttr(&mut self, val: bool) {
                unsafe {
                    let val: u8 = ::std::mem::transmute(val);
                    self._bitfield_1.set(2usize, 1u8, val as u64)
                }
            }
            #[inline]
            pub fn mIsTableBorderNonzero(&self) -> bool {
                unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
            }
            #[inline]
            pub fn set_mIsTableBorderNonzero(&mut self, val: bool) {
                unsafe {
                    let val: u8 = ::std::mem::transmute(val);
                    self._bitfield_1.set(3usize, 1u8, val as u64)
                }
            }
            #[inline]
            pub fn mIsMozBrowserFrame(&self) -> bool {
                unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
            }
            #[inline]
            pub fn set_mIsMozBrowserFrame(&mut self, val: bool) {
                unsafe {
                    let val: u8 = ::std::mem::transmute(val);
                    self._bitfield_1.set(4usize, 1u8, val as u64)
                }
            }
            #[inline]
            pub fn mClassAttributeChanged(&self) -> bool {
                unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
            }
            #[inline]
            pub fn set_mClassAttributeChanged(&mut self, val: bool) {
                unsafe {
                    let val: u8 = ::std::mem::transmute(val);
                    self._bitfield_1.set(5usize, 1u8, val as u64)
                }
            }
            #[inline]
            pub fn mIdAttributeChanged(&self) -> bool {
                unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
            }
            #[inline]
            pub fn set_mIdAttributeChanged(&mut self, val: bool) {
                unsafe {
                    let val: u8 = ::std::mem::transmute(val);
                    self._bitfield_1.set(6usize, 1u8, val as u64)
                }
            }
            #[inline]
            pub fn mOtherAttributeChanged(&self) -> bool {
                unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
            }
            #[inline]
            pub fn set_mOtherAttributeChanged(&mut self, val: bool) {
                unsafe {
                    let val: u8 = ::std::mem::transmute(val);
                    self._bitfield_1.set(7usize, 1u8, val as u64)
                }
            }
            #[inline]
            pub fn new_bitfield_1(
                mIsHTMLElementInHTMLDocument: bool,
                mIsInChromeDocument: bool,
                mSupportsLangAttr: bool,
                mIsTableBorderNonzero: bool,
                mIsMozBrowserFrame: bool,
                mClassAttributeChanged: bool,
                mIdAttributeChanged: bool,
                mOtherAttributeChanged: bool,
            ) -> root::__BindgenBitfieldUnit<[u8; 1usize], u8> {
                let mut __bindgen_bitfield_unit: root::__BindgenBitfieldUnit<
                    [u8; 1usize],
                    u8,
                > = Default::default();
                __bindgen_bitfield_unit.set(0usize, 1u8, {
                    let mIsHTMLElementInHTMLDocument: u8 =
                        unsafe { ::std::mem::transmute(mIsHTMLElementInHTMLDocument) };
                    mIsHTMLElementInHTMLDocument as u64
                });
                __bindgen_bitfield_unit.set(1usize, 1u8, {
                    let mIsInChromeDocument: u8 =
                        unsafe { ::std::mem::transmute(mIsInChromeDocument) };
                    mIsInChromeDocument as u64
                });
                __bindgen_bitfield_unit.set(2usize, 1u8, {
                    let mSupportsLangAttr: u8 = unsafe { ::std::mem::transmute(mSupportsLangAttr) };
                    mSupportsLangAttr as u64
                });
                __bindgen_bitfield_unit.set(3usize, 1u8, {
                    let mIsTableBorderNonzero: u8 =
                        unsafe { ::std::mem::transmute(mIsTableBorderNonzero) };
                    mIsTableBorderNonzero as u64
                });
                __bindgen_bitfield_unit.set(4usize, 1u8, {
                    let mIsMozBrowserFrame: u8 =
                        unsafe { ::std::mem::transmute(mIsMozBrowserFrame) };
                    mIsMozBrowserFrame as u64
                });
                __bindgen_bitfield_unit.set(5usize, 1u8, {
                    let mClassAttributeChanged: u8 =
                        unsafe { ::std::mem::transmute(mClassAttributeChanged) };
                    mClassAttributeChanged as u64
                });
                __bindgen_bitfield_unit.set(6usize, 1u8, {
                    let mIdAttributeChanged: u8 =
                        unsafe { ::std::mem::transmute(mIdAttributeChanged) };
                    mIdAttributeChanged as u64
                });
                __bindgen_bitfield_unit.set(7usize, 1u8, {
                    let mOtherAttributeChanged: u8 =
                        unsafe { ::std::mem::transmute(mOtherAttributeChanged) };
                    mOtherAttributeChanged as u64
                });
                __bindgen_bitfield_unit
            }
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct ServoElementSnapshotTable {
            pub _base: [u64; 4usize],
        }
        #[test]
        fn bindgen_test_layout_ServoElementSnapshotTable() {
            assert_eq!(
                ::std::mem::size_of::<ServoElementSnapshotTable>(),
                32usize,
                concat!("Size of: ", stringify!(ServoElementSnapshotTable))
            );
            assert_eq!(
                ::std::mem::align_of::<ServoElementSnapshotTable>(),
                8usize,
                concat!("Alignment of ", stringify!(ServoElementSnapshotTable))
            );
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct LookAndFeel {
            pub _address: u8,
        }
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum LookAndFeel_ColorID {
            eColorID_WindowBackground = 0,
            eColorID_WindowForeground = 1,
            eColorID_WidgetBackground = 2,
            eColorID_WidgetForeground = 3,
            eColorID_WidgetSelectBackground = 4,
            eColorID_WidgetSelectForeground = 5,
            eColorID_Widget3DHighlight = 6,
            eColorID_Widget3DShadow = 7,
            eColorID_TextBackground = 8,
            eColorID_TextForeground = 9,
            eColorID_TextSelectBackground = 10,
            eColorID_TextSelectForeground = 11,
            eColorID_TextSelectForegroundCustom = 12,
            eColorID_TextSelectBackgroundDisabled = 13,
            eColorID_TextSelectBackgroundAttention = 14,
            eColorID_TextHighlightBackground = 15,
            eColorID_TextHighlightForeground = 16,
            eColorID_IMERawInputBackground = 17,
            eColorID_IMERawInputForeground = 18,
            eColorID_IMERawInputUnderline = 19,
            eColorID_IMESelectedRawTextBackground = 20,
            eColorID_IMESelectedRawTextForeground = 21,
            eColorID_IMESelectedRawTextUnderline = 22,
            eColorID_IMEConvertedTextBackground = 23,
            eColorID_IMEConvertedTextForeground = 24,
            eColorID_IMEConvertedTextUnderline = 25,
            eColorID_IMESelectedConvertedTextBackground = 26,
            eColorID_IMESelectedConvertedTextForeground = 27,
            eColorID_IMESelectedConvertedTextUnderline = 28,
            eColorID_SpellCheckerUnderline = 29,
            eColorID_activeborder = 30,
            eColorID_activecaption = 31,
            eColorID_appworkspace = 32,
            eColorID_background = 33,
            eColorID_buttonface = 34,
            eColorID_buttonhighlight = 35,
            eColorID_buttonshadow = 36,
            eColorID_buttontext = 37,
            eColorID_captiontext = 38,
            eColorID_graytext = 39,
            eColorID_highlight = 40,
            eColorID_highlighttext = 41,
            eColorID_inactiveborder = 42,
            eColorID_inactivecaption = 43,
            eColorID_inactivecaptiontext = 44,
            eColorID_infobackground = 45,
            eColorID_infotext = 46,
            eColorID_menu = 47,
            eColorID_menutext = 48,
            eColorID_scrollbar = 49,
            eColorID_threeddarkshadow = 50,
            eColorID_threedface = 51,
            eColorID_threedhighlight = 52,
            eColorID_threedlightshadow = 53,
            eColorID_threedshadow = 54,
            eColorID_window = 55,
            eColorID_windowframe = 56,
            eColorID_windowtext = 57,
            eColorID__moz_buttondefault = 58,
            eColorID__moz_field = 59,
            eColorID__moz_fieldtext = 60,
            eColorID__moz_dialog = 61,
            eColorID__moz_dialogtext = 62,
            eColorID__moz_dragtargetzone = 63,
            eColorID__moz_cellhighlight = 64,
            eColorID__moz_cellhighlighttext = 65,
            eColorID__moz_html_cellhighlight = 66,
            eColorID__moz_html_cellhighlighttext = 67,
            eColorID__moz_buttonhoverface = 68,
            eColorID__moz_buttonhovertext = 69,
            eColorID__moz_menuhover = 70,
            eColorID__moz_menuhovertext = 71,
            eColorID__moz_menubartext = 72,
            eColorID__moz_menubarhovertext = 73,
            eColorID__moz_eventreerow = 74,
            eColorID__moz_oddtreerow = 75,
            eColorID__moz_mac_buttonactivetext = 76,
            eColorID__moz_mac_chrome_active = 77,
            eColorID__moz_mac_chrome_inactive = 78,
            eColorID__moz_mac_defaultbuttontext = 79,
            eColorID__moz_mac_focusring = 80,
            eColorID__moz_mac_menuselect = 81,
            eColorID__moz_mac_menushadow = 82,
            eColorID__moz_mac_menutextdisable = 83,
            eColorID__moz_mac_menutextselect = 84,
            eColorID__moz_mac_disabledtoolbartext = 85,
            eColorID__moz_mac_secondaryhighlight = 86,
            eColorID__moz_mac_vibrancy_light = 87,
            eColorID__moz_mac_vibrancy_dark = 88,
            eColorID__moz_mac_vibrant_titlebar_light = 89,
            eColorID__moz_mac_vibrant_titlebar_dark = 90,
            eColorID__moz_mac_menupopup = 91,
            eColorID__moz_mac_menuitem = 92,
            eColorID__moz_mac_active_menuitem = 93,
            eColorID__moz_mac_source_list = 94,
            eColorID__moz_mac_source_list_selection = 95,
            eColorID__moz_mac_active_source_list_selection = 96,
            eColorID__moz_mac_tooltip = 97,
            eColorID__moz_win_accentcolor = 98,
            eColorID__moz_win_accentcolortext = 99,
            eColorID__moz_win_mediatext = 100,
            eColorID__moz_win_communicationstext = 101,
            eColorID__moz_nativehyperlinktext = 102,
            eColorID__moz_comboboxtext = 103,
            eColorID__moz_combobox = 104,
            eColorID__moz_gtk_info_bar_text = 105,
            eColorID_LAST_COLOR = 106,
        }
        pub const LookAndFeel_IntID_eIntID_CaretBlinkTime: root::mozilla::LookAndFeel_IntID = 0;
        pub const LookAndFeel_IntID_eIntID_CaretWidth: root::mozilla::LookAndFeel_IntID = 1;
        pub const LookAndFeel_IntID_eIntID_ShowCaretDuringSelection:
            root::mozilla::LookAndFeel_IntID = 2;
        pub const LookAndFeel_IntID_eIntID_SelectTextfieldsOnKeyFocus:
            root::mozilla::LookAndFeel_IntID = 3;
        pub const LookAndFeel_IntID_eIntID_SubmenuDelay: root::mozilla::LookAndFeel_IntID = 4;
        pub const LookAndFeel_IntID_eIntID_MenusCanOverlapOSBar: root::mozilla::LookAndFeel_IntID =
            5;
        pub const LookAndFeel_IntID_eIntID_UseOverlayScrollbars: root::mozilla::LookAndFeel_IntID =
            6;
        pub const LookAndFeel_IntID_eIntID_AllowOverlayScrollbarsOverlap:
            root::mozilla::LookAndFeel_IntID = 7;
        pub const LookAndFeel_IntID_eIntID_ShowHideScrollbars: root::mozilla::LookAndFeel_IntID = 8;
        pub const LookAndFeel_IntID_eIntID_SkipNavigatingDisabledMenuItem:
            root::mozilla::LookAndFeel_IntID = 9;
        pub const LookAndFeel_IntID_eIntID_DragThresholdX: root::mozilla::LookAndFeel_IntID = 10;
        pub const LookAndFeel_IntID_eIntID_DragThresholdY: root::mozilla::LookAndFeel_IntID = 11;
        pub const LookAndFeel_IntID_eIntID_UseAccessibilityTheme: root::mozilla::LookAndFeel_IntID =
            12;
        pub const LookAndFeel_IntID_eIntID_ScrollArrowStyle: root::mozilla::LookAndFeel_IntID = 13;
        pub const LookAndFeel_IntID_eIntID_ScrollSliderStyle: root::mozilla::LookAndFeel_IntID = 14;
        pub const LookAndFeel_IntID_eIntID_ScrollButtonLeftMouseButtonAction:
            root::mozilla::LookAndFeel_IntID = 15;
        pub const LookAndFeel_IntID_eIntID_ScrollButtonMiddleMouseButtonAction:
            root::mozilla::LookAndFeel_IntID = 16;
        pub const LookAndFeel_IntID_eIntID_ScrollButtonRightMouseButtonAction:
            root::mozilla::LookAndFeel_IntID = 17;
        pub const LookAndFeel_IntID_eIntID_TreeOpenDelay: root::mozilla::LookAndFeel_IntID = 18;
        pub const LookAndFeel_IntID_eIntID_TreeCloseDelay: root::mozilla::LookAndFeel_IntID = 19;
        pub const LookAndFeel_IntID_eIntID_TreeLazyScrollDelay: root::mozilla::LookAndFeel_IntID =
            20;
        pub const LookAndFeel_IntID_eIntID_TreeScrollDelay: root::mozilla::LookAndFeel_IntID = 21;
        pub const LookAndFeel_IntID_eIntID_TreeScrollLinesMax: root::mozilla::LookAndFeel_IntID =
            22;
        pub const LookAndFeel_IntID_eIntID_TabFocusModel: root::mozilla::LookAndFeel_IntID = 23;
        pub const LookAndFeel_IntID_eIntID_ChosenMenuItemsShouldBlink:
            root::mozilla::LookAndFeel_IntID = 24;
        pub const LookAndFeel_IntID_eIntID_WindowsAccentColorInTitlebar:
            root::mozilla::LookAndFeel_IntID = 25;
        pub const LookAndFeel_IntID_eIntID_WindowsDefaultTheme: root::mozilla::LookAndFeel_IntID =
            26;
        pub const LookAndFeel_IntID_eIntID_DWMCompositor: root::mozilla::LookAndFeel_IntID = 27;
        pub const LookAndFeel_IntID_eIntID_WindowsClassic: root::mozilla::LookAndFeel_IntID = 28;
        pub const LookAndFeel_IntID_eIntID_WindowsGlass: root::mozilla::LookAndFeel_IntID = 29;
        pub const LookAndFeel_IntID_eIntID_TouchEnabled: root::mozilla::LookAndFeel_IntID = 30;
        pub const LookAndFeel_IntID_eIntID_MacGraphiteTheme: root::mozilla::LookAndFeel_IntID = 31;
        pub const LookAndFeel_IntID_eIntID_MacYosemiteTheme: root::mozilla::LookAndFeel_IntID = 32;
        pub const LookAndFeel_IntID_eIntID_AlertNotificationOrigin:
            root::mozilla::LookAndFeel_IntID = 33;
        /// If true, clicking on a scrollbar (not as in dragging the thumb) defaults
        /// to scrolling the view corresponding to the clicked point. Otherwise, we
        /// only do so if the scrollbar is clicked using the middle mouse button or
        /// if shift is pressed when the scrollbar is clicked.
        pub const LookAndFeel_IntID_eIntID_ScrollToClick: root::mozilla::LookAndFeel_IntID = 34;
        /// IME and spell checker underline styles, the values should be
        /// NS_DECORATION_LINE_STYLE_*.  They are defined below.
        pub const LookAndFeel_IntID_eIntID_IMERawInputUnderlineStyle:
            root::mozilla::LookAndFeel_IntID = 35;
        /// IME and spell checker underline styles, the values should be
        /// NS_DECORATION_LINE_STYLE_*.  They are defined below.
        pub const LookAndFeel_IntID_eIntID_IMESelectedRawTextUnderlineStyle:
            root::mozilla::LookAndFeel_IntID = 36;
        /// IME and spell checker underline styles, the values should be
        /// NS_DECORATION_LINE_STYLE_*.  They are defined below.
        pub const LookAndFeel_IntID_eIntID_IMEConvertedTextUnderlineStyle:
            root::mozilla::LookAndFeel_IntID = 37;
        /// IME and spell checker underline styles, the values should be
        /// NS_DECORATION_LINE_STYLE_*.  They are defined below.
        pub const LookAndFeel_IntID_eIntID_IMESelectedConvertedTextUnderline:
            root::mozilla::LookAndFeel_IntID = 38;
        /// IME and spell checker underline styles, the values should be
        /// NS_DECORATION_LINE_STYLE_*.  They are defined below.
        pub const LookAndFeel_IntID_eIntID_SpellCheckerUnderlineStyle:
            root::mozilla::LookAndFeel_IntID = 39;
        /// If this metric != 0, support window dragging on the menubar.
        pub const LookAndFeel_IntID_eIntID_MenuBarDrag: root::mozilla::LookAndFeel_IntID = 40;
        /// Return the appropriate WindowsThemeIdentifier for the current theme.
        pub const LookAndFeel_IntID_eIntID_WindowsThemeIdentifier:
            root::mozilla::LookAndFeel_IntID = 41;
        /// Return an appropriate os version identifier.
        pub const LookAndFeel_IntID_eIntID_OperatingSystemVersionIdentifier:
            root::mozilla::LookAndFeel_IntID = 42;
        /// 0: scrollbar button repeats to scroll only when cursor is on the button.
        /// 1: scrollbar button repeats to scroll even if cursor is outside of it.
        pub const LookAndFeel_IntID_eIntID_ScrollbarButtonAutoRepeatBehavior:
            root::mozilla::LookAndFeel_IntID = 43;
        /// Delay before showing a tooltip.
        pub const LookAndFeel_IntID_eIntID_TooltipDelay: root::mozilla::LookAndFeel_IntID = 44;
        /// Delay before showing a tooltip.
        pub const LookAndFeel_IntID_eIntID_SwipeAnimationEnabled: root::mozilla::LookAndFeel_IntID =
            45;
        /// Delay before showing a tooltip.
        pub const LookAndFeel_IntID_eIntID_ScrollbarDisplayOnMouseMove:
            root::mozilla::LookAndFeel_IntID = 46;
        /// Delay before showing a tooltip.
        pub const LookAndFeel_IntID_eIntID_ScrollbarFadeBeginDelay:
            root::mozilla::LookAndFeel_IntID = 47;
        /// Delay before showing a tooltip.
        pub const LookAndFeel_IntID_eIntID_ScrollbarFadeDuration: root::mozilla::LookAndFeel_IntID =
            48;
        /// Distance in pixels to offset the context menu from the cursor
        /// on open.
        pub const LookAndFeel_IntID_eIntID_ContextMenuOffsetVertical:
            root::mozilla::LookAndFeel_IntID = 49;
        /// Distance in pixels to offset the context menu from the cursor
        /// on open.
        pub const LookAndFeel_IntID_eIntID_ContextMenuOffsetHorizontal:
            root::mozilla::LookAndFeel_IntID = 50;
        /// Distance in pixels to offset the context menu from the cursor
        /// on open.
        pub const LookAndFeel_IntID_eIntID_GTKCSDAvailable: root::mozilla::LookAndFeel_IntID = 51;
        /// Distance in pixels to offset the context menu from the cursor
        /// on open.
        pub const LookAndFeel_IntID_eIntID_GTKCSDMinimizeButton: root::mozilla::LookAndFeel_IntID =
            52;
        /// Distance in pixels to offset the context menu from the cursor
        /// on open.
        pub const LookAndFeel_IntID_eIntID_GTKCSDMaximizeButton: root::mozilla::LookAndFeel_IntID =
            53;
        /// Distance in pixels to offset the context menu from the cursor
        /// on open.
        pub const LookAndFeel_IntID_eIntID_GTKCSDCloseButton: root::mozilla::LookAndFeel_IntID = 54;
        pub type LookAndFeel_IntID = u32;
        pub const LookAndFeel_WindowsTheme_eWindowsTheme_Generic:
            root::mozilla::LookAndFeel_WindowsTheme = 0;
        pub const LookAndFeel_WindowsTheme_eWindowsTheme_Classic:
            root::mozilla::LookAndFeel_WindowsTheme = 1;
        pub const LookAndFeel_WindowsTheme_eWindowsTheme_Aero:
            root::mozilla::LookAndFeel_WindowsTheme = 2;
        pub const LookAndFeel_WindowsTheme_eWindowsTheme_LunaBlue:
            root::mozilla::LookAndFeel_WindowsTheme = 3;
        pub const LookAndFeel_WindowsTheme_eWindowsTheme_LunaOlive:
            root::mozilla::LookAndFeel_WindowsTheme = 4;
        pub const LookAndFeel_WindowsTheme_eWindowsTheme_LunaSilver:
            root::mozilla::LookAndFeel_WindowsTheme = 5;
        pub const LookAndFeel_WindowsTheme_eWindowsTheme_Royale:
            root::mozilla::LookAndFeel_WindowsTheme = 6;
        pub const LookAndFeel_WindowsTheme_eWindowsTheme_Zune:
            root::mozilla::LookAndFeel_WindowsTheme = 7;
        pub const LookAndFeel_WindowsTheme_eWindowsTheme_AeroLite:
            root::mozilla::LookAndFeel_WindowsTheme = 8;
        /// Windows themes we currently detect.
        pub type LookAndFeel_WindowsTheme = u32;
        pub const LookAndFeel_OperatingSystemVersion_eOperatingSystemVersion_Windows7:
            root::mozilla::LookAndFeel_OperatingSystemVersion = 2;
        pub const LookAndFeel_OperatingSystemVersion_eOperatingSystemVersion_Windows8:
            root::mozilla::LookAndFeel_OperatingSystemVersion = 3;
        pub const LookAndFeel_OperatingSystemVersion_eOperatingSystemVersion_Windows10:
            root::mozilla::LookAndFeel_OperatingSystemVersion = 4;
        pub const LookAndFeel_OperatingSystemVersion_eOperatingSystemVersion_Unknown:
            root::mozilla::LookAndFeel_OperatingSystemVersion = 5;
        /// Operating system versions.
        pub type LookAndFeel_OperatingSystemVersion = u32;
        pub const LookAndFeel_eScrollArrow_None: root::mozilla::LookAndFeel__bindgen_ty_1 = 0;
        pub const LookAndFeel_eScrollArrow_StartBackward: root::mozilla::LookAndFeel__bindgen_ty_1 =
            4096;
        pub const LookAndFeel_eScrollArrow_StartForward: root::mozilla::LookAndFeel__bindgen_ty_1 =
            256;
        pub const LookAndFeel_eScrollArrow_EndBackward: root::mozilla::LookAndFeel__bindgen_ty_1 =
            16;
        pub const LookAndFeel_eScrollArrow_EndForward: root::mozilla::LookAndFeel__bindgen_ty_1 = 1;
        pub type LookAndFeel__bindgen_ty_1 = u32;
        pub const LookAndFeel_eScrollArrowStyle_Single: root::mozilla::LookAndFeel__bindgen_ty_2 =
            4097;
        pub const LookAndFeel_eScrollArrowStyle_BothAtBottom:
            root::mozilla::LookAndFeel__bindgen_ty_2 = 17;
        pub const LookAndFeel_eScrollArrowStyle_BothAtEachEnd:
            root::mozilla::LookAndFeel__bindgen_ty_2 = 4369;
        pub const LookAndFeel_eScrollArrowStyle_BothAtTop:
            root::mozilla::LookAndFeel__bindgen_ty_2 = 4352;
        pub type LookAndFeel__bindgen_ty_2 = u32;
        pub const LookAndFeel_eScrollThumbStyle_Normal: root::mozilla::LookAndFeel__bindgen_ty_3 =
            0;
        pub const LookAndFeel_eScrollThumbStyle_Proportional:
            root::mozilla::LookAndFeel__bindgen_ty_3 = 1;
        pub type LookAndFeel__bindgen_ty_3 = u32;
        pub const LookAndFeel_FloatID_eFloatID_IMEUnderlineRelativeSize:
            root::mozilla::LookAndFeel_FloatID = 0;
        pub const LookAndFeel_FloatID_eFloatID_SpellCheckerUnderlineRelativeSize:
            root::mozilla::LookAndFeel_FloatID = 1;
        pub const LookAndFeel_FloatID_eFloatID_CaretAspectRatio:
            root::mozilla::LookAndFeel_FloatID = 2;
        pub type LookAndFeel_FloatID = u32;
        pub const LookAndFeel_FontID_FontID_MINIMUM: root::mozilla::LookAndFeel_FontID =
            LookAndFeel_FontID::eFont_Caption;
        pub const LookAndFeel_FontID_FontID_MAXIMUM: root::mozilla::LookAndFeel_FontID =
            LookAndFeel_FontID::eFont_Widget;
        #[repr(u32)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum LookAndFeel_FontID {
            eFont_Caption = 1,
            eFont_Icon = 2,
            eFont_Menu = 3,
            eFont_MessageBox = 4,
            eFont_SmallCaption = 5,
            eFont_StatusBar = 6,
            eFont_Window = 7,
            eFont_Document = 8,
            eFont_Workspace = 9,
            eFont_Desktop = 10,
            eFont_Info = 11,
            eFont_Dialog = 12,
            eFont_Button = 13,
            eFont_PullDownMenu = 14,
            eFont_List = 15,
            eFont_Field = 16,
            eFont_Tooltips = 17,
            eFont_Widget = 18,
        }
        #[test]
        fn bindgen_test_layout_LookAndFeel() {
            assert_eq!(
                ::std::mem::size_of::<LookAndFeel>(),
                1usize,
                concat!("Size of: ", stringify!(LookAndFeel))
            );
            assert_eq!(
                ::std::mem::align_of::<LookAndFeel>(),
                1usize,
                concat!("Alignment of ", stringify!(LookAndFeel))
            );
        }
        impl Clone for LookAndFeel {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct StylePrefs {
            pub _address: u8,
        }
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla10StylePrefs19sFontDisplayEnabledE"]
            pub static mut StylePrefs_sFontDisplayEnabled: bool;
        }
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla10StylePrefs19sOpentypeSVGEnabledE"]
            pub static mut StylePrefs_sOpentypeSVGEnabled: bool;
        }
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla10StylePrefs29sWebkitPrefixedAliasesEnabledE"]
            pub static mut StylePrefs_sWebkitPrefixedAliasesEnabled: bool;
        }
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla10StylePrefs30sWebkitDevicePixelRatioEnabledE"]
            pub static mut StylePrefs_sWebkitDevicePixelRatioEnabled: bool;
        }
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla10StylePrefs20sMozGradientsEnabledE"]
            pub static mut StylePrefs_sMozGradientsEnabled: bool;
        }
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla10StylePrefs22sControlCharVisibilityE"]
            pub static mut StylePrefs_sControlCharVisibility: bool;
        }
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla10StylePrefs28sFramesTimingFunctionEnabledE"]
            pub static mut StylePrefs_sFramesTimingFunctionEnabled: bool;
        }
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla10StylePrefs31sUnprefixedFullscreenApiEnabledE"]
            pub static mut StylePrefs_sUnprefixedFullscreenApiEnabled: bool;
        }
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla10StylePrefs20sVisitedLinksEnabledE"]
            pub static mut StylePrefs_sVisitedLinksEnabled: bool;
        }
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla10StylePrefs28sMozDocumentEnabledInContentE"]
            pub static mut StylePrefs_sMozDocumentEnabledInContent: bool;
        }
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla10StylePrefs32sGridTemplateSubgridValueEnabledE"]
            pub static mut StylePrefs_sGridTemplateSubgridValueEnabled: bool;
        }
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla10StylePrefs22sFontVariationsEnabledE"]
            pub static mut StylePrefs_sFontVariationsEnabled: bool;
        }
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla10StylePrefs22sEmulateMozBoxWithFlexE"]
            pub static mut StylePrefs_sEmulateMozBoxWithFlex: bool;
        }
        #[test]
        fn bindgen_test_layout_StylePrefs() {
            assert_eq!(
                ::std::mem::size_of::<StylePrefs>(),
                1usize,
                concat!("Size of: ", stringify!(StylePrefs))
            );
            assert_eq!(
                ::std::mem::align_of::<StylePrefs>(),
                1usize,
                concat!("Alignment of ", stringify!(StylePrefs))
            );
        }
        impl Clone for StylePrefs {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct NonOwningAnimationTarget {
            pub mElement: *mut root::mozilla::dom::Element,
            pub mPseudoType: root::mozilla::CSSPseudoElementType,
        }
        #[test]
        fn bindgen_test_layout_NonOwningAnimationTarget() {
            assert_eq!(
                ::std::mem::size_of::<NonOwningAnimationTarget>(),
                16usize,
                concat!("Size of: ", stringify!(NonOwningAnimationTarget))
            );
            assert_eq!(
                ::std::mem::align_of::<NonOwningAnimationTarget>(),
                8usize,
                concat!("Alignment of ", stringify!(NonOwningAnimationTarget))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<NonOwningAnimationTarget>())).mElement as *const _
                        as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(NonOwningAnimationTarget),
                    "::",
                    stringify!(mElement)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<NonOwningAnimationTarget>())).mPseudoType as *const _
                        as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(NonOwningAnimationTarget),
                    "::",
                    stringify!(mPseudoType)
                )
            );
        }
        impl Clone for NonOwningAnimationTarget {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        pub struct PseudoElementHashEntry {
            pub _base: root::PLDHashEntryHdr,
            pub mElement: root::RefPtr<root::mozilla::dom::Element>,
            pub mPseudoType: root::mozilla::CSSPseudoElementType,
        }
        pub type PseudoElementHashEntry_KeyType = root::mozilla::NonOwningAnimationTarget;
        pub type PseudoElementHashEntry_KeyTypePointer =
            *const root::mozilla::NonOwningAnimationTarget;
        pub const PseudoElementHashEntry_ALLOW_MEMMOVE:
            root::mozilla::PseudoElementHashEntry__bindgen_ty_1 = 1;
        pub type PseudoElementHashEntry__bindgen_ty_1 = u32;
        #[test]
        fn bindgen_test_layout_PseudoElementHashEntry() {
            assert_eq!(
                ::std::mem::size_of::<PseudoElementHashEntry>(),
                24usize,
                concat!("Size of: ", stringify!(PseudoElementHashEntry))
            );
            assert_eq!(
                ::std::mem::align_of::<PseudoElementHashEntry>(),
                8usize,
                concat!("Alignment of ", stringify!(PseudoElementHashEntry))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<PseudoElementHashEntry>())).mElement as *const _ as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(PseudoElementHashEntry),
                    "::",
                    stringify!(mElement)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<PseudoElementHashEntry>())).mPseudoType as *const _
                        as usize
                },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(PseudoElementHashEntry),
                    "::",
                    stringify!(mPseudoType)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct EffectCompositor {
            pub mRefCnt: root::nsCycleCollectingAutoRefCnt,
            pub mPresContext: *mut root::nsPresContext,
            pub mElementsToRestyle: [u64; 8usize],
            pub mIsInPreTraverse: bool,
            pub mRuleProcessors: [u64; 2usize],
        }
        pub type EffectCompositor_HasThreadSafeRefCnt = root::mozilla::FalseType;
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct EffectCompositor_cycleCollection {
            pub _base: root::nsCycleCollectionParticipant,
        }
        #[test]
        fn bindgen_test_layout_EffectCompositor_cycleCollection() {
            assert_eq!(
                ::std::mem::size_of::<EffectCompositor_cycleCollection>(),
                16usize,
                concat!("Size of: ", stringify!(EffectCompositor_cycleCollection))
            );
            assert_eq!(
                ::std::mem::align_of::<EffectCompositor_cycleCollection>(),
                8usize,
                concat!(
                    "Alignment of ",
                    stringify!(EffectCompositor_cycleCollection)
                )
            );
        }
        impl Clone for EffectCompositor_cycleCollection {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(u32)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum EffectCompositor_CascadeLevel {
            Animations = 0,
            Transitions = 1,
        }
        pub const EffectCompositor_RestyleType_Throttled:
            root::mozilla::EffectCompositor_RestyleType = 0;
        pub const EffectCompositor_RestyleType_Standard:
            root::mozilla::EffectCompositor_RestyleType = 1;
        pub const EffectCompositor_RestyleType_Layer: root::mozilla::EffectCompositor_RestyleType =
            2;
        pub type EffectCompositor_RestyleType = i32;
        #[repr(C)]
        #[derive(Debug)]
        pub struct EffectCompositor_AnimationStyleRuleProcessor {
            pub _base: root::nsIStyleRuleProcessor,
            pub mRefCnt: root::nsAutoRefCnt,
            pub mCompositor: *mut root::mozilla::EffectCompositor,
            pub mCascadeLevel: root::mozilla::EffectCompositor_CascadeLevel,
        }
        pub type EffectCompositor_AnimationStyleRuleProcessor_HasThreadSafeRefCnt =
            root::mozilla::FalseType;
        #[test]
        fn bindgen_test_layout_EffectCompositor_AnimationStyleRuleProcessor() {
            assert_eq!(
                ::std::mem::size_of::<EffectCompositor_AnimationStyleRuleProcessor>(),
                32usize,
                concat!(
                    "Size of: ",
                    stringify!(EffectCompositor_AnimationStyleRuleProcessor)
                )
            );
            assert_eq!(
                ::std::mem::align_of::<EffectCompositor_AnimationStyleRuleProcessor>(),
                8usize,
                concat!(
                    "Alignment of ",
                    stringify!(EffectCompositor_AnimationStyleRuleProcessor)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<EffectCompositor_AnimationStyleRuleProcessor>())).mRefCnt
                        as *const _ as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(EffectCompositor_AnimationStyleRuleProcessor),
                    "::",
                    stringify!(mRefCnt)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<EffectCompositor_AnimationStyleRuleProcessor>()))
                        .mCompositor as *const _ as usize
                },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(EffectCompositor_AnimationStyleRuleProcessor),
                    "::",
                    stringify!(mCompositor)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<EffectCompositor_AnimationStyleRuleProcessor>()))
                        .mCascadeLevel as *const _ as usize
                },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(EffectCompositor_AnimationStyleRuleProcessor),
                    "::",
                    stringify!(mCascadeLevel)
                )
            );
        }
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla16EffectCompositor21_cycleCollectorGlobalE"]
            pub static mut EffectCompositor__cycleCollectorGlobal:
                root::mozilla::EffectCompositor_cycleCollection;
        }
        pub const EffectCompositor_kCascadeLevelCount: usize = 2;
        #[test]
        fn bindgen_test_layout_EffectCompositor() {
            assert_eq!(
                ::std::mem::size_of::<EffectCompositor>(),
                104usize,
                concat!("Size of: ", stringify!(EffectCompositor))
            );
            assert_eq!(
                ::std::mem::align_of::<EffectCompositor>(),
                8usize,
                concat!("Alignment of ", stringify!(EffectCompositor))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<EffectCompositor>())).mRefCnt as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(EffectCompositor),
                    "::",
                    stringify!(mRefCnt)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<EffectCompositor>())).mPresContext as *const _ as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(EffectCompositor),
                    "::",
                    stringify!(mPresContext)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<EffectCompositor>())).mElementsToRestyle as *const _
                        as usize
                },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(EffectCompositor),
                    "::",
                    stringify!(mElementsToRestyle)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<EffectCompositor>())).mIsInPreTraverse as *const _
                        as usize
                },
                80usize,
                concat!(
                    "Offset of field: ",
                    stringify!(EffectCompositor),
                    "::",
                    stringify!(mIsInPreTraverse)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<EffectCompositor>())).mRuleProcessors as *const _
                        as usize
                },
                88usize,
                concat!(
                    "Offset of field: ",
                    stringify!(EffectCompositor),
                    "::",
                    stringify!(mRuleProcessors)
                )
            );
        }
        pub type CSSPseudoClassTypeBase = u8;
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum CSSPseudoClassType {
            empty = 0,
            mozOnlyWhitespace = 1,
            lang = 2,
            root = 3,
            any = 4,
            firstChild = 5,
            firstNode = 6,
            lastChild = 7,
            lastNode = 8,
            onlyChild = 9,
            firstOfType = 10,
            lastOfType = 11,
            onlyOfType = 12,
            nthChild = 13,
            nthLastChild = 14,
            nthOfType = 15,
            nthLastOfType = 16,
            mozIsHTML = 17,
            mozNativeAnonymous = 18,
            mozUseShadowTreeRoot = 19,
            mozLocaleDir = 20,
            mozLWTheme = 21,
            mozLWThemeBrightText = 22,
            mozLWThemeDarkText = 23,
            mozWindowInactive = 24,
            mozTableBorderNonzero = 25,
            mozBrowserFrame = 26,
            scope = 27,
            negation = 28,
            dir = 29,
            link = 30,
            mozAnyLink = 31,
            anyLink = 32,
            visited = 33,
            active = 34,
            checked = 35,
            disabled = 36,
            enabled = 37,
            focus = 38,
            focusWithin = 39,
            hover = 40,
            mozDragOver = 41,
            target = 42,
            indeterminate = 43,
            mozDevtoolsHighlighted = 44,
            mozStyleeditorTransitioning = 45,
            fullscreen = 46,
            mozFullScreen = 47,
            mozFocusRing = 48,
            mozBroken = 49,
            mozLoading = 50,
            mozUserDisabled = 51,
            mozSuppressed = 52,
            mozHandlerClickToPlay = 53,
            mozHandlerVulnerableUpdatable = 54,
            mozHandlerVulnerableNoUpdate = 55,
            mozHandlerDisabled = 56,
            mozHandlerBlocked = 57,
            mozHandlerCrashed = 58,
            mozMathIncrementScriptLevel = 59,
            mozHasDirAttr = 60,
            mozDirAttrLTR = 61,
            mozDirAttrRTL = 62,
            mozDirAttrLikeAuto = 63,
            mozAutofill = 64,
            mozAutofillPreview = 65,
            required = 66,
            optional = 67,
            valid = 68,
            invalid = 69,
            inRange = 70,
            outOfRange = 71,
            defaultPseudo = 72,
            placeholderShown = 73,
            mozReadOnly = 74,
            mozReadWrite = 75,
            mozSubmitInvalid = 76,
            mozUIInvalid = 77,
            mozUIValid = 78,
            mozMeterOptimum = 79,
            mozMeterSubOptimum = 80,
            mozMeterSubSubOptimum = 81,
            mozPlaceholder = 82,
            Count = 83,
            NotPseudo = 84,
            MAX = 85,
        }
        #[repr(C)]
        pub struct GeckoFont {
            pub gecko: root::nsStyleFont,
        }
        #[test]
        fn bindgen_test_layout_GeckoFont() {
            assert_eq!(
                ::std::mem::size_of::<GeckoFont>(),
                136usize,
                concat!("Size of: ", stringify!(GeckoFont))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoFont>(),
                8usize,
                concat!("Alignment of ", stringify!(GeckoFont))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoFont>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoFont),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct GeckoColor {
            pub gecko: root::nsStyleColor,
        }
        #[test]
        fn bindgen_test_layout_GeckoColor() {
            assert_eq!(
                ::std::mem::size_of::<GeckoColor>(),
                4usize,
                concat!("Size of: ", stringify!(GeckoColor))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoColor>(),
                4usize,
                concat!("Alignment of ", stringify!(GeckoColor))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoColor>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoColor),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        pub struct GeckoList {
            pub gecko: root::nsStyleList,
        }
        #[test]
        fn bindgen_test_layout_GeckoList() {
            assert_eq!(
                ::std::mem::size_of::<GeckoList>(),
                48usize,
                concat!("Size of: ", stringify!(GeckoList))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoList>(),
                8usize,
                concat!("Alignment of ", stringify!(GeckoList))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoList>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoList),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        pub struct GeckoText {
            pub gecko: root::nsStyleText,
        }
        #[test]
        fn bindgen_test_layout_GeckoText() {
            assert_eq!(
                ::std::mem::size_of::<GeckoText>(),
                160usize,
                concat!("Size of: ", stringify!(GeckoText))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoText>(),
                8usize,
                concat!("Alignment of ", stringify!(GeckoText))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoText>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoText),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct GeckoVisibility {
            pub gecko: root::nsStyleVisibility,
        }
        #[test]
        fn bindgen_test_layout_GeckoVisibility() {
            assert_eq!(
                ::std::mem::size_of::<GeckoVisibility>(),
                7usize,
                concat!("Size of: ", stringify!(GeckoVisibility))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoVisibility>(),
                1usize,
                concat!("Alignment of ", stringify!(GeckoVisibility))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoVisibility>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoVisibility),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct GeckoUserInterface {
            pub gecko: root::nsStyleUserInterface,
        }
        #[test]
        fn bindgen_test_layout_GeckoUserInterface() {
            assert_eq!(
                ::std::mem::size_of::<GeckoUserInterface>(),
                24usize,
                concat!("Size of: ", stringify!(GeckoUserInterface))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoUserInterface>(),
                8usize,
                concat!("Alignment of ", stringify!(GeckoUserInterface))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<GeckoUserInterface>())).gecko as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoUserInterface),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct GeckoTableBorder {
            pub gecko: root::nsStyleTableBorder,
        }
        #[test]
        fn bindgen_test_layout_GeckoTableBorder() {
            assert_eq!(
                ::std::mem::size_of::<GeckoTableBorder>(),
                12usize,
                concat!("Size of: ", stringify!(GeckoTableBorder))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoTableBorder>(),
                4usize,
                concat!("Alignment of ", stringify!(GeckoTableBorder))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoTableBorder>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoTableBorder),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct GeckoSVG {
            pub gecko: root::nsStyleSVG,
        }
        #[test]
        fn bindgen_test_layout_GeckoSVG() {
            assert_eq!(
                ::std::mem::size_of::<GeckoSVG>(),
                128usize,
                concat!("Size of: ", stringify!(GeckoSVG))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoSVG>(),
                8usize,
                concat!("Alignment of ", stringify!(GeckoSVG))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoSVG>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoSVG),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct GeckoBackground {
            pub gecko: root::nsStyleBackground,
        }
        #[test]
        fn bindgen_test_layout_GeckoBackground() {
            assert_eq!(
                ::std::mem::size_of::<GeckoBackground>(),
                160usize,
                concat!("Size of: ", stringify!(GeckoBackground))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoBackground>(),
                8usize,
                concat!("Alignment of ", stringify!(GeckoBackground))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoBackground>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoBackground),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        pub struct GeckoPosition {
            pub gecko: root::nsStylePosition,
        }
        #[test]
        fn bindgen_test_layout_GeckoPosition() {
            assert_eq!(
                ::std::mem::size_of::<GeckoPosition>(),
                440usize,
                concat!("Size of: ", stringify!(GeckoPosition))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoPosition>(),
                8usize,
                concat!("Alignment of ", stringify!(GeckoPosition))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoPosition>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoPosition),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        pub struct GeckoTextReset {
            pub gecko: root::nsStyleTextReset,
        }
        #[test]
        fn bindgen_test_layout_GeckoTextReset() {
            assert_eq!(
                ::std::mem::size_of::<GeckoTextReset>(),
                80usize,
                concat!("Size of: ", stringify!(GeckoTextReset))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoTextReset>(),
                8usize,
                concat!("Alignment of ", stringify!(GeckoTextReset))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoTextReset>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoTextReset),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct GeckoDisplay {
            pub gecko: root::nsStyleDisplay,
        }
        #[test]
        fn bindgen_test_layout_GeckoDisplay() {
            assert_eq!(
                ::std::mem::size_of::<GeckoDisplay>(),
                456usize,
                concat!("Size of: ", stringify!(GeckoDisplay))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoDisplay>(),
                8usize,
                concat!("Alignment of ", stringify!(GeckoDisplay))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoDisplay>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoDisplay),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        pub struct GeckoContent {
            pub gecko: root::nsStyleContent,
        }
        #[test]
        fn bindgen_test_layout_GeckoContent() {
            assert_eq!(
                ::std::mem::size_of::<GeckoContent>(),
                24usize,
                concat!("Size of: ", stringify!(GeckoContent))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoContent>(),
                8usize,
                concat!("Alignment of ", stringify!(GeckoContent))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoContent>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoContent),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct GeckoUIReset {
            pub gecko: root::nsStyleUIReset,
        }
        #[test]
        fn bindgen_test_layout_GeckoUIReset() {
            assert_eq!(
                ::std::mem::size_of::<GeckoUIReset>(),
                56usize,
                concat!("Size of: ", stringify!(GeckoUIReset))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoUIReset>(),
                8usize,
                concat!("Alignment of ", stringify!(GeckoUIReset))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoUIReset>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoUIReset),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct GeckoTable {
            pub gecko: root::nsStyleTable,
        }
        #[test]
        fn bindgen_test_layout_GeckoTable() {
            assert_eq!(
                ::std::mem::size_of::<GeckoTable>(),
                8usize,
                concat!("Size of: ", stringify!(GeckoTable))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoTable>(),
                4usize,
                concat!("Alignment of ", stringify!(GeckoTable))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoTable>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoTable),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct GeckoMargin {
            pub gecko: root::nsStyleMargin,
        }
        #[test]
        fn bindgen_test_layout_GeckoMargin() {
            assert_eq!(
                ::std::mem::size_of::<GeckoMargin>(),
                40usize,
                concat!("Size of: ", stringify!(GeckoMargin))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoMargin>(),
                8usize,
                concat!("Alignment of ", stringify!(GeckoMargin))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoMargin>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoMargin),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct GeckoPadding {
            pub gecko: root::nsStylePadding,
        }
        #[test]
        fn bindgen_test_layout_GeckoPadding() {
            assert_eq!(
                ::std::mem::size_of::<GeckoPadding>(),
                40usize,
                concat!("Size of: ", stringify!(GeckoPadding))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoPadding>(),
                8usize,
                concat!("Alignment of ", stringify!(GeckoPadding))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoPadding>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoPadding),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct GeckoBorder {
            pub gecko: root::nsStyleBorder,
        }
        #[test]
        fn bindgen_test_layout_GeckoBorder() {
            assert_eq!(
                ::std::mem::size_of::<GeckoBorder>(),
                304usize,
                concat!("Size of: ", stringify!(GeckoBorder))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoBorder>(),
                8usize,
                concat!("Alignment of ", stringify!(GeckoBorder))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoBorder>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoBorder),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct GeckoOutline {
            pub gecko: root::nsStyleOutline,
        }
        #[test]
        fn bindgen_test_layout_GeckoOutline() {
            assert_eq!(
                ::std::mem::size_of::<GeckoOutline>(),
                104usize,
                concat!("Size of: ", stringify!(GeckoOutline))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoOutline>(),
                8usize,
                concat!("Alignment of ", stringify!(GeckoOutline))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoOutline>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoOutline),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct GeckoXUL {
            pub gecko: root::nsStyleXUL,
        }
        #[test]
        fn bindgen_test_layout_GeckoXUL() {
            assert_eq!(
                ::std::mem::size_of::<GeckoXUL>(),
                16usize,
                concat!("Size of: ", stringify!(GeckoXUL))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoXUL>(),
                4usize,
                concat!("Alignment of ", stringify!(GeckoXUL))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoXUL>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoXUL),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct GeckoSVGReset {
            pub gecko: root::nsStyleSVGReset,
        }
        #[test]
        fn bindgen_test_layout_GeckoSVGReset() {
            assert_eq!(
                ::std::mem::size_of::<GeckoSVGReset>(),
                200usize,
                concat!("Size of: ", stringify!(GeckoSVGReset))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoSVGReset>(),
                8usize,
                concat!("Alignment of ", stringify!(GeckoSVGReset))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoSVGReset>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoSVGReset),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct GeckoColumn {
            pub gecko: root::nsStyleColumn,
        }
        #[test]
        fn bindgen_test_layout_GeckoColumn() {
            assert_eq!(
                ::std::mem::size_of::<GeckoColumn>(),
                64usize,
                concat!("Size of: ", stringify!(GeckoColumn))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoColumn>(),
                8usize,
                concat!("Alignment of ", stringify!(GeckoColumn))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoColumn>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoColumn),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct GeckoEffects {
            pub gecko: root::nsStyleEffects,
        }
        #[test]
        fn bindgen_test_layout_GeckoEffects() {
            assert_eq!(
                ::std::mem::size_of::<GeckoEffects>(),
                40usize,
                concat!("Size of: ", stringify!(GeckoEffects))
            );
            assert_eq!(
                ::std::mem::align_of::<GeckoEffects>(),
                8usize,
                concat!("Alignment of ", stringify!(GeckoEffects))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<GeckoEffects>())).gecko as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(GeckoEffects),
                    "::",
                    stringify!(gecko)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct ServoMediaList {
            pub _base: root::mozilla::dom::MediaList,
            pub mRawList: root::RefPtr<root::RawServoMediaList>,
        }
        #[test]
        fn bindgen_test_layout_ServoMediaList() {
            assert_eq!(
                ::std::mem::size_of::<ServoMediaList>(),
                56usize,
                concat!("Size of: ", stringify!(ServoMediaList))
            );
            assert_eq!(
                ::std::mem::align_of::<ServoMediaList>(),
                8usize,
                concat!("Alignment of ", stringify!(ServoMediaList))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<ServoMediaList>())).mRawList as *const _ as usize },
                48usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoMediaList),
                    "::",
                    stringify!(mRawList)
                )
            );
        }
        pub const OriginFlags_UserAgent: root::mozilla::OriginFlags = root::mozilla::OriginFlags(1);
        pub const OriginFlags_User: root::mozilla::OriginFlags = root::mozilla::OriginFlags(2);
        pub const OriginFlags_Author: root::mozilla::OriginFlags = root::mozilla::OriginFlags(4);
        pub const OriginFlags_All: root::mozilla::OriginFlags = root::mozilla::OriginFlags(7);
        impl ::std::ops::BitOr<root::mozilla::OriginFlags> for root::mozilla::OriginFlags {
            type Output = Self;
            #[inline]
            fn bitor(self, other: Self) -> Self {
                OriginFlags(self.0 | other.0)
            }
        }
        impl ::std::ops::BitOrAssign for root::mozilla::OriginFlags {
            #[inline]
            fn bitor_assign(&mut self, rhs: root::mozilla::OriginFlags) {
                self.0 |= rhs.0;
            }
        }
        impl ::std::ops::BitAnd<root::mozilla::OriginFlags> for root::mozilla::OriginFlags {
            type Output = Self;
            #[inline]
            fn bitand(self, other: Self) -> Self {
                OriginFlags(self.0 & other.0)
            }
        }
        impl ::std::ops::BitAndAssign for root::mozilla::OriginFlags {
            #[inline]
            fn bitand_assign(&mut self, rhs: root::mozilla::OriginFlags) {
                self.0 &= rhs.0;
            }
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub struct OriginFlags(pub u8);
        #[repr(C)]
        #[derive(Debug)]
        pub struct CachedInheritingStyles {
            pub mBits: usize,
        }
        pub type CachedInheritingStyles_IndirectCache = [u64; 6usize];
        #[test]
        fn bindgen_test_layout_CachedInheritingStyles() {
            assert_eq!(
                ::std::mem::size_of::<CachedInheritingStyles>(),
                8usize,
                concat!("Size of: ", stringify!(CachedInheritingStyles))
            );
            assert_eq!(
                ::std::mem::align_of::<CachedInheritingStyles>(),
                8usize,
                concat!("Alignment of ", stringify!(CachedInheritingStyles))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CachedInheritingStyles>())).mBits as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CachedInheritingStyles),
                    "::",
                    stringify!(mBits)
                )
            );
        }
        #[repr(C)]
        pub struct ServoStyleContext {
            pub _base: root::nsStyleContext,
            pub mPresContext: *mut root::nsPresContext,
            pub mSource: root::ServoComputedData,
            pub mCachedInheritingStyles: root::mozilla::CachedInheritingStyles,
        }
        #[test]
        fn bindgen_test_layout_ServoStyleContext() {
            assert_eq!(
                ::std::mem::size_of::<ServoStyleContext>(),
                248usize,
                concat!("Size of: ", stringify!(ServoStyleContext))
            );
            assert_eq!(
                ::std::mem::align_of::<ServoStyleContext>(),
                8usize,
                concat!("Alignment of ", stringify!(ServoStyleContext))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoStyleContext>())).mPresContext as *const _ as usize
                },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoStyleContext),
                    "::",
                    stringify!(mPresContext)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoStyleContext>())).mSource as *const _ as usize
                },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoStyleContext),
                    "::",
                    stringify!(mSource)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoStyleContext>())).mCachedInheritingStyles
                        as *const _ as usize
                },
                240usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoStyleContext),
                    "::",
                    stringify!(mCachedInheritingStyles)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct DeclarationBlock {
            pub mContainer: root::mozilla::DeclarationBlock__bindgen_ty_1,
            pub mImmutable: bool,
            pub mType: root::mozilla::StyleBackendType,
            pub mIsDirty: u32,
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct DeclarationBlock__bindgen_ty_1 {
            pub mRaw: root::__BindgenUnionField<usize>,
            pub mOwningRule: root::__BindgenUnionField<*mut root::mozilla::css::Rule>,
            pub mHTMLCSSStyleSheet: root::__BindgenUnionField<*mut root::nsHTMLCSSStyleSheet>,
            pub bindgen_union_field: u64,
        }
        #[test]
        fn bindgen_test_layout_DeclarationBlock__bindgen_ty_1() {
            assert_eq!(
                ::std::mem::size_of::<DeclarationBlock__bindgen_ty_1>(),
                8usize,
                concat!("Size of: ", stringify!(DeclarationBlock__bindgen_ty_1))
            );
            assert_eq!(
                ::std::mem::align_of::<DeclarationBlock__bindgen_ty_1>(),
                8usize,
                concat!("Alignment of ", stringify!(DeclarationBlock__bindgen_ty_1))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<DeclarationBlock__bindgen_ty_1>())).mRaw as *const _
                        as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(DeclarationBlock__bindgen_ty_1),
                    "::",
                    stringify!(mRaw)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<DeclarationBlock__bindgen_ty_1>())).mOwningRule
                        as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(DeclarationBlock__bindgen_ty_1),
                    "::",
                    stringify!(mOwningRule)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<DeclarationBlock__bindgen_ty_1>())).mHTMLCSSStyleSheet
                        as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(DeclarationBlock__bindgen_ty_1),
                    "::",
                    stringify!(mHTMLCSSStyleSheet)
                )
            );
        }
        impl Clone for DeclarationBlock__bindgen_ty_1 {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[test]
        fn bindgen_test_layout_DeclarationBlock() {
            assert_eq!(
                ::std::mem::size_of::<DeclarationBlock>(),
                16usize,
                concat!("Size of: ", stringify!(DeclarationBlock))
            );
            assert_eq!(
                ::std::mem::align_of::<DeclarationBlock>(),
                8usize,
                concat!("Alignment of ", stringify!(DeclarationBlock))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<DeclarationBlock>())).mContainer as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(DeclarationBlock),
                    "::",
                    stringify!(mContainer)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<DeclarationBlock>())).mImmutable as *const _ as usize
                },
                8usize,
                concat!(
                    "Offset of field: ",
                    stringify!(DeclarationBlock),
                    "::",
                    stringify!(mImmutable)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<DeclarationBlock>())).mType as *const _ as usize },
                9usize,
                concat!(
                    "Offset of field: ",
                    stringify!(DeclarationBlock),
                    "::",
                    stringify!(mType)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<DeclarationBlock>())).mIsDirty as *const _ as usize
                },
                12usize,
                concat!(
                    "Offset of field: ",
                    stringify!(DeclarationBlock),
                    "::",
                    stringify!(mIsDirty)
                )
            );
        }
        impl Clone for DeclarationBlock {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct ServoDeclarationBlock {
            pub _base: root::mozilla::DeclarationBlock,
            pub mRefCnt: root::mozilla::ThreadSafeAutoRefCnt,
            pub mRaw: root::RefPtr<root::RawServoDeclarationBlock>,
        }
        pub type ServoDeclarationBlock_HasThreadSafeRefCnt = root::mozilla::TrueType;
        #[test]
        fn bindgen_test_layout_ServoDeclarationBlock() {
            assert_eq!(
                ::std::mem::size_of::<ServoDeclarationBlock>(),
                32usize,
                concat!("Size of: ", stringify!(ServoDeclarationBlock))
            );
            assert_eq!(
                ::std::mem::align_of::<ServoDeclarationBlock>(),
                8usize,
                concat!("Alignment of ", stringify!(ServoDeclarationBlock))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoDeclarationBlock>())).mRefCnt as *const _ as usize
                },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoDeclarationBlock),
                    "::",
                    stringify!(mRefCnt)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<ServoDeclarationBlock>())).mRaw as *const _ as usize
                },
                24usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ServoDeclarationBlock),
                    "::",
                    stringify!(mRaw)
                )
            );
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct CSSFontFaceDescriptors {
            pub mFamily: root::nsCSSValue,
            pub mStyle: root::nsCSSValue,
            pub mWeight: root::nsCSSValue,
            pub mStretch: root::nsCSSValue,
            pub mSrc: root::nsCSSValue,
            pub mUnicodeRange: root::nsCSSValue,
            pub mFontFeatureSettings: root::nsCSSValue,
            pub mFontVariationSettings: root::nsCSSValue,
            pub mFontLanguageOverride: root::nsCSSValue,
            pub mDisplay: root::nsCSSValue,
        }
        extern "C" {
            #[link_name = "\u{1}_ZN7mozilla22CSSFontFaceDescriptors6FieldsE"]
            pub static mut CSSFontFaceDescriptors_Fields: [*const root::nsCSSValue; 0usize];
        }
        #[test]
        fn bindgen_test_layout_CSSFontFaceDescriptors() {
            assert_eq!(
                ::std::mem::size_of::<CSSFontFaceDescriptors>(),
                160usize,
                concat!("Size of: ", stringify!(CSSFontFaceDescriptors))
            );
            assert_eq!(
                ::std::mem::align_of::<CSSFontFaceDescriptors>(),
                8usize,
                concat!("Alignment of ", stringify!(CSSFontFaceDescriptors))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CSSFontFaceDescriptors>())).mFamily as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CSSFontFaceDescriptors),
                    "::",
                    stringify!(mFamily)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CSSFontFaceDescriptors>())).mStyle as *const _ as usize
                },
                16usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CSSFontFaceDescriptors),
                    "::",
                    stringify!(mStyle)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CSSFontFaceDescriptors>())).mWeight as *const _ as usize
                },
                32usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CSSFontFaceDescriptors),
                    "::",
                    stringify!(mWeight)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CSSFontFaceDescriptors>())).mStretch as *const _ as usize
                },
                48usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CSSFontFaceDescriptors),
                    "::",
                    stringify!(mStretch)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CSSFontFaceDescriptors>())).mSrc as *const _ as usize
                },
                64usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CSSFontFaceDescriptors),
                    "::",
                    stringify!(mSrc)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CSSFontFaceDescriptors>())).mUnicodeRange as *const _
                        as usize
                },
                80usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CSSFontFaceDescriptors),
                    "::",
                    stringify!(mUnicodeRange)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CSSFontFaceDescriptors>())).mFontFeatureSettings
                        as *const _ as usize
                },
                96usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CSSFontFaceDescriptors),
                    "::",
                    stringify!(mFontFeatureSettings)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CSSFontFaceDescriptors>())).mFontVariationSettings
                        as *const _ as usize
                },
                112usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CSSFontFaceDescriptors),
                    "::",
                    stringify!(mFontVariationSettings)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CSSFontFaceDescriptors>())).mFontLanguageOverride
                        as *const _ as usize
                },
                128usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CSSFontFaceDescriptors),
                    "::",
                    stringify!(mFontLanguageOverride)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<CSSFontFaceDescriptors>())).mDisplay as *const _ as usize
                },
                144usize,
                concat!(
                    "Offset of field: ",
                    stringify!(CSSFontFaceDescriptors),
                    "::",
                    stringify!(mDisplay)
                )
            );
        }
        pub mod intl {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            #[repr(C)]
            #[derive(Debug)]
            pub struct LineBreaker {
                pub mRefCnt: root::nsAutoRefCnt,
            }
            pub type LineBreaker_HasThreadSafeRefCnt = root::mozilla::FalseType;
            pub const LineBreaker_kWordBreak_Normal:
                root::mozilla::intl::LineBreaker__bindgen_ty_1 = 0;
            pub const LineBreaker_kWordBreak_BreakAll:
                root::mozilla::intl::LineBreaker__bindgen_ty_1 = 1;
            pub const LineBreaker_kWordBreak_KeepAll:
                root::mozilla::intl::LineBreaker__bindgen_ty_1 = 2;
            pub type LineBreaker__bindgen_ty_1 = u32;
            #[test]
            fn bindgen_test_layout_LineBreaker() {
                assert_eq!(
                    ::std::mem::size_of::<LineBreaker>(),
                    8usize,
                    concat!("Size of: ", stringify!(LineBreaker))
                );
                assert_eq!(
                    ::std::mem::align_of::<LineBreaker>(),
                    8usize,
                    concat!("Alignment of ", stringify!(LineBreaker))
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<LineBreaker>())).mRefCnt as *const _ as usize },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(LineBreaker),
                        "::",
                        stringify!(mRefCnt)
                    )
                );
            }
            #[repr(C)]
            #[derive(Debug)]
            pub struct WordBreaker {
                pub mRefCnt: root::nsAutoRefCnt,
            }
            pub type WordBreaker_HasThreadSafeRefCnt = root::mozilla::FalseType;
            #[test]
            fn bindgen_test_layout_WordBreaker() {
                assert_eq!(
                    ::std::mem::size_of::<WordBreaker>(),
                    8usize,
                    concat!("Size of: ", stringify!(WordBreaker))
                );
                assert_eq!(
                    ::std::mem::align_of::<WordBreaker>(),
                    8usize,
                    concat!("Alignment of ", stringify!(WordBreaker))
                );
                assert_eq!(
                    unsafe { &(*(::std::ptr::null::<WordBreaker>())).mRefCnt as *const _ as usize },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(WordBreaker),
                        "::",
                        stringify!(mRefCnt)
                    )
                );
            }
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct InfallibleAllocPolicy {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_InfallibleAllocPolicy() {
        assert_eq!(
            ::std::mem::size_of::<InfallibleAllocPolicy>(),
            1usize,
            concat!("Size of: ", stringify!(InfallibleAllocPolicy))
        );
        assert_eq!(
            ::std::mem::align_of::<InfallibleAllocPolicy>(),
            1usize,
            concat!("Alignment of ", stringify!(InfallibleAllocPolicy))
        );
    }
    impl Clone for InfallibleAllocPolicy {
        fn clone(&self) -> Self {
            *self
        }
    }
    /// MozRefCountType is Mozilla's reference count type.
    ///
    /// We use the same type to represent the refcount of RefCounted objects
    /// as well, in order to be able to use the leak detection facilities
    /// that are implemented by XPCOM.
    ///
    /// Note that this type is not in the mozilla namespace so that it is
    /// usable for both C and C++ code.
    pub type MozRefCountType = usize;
    pub const nsresult_NS_ERROR_NO_INTERFACE: root::nsresult = nsresult::NS_NOINTERFACE;
    pub const nsresult_NS_ERROR_INVALID_ARG: root::nsresult = nsresult::NS_ERROR_ILLEGAL_VALUE;
    pub const nsresult_NS_ERROR_INVALID_POINTER: root::nsresult = nsresult::NS_ERROR_ILLEGAL_VALUE;
    pub const nsresult_NS_ERROR_NULL_POINTER: root::nsresult = nsresult::NS_ERROR_ILLEGAL_VALUE;
    pub const nsresult_NS_BINDING_SUCCEEDED: root::nsresult = nsresult::NS_OK;
    pub const nsresult_NS_NET_STATUS_RESOLVING_HOST: root::nsresult =
        nsresult::NS_BINDING_REDIRECTED;
    pub const nsresult_NS_NET_STATUS_RESOLVED_HOST: root::nsresult =
        nsresult::NS_ERROR_ALREADY_CONNECTED;
    pub const nsresult_NS_NET_STATUS_CONNECTED_TO: root::nsresult = nsresult::NS_BINDING_RETARGETED;
    pub const nsresult_NS_NET_STATUS_TLS_HANDSHAKE_STARTING: root::nsresult =
        nsresult::NS_ERROR_NOT_CONNECTED;
    pub const nsresult_NS_NET_STATUS_TLS_HANDSHAKE_ENDED: root::nsresult =
        nsresult::NS_ERROR_CONNECTION_REFUSED;
    pub const nsresult_NS_NET_STATUS_WAITING_FOR: root::nsresult = nsresult::NS_ERROR_MALFORMED_URI;
    pub const nsresult_NS_STATE_PROPERTY_EXISTS: root::nsresult = nsresult::NS_OK;
    pub const nsresult_NS_ERROR_HTMLPARSER_CONTINUE: root::nsresult = nsresult::NS_OK;
    pub const nsresult_NS_RDF_ASSERTION_ACCEPTED: root::nsresult = nsresult::NS_OK;
    pub const nsresult_NS_EXACT_LENGTH: root::nsresult = nsresult::NS_OK_UDEC_EXACTLENGTH;
    pub const nsresult_NS_PARTIAL_MORE_INPUT: root::nsresult = nsresult::NS_OK_UDEC_MOREINPUT;
    pub const nsresult_NS_PARTIAL_MORE_OUTPUT: root::nsresult = nsresult::NS_OK_UDEC_MOREOUTPUT;
    pub const nsresult_NS_ERROR_ILLEGAL_INPUT: root::nsresult =
        nsresult::NS_ERROR_UDEC_ILLEGALINPUT;
    pub const nsresult_NS_ERROR_XPATH_INVALID_ARG: root::nsresult =
        nsresult::NS_ERROR_ILLEGAL_VALUE;
    pub const nsresult_NS_SUCCESS_RESTART_APP: root::nsresult = nsresult::NS_SUCCESS_DONT_FIXUP;
    #[repr(u32)]
    #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
    pub enum nsresult {
        NS_OK = 0,
        NS_ERROR_BASE = 3253927936,
        NS_ERROR_NOT_INITIALIZED = 3253927937,
        NS_ERROR_ALREADY_INITIALIZED = 3253927938,
        NS_ERROR_NOT_IMPLEMENTED = 2147500033,
        NS_NOINTERFACE = 2147500034,
        NS_ERROR_ABORT = 2147500036,
        NS_ERROR_FAILURE = 2147500037,
        NS_ERROR_UNEXPECTED = 2147549183,
        NS_ERROR_OUT_OF_MEMORY = 2147942414,
        NS_ERROR_ILLEGAL_VALUE = 2147942487,
        NS_ERROR_NO_AGGREGATION = 2147746064,
        NS_ERROR_NOT_AVAILABLE = 2147746065,
        NS_ERROR_FACTORY_NOT_REGISTERED = 2147746132,
        NS_ERROR_FACTORY_REGISTER_AGAIN = 2147746133,
        NS_ERROR_FACTORY_NOT_LOADED = 2147746296,
        NS_ERROR_FACTORY_NO_SIGNATURE_SUPPORT = 3253928193,
        NS_ERROR_FACTORY_EXISTS = 3253928192,
        NS_ERROR_CANNOT_CONVERT_DATA = 2152071169,
        NS_ERROR_OBJECT_IS_IMMUTABLE = 2152071170,
        NS_ERROR_LOSS_OF_SIGNIFICANT_DATA = 2152071171,
        NS_ERROR_NOT_SAME_THREAD = 2152071172,
        NS_ERROR_ILLEGAL_DURING_SHUTDOWN = 2152071198,
        NS_ERROR_SERVICE_NOT_AVAILABLE = 2152071190,
        NS_SUCCESS_LOSS_OF_INSIGNIFICANT_DATA = 4587521,
        NS_SUCCESS_INTERRUPTED_TRAVERSE = 4587522,
        NS_ERROR_SERVICE_NOT_FOUND = 4587542,
        NS_ERROR_SERVICE_IN_USE = 4587543,
        NS_BASE_STREAM_CLOSED = 2152136706,
        NS_BASE_STREAM_OSERROR = 2152136707,
        NS_BASE_STREAM_ILLEGAL_ARGS = 2152136708,
        NS_BASE_STREAM_NO_CONVERTER = 2152136709,
        NS_BASE_STREAM_BAD_CONVERSION = 2152136710,
        NS_BASE_STREAM_WOULD_BLOCK = 2152136711,
        NS_ERROR_GFX_PRINTER_NO_PRINTER_AVAILABLE = 2152202241,
        NS_ERROR_GFX_PRINTER_NAME_NOT_FOUND = 2152202242,
        NS_ERROR_GFX_PRINTER_COULD_NOT_OPEN_FILE = 2152202243,
        NS_ERROR_GFX_PRINTER_STARTDOC = 2152202244,
        NS_ERROR_GFX_PRINTER_ENDDOC = 2152202245,
        NS_ERROR_GFX_PRINTER_STARTPAGE = 2152202246,
        NS_ERROR_GFX_PRINTER_DOC_IS_BUSY = 2152202247,
        NS_ERROR_GFX_CMAP_MALFORMED = 2152202291,
        NS_SUCCESS_EVENT_CONSUMED = 4784129,
        NS_SUCCESS_EVENT_HANDLED_ASYNCHRONOUSLY = 4784130,
        NS_BINDING_FAILED = 2152398849,
        NS_BINDING_ABORTED = 2152398850,
        NS_BINDING_REDIRECTED = 2152398851,
        NS_BINDING_RETARGETED = 2152398852,
        NS_ERROR_MALFORMED_URI = 2152398858,
        NS_ERROR_IN_PROGRESS = 2152398863,
        NS_ERROR_NO_CONTENT = 2152398865,
        NS_ERROR_UNKNOWN_PROTOCOL = 2152398866,
        NS_ERROR_INVALID_CONTENT_ENCODING = 2152398875,
        NS_ERROR_CORRUPTED_CONTENT = 2152398877,
        NS_ERROR_INVALID_SIGNATURE = 2152398906,
        NS_ERROR_FIRST_HEADER_FIELD_COMPONENT_EMPTY = 2152398882,
        NS_ERROR_ALREADY_OPENED = 2152398921,
        NS_ERROR_ALREADY_CONNECTED = 2152398859,
        NS_ERROR_NOT_CONNECTED = 2152398860,
        NS_ERROR_CONNECTION_REFUSED = 2152398861,
        NS_ERROR_NET_TIMEOUT = 2152398862,
        NS_ERROR_OFFLINE = 2152398864,
        NS_ERROR_PORT_ACCESS_NOT_ALLOWED = 2152398867,
        NS_ERROR_NET_RESET = 2152398868,
        NS_ERROR_NET_INTERRUPT = 2152398919,
        NS_ERROR_PROXY_CONNECTION_REFUSED = 2152398920,
        NS_ERROR_NET_PARTIAL_TRANSFER = 2152398924,
        NS_ERROR_NET_INADEQUATE_SECURITY = 2152398930,
        NS_ERROR_NOT_RESUMABLE = 2152398873,
        NS_ERROR_REDIRECT_LOOP = 2152398879,
        NS_ERROR_ENTITY_CHANGED = 2152398880,
        NS_ERROR_UNSAFE_CONTENT_TYPE = 2152398922,
        NS_ERROR_REMOTE_XUL = 2152398923,
        NS_ERROR_LOAD_SHOWED_ERRORPAGE = 2152398925,
        NS_ERROR_DOCSHELL_DYING = 2152398926,
        NS_ERROR_FTP_LOGIN = 2152398869,
        NS_ERROR_FTP_CWD = 2152398870,
        NS_ERROR_FTP_PASV = 2152398871,
        NS_ERROR_FTP_PWD = 2152398872,
        NS_ERROR_FTP_LIST = 2152398876,
        NS_ERROR_UNKNOWN_HOST = 2152398878,
        NS_ERROR_DNS_LOOKUP_QUEUE_FULL = 2152398881,
        NS_ERROR_UNKNOWN_PROXY_HOST = 2152398890,
        NS_ERROR_UNKNOWN_SOCKET_TYPE = 2152398899,
        NS_ERROR_SOCKET_CREATE_FAILED = 2152398900,
        NS_ERROR_SOCKET_ADDRESS_NOT_SUPPORTED = 2152398901,
        NS_ERROR_SOCKET_ADDRESS_IN_USE = 2152398902,
        NS_ERROR_CACHE_KEY_NOT_FOUND = 2152398909,
        NS_ERROR_CACHE_DATA_IS_STREAM = 2152398910,
        NS_ERROR_CACHE_DATA_IS_NOT_STREAM = 2152398911,
        NS_ERROR_CACHE_WAIT_FOR_VALIDATION = 2152398912,
        NS_ERROR_CACHE_ENTRY_DOOMED = 2152398913,
        NS_ERROR_CACHE_READ_ACCESS_DENIED = 2152398914,
        NS_ERROR_CACHE_WRITE_ACCESS_DENIED = 2152398915,
        NS_ERROR_CACHE_IN_USE = 2152398916,
        NS_ERROR_DOCUMENT_NOT_CACHED = 2152398918,
        NS_ERROR_INSUFFICIENT_DOMAIN_LEVELS = 2152398928,
        NS_ERROR_HOST_IS_IP_ADDRESS = 2152398929,
        NS_SUCCESS_ADOPTED_DATA = 4915290,
        NS_NET_STATUS_BEGIN_FTP_TRANSACTION = 4915227,
        NS_NET_STATUS_END_FTP_TRANSACTION = 4915228,
        NS_SUCCESS_AUTH_FINISHED = 4915240,
        NS_NET_STATUS_READING = 2152398856,
        NS_NET_STATUS_WRITING = 2152398857,
        NS_NET_STATUS_CONNECTING_TO = 2152398855,
        NS_NET_STATUS_SENDING_TO = 2152398853,
        NS_NET_STATUS_RECEIVING_FROM = 2152398854,
        NS_ERROR_INTERCEPTION_FAILED = 2152398948,
        NS_ERROR_PLUGINS_PLUGINSNOTCHANGED = 2152465384,
        NS_ERROR_PLUGIN_DISABLED = 2152465385,
        NS_ERROR_PLUGIN_BLOCKLISTED = 2152465386,
        NS_ERROR_PLUGIN_TIME_RANGE_NOT_SUPPORTED = 2152465387,
        NS_ERROR_PLUGIN_CLICKTOPLAY = 2152465388,
        NS_TABLELAYOUT_CELL_NOT_FOUND = 5046272,
        NS_OK_PARSE_SHEET = 5046273,
        NS_POSITION_BEFORE_TABLE = 5046275,
        NS_STATE_PROPERTY_NOT_THERE = 5046277,
        NS_ERROR_HTMLPARSER_EOF = 2152596456,
        NS_ERROR_HTMLPARSER_UNKNOWN = 2152596457,
        NS_ERROR_HTMLPARSER_CANTPROPAGATE = 2152596458,
        NS_ERROR_HTMLPARSER_CONTEXTMISMATCH = 2152596459,
        NS_ERROR_HTMLPARSER_BADFILENAME = 2152596460,
        NS_ERROR_HTMLPARSER_BADURL = 2152596461,
        NS_ERROR_HTMLPARSER_INVALIDPARSERCONTEXT = 2152596462,
        NS_ERROR_HTMLPARSER_INTERRUPTED = 2152596463,
        NS_ERROR_HTMLPARSER_BLOCK = 2152596464,
        NS_ERROR_HTMLPARSER_BADTOKENIZER = 2152596465,
        NS_ERROR_HTMLPARSER_BADATTRIBUTE = 2152596466,
        NS_ERROR_HTMLPARSER_UNRESOLVEDDTD = 2152596467,
        NS_ERROR_HTMLPARSER_MISPLACEDTABLECONTENT = 2152596468,
        NS_ERROR_HTMLPARSER_BADDTD = 2152596469,
        NS_ERROR_HTMLPARSER_BADCONTEXT = 2152596470,
        NS_ERROR_HTMLPARSER_STOPPARSING = 2152596471,
        NS_ERROR_HTMLPARSER_UNTERMINATEDSTRINGLITERAL = 2152596472,
        NS_ERROR_HTMLPARSER_HIERARCHYTOODEEP = 2152596473,
        NS_ERROR_HTMLPARSER_FAKE_ENDTAG = 2152596474,
        NS_ERROR_HTMLPARSER_INVALID_COMMENT = 2152596475,
        NS_HTMLTOKENS_NOT_AN_ENTITY = 5113808,
        NS_HTMLPARSER_VALID_META_CHARSET = 5114808,
        NS_RDF_CURSOR_EMPTY = 5177345,
        NS_RDF_NO_VALUE = 5177346,
        NS_RDF_ASSERTION_REJECTED = 5177347,
        NS_RDF_STOP_VISIT = 5177348,
        NS_ERROR_UCONV_NOCONV = 2152726529,
        NS_ERROR_UDEC_ILLEGALINPUT = 2152726542,
        NS_OK_HAD_REPLACEMENTS = 5242883,
        NS_SUCCESS_USING_FALLBACK_LOCALE = 5242882,
        NS_OK_UDEC_EXACTLENGTH = 5242891,
        NS_OK_UDEC_MOREINPUT = 5242892,
        NS_OK_UDEC_MOREOUTPUT = 5242893,
        NS_OK_UDEC_NOBOMFOUND = 5242894,
        NS_OK_UENC_EXACTLENGTH = 5242913,
        NS_OK_UENC_MOREOUTPUT = 5242914,
        NS_ERROR_UENC_NOMAPPING = 5242915,
        NS_OK_UENC_MOREINPUT = 5242916,
        NS_ERROR_FILE_UNRECOGNIZED_PATH = 2152857601,
        NS_ERROR_FILE_UNRESOLVABLE_SYMLINK = 2152857602,
        NS_ERROR_FILE_EXECUTION_FAILED = 2152857603,
        NS_ERROR_FILE_UNKNOWN_TYPE = 2152857604,
        NS_ERROR_FILE_DESTINATION_NOT_DIR = 2152857605,
        NS_ERROR_FILE_TARGET_DOES_NOT_EXIST = 2152857606,
        NS_ERROR_FILE_COPY_OR_MOVE_FAILED = 2152857607,
        NS_ERROR_FILE_ALREADY_EXISTS = 2152857608,
        NS_ERROR_FILE_INVALID_PATH = 2152857609,
        NS_ERROR_FILE_DISK_FULL = 2152857610,
        NS_ERROR_FILE_CORRUPTED = 2152857611,
        NS_ERROR_FILE_NOT_DIRECTORY = 2152857612,
        NS_ERROR_FILE_IS_DIRECTORY = 2152857613,
        NS_ERROR_FILE_IS_LOCKED = 2152857614,
        NS_ERROR_FILE_TOO_BIG = 2152857615,
        NS_ERROR_FILE_NO_DEVICE_SPACE = 2152857616,
        NS_ERROR_FILE_NAME_TOO_LONG = 2152857617,
        NS_ERROR_FILE_NOT_FOUND = 2152857618,
        NS_ERROR_FILE_READ_ONLY = 2152857619,
        NS_ERROR_FILE_DIR_NOT_EMPTY = 2152857620,
        NS_ERROR_FILE_ACCESS_DENIED = 2152857621,
        NS_SUCCESS_FILE_DIRECTORY_EMPTY = 5373953,
        NS_SUCCESS_AGGREGATE_RESULT = 5373954,
        NS_ERROR_DOM_INDEX_SIZE_ERR = 2152923137,
        NS_ERROR_DOM_HIERARCHY_REQUEST_ERR = 2152923139,
        NS_ERROR_DOM_WRONG_DOCUMENT_ERR = 2152923140,
        NS_ERROR_DOM_INVALID_CHARACTER_ERR = 2152923141,
        NS_ERROR_DOM_NO_MODIFICATION_ALLOWED_ERR = 2152923143,
        NS_ERROR_DOM_NOT_FOUND_ERR = 2152923144,
        NS_ERROR_DOM_NOT_SUPPORTED_ERR = 2152923145,
        NS_ERROR_DOM_INUSE_ATTRIBUTE_ERR = 2152923146,
        NS_ERROR_DOM_INVALID_STATE_ERR = 2152923147,
        NS_ERROR_DOM_SYNTAX_ERR = 2152923148,
        NS_ERROR_DOM_INVALID_MODIFICATION_ERR = 2152923149,
        NS_ERROR_DOM_NAMESPACE_ERR = 2152923150,
        NS_ERROR_DOM_INVALID_ACCESS_ERR = 2152923151,
        NS_ERROR_DOM_TYPE_MISMATCH_ERR = 2152923153,
        NS_ERROR_DOM_SECURITY_ERR = 2152923154,
        NS_ERROR_DOM_NETWORK_ERR = 2152923155,
        NS_ERROR_DOM_ABORT_ERR = 2152923156,
        NS_ERROR_DOM_URL_MISMATCH_ERR = 2152923157,
        NS_ERROR_DOM_QUOTA_EXCEEDED_ERR = 2152923158,
        NS_ERROR_DOM_TIMEOUT_ERR = 2152923159,
        NS_ERROR_DOM_INVALID_NODE_TYPE_ERR = 2152923160,
        NS_ERROR_DOM_DATA_CLONE_ERR = 2152923161,
        NS_ERROR_TYPE_ERR = 2152923162,
        NS_ERROR_RANGE_ERR = 2152923163,
        NS_ERROR_DOM_ENCODING_NOT_SUPPORTED_ERR = 2152923164,
        NS_ERROR_DOM_INVALID_POINTER_ERR = 2152923165,
        NS_ERROR_DOM_UNKNOWN_ERR = 2152923166,
        NS_ERROR_DOM_DATA_ERR = 2152923167,
        NS_ERROR_DOM_OPERATION_ERR = 2152923168,
        NS_ERROR_DOM_NOT_ALLOWED_ERR = 2152923169,
        NS_ERROR_DOM_SECMAN_ERR = 2152924137,
        NS_ERROR_DOM_WRONG_TYPE_ERR = 2152924138,
        NS_ERROR_DOM_NOT_OBJECT_ERR = 2152924139,
        NS_ERROR_DOM_NOT_XPC_OBJECT_ERR = 2152924140,
        NS_ERROR_DOM_NOT_NUMBER_ERR = 2152924141,
        NS_ERROR_DOM_NOT_BOOLEAN_ERR = 2152924142,
        NS_ERROR_DOM_NOT_FUNCTION_ERR = 2152924143,
        NS_ERROR_DOM_TOO_FEW_PARAMETERS_ERR = 2152924144,
        NS_ERROR_DOM_BAD_DOCUMENT_DOMAIN = 2152924145,
        NS_ERROR_DOM_PROP_ACCESS_DENIED = 2152924146,
        NS_ERROR_DOM_XPCONNECT_ACCESS_DENIED = 2152924147,
        NS_ERROR_DOM_BAD_URI = 2152924148,
        NS_ERROR_DOM_RETVAL_UNDEFINED = 2152924149,
        NS_ERROR_DOM_QUOTA_REACHED = 2152924150,
        NS_ERROR_UNCATCHABLE_EXCEPTION = 2152924151,
        NS_ERROR_DOM_MALFORMED_URI = 2152924152,
        NS_ERROR_DOM_INVALID_HEADER_NAME = 2152924153,
        NS_ERROR_DOM_INVALID_STATE_XHR_HAS_INVALID_CONTEXT = 2152924154,
        NS_ERROR_DOM_INVALID_STATE_XHR_MUST_BE_OPENED = 2152924155,
        NS_ERROR_DOM_INVALID_STATE_XHR_MUST_NOT_BE_SENDING = 2152924156,
        NS_ERROR_DOM_INVALID_STATE_XHR_MUST_NOT_BE_LOADING_OR_DONE = 2152924157,
        NS_ERROR_DOM_INVALID_STATE_XHR_HAS_WRONG_RESPONSETYPE_FOR_RESPONSEXML = 2152924158,
        NS_ERROR_DOM_INVALID_STATE_XHR_HAS_WRONG_RESPONSETYPE_FOR_RESPONSETEXT = 2152924159,
        NS_ERROR_DOM_INVALID_STATE_XHR_CHUNKED_RESPONSETYPES_UNSUPPORTED_FOR_SYNC = 2152924160,
        NS_ERROR_DOM_INVALID_ACCESS_XHR_TIMEOUT_AND_RESPONSETYPE_UNSUPPORTED_FOR_SYNC = 2152924161,
        NS_ERROR_DOM_JS_DECODING_ERROR = 2152924162,
        NS_SUCCESS_DOM_NO_OPERATION = 5439489,
        NS_SUCCESS_DOM_SCRIPT_EVALUATION_THREW = 5439490,
        NS_SUCCESS_DOM_SCRIPT_EVALUATION_THREW_UNCATCHABLE = 5439491,
        NS_IMAGELIB_SUCCESS_LOAD_FINISHED = 5505024,
        NS_IMAGELIB_ERROR_FAILURE = 2152988677,
        NS_IMAGELIB_ERROR_NO_DECODER = 2152988678,
        NS_IMAGELIB_ERROR_NOT_FINISHED = 2152988679,
        NS_IMAGELIB_ERROR_NO_ENCODER = 2152988681,
        NS_SUCCESS_EDITOR_ELEMENT_NOT_FOUND = 5636097,
        NS_SUCCESS_EDITOR_FOUND_TARGET = 5636098,
        NS_ERROR_XPC_NOT_ENOUGH_ARGS = 2153185281,
        NS_ERROR_XPC_NEED_OUT_OBJECT = 2153185282,
        NS_ERROR_XPC_CANT_SET_OUT_VAL = 2153185283,
        NS_ERROR_XPC_NATIVE_RETURNED_FAILURE = 2153185284,
        NS_ERROR_XPC_CANT_GET_INTERFACE_INFO = 2153185285,
        NS_ERROR_XPC_CANT_GET_PARAM_IFACE_INFO = 2153185286,
        NS_ERROR_XPC_CANT_GET_METHOD_INFO = 2153185287,
        NS_ERROR_XPC_UNEXPECTED = 2153185288,
        NS_ERROR_XPC_BAD_CONVERT_JS = 2153185289,
        NS_ERROR_XPC_BAD_CONVERT_NATIVE = 2153185290,
        NS_ERROR_XPC_BAD_CONVERT_JS_NULL_REF = 2153185291,
        NS_ERROR_XPC_BAD_OP_ON_WN_PROTO = 2153185292,
        NS_ERROR_XPC_CANT_CONVERT_WN_TO_FUN = 2153185293,
        NS_ERROR_XPC_CANT_DEFINE_PROP_ON_WN = 2153185294,
        NS_ERROR_XPC_CANT_WATCH_WN_STATIC = 2153185295,
        NS_ERROR_XPC_CANT_EXPORT_WN_STATIC = 2153185296,
        NS_ERROR_XPC_SCRIPTABLE_CALL_FAILED = 2153185297,
        NS_ERROR_XPC_SCRIPTABLE_CTOR_FAILED = 2153185298,
        NS_ERROR_XPC_CANT_CALL_WO_SCRIPTABLE = 2153185299,
        NS_ERROR_XPC_CANT_CTOR_WO_SCRIPTABLE = 2153185300,
        NS_ERROR_XPC_CI_RETURNED_FAILURE = 2153185301,
        NS_ERROR_XPC_GS_RETURNED_FAILURE = 2153185302,
        NS_ERROR_XPC_BAD_CID = 2153185303,
        NS_ERROR_XPC_BAD_IID = 2153185304,
        NS_ERROR_XPC_CANT_CREATE_WN = 2153185305,
        NS_ERROR_XPC_JS_THREW_EXCEPTION = 2153185306,
        NS_ERROR_XPC_JS_THREW_NATIVE_OBJECT = 2153185307,
        NS_ERROR_XPC_JS_THREW_JS_OBJECT = 2153185308,
        NS_ERROR_XPC_JS_THREW_NULL = 2153185309,
        NS_ERROR_XPC_JS_THREW_STRING = 2153185310,
        NS_ERROR_XPC_JS_THREW_NUMBER = 2153185311,
        NS_ERROR_XPC_JAVASCRIPT_ERROR = 2153185312,
        NS_ERROR_XPC_JAVASCRIPT_ERROR_WITH_DETAILS = 2153185313,
        NS_ERROR_XPC_CANT_CONVERT_PRIMITIVE_TO_ARRAY = 2153185314,
        NS_ERROR_XPC_CANT_CONVERT_OBJECT_TO_ARRAY = 2153185315,
        NS_ERROR_XPC_NOT_ENOUGH_ELEMENTS_IN_ARRAY = 2153185316,
        NS_ERROR_XPC_CANT_GET_ARRAY_INFO = 2153185317,
        NS_ERROR_XPC_NOT_ENOUGH_CHARS_IN_STRING = 2153185318,
        NS_ERROR_XPC_SECURITY_MANAGER_VETO = 2153185319,
        NS_ERROR_XPC_INTERFACE_NOT_SCRIPTABLE = 2153185320,
        NS_ERROR_XPC_INTERFACE_NOT_FROM_NSISUPPORTS = 2153185321,
        NS_ERROR_XPC_CANT_GET_JSOBJECT_OF_DOM_OBJECT = 2153185322,
        NS_ERROR_XPC_CANT_SET_READ_ONLY_CONSTANT = 2153185323,
        NS_ERROR_XPC_CANT_SET_READ_ONLY_ATTRIBUTE = 2153185324,
        NS_ERROR_XPC_CANT_SET_READ_ONLY_METHOD = 2153185325,
        NS_ERROR_XPC_CANT_ADD_PROP_TO_WRAPPED_NATIVE = 2153185326,
        NS_ERROR_XPC_CALL_TO_SCRIPTABLE_FAILED = 2153185327,
        NS_ERROR_XPC_JSOBJECT_HAS_NO_FUNCTION_NAMED = 2153185328,
        NS_ERROR_XPC_BAD_ID_STRING = 2153185329,
        NS_ERROR_XPC_BAD_INITIALIZER_NAME = 2153185330,
        NS_ERROR_XPC_HAS_BEEN_SHUTDOWN = 2153185331,
        NS_ERROR_XPC_CANT_MODIFY_PROP_ON_WN = 2153185332,
        NS_ERROR_XPC_BAD_CONVERT_JS_ZERO_ISNOT_NULL = 2153185333,
        NS_ERROR_XPC_CANT_PASS_CPOW_TO_NATIVE = 2153185334,
        NS_ERROR_LAUNCHED_CHILD_PROCESS = 2153251016,
        NS_ERROR_CSP_FORM_ACTION_VIOLATION = 2153381986,
        NS_ERROR_CSP_FRAME_ANCESTOR_VIOLATION = 2153381987,
        NS_ERROR_SRI_CORRUPT = 2153382088,
        NS_ERROR_SRI_DISABLED = 2153382089,
        NS_ERROR_SRI_NOT_ELIGIBLE = 2153382090,
        NS_ERROR_SRI_UNEXPECTED_HASH_TYPE = 2153382091,
        NS_ERROR_SRI_IMPORT = 2153382092,
        NS_ERROR_CMS_VERIFY_NOT_SIGNED = 2153382912,
        NS_ERROR_CMS_VERIFY_NO_CONTENT_INFO = 2153382913,
        NS_ERROR_CMS_VERIFY_BAD_DIGEST = 2153382914,
        NS_ERROR_CMS_VERIFY_NOCERT = 2153382916,
        NS_ERROR_CMS_VERIFY_UNTRUSTED = 2153382917,
        NS_ERROR_CMS_VERIFY_ERROR_UNVERIFIED = 2153382919,
        NS_ERROR_CMS_VERIFY_ERROR_PROCESSING = 2153382920,
        NS_ERROR_CMS_VERIFY_BAD_SIGNATURE = 2153382921,
        NS_ERROR_CMS_VERIFY_DIGEST_MISMATCH = 2153382922,
        NS_ERROR_CMS_VERIFY_UNKNOWN_ALGO = 2153382923,
        NS_ERROR_CMS_VERIFY_UNSUPPORTED_ALGO = 2153382924,
        NS_ERROR_CMS_VERIFY_MALFORMED_SIGNATURE = 2153382925,
        NS_ERROR_CMS_VERIFY_HEADER_MISMATCH = 2153382926,
        NS_ERROR_CMS_VERIFY_NOT_YET_ATTEMPTED = 2153382927,
        NS_ERROR_CMS_VERIFY_CERT_WITHOUT_ADDRESS = 2153382928,
        NS_ERROR_CMS_ENCRYPT_NO_BULK_ALG = 2153382944,
        NS_ERROR_CMS_ENCRYPT_INCOMPLETE = 2153382945,
        NS_ERROR_DOM_INVALID_EXPRESSION_ERR = 2153447475,
        NS_ERROR_DOM_TYPE_ERR = 2153447476,
        NS_ERROR_WONT_HANDLE_CONTENT = 2153578497,
        NS_ERROR_MALWARE_URI = 2153578526,
        NS_ERROR_PHISHING_URI = 2153578527,
        NS_ERROR_TRACKING_URI = 2153578530,
        NS_ERROR_UNWANTED_URI = 2153578531,
        NS_ERROR_BLOCKED_URI = 2153578533,
        NS_ERROR_HARMFUL_URI = 2153578534,
        NS_ERROR_SAVE_LINK_AS_TIMEOUT = 2153578528,
        NS_ERROR_PARSED_DATA_CACHED = 2153578529,
        NS_REFRESHURI_HEADER_FOUND = 6094850,
        NS_ERROR_CONTENT_BLOCKED = 2153644038,
        NS_ERROR_CONTENT_BLOCKED_SHOW_ALT = 2153644039,
        NS_PROPTABLE_PROP_NOT_THERE = 2153644042,
        NS_ERROR_XBL_BLOCKED = 2153644047,
        NS_ERROR_CONTENT_CRASHED = 2153644048,
        NS_HTML_STYLE_PROPERTY_NOT_THERE = 6160386,
        NS_CONTENT_BLOCKED = 6160392,
        NS_CONTENT_BLOCKED_SHOW_ALT = 6160393,
        NS_PROPTABLE_PROP_OVERWRITTEN = 6160395,
        NS_FINDBROADCASTER_NOT_FOUND = 6160396,
        NS_FINDBROADCASTER_FOUND = 6160397,
        NS_FINDBROADCASTER_AWAIT_OVERLAYS = 6160398,
        NS_ERROR_XSLT_PARSE_FAILURE = 2153775105,
        NS_ERROR_XPATH_PARSE_FAILURE = 2153775106,
        NS_ERROR_XSLT_ALREADY_SET = 2153775107,
        NS_ERROR_XSLT_EXECUTION_FAILURE = 2153775108,
        NS_ERROR_XPATH_UNKNOWN_FUNCTION = 2153775109,
        NS_ERROR_XSLT_BAD_RECURSION = 2153775110,
        NS_ERROR_XSLT_BAD_VALUE = 2153775111,
        NS_ERROR_XSLT_NODESET_EXPECTED = 2153775112,
        NS_ERROR_XSLT_ABORTED = 2153775113,
        NS_ERROR_XSLT_NETWORK_ERROR = 2153775114,
        NS_ERROR_XSLT_WRONG_MIME_TYPE = 2153775115,
        NS_ERROR_XSLT_LOAD_RECURSION = 2153775116,
        NS_ERROR_XPATH_BAD_ARGUMENT_COUNT = 2153775117,
        NS_ERROR_XPATH_BAD_EXTENSION_FUNCTION = 2153775118,
        NS_ERROR_XPATH_PAREN_EXPECTED = 2153775119,
        NS_ERROR_XPATH_INVALID_AXIS = 2153775120,
        NS_ERROR_XPATH_NO_NODE_TYPE_TEST = 2153775121,
        NS_ERROR_XPATH_BRACKET_EXPECTED = 2153775122,
        NS_ERROR_XPATH_INVALID_VAR_NAME = 2153775123,
        NS_ERROR_XPATH_UNEXPECTED_END = 2153775124,
        NS_ERROR_XPATH_OPERATOR_EXPECTED = 2153775125,
        NS_ERROR_XPATH_UNCLOSED_LITERAL = 2153775126,
        NS_ERROR_XPATH_BAD_COLON = 2153775127,
        NS_ERROR_XPATH_BAD_BANG = 2153775128,
        NS_ERROR_XPATH_ILLEGAL_CHAR = 2153775129,
        NS_ERROR_XPATH_BINARY_EXPECTED = 2153775130,
        NS_ERROR_XSLT_LOAD_BLOCKED_ERROR = 2153775131,
        NS_ERROR_XPATH_INVALID_EXPRESSION_EVALUATED = 2153775132,
        NS_ERROR_XPATH_UNBALANCED_CURLY_BRACE = 2153775133,
        NS_ERROR_XSLT_BAD_NODE_NAME = 2153775134,
        NS_ERROR_XSLT_VAR_ALREADY_SET = 2153775135,
        NS_ERROR_XSLT_CALL_TO_KEY_NOT_ALLOWED = 2153775136,
        NS_XSLT_GET_NEW_HANDLER = 6291457,
        NS_ERROR_TRANSPORT_INIT = 2153840641,
        NS_ERROR_DUPLICATE_HANDLE = 2153840642,
        NS_ERROR_BRIDGE_OPEN_PARENT = 2153840643,
        NS_ERROR_BRIDGE_OPEN_CHILD = 2153840644,
        NS_ERROR_DOM_SVG_WRONG_TYPE_ERR = 2153906176,
        NS_ERROR_DOM_SVG_MATRIX_NOT_INVERTABLE = 2153906178,
        NS_ERROR_STORAGE_BUSY = 2153971713,
        NS_ERROR_STORAGE_IOERR = 2153971714,
        NS_ERROR_STORAGE_CONSTRAINT = 2153971715,
        NS_ERROR_DOM_FILE_NOT_FOUND_ERR = 2154102784,
        NS_ERROR_DOM_FILE_NOT_READABLE_ERR = 2154102785,
        NS_ERROR_DOM_FILE_ABORT_ERR = 2154102786,
        NS_ERROR_DOM_INDEXEDDB_UNKNOWN_ERR = 2154168321,
        NS_ERROR_DOM_INDEXEDDB_NOT_FOUND_ERR = 2154168323,
        NS_ERROR_DOM_INDEXEDDB_CONSTRAINT_ERR = 2154168324,
        NS_ERROR_DOM_INDEXEDDB_DATA_ERR = 2154168325,
        NS_ERROR_DOM_INDEXEDDB_NOT_ALLOWED_ERR = 2154168326,
        NS_ERROR_DOM_INDEXEDDB_TRANSACTION_INACTIVE_ERR = 2154168327,
        NS_ERROR_DOM_INDEXEDDB_ABORT_ERR = 2154168328,
        NS_ERROR_DOM_INDEXEDDB_READ_ONLY_ERR = 2154168329,
        NS_ERROR_DOM_INDEXEDDB_TIMEOUT_ERR = 2154168330,
        NS_ERROR_DOM_INDEXEDDB_QUOTA_ERR = 2154168331,
        NS_ERROR_DOM_INDEXEDDB_VERSION_ERR = 2154168332,
        NS_ERROR_DOM_INDEXEDDB_RECOVERABLE_ERR = 2154169321,
        NS_ERROR_DOM_FILEHANDLE_UNKNOWN_ERR = 2154233857,
        NS_ERROR_DOM_FILEHANDLE_NOT_ALLOWED_ERR = 2154233858,
        NS_ERROR_DOM_FILEHANDLE_INACTIVE_ERR = 2154233859,
        NS_ERROR_DOM_FILEHANDLE_ABORT_ERR = 2154233860,
        NS_ERROR_DOM_FILEHANDLE_READ_ONLY_ERR = 2154233861,
        NS_ERROR_DOM_FILEHANDLE_QUOTA_ERR = 2154233862,
        NS_ERROR_SIGNED_JAR_NOT_SIGNED = 2154299393,
        NS_ERROR_SIGNED_JAR_MODIFIED_ENTRY = 2154299394,
        NS_ERROR_SIGNED_JAR_UNSIGNED_ENTRY = 2154299395,
        NS_ERROR_SIGNED_JAR_ENTRY_MISSING = 2154299396,
        NS_ERROR_SIGNED_JAR_WRONG_SIGNATURE = 2154299397,
        NS_ERROR_SIGNED_JAR_ENTRY_TOO_LARGE = 2154299398,
        NS_ERROR_SIGNED_JAR_ENTRY_INVALID = 2154299399,
        NS_ERROR_SIGNED_JAR_MANIFEST_INVALID = 2154299400,
        NS_ERROR_DOM_FILESYSTEM_INVALID_PATH_ERR = 2154364929,
        NS_ERROR_DOM_FILESYSTEM_INVALID_MODIFICATION_ERR = 2154364930,
        NS_ERROR_DOM_FILESYSTEM_NO_MODIFICATION_ALLOWED_ERR = 2154364931,
        NS_ERROR_DOM_FILESYSTEM_PATH_EXISTS_ERR = 2154364932,
        NS_ERROR_DOM_FILESYSTEM_TYPE_MISMATCH_ERR = 2154364933,
        NS_ERROR_DOM_FILESYSTEM_UNKNOWN_ERR = 2154364934,
        NS_ERROR_SIGNED_APP_MANIFEST_INVALID = 2154496001,
        NS_ERROR_DOM_ANIM_MISSING_PROPS_ERR = 2154561537,
        NS_ERROR_DOM_PUSH_INVALID_REGISTRATION_ERR = 2154627073,
        NS_ERROR_DOM_PUSH_DENIED_ERR = 2154627074,
        NS_ERROR_DOM_PUSH_ABORT_ERR = 2154627075,
        NS_ERROR_DOM_PUSH_SERVICE_UNREACHABLE = 2154627076,
        NS_ERROR_DOM_PUSH_INVALID_KEY_ERR = 2154627077,
        NS_ERROR_DOM_PUSH_MISMATCHED_KEY_ERR = 2154627078,
        NS_ERROR_DOM_PUSH_GCM_DISABLED = 2154627079,
        NS_ERROR_DOM_MEDIA_ABORT_ERR = 2154692609,
        NS_ERROR_DOM_MEDIA_NOT_ALLOWED_ERR = 2154692610,
        NS_ERROR_DOM_MEDIA_NOT_SUPPORTED_ERR = 2154692611,
        NS_ERROR_DOM_MEDIA_DECODE_ERR = 2154692612,
        NS_ERROR_DOM_MEDIA_FATAL_ERR = 2154692613,
        NS_ERROR_DOM_MEDIA_METADATA_ERR = 2154692614,
        NS_ERROR_DOM_MEDIA_OVERFLOW_ERR = 2154692615,
        NS_ERROR_DOM_MEDIA_END_OF_STREAM = 2154692616,
        NS_ERROR_DOM_MEDIA_WAITING_FOR_DATA = 2154692617,
        NS_ERROR_DOM_MEDIA_CANCELED = 2154692618,
        NS_ERROR_DOM_MEDIA_MEDIASINK_ERR = 2154692619,
        NS_ERROR_DOM_MEDIA_DEMUXER_ERR = 2154692620,
        NS_ERROR_DOM_MEDIA_CDM_ERR = 2154692621,
        NS_ERROR_DOM_MEDIA_NEED_NEW_DECODER = 2154692622,
        NS_ERROR_DOM_MEDIA_INITIALIZING_DECODER = 2154692623,
        NS_ERROR_DOM_MEDIA_CUBEB_INITIALIZATION_ERR = 2154692709,
        NS_ERROR_UC_UPDATE_UNKNOWN = 2154758145,
        NS_ERROR_UC_UPDATE_DUPLICATE_PREFIX = 2154758146,
        NS_ERROR_UC_UPDATE_INFINITE_LOOP = 2154758147,
        NS_ERROR_UC_UPDATE_WRONG_REMOVAL_INDICES = 2154758148,
        NS_ERROR_UC_UPDATE_CHECKSUM_MISMATCH = 2154758149,
        NS_ERROR_UC_UPDATE_MISSING_CHECKSUM = 2154758150,
        NS_ERROR_UC_UPDATE_SHUTDOWNING = 2154758151,
        NS_ERROR_UC_UPDATE_TABLE_NOT_FOUND = 2154758152,
        NS_ERROR_UC_UPDATE_BUILD_PREFIX_FAILURE = 2154758153,
        NS_ERROR_UC_UPDATE_FAIL_TO_WRITE_DISK = 2154758154,
        NS_ERROR_UC_PARSER_MISSING_PARAM = 2154758156,
        NS_ERROR_UC_PARSER_DECODE_FAILURE = 2154758157,
        NS_ERROR_UC_PARSER_UNKNOWN_THREAT = 2154758158,
        NS_ERROR_INTERNAL_ERRORRESULT_JS_EXCEPTION = 2154823681,
        NS_ERROR_INTERNAL_ERRORRESULT_DOMEXCEPTION = 2154823682,
        NS_ERROR_INTERNAL_ERRORRESULT_EXCEPTION_ON_JSCONTEXT = 2154823683,
        NS_ERROR_INTERNAL_ERRORRESULT_TYPEERROR = 2154823684,
        NS_ERROR_INTERNAL_ERRORRESULT_RANGEERROR = 2154823685,
        NS_ERROR_DOWNLOAD_COMPLETE = 2155347969,
        NS_ERROR_DOWNLOAD_NOT_PARTIAL = 2155347970,
        NS_ERROR_UNORM_MOREOUTPUT = 2155348001,
        NS_ERROR_DOCSHELL_REQUEST_REJECTED = 2155348969,
        NS_ERROR_DOCUMENT_IS_PRINTMODE = 2155349969,
        NS_SUCCESS_DONT_FIXUP = 7864321,
        NS_SUCCESS_RESTART_APP_NOT_SAME_PROFILE = 7864323,
        NS_SUCCESS_UNORM_NOTFOUND = 7864337,
        NS_ERROR_NOT_IN_TREE = 2155348006,
        NS_OK_NO_NAME_CLAUSE_HANDLED = 7864354,
        NS_ERROR_BLOCKED_BY_POLICY = 2155347971,
    }
    pub type nsrefcnt = root::MozRefCountType;
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIFrame {
        _unused: [u8; 0],
    }
    impl Clone for nsIFrame {
        fn clone(&self) -> Self {
            *self
        }
    }
    pub type nsAString = root::nsTSubstring<u16>;
    pub type nsAutoString = [u64; 19usize];
    pub type nsACString = root::nsTSubstring<::std::os::raw::c_char>;
    pub type nsCString = root::nsTString<::std::os::raw::c_char>;
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsCharTraits {
        pub _address: u8,
    }
    /// @see nsTAString
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsReadingIterator<CharT> {
        pub mStart: *mut CharT,
        pub mEnd: *mut CharT,
        pub mPosition: *mut CharT,
        pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<CharT>>,
    }
    pub type nsReadingIterator_self_type<CharT> = root::nsReadingIterator<CharT>;
    pub type nsReadingIterator_difference_type = isize;
    pub type nsReadingIterator_size_type = usize;
    pub type nsReadingIterator_value_type<CharT> = CharT;
    pub type nsReadingIterator_pointer<CharT> = *mut CharT;
    pub type nsReadingIterator_reference = u8;
    /// @see nsTAString
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsWritingIterator<CharT> {
        pub mStart: *mut CharT,
        pub mEnd: *mut CharT,
        pub mPosition: *mut CharT,
        pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<CharT>>,
    }
    pub type nsWritingIterator_self_type<CharT> = root::nsWritingIterator<CharT>;
    pub type nsWritingIterator_difference_type = isize;
    pub type nsWritingIterator_size_type = usize;
    pub type nsWritingIterator_value_type<CharT> = CharT;
    pub type nsWritingIterator_pointer<CharT> = *mut CharT;
    pub type nsWritingIterator_reference = u8;
    #[repr(C)]
    pub struct nsTStringComparator__bindgen_vtable(::std::os::raw::c_void);
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsTStringComparator {
        pub vtable_: *const nsTStringComparator__bindgen_vtable,
    }
    pub type nsTStringComparator_char_type<T> = T;
    /// nsTSubstring is an abstract string class. From an API perspective, this
    /// class is the root of the string class hierarchy. It represents a single
    /// contiguous array of characters, which may or may not be null-terminated.
    /// This type is not instantiated directly. A sub-class is instantiated
    /// instead. For example, see nsTString.
    ///
    /// NAMES:
    /// nsAString for wide characters
    /// nsACString for narrow characters
    ///
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsTSubstring<T> {
        pub _base: root::mozilla::detail::nsTStringRepr<T>,
        pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
    }
    pub type nsTSubstring_self_type<T> = root::nsTSubstring<T>;
    pub type nsTSubstring_string_type<T> = root::nsTString<T>;
    pub type nsTSubstring_base_string_type<T> = root::mozilla::detail::nsTStringRepr<T>;
    pub type nsTSubstring_substring_type<T> = root::nsTSubstring_base_string_type<T>;
    pub type nsTSubstring_literalstring_type<T> = root::nsTSubstring_base_string_type<T>;
    pub type nsTSubstring_fallible_t<T> = root::nsTSubstring_base_string_type<T>;
    pub type nsTSubstring_char_type<T> = root::nsTSubstring_base_string_type<T>;
    pub type nsTSubstring_substring_tuple_type<T> = root::nsTSubstring_base_string_type<T>;
    pub type nsTSubstring_const_iterator<T> = root::nsTSubstring_base_string_type<T>;
    pub type nsTSubstring_iterator<T> = root::nsTSubstring_base_string_type<T>;
    pub type nsTSubstring_comparator_type<T> = root::nsTSubstring_base_string_type<T>;
    pub type nsTSubstring_char_iterator<T> = root::nsTSubstring_base_string_type<T>;
    pub type nsTSubstring_const_char_iterator<T> = root::nsTSubstring_base_string_type<T>;
    pub type nsTSubstring_index_type<T> = root::nsTSubstring_base_string_type<T>;
    pub type nsTSubstring_size_type<T> = root::nsTSubstring_base_string_type<T>;
    pub type nsTSubstring_DataFlags<T> = root::nsTSubstring_base_string_type<T>;
    pub type nsTSubstring_ClassFlags<T> = root::nsTSubstring_base_string_type<T>;
    /// nsTSubstringTuple
    ///
    /// Represents a tuple of string fragments.  Built as a recursive binary tree.
    /// It is used to implement the concatenation of two or more string objects.
    ///
    /// NOTE: This class is a private implementation detail and should never be
    /// referenced outside the string code.
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsTSubstringTuple<T> {
        pub mHead: *const root::nsTSubstringTuple_self_type<T>,
        pub mFragA: *const root::nsTSubstringTuple_base_string_type<T>,
        pub mFragB: *const root::nsTSubstringTuple_base_string_type<T>,
        pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
    }
    pub type nsTSubstringTuple_char_type<T> = T;
    pub type nsTSubstringTuple_self_type<T> = root::nsTSubstringTuple<T>;
    pub type nsTSubstringTuple_base_string_type<T> =
        root::mozilla::detail::nsTStringRepr<root::nsTSubstringTuple_char_type<T>>;
    pub type nsTSubstringTuple_size_type = u32;
    /// nsTLiteralString_CharT
    ///
    /// Stores a null-terminated, immutable sequence of characters.
    ///
    /// nsTString-lookalike that restricts its string value to a literal character
    /// sequence. Can be implicitly cast to const nsTString& (the const is
    /// essential, since this class's data are not writable). The data are assumed
    /// to be static (permanent) and therefore, as an optimization, this class
    /// does not have a destructor.
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsTLiteralString<T> {
        pub _base: root::mozilla::detail::nsTStringRepr<T>,
        pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
    }
    pub type nsTLiteralString_self_type<T> = root::nsTLiteralString<T>;
    pub type nsTLiteralString_char_type = [u8; 0usize];
    pub type nsTLiteralString_size_type = [u8; 0usize];
    pub type nsTLiteralString_DataFlags = [u8; 0usize];
    pub type nsTLiteralString_ClassFlags = [u8; 0usize];
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsTLiteralString_raw_type {
        pub _address: u8,
    }
    pub type nsTLiteralString_raw_type_type<N> = *mut N;
    /// This is the canonical null-terminated string class.  All subclasses
    /// promise null-terminated storage.  Instances of this class allocate
    /// strings on the heap.
    ///
    /// NAMES:
    /// nsString for wide characters
    /// nsCString for narrow characters
    ///
    /// This class is also known as nsAFlat[C]String, where "flat" is used
    /// to denote a null-terminated string.
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsTString<T> {
        pub _base: root::nsTSubstring<T>,
        pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
    }
    pub type nsTString_self_type<T> = root::nsTString<T>;
    pub type nsTString_literalstring_type = [u8; 0usize];
    pub type nsTString_fallible_t = [u8; 0usize];
    pub type nsTString_char_type = [u8; 0usize];
    pub type nsTString_substring_tuple_type = [u8; 0usize];
    pub type nsTString_const_iterator = [u8; 0usize];
    pub type nsTString_iterator = [u8; 0usize];
    pub type nsTString_comparator_type = [u8; 0usize];
    pub type nsTString_char_iterator = [u8; 0usize];
    pub type nsTString_const_char_iterator = [u8; 0usize];
    pub type nsTString_index_type = [u8; 0usize];
    pub type nsTString_size_type = [u8; 0usize];
    pub type nsTString_DataFlags = [u8; 0usize];
    pub type nsTString_ClassFlags = [u8; 0usize];
    /// returns the null-terminated string
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsTString_raw_type {
        pub _address: u8,
    }
    pub type nsTString_raw_type_type<U> = *mut U;
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsTString_Segment {
        pub mBegin: u32,
        pub mLength: u32,
    }
    pub type nsTAutoStringN_self_type = u8;
    pub type nsTAutoStringN_base_string_type<T> = root::nsTString<T>;
    pub type nsTAutoStringN_string_type<T> = root::nsTAutoStringN_base_string_type<T>;
    pub type nsTAutoStringN_char_type<T> = root::nsTAutoStringN_base_string_type<T>;
    pub type nsTAutoStringN_substring_type<T> = root::nsTAutoStringN_base_string_type<T>;
    pub type nsTAutoStringN_size_type<T> = root::nsTAutoStringN_base_string_type<T>;
    pub type nsTAutoStringN_substring_tuple_type<T> = root::nsTAutoStringN_base_string_type<T>;
    pub type nsTAutoStringN_literalstring_type<T> = root::nsTAutoStringN_base_string_type<T>;
    pub type nsTAutoStringN_DataFlags<T> = root::nsTAutoStringN_base_string_type<T>;
    pub type nsTAutoStringN_ClassFlags<T> = root::nsTAutoStringN_base_string_type<T>;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_Nothing:
        root::nsCSSTokenSerializationType = 0;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_Whitespace:
        root::nsCSSTokenSerializationType = 1;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_AtKeyword_or_Hash:
        root::nsCSSTokenSerializationType = 2;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_Number:
        root::nsCSSTokenSerializationType = 3;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_Dimension:
        root::nsCSSTokenSerializationType = 4;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_Percentage:
        root::nsCSSTokenSerializationType = 5;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_URange:
        root::nsCSSTokenSerializationType = 6;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_URL_or_BadURL:
        root::nsCSSTokenSerializationType = 7;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_Function:
        root::nsCSSTokenSerializationType = 8;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_Ident:
        root::nsCSSTokenSerializationType = 9;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_CDC:
        root::nsCSSTokenSerializationType = 10;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_DashMatch:
        root::nsCSSTokenSerializationType = 11;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_ContainsMatch:
        root::nsCSSTokenSerializationType = 12;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_Symbol_Hash:
        root::nsCSSTokenSerializationType = 13;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_Symbol_At:
        root::nsCSSTokenSerializationType = 14;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_Symbol_Dot_or_Plus:
        root::nsCSSTokenSerializationType = 15;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_Symbol_Minus:
        root::nsCSSTokenSerializationType = 16;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_Symbol_OpenParen:
        root::nsCSSTokenSerializationType = 17;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_Symbol_Question:
        root::nsCSSTokenSerializationType = 18;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_Symbol_Assorted:
        root::nsCSSTokenSerializationType = 19;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_Symbol_Equals:
        root::nsCSSTokenSerializationType = 20;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_Symbol_Bar:
        root::nsCSSTokenSerializationType = 21;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_Symbol_Slash:
        root::nsCSSTokenSerializationType = 22;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_Symbol_Asterisk:
        root::nsCSSTokenSerializationType = 23;
    pub const nsCSSTokenSerializationType_eCSSTokenSerialization_Other:
        root::nsCSSTokenSerializationType = 24;
    pub type nsCSSTokenSerializationType = u32;
    #[repr(C)]
    pub struct nsCSSScanner {
        pub mBuffer: *const u16,
        pub mOffset: u32,
        pub mCount: u32,
        pub mLineNumber: u32,
        pub mLineOffset: u32,
        pub mTokenLineNumber: u32,
        pub mTokenLineOffset: u32,
        pub mTokenOffset: u32,
        pub mRecordStartOffset: u32,
        pub mEOFCharacters: root::nsCSSScanner_EOFCharacters,
        pub mReporter: *mut root::mozilla::css::ErrorReporter,
        pub mRecording: bool,
        pub mSeenBadToken: bool,
        pub mSeenVariableReference: bool,
        pub mSourceMapURL: ::nsstring::nsStringRepr,
        pub mSourceURL: ::nsstring::nsStringRepr,
    }
    pub const nsCSSScanner_EOFCharacters_eEOFCharacters_None: root::nsCSSScanner_EOFCharacters = 0;
    pub const nsCSSScanner_EOFCharacters_eEOFCharacters_DropBackslash:
        root::nsCSSScanner_EOFCharacters = 1;
    pub const nsCSSScanner_EOFCharacters_eEOFCharacters_ReplacementChar:
        root::nsCSSScanner_EOFCharacters = 2;
    pub const nsCSSScanner_EOFCharacters_eEOFCharacters_Asterisk: root::nsCSSScanner_EOFCharacters =
        4;
    pub const nsCSSScanner_EOFCharacters_eEOFCharacters_Slash: root::nsCSSScanner_EOFCharacters = 8;
    pub const nsCSSScanner_EOFCharacters_eEOFCharacters_DoubleQuote:
        root::nsCSSScanner_EOFCharacters = 16;
    pub const nsCSSScanner_EOFCharacters_eEOFCharacters_SingleQuote:
        root::nsCSSScanner_EOFCharacters = 32;
    pub const nsCSSScanner_EOFCharacters_eEOFCharacters_CloseParen:
        root::nsCSSScanner_EOFCharacters = 64;
    pub type nsCSSScanner_EOFCharacters = u32;
    #[test]
    fn bindgen_test_layout_nsCSSScanner() {
        assert_eq!(
            ::std::mem::size_of::<nsCSSScanner>(),
            96usize,
            concat!("Size of: ", stringify!(nsCSSScanner))
        );
        assert_eq!(
            ::std::mem::align_of::<nsCSSScanner>(),
            8usize,
            concat!("Alignment of ", stringify!(nsCSSScanner))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsCSSScanner>())).mBuffer as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCSSScanner),
                "::",
                stringify!(mBuffer)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsCSSScanner>())).mOffset as *const _ as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCSSScanner),
                "::",
                stringify!(mOffset)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsCSSScanner>())).mCount as *const _ as usize },
            12usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCSSScanner),
                "::",
                stringify!(mCount)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsCSSScanner>())).mLineNumber as *const _ as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCSSScanner),
                "::",
                stringify!(mLineNumber)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsCSSScanner>())).mLineOffset as *const _ as usize },
            20usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCSSScanner),
                "::",
                stringify!(mLineOffset)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsCSSScanner>())).mTokenLineNumber as *const _ as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCSSScanner),
                "::",
                stringify!(mTokenLineNumber)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsCSSScanner>())).mTokenLineOffset as *const _ as usize
            },
            28usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCSSScanner),
                "::",
                stringify!(mTokenLineOffset)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsCSSScanner>())).mTokenOffset as *const _ as usize },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCSSScanner),
                "::",
                stringify!(mTokenOffset)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsCSSScanner>())).mRecordStartOffset as *const _ as usize
            },
            36usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCSSScanner),
                "::",
                stringify!(mRecordStartOffset)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsCSSScanner>())).mEOFCharacters as *const _ as usize },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCSSScanner),
                "::",
                stringify!(mEOFCharacters)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsCSSScanner>())).mReporter as *const _ as usize },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCSSScanner),
                "::",
                stringify!(mReporter)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsCSSScanner>())).mRecording as *const _ as usize },
            56usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCSSScanner),
                "::",
                stringify!(mRecording)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsCSSScanner>())).mSeenBadToken as *const _ as usize },
            57usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCSSScanner),
                "::",
                stringify!(mSeenBadToken)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsCSSScanner>())).mSeenVariableReference as *const _ as usize
            },
            58usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCSSScanner),
                "::",
                stringify!(mSeenVariableReference)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsCSSScanner>())).mSourceMapURL as *const _ as usize },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCSSScanner),
                "::",
                stringify!(mSourceMapURL)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsCSSScanner>())).mSourceURL as *const _ as usize },
            80usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCSSScanner),
                "::",
                stringify!(mSourceURL)
            )
        );
    }
    #[repr(C)]
    pub struct nsISupports__bindgen_vtable(::std::os::raw::c_void);
    /// Basic component object model interface. Objects which implement
    /// this interface support runtime interface discovery (QueryInterface)
    /// and a reference counted memory model (AddRef/Release). This is
    /// modelled after the win32 IUnknown API.
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsISupports {
        pub vtable_: *const nsISupports__bindgen_vtable,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsISupports_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsISupports() {
        assert_eq!(
            ::std::mem::size_of::<nsISupports>(),
            8usize,
            concat!("Size of: ", stringify!(nsISupports))
        );
        assert_eq!(
            ::std::mem::align_of::<nsISupports>(),
            8usize,
            concat!("Alignment of ", stringify!(nsISupports))
        );
    }
    impl Clone for nsISupports {
        fn clone(&self) -> Self {
            *self
        }
    }
    pub type PRUint32 = ::std::os::raw::c_uint;
    pub type PRIntn = ::std::os::raw::c_int;
    pub type PRUintn = ::std::os::raw::c_uint;
    /// TYPES:       PRSize
    /// DESCRIPTION:
    /// A type for representing the size of objects.
    pub type PRSize = usize;
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct PRThread {
        _unused: [u8; 0],
    }
    impl Clone for PRThread {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsCycleCollectingAutoRefCnt {
        pub mRefCntAndFlags: usize,
    }
    pub type nsCycleCollectingAutoRefCnt_Suspect = ::std::option::Option<
        unsafe extern "C" fn(
            aPtr: *mut ::std::os::raw::c_void,
            aCp: *mut root::nsCycleCollectionParticipant,
            aRefCnt: *mut root::nsCycleCollectingAutoRefCnt,
            aShouldDelete: *mut bool,
        ),
    >;
    #[test]
    fn bindgen_test_layout_nsCycleCollectingAutoRefCnt() {
        assert_eq!(
            ::std::mem::size_of::<nsCycleCollectingAutoRefCnt>(),
            8usize,
            concat!("Size of: ", stringify!(nsCycleCollectingAutoRefCnt))
        );
        assert_eq!(
            ::std::mem::align_of::<nsCycleCollectingAutoRefCnt>(),
            8usize,
            concat!("Alignment of ", stringify!(nsCycleCollectingAutoRefCnt))
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsCycleCollectingAutoRefCnt>())).mRefCntAndFlags as *const _
                    as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCycleCollectingAutoRefCnt),
                "::",
                stringify!(mRefCntAndFlags)
            )
        );
    }
    impl Clone for nsCycleCollectingAutoRefCnt {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsAutoRefCnt {
        pub mValue: root::nsrefcnt,
    }
    pub const nsAutoRefCnt_isThreadSafe: bool = false;
    #[test]
    fn bindgen_test_layout_nsAutoRefCnt() {
        assert_eq!(
            ::std::mem::size_of::<nsAutoRefCnt>(),
            8usize,
            concat!("Size of: ", stringify!(nsAutoRefCnt))
        );
        assert_eq!(
            ::std::mem::align_of::<nsAutoRefCnt>(),
            8usize,
            concat!("Alignment of ", stringify!(nsAutoRefCnt))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsAutoRefCnt>())).mValue as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsAutoRefCnt),
                "::",
                stringify!(mValue)
            )
        );
    }
    impl Clone for nsAutoRefCnt {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug)]
    pub struct RefPtr<T> {
        pub mRawPtr: *mut T,
        pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
    }
    pub type RefPtr_element_type<T> = T;
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct RefPtr_Proxy {
        pub _address: u8,
    }
    pub type RefPtr_Proxy_member_function = u8;
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct RefPtr_ConstRemovingRefPtrTraits {
        pub _address: u8,
    }
    pub mod JS {
        #[allow(unused_imports)]
        use self::super::super::root;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct DeletePolicy {
            pub _address: u8,
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct FreePolicy {
            pub _address: u8,
        }
        #[test]
        fn bindgen_test_layout_FreePolicy() {
            assert_eq!(
                ::std::mem::size_of::<FreePolicy>(),
                1usize,
                concat!("Size of: ", stringify!(FreePolicy))
            );
            assert_eq!(
                ::std::mem::align_of::<FreePolicy>(),
                1usize,
                concat!("Alignment of ", stringify!(FreePolicy))
            );
        }
        impl Clone for FreePolicy {
            fn clone(&self) -> Self {
                *self
            }
        }
        /// Local variable of type T whose value is always rooted. This is typically
        /// used for local variables, or for non-rooted values being passed to a
        /// function that requires a handle, e.g. Foo(Root<T>(cx, x)).
        ///
        /// If you want to add additional methods to Rooted for a specific
        /// specialization, define a RootedBase<T> specialization containing them.
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct Rooted {
            pub _address: u8,
        }
        pub type Rooted_ElementType<T> = T;
        pub mod dbg {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            #[repr(C)]
            #[derive(Debug)]
            pub struct GarbageCollectionEvent {
                pub majorGCNumber_: u64,
                pub reason: *const ::std::os::raw::c_char,
                pub nonincrementalReason: *const ::std::os::raw::c_char,
                pub collections: [u64; 3usize],
            }
            #[repr(C)]
            #[derive(Debug, Copy)]
            pub struct GarbageCollectionEvent_Collection {
                pub startTimestamp: root::mozilla::TimeStamp,
                pub endTimestamp: root::mozilla::TimeStamp,
            }
            #[test]
            fn bindgen_test_layout_GarbageCollectionEvent_Collection() {
                assert_eq!(
                    ::std::mem::size_of::<GarbageCollectionEvent_Collection>(),
                    16usize,
                    concat!("Size of: ", stringify!(GarbageCollectionEvent_Collection))
                );
                assert_eq!(
                    ::std::mem::align_of::<GarbageCollectionEvent_Collection>(),
                    8usize,
                    concat!(
                        "Alignment of ",
                        stringify!(GarbageCollectionEvent_Collection)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<GarbageCollectionEvent_Collection>())).startTimestamp
                            as *const _ as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GarbageCollectionEvent_Collection),
                        "::",
                        stringify!(startTimestamp)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<GarbageCollectionEvent_Collection>())).endTimestamp
                            as *const _ as usize
                    },
                    8usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GarbageCollectionEvent_Collection),
                        "::",
                        stringify!(endTimestamp)
                    )
                );
            }
            impl Clone for GarbageCollectionEvent_Collection {
                fn clone(&self) -> Self {
                    *self
                }
            }
            pub type GarbageCollectionEvent_Ptr =
                root::mozilla::UniquePtr<root::JS::dbg::GarbageCollectionEvent>;
            #[test]
            fn bindgen_test_layout_GarbageCollectionEvent() {
                assert_eq!(
                    ::std::mem::size_of::<GarbageCollectionEvent>(),
                    48usize,
                    concat!("Size of: ", stringify!(GarbageCollectionEvent))
                );
                assert_eq!(
                    ::std::mem::align_of::<GarbageCollectionEvent>(),
                    8usize,
                    concat!("Alignment of ", stringify!(GarbageCollectionEvent))
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<GarbageCollectionEvent>())).majorGCNumber_
                            as *const _ as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GarbageCollectionEvent),
                        "::",
                        stringify!(majorGCNumber_)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<GarbageCollectionEvent>())).reason as *const _
                            as usize
                    },
                    8usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GarbageCollectionEvent),
                        "::",
                        stringify!(reason)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<GarbageCollectionEvent>())).nonincrementalReason
                            as *const _ as usize
                    },
                    16usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GarbageCollectionEvent),
                        "::",
                        stringify!(nonincrementalReason)
                    )
                );
                assert_eq!(
                    unsafe {
                        &(*(::std::ptr::null::<GarbageCollectionEvent>())).collections as *const _
                            as usize
                    },
                    24usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GarbageCollectionEvent),
                        "::",
                        stringify!(collections)
                    )
                );
            }
        }
        pub type Value_PayloadType = u64;
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct Value_layout {
            pub asBits: root::__BindgenUnionField<u64>,
            pub debugView: root::__BindgenUnionField<root::JS::Value_layout__bindgen_ty_1>,
            pub s: root::__BindgenUnionField<root::JS::Value_layout__bindgen_ty_2>,
            pub asDouble: root::__BindgenUnionField<f64>,
            pub asPtr: root::__BindgenUnionField<*mut ::std::os::raw::c_void>,
            pub asWord: root::__BindgenUnionField<usize>,
            pub asUIntPtr: root::__BindgenUnionField<usize>,
            pub bindgen_union_field: u64,
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct Value_layout__bindgen_ty_1 {
            pub _bitfield_1: root::__BindgenBitfieldUnit<[u8; 8usize], u64>,
            pub __bindgen_align: [u64; 0usize],
        }
        #[test]
        fn bindgen_test_layout_Value_layout__bindgen_ty_1() {
            assert_eq!(
                ::std::mem::size_of::<Value_layout__bindgen_ty_1>(),
                8usize,
                concat!("Size of: ", stringify!(Value_layout__bindgen_ty_1))
            );
            assert_eq!(
                ::std::mem::align_of::<Value_layout__bindgen_ty_1>(),
                8usize,
                concat!("Alignment of ", stringify!(Value_layout__bindgen_ty_1))
            );
        }
        impl Clone for Value_layout__bindgen_ty_1 {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl Value_layout__bindgen_ty_1 {
            #[inline]
            pub fn payload47(&self) -> u64 {
                unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 47u8) as u64) }
            }
            #[inline]
            pub fn set_payload47(&mut self, val: u64) {
                unsafe {
                    let val: u64 = ::std::mem::transmute(val);
                    self._bitfield_1.set(0usize, 47u8, val as u64)
                }
            }
            #[inline]
            pub fn tag(&self) -> root::JSValueTag {
                unsafe { ::std::mem::transmute(self._bitfield_1.get(47usize, 17u8) as u32) }
            }
            #[inline]
            pub fn set_tag(&mut self, val: root::JSValueTag) {
                unsafe {
                    let val: u32 = ::std::mem::transmute(val);
                    self._bitfield_1.set(47usize, 17u8, val as u64)
                }
            }
            #[inline]
            pub fn new_bitfield_1(
                payload47: u64,
                tag: root::JSValueTag,
            ) -> root::__BindgenBitfieldUnit<[u8; 8usize], u64> {
                let mut __bindgen_bitfield_unit: root::__BindgenBitfieldUnit<
                    [u8; 8usize],
                    u64,
                > = Default::default();
                __bindgen_bitfield_unit.set(0usize, 47u8, {
                    let payload47: u64 = unsafe { ::std::mem::transmute(payload47) };
                    payload47 as u64
                });
                __bindgen_bitfield_unit.set(47usize, 17u8, {
                    let tag: u32 = unsafe { ::std::mem::transmute(tag) };
                    tag as u64
                });
                __bindgen_bitfield_unit
            }
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct Value_layout__bindgen_ty_2 {
            pub payload: root::JS::Value_layout__bindgen_ty_2__bindgen_ty_1,
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct Value_layout__bindgen_ty_2__bindgen_ty_1 {
            pub i32: root::__BindgenUnionField<i32>,
            pub u32: root::__BindgenUnionField<u32>,
            pub why: root::__BindgenUnionField<root::JSWhyMagic>,
            pub bindgen_union_field: u32,
        }
        #[test]
        fn bindgen_test_layout_Value_layout__bindgen_ty_2__bindgen_ty_1() {
            assert_eq!(
                ::std::mem::size_of::<Value_layout__bindgen_ty_2__bindgen_ty_1>(),
                4usize,
                concat!(
                    "Size of: ",
                    stringify!(Value_layout__bindgen_ty_2__bindgen_ty_1)
                )
            );
            assert_eq!(
                ::std::mem::align_of::<Value_layout__bindgen_ty_2__bindgen_ty_1>(),
                4usize,
                concat!(
                    "Alignment of ",
                    stringify!(Value_layout__bindgen_ty_2__bindgen_ty_1)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<Value_layout__bindgen_ty_2__bindgen_ty_1>())).i32
                        as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Value_layout__bindgen_ty_2__bindgen_ty_1),
                    "::",
                    stringify!(i32)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<Value_layout__bindgen_ty_2__bindgen_ty_1>())).u32
                        as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Value_layout__bindgen_ty_2__bindgen_ty_1),
                    "::",
                    stringify!(u32)
                )
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<Value_layout__bindgen_ty_2__bindgen_ty_1>())).why
                        as *const _ as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Value_layout__bindgen_ty_2__bindgen_ty_1),
                    "::",
                    stringify!(why)
                )
            );
        }
        impl Clone for Value_layout__bindgen_ty_2__bindgen_ty_1 {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[test]
        fn bindgen_test_layout_Value_layout__bindgen_ty_2() {
            assert_eq!(
                ::std::mem::size_of::<Value_layout__bindgen_ty_2>(),
                4usize,
                concat!("Size of: ", stringify!(Value_layout__bindgen_ty_2))
            );
            assert_eq!(
                ::std::mem::align_of::<Value_layout__bindgen_ty_2>(),
                4usize,
                concat!("Alignment of ", stringify!(Value_layout__bindgen_ty_2))
            );
            assert_eq!(
                unsafe {
                    &(*(::std::ptr::null::<Value_layout__bindgen_ty_2>())).payload as *const _
                        as usize
                },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Value_layout__bindgen_ty_2),
                    "::",
                    stringify!(payload)
                )
            );
        }
        impl Clone for Value_layout__bindgen_ty_2 {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[test]
        fn bindgen_test_layout_Value_layout() {
            assert_eq!(
                ::std::mem::size_of::<Value_layout>(),
                8usize,
                concat!("Size of: ", stringify!(Value_layout))
            );
            assert_eq!(
                ::std::mem::align_of::<Value_layout>(),
                8usize,
                concat!("Alignment of ", stringify!(Value_layout))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<Value_layout>())).asBits as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Value_layout),
                    "::",
                    stringify!(asBits)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<Value_layout>())).debugView as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Value_layout),
                    "::",
                    stringify!(debugView)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<Value_layout>())).s as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Value_layout),
                    "::",
                    stringify!(s)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<Value_layout>())).asDouble as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Value_layout),
                    "::",
                    stringify!(asDouble)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<Value_layout>())).asPtr as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Value_layout),
                    "::",
                    stringify!(asPtr)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<Value_layout>())).asWord as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Value_layout),
                    "::",
                    stringify!(asWord)
                )
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<Value_layout>())).asUIntPtr as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(Value_layout),
                    "::",
                    stringify!(asUIntPtr)
                )
            );
        }
        impl Clone for Value_layout {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct ConstUTF8CharsZ {
            pub data_: *const ::std::os::raw::c_char,
        }
        pub type ConstUTF8CharsZ_CharT = ::std::os::raw::c_uchar;
        #[test]
        fn bindgen_test_layout_ConstUTF8CharsZ() {
            assert_eq!(
                ::std::mem::size_of::<ConstUTF8CharsZ>(),
                8usize,
                concat!("Size of: ", stringify!(ConstUTF8CharsZ))
            );
            assert_eq!(
                ::std::mem::align_of::<ConstUTF8CharsZ>(),
                8usize,
                concat!("Alignment of ", stringify!(ConstUTF8CharsZ))
            );
            assert_eq!(
                unsafe { &(*(::std::ptr::null::<ConstUTF8CharsZ>())).data_ as *const _ as usize },
                0usize,
                concat!(
                    "Offset of field: ",
                    stringify!(ConstUTF8CharsZ),
                    "::",
                    stringify!(data_)
                )
            );
        }
        impl Clone for ConstUTF8CharsZ {
            fn clone(&self) -> Self {
                *self
            }
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct JSContext {
        _unused: [u8; 0],
    }
    impl Clone for JSContext {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct JSObject {
        _unused: [u8; 0],
    }
    impl Clone for JSObject {
        fn clone(&self) -> Self {
            *self
        }
    }
    pub mod js {
        #[allow(unused_imports)]
        use self::super::super::root;
        pub mod gc {
            #[allow(unused_imports)]
            use self::super::super::super::root;
        }
        #[repr(C)]
        #[derive(Debug, Copy)]
        pub struct SystemAllocPolicy {
            pub _address: u8,
        }
        #[test]
        fn bindgen_test_layout_SystemAllocPolicy() {
            assert_eq!(
                ::std::mem::size_of::<SystemAllocPolicy>(),
                1usize,
                concat!("Size of: ", stringify!(SystemAllocPolicy))
            );
            assert_eq!(
                ::std::mem::align_of::<SystemAllocPolicy>(),
                1usize,
                concat!("Alignment of ", stringify!(SystemAllocPolicy))
            );
        }
        impl Clone for SystemAllocPolicy {
            fn clone(&self) -> Self {
                *self
            }
        }
        #[repr(C)]
        pub struct SourceHook__bindgen_vtable(::std::os::raw::c_void);
        /// A class of objects that return source code on demand.
        ///
        /// When code is compiled with setSourceIsLazy(true), SpiderMonkey doesn't
        /// retain the source code (and doesn't do lazy bytecode generation). If we ever
        /// need the source code, say, in response to a call to Function.prototype.
        /// toSource or Debugger.Source.prototype.text, then we call the 'load' member
        /// function of the instance of this class that has hopefully been registered
        /// with the runtime, passing the code's URL, and hope that it will be able to
        /// find the source.
        #[repr(C)]
        #[derive(Debug)]
        pub struct SourceHook {
            pub vtable_: *const SourceHook__bindgen_vtable,
        }
        #[test]
        fn bindgen_test_layout_SourceHook() {
            assert_eq!(
                ::std::mem::size_of::<SourceHook>(),
                8usize,
                concat!("Size of: ", stringify!(SourceHook))
            );
            assert_eq!(
                ::std::mem::align_of::<SourceHook>(),
                8usize,
                concat!("Alignment of ", stringify!(SourceHook))
            );
        }
    }
    /// Factors implementation for all template versions of nsCOMPtr.
    ///
    /// Here's the way people normally do things like this:
    ///
    /// template<class T> class Foo { ... };
    /// template<> class Foo<void*> { ... };
    /// template<class T> class Foo<T*> : private Foo<void*> { ... };
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsCOMPtr_base {
        pub mRawPtr: *mut root::nsISupports,
    }
    #[test]
    fn bindgen_test_layout_nsCOMPtr_base() {
        assert_eq!(
            ::std::mem::size_of::<nsCOMPtr_base>(),
            8usize,
            concat!("Size of: ", stringify!(nsCOMPtr_base))
        );
        assert_eq!(
            ::std::mem::align_of::<nsCOMPtr_base>(),
            8usize,
            concat!("Alignment of ", stringify!(nsCOMPtr_base))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsCOMPtr_base>())).mRawPtr as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCOMPtr_base),
                "::",
                stringify!(mRawPtr)
            )
        );
    }
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsCOMPtr {
        pub _base: root::nsCOMPtr_base,
    }
    pub type nsCOMPtr_element_type<T> = T;
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsAutoPtr<T> {
        pub mRawPtr: *mut T,
        pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsAutoPtr_Ptr<T> {
        pub mPtr: *mut T,
        pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
    }
    pub type nsAutoPtr_element_type<T> = T;
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsAutoPtr_Proxy {
        pub _address: u8,
    }
    pub type nsAutoPtr_Proxy_member_function = u8;
    pub type PLDHashNumber = u32;
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct PLDHashEntryHdr {
        pub mKeyHash: root::PLDHashNumber,
    }
    #[test]
    fn bindgen_test_layout_PLDHashEntryHdr() {
        assert_eq!(
            ::std::mem::size_of::<PLDHashEntryHdr>(),
            4usize,
            concat!("Size of: ", stringify!(PLDHashEntryHdr))
        );
        assert_eq!(
            ::std::mem::align_of::<PLDHashEntryHdr>(),
            4usize,
            concat!("Alignment of ", stringify!(PLDHashEntryHdr))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLDHashEntryHdr>())).mKeyHash as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashEntryHdr),
                "::",
                stringify!(mKeyHash)
            )
        );
    }
    impl Clone for PLDHashEntryHdr {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug)]
    pub struct PLDHashTable {
        pub mOps: *const root::PLDHashTableOps,
        pub mEntryStore: root::PLDHashTable_EntryStore,
        pub mGeneration: u16,
        pub mHashShift: u8,
        pub mEntrySize: u8,
        pub mEntryCount: u32,
        pub mRemovedCount: u32,
    }
    #[repr(C)]
    #[derive(Debug)]
    pub struct PLDHashTable_EntryStore {
        pub mEntryStore: *mut ::std::os::raw::c_char,
    }
    #[test]
    fn bindgen_test_layout_PLDHashTable_EntryStore() {
        assert_eq!(
            ::std::mem::size_of::<PLDHashTable_EntryStore>(),
            8usize,
            concat!("Size of: ", stringify!(PLDHashTable_EntryStore))
        );
        assert_eq!(
            ::std::mem::align_of::<PLDHashTable_EntryStore>(),
            8usize,
            concat!("Alignment of ", stringify!(PLDHashTable_EntryStore))
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<PLDHashTable_EntryStore>())).mEntryStore as *const _ as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTable_EntryStore),
                "::",
                stringify!(mEntryStore)
            )
        );
    }
    #[repr(C)]
    #[derive(Debug)]
    pub struct PLDHashTable_Iterator {
        pub mTable: *mut root::PLDHashTable,
        pub mStart: *mut ::std::os::raw::c_char,
        pub mLimit: *mut ::std::os::raw::c_char,
        pub mCurrent: *mut ::std::os::raw::c_char,
        pub mNexts: u32,
        pub mNextsLimit: u32,
        pub mHaveRemoved: bool,
    }
    #[test]
    fn bindgen_test_layout_PLDHashTable_Iterator() {
        assert_eq!(
            ::std::mem::size_of::<PLDHashTable_Iterator>(),
            48usize,
            concat!("Size of: ", stringify!(PLDHashTable_Iterator))
        );
        assert_eq!(
            ::std::mem::align_of::<PLDHashTable_Iterator>(),
            8usize,
            concat!("Alignment of ", stringify!(PLDHashTable_Iterator))
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<PLDHashTable_Iterator>())).mTable as *const _ as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTable_Iterator),
                "::",
                stringify!(mTable)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<PLDHashTable_Iterator>())).mStart as *const _ as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTable_Iterator),
                "::",
                stringify!(mStart)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<PLDHashTable_Iterator>())).mLimit as *const _ as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTable_Iterator),
                "::",
                stringify!(mLimit)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<PLDHashTable_Iterator>())).mCurrent as *const _ as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTable_Iterator),
                "::",
                stringify!(mCurrent)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<PLDHashTable_Iterator>())).mNexts as *const _ as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTable_Iterator),
                "::",
                stringify!(mNexts)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<PLDHashTable_Iterator>())).mNextsLimit as *const _ as usize
            },
            36usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTable_Iterator),
                "::",
                stringify!(mNextsLimit)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<PLDHashTable_Iterator>())).mHaveRemoved as *const _ as usize
            },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTable_Iterator),
                "::",
                stringify!(mHaveRemoved)
            )
        );
    }
    pub const PLDHashTable_SearchReason_ForSearchOrRemove: root::PLDHashTable_SearchReason = 0;
    pub const PLDHashTable_SearchReason_ForAdd: root::PLDHashTable_SearchReason = 1;
    pub type PLDHashTable_SearchReason = u32;
    pub const PLDHashTable_kMaxCapacity: u32 = 67108864;
    pub const PLDHashTable_kMinCapacity: u32 = 8;
    pub const PLDHashTable_kMaxInitialLength: u32 = 33554432;
    pub const PLDHashTable_kDefaultInitialLength: u32 = 4;
    pub const PLDHashTable_kHashBits: u32 = 32;
    pub const PLDHashTable_kGoldenRatio: u32 = 2654435769;
    pub const PLDHashTable_kCollisionFlag: root::PLDHashNumber = 1;
    #[test]
    fn bindgen_test_layout_PLDHashTable() {
        assert_eq!(
            ::std::mem::size_of::<PLDHashTable>(),
            32usize,
            concat!("Size of: ", stringify!(PLDHashTable))
        );
        assert_eq!(
            ::std::mem::align_of::<PLDHashTable>(),
            8usize,
            concat!("Alignment of ", stringify!(PLDHashTable))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLDHashTable>())).mOps as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTable),
                "::",
                stringify!(mOps)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLDHashTable>())).mEntryStore as *const _ as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTable),
                "::",
                stringify!(mEntryStore)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLDHashTable>())).mGeneration as *const _ as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTable),
                "::",
                stringify!(mGeneration)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLDHashTable>())).mHashShift as *const _ as usize },
            18usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTable),
                "::",
                stringify!(mHashShift)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLDHashTable>())).mEntrySize as *const _ as usize },
            19usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTable),
                "::",
                stringify!(mEntrySize)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLDHashTable>())).mEntryCount as *const _ as usize },
            20usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTable),
                "::",
                stringify!(mEntryCount)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLDHashTable>())).mRemovedCount as *const _ as usize },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTable),
                "::",
                stringify!(mRemovedCount)
            )
        );
    }
    pub type PLDHashHashKey = ::std::option::Option<
        unsafe extern "C" fn(aKey: *const ::std::os::raw::c_void) -> root::PLDHashNumber,
    >;
    pub type PLDHashMatchEntry = ::std::option::Option<
        unsafe extern "C" fn(
            aEntry: *const root::PLDHashEntryHdr,
            aKey: *const ::std::os::raw::c_void,
        ) -> bool,
    >;
    pub type PLDHashMoveEntry = ::std::option::Option<
        unsafe extern "C" fn(
            aTable: *mut root::PLDHashTable,
            aFrom: *const root::PLDHashEntryHdr,
            aTo: *mut root::PLDHashEntryHdr,
        ),
    >;
    pub type PLDHashClearEntry = ::std::option::Option<
        unsafe extern "C" fn(aTable: *mut root::PLDHashTable, aEntry: *mut root::PLDHashEntryHdr),
    >;
    pub type PLDHashInitEntry = ::std::option::Option<
        unsafe extern "C" fn(
            aEntry: *mut root::PLDHashEntryHdr,
            aKey: *const ::std::os::raw::c_void,
        ),
    >;
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct PLDHashTableOps {
        pub hashKey: root::PLDHashHashKey,
        pub matchEntry: root::PLDHashMatchEntry,
        pub moveEntry: root::PLDHashMoveEntry,
        pub clearEntry: root::PLDHashClearEntry,
        pub initEntry: root::PLDHashInitEntry,
    }
    #[test]
    fn bindgen_test_layout_PLDHashTableOps() {
        assert_eq!(
            ::std::mem::size_of::<PLDHashTableOps>(),
            40usize,
            concat!("Size of: ", stringify!(PLDHashTableOps))
        );
        assert_eq!(
            ::std::mem::align_of::<PLDHashTableOps>(),
            8usize,
            concat!("Alignment of ", stringify!(PLDHashTableOps))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLDHashTableOps>())).hashKey as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTableOps),
                "::",
                stringify!(hashKey)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLDHashTableOps>())).matchEntry as *const _ as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTableOps),
                "::",
                stringify!(matchEntry)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLDHashTableOps>())).moveEntry as *const _ as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTableOps),
                "::",
                stringify!(moveEntry)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLDHashTableOps>())).clearEntry as *const _ as usize },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTableOps),
                "::",
                stringify!(clearEntry)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLDHashTableOps>())).initEntry as *const _ as usize },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(PLDHashTableOps),
                "::",
                stringify!(initEntry)
            )
        );
    }
    impl Clone for PLDHashTableOps {
        fn clone(&self) -> Self {
            *self
        }
    }
    /// hashkey wrapper using T* KeyType
    ///
    /// @see nsTHashtable::EntryType for specification
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsPtrHashKey<T> {
        pub _base: root::PLDHashEntryHdr,
        pub mKey: *mut T,
        pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
    }
    pub type nsPtrHashKey_KeyType<T> = *mut T;
    pub type nsPtrHashKey_KeyTypePointer<T> = *mut T;
    pub const nsPtrHashKey_ALLOW_MEMMOVE: root::nsPtrHashKey__bindgen_ty_1 = 0;
    pub type nsPtrHashKey__bindgen_ty_1 = i32;
    /// hashkey wrapper using nsAString KeyType
    ///
    /// @see nsTHashtable::EntryType for specification
    #[repr(C)]
    pub struct nsStringHashKey {
        pub _base: root::PLDHashEntryHdr,
        pub mStr: ::nsstring::nsStringRepr,
    }
    pub type nsStringHashKey_KeyType = *const root::nsAString;
    pub type nsStringHashKey_KeyTypePointer = *const root::nsAString;
    pub const nsStringHashKey_ALLOW_MEMMOVE: root::nsStringHashKey__bindgen_ty_1 = 1;
    pub type nsStringHashKey__bindgen_ty_1 = u32;
    #[test]
    fn bindgen_test_layout_nsStringHashKey() {
        assert_eq!(
            ::std::mem::size_of::<nsStringHashKey>(),
            24usize,
            concat!("Size of: ", stringify!(nsStringHashKey))
        );
        assert_eq!(
            ::std::mem::align_of::<nsStringHashKey>(),
            8usize,
            concat!("Alignment of ", stringify!(nsStringHashKey))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsStringHashKey>())).mStr as *const _ as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsStringHashKey),
                "::",
                stringify!(mStr)
            )
        );
    }
    /// hashkey wrapper using nsACString KeyType
    ///
    /// @see nsTHashtable::EntryType for specification
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsCStringHashKey {
        pub _base: root::PLDHashEntryHdr,
        pub mStr: root::nsCString,
    }
    pub type nsCStringHashKey_KeyType = *const root::nsACString;
    pub type nsCStringHashKey_KeyTypePointer = *const root::nsACString;
    pub const nsCStringHashKey_ALLOW_MEMMOVE: root::nsCStringHashKey__bindgen_ty_1 = 1;
    pub type nsCStringHashKey__bindgen_ty_1 = u32;
    #[test]
    fn bindgen_test_layout_nsCStringHashKey() {
        assert_eq!(
            ::std::mem::size_of::<nsCStringHashKey>(),
            24usize,
            concat!("Size of: ", stringify!(nsCStringHashKey))
        );
        assert_eq!(
            ::std::mem::align_of::<nsCStringHashKey>(),
            8usize,
            concat!("Alignment of ", stringify!(nsCStringHashKey))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsCStringHashKey>())).mStr as *const _ as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCStringHashKey),
                "::",
                stringify!(mStr)
            )
        );
    }
    /// hashkey wrapper using nsISupports* KeyType
    ///
    /// @see nsTHashtable::EntryType for specification
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsISupportsHashKey {
        pub _base: root::PLDHashEntryHdr,
        pub mSupports: root::nsCOMPtr,
    }
    pub type nsISupportsHashKey_KeyType = *mut root::nsISupports;
    pub type nsISupportsHashKey_KeyTypePointer = *const root::nsISupports;
    pub const nsISupportsHashKey_ALLOW_MEMMOVE: root::nsISupportsHashKey__bindgen_ty_1 = 1;
    pub type nsISupportsHashKey__bindgen_ty_1 = u32;
    #[test]
    fn bindgen_test_layout_nsISupportsHashKey() {
        assert_eq!(
            ::std::mem::size_of::<nsISupportsHashKey>(),
            16usize,
            concat!("Size of: ", stringify!(nsISupportsHashKey))
        );
        assert_eq!(
            ::std::mem::align_of::<nsISupportsHashKey>(),
            8usize,
            concat!("Alignment of ", stringify!(nsISupportsHashKey))
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsISupportsHashKey>())).mSupports as *const _ as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsISupportsHashKey),
                "::",
                stringify!(mSupports)
            )
        );
    }
    /// hashkey wrapper using refcounted * KeyType
    ///
    /// @see nsTHashtable::EntryType for specification
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsRefPtrHashKey<T> {
        pub _base: root::PLDHashEntryHdr,
        pub mKey: root::RefPtr<T>,
        pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
    }
    pub type nsRefPtrHashKey_KeyType<T> = *mut T;
    pub type nsRefPtrHashKey_KeyTypePointer<T> = *mut T;
    pub const nsRefPtrHashKey_ALLOW_MEMMOVE: root::nsRefPtrHashKey__bindgen_ty_1 = 0;
    pub type nsRefPtrHashKey__bindgen_ty_1 = i32;
    /// a base class for templated hashtables.
    ///
    /// Clients will rarely need to use this class directly. Check the derived
    /// classes first, to see if they will meet your needs.
    ///
    /// @param EntryType  the templated entry-type class that is managed by the
    /// hashtable. <code>EntryType</code> must extend the following declaration,
    /// and <strong>must not declare any virtual functions or derive from classes
    /// with virtual functions.</strong>  Any vtable pointer would break the
    /// PLDHashTable code.
    /// <pre>   class EntryType : public PLDHashEntryHdr
    /// {
    /// public: or friend nsTHashtable<EntryType>;
    /// // KeyType is what we use when Get()ing or Put()ing this entry
    /// // this should either be a simple datatype (uint32_t, nsISupports*) or
    /// // a const reference (const nsAString&)
    /// typedef something KeyType;
    /// // KeyTypePointer is the pointer-version of KeyType, because
    /// // PLDHashTable.h requires keys to cast to <code>const void*</code>
    /// typedef const something* KeyTypePointer;
    ///
    /// EntryType(KeyTypePointer aKey);
    ///
    /// // A copy or C++11 Move constructor must be defined, even if
    /// // AllowMemMove() == true, otherwise you will cause link errors.
    /// EntryType(const EntryType& aEnt);  // Either this...
    /// EntryType(EntryType&& aEnt);       // ...or this
    ///
    /// // the destructor must be defined... or you will cause link errors!
    /// ~EntryType();
    ///
    /// // KeyEquals(): does this entry match this key?
    /// bool KeyEquals(KeyTypePointer aKey) const;
    ///
    /// // KeyToPointer(): Convert KeyType to KeyTypePointer
    /// static KeyTypePointer KeyToPointer(KeyType aKey);
    ///
    /// // HashKey(): calculate the hash number
    /// static PLDHashNumber HashKey(KeyTypePointer aKey);
    ///
    /// // ALLOW_MEMMOVE can we move this class with memmove(), or do we have
    /// // to use the copy constructor?
    /// enum { ALLOW_MEMMOVE = true/false };
    /// }</pre>
    ///
    /// @see nsInterfaceHashtable
    /// @see nsDataHashtable
    /// @see nsClassHashtable
    /// @author "Benjamin Smedberg <bsmedberg@covad.net>"
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsTHashtable {
        pub _address: u8,
    }
    pub type nsTHashtable_fallible_t = root::mozilla::fallible_t;
    /// KeyType is typedef'ed for ease of use.
    pub type nsTHashtable_KeyType = [u8; 0usize];
    /// KeyTypePointer is typedef'ed for ease of use.
    pub type nsTHashtable_KeyTypePointer = [u8; 0usize];
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsTHashtable_Iterator {
        pub _base: root::PLDHashTable_Iterator,
    }
    pub type nsTHashtable_Iterator_Base = root::PLDHashTable_Iterator;
    /// the private nsTHashtable::EntryType class used by nsBaseHashtable
    /// @see nsTHashtable for the specification of this class
    /// @see nsBaseHashtable for template parameters
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsBaseHashtableET<KeyClass, DataType> {
        pub _base: KeyClass,
        pub mData: DataType,
        pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<KeyClass>>,
        pub _phantom_1: ::std::marker::PhantomData<::std::cell::UnsafeCell<DataType>>,
    }
    pub type nsBaseHashtableET_KeyType = [u8; 0usize];
    pub type nsBaseHashtableET_KeyTypePointer = [u8; 0usize];
    /// templated hashtable for simple data types
    /// This class manages simple data types that do not need construction or
    /// destruction.
    ///
    /// @param KeyClass a wrapper-class for the hashtable key, see nsHashKeys.h
    /// for a complete specification.
    /// @param DataType the datatype stored in the hashtable,
    /// for example, uint32_t or nsCOMPtr.  If UserDataType is not the same,
    /// DataType must implicitly cast to UserDataType
    /// @param UserDataType the user sees, for example uint32_t or nsISupports*
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsBaseHashtable {
        pub _address: u8,
    }
    pub type nsBaseHashtable_fallible_t = root::mozilla::fallible_t;
    pub type nsBaseHashtable_KeyType = [u8; 0usize];
    pub type nsBaseHashtable_EntryType<KeyClass, DataType> =
        root::nsBaseHashtableET<KeyClass, DataType>;
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsBaseHashtable_LookupResult<KeyClass, DataType> {
        pub mEntry: *mut root::nsBaseHashtable_EntryType<KeyClass, DataType>,
        pub mTable: *mut u8,
        pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<KeyClass>>,
        pub _phantom_1: ::std::marker::PhantomData<::std::cell::UnsafeCell<DataType>>,
    }
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsBaseHashtable_EntryPtr<KeyClass, DataType> {
        pub mEntry: *mut root::nsBaseHashtable_EntryType<KeyClass, DataType>,
        pub mExistingEntry: bool,
        pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<KeyClass>>,
        pub _phantom_1: ::std::marker::PhantomData<::std::cell::UnsafeCell<DataType>>,
    }
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsBaseHashtable_Iterator {
        pub _base: root::PLDHashTable_Iterator,
    }
    pub type nsBaseHashtable_Iterator_Base = root::PLDHashTable_Iterator;
    /// templated hashtable class maps keys to simple datatypes.
    /// See nsBaseHashtable for complete declaration
    /// @param KeyClass a wrapper-class for the hashtable key, see nsHashKeys.h
    /// for a complete specification.
    /// @param DataType the simple datatype being wrapped
    /// @see nsInterfaceHashtable, nsClassHashtable
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsDataHashtable {
        pub _address: u8,
    }
    pub type nsDataHashtable_BaseClass = u8;
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsTArrayHeader {
        pub mLength: u32,
        pub _bitfield_1: root::__BindgenBitfieldUnit<[u8; 4usize], u32>,
    }
    extern "C" {
        #[link_name = "\u{1}_ZN14nsTArrayHeader9sEmptyHdrE"]
        pub static mut nsTArrayHeader_sEmptyHdr: root::nsTArrayHeader;
    }
    #[test]
    fn bindgen_test_layout_nsTArrayHeader() {
        assert_eq!(
            ::std::mem::size_of::<nsTArrayHeader>(),
            8usize,
            concat!("Size of: ", stringify!(nsTArrayHeader))
        );
        assert_eq!(
            ::std::mem::align_of::<nsTArrayHeader>(),
            4usize,
            concat!("Alignment of ", stringify!(nsTArrayHeader))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsTArrayHeader>())).mLength as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsTArrayHeader),
                "::",
                stringify!(mLength)
            )
        );
    }
    impl Clone for nsTArrayHeader {
        fn clone(&self) -> Self {
            *self
        }
    }
    impl nsTArrayHeader {
        #[inline]
        pub fn mCapacity(&self) -> u32 {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 31u8) as u32) }
        }
        #[inline]
        pub fn set_mCapacity(&mut self, val: u32) {
            unsafe {
                let val: u32 = ::std::mem::transmute(val);
                self._bitfield_1.set(0usize, 31u8, val as u64)
            }
        }
        #[inline]
        pub fn mIsAutoArray(&self) -> u32 {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
        }
        #[inline]
        pub fn set_mIsAutoArray(&mut self, val: u32) {
            unsafe {
                let val: u32 = ::std::mem::transmute(val);
                self._bitfield_1.set(31usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn new_bitfield_1(
            mCapacity: u32,
            mIsAutoArray: u32,
        ) -> root::__BindgenBitfieldUnit<[u8; 4usize], u32> {
            let mut __bindgen_bitfield_unit: root::__BindgenBitfieldUnit<
                [u8; 4usize],
                u32,
            > = Default::default();
            __bindgen_bitfield_unit.set(0usize, 31u8, {
                let mCapacity: u32 = unsafe { ::std::mem::transmute(mCapacity) };
                mCapacity as u64
            });
            __bindgen_bitfield_unit.set(31usize, 1u8, {
                let mIsAutoArray: u32 = unsafe { ::std::mem::transmute(mIsAutoArray) };
                mIsAutoArray as u64
            });
            __bindgen_bitfield_unit
        }
    }
    pub type AutoTArray_self_type = u8;
    pub type AutoTArray_base_type<E> = root::nsTArray<E>;
    pub type AutoTArray_Header<E> = root::AutoTArray_base_type<E>;
    pub type AutoTArray_elem_type<E> = root::AutoTArray_base_type<E>;
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct AutoTArray__bindgen_ty_1 {
        pub mAutoBuf: root::__BindgenUnionField<*mut ::std::os::raw::c_char>,
        pub mAlign: root::__BindgenUnionField<u8>,
        pub bindgen_union_field: u64,
    }
    pub type nscoord = i32;
    pub type nscolor = u32;
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct gfxFontFeature {
        pub mTag: u32,
        pub mValue: u32,
    }
    #[test]
    fn bindgen_test_layout_gfxFontFeature() {
        assert_eq!(
            ::std::mem::size_of::<gfxFontFeature>(),
            8usize,
            concat!("Size of: ", stringify!(gfxFontFeature))
        );
        assert_eq!(
            ::std::mem::align_of::<gfxFontFeature>(),
            4usize,
            concat!("Alignment of ", stringify!(gfxFontFeature))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<gfxFontFeature>())).mTag as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(gfxFontFeature),
                "::",
                stringify!(mTag)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<gfxFontFeature>())).mValue as *const _ as usize },
            4usize,
            concat!(
                "Offset of field: ",
                stringify!(gfxFontFeature),
                "::",
                stringify!(mValue)
            )
        );
    }
    impl Clone for gfxFontFeature {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    pub struct gfxAlternateValue {
        pub alternate: u32,
        pub value: ::nsstring::nsStringRepr,
    }
    #[test]
    fn bindgen_test_layout_gfxAlternateValue() {
        assert_eq!(
            ::std::mem::size_of::<gfxAlternateValue>(),
            24usize,
            concat!("Size of: ", stringify!(gfxAlternateValue))
        );
        assert_eq!(
            ::std::mem::align_of::<gfxAlternateValue>(),
            8usize,
            concat!("Alignment of ", stringify!(gfxAlternateValue))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<gfxAlternateValue>())).alternate as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(gfxAlternateValue),
                "::",
                stringify!(alternate)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<gfxAlternateValue>())).value as *const _ as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(gfxAlternateValue),
                "::",
                stringify!(value)
            )
        );
    }
    #[repr(C)]
    #[derive(Debug)]
    pub struct gfxFontFeatureValueSet {
        pub mRefCnt: root::mozilla::ThreadSafeAutoRefCnt,
        pub mFontFeatureValues: [u64; 4usize],
    }
    pub type gfxFontFeatureValueSet_HasThreadSafeRefCnt = root::mozilla::TrueType;
    #[repr(C)]
    pub struct gfxFontFeatureValueSet_ValueList {
        pub name: ::nsstring::nsStringRepr,
        pub featureSelectors: root::nsTArray<u32>,
    }
    #[test]
    fn bindgen_test_layout_gfxFontFeatureValueSet_ValueList() {
        assert_eq!(
            ::std::mem::size_of::<gfxFontFeatureValueSet_ValueList>(),
            24usize,
            concat!("Size of: ", stringify!(gfxFontFeatureValueSet_ValueList))
        );
        assert_eq!(
            ::std::mem::align_of::<gfxFontFeatureValueSet_ValueList>(),
            8usize,
            concat!(
                "Alignment of ",
                stringify!(gfxFontFeatureValueSet_ValueList)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<gfxFontFeatureValueSet_ValueList>())).name as *const _
                    as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(gfxFontFeatureValueSet_ValueList),
                "::",
                stringify!(name)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<gfxFontFeatureValueSet_ValueList>())).featureSelectors
                    as *const _ as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(gfxFontFeatureValueSet_ValueList),
                "::",
                stringify!(featureSelectors)
            )
        );
    }
    #[repr(C)]
    pub struct gfxFontFeatureValueSet_FeatureValues {
        pub alternate: u32,
        pub valuelist: root::nsTArray<root::gfxFontFeatureValueSet_ValueList>,
    }
    #[test]
    fn bindgen_test_layout_gfxFontFeatureValueSet_FeatureValues() {
        assert_eq!(
            ::std::mem::size_of::<gfxFontFeatureValueSet_FeatureValues>(),
            16usize,
            concat!(
                "Size of: ",
                stringify!(gfxFontFeatureValueSet_FeatureValues)
            )
        );
        assert_eq!(
            ::std::mem::align_of::<gfxFontFeatureValueSet_FeatureValues>(),
            8usize,
            concat!(
                "Alignment of ",
                stringify!(gfxFontFeatureValueSet_FeatureValues)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<gfxFontFeatureValueSet_FeatureValues>())).alternate
                    as *const _ as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(gfxFontFeatureValueSet_FeatureValues),
                "::",
                stringify!(alternate)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<gfxFontFeatureValueSet_FeatureValues>())).valuelist
                    as *const _ as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(gfxFontFeatureValueSet_FeatureValues),
                "::",
                stringify!(valuelist)
            )
        );
    }
    #[repr(C)]
    pub struct gfxFontFeatureValueSet_FeatureValueHashKey {
        pub mFamily: ::nsstring::nsStringRepr,
        pub mPropVal: u32,
        pub mName: ::nsstring::nsStringRepr,
    }
    #[test]
    fn bindgen_test_layout_gfxFontFeatureValueSet_FeatureValueHashKey() {
        assert_eq!(
            ::std::mem::size_of::<gfxFontFeatureValueSet_FeatureValueHashKey>(),
            40usize,
            concat!(
                "Size of: ",
                stringify!(gfxFontFeatureValueSet_FeatureValueHashKey)
            )
        );
        assert_eq!(
            ::std::mem::align_of::<gfxFontFeatureValueSet_FeatureValueHashKey>(),
            8usize,
            concat!(
                "Alignment of ",
                stringify!(gfxFontFeatureValueSet_FeatureValueHashKey)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<gfxFontFeatureValueSet_FeatureValueHashKey>())).mFamily
                    as *const _ as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(gfxFontFeatureValueSet_FeatureValueHashKey),
                "::",
                stringify!(mFamily)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<gfxFontFeatureValueSet_FeatureValueHashKey>())).mPropVal
                    as *const _ as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(gfxFontFeatureValueSet_FeatureValueHashKey),
                "::",
                stringify!(mPropVal)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<gfxFontFeatureValueSet_FeatureValueHashKey>())).mName
                    as *const _ as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(gfxFontFeatureValueSet_FeatureValueHashKey),
                "::",
                stringify!(mName)
            )
        );
    }
    #[repr(C)]
    pub struct gfxFontFeatureValueSet_FeatureValueHashEntry {
        pub _base: root::PLDHashEntryHdr,
        pub mKey: root::gfxFontFeatureValueSet_FeatureValueHashKey,
        pub mValues: root::nsTArray<u32>,
    }
    pub type gfxFontFeatureValueSet_FeatureValueHashEntry_KeyType =
        *const root::gfxFontFeatureValueSet_FeatureValueHashKey;
    pub type gfxFontFeatureValueSet_FeatureValueHashEntry_KeyTypePointer =
        *const root::gfxFontFeatureValueSet_FeatureValueHashKey;
    pub const gfxFontFeatureValueSet_FeatureValueHashEntry_ALLOW_MEMMOVE:
        root::gfxFontFeatureValueSet_FeatureValueHashEntry__bindgen_ty_1 = 1;
    pub type gfxFontFeatureValueSet_FeatureValueHashEntry__bindgen_ty_1 = u32;
    #[test]
    fn bindgen_test_layout_gfxFontFeatureValueSet_FeatureValueHashEntry() {
        assert_eq!(
            ::std::mem::size_of::<gfxFontFeatureValueSet_FeatureValueHashEntry>(),
            56usize,
            concat!(
                "Size of: ",
                stringify!(gfxFontFeatureValueSet_FeatureValueHashEntry)
            )
        );
        assert_eq!(
            ::std::mem::align_of::<gfxFontFeatureValueSet_FeatureValueHashEntry>(),
            8usize,
            concat!(
                "Alignment of ",
                stringify!(gfxFontFeatureValueSet_FeatureValueHashEntry)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<gfxFontFeatureValueSet_FeatureValueHashEntry>())).mKey
                    as *const _ as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(gfxFontFeatureValueSet_FeatureValueHashEntry),
                "::",
                stringify!(mKey)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<gfxFontFeatureValueSet_FeatureValueHashEntry>())).mValues
                    as *const _ as usize
            },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(gfxFontFeatureValueSet_FeatureValueHashEntry),
                "::",
                stringify!(mValues)
            )
        );
    }
    #[test]
    fn bindgen_test_layout_gfxFontFeatureValueSet() {
        assert_eq!(
            ::std::mem::size_of::<gfxFontFeatureValueSet>(),
            40usize,
            concat!("Size of: ", stringify!(gfxFontFeatureValueSet))
        );
        assert_eq!(
            ::std::mem::align_of::<gfxFontFeatureValueSet>(),
            8usize,
            concat!("Alignment of ", stringify!(gfxFontFeatureValueSet))
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<gfxFontFeatureValueSet>())).mRefCnt as *const _ as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(gfxFontFeatureValueSet),
                "::",
                stringify!(mRefCnt)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<gfxFontFeatureValueSet>())).mFontFeatureValues as *const _
                    as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(gfxFontFeatureValueSet),
                "::",
                stringify!(mFontFeatureValues)
            )
        );
    }
    pub type gfxFontVariation = root::mozilla::gfx::FontVariation;
    pub const kGenericFont_NONE: u8 = 0;
    pub const kGenericFont_moz_variable: u8 = 0;
    pub const kGenericFont_moz_fixed: u8 = 1;
    pub const kGenericFont_serif: u8 = 2;
    pub const kGenericFont_sans_serif: u8 = 4;
    pub const kGenericFont_monospace: u8 = 8;
    pub const kGenericFont_cursive: u8 = 16;
    pub const kGenericFont_fantasy: u8 = 32;
    #[repr(C)]
    pub struct nsFont {
        pub fontlist: root::mozilla::FontFamilyList,
        pub style: u8,
        pub systemFont: bool,
        pub variantCaps: u8,
        pub variantNumeric: u8,
        pub variantPosition: u8,
        pub variantWidth: u8,
        pub variantLigatures: u16,
        pub variantEastAsian: u16,
        pub variantAlternates: u16,
        pub smoothing: u8,
        pub fontSmoothingBackgroundColor: root::nscolor,
        pub weight: u16,
        pub stretch: i16,
        pub kerning: u8,
        pub opticalSizing: u8,
        pub synthesis: u8,
        pub size: root::nscoord,
        pub sizeAdjust: f32,
        pub alternateValues: root::nsTArray<root::gfxAlternateValue>,
        pub featureValueLookup: root::RefPtr<root::gfxFontFeatureValueSet>,
        pub fontFeatureSettings: root::nsTArray<root::gfxFontFeature>,
        pub fontVariationSettings: root::nsTArray<root::gfxFontVariation>,
        pub languageOverride: u32,
    }
    pub const nsFont_MaxDifference_eNone: root::nsFont_MaxDifference = 0;
    pub const nsFont_MaxDifference_eVisual: root::nsFont_MaxDifference = 1;
    pub const nsFont_MaxDifference_eLayoutAffecting: root::nsFont_MaxDifference = 2;
    pub type nsFont_MaxDifference = u8;
    #[test]
    fn bindgen_test_layout_nsFont() {
        assert_eq!(
            ::std::mem::size_of::<nsFont>(),
            96usize,
            concat!("Size of: ", stringify!(nsFont))
        );
        assert_eq!(
            ::std::mem::align_of::<nsFont>(),
            8usize,
            concat!("Alignment of ", stringify!(nsFont))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).fontlist as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(fontlist)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).style as *const _ as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(style)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).systemFont as *const _ as usize },
            17usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(systemFont)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).variantCaps as *const _ as usize },
            18usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(variantCaps)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).variantNumeric as *const _ as usize },
            19usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(variantNumeric)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).variantPosition as *const _ as usize },
            20usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(variantPosition)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).variantWidth as *const _ as usize },
            21usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(variantWidth)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).variantLigatures as *const _ as usize },
            22usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(variantLigatures)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).variantEastAsian as *const _ as usize },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(variantEastAsian)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).variantAlternates as *const _ as usize },
            26usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(variantAlternates)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).smoothing as *const _ as usize },
            28usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(smoothing)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsFont>())).fontSmoothingBackgroundColor as *const _ as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(fontSmoothingBackgroundColor)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).weight as *const _ as usize },
            36usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(weight)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).stretch as *const _ as usize },
            38usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(stretch)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).kerning as *const _ as usize },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(kerning)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).opticalSizing as *const _ as usize },
            41usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(opticalSizing)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).synthesis as *const _ as usize },
            42usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(synthesis)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).size as *const _ as usize },
            44usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(size)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).sizeAdjust as *const _ as usize },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(sizeAdjust)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).alternateValues as *const _ as usize },
            56usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(alternateValues)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).featureValueLookup as *const _ as usize },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(featureValueLookup)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).fontFeatureSettings as *const _ as usize },
            72usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(fontFeatureSettings)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsFont>())).fontVariationSettings as *const _ as usize
            },
            80usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(fontVariationSettings)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsFont>())).languageOverride as *const _ as usize },
            88usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFont),
                "::",
                stringify!(languageOverride)
            )
        );
    }
    /// An array of objects, similar to AutoTArray<T,1> but which is memmovable. It
    /// always has length >= 1.
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsStyleAutoArray<T> {
        pub mFirstElement: T,
        pub mOtherElements: root::nsTArray<T>,
        pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
    }
    pub const nsStyleAutoArray_WithSingleInitialElement_WITH_SINGLE_INITIAL_ELEMENT:
        root::nsStyleAutoArray_WithSingleInitialElement = 0;
    pub type nsStyleAutoArray_WithSingleInitialElement = i32;
    pub const nsStyleUnit_eStyleUnit_MAX: root::nsStyleUnit = nsStyleUnit::eStyleUnit_Calc;
    #[repr(u8)]
    #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
    pub enum nsStyleUnit {
        eStyleUnit_Null = 0,
        eStyleUnit_Normal = 1,
        eStyleUnit_Auto = 2,
        eStyleUnit_None = 3,
        eStyleUnit_Percent = 10,
        eStyleUnit_Factor = 11,
        eStyleUnit_Degree = 12,
        eStyleUnit_Grad = 13,
        eStyleUnit_Radian = 14,
        eStyleUnit_Turn = 15,
        eStyleUnit_FlexFraction = 16,
        eStyleUnit_Coord = 20,
        eStyleUnit_Integer = 30,
        eStyleUnit_Enumerated = 32,
        eStyleUnit_Calc = 40,
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsStyleUnion {
        pub mInt: root::__BindgenUnionField<i32>,
        pub mFloat: root::__BindgenUnionField<f32>,
        pub mPointer: root::__BindgenUnionField<*mut ::std::os::raw::c_void>,
        pub bindgen_union_field: u64,
    }
    #[test]
    fn bindgen_test_layout_nsStyleUnion() {
        assert_eq!(
            ::std::mem::size_of::<nsStyleUnion>(),
            8usize,
            concat!("Size of: ", stringify!(nsStyleUnion))
        );
        assert_eq!(
            ::std::mem::align_of::<nsStyleUnion>(),
            8usize,
            concat!("Alignment of ", stringify!(nsStyleUnion))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsStyleUnion>())).mInt as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsStyleUnion),
                "::",
                stringify!(mInt)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsStyleUnion>())).mFloat as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsStyleUnion),
                "::",
                stringify!(mFloat)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsStyleUnion>())).mPointer as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsStyleUnion),
                "::",
                stringify!(mPointer)
            )
        );
    }
    impl Clone for nsStyleUnion {
        fn clone(&self) -> Self {
            *self
        }
    }
    /// Class that hold a single size specification used by the style
    /// system.  The size specification consists of two parts -- a number
    /// and a unit.  The number is an integer, a floating point value, an
    /// nscoord, or undefined, and the unit is an nsStyleUnit.  Checking
    /// the unit is a must before asking for the value in any particular
    /// form.
    /// /
    /// /** <div rustbindgen private accessor="unsafe"></div>
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsStyleCoord {
        mUnit: root::nsStyleUnit,
        mValue: root::nsStyleUnion,
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsStyleCoord_CalcValue {
        pub mLength: root::nscoord,
        pub mPercent: f32,
        pub mHasPercent: bool,
    }
    #[test]
    fn bindgen_test_layout_nsStyleCoord_CalcValue() {
        assert_eq!(
            ::std::mem::size_of::<nsStyleCoord_CalcValue>(),
            12usize,
            concat!("Size of: ", stringify!(nsStyleCoord_CalcValue))
        );
        assert_eq!(
            ::std::mem::align_of::<nsStyleCoord_CalcValue>(),
            4usize,
            concat!("Alignment of ", stringify!(nsStyleCoord_CalcValue))
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsStyleCoord_CalcValue>())).mLength as *const _ as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsStyleCoord_CalcValue),
                "::",
                stringify!(mLength)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsStyleCoord_CalcValue>())).mPercent as *const _ as usize
            },
            4usize,
            concat!(
                "Offset of field: ",
                stringify!(nsStyleCoord_CalcValue),
                "::",
                stringify!(mPercent)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsStyleCoord_CalcValue>())).mHasPercent as *const _ as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsStyleCoord_CalcValue),
                "::",
                stringify!(mHasPercent)
            )
        );
    }
    impl Clone for nsStyleCoord_CalcValue {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsStyleCoord_Calc {
        pub _base: root::nsStyleCoord_CalcValue,
        pub mRefCnt: root::mozilla::ThreadSafeAutoRefCnt,
    }
    pub type nsStyleCoord_Calc_HasThreadSafeRefCnt = root::mozilla::TrueType;
    #[test]
    fn bindgen_test_layout_nsStyleCoord_Calc() {
        assert_eq!(
            ::std::mem::size_of::<nsStyleCoord_Calc>(),
            24usize,
            concat!("Size of: ", stringify!(nsStyleCoord_Calc))
        );
        assert_eq!(
            ::std::mem::align_of::<nsStyleCoord_Calc>(),
            8usize,
            concat!("Alignment of ", stringify!(nsStyleCoord_Calc))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsStyleCoord_Calc>())).mRefCnt as *const _ as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(nsStyleCoord_Calc),
                "::",
                stringify!(mRefCnt)
            )
        );
    }
    pub const nsStyleCoord_CoordConstructorType_CoordConstructor:
        root::nsStyleCoord_CoordConstructorType = 0;
    pub type nsStyleCoord_CoordConstructorType = u32;
    #[test]
    fn bindgen_test_layout_nsStyleCoord() {
        assert_eq!(
            ::std::mem::size_of::<nsStyleCoord>(),
            16usize,
            concat!("Size of: ", stringify!(nsStyleCoord))
        );
        assert_eq!(
            ::std::mem::align_of::<nsStyleCoord>(),
            8usize,
            concat!("Alignment of ", stringify!(nsStyleCoord))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsStyleCoord>())).mUnit as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsStyleCoord),
                "::",
                stringify!(mUnit)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsStyleCoord>())).mValue as *const _ as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsStyleCoord),
                "::",
                stringify!(mValue)
            )
        );
    }
    impl nsStyleCoord {
        #[inline]
        pub unsafe fn get_mUnit(&self) -> &root::nsStyleUnit {
            &self.mUnit
        }
        #[inline]
        pub unsafe fn get_mUnit_mut(&mut self) -> &mut root::nsStyleUnit {
            &mut self.mUnit
        }
        #[inline]
        pub unsafe fn get_mValue(&self) -> &root::nsStyleUnion {
            &self.mValue
        }
        #[inline]
        pub unsafe fn get_mValue_mut(&mut self) -> &mut root::nsStyleUnion {
            &mut self.mValue
        }
    }
    /// Class that represents a set of top/right/bottom/left nsStyleCoords.
    /// This is commonly used to hold the widths of the borders, margins,
    /// or paddings of a box.
    /// /
    /// /** <div rustbindgen private accessor="unsafe"></div>
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsStyleSides {
        mUnits: [root::nsStyleUnit; 4usize],
        mValues: [root::nsStyleUnion; 4usize],
    }
    #[test]
    fn bindgen_test_layout_nsStyleSides() {
        assert_eq!(
            ::std::mem::size_of::<nsStyleSides>(),
            40usize,
            concat!("Size of: ", stringify!(nsStyleSides))
        );
        assert_eq!(
            ::std::mem::align_of::<nsStyleSides>(),
            8usize,
            concat!("Alignment of ", stringify!(nsStyleSides))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsStyleSides>())).mUnits as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsStyleSides),
                "::",
                stringify!(mUnits)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsStyleSides>())).mValues as *const _ as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsStyleSides),
                "::",
                stringify!(mValues)
            )
        );
    }
    impl nsStyleSides {
        #[inline]
        pub unsafe fn get_mUnits(&self) -> &[root::nsStyleUnit; 4usize] {
            &self.mUnits
        }
        #[inline]
        pub unsafe fn get_mUnits_mut(&mut self) -> &mut [root::nsStyleUnit; 4usize] {
            &mut self.mUnits
        }
        #[inline]
        pub unsafe fn get_mValues(&self) -> &[root::nsStyleUnion; 4usize] {
            &self.mValues
        }
        #[inline]
        pub unsafe fn get_mValues_mut(&mut self) -> &mut [root::nsStyleUnion; 4usize] {
            &mut self.mValues
        }
    }
    /// Class that represents a set of top-left/top-right/bottom-right/bottom-left
    /// nsStyleCoord pairs.  This is used to hold the dimensions of the
    /// corners of a box (for, e.g., border-radius and outline-radius).
    /// /
    /// /** <div rustbindgen private accessor="unsafe"></div>
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsStyleCorners {
        mUnits: [root::nsStyleUnit; 8usize],
        mValues: [root::nsStyleUnion; 8usize],
    }
    #[test]
    fn bindgen_test_layout_nsStyleCorners() {
        assert_eq!(
            ::std::mem::size_of::<nsStyleCorners>(),
            72usize,
            concat!("Size of: ", stringify!(nsStyleCorners))
        );
        assert_eq!(
            ::std::mem::align_of::<nsStyleCorners>(),
            8usize,
            concat!("Alignment of ", stringify!(nsStyleCorners))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsStyleCorners>())).mUnits as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsStyleCorners),
                "::",
                stringify!(mUnits)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsStyleCorners>())).mValues as *const _ as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsStyleCorners),
                "::",
                stringify!(mValues)
            )
        );
    }
    impl nsStyleCorners {
        #[inline]
        pub unsafe fn get_mUnits(&self) -> &[root::nsStyleUnit; 8usize] {
            &self.mUnits
        }
        #[inline]
        pub unsafe fn get_mUnits_mut(&mut self) -> &mut [root::nsStyleUnit; 8usize] {
            &mut self.mUnits
        }
        #[inline]
        pub unsafe fn get_mValues(&self) -> &[root::nsStyleUnion; 8usize] {
            &self.mValues
        }
        #[inline]
        pub unsafe fn get_mValues_mut(&mut self) -> &mut [root::nsStyleUnion; 8usize] {
            &mut self.mValues
        }
    }
    pub const nsChangeHint_nsChangeHint_Empty: root::nsChangeHint = root::nsChangeHint(0);
    pub const nsChangeHint_nsChangeHint_RepaintFrame: root::nsChangeHint = root::nsChangeHint(1);
    pub const nsChangeHint_nsChangeHint_NeedReflow: root::nsChangeHint = root::nsChangeHint(2);
    pub const nsChangeHint_nsChangeHint_ClearAncestorIntrinsics: root::nsChangeHint =
        root::nsChangeHint(4);
    pub const nsChangeHint_nsChangeHint_ClearDescendantIntrinsics: root::nsChangeHint =
        root::nsChangeHint(8);
    pub const nsChangeHint_nsChangeHint_NeedDirtyReflow: root::nsChangeHint =
        root::nsChangeHint(16);
    pub const nsChangeHint_nsChangeHint_SyncFrameView: root::nsChangeHint = root::nsChangeHint(32);
    pub const nsChangeHint_nsChangeHint_UpdateCursor: root::nsChangeHint = root::nsChangeHint(64);
    /// Used when the computed value (a URI) of one or more of an element's
    /// filter/mask/clip/etc CSS properties changes, causing the element's frame
    /// to start/stop referencing (or reference different) SVG resource elements.
    /// (_Not_ used to handle changes to referenced resource elements.) Using this
    /// hint results in SVGObserverUtils::UpdateEffects being called on the
    /// element's frame.
    pub const nsChangeHint_nsChangeHint_UpdateEffects: root::nsChangeHint = root::nsChangeHint(128);
    /// Visual change only, but the change can be handled entirely by
    /// updating the layer(s) for the frame.
    /// Updates all descendants (including following placeholders to out-of-flows).
    pub const nsChangeHint_nsChangeHint_UpdateOpacityLayer: root::nsChangeHint =
        root::nsChangeHint(256);
    /// Updates all descendants. Any placeholder descendants' out-of-flows
    /// are also descendants of the transformed frame, so they're updated.
    pub const nsChangeHint_nsChangeHint_UpdateTransformLayer: root::nsChangeHint =
        root::nsChangeHint(512);
    /// Change requires frame change (e.g., display:).
    /// Reconstructs all frame descendants, including following placeholders
    /// to out-of-flows.
    ///
    /// Note that this subsumes all the other change hints. (see
    /// RestyleManager::ProcessRestyledFrames for details).
    pub const nsChangeHint_nsChangeHint_ReconstructFrame: root::nsChangeHint =
        root::nsChangeHint(1024);
    /// The frame's overflow area has changed. Does not update any descendant
    /// frames.
    pub const nsChangeHint_nsChangeHint_UpdateOverflow: root::nsChangeHint =
        root::nsChangeHint(2048);
    /// The overflow area of the frame and all of its descendants has changed. This
    /// can happen through a text-decoration change.
    pub const nsChangeHint_nsChangeHint_UpdateSubtreeOverflow: root::nsChangeHint =
        root::nsChangeHint(4096);
    /// The frame's overflow area has changed, through a change in its transform.
    /// In other words, the frame's pre-transform overflow is unchanged, but
    /// its post-transform overflow has changed, and thus its effect on its
    /// parent's overflow has changed.  If the pre-transform overflow has
    /// changed, see nsChangeHint_UpdateOverflow.
    /// Does not update any descendant frames.
    pub const nsChangeHint_nsChangeHint_UpdatePostTransformOverflow: root::nsChangeHint =
        root::nsChangeHint(8192);
    /// This frame's effect on its parent's overflow area has changed.
    /// (But neither its pre-transform nor post-transform overflow have
    /// changed; if those are the case, see
    /// nsChangeHint_UpdatePostTransformOverflow.)
    pub const nsChangeHint_nsChangeHint_UpdateParentOverflow: root::nsChangeHint =
        root::nsChangeHint(16384);
    /// The children-only transform of an SVG frame changed, requiring the
    /// overflow rects of the frame's immediate children to be updated.
    pub const nsChangeHint_nsChangeHint_ChildrenOnlyTransform: root::nsChangeHint =
        root::nsChangeHint(32768);
    /// The frame's offsets have changed, while its dimensions might have
    /// changed as well.  This hint is used for positioned frames if their
    /// offset changes.  If we decide that the dimensions are likely to
    /// change, this will trigger a reflow.
    ///
    /// Note that this should probably be used in combination with
    /// nsChangeHint_UpdateOverflow in order to get the overflow areas of
    /// the ancestors updated as well.
    pub const nsChangeHint_nsChangeHint_RecomputePosition: root::nsChangeHint =
        root::nsChangeHint(65536);
    /// Behaves like ReconstructFrame, but only if the frame has descendants
    /// that are absolutely or fixed position. Use this hint when a style change
    /// has changed whether the frame is a container for fixed-pos or abs-pos
    /// elements, but reframing is otherwise not needed.
    ///
    /// Note that nsStyleContext::CalcStyleDifference adjusts results
    /// returned by style struct CalcDifference methods to return this hint
    /// only if there was a change to whether the element's overall style
    /// indicates that it establishes a containing block.
    pub const nsChangeHint_nsChangeHint_UpdateContainingBlock: root::nsChangeHint =
        root::nsChangeHint(131072);
    /// This change hint has *no* change handling behavior.  However, it
    /// exists to be a non-inherited hint, because when the border-style
    /// changes, and it's inherited by a child, that might require a reflow
    /// due to the border-width change on the child.
    pub const nsChangeHint_nsChangeHint_BorderStyleNoneChange: root::nsChangeHint =
        root::nsChangeHint(262144);
    /// SVG textPath needs to be recomputed because the path has changed.
    /// This means that the glyph positions of the text need to be recomputed.
    pub const nsChangeHint_nsChangeHint_UpdateTextPath: root::nsChangeHint =
        root::nsChangeHint(524288);
    /// This will schedule an invalidating paint. This is useful if something
    /// has changed which will be invalidated by DLBI.
    pub const nsChangeHint_nsChangeHint_SchedulePaint: root::nsChangeHint =
        root::nsChangeHint(1048576);
    /// A hint reflecting that style data changed with no change handling
    /// behavior.  We need to return this, rather than nsChangeHint(0),
    /// so that certain optimizations that manipulate the style context tree are
    /// correct.
    ///
    /// nsChangeHint_NeutralChange must be returned by CalcDifference on a given
    /// style struct if the data in the style structs are meaningfully different
    /// and if no other change hints are returned.  If any other change hints are
    /// set, then nsChangeHint_NeutralChange need not also be included, but it is
    /// safe to do so.  (An example of style structs having non-meaningfully
    /// different data would be cached information that would be re-calculated
    /// to the same values, such as nsStyleBorder::mSubImages.)
    pub const nsChangeHint_nsChangeHint_NeutralChange: root::nsChangeHint =
        root::nsChangeHint(2097152);
    /// This will cause rendering observers to be invalidated.
    pub const nsChangeHint_nsChangeHint_InvalidateRenderingObservers: root::nsChangeHint =
        root::nsChangeHint(4194304);
    /// Indicates that the reflow changes the size or position of the
    /// element, and thus the reflow must start from at least the frame's
    /// parent.  Must be not be set without also setting nsChangeHint_NeedReflow
    /// and nsChangeHint_ClearAncestorIntrinsics.
    pub const nsChangeHint_nsChangeHint_ReflowChangesSizeOrPosition: root::nsChangeHint =
        root::nsChangeHint(8388608);
    /// Indicates that the style changes the computed BSize --- e.g. 'height'.
    /// Must not be set without also setting nsChangeHint_NeedReflow.
    pub const nsChangeHint_nsChangeHint_UpdateComputedBSize: root::nsChangeHint =
        root::nsChangeHint(16777216);
    /// Indicates that the 'opacity' property changed between 1 and non-1.
    ///
    /// Used as extra data for handling UpdateOpacityLayer hints.
    ///
    /// Note that we do not send this hint if the non-1 value was 0.99 or
    /// greater, since in that case we send a RepaintFrame hint instead.
    pub const nsChangeHint_nsChangeHint_UpdateUsesOpacity: root::nsChangeHint =
        root::nsChangeHint(33554432);
    /// Indicates that the 'background-position' property changed.
    /// Regular frames can invalidate these changes using DLBI, but
    /// for some frame types we need to repaint the whole frame because
    /// the frame does not build individual background image display items
    /// for each background layer.
    pub const nsChangeHint_nsChangeHint_UpdateBackgroundPosition: root::nsChangeHint =
        root::nsChangeHint(67108864);
    /// Indicates that a frame has changed to or from having the CSS
    /// transform property set.
    pub const nsChangeHint_nsChangeHint_AddOrRemoveTransform: root::nsChangeHint =
        root::nsChangeHint(134217728);
    /// Indicates that the overflow-x and/or overflow-y property changed.
    ///
    /// In most cases, this is equivalent to nsChangeHint_ReconstructFrame. But
    /// in some special cases where the change is really targeting the viewport's
    /// scrollframe, this is instead equivalent to nsChangeHint_AllReflowHints
    /// (because the viewport always has an associated scrollframe).
    pub const nsChangeHint_nsChangeHint_CSSOverflowChange: root::nsChangeHint =
        root::nsChangeHint(268435456);
    /// Indicates that nsIFrame::UpdateWidgetProperties needs to be called.
    /// This is used for -moz-window-* properties.
    pub const nsChangeHint_nsChangeHint_UpdateWidgetProperties: root::nsChangeHint =
        root::nsChangeHint(536870912);
    /// Indicates that there has been a colspan or rowspan attribute change
    /// on the cells of a table.
    pub const nsChangeHint_nsChangeHint_UpdateTableCellSpans: root::nsChangeHint =
        root::nsChangeHint(1073741824);
    /// Indicates that the visiblity property changed.
    /// This change hint is used for skip restyling for animations on
    /// visibility:hidden elements in the case where the elements have no visible
    /// descendants.
    pub const nsChangeHint_nsChangeHint_VisibilityChange: root::nsChangeHint =
        root::nsChangeHint(2147483648);
    /// Dummy hint value for all hints. It exists for compile time check.
    pub const nsChangeHint_nsChangeHint_AllHints: root::nsChangeHint =
        root::nsChangeHint(4294967295);
    impl ::std::ops::BitOr<root::nsChangeHint> for root::nsChangeHint {
        type Output = Self;
        #[inline]
        fn bitor(self, other: Self) -> Self {
            nsChangeHint(self.0 | other.0)
        }
    }
    impl ::std::ops::BitOrAssign for root::nsChangeHint {
        #[inline]
        fn bitor_assign(&mut self, rhs: root::nsChangeHint) {
            self.0 |= rhs.0;
        }
    }
    impl ::std::ops::BitAnd<root::nsChangeHint> for root::nsChangeHint {
        type Output = Self;
        #[inline]
        fn bitand(self, other: Self) -> Self {
            nsChangeHint(self.0 & other.0)
        }
    }
    impl ::std::ops::BitAndAssign for root::nsChangeHint {
        #[inline]
        fn bitand_assign(&mut self, rhs: root::nsChangeHint) {
            self.0 &= rhs.0;
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
    pub struct nsChangeHint(pub u32);
    pub const nsRestyleHint_eRestyle_Self: root::nsRestyleHint = root::nsRestyleHint(1);
    pub const nsRestyleHint_eRestyle_SomeDescendants: root::nsRestyleHint = root::nsRestyleHint(2);
    pub const nsRestyleHint_eRestyle_Subtree: root::nsRestyleHint = root::nsRestyleHint(4);
    pub const nsRestyleHint_eRestyle_LaterSiblings: root::nsRestyleHint = root::nsRestyleHint(8);
    pub const nsRestyleHint_eRestyle_CSSTransitions: root::nsRestyleHint = root::nsRestyleHint(16);
    pub const nsRestyleHint_eRestyle_CSSAnimations: root::nsRestyleHint = root::nsRestyleHint(32);
    pub const nsRestyleHint_eRestyle_StyleAttribute: root::nsRestyleHint = root::nsRestyleHint(64);
    pub const nsRestyleHint_eRestyle_StyleAttribute_Animations: root::nsRestyleHint =
        root::nsRestyleHint(128);
    pub const nsRestyleHint_eRestyle_Force: root::nsRestyleHint = root::nsRestyleHint(256);
    pub const nsRestyleHint_eRestyle_ForceDescendants: root::nsRestyleHint =
        root::nsRestyleHint(512);
    pub const nsRestyleHint_eRestyle_AllHintsWithAnimations: root::nsRestyleHint =
        root::nsRestyleHint(176);
    impl ::std::ops::BitOr<root::nsRestyleHint> for root::nsRestyleHint {
        type Output = Self;
        #[inline]
        fn bitor(self, other: Self) -> Self {
            nsRestyleHint(self.0 | other.0)
        }
    }
    impl ::std::ops::BitOrAssign for root::nsRestyleHint {
        #[inline]
        fn bitor_assign(&mut self, rhs: root::nsRestyleHint) {
            self.0 |= rhs.0;
        }
    }
    impl ::std::ops::BitAnd<root::nsRestyleHint> for root::nsRestyleHint {
        type Output = Self;
        #[inline]
        fn bitand(self, other: Self) -> Self {
            nsRestyleHint(self.0 & other.0)
        }
    }
    impl ::std::ops::BitAndAssign for root::nsRestyleHint {
        #[inline]
        fn bitand_assign(&mut self, rhs: root::nsRestyleHint) {
            self.0 &= rhs.0;
        }
    }
    #[repr(C)]
    /// |nsRestyleHint| is a bitfield for the result of
    /// |HasStateDependentStyle| and |HasAttributeDependentStyle|.  When no
    /// restyling is necessary, use |nsRestyleHint(0)|.
    ///
    /// Without eRestyle_Force or eRestyle_ForceDescendants, the restyling process
    /// can stop processing at a frame when it detects no style changes and it is
    /// known that the styles of the subtree beneath it will not change, leaving
    /// the old style context on the frame.  eRestyle_Force can be used to skip this
    /// optimization on a frame, and to force its new style context to be used.
    ///
    /// Similarly, eRestyle_ForceDescendants will cause the frame and all of its
    /// descendants to be traversed and for the new style contexts that are created
    /// to be set on the frames.
    ///
    /// NOTE: When adding new restyle hints, please also add them to
    /// RestyleManager::RestyleHintToString.
    #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
    pub struct nsRestyleHint(pub u32);
    /// We want C++ to be able to read the style struct fields of ComputedValues
    /// so we define this type on the C++ side and use the bindgenned version
    /// on the Rust side.
    #[repr(C)]
    pub struct ServoComputedData {
        pub Font: ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoFont>,
        pub Color: ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoColor>,
        pub List: ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoList>,
        pub Text: ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoText>,
        pub Visibility:
            ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoVisibility>,
        pub UserInterface:
            ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoUserInterface>,
        pub TableBorder:
            ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoTableBorder>,
        pub SVG: ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoSVG>,
        pub Background:
            ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoBackground>,
        pub Position: ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoPosition>,
        pub TextReset: ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoTextReset>,
        pub Display: ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoDisplay>,
        pub Content: ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoContent>,
        pub UIReset: ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoUIReset>,
        pub Table: ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoTable>,
        pub Margin: ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoMargin>,
        pub Padding: ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoPadding>,
        pub Border: ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoBorder>,
        pub Outline: ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoOutline>,
        pub XUL: ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoXUL>,
        pub SVGReset: ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoSVGReset>,
        pub Column: ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoColumn>,
        pub Effects: ::gecko_bindings::structs::ServoRawOffsetArc<root::mozilla::GeckoEffects>,
        pub custom_properties: ::gecko_bindings::structs::ServoCustomPropertiesMap,
        pub writing_mode: ::gecko_bindings::structs::ServoWritingMode,
        pub flags: ::gecko_bindings::structs::ServoComputedValueFlags,
        /// The rule node representing the ordered list of rules matched for this
        /// /// node.  Can be None for default values and text nodes.  This is
        /// /// essentially an optimization to avoid referencing the root rule node.
        pub rules: ::gecko_bindings::structs::ServoRuleNode,
        /// The element's computed values if visited, only computed if there's a
        /// /// relevant link for this element. A element's "relevant link" is the
        /// /// element being matched if it is a link or the nearest ancestor link.
        pub visited_style: ::gecko_bindings::structs::ServoVisitedStyle,
    }
    #[test]
    fn bindgen_test_layout_ServoComputedData() {
        assert_eq!(
            ::std::mem::size_of::<ServoComputedData>(),
            216usize,
            concat!("Size of: ", stringify!(ServoComputedData))
        );
        assert_eq!(
            ::std::mem::align_of::<ServoComputedData>(),
            8usize,
            concat!("Alignment of ", stringify!(ServoComputedData))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).Font as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(Font)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).Color as *const _ as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(Color)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).List as *const _ as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(List)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).Text as *const _ as usize },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(Text)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<ServoComputedData>())).Visibility as *const _ as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(Visibility)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<ServoComputedData>())).UserInterface as *const _ as usize
            },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(UserInterface)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<ServoComputedData>())).TableBorder as *const _ as usize
            },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(TableBorder)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).SVG as *const _ as usize },
            56usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(SVG)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<ServoComputedData>())).Background as *const _ as usize
            },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(Background)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).Position as *const _ as usize },
            72usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(Position)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).TextReset as *const _ as usize },
            80usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(TextReset)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).Display as *const _ as usize },
            88usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(Display)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).Content as *const _ as usize },
            96usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(Content)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).UIReset as *const _ as usize },
            104usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(UIReset)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).Table as *const _ as usize },
            112usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(Table)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).Margin as *const _ as usize },
            120usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(Margin)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).Padding as *const _ as usize },
            128usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(Padding)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).Border as *const _ as usize },
            136usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(Border)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).Outline as *const _ as usize },
            144usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(Outline)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).XUL as *const _ as usize },
            152usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(XUL)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).SVGReset as *const _ as usize },
            160usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(SVGReset)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).Column as *const _ as usize },
            168usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(Column)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).Effects as *const _ as usize },
            176usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(Effects)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<ServoComputedData>())).custom_properties as *const _ as usize
            },
            184usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(custom_properties)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<ServoComputedData>())).writing_mode as *const _ as usize
            },
            192usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(writing_mode)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).flags as *const _ as usize },
            194usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(flags)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<ServoComputedData>())).rules as *const _ as usize },
            200usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(rules)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<ServoComputedData>())).visited_style as *const _ as usize
            },
            208usize,
            concat!(
                "Offset of field: ",
                stringify!(ServoComputedData),
                "::",
                stringify!(visited_style)
            )
        );
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct ProfilerBacktrace {
        _unused: [u8; 0],
    }
    impl Clone for ProfilerBacktrace {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct ProfilerMarkerPayload {
        _unused: [u8; 0],
    }
    impl Clone for ProfilerMarkerPayload {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct ProfilerBacktraceDestructor {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_ProfilerBacktraceDestructor() {
        assert_eq!(
            ::std::mem::size_of::<ProfilerBacktraceDestructor>(),
            1usize,
            concat!("Size of: ", stringify!(ProfilerBacktraceDestructor))
        );
        assert_eq!(
            ::std::mem::align_of::<ProfilerBacktraceDestructor>(),
            1usize,
            concat!("Alignment of ", stringify!(ProfilerBacktraceDestructor))
        );
    }
    impl Clone for ProfilerBacktraceDestructor {
        fn clone(&self) -> Self {
            *self
        }
    }
    pub type UniqueProfilerBacktrace = root::mozilla::UniquePtr<root::ProfilerBacktrace>;
    pub const JSValueTag_JSVAL_TAG_MAX_DOUBLE: root::JSValueTag = 131056;
    pub const JSValueTag_JSVAL_TAG_INT32: root::JSValueTag = 131057;
    pub const JSValueTag_JSVAL_TAG_UNDEFINED: root::JSValueTag = 131059;
    pub const JSValueTag_JSVAL_TAG_NULL: root::JSValueTag = 131060;
    pub const JSValueTag_JSVAL_TAG_BOOLEAN: root::JSValueTag = 131058;
    pub const JSValueTag_JSVAL_TAG_MAGIC: root::JSValueTag = 131061;
    pub const JSValueTag_JSVAL_TAG_STRING: root::JSValueTag = 131062;
    pub const JSValueTag_JSVAL_TAG_SYMBOL: root::JSValueTag = 131063;
    pub const JSValueTag_JSVAL_TAG_PRIVATE_GCTHING: root::JSValueTag = 131064;
    pub const JSValueTag_JSVAL_TAG_OBJECT: root::JSValueTag = 131068;
    pub type JSValueTag = u32;
    /// a hole in a native object's elements
    pub const JSWhyMagic_JS_ELEMENTS_HOLE: root::JSWhyMagic = 0;
    /// there is not a pending iterator value
    pub const JSWhyMagic_JS_NO_ITER_VALUE: root::JSWhyMagic = 1;
    /// exception value thrown when closing a generator
    pub const JSWhyMagic_JS_GENERATOR_CLOSING: root::JSWhyMagic = 2;
    /// compiler sentinel value
    pub const JSWhyMagic_JS_NO_CONSTANT: root::JSWhyMagic = 3;
    /// used in debug builds to catch tracing errors
    pub const JSWhyMagic_JS_THIS_POISON: root::JSWhyMagic = 4;
    /// used in debug builds to catch tracing errors
    pub const JSWhyMagic_JS_ARG_POISON: root::JSWhyMagic = 5;
    /// an empty subnode in the AST serializer
    pub const JSWhyMagic_JS_SERIALIZE_NO_NODE: root::JSWhyMagic = 6;
    /// lazy arguments value on the stack
    pub const JSWhyMagic_JS_LAZY_ARGUMENTS: root::JSWhyMagic = 7;
    /// optimized-away 'arguments' value
    pub const JSWhyMagic_JS_OPTIMIZED_ARGUMENTS: root::JSWhyMagic = 8;
    /// magic value passed to natives to indicate construction
    pub const JSWhyMagic_JS_IS_CONSTRUCTING: root::JSWhyMagic = 9;
    /// value of static block object slot
    pub const JSWhyMagic_JS_BLOCK_NEEDS_CLONE: root::JSWhyMagic = 10;
    /// see class js::HashableValue
    pub const JSWhyMagic_JS_HASH_KEY_EMPTY: root::JSWhyMagic = 11;
    /// error while running Ion code
    pub const JSWhyMagic_JS_ION_ERROR: root::JSWhyMagic = 12;
    /// missing recover instruction result
    pub const JSWhyMagic_JS_ION_BAILOUT: root::JSWhyMagic = 13;
    /// optimized out slot
    pub const JSWhyMagic_JS_OPTIMIZED_OUT: root::JSWhyMagic = 14;
    /// uninitialized lexical bindings that produce ReferenceError on touch.
    pub const JSWhyMagic_JS_UNINITIALIZED_LEXICAL: root::JSWhyMagic = 15;
    /// standard constructors are not created for off-thread parsing.
    pub const JSWhyMagic_JS_OFF_THREAD_CONSTRUCTOR: root::JSWhyMagic = 16;
    /// for local use
    pub const JSWhyMagic_JS_GENERIC_MAGIC: root::JSWhyMagic = 17;
    /// for local use
    pub const JSWhyMagic_JS_WHY_MAGIC_COUNT: root::JSWhyMagic = 18;
    pub type JSWhyMagic = u32;
    /// This structure precedes the string buffers "we" allocate.  It may be the
    /// case that nsTAString::mData does not point to one of these special
    /// buffers.  The mDataFlags member variable distinguishes the buffer type.
    ///
    /// When this header is in use, it enables reference counting, and capacity
    /// tracking.  NOTE: A string buffer can be modified only if its reference
    /// count is 1.
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsStringBuffer {
        pub mRefCount: u32,
        pub mStorageSize: u32,
        pub mCanary: u32,
    }
    #[test]
    fn bindgen_test_layout_nsStringBuffer() {
        assert_eq!(
            ::std::mem::size_of::<nsStringBuffer>(),
            12usize,
            concat!("Size of: ", stringify!(nsStringBuffer))
        );
        assert_eq!(
            ::std::mem::align_of::<nsStringBuffer>(),
            4usize,
            concat!("Alignment of ", stringify!(nsStringBuffer))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsStringBuffer>())).mRefCount as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsStringBuffer),
                "::",
                stringify!(mRefCount)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsStringBuffer>())).mStorageSize as *const _ as usize },
            4usize,
            concat!(
                "Offset of field: ",
                stringify!(nsStringBuffer),
                "::",
                stringify!(mStorageSize)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsStringBuffer>())).mCanary as *const _ as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsStringBuffer),
                "::",
                stringify!(mCanary)
            )
        );
    }
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsAtom {
        pub mRefCnt: root::mozilla::ThreadSafeAutoRefCnt,
        pub _bitfield_1: root::__BindgenBitfieldUnit<[u8; 4usize], u32>,
        pub mHash: u32,
        pub mString: *mut u16,
    }
    #[repr(u8)]
    #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
    pub enum nsAtom_AtomKind {
        DynamicAtom = 0,
        StaticAtom = 1,
        HTML5Atom = 2,
    }
    pub type nsAtom_HasThreadSafeRefCnt = root::mozilla::TrueType;
    #[test]
    fn bindgen_test_layout_nsAtom() {
        assert_eq!(
            ::std::mem::size_of::<nsAtom>(),
            24usize,
            concat!("Size of: ", stringify!(nsAtom))
        );
        assert_eq!(
            ::std::mem::align_of::<nsAtom>(),
            8usize,
            concat!("Alignment of ", stringify!(nsAtom))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsAtom>())).mRefCnt as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsAtom),
                "::",
                stringify!(mRefCnt)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsAtom>())).mHash as *const _ as usize },
            12usize,
            concat!(
                "Offset of field: ",
                stringify!(nsAtom),
                "::",
                stringify!(mHash)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsAtom>())).mString as *const _ as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(nsAtom),
                "::",
                stringify!(mString)
            )
        );
    }
    impl nsAtom {
        #[inline]
        pub fn mLength(&self) -> u32 {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 30u8) as u32) }
        }
        #[inline]
        pub fn set_mLength(&mut self, val: u32) {
            unsafe {
                let val: u32 = ::std::mem::transmute(val);
                self._bitfield_1.set(0usize, 30u8, val as u64)
            }
        }
        #[inline]
        pub fn mKind(&self) -> u32 {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(30usize, 2u8) as u32) }
        }
        #[inline]
        pub fn set_mKind(&mut self, val: u32) {
            unsafe {
                let val: u32 = ::std::mem::transmute(val);
                self._bitfield_1.set(30usize, 2u8, val as u64)
            }
        }
        #[inline]
        pub fn new_bitfield_1(
            mLength: u32,
            mKind: u32,
        ) -> root::__BindgenBitfieldUnit<[u8; 4usize], u32> {
            let mut __bindgen_bitfield_unit: root::__BindgenBitfieldUnit<
                [u8; 4usize],
                u32,
            > = Default::default();
            __bindgen_bitfield_unit.set(0usize, 30u8, {
                let mLength: u32 = unsafe { ::std::mem::transmute(mLength) };
                mLength as u64
            });
            __bindgen_bitfield_unit.set(30usize, 2u8, {
                let mKind: u32 = unsafe { ::std::mem::transmute(mKind) };
                mKind as u64
            });
            __bindgen_bitfield_unit
        }
    }
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsStaticAtom {
        pub _base: root::nsAtom,
    }
    #[test]
    fn bindgen_test_layout_nsStaticAtom() {
        assert_eq!(
            ::std::mem::size_of::<nsStaticAtom>(),
            24usize,
            concat!("Size of: ", stringify!(nsStaticAtom))
        );
        assert_eq!(
            ::std::mem::align_of::<nsStaticAtom>(),
            8usize,
            concat!("Alignment of ", stringify!(nsStaticAtom))
        );
    }
    pub type nsLoadFlags = u32;
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIRequest {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIRequest_COMTypeInfo {
        pub _address: u8,
    }
    pub const nsIRequest_LOAD_REQUESTMASK: root::nsIRequest__bindgen_ty_1 = 65535;
    pub const nsIRequest_LOAD_NORMAL: root::nsIRequest__bindgen_ty_1 = 0;
    pub const nsIRequest_LOAD_BACKGROUND: root::nsIRequest__bindgen_ty_1 = 1;
    pub const nsIRequest_LOAD_HTML_OBJECT_DATA: root::nsIRequest__bindgen_ty_1 = 2;
    pub const nsIRequest_LOAD_DOCUMENT_NEEDS_COOKIE: root::nsIRequest__bindgen_ty_1 = 4;
    pub const nsIRequest_INHIBIT_CACHING: root::nsIRequest__bindgen_ty_1 = 128;
    pub const nsIRequest_INHIBIT_PERSISTENT_CACHING: root::nsIRequest__bindgen_ty_1 = 256;
    pub const nsIRequest_LOAD_BYPASS_CACHE: root::nsIRequest__bindgen_ty_1 = 512;
    pub const nsIRequest_LOAD_FROM_CACHE: root::nsIRequest__bindgen_ty_1 = 1024;
    pub const nsIRequest_VALIDATE_ALWAYS: root::nsIRequest__bindgen_ty_1 = 2048;
    pub const nsIRequest_VALIDATE_NEVER: root::nsIRequest__bindgen_ty_1 = 4096;
    pub const nsIRequest_VALIDATE_ONCE_PER_SESSION: root::nsIRequest__bindgen_ty_1 = 8192;
    pub const nsIRequest_LOAD_ANONYMOUS: root::nsIRequest__bindgen_ty_1 = 16384;
    pub const nsIRequest_LOAD_FRESH_CONNECTION: root::nsIRequest__bindgen_ty_1 = 32768;
    pub type nsIRequest__bindgen_ty_1 = u32;
    #[test]
    fn bindgen_test_layout_nsIRequest() {
        assert_eq!(
            ::std::mem::size_of::<nsIRequest>(),
            8usize,
            concat!("Size of: ", stringify!(nsIRequest))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIRequest>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIRequest))
        );
    }
    impl Clone for nsIRequest {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIContentPolicy {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIContentPolicy_COMTypeInfo {
        pub _address: u8,
    }
    pub const nsIContentPolicy_TYPE_INVALID: root::nsIContentPolicy__bindgen_ty_1 = 0;
    pub const nsIContentPolicy_TYPE_OTHER: root::nsIContentPolicy__bindgen_ty_1 = 1;
    pub const nsIContentPolicy_TYPE_SCRIPT: root::nsIContentPolicy__bindgen_ty_1 = 2;
    pub const nsIContentPolicy_TYPE_IMAGE: root::nsIContentPolicy__bindgen_ty_1 = 3;
    pub const nsIContentPolicy_TYPE_STYLESHEET: root::nsIContentPolicy__bindgen_ty_1 = 4;
    pub const nsIContentPolicy_TYPE_OBJECT: root::nsIContentPolicy__bindgen_ty_1 = 5;
    pub const nsIContentPolicy_TYPE_DOCUMENT: root::nsIContentPolicy__bindgen_ty_1 = 6;
    pub const nsIContentPolicy_TYPE_SUBDOCUMENT: root::nsIContentPolicy__bindgen_ty_1 = 7;
    pub const nsIContentPolicy_TYPE_REFRESH: root::nsIContentPolicy__bindgen_ty_1 = 8;
    pub const nsIContentPolicy_TYPE_XBL: root::nsIContentPolicy__bindgen_ty_1 = 9;
    pub const nsIContentPolicy_TYPE_PING: root::nsIContentPolicy__bindgen_ty_1 = 10;
    pub const nsIContentPolicy_TYPE_XMLHTTPREQUEST: root::nsIContentPolicy__bindgen_ty_1 = 11;
    pub const nsIContentPolicy_TYPE_DATAREQUEST: root::nsIContentPolicy__bindgen_ty_1 = 11;
    pub const nsIContentPolicy_TYPE_OBJECT_SUBREQUEST: root::nsIContentPolicy__bindgen_ty_1 = 12;
    pub const nsIContentPolicy_TYPE_DTD: root::nsIContentPolicy__bindgen_ty_1 = 13;
    pub const nsIContentPolicy_TYPE_FONT: root::nsIContentPolicy__bindgen_ty_1 = 14;
    pub const nsIContentPolicy_TYPE_MEDIA: root::nsIContentPolicy__bindgen_ty_1 = 15;
    pub const nsIContentPolicy_TYPE_WEBSOCKET: root::nsIContentPolicy__bindgen_ty_1 = 16;
    pub const nsIContentPolicy_TYPE_CSP_REPORT: root::nsIContentPolicy__bindgen_ty_1 = 17;
    pub const nsIContentPolicy_TYPE_XSLT: root::nsIContentPolicy__bindgen_ty_1 = 18;
    pub const nsIContentPolicy_TYPE_BEACON: root::nsIContentPolicy__bindgen_ty_1 = 19;
    pub const nsIContentPolicy_TYPE_FETCH: root::nsIContentPolicy__bindgen_ty_1 = 20;
    pub const nsIContentPolicy_TYPE_IMAGESET: root::nsIContentPolicy__bindgen_ty_1 = 21;
    pub const nsIContentPolicy_TYPE_WEB_MANIFEST: root::nsIContentPolicy__bindgen_ty_1 = 22;
    pub const nsIContentPolicy_TYPE_SAVEAS_DOWNLOAD: root::nsIContentPolicy__bindgen_ty_1 = 43;
    pub const nsIContentPolicy_TYPE_INTERNAL_SCRIPT: root::nsIContentPolicy__bindgen_ty_1 = 23;
    pub const nsIContentPolicy_TYPE_INTERNAL_WORKER: root::nsIContentPolicy__bindgen_ty_1 = 24;
    pub const nsIContentPolicy_TYPE_INTERNAL_SHARED_WORKER: root::nsIContentPolicy__bindgen_ty_1 =
        25;
    pub const nsIContentPolicy_TYPE_INTERNAL_EMBED: root::nsIContentPolicy__bindgen_ty_1 = 26;
    pub const nsIContentPolicy_TYPE_INTERNAL_OBJECT: root::nsIContentPolicy__bindgen_ty_1 = 27;
    pub const nsIContentPolicy_TYPE_INTERNAL_FRAME: root::nsIContentPolicy__bindgen_ty_1 = 28;
    pub const nsIContentPolicy_TYPE_INTERNAL_IFRAME: root::nsIContentPolicy__bindgen_ty_1 = 29;
    pub const nsIContentPolicy_TYPE_INTERNAL_AUDIO: root::nsIContentPolicy__bindgen_ty_1 = 30;
    pub const nsIContentPolicy_TYPE_INTERNAL_VIDEO: root::nsIContentPolicy__bindgen_ty_1 = 31;
    pub const nsIContentPolicy_TYPE_INTERNAL_TRACK: root::nsIContentPolicy__bindgen_ty_1 = 32;
    pub const nsIContentPolicy_TYPE_INTERNAL_XMLHTTPREQUEST: root::nsIContentPolicy__bindgen_ty_1 =
        33;
    pub const nsIContentPolicy_TYPE_INTERNAL_EVENTSOURCE: root::nsIContentPolicy__bindgen_ty_1 = 34;
    pub const nsIContentPolicy_TYPE_INTERNAL_SERVICE_WORKER: root::nsIContentPolicy__bindgen_ty_1 =
        35;
    pub const nsIContentPolicy_TYPE_INTERNAL_SCRIPT_PRELOAD: root::nsIContentPolicy__bindgen_ty_1 =
        36;
    pub const nsIContentPolicy_TYPE_INTERNAL_IMAGE: root::nsIContentPolicy__bindgen_ty_1 = 37;
    pub const nsIContentPolicy_TYPE_INTERNAL_IMAGE_PRELOAD: root::nsIContentPolicy__bindgen_ty_1 =
        38;
    pub const nsIContentPolicy_TYPE_INTERNAL_STYLESHEET: root::nsIContentPolicy__bindgen_ty_1 = 39;
    pub const nsIContentPolicy_TYPE_INTERNAL_STYLESHEET_PRELOAD:
        root::nsIContentPolicy__bindgen_ty_1 = 40;
    pub const nsIContentPolicy_TYPE_INTERNAL_IMAGE_FAVICON: root::nsIContentPolicy__bindgen_ty_1 =
        41;
    pub const nsIContentPolicy_TYPE_INTERNAL_WORKER_IMPORT_SCRIPTS:
        root::nsIContentPolicy__bindgen_ty_1 = 42;
    pub const nsIContentPolicy_REJECT_REQUEST: root::nsIContentPolicy__bindgen_ty_1 = -1;
    pub const nsIContentPolicy_REJECT_TYPE: root::nsIContentPolicy__bindgen_ty_1 = -2;
    pub const nsIContentPolicy_REJECT_SERVER: root::nsIContentPolicy__bindgen_ty_1 = -3;
    pub const nsIContentPolicy_REJECT_OTHER: root::nsIContentPolicy__bindgen_ty_1 = -4;
    pub const nsIContentPolicy_ACCEPT: root::nsIContentPolicy__bindgen_ty_1 = 1;
    pub type nsIContentPolicy__bindgen_ty_1 = i32;
    #[test]
    fn bindgen_test_layout_nsIContentPolicy() {
        assert_eq!(
            ::std::mem::size_of::<nsIContentPolicy>(),
            8usize,
            concat!("Size of: ", stringify!(nsIContentPolicy))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIContentPolicy>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIContentPolicy))
        );
    }
    impl Clone for nsIContentPolicy {
        fn clone(&self) -> Self {
            *self
        }
    }
    /// Base class that implements parts shared by JSErrorReport and
    /// JSErrorNotes::Note.
    #[repr(C)]
    #[derive(Debug)]
    pub struct JSErrorBase {
        pub message_: root::JS::ConstUTF8CharsZ,
        pub filename: *const ::std::os::raw::c_char,
        pub lineno: ::std::os::raw::c_uint,
        pub column: ::std::os::raw::c_uint,
        pub errorNumber: ::std::os::raw::c_uint,
        pub _bitfield_1: root::__BindgenBitfieldUnit<[u8; 1usize], u8>,
        pub __bindgen_padding_0: [u8; 3usize],
    }
    #[test]
    fn bindgen_test_layout_JSErrorBase() {
        assert_eq!(
            ::std::mem::size_of::<JSErrorBase>(),
            32usize,
            concat!("Size of: ", stringify!(JSErrorBase))
        );
        assert_eq!(
            ::std::mem::align_of::<JSErrorBase>(),
            8usize,
            concat!("Alignment of ", stringify!(JSErrorBase))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<JSErrorBase>())).message_ as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(JSErrorBase),
                "::",
                stringify!(message_)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<JSErrorBase>())).filename as *const _ as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(JSErrorBase),
                "::",
                stringify!(filename)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<JSErrorBase>())).lineno as *const _ as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(JSErrorBase),
                "::",
                stringify!(lineno)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<JSErrorBase>())).column as *const _ as usize },
            20usize,
            concat!(
                "Offset of field: ",
                stringify!(JSErrorBase),
                "::",
                stringify!(column)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<JSErrorBase>())).errorNumber as *const _ as usize },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(JSErrorBase),
                "::",
                stringify!(errorNumber)
            )
        );
    }
    impl JSErrorBase {
        #[inline]
        pub fn ownsMessage_(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_ownsMessage_(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(0usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn new_bitfield_1(ownsMessage_: bool) -> root::__BindgenBitfieldUnit<[u8; 1usize], u8> {
            let mut __bindgen_bitfield_unit: root::__BindgenBitfieldUnit<
                [u8; 1usize],
                u8,
            > = Default::default();
            __bindgen_bitfield_unit.set(0usize, 1u8, {
                let ownsMessage_: u8 = unsafe { ::std::mem::transmute(ownsMessage_) };
                ownsMessage_ as u64
            });
            __bindgen_bitfield_unit
        }
    }
    /// Notes associated with JSErrorReport.
    #[repr(C)]
    #[derive(Debug)]
    pub struct JSErrorNotes {
        pub notes_: [u64; 4usize],
    }
    #[repr(C)]
    #[derive(Debug)]
    pub struct JSErrorNotes_Note {
        pub _base: root::JSErrorBase,
    }
    #[test]
    fn bindgen_test_layout_JSErrorNotes_Note() {
        assert_eq!(
            ::std::mem::size_of::<JSErrorNotes_Note>(),
            32usize,
            concat!("Size of: ", stringify!(JSErrorNotes_Note))
        );
        assert_eq!(
            ::std::mem::align_of::<JSErrorNotes_Note>(),
            8usize,
            concat!("Alignment of ", stringify!(JSErrorNotes_Note))
        );
    }
    #[repr(C)]
    #[derive(Debug)]
    pub struct JSErrorNotes_iterator {
        pub note_: *mut root::mozilla::UniquePtr<root::JSErrorNotes_Note>,
    }
    #[test]
    fn bindgen_test_layout_JSErrorNotes_iterator() {
        assert_eq!(
            ::std::mem::size_of::<JSErrorNotes_iterator>(),
            8usize,
            concat!("Size of: ", stringify!(JSErrorNotes_iterator))
        );
        assert_eq!(
            ::std::mem::align_of::<JSErrorNotes_iterator>(),
            8usize,
            concat!("Alignment of ", stringify!(JSErrorNotes_iterator))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<JSErrorNotes_iterator>())).note_ as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(JSErrorNotes_iterator),
                "::",
                stringify!(note_)
            )
        );
    }
    #[test]
    fn bindgen_test_layout_JSErrorNotes() {
        assert_eq!(
            ::std::mem::size_of::<JSErrorNotes>(),
            32usize,
            concat!("Size of: ", stringify!(JSErrorNotes))
        );
        assert_eq!(
            ::std::mem::align_of::<JSErrorNotes>(),
            8usize,
            concat!("Alignment of ", stringify!(JSErrorNotes))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<JSErrorNotes>())).notes_ as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(JSErrorNotes),
                "::",
                stringify!(notes_)
            )
        );
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsISerializable {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsISerializable_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsISerializable() {
        assert_eq!(
            ::std::mem::size_of::<nsISerializable>(),
            8usize,
            concat!("Size of: ", stringify!(nsISerializable))
        );
        assert_eq!(
            ::std::mem::align_of::<nsISerializable>(),
            8usize,
            concat!("Alignment of ", stringify!(nsISerializable))
        );
    }
    impl Clone for nsISerializable {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIPrincipal {
        pub _base: root::nsISerializable,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIPrincipal_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsIPrincipal() {
        assert_eq!(
            ::std::mem::size_of::<nsIPrincipal>(),
            8usize,
            concat!("Size of: ", stringify!(nsIPrincipal))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIPrincipal>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIPrincipal))
        );
    }
    impl Clone for nsIPrincipal {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIDocShell {
        _unused: [u8; 0],
    }
    impl Clone for nsIDocShell {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIScriptSecurityManager {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIScriptSecurityManager_COMTypeInfo {
        pub _address: u8,
    }
    pub const nsIScriptSecurityManager_STANDARD: root::nsIScriptSecurityManager__bindgen_ty_1 = 0;
    pub const nsIScriptSecurityManager_LOAD_IS_AUTOMATIC_DOCUMENT_REPLACEMENT:
        root::nsIScriptSecurityManager__bindgen_ty_1 = 1;
    pub const nsIScriptSecurityManager_ALLOW_CHROME: root::nsIScriptSecurityManager__bindgen_ty_1 =
        2;
    pub const nsIScriptSecurityManager_DISALLOW_INHERIT_PRINCIPAL:
        root::nsIScriptSecurityManager__bindgen_ty_1 = 4;
    pub const nsIScriptSecurityManager_DISALLOW_SCRIPT_OR_DATA:
        root::nsIScriptSecurityManager__bindgen_ty_1 = 4;
    pub const nsIScriptSecurityManager_DISALLOW_SCRIPT:
        root::nsIScriptSecurityManager__bindgen_ty_1 = 8;
    pub const nsIScriptSecurityManager_DONT_REPORT_ERRORS:
        root::nsIScriptSecurityManager__bindgen_ty_1 = 16;
    pub type nsIScriptSecurityManager__bindgen_ty_1 = u32;
    pub const nsIScriptSecurityManager_NO_APP_ID: root::nsIScriptSecurityManager__bindgen_ty_2 = 0;
    pub const nsIScriptSecurityManager_UNKNOWN_APP_ID:
        root::nsIScriptSecurityManager__bindgen_ty_2 = 4294967295;
    pub const nsIScriptSecurityManager_DEFAULT_USER_CONTEXT_ID:
        root::nsIScriptSecurityManager__bindgen_ty_2 = 0;
    pub type nsIScriptSecurityManager__bindgen_ty_2 = u32;
    #[test]
    fn bindgen_test_layout_nsIScriptSecurityManager() {
        assert_eq!(
            ::std::mem::size_of::<nsIScriptSecurityManager>(),
            8usize,
            concat!("Size of: ", stringify!(nsIScriptSecurityManager))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIScriptSecurityManager>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIScriptSecurityManager))
        );
    }
    impl Clone for nsIScriptSecurityManager {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIChannel {
        pub _base: root::nsIRequest,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIChannel_COMTypeInfo {
        pub _address: u8,
    }
    pub const nsIChannel_LOAD_DOCUMENT_URI: root::nsIChannel__bindgen_ty_1 = 65536;
    pub const nsIChannel_LOAD_RETARGETED_DOCUMENT_URI: root::nsIChannel__bindgen_ty_1 = 131072;
    pub const nsIChannel_LOAD_REPLACE: root::nsIChannel__bindgen_ty_1 = 262144;
    pub const nsIChannel_LOAD_INITIAL_DOCUMENT_URI: root::nsIChannel__bindgen_ty_1 = 524288;
    pub const nsIChannel_LOAD_TARGETED: root::nsIChannel__bindgen_ty_1 = 1048576;
    pub const nsIChannel_LOAD_CALL_CONTENT_SNIFFERS: root::nsIChannel__bindgen_ty_1 = 2097152;
    pub const nsIChannel_LOAD_CLASSIFY_URI: root::nsIChannel__bindgen_ty_1 = 4194304;
    pub const nsIChannel_LOAD_MEDIA_SNIFFER_OVERRIDES_CONTENT_TYPE: root::nsIChannel__bindgen_ty_1 =
        8388608;
    pub const nsIChannel_LOAD_EXPLICIT_CREDENTIALS: root::nsIChannel__bindgen_ty_1 = 16777216;
    pub const nsIChannel_LOAD_BYPASS_SERVICE_WORKER: root::nsIChannel__bindgen_ty_1 = 33554432;
    pub type nsIChannel__bindgen_ty_1 = u32;
    pub const nsIChannel_DISPOSITION_INLINE: root::nsIChannel__bindgen_ty_2 = 0;
    pub const nsIChannel_DISPOSITION_ATTACHMENT: root::nsIChannel__bindgen_ty_2 = 1;
    pub type nsIChannel__bindgen_ty_2 = u32;
    #[test]
    fn bindgen_test_layout_nsIChannel() {
        assert_eq!(
            ::std::mem::size_of::<nsIChannel>(),
            8usize,
            concat!("Size of: ", stringify!(nsIChannel))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIChannel>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIChannel))
        );
    }
    impl Clone for nsIChannel {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsICSSLoaderObserver {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsICSSLoaderObserver_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsICSSLoaderObserver() {
        assert_eq!(
            ::std::mem::size_of::<nsICSSLoaderObserver>(),
            8usize,
            concat!("Size of: ", stringify!(nsICSSLoaderObserver))
        );
        assert_eq!(
            ::std::mem::align_of::<nsICSSLoaderObserver>(),
            8usize,
            concat!("Alignment of ", stringify!(nsICSSLoaderObserver))
        );
    }
    impl Clone for nsICSSLoaderObserver {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    pub struct nsCycleCollectionParticipant__bindgen_vtable(::std::os::raw::c_void);
    /// Participant implementation classes
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsCycleCollectionParticipant {
        pub vtable_: *const nsCycleCollectionParticipant__bindgen_vtable,
        pub mMightSkip: bool,
        pub mTraverseShouldTrace: bool,
    }
    #[test]
    fn bindgen_test_layout_nsCycleCollectionParticipant() {
        assert_eq!(
            ::std::mem::size_of::<nsCycleCollectionParticipant>(),
            16usize,
            concat!("Size of: ", stringify!(nsCycleCollectionParticipant))
        );
        assert_eq!(
            ::std::mem::align_of::<nsCycleCollectionParticipant>(),
            8usize,
            concat!("Alignment of ", stringify!(nsCycleCollectionParticipant))
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsCycleCollectionParticipant>())).mMightSkip as *const _
                    as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCycleCollectionParticipant),
                "::",
                stringify!(mMightSkip)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsCycleCollectionParticipant>())).mTraverseShouldTrace
                    as *const _ as usize
            },
            9usize,
            concat!(
                "Offset of field: ",
                stringify!(nsCycleCollectionParticipant),
                "::",
                stringify!(mTraverseShouldTrace)
            )
        );
    }
    impl Clone for nsCycleCollectionParticipant {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsScriptObjectTracer {
        pub _base: root::nsCycleCollectionParticipant,
    }
    #[test]
    fn bindgen_test_layout_nsScriptObjectTracer() {
        assert_eq!(
            ::std::mem::size_of::<nsScriptObjectTracer>(),
            16usize,
            concat!("Size of: ", stringify!(nsScriptObjectTracer))
        );
        assert_eq!(
            ::std::mem::align_of::<nsScriptObjectTracer>(),
            8usize,
            concat!("Alignment of ", stringify!(nsScriptObjectTracer))
        );
    }
    impl Clone for nsScriptObjectTracer {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsXPCOMCycleCollectionParticipant {
        pub _base: root::nsScriptObjectTracer,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsXPCOMCycleCollectionParticipant_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsXPCOMCycleCollectionParticipant() {
        assert_eq!(
            ::std::mem::size_of::<nsXPCOMCycleCollectionParticipant>(),
            16usize,
            concat!("Size of: ", stringify!(nsXPCOMCycleCollectionParticipant))
        );
        assert_eq!(
            ::std::mem::align_of::<nsXPCOMCycleCollectionParticipant>(),
            8usize,
            concat!(
                "Alignment of ",
                stringify!(nsXPCOMCycleCollectionParticipant)
            )
        );
    }
    impl Clone for nsXPCOMCycleCollectionParticipant {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    pub struct nsWrapperCache__bindgen_vtable(::std::os::raw::c_void);
    /// Class to store the wrapper for an object. This can only be used with objects
    /// that only have one non-security wrapper at a time (for an XPCWrappedNative
    /// this is usually ensured by setting an explicit parent in the PreCreate hook
    /// for the class).
    ///
    /// An instance of nsWrapperCache can be gotten from an object that implements
    /// a wrapper cache by calling QueryInterface on it. Note that this breaks XPCOM
    /// rules a bit (this object doesn't derive from nsISupports).
    ///
    /// The cache can store objects other than wrappers. We allow wrappers to use a
    /// separate JSObject to store their state (mostly expandos). If the wrapper is
    /// collected and we want to preserve this state we actually store the state
    /// object in the cache.
    ///
    /// The cache can store 2 types of objects:
    ///
    /// If WRAPPER_IS_NOT_DOM_BINDING is set (IsDOMBinding() returns false):
    /// - the JSObject of an XPCWrappedNative wrapper
    ///
    /// If WRAPPER_IS_NOT_DOM_BINDING is not set (IsDOMBinding() returns true):
    /// - a DOM binding object (regular JS object or proxy)
    ///
    /// The finalizer for the wrapper clears the cache.
    ///
    /// A compacting GC can move the wrapper object. Pointers to moved objects are
    /// usually found and updated by tracing the heap, however non-preserved wrappers
    /// are weak references and are not traced, so another approach is
    /// necessary. Instead a class hook (objectMovedOp) is provided that is called
    /// when an object is moved and is responsible for ensuring pointers are
    /// updated. It does this by calling UpdateWrapper() on the wrapper
    /// cache. SetWrapper() asserts that the hook is implemented for any wrapper set.
    ///
    /// A number of the methods are implemented in nsWrapperCacheInlines.h because we
    /// have to include some JS headers that don't play nicely with the rest of the
    /// codebase. Include nsWrapperCacheInlines.h if you need to call those methods.
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsWrapperCache {
        pub vtable_: *const nsWrapperCache__bindgen_vtable,
        pub mWrapper: *mut root::JSObject,
        pub mFlags: root::nsWrapperCache_FlagsType,
        pub mBoolFlags: u32,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsWrapperCache_COMTypeInfo {
        pub _address: u8,
    }
    pub type nsWrapperCache_FlagsType = u32;
    pub const nsWrapperCache_WRAPPER_BIT_PRESERVED: root::nsWrapperCache__bindgen_ty_1 = 1;
    /// If this bit is set then we're preserving the wrapper, which in effect ties
    /// the lifetime of the JS object stored in the cache to the lifetime of the
    /// native object. We rely on the cycle collector to break the cycle that this
    /// causes between the native object and the JS object, so it is important that
    /// any native object that supports preserving of its wrapper
    /// traces/traverses/unlinks the cached JS object (see
    /// NS_IMPL_CYCLE_COLLECTION_TRACE_PRESERVED_WRAPPER and
    /// NS_IMPL_CYCLE_COLLECTION_UNLINK_PRESERVED_WRAPPER).
    pub type nsWrapperCache__bindgen_ty_1 = u32;
    pub const nsWrapperCache_WRAPPER_IS_NOT_DOM_BINDING: root::nsWrapperCache__bindgen_ty_2 = 2;
    /// If this bit is set then the wrapper for the native object is not a DOM
    /// binding.
    pub type nsWrapperCache__bindgen_ty_2 = u32;
    pub const nsWrapperCache_kWrapperFlagsMask: root::nsWrapperCache__bindgen_ty_3 = 3;
    pub type nsWrapperCache__bindgen_ty_3 = u32;
    #[test]
    fn bindgen_test_layout_nsWrapperCache() {
        assert_eq!(
            ::std::mem::size_of::<nsWrapperCache>(),
            24usize,
            concat!("Size of: ", stringify!(nsWrapperCache))
        );
        assert_eq!(
            ::std::mem::align_of::<nsWrapperCache>(),
            8usize,
            concat!("Alignment of ", stringify!(nsWrapperCache))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsWrapperCache>())).mWrapper as *const _ as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsWrapperCache),
                "::",
                stringify!(mWrapper)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsWrapperCache>())).mFlags as *const _ as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(nsWrapperCache),
                "::",
                stringify!(mFlags)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsWrapperCache>())).mBoolFlags as *const _ as usize },
            20usize,
            concat!(
                "Offset of field: ",
                stringify!(nsWrapperCache),
                "::",
                stringify!(mBoolFlags)
            )
        );
    }
    pub type gfxSize = [u64; 2usize];
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIDOMNode {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIDOMNode_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsIDOMNode() {
        assert_eq!(
            ::std::mem::size_of::<nsIDOMNode>(),
            8usize,
            concat!("Size of: ", stringify!(nsIDOMNode))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIDOMNode>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIDOMNode))
        );
    }
    impl Clone for nsIDOMNode {
        fn clone(&self) -> Self {
            *self
        }
    }
    pub const kNameSpaceID_None: i32 = 0;
    pub type PLHashNumber = root::PRUint32;
    pub type PLHashFunction = ::std::option::Option<
        unsafe extern "C" fn(key: *const ::std::os::raw::c_void) -> root::PLHashNumber,
    >;
    pub type PLHashComparator = ::std::option::Option<
        unsafe extern "C" fn(v1: *const ::std::os::raw::c_void, v2: *const ::std::os::raw::c_void)
            -> root::PRIntn,
    >;
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct PLHashAllocOps {
        pub allocTable: ::std::option::Option<
            unsafe extern "C" fn(pool: *mut ::std::os::raw::c_void, size: root::PRSize)
                -> *mut ::std::os::raw::c_void,
        >,
        pub freeTable: ::std::option::Option<
            unsafe extern "C" fn(
                pool: *mut ::std::os::raw::c_void,
                item: *mut ::std::os::raw::c_void,
            ),
        >,
        pub allocEntry: ::std::option::Option<
            unsafe extern "C" fn(
                pool: *mut ::std::os::raw::c_void,
                key: *const ::std::os::raw::c_void,
            ) -> *mut root::PLHashEntry,
        >,
        pub freeEntry: ::std::option::Option<
            unsafe extern "C" fn(
                pool: *mut ::std::os::raw::c_void,
                he: *mut root::PLHashEntry,
                flag: root::PRUintn,
            ),
        >,
    }
    #[test]
    fn bindgen_test_layout_PLHashAllocOps() {
        assert_eq!(
            ::std::mem::size_of::<PLHashAllocOps>(),
            32usize,
            concat!("Size of: ", stringify!(PLHashAllocOps))
        );
        assert_eq!(
            ::std::mem::align_of::<PLHashAllocOps>(),
            8usize,
            concat!("Alignment of ", stringify!(PLHashAllocOps))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLHashAllocOps>())).allocTable as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(PLHashAllocOps),
                "::",
                stringify!(allocTable)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLHashAllocOps>())).freeTable as *const _ as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(PLHashAllocOps),
                "::",
                stringify!(freeTable)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLHashAllocOps>())).allocEntry as *const _ as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(PLHashAllocOps),
                "::",
                stringify!(allocEntry)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLHashAllocOps>())).freeEntry as *const _ as usize },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(PLHashAllocOps),
                "::",
                stringify!(freeEntry)
            )
        );
    }
    impl Clone for PLHashAllocOps {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct PLHashEntry {
        pub next: *mut root::PLHashEntry,
        pub keyHash: root::PLHashNumber,
        pub key: *const ::std::os::raw::c_void,
        pub value: *mut ::std::os::raw::c_void,
    }
    #[test]
    fn bindgen_test_layout_PLHashEntry() {
        assert_eq!(
            ::std::mem::size_of::<PLHashEntry>(),
            32usize,
            concat!("Size of: ", stringify!(PLHashEntry))
        );
        assert_eq!(
            ::std::mem::align_of::<PLHashEntry>(),
            8usize,
            concat!("Alignment of ", stringify!(PLHashEntry))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLHashEntry>())).next as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(PLHashEntry),
                "::",
                stringify!(next)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLHashEntry>())).keyHash as *const _ as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(PLHashEntry),
                "::",
                stringify!(keyHash)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLHashEntry>())).key as *const _ as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(PLHashEntry),
                "::",
                stringify!(key)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLHashEntry>())).value as *const _ as usize },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(PLHashEntry),
                "::",
                stringify!(value)
            )
        );
    }
    impl Clone for PLHashEntry {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct PLHashTable {
        pub buckets: *mut *mut root::PLHashEntry,
        pub nentries: root::PRUint32,
        pub shift: root::PRUint32,
        pub keyHash: root::PLHashFunction,
        pub keyCompare: root::PLHashComparator,
        pub valueCompare: root::PLHashComparator,
        pub allocOps: *const root::PLHashAllocOps,
        pub allocPriv: *mut ::std::os::raw::c_void,
    }
    #[test]
    fn bindgen_test_layout_PLHashTable() {
        assert_eq!(
            ::std::mem::size_of::<PLHashTable>(),
            56usize,
            concat!("Size of: ", stringify!(PLHashTable))
        );
        assert_eq!(
            ::std::mem::align_of::<PLHashTable>(),
            8usize,
            concat!("Alignment of ", stringify!(PLHashTable))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLHashTable>())).buckets as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(PLHashTable),
                "::",
                stringify!(buckets)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLHashTable>())).nentries as *const _ as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(PLHashTable),
                "::",
                stringify!(nentries)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLHashTable>())).shift as *const _ as usize },
            12usize,
            concat!(
                "Offset of field: ",
                stringify!(PLHashTable),
                "::",
                stringify!(shift)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLHashTable>())).keyHash as *const _ as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(PLHashTable),
                "::",
                stringify!(keyHash)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLHashTable>())).keyCompare as *const _ as usize },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(PLHashTable),
                "::",
                stringify!(keyCompare)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLHashTable>())).valueCompare as *const _ as usize },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(PLHashTable),
                "::",
                stringify!(valueCompare)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLHashTable>())).allocOps as *const _ as usize },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(PLHashTable),
                "::",
                stringify!(allocOps)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<PLHashTable>())).allocPriv as *const _ as usize },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(PLHashTable),
                "::",
                stringify!(allocPriv)
            )
        );
    }
    impl Clone for PLHashTable {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIVariant {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIVariant_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsIVariant() {
        assert_eq!(
            ::std::mem::size_of::<nsIVariant>(),
            8usize,
            concat!("Size of: ", stringify!(nsIVariant))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIVariant>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIVariant))
        );
    }
    impl Clone for nsIVariant {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    pub struct nsNodeInfoManager {
        pub mRefCnt: root::nsCycleCollectingAutoRefCnt,
        pub mNodeInfoHash: *mut root::PLHashTable,
        pub mDocument: *mut root::nsIDocument,
        pub mNonDocumentNodeInfos: u32,
        pub mPrincipal: root::nsCOMPtr,
        pub mDefaultPrincipal: root::nsCOMPtr,
        pub mTextNodeInfo: *mut root::mozilla::dom::NodeInfo,
        pub mCommentNodeInfo: *mut root::mozilla::dom::NodeInfo,
        pub mDocumentNodeInfo: *mut root::mozilla::dom::NodeInfo,
        pub mBindingManager: root::RefPtr<root::nsBindingManager>,
        pub mRecentlyUsedNodeInfos: [*mut root::mozilla::dom::NodeInfo; 31usize],
        pub mSVGEnabled: root::nsNodeInfoManager_Tri,
        pub mMathMLEnabled: root::nsNodeInfoManager_Tri,
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsNodeInfoManager_cycleCollection {
        pub _base: root::nsCycleCollectionParticipant,
    }
    #[test]
    fn bindgen_test_layout_nsNodeInfoManager_cycleCollection() {
        assert_eq!(
            ::std::mem::size_of::<nsNodeInfoManager_cycleCollection>(),
            16usize,
            concat!("Size of: ", stringify!(nsNodeInfoManager_cycleCollection))
        );
        assert_eq!(
            ::std::mem::align_of::<nsNodeInfoManager_cycleCollection>(),
            8usize,
            concat!(
                "Alignment of ",
                stringify!(nsNodeInfoManager_cycleCollection)
            )
        );
    }
    impl Clone for nsNodeInfoManager_cycleCollection {
        fn clone(&self) -> Self {
            *self
        }
    }
    pub type nsNodeInfoManager_HasThreadSafeRefCnt = root::mozilla::FalseType;
    pub const nsNodeInfoManager_Tri_eTriUnset: root::nsNodeInfoManager_Tri = 0;
    pub const nsNodeInfoManager_Tri_eTriFalse: root::nsNodeInfoManager_Tri = 1;
    pub const nsNodeInfoManager_Tri_eTriTrue: root::nsNodeInfoManager_Tri = 2;
    pub type nsNodeInfoManager_Tri = u32;
    extern "C" {
        #[link_name = "\u{1}_ZN17nsNodeInfoManager21_cycleCollectorGlobalE"]
        pub static mut nsNodeInfoManager__cycleCollectorGlobal:
            root::nsNodeInfoManager_cycleCollection;
    }
    #[test]
    fn bindgen_test_layout_nsNodeInfoManager() {
        assert_eq!(
            ::std::mem::size_of::<nsNodeInfoManager>(),
            336usize,
            concat!("Size of: ", stringify!(nsNodeInfoManager))
        );
        assert_eq!(
            ::std::mem::align_of::<nsNodeInfoManager>(),
            8usize,
            concat!("Alignment of ", stringify!(nsNodeInfoManager))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsNodeInfoManager>())).mRefCnt as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsNodeInfoManager),
                "::",
                stringify!(mRefCnt)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsNodeInfoManager>())).mNodeInfoHash as *const _ as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsNodeInfoManager),
                "::",
                stringify!(mNodeInfoHash)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsNodeInfoManager>())).mDocument as *const _ as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(nsNodeInfoManager),
                "::",
                stringify!(mDocument)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsNodeInfoManager>())).mNonDocumentNodeInfos as *const _
                    as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(nsNodeInfoManager),
                "::",
                stringify!(mNonDocumentNodeInfos)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsNodeInfoManager>())).mPrincipal as *const _ as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(nsNodeInfoManager),
                "::",
                stringify!(mPrincipal)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsNodeInfoManager>())).mDefaultPrincipal as *const _ as usize
            },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(nsNodeInfoManager),
                "::",
                stringify!(mDefaultPrincipal)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsNodeInfoManager>())).mTextNodeInfo as *const _ as usize
            },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(nsNodeInfoManager),
                "::",
                stringify!(mTextNodeInfo)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsNodeInfoManager>())).mCommentNodeInfo as *const _ as usize
            },
            56usize,
            concat!(
                "Offset of field: ",
                stringify!(nsNodeInfoManager),
                "::",
                stringify!(mCommentNodeInfo)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsNodeInfoManager>())).mDocumentNodeInfo as *const _ as usize
            },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(nsNodeInfoManager),
                "::",
                stringify!(mDocumentNodeInfo)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsNodeInfoManager>())).mBindingManager as *const _ as usize
            },
            72usize,
            concat!(
                "Offset of field: ",
                stringify!(nsNodeInfoManager),
                "::",
                stringify!(mBindingManager)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsNodeInfoManager>())).mRecentlyUsedNodeInfos as *const _
                    as usize
            },
            80usize,
            concat!(
                "Offset of field: ",
                stringify!(nsNodeInfoManager),
                "::",
                stringify!(mRecentlyUsedNodeInfos)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsNodeInfoManager>())).mSVGEnabled as *const _ as usize
            },
            328usize,
            concat!(
                "Offset of field: ",
                stringify!(nsNodeInfoManager),
                "::",
                stringify!(mSVGEnabled)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsNodeInfoManager>())).mMathMLEnabled as *const _ as usize
            },
            332usize,
            concat!(
                "Offset of field: ",
                stringify!(nsNodeInfoManager),
                "::",
                stringify!(mMathMLEnabled)
            )
        );
    }
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsPropertyTable {
        pub mPropertyList: *mut root::nsPropertyTable_PropertyList,
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsPropertyTable_PropertyList {
        _unused: [u8; 0],
    }
    impl Clone for nsPropertyTable_PropertyList {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[test]
    fn bindgen_test_layout_nsPropertyTable() {
        assert_eq!(
            ::std::mem::size_of::<nsPropertyTable>(),
            8usize,
            concat!("Size of: ", stringify!(nsPropertyTable))
        );
        assert_eq!(
            ::std::mem::align_of::<nsPropertyTable>(),
            8usize,
            concat!("Alignment of ", stringify!(nsPropertyTable))
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPropertyTable>())).mPropertyList as *const _ as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPropertyTable),
                "::",
                stringify!(mPropertyList)
            )
        );
    }
    pub type nsTObserverArray_base_index_type = usize;
    pub type nsTObserverArray_base_size_type = usize;
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsTObserverArray_base_Iterator_base {
        pub mPosition: root::nsTObserverArray_base_index_type,
        pub mNext: *mut root::nsTObserverArray_base_Iterator_base,
    }
    #[test]
    fn bindgen_test_layout_nsTObserverArray_base_Iterator_base() {
        assert_eq!(
            ::std::mem::size_of::<nsTObserverArray_base_Iterator_base>(),
            16usize,
            concat!("Size of: ", stringify!(nsTObserverArray_base_Iterator_base))
        );
        assert_eq!(
            ::std::mem::align_of::<nsTObserverArray_base_Iterator_base>(),
            8usize,
            concat!(
                "Alignment of ",
                stringify!(nsTObserverArray_base_Iterator_base)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsTObserverArray_base_Iterator_base>())).mPosition
                    as *const _ as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsTObserverArray_base_Iterator_base),
                "::",
                stringify!(mPosition)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsTObserverArray_base_Iterator_base>())).mNext as *const _
                    as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsTObserverArray_base_Iterator_base),
                "::",
                stringify!(mNext)
            )
        );
    }
    impl Clone for nsTObserverArray_base_Iterator_base {
        fn clone(&self) -> Self {
            *self
        }
    }
    pub type nsAutoTObserverArray_elem_type<T> = T;
    pub type nsAutoTObserverArray_array_type<T> = root::nsTArray<T>;
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsAutoTObserverArray_Iterator {
        pub _base: root::nsTObserverArray_base_Iterator_base,
        pub mArray: *mut root::nsAutoTObserverArray_Iterator_array_type,
    }
    pub type nsAutoTObserverArray_Iterator_array_type = u8;
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsAutoTObserverArray_ForwardIterator {
        pub _base: root::nsAutoTObserverArray_Iterator,
    }
    pub type nsAutoTObserverArray_ForwardIterator_array_type = u8;
    pub type nsAutoTObserverArray_ForwardIterator_base_type = root::nsAutoTObserverArray_Iterator;
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsAutoTObserverArray_EndLimitedIterator {
        pub _base: root::nsAutoTObserverArray_ForwardIterator,
        pub mEnd: root::nsAutoTObserverArray_ForwardIterator,
    }
    pub type nsAutoTObserverArray_EndLimitedIterator_array_type = u8;
    pub type nsAutoTObserverArray_EndLimitedIterator_base_type =
        root::nsAutoTObserverArray_Iterator;
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsAutoTObserverArray_BackwardIterator {
        pub _base: root::nsAutoTObserverArray_Iterator,
    }
    pub type nsAutoTObserverArray_BackwardIterator_array_type = u8;
    pub type nsAutoTObserverArray_BackwardIterator_base_type = root::nsAutoTObserverArray_Iterator;
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsTObserverArray {
        pub _address: u8,
    }
    pub type nsTObserverArray_base_type = u8;
    pub type nsTObserverArray_size_type = root::nsTObserverArray_base_size_type;
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIDOMEventTarget {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIDOMEventTarget_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsIDOMEventTarget() {
        assert_eq!(
            ::std::mem::size_of::<nsIDOMEventTarget>(),
            8usize,
            concat!("Size of: ", stringify!(nsIDOMEventTarget))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIDOMEventTarget>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIDOMEventTarget))
        );
    }
    impl Clone for nsIDOMEventTarget {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsAttrChildContentList {
        _unused: [u8; 0],
    }
    impl Clone for nsAttrChildContentList {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsCSSSelectorList {
        _unused: [u8; 0],
    }
    impl Clone for nsCSSSelectorList {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsRange {
        _unused: [u8; 0],
    }
    impl Clone for nsRange {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct RawServoSelectorList {
        _unused: [u8; 0],
    }
    impl Clone for RawServoSelectorList {
        fn clone(&self) -> Self {
            *self
        }
    }
    pub const NODE_HAS_LISTENERMANAGER: root::_bindgen_ty_77 = 4;
    pub const NODE_HAS_PROPERTIES: root::_bindgen_ty_77 = 8;
    pub const NODE_IS_ANONYMOUS_ROOT: root::_bindgen_ty_77 = 16;
    pub const NODE_IS_IN_NATIVE_ANONYMOUS_SUBTREE: root::_bindgen_ty_77 = 32;
    pub const NODE_IS_NATIVE_ANONYMOUS_ROOT: root::_bindgen_ty_77 = 64;
    pub const NODE_FORCE_XBL_BINDINGS: root::_bindgen_ty_77 = 128;
    pub const NODE_MAY_BE_IN_BINDING_MNGR: root::_bindgen_ty_77 = 256;
    pub const NODE_IS_EDITABLE: root::_bindgen_ty_77 = 512;
    pub const NODE_IS_NATIVE_ANONYMOUS: root::_bindgen_ty_77 = 1024;
    pub const NODE_IS_IN_SHADOW_TREE: root::_bindgen_ty_77 = 2048;
    pub const NODE_HAS_EMPTY_SELECTOR: root::_bindgen_ty_77 = 4096;
    pub const NODE_HAS_SLOW_SELECTOR: root::_bindgen_ty_77 = 8192;
    pub const NODE_HAS_EDGE_CHILD_SELECTOR: root::_bindgen_ty_77 = 16384;
    pub const NODE_HAS_SLOW_SELECTOR_LATER_SIBLINGS: root::_bindgen_ty_77 = 32768;
    pub const NODE_ALL_SELECTOR_FLAGS: root::_bindgen_ty_77 = 61440;
    pub const NODE_NEEDS_FRAME: root::_bindgen_ty_77 = 65536;
    pub const NODE_DESCENDANTS_NEED_FRAMES: root::_bindgen_ty_77 = 131072;
    pub const NODE_HAS_ACCESSKEY: root::_bindgen_ty_77 = 262144;
    pub const NODE_HAS_DIRECTION_RTL: root::_bindgen_ty_77 = 524288;
    pub const NODE_HAS_DIRECTION_LTR: root::_bindgen_ty_77 = 1048576;
    pub const NODE_ALL_DIRECTION_FLAGS: root::_bindgen_ty_77 = 1572864;
    pub const NODE_CHROME_ONLY_ACCESS: root::_bindgen_ty_77 = 2097152;
    pub const NODE_IS_ROOT_OF_CHROME_ONLY_ACCESS: root::_bindgen_ty_77 = 4194304;
    pub const NODE_TYPE_SPECIFIC_BITS_OFFSET: root::_bindgen_ty_77 = 21;
    pub type _bindgen_ty_77 = u32;
    /// An internal interface that abstracts some DOMNode-related parts that both
    /// nsIContent and nsIDocument share.  An instance of this interface has a list
    /// of nsIContent children and provides access to them.
    #[repr(C)]
    pub struct nsINode {
        pub _base: root::mozilla::dom::EventTarget,
        pub mNodeInfo: root::RefPtr<root::mozilla::dom::NodeInfo>,
        pub mParent: *mut root::nsINode,
        pub mNextSibling: *mut root::nsIContent,
        pub mPreviousSibling: *mut root::nsIContent,
        pub mFirstChild: *mut root::nsIContent,
        pub __bindgen_anon_1: root::nsINode__bindgen_ty_1,
        pub mSlots: *mut root::nsINode_nsSlots,
    }
    pub type nsINode_BoxQuadOptions = root::mozilla::dom::BoxQuadOptions;
    pub type nsINode_ConvertCoordinateOptions = root::mozilla::dom::ConvertCoordinateOptions;
    pub type nsINode_DocGroup = root::mozilla::dom::DocGroup;
    pub type nsINode_DOMPoint = root::mozilla::dom::DOMPoint;
    pub type nsINode_DOMPointInit = root::mozilla::dom::DOMPointInit;
    pub type nsINode_DOMQuad = root::mozilla::dom::DOMQuad;
    pub type nsINode_DOMRectReadOnly = root::mozilla::dom::DOMRectReadOnly;
    pub type nsINode_OwningNodeOrString = root::mozilla::dom::OwningNodeOrString;
    pub type nsINode_TextOrElementOrDocument = root::mozilla::dom::TextOrElementOrDocument;
    pub use self::super::root::mozilla::dom::CallerType as nsINode_CallerType;
    pub type nsINode_Sequence = u8;
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsINode_COMTypeInfo {
        pub _address: u8,
    }
    /// nsIDocument nodes
    pub const nsINode_eDOCUMENT: root::nsINode__bindgen_ty_2 = 2;
    /// nsIAttribute nodes
    pub const nsINode_eATTRIBUTE: root::nsINode__bindgen_ty_2 = 4;
    /// text nodes
    pub const nsINode_eTEXT: root::nsINode__bindgen_ty_2 = 8;
    /// xml processing instructions
    pub const nsINode_ePROCESSING_INSTRUCTION: root::nsINode__bindgen_ty_2 = 16;
    /// comment nodes
    pub const nsINode_eCOMMENT: root::nsINode__bindgen_ty_2 = 32;
    /// form control elements
    pub const nsINode_eHTML_FORM_CONTROL: root::nsINode__bindgen_ty_2 = 64;
    /// document fragments
    pub const nsINode_eDOCUMENT_FRAGMENT: root::nsINode__bindgen_ty_2 = 128;
    /// data nodes (comments, PIs, text). Nodes of this type always
    /// returns a non-null value for nsIContent::GetText()
    pub const nsINode_eDATA_NODE: root::nsINode__bindgen_ty_2 = 256;
    /// HTMLMediaElement
    pub const nsINode_eMEDIA: root::nsINode__bindgen_ty_2 = 512;
    /// animation elements
    pub const nsINode_eANIMATION: root::nsINode__bindgen_ty_2 = 1024;
    /// filter elements that implement SVGFilterPrimitiveStandardAttributes
    pub const nsINode_eFILTER: root::nsINode__bindgen_ty_2 = 2048;
    /// Bit-flags to pass (or'ed together) to IsNodeOfType()
    pub type nsINode__bindgen_ty_2 = u32;
    pub const nsINode_FlattenedParentType_eNotForStyle: root::nsINode_FlattenedParentType = 0;
    pub const nsINode_FlattenedParentType_eForStyle: root::nsINode_FlattenedParentType = 1;
    pub type nsINode_FlattenedParentType = u32;
    #[repr(C)]
    pub struct nsINode_nsSlots__bindgen_vtable(::std::os::raw::c_void);
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsINode_nsSlots {
        pub vtable_: *const nsINode_nsSlots__bindgen_vtable,
        /// A list of mutation observers
        pub mMutationObservers: [u64; 4usize],
        /// An object implementing nsIDOMNodeList for this content (childNodes)
        /// @see nsIDOMNodeList
        /// @see nsGenericHTMLElement::GetChildNodes
        pub mChildNodes: root::RefPtr<root::nsAttrChildContentList>,
        /// Weak reference to this node.  This is cleared by the destructor of
        /// nsNodeWeakReference.
        pub mWeakReference: *mut root::nsNodeWeakReference,
        /// A set of ranges which are in the selection and which have this node as
        /// their endpoints' common ancestor.  This is a UniquePtr instead of just a
        /// LinkedList, because that prevents us from pushing DOMSlots up to the next
        /// allocation bucket size, at the cost of some complexity.
        pub mCommonAncestorRanges: root::mozilla::UniquePtr<root::mozilla::LinkedList>,
        /// Number of descendant nodes in the uncomposed document that have been
        /// explicitly set as editable.
        pub mEditableDescendantCount: u32,
    }
    #[test]
    fn bindgen_test_layout_nsINode_nsSlots() {
        assert_eq!(
            ::std::mem::size_of::<nsINode_nsSlots>(),
            72usize,
            concat!("Size of: ", stringify!(nsINode_nsSlots))
        );
        assert_eq!(
            ::std::mem::align_of::<nsINode_nsSlots>(),
            8usize,
            concat!("Alignment of ", stringify!(nsINode_nsSlots))
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsINode_nsSlots>())).mMutationObservers as *const _ as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsINode_nsSlots),
                "::",
                stringify!(mMutationObservers)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsINode_nsSlots>())).mChildNodes as *const _ as usize },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(nsINode_nsSlots),
                "::",
                stringify!(mChildNodes)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsINode_nsSlots>())).mWeakReference as *const _ as usize
            },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(nsINode_nsSlots),
                "::",
                stringify!(mWeakReference)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsINode_nsSlots>())).mCommonAncestorRanges as *const _
                    as usize
            },
            56usize,
            concat!(
                "Offset of field: ",
                stringify!(nsINode_nsSlots),
                "::",
                stringify!(mCommonAncestorRanges)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsINode_nsSlots>())).mEditableDescendantCount as *const _
                    as usize
            },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(nsINode_nsSlots),
                "::",
                stringify!(mEditableDescendantCount)
            )
        );
    }
    #[repr(u32)]
    /// Boolean flags
    #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
    pub enum nsINode_BooleanFlag {
        NodeHasRenderingObservers = 0,
        IsInDocument = 1,
        ParentIsContent = 2,
        NodeIsElement = 3,
        ElementHasID = 4,
        ElementMayHaveClass = 5,
        ElementMayHaveStyle = 6,
        ElementHasName = 7,
        ElementMayHaveContentEditableAttr = 8,
        NodeIsCommonAncestorForRangeInSelection = 9,
        NodeIsDescendantOfCommonAncestorForRangeInSelection = 10,
        NodeIsCCMarkedRoot = 11,
        NodeIsCCBlackTree = 12,
        NodeIsPurpleRoot = 13,
        ElementHasLockedStyleStates = 14,
        ElementHasPointerLock = 15,
        NodeMayHaveDOMMutationObserver = 16,
        NodeIsContent = 17,
        ElementHasAnimations = 18,
        NodeHasValidDirAttribute = 19,
        NodeHasDirAutoSet = 20,
        NodeHasTextNodeDirectionalityMap = 21,
        NodeAncestorHasDirAuto = 22,
        ElementIsInStyleScope = 23,
        ElementIsScopedStyleRoot = 24,
        NodeHandlingClick = 25,
        NodeHasRelevantHoverRules = 26,
        ElementHasWeirdParserInsertionMode = 27,
        ParserHasNotified = 28,
        MayBeApzAware = 29,
        ElementMayHaveAnonymousChildren = 30,
        NodeMayHaveChildrenWithLayoutBoxesDisabled = 31,
        BooleanFlagCount = 32,
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsINode__bindgen_ty_1 {
        pub mPrimaryFrame: root::__BindgenUnionField<*mut root::nsIFrame>,
        pub mSubtreeRoot: root::__BindgenUnionField<*mut root::nsINode>,
        pub bindgen_union_field: u64,
    }
    #[test]
    fn bindgen_test_layout_nsINode__bindgen_ty_1() {
        assert_eq!(
            ::std::mem::size_of::<nsINode__bindgen_ty_1>(),
            8usize,
            concat!("Size of: ", stringify!(nsINode__bindgen_ty_1))
        );
        assert_eq!(
            ::std::mem::align_of::<nsINode__bindgen_ty_1>(),
            8usize,
            concat!("Alignment of ", stringify!(nsINode__bindgen_ty_1))
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsINode__bindgen_ty_1>())).mPrimaryFrame as *const _ as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsINode__bindgen_ty_1),
                "::",
                stringify!(mPrimaryFrame)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsINode__bindgen_ty_1>())).mSubtreeRoot as *const _ as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsINode__bindgen_ty_1),
                "::",
                stringify!(mSubtreeRoot)
            )
        );
    }
    impl Clone for nsINode__bindgen_ty_1 {
        fn clone(&self) -> Self {
            *self
        }
    }
    pub const nsINode_ELEMENT_NODE: ::std::os::raw::c_ushort = 1;
    pub const nsINode_ATTRIBUTE_NODE: ::std::os::raw::c_ushort = 2;
    pub const nsINode_TEXT_NODE: ::std::os::raw::c_ushort = 3;
    pub const nsINode_CDATA_SECTION_NODE: ::std::os::raw::c_ushort = 4;
    pub const nsINode_ENTITY_REFERENCE_NODE: ::std::os::raw::c_ushort = 5;
    pub const nsINode_ENTITY_NODE: ::std::os::raw::c_ushort = 6;
    pub const nsINode_PROCESSING_INSTRUCTION_NODE: ::std::os::raw::c_ushort = 7;
    pub const nsINode_COMMENT_NODE: ::std::os::raw::c_ushort = 8;
    pub const nsINode_DOCUMENT_NODE: ::std::os::raw::c_ushort = 9;
    pub const nsINode_DOCUMENT_TYPE_NODE: ::std::os::raw::c_ushort = 10;
    pub const nsINode_DOCUMENT_FRAGMENT_NODE: ::std::os::raw::c_ushort = 11;
    pub const nsINode_NOTATION_NODE: ::std::os::raw::c_ushort = 12;
    #[test]
    fn bindgen_test_layout_nsINode() {
        assert_eq!(
            ::std::mem::size_of::<nsINode>(),
            88usize,
            concat!("Size of: ", stringify!(nsINode))
        );
        assert_eq!(
            ::std::mem::align_of::<nsINode>(),
            8usize,
            concat!("Alignment of ", stringify!(nsINode))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsINode>())).mNodeInfo as *const _ as usize },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(nsINode),
                "::",
                stringify!(mNodeInfo)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsINode>())).mParent as *const _ as usize },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(nsINode),
                "::",
                stringify!(mParent)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsINode>())).mNextSibling as *const _ as usize },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(nsINode),
                "::",
                stringify!(mNextSibling)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsINode>())).mPreviousSibling as *const _ as usize },
            56usize,
            concat!(
                "Offset of field: ",
                stringify!(nsINode),
                "::",
                stringify!(mPreviousSibling)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsINode>())).mFirstChild as *const _ as usize },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(nsINode),
                "::",
                stringify!(mFirstChild)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsINode>())).mSlots as *const _ as usize },
            80usize,
            concat!(
                "Offset of field: ",
                stringify!(nsINode),
                "::",
                stringify!(mSlots)
            )
        );
    }
    /// Functions to create content, to be used only inside Gecko
    /// (mozilla/content and mozilla/layout).
    #[repr(C)]
    pub struct nsIContent {
        pub _base: root::nsINode,
    }
    pub type nsIContent_IMEState = root::mozilla::widget::IMEState;
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIContent_COMTypeInfo {
        pub _address: u8,
    }
    /// All XBL flattened tree children of the node, as well as :before and
    /// :after anonymous content and native anonymous children.
    ///
    /// @note the result children order is
    /// 1. :before generated node
    /// 2. XBL flattened tree children of this node
    /// 3. native anonymous nodes
    /// 4. :after generated node
    pub const nsIContent_eAllChildren: root::nsIContent__bindgen_ty_1 = 0;
    /// All XBL explicit children of the node (see
    /// http://www.w3.org/TR/xbl/#explicit3 ), as well as :before and :after
    /// anonymous content and native anonymous children.
    ///
    /// @note the result children order is
    /// 1. :before generated node
    /// 2. XBL explicit children of the node
    /// 3. native anonymous nodes
    /// 4. :after generated node
    pub const nsIContent_eAllButXBL: root::nsIContent__bindgen_ty_1 = 1;
    /// Skip native anonymous content created for placeholder of HTML input,
    /// used in conjunction with eAllChildren or eAllButXBL.
    pub const nsIContent_eSkipPlaceholderContent: root::nsIContent__bindgen_ty_1 = 2;
    /// Skip native anonymous content created by ancestor frames of the root
    /// element's primary frame, such as scrollbar elements created by the root
    /// scroll frame.
    pub const nsIContent_eSkipDocumentLevelNativeAnonymousContent: root::nsIContent__bindgen_ty_1 =
        4;
    pub type nsIContent__bindgen_ty_1 = u32;
    #[repr(C)]
    pub struct nsIContent_nsExtendedContentSlots__bindgen_vtable(::std::os::raw::c_void);
    /// Lazily allocated extended slots to avoid
    /// that may only be instantiated when a content object is accessed
    /// through the DOM. Rather than burn actual slots in the content
    /// objects for each of these instance variables, we put them off
    /// in a side structure that's only allocated when the content is
    /// accessed through the DOM.
    #[repr(C)]
    pub struct nsIContent_nsExtendedContentSlots {
        pub vtable_: *const nsIContent_nsExtendedContentSlots__bindgen_vtable,
        /// The nearest enclosing content node with a binding that created us.
        /// @see nsIContent::GetBindingParent
        pub mBindingParent: *mut root::nsIContent,
        /// @see nsIContent::GetXBLInsertionPoint
        pub mXBLInsertionPoint: root::nsCOMPtr,
        /// @see nsIContent::GetContainingShadow
        pub mContainingShadow: root::RefPtr<root::mozilla::dom::ShadowRoot>,
        /// @see nsIContent::GetAssignedSlot
        pub mAssignedSlot: root::RefPtr<root::mozilla::dom::HTMLSlotElement>,
    }
    #[test]
    fn bindgen_test_layout_nsIContent_nsExtendedContentSlots() {
        assert_eq!(
            ::std::mem::size_of::<nsIContent_nsExtendedContentSlots>(),
            40usize,
            concat!("Size of: ", stringify!(nsIContent_nsExtendedContentSlots))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIContent_nsExtendedContentSlots>(),
            8usize,
            concat!(
                "Alignment of ",
                stringify!(nsIContent_nsExtendedContentSlots)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIContent_nsExtendedContentSlots>())).mBindingParent
                    as *const _ as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIContent_nsExtendedContentSlots),
                "::",
                stringify!(mBindingParent)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIContent_nsExtendedContentSlots>())).mXBLInsertionPoint
                    as *const _ as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIContent_nsExtendedContentSlots),
                "::",
                stringify!(mXBLInsertionPoint)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIContent_nsExtendedContentSlots>())).mContainingShadow
                    as *const _ as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIContent_nsExtendedContentSlots),
                "::",
                stringify!(mContainingShadow)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIContent_nsExtendedContentSlots>())).mAssignedSlot
                    as *const _ as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIContent_nsExtendedContentSlots),
                "::",
                stringify!(mAssignedSlot)
            )
        );
    }
    #[repr(C)]
    pub struct nsIContent_nsContentSlots {
        pub _base: root::nsINode_nsSlots,
        pub mExtendedSlots: root::mozilla::UniquePtr<root::nsIContent_nsExtendedContentSlots>,
    }
    #[test]
    fn bindgen_test_layout_nsIContent_nsContentSlots() {
        assert_eq!(
            ::std::mem::size_of::<nsIContent_nsContentSlots>(),
            80usize,
            concat!("Size of: ", stringify!(nsIContent_nsContentSlots))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIContent_nsContentSlots>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIContent_nsContentSlots))
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIContent_nsContentSlots>())).mExtendedSlots as *const _
                    as usize
            },
            72usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIContent_nsContentSlots),
                "::",
                stringify!(mExtendedSlots)
            )
        );
    }
    pub const nsIContent_ETabFocusType_eTabFocus_textControlsMask: root::nsIContent_ETabFocusType =
        1;
    pub const nsIContent_ETabFocusType_eTabFocus_formElementsMask: root::nsIContent_ETabFocusType =
        2;
    pub const nsIContent_ETabFocusType_eTabFocus_linksMask: root::nsIContent_ETabFocusType = 4;
    pub const nsIContent_ETabFocusType_eTabFocus_any: root::nsIContent_ETabFocusType = 7;
    pub type nsIContent_ETabFocusType = u32;
    extern "C" {
        #[link_name = "\u{1}_ZN10nsIContent14sTabFocusModelE"]
        pub static mut nsIContent_sTabFocusModel: i32;
    }
    extern "C" {
        #[link_name = "\u{1}_ZN10nsIContent26sTabFocusModelAppliesToXULE"]
        pub static mut nsIContent_sTabFocusModelAppliesToXUL: bool;
    }
    #[test]
    fn bindgen_test_layout_nsIContent() {
        assert_eq!(
            ::std::mem::size_of::<nsIContent>(),
            88usize,
            concat!("Size of: ", stringify!(nsIContent))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIContent>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIContent))
        );
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsFrameManagerBase {
        pub mPresShell: *mut root::nsIPresShell,
        pub mRootFrame: *mut root::nsIFrame,
        pub mDisplayNoneMap: *mut root::nsFrameManagerBase_UndisplayedMap,
        pub mDisplayContentsMap: *mut root::nsFrameManagerBase_UndisplayedMap,
        pub mIsDestroyingFrames: bool,
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsFrameManagerBase_UndisplayedMap {
        _unused: [u8; 0],
    }
    impl Clone for nsFrameManagerBase_UndisplayedMap {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[test]
    fn bindgen_test_layout_nsFrameManagerBase() {
        assert_eq!(
            ::std::mem::size_of::<nsFrameManagerBase>(),
            40usize,
            concat!("Size of: ", stringify!(nsFrameManagerBase))
        );
        assert_eq!(
            ::std::mem::align_of::<nsFrameManagerBase>(),
            8usize,
            concat!("Alignment of ", stringify!(nsFrameManagerBase))
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsFrameManagerBase>())).mPresShell as *const _ as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFrameManagerBase),
                "::",
                stringify!(mPresShell)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsFrameManagerBase>())).mRootFrame as *const _ as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFrameManagerBase),
                "::",
                stringify!(mRootFrame)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsFrameManagerBase>())).mDisplayNoneMap as *const _ as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFrameManagerBase),
                "::",
                stringify!(mDisplayNoneMap)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsFrameManagerBase>())).mDisplayContentsMap as *const _
                    as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFrameManagerBase),
                "::",
                stringify!(mDisplayContentsMap)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsFrameManagerBase>())).mIsDestroyingFrames as *const _
                    as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(nsFrameManagerBase),
                "::",
                stringify!(mIsDestroyingFrames)
            )
        );
    }
    impl Clone for nsFrameManagerBase {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIWeakReference {
        pub _base: root::nsISupports,
        pub mObject: *mut root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIWeakReference_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsIWeakReference() {
        assert_eq!(
            ::std::mem::size_of::<nsIWeakReference>(),
            16usize,
            concat!("Size of: ", stringify!(nsIWeakReference))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIWeakReference>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIWeakReference))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsIWeakReference>())).mObject as *const _ as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIWeakReference),
                "::",
                stringify!(mObject)
            )
        );
    }
    impl Clone for nsIWeakReference {
        fn clone(&self) -> Self {
            *self
        }
    }
    pub type nsWeakPtr = root::nsCOMPtr;
    /// templated hashtable class maps keys to reference pointers.
    /// See nsBaseHashtable for complete declaration.
    /// @param KeyClass a wrapper-class for the hashtable key, see nsHashKeys.h
    /// for a complete specification.
    /// @param PtrType the reference-type being wrapped
    /// @see nsDataHashtable, nsClassHashtable
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsRefPtrHashtable {
        pub _address: u8,
    }
    pub type nsRefPtrHashtable_KeyType = [u8; 0usize];
    pub type nsRefPtrHashtable_UserDataType<PtrType> = *mut PtrType;
    pub type nsRefPtrHashtable_base_type = u8;
    /// templated hashtable class maps keys to C++ object pointers.
    /// See nsBaseHashtable for complete declaration.
    /// @param KeyClass a wrapper-class for the hashtable key, see nsHashKeys.h
    /// for a complete specification.
    /// @param Class the class-type being wrapped
    /// @see nsInterfaceHashtable, nsClassHashtable
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsClassHashtable {
        pub _address: u8,
    }
    pub type nsClassHashtable_KeyType = [u8; 0usize];
    pub type nsClassHashtable_UserDataType<T> = *mut T;
    pub type nsClassHashtable_base_type = u8;
    #[repr(C)]
    pub struct nsPresArena {
        pub mFreeLists: [root::nsPresArena_FreeList; 211usize],
        pub mPool: [u64; 5usize],
        pub mArenaRefPtrs: [u64; 4usize],
    }
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsPresArena_FreeList {
        pub mEntries: root::nsTArray<*mut ::std::os::raw::c_void>,
        pub mEntrySize: usize,
        pub mEntriesEverAllocated: usize,
    }
    #[test]
    fn bindgen_test_layout_nsPresArena_FreeList() {
        assert_eq!(
            ::std::mem::size_of::<nsPresArena_FreeList>(),
            24usize,
            concat!("Size of: ", stringify!(nsPresArena_FreeList))
        );
        assert_eq!(
            ::std::mem::align_of::<nsPresArena_FreeList>(),
            8usize,
            concat!("Alignment of ", stringify!(nsPresArena_FreeList))
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPresArena_FreeList>())).mEntries as *const _ as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPresArena_FreeList),
                "::",
                stringify!(mEntries)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPresArena_FreeList>())).mEntrySize as *const _ as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPresArena_FreeList),
                "::",
                stringify!(mEntrySize)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPresArena_FreeList>())).mEntriesEverAllocated as *const _
                    as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPresArena_FreeList),
                "::",
                stringify!(mEntriesEverAllocated)
            )
        );
    }
    #[test]
    fn bindgen_test_layout_nsPresArena() {
        assert_eq!(
            ::std::mem::size_of::<nsPresArena>(),
            5136usize,
            concat!("Size of: ", stringify!(nsPresArena))
        );
        assert_eq!(
            ::std::mem::align_of::<nsPresArena>(),
            8usize,
            concat!("Alignment of ", stringify!(nsPresArena))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsPresArena>())).mFreeLists as *const _ as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPresArena),
                "::",
                stringify!(mFreeLists)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsPresArena>())).mPool as *const _ as usize },
            5064usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPresArena),
                "::",
                stringify!(mPool)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsPresArena>())).mArenaRefPtrs as *const _ as usize },
            5104usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPresArena),
                "::",
                stringify!(mArenaRefPtrs)
            )
        );
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct imgINotificationObserver {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct imgINotificationObserver_COMTypeInfo {
        pub _address: u8,
    }
    pub const imgINotificationObserver_SIZE_AVAILABLE:
        root::imgINotificationObserver__bindgen_ty_1 = 1;
    pub const imgINotificationObserver_FRAME_UPDATE: root::imgINotificationObserver__bindgen_ty_1 =
        2;
    pub const imgINotificationObserver_FRAME_COMPLETE:
        root::imgINotificationObserver__bindgen_ty_1 = 3;
    pub const imgINotificationObserver_LOAD_COMPLETE: root::imgINotificationObserver__bindgen_ty_1 =
        4;
    pub const imgINotificationObserver_DECODE_COMPLETE:
        root::imgINotificationObserver__bindgen_ty_1 = 5;
    pub const imgINotificationObserver_DISCARD: root::imgINotificationObserver__bindgen_ty_1 = 6;
    pub const imgINotificationObserver_UNLOCKED_DRAW: root::imgINotificationObserver__bindgen_ty_1 =
        7;
    pub const imgINotificationObserver_IS_ANIMATED: root::imgINotificationObserver__bindgen_ty_1 =
        8;
    pub const imgINotificationObserver_HAS_TRANSPARENCY:
        root::imgINotificationObserver__bindgen_ty_1 = 9;
    pub type imgINotificationObserver__bindgen_ty_1 = u32;
    #[test]
    fn bindgen_test_layout_imgINotificationObserver() {
        assert_eq!(
            ::std::mem::size_of::<imgINotificationObserver>(),
            8usize,
            concat!("Size of: ", stringify!(imgINotificationObserver))
        );
        assert_eq!(
            ::std::mem::align_of::<imgINotificationObserver>(),
            8usize,
            concat!("Alignment of ", stringify!(imgINotificationObserver))
        );
    }
    impl Clone for imgINotificationObserver {
        fn clone(&self) -> Self {
            *self
        }
    }
    /// Mutation observer interface
    ///
    /// See nsINode::AddMutationObserver, nsINode::RemoveMutationObserver for how to
    /// attach or remove your observers.
    ///
    /// WARNING: During these notifications, you are not allowed to perform
    /// any mutations to the current or any other document, or start a
    /// network load.  If you need to perform such operations do that
    /// during the _last_ nsIDocumentObserver::EndUpdate notification.  The
    /// expection for this is ParentChainChanged, where mutations should be
    /// done from an async event, as the notification might not be
    /// surrounded by BeginUpdate/EndUpdate calls.
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIMutationObserver {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIMutationObserver_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsIMutationObserver() {
        assert_eq!(
            ::std::mem::size_of::<nsIMutationObserver>(),
            8usize,
            concat!("Size of: ", stringify!(nsIMutationObserver))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIMutationObserver>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIMutationObserver))
        );
    }
    impl Clone for nsIMutationObserver {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIDocumentObserver {
        pub _base: root::nsIMutationObserver,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIDocumentObserver_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsIDocumentObserver() {
        assert_eq!(
            ::std::mem::size_of::<nsIDocumentObserver>(),
            8usize,
            concat!("Size of: ", stringify!(nsIDocumentObserver))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIDocumentObserver>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIDocumentObserver))
        );
    }
    impl Clone for nsIDocumentObserver {
        fn clone(&self) -> Self {
            *self
        }
    }
    /// There are two advantages to inheriting from nsStubDocumentObserver
    /// rather than directly from nsIDocumentObserver:
    /// 1. smaller compiled code size (since there's no need for the code
    /// for the empty virtual function implementations for every
    /// nsIDocumentObserver implementation)
    /// 2. the performance of document's loop over observers benefits from
    /// the fact that more of the functions called are the same (which
    /// can reduce instruction cache misses and perhaps improve branch
    /// prediction)
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsStubDocumentObserver {
        pub _base: root::nsIDocumentObserver,
    }
    #[test]
    fn bindgen_test_layout_nsStubDocumentObserver() {
        assert_eq!(
            ::std::mem::size_of::<nsStubDocumentObserver>(),
            8usize,
            concat!("Size of: ", stringify!(nsStubDocumentObserver))
        );
        assert_eq!(
            ::std::mem::align_of::<nsStubDocumentObserver>(),
            8usize,
            concat!("Alignment of ", stringify!(nsStubDocumentObserver))
        );
    }
    impl Clone for nsStubDocumentObserver {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsDocShell {
        _unused: [u8; 0],
    }
    impl Clone for nsDocShell {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsViewManager {
        _unused: [u8; 0],
    }
    impl Clone for nsViewManager {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsFrameSelection {
        _unused: [u8; 0],
    }
    impl Clone for nsFrameSelection {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsCSSFrameConstructor {
        _unused: [u8; 0],
    }
    impl Clone for nsCSSFrameConstructor {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct AutoWeakFrame {
        _unused: [u8; 0],
    }
    impl Clone for AutoWeakFrame {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct WeakFrame {
        _unused: [u8; 0],
    }
    impl Clone for WeakFrame {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsRefreshDriver {
        _unused: [u8; 0],
    }
    impl Clone for nsRefreshDriver {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    pub struct CapturingContentInfo {
        pub mAllowed: bool,
        pub mPointerLock: bool,
        pub mRetargetToElement: bool,
        pub mPreventDrag: bool,
        pub mContent: root::mozilla::StaticRefPtr<root::nsIContent>,
    }
    #[test]
    fn bindgen_test_layout_CapturingContentInfo() {
        assert_eq!(
            ::std::mem::size_of::<CapturingContentInfo>(),
            16usize,
            concat!("Size of: ", stringify!(CapturingContentInfo))
        );
        assert_eq!(
            ::std::mem::align_of::<CapturingContentInfo>(),
            8usize,
            concat!("Alignment of ", stringify!(CapturingContentInfo))
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<CapturingContentInfo>())).mAllowed as *const _ as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(CapturingContentInfo),
                "::",
                stringify!(mAllowed)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<CapturingContentInfo>())).mPointerLock as *const _ as usize
            },
            1usize,
            concat!(
                "Offset of field: ",
                stringify!(CapturingContentInfo),
                "::",
                stringify!(mPointerLock)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<CapturingContentInfo>())).mRetargetToElement as *const _
                    as usize
            },
            2usize,
            concat!(
                "Offset of field: ",
                stringify!(CapturingContentInfo),
                "::",
                stringify!(mRetargetToElement)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<CapturingContentInfo>())).mPreventDrag as *const _ as usize
            },
            3usize,
            concat!(
                "Offset of field: ",
                stringify!(CapturingContentInfo),
                "::",
                stringify!(mPreventDrag)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<CapturingContentInfo>())).mContent as *const _ as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(CapturingContentInfo),
                "::",
                stringify!(mContent)
            )
        );
    }
    /// Presentation shell interface. Presentation shells are the
    /// controlling point for managing the presentation of a document. The
    /// presentation shell holds a live reference to the document, the
    /// presentation context, the style manager, the style set and the root
    /// frame. <p>
    ///
    /// When this object is Release'd, it will release the document, the
    /// presentation context, the style manager, the style set and the root
    /// frame.
    #[repr(C)]
    pub struct nsIPresShell {
        pub _base: root::nsStubDocumentObserver,
        pub mDocument: root::nsCOMPtr,
        pub mPresContext: root::RefPtr<root::nsPresContext>,
        pub mStyleSet: root::mozilla::StyleSetHandle,
        pub mFrameConstructor: *mut root::nsCSSFrameConstructor,
        pub mViewManager: *mut root::nsViewManager,
        pub mFrameArena: root::nsPresArena,
        pub mSelection: root::RefPtr<root::nsFrameSelection>,
        pub mFrameManager: *mut root::nsFrameManagerBase,
        pub mForwardingContainer: u64,
        pub mDocAccessible: *mut root::mozilla::a11y::DocAccessible,
        pub mReflowContinueTimer: root::nsCOMPtr,
        pub mPaintCount: u64,
        pub mScrollPositionClampingScrollPortSize: root::nsSize,
        pub mAutoWeakFrames: *mut root::AutoWeakFrame,
        pub mWeakFrames: [u64; 4usize],
        pub mStyleCause: root::UniqueProfilerBacktrace,
        pub mReflowCause: root::UniqueProfilerBacktrace,
        pub mCanvasBackgroundColor: root::nscolor,
        pub mResolution: [u32; 2usize],
        pub mSelectionFlags: i16,
        pub mChangeNestCount: u16,
        pub mRenderFlags: root::nsIPresShell_RenderFlags,
        pub _bitfield_1: root::__BindgenBitfieldUnit<[u8; 3usize], u8>,
        pub mPresShellId: u32,
        pub mFontSizeInflationEmPerLine: u32,
        pub mFontSizeInflationMinTwips: u32,
        pub mFontSizeInflationLineThreshold: u32,
        pub mFontSizeInflationForceEnabled: bool,
        pub mFontSizeInflationDisabledInMasterProcess: bool,
        pub mFontSizeInflationEnabled: bool,
        pub mFontSizeInflationEnabledIsDirty: bool,
        pub mPaintingIsFrozen: bool,
        pub mIsNeverPainting: bool,
        pub mInFlush: bool,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIPresShell_COMTypeInfo {
        pub _address: u8,
    }
    pub type nsIPresShell_LayerManager = root::mozilla::layers::LayerManager;
    pub type nsIPresShell_SourceSurface = root::mozilla::gfx::SourceSurface;
    pub const nsIPresShell_eRenderFlag_STATE_IGNORING_VIEWPORT_SCROLLING:
        root::nsIPresShell_eRenderFlag = 1;
    pub const nsIPresShell_eRenderFlag_STATE_DRAWWINDOW_NOT_FLUSHING:
        root::nsIPresShell_eRenderFlag = 2;
    pub type nsIPresShell_eRenderFlag = u32;
    pub type nsIPresShell_RenderFlags = u8;
    pub const nsIPresShell_ResizeReflowOptions_eBSizeExact: root::nsIPresShell_ResizeReflowOptions =
        0;
    pub const nsIPresShell_ResizeReflowOptions_eBSizeLimit: root::nsIPresShell_ResizeReflowOptions =
        1;
    pub type nsIPresShell_ResizeReflowOptions = u32;
    pub const nsIPresShell_ScrollDirection_eHorizontal: root::nsIPresShell_ScrollDirection = 0;
    pub const nsIPresShell_ScrollDirection_eVertical: root::nsIPresShell_ScrollDirection = 1;
    pub const nsIPresShell_ScrollDirection_eEither: root::nsIPresShell_ScrollDirection = 2;
    /// Gets nearest scrollable frame from the specified content node. The frame
    /// is scrollable with overflow:scroll or overflow:auto in some direction when
    /// aDirection is eEither.  Otherwise, this returns a nearest frame that is
    /// scrollable in the specified direction.
    pub type nsIPresShell_ScrollDirection = u32;
    pub const nsIPresShell_IntrinsicDirty_eResize: root::nsIPresShell_IntrinsicDirty = 0;
    pub const nsIPresShell_IntrinsicDirty_eTreeChange: root::nsIPresShell_IntrinsicDirty = 1;
    pub const nsIPresShell_IntrinsicDirty_eStyleChange: root::nsIPresShell_IntrinsicDirty = 2;
    /// Tell the pres shell that a frame needs to be marked dirty and needs
    /// Reflow.  It's OK if this is an ancestor of the frame needing reflow as
    /// long as the ancestor chain between them doesn't cross a reflow root.
    ///
    /// The bit to add should be NS_FRAME_IS_DIRTY, NS_FRAME_HAS_DIRTY_CHILDREN
    /// or nsFrameState(0); passing 0 means that dirty bits won't be set on the
    /// frame or its ancestors/descendants, but that intrinsic widths will still
    /// be marked dirty.  Passing aIntrinsicDirty = eResize and aBitToAdd = 0
    /// would result in no work being done, so don't do that.
    pub type nsIPresShell_IntrinsicDirty = u32;
    pub const nsIPresShell_ReflowRootHandling_ePositionOrSizeChange:
        root::nsIPresShell_ReflowRootHandling = 0;
    pub const nsIPresShell_ReflowRootHandling_eNoPositionOrSizeChange:
        root::nsIPresShell_ReflowRootHandling = 1;
    pub const nsIPresShell_ReflowRootHandling_eInferFromBitToAdd:
        root::nsIPresShell_ReflowRootHandling = 2;
    pub type nsIPresShell_ReflowRootHandling = u32;
    pub const nsIPresShell_SCROLL_TOP: root::nsIPresShell__bindgen_ty_1 = 0;
    pub const nsIPresShell_SCROLL_BOTTOM: root::nsIPresShell__bindgen_ty_1 = 100;
    pub const nsIPresShell_SCROLL_LEFT: root::nsIPresShell__bindgen_ty_1 = 0;
    pub const nsIPresShell_SCROLL_RIGHT: root::nsIPresShell__bindgen_ty_1 = 100;
    pub const nsIPresShell_SCROLL_CENTER: root::nsIPresShell__bindgen_ty_1 = 50;
    pub const nsIPresShell_SCROLL_MINIMUM: root::nsIPresShell__bindgen_ty_1 = -1;
    pub type nsIPresShell__bindgen_ty_1 = i32;
    pub const nsIPresShell_WhenToScroll_SCROLL_ALWAYS: root::nsIPresShell_WhenToScroll = 0;
    pub const nsIPresShell_WhenToScroll_SCROLL_IF_NOT_VISIBLE: root::nsIPresShell_WhenToScroll = 1;
    pub const nsIPresShell_WhenToScroll_SCROLL_IF_NOT_FULLY_VISIBLE:
        root::nsIPresShell_WhenToScroll = 2;
    pub type nsIPresShell_WhenToScroll = u32;
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIPresShell_ScrollAxis {
        pub _bindgen_opaque_blob: u32,
    }
    #[test]
    fn bindgen_test_layout_nsIPresShell_ScrollAxis() {
        assert_eq!(
            ::std::mem::size_of::<nsIPresShell_ScrollAxis>(),
            4usize,
            concat!("Size of: ", stringify!(nsIPresShell_ScrollAxis))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIPresShell_ScrollAxis>(),
            4usize,
            concat!("Alignment of ", stringify!(nsIPresShell_ScrollAxis))
        );
    }
    impl Clone for nsIPresShell_ScrollAxis {
        fn clone(&self) -> Self {
            *self
        }
    }
    pub const nsIPresShell_SCROLL_FIRST_ANCESTOR_ONLY: root::nsIPresShell__bindgen_ty_2 = 1;
    pub const nsIPresShell_SCROLL_OVERFLOW_HIDDEN: root::nsIPresShell__bindgen_ty_2 = 2;
    pub const nsIPresShell_SCROLL_NO_PARENT_FRAMES: root::nsIPresShell__bindgen_ty_2 = 4;
    pub const nsIPresShell_SCROLL_SMOOTH: root::nsIPresShell__bindgen_ty_2 = 8;
    pub const nsIPresShell_SCROLL_SMOOTH_AUTO: root::nsIPresShell__bindgen_ty_2 = 16;
    pub type nsIPresShell__bindgen_ty_2 = u32;
    pub const nsIPresShell_RENDER_IS_UNTRUSTED: root::nsIPresShell__bindgen_ty_3 = 1;
    pub const nsIPresShell_RENDER_IGNORE_VIEWPORT_SCROLLING: root::nsIPresShell__bindgen_ty_3 = 2;
    pub const nsIPresShell_RENDER_CARET: root::nsIPresShell__bindgen_ty_3 = 4;
    pub const nsIPresShell_RENDER_USE_WIDGET_LAYERS: root::nsIPresShell__bindgen_ty_3 = 8;
    pub const nsIPresShell_RENDER_ASYNC_DECODE_IMAGES: root::nsIPresShell__bindgen_ty_3 = 16;
    pub const nsIPresShell_RENDER_DOCUMENT_RELATIVE: root::nsIPresShell__bindgen_ty_3 = 32;
    pub const nsIPresShell_RENDER_DRAWWINDOW_NOT_FLUSHING: root::nsIPresShell__bindgen_ty_3 = 64;
    /// Render the document into an arbitrary gfxContext
    /// Designed for getting a picture of a document or a piece of a document
    /// Note that callers will generally want to call FlushPendingNotifications
    /// to get an up-to-date view of the document
    /// @param aRect is the region to capture into the offscreen buffer, in the
    /// root frame's coordinate system (if aIgnoreViewportScrolling is false)
    /// or in the root scrolled frame's coordinate system
    /// (if aIgnoreViewportScrolling is true). The coordinates are in appunits.
    /// @param aFlags see below;
    /// set RENDER_IS_UNTRUSTED if the contents may be passed to malicious
    /// agents. E.g. we might choose not to paint the contents of sensitive widgets
    /// such as the file name in a file upload widget, and we might choose not
    /// to paint themes.
    /// set RENDER_IGNORE_VIEWPORT_SCROLLING to ignore
    /// clipping and scrollbar painting due to scrolling in the viewport
    /// set RENDER_CARET to draw the caret if one would be visible
    /// (by default the caret is never drawn)
    /// set RENDER_USE_LAYER_MANAGER to force rendering to go through
    /// the layer manager for the window. This may be unexpectedly slow
    /// (if the layer manager must read back data from the GPU) or low-quality
    /// (if the layer manager reads back pixel data and scales it
    /// instead of rendering using the appropriate scaling). It may also
    /// slow everything down if the area rendered does not correspond to the
    /// normal visible area of the window.
    /// set RENDER_ASYNC_DECODE_IMAGES to avoid having images synchronously
    /// decoded during rendering.
    /// (by default images decode synchronously with RenderDocument)
    /// set RENDER_DOCUMENT_RELATIVE to render the document as if there has been
    /// no scrolling and interpret |aRect| relative to the document instead of the
    /// CSS viewport. Only considered if RENDER_IGNORE_VIEWPORT_SCROLLING is set
    /// or the document is in ignore viewport scrolling mode
    /// (nsIPresShell::SetIgnoreViewportScrolling/IgnoringViewportScrolling).
    /// @param aBackgroundColor a background color to render onto
    /// @param aRenderedContext the gfxContext to render to. We render so that
    /// one CSS pixel in the source document is rendered to one unit in the current
    /// transform.
    pub type nsIPresShell__bindgen_ty_3 = u32;
    pub const nsIPresShell_RENDER_IS_IMAGE: root::nsIPresShell__bindgen_ty_4 = 256;
    pub const nsIPresShell_RENDER_AUTO_SCALE: root::nsIPresShell__bindgen_ty_4 = 128;
    pub type nsIPresShell__bindgen_ty_4 = u32;
    pub const nsIPresShell_FORCE_DRAW: root::nsIPresShell__bindgen_ty_5 = 1;
    pub const nsIPresShell_ADD_FOR_SUBDOC: root::nsIPresShell__bindgen_ty_5 = 2;
    pub const nsIPresShell_APPEND_UNSCROLLED_ONLY: root::nsIPresShell__bindgen_ty_5 = 4;
    /// Add a solid color item to the bottom of aList with frame aFrame and bounds
    /// aBounds. Checks first if this needs to be done by checking if aFrame is a
    /// canvas frame (if the FORCE_DRAW flag is passed then this check is skipped).
    /// aBackstopColor is composed behind the background color of the canvas, it is
    /// transparent by default.
    /// We attempt to make the background color part of the scrolled canvas (to reduce
    /// transparent layers), and if async scrolling is enabled (and the background
    /// is opaque) then we add a second, unscrolled item to handle the checkerboarding
    /// case.
    /// ADD_FOR_SUBDOC shoud be specified when calling this for a subdocument, and
    /// LayoutUseContainersForRootFrame might cause the whole list to be scrolled. In
    /// that case the second unscrolled item will be elided.
    /// APPEND_UNSCROLLED_ONLY only attempts to add the unscrolled item, so that we
    /// can add it manually after LayoutUseContainersForRootFrame has built the
    /// scrolling ContainerLayer.
    pub type nsIPresShell__bindgen_ty_5 = u32;
    pub const nsIPresShell_PaintFlags_PAINT_LAYERS: root::nsIPresShell_PaintFlags = 1;
    pub const nsIPresShell_PaintFlags_PAINT_COMPOSITE: root::nsIPresShell_PaintFlags = 2;
    pub const nsIPresShell_PaintFlags_PAINT_SYNC_DECODE_IMAGES: root::nsIPresShell_PaintFlags = 4;
    pub type nsIPresShell_PaintFlags = u32;
    pub const nsIPresShell_PaintType_PAINT_DEFAULT: root::nsIPresShell_PaintType = 0;
    pub const nsIPresShell_PaintType_PAINT_DELAYED_COMPRESS: root::nsIPresShell_PaintType = 1;
    /// Ensures that the refresh driver is running, and schedules a view
    /// manager flush on the next tick.
    ///
    /// @param aType PAINT_DELAYED_COMPRESS : Schedule a paint to be executed after a delay, and
    /// put FrameLayerBuilder in 'compressed' mode that avoids short cut optimizations.
    pub type nsIPresShell_PaintType = u32;
    extern "C" {
        #[link_name = "\u{1}_ZN12nsIPresShell12gCaptureInfoE"]
        pub static mut nsIPresShell_gCaptureInfo: root::CapturingContentInfo;
    }
    extern "C" {
        #[link_name = "\u{1}_ZN12nsIPresShell14gKeyDownTargetE"]
        pub static mut nsIPresShell_gKeyDownTarget: *mut root::nsIContent;
    }
    #[test]
    fn bindgen_test_layout_nsIPresShell() {
        assert_eq!(
            ::std::mem::size_of::<nsIPresShell>(),
            5344usize,
            concat!("Size of: ", stringify!(nsIPresShell))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIPresShell>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIPresShell))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsIPresShell>())).mDocument as *const _ as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mDocument)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsIPresShell>())).mPresContext as *const _ as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mPresContext)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsIPresShell>())).mStyleSet as *const _ as usize },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mStyleSet)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIPresShell>())).mFrameConstructor as *const _ as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mFrameConstructor)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsIPresShell>())).mViewManager as *const _ as usize },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mViewManager)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsIPresShell>())).mFrameArena as *const _ as usize },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mFrameArena)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsIPresShell>())).mSelection as *const _ as usize },
            5184usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mSelection)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsIPresShell>())).mFrameManager as *const _ as usize },
            5192usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mFrameManager)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIPresShell>())).mForwardingContainer as *const _ as usize
            },
            5200usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mForwardingContainer)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsIPresShell>())).mDocAccessible as *const _ as usize },
            5208usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mDocAccessible)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIPresShell>())).mReflowContinueTimer as *const _ as usize
            },
            5216usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mReflowContinueTimer)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsIPresShell>())).mPaintCount as *const _ as usize },
            5224usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mPaintCount)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIPresShell>())).mScrollPositionClampingScrollPortSize
                    as *const _ as usize
            },
            5232usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mScrollPositionClampingScrollPortSize)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIPresShell>())).mAutoWeakFrames as *const _ as usize
            },
            5240usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mAutoWeakFrames)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsIPresShell>())).mWeakFrames as *const _ as usize },
            5248usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mWeakFrames)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsIPresShell>())).mStyleCause as *const _ as usize },
            5280usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mStyleCause)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsIPresShell>())).mReflowCause as *const _ as usize },
            5288usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mReflowCause)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIPresShell>())).mCanvasBackgroundColor as *const _ as usize
            },
            5296usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mCanvasBackgroundColor)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsIPresShell>())).mResolution as *const _ as usize },
            5300usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mResolution)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIPresShell>())).mSelectionFlags as *const _ as usize
            },
            5308usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mSelectionFlags)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIPresShell>())).mChangeNestCount as *const _ as usize
            },
            5310usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mChangeNestCount)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsIPresShell>())).mRenderFlags as *const _ as usize },
            5312usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mRenderFlags)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsIPresShell>())).mPresShellId as *const _ as usize },
            5316usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mPresShellId)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIPresShell>())).mFontSizeInflationEmPerLine as *const _
                    as usize
            },
            5320usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mFontSizeInflationEmPerLine)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIPresShell>())).mFontSizeInflationMinTwips as *const _
                    as usize
            },
            5324usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mFontSizeInflationMinTwips)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIPresShell>())).mFontSizeInflationLineThreshold as *const _
                    as usize
            },
            5328usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mFontSizeInflationLineThreshold)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIPresShell>())).mFontSizeInflationForceEnabled as *const _
                    as usize
            },
            5332usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mFontSizeInflationForceEnabled)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIPresShell>())).mFontSizeInflationDisabledInMasterProcess
                    as *const _ as usize
            },
            5333usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mFontSizeInflationDisabledInMasterProcess)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIPresShell>())).mFontSizeInflationEnabled as *const _
                    as usize
            },
            5334usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mFontSizeInflationEnabled)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIPresShell>())).mFontSizeInflationEnabledIsDirty
                    as *const _ as usize
            },
            5335usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mFontSizeInflationEnabledIsDirty)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIPresShell>())).mPaintingIsFrozen as *const _ as usize
            },
            5336usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mPaintingIsFrozen)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIPresShell>())).mIsNeverPainting as *const _ as usize
            },
            5337usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mIsNeverPainting)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsIPresShell>())).mInFlush as *const _ as usize },
            5338usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIPresShell),
                "::",
                stringify!(mInFlush)
            )
        );
    }
    impl nsIPresShell {
        #[inline]
        pub fn mDidInitialize(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mDidInitialize(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(0usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mIsDestroying(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mIsDestroying(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(1usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mIsReflowing(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mIsReflowing(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(2usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mIsObservingDocument(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mIsObservingDocument(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(3usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mIsDocumentGone(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mIsDocumentGone(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(4usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mPaintingSuppressed(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mPaintingSuppressed(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(5usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mIsActive(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mIsActive(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(6usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mFrozen(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mFrozen(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(7usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mIsFirstPaint(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mIsFirstPaint(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(8usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mObservesMutationsForPrint(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mObservesMutationsForPrint(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(9usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mWasLastReflowInterrupted(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mWasLastReflowInterrupted(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(10usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mScrollPositionClampingScrollPortSizeSet(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mScrollPositionClampingScrollPortSizeSet(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(11usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mNeedLayoutFlush(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mNeedLayoutFlush(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(12usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mNeedStyleFlush(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mNeedStyleFlush(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(13usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mObservingStyleFlushes(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mObservingStyleFlushes(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(14usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mObservingLayoutFlushes(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mObservingLayoutFlushes(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(15usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mNeedThrottledAnimationFlush(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mNeedThrottledAnimationFlush(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(16usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn new_bitfield_1(
            mDidInitialize: bool,
            mIsDestroying: bool,
            mIsReflowing: bool,
            mIsObservingDocument: bool,
            mIsDocumentGone: bool,
            mPaintingSuppressed: bool,
            mIsActive: bool,
            mFrozen: bool,
            mIsFirstPaint: bool,
            mObservesMutationsForPrint: bool,
            mWasLastReflowInterrupted: bool,
            mScrollPositionClampingScrollPortSizeSet: bool,
            mNeedLayoutFlush: bool,
            mNeedStyleFlush: bool,
            mObservingStyleFlushes: bool,
            mObservingLayoutFlushes: bool,
            mNeedThrottledAnimationFlush: bool,
        ) -> root::__BindgenBitfieldUnit<[u8; 3usize], u8> {
            let mut __bindgen_bitfield_unit: root::__BindgenBitfieldUnit<
                [u8; 3usize],
                u8,
            > = Default::default();
            __bindgen_bitfield_unit.set(0usize, 1u8, {
                let mDidInitialize: u8 = unsafe { ::std::mem::transmute(mDidInitialize) };
                mDidInitialize as u64
            });
            __bindgen_bitfield_unit.set(1usize, 1u8, {
                let mIsDestroying: u8 = unsafe { ::std::mem::transmute(mIsDestroying) };
                mIsDestroying as u64
            });
            __bindgen_bitfield_unit.set(2usize, 1u8, {
                let mIsReflowing: u8 = unsafe { ::std::mem::transmute(mIsReflowing) };
                mIsReflowing as u64
            });
            __bindgen_bitfield_unit.set(3usize, 1u8, {
                let mIsObservingDocument: u8 =
                    unsafe { ::std::mem::transmute(mIsObservingDocument) };
                mIsObservingDocument as u64
            });
            __bindgen_bitfield_unit.set(4usize, 1u8, {
                let mIsDocumentGone: u8 = unsafe { ::std::mem::transmute(mIsDocumentGone) };
                mIsDocumentGone as u64
            });
            __bindgen_bitfield_unit.set(5usize, 1u8, {
                let mPaintingSuppressed: u8 = unsafe { ::std::mem::transmute(mPaintingSuppressed) };
                mPaintingSuppressed as u64
            });
            __bindgen_bitfield_unit.set(6usize, 1u8, {
                let mIsActive: u8 = unsafe { ::std::mem::transmute(mIsActive) };
                mIsActive as u64
            });
            __bindgen_bitfield_unit.set(7usize, 1u8, {
                let mFrozen: u8 = unsafe { ::std::mem::transmute(mFrozen) };
                mFrozen as u64
            });
            __bindgen_bitfield_unit.set(8usize, 1u8, {
                let mIsFirstPaint: u8 = unsafe { ::std::mem::transmute(mIsFirstPaint) };
                mIsFirstPaint as u64
            });
            __bindgen_bitfield_unit.set(9usize, 1u8, {
                let mObservesMutationsForPrint: u8 =
                    unsafe { ::std::mem::transmute(mObservesMutationsForPrint) };
                mObservesMutationsForPrint as u64
            });
            __bindgen_bitfield_unit.set(10usize, 1u8, {
                let mWasLastReflowInterrupted: u8 =
                    unsafe { ::std::mem::transmute(mWasLastReflowInterrupted) };
                mWasLastReflowInterrupted as u64
            });
            __bindgen_bitfield_unit.set(11usize, 1u8, {
                let mScrollPositionClampingScrollPortSizeSet: u8 =
                    unsafe { ::std::mem::transmute(mScrollPositionClampingScrollPortSizeSet) };
                mScrollPositionClampingScrollPortSizeSet as u64
            });
            __bindgen_bitfield_unit.set(12usize, 1u8, {
                let mNeedLayoutFlush: u8 = unsafe { ::std::mem::transmute(mNeedLayoutFlush) };
                mNeedLayoutFlush as u64
            });
            __bindgen_bitfield_unit.set(13usize, 1u8, {
                let mNeedStyleFlush: u8 = unsafe { ::std::mem::transmute(mNeedStyleFlush) };
                mNeedStyleFlush as u64
            });
            __bindgen_bitfield_unit.set(14usize, 1u8, {
                let mObservingStyleFlushes: u8 =
                    unsafe { ::std::mem::transmute(mObservingStyleFlushes) };
                mObservingStyleFlushes as u64
            });
            __bindgen_bitfield_unit.set(15usize, 1u8, {
                let mObservingLayoutFlushes: u8 =
                    unsafe { ::std::mem::transmute(mObservingLayoutFlushes) };
                mObservingLayoutFlushes as u64
            });
            __bindgen_bitfield_unit.set(16usize, 1u8, {
                let mNeedThrottledAnimationFlush: u8 =
                    unsafe { ::std::mem::transmute(mNeedThrottledAnimationFlush) };
                mNeedThrottledAnimationFlush as u64
            });
            __bindgen_bitfield_unit
        }
    }
    #[repr(u32)]
    #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
    pub enum nsCompatibility {
        eCompatibility_FullStandards = 1,
        eCompatibility_AlmostStandards = 2,
        eCompatibility_NavQuirks = 3,
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsILoadGroup {
        pub _base: root::nsIRequest,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsILoadGroup_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsILoadGroup() {
        assert_eq!(
            ::std::mem::size_of::<nsILoadGroup>(),
            8usize,
            concat!("Size of: ", stringify!(nsILoadGroup))
        );
        assert_eq!(
            ::std::mem::align_of::<nsILoadGroup>(),
            8usize,
            concat!("Alignment of ", stringify!(nsILoadGroup))
        );
    }
    impl Clone for nsILoadGroup {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIRequestObserver {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIRequestObserver_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsIRequestObserver() {
        assert_eq!(
            ::std::mem::size_of::<nsIRequestObserver>(),
            8usize,
            concat!("Size of: ", stringify!(nsIRequestObserver))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIRequestObserver>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIRequestObserver))
        );
    }
    impl Clone for nsIRequestObserver {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIStreamListener {
        pub _base: root::nsIRequestObserver,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIStreamListener_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsIStreamListener() {
        assert_eq!(
            ::std::mem::size_of::<nsIStreamListener>(),
            8usize,
            concat!("Size of: ", stringify!(nsIStreamListener))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIStreamListener>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIStreamListener))
        );
    }
    impl Clone for nsIStreamListener {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsParserBase {
        pub _base: root::nsISupports,
    }
    #[test]
    fn bindgen_test_layout_nsParserBase() {
        assert_eq!(
            ::std::mem::size_of::<nsParserBase>(),
            8usize,
            concat!("Size of: ", stringify!(nsParserBase))
        );
        assert_eq!(
            ::std::mem::align_of::<nsParserBase>(),
            8usize,
            concat!("Alignment of ", stringify!(nsParserBase))
        );
    }
    impl Clone for nsParserBase {
        fn clone(&self) -> Self {
            *self
        }
    }
    /// This GECKO-INTERNAL interface is on track to being REMOVED (or refactored
    /// to the point of being near-unrecognizable).
    ///
    /// Please DO NOT #include this file in comm-central code, in your XULRunner
    /// app or binary extensions.
    ///
    /// Please DO NOT #include this into new files even inside Gecko. It is more
    /// likely than not that #including this header is the wrong thing to do.
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIParser {
        pub _base: root::nsParserBase,
    }
    pub type nsIParser_Encoding = root::mozilla::Encoding;
    pub type nsIParser_NotNull<T> = root::mozilla::NotNull<T>;
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIParser_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsIParser() {
        assert_eq!(
            ::std::mem::size_of::<nsIParser>(),
            8usize,
            concat!("Size of: ", stringify!(nsIParser))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIParser>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIParser))
        );
    }
    impl Clone for nsIParser {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsIGlobalObject {
        pub _base: root::nsISupports,
        pub _base_1: root::mozilla::dom::DispatcherTrait,
        pub mHostObjectURIs: root::nsTArray<root::nsCString>,
        pub mEventTargetObjects: [u64; 4usize],
        pub mIsDying: bool,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIGlobalObject_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsIGlobalObject() {
        assert_eq!(
            ::std::mem::size_of::<nsIGlobalObject>(),
            64usize,
            concat!("Size of: ", stringify!(nsIGlobalObject))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIGlobalObject>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIGlobalObject))
        );
    }
    /// The global object which keeps a script context for each supported script
    /// language. This often used to store per-window global state.
    /// This is a heavyweight interface implemented only by DOM globals, and
    /// it might go away some time in the future.
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsIScriptGlobalObject {
        pub _base: root::nsIGlobalObject,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIScriptGlobalObject_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsIScriptGlobalObject() {
        assert_eq!(
            ::std::mem::size_of::<nsIScriptGlobalObject>(),
            64usize,
            concat!("Size of: ", stringify!(nsIScriptGlobalObject))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIScriptGlobalObject>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIScriptGlobalObject))
        );
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIURI {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIURI_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsIURI() {
        assert_eq!(
            ::std::mem::size_of::<nsIURI>(),
            8usize,
            concat!("Size of: ", stringify!(nsIURI))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIURI>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIURI))
        );
    }
    impl Clone for nsIURI {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIUUIDGenerator {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIUUIDGenerator_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsIUUIDGenerator() {
        assert_eq!(
            ::std::mem::size_of::<nsIUUIDGenerator>(),
            8usize,
            concat!("Size of: ", stringify!(nsIUUIDGenerator))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIUUIDGenerator>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIUUIDGenerator))
        );
    }
    impl Clone for nsIUUIDGenerator {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIControllers {
        _unused: [u8; 0],
    }
    impl Clone for nsIControllers {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct mozIDOMWindow {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct mozIDOMWindow_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_mozIDOMWindow() {
        assert_eq!(
            ::std::mem::size_of::<mozIDOMWindow>(),
            8usize,
            concat!("Size of: ", stringify!(mozIDOMWindow))
        );
        assert_eq!(
            ::std::mem::align_of::<mozIDOMWindow>(),
            8usize,
            concat!("Alignment of ", stringify!(mozIDOMWindow))
        );
    }
    impl Clone for mozIDOMWindow {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct mozIDOMWindowProxy {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct mozIDOMWindowProxy_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_mozIDOMWindowProxy() {
        assert_eq!(
            ::std::mem::size_of::<mozIDOMWindowProxy>(),
            8usize,
            concat!("Size of: ", stringify!(mozIDOMWindowProxy))
        );
        assert_eq!(
            ::std::mem::align_of::<mozIDOMWindowProxy>(),
            8usize,
            concat!("Alignment of ", stringify!(mozIDOMWindowProxy))
        );
    }
    impl Clone for mozIDOMWindowProxy {
        fn clone(&self) -> Self {
            *self
        }
    }
    pub type SuspendTypes = u32;
    pub const PopupControlState_openAllowed: root::PopupControlState = 0;
    pub const PopupControlState_openControlled: root::PopupControlState = 1;
    pub const PopupControlState_openBlocked: root::PopupControlState = 2;
    pub const PopupControlState_openAbused: root::PopupControlState = 3;
    pub const PopupControlState_openOverridden: root::PopupControlState = 4;
    pub type PopupControlState = u32;
    #[repr(C)]
    pub struct nsPIDOMWindowInner {
        pub _base: root::mozIDOMWindow,
        pub mChromeEventHandler: root::nsCOMPtr,
        pub mDoc: root::nsCOMPtr,
        pub mDocumentURI: root::nsCOMPtr,
        pub mDocBaseURI: root::nsCOMPtr,
        pub mParentTarget: root::nsCOMPtr,
        pub mPerformance: root::RefPtr<root::mozilla::dom::Performance>,
        pub mTimeoutManager: root::mozilla::UniquePtr<root::mozilla::dom::TimeoutManager>,
        pub mNavigator: root::RefPtr<root::mozilla::dom::Navigator>,
        pub mServiceWorkerRegistrationTable:
            root::nsPIDOMWindowInner_ServiceWorkerRegistrationTable,
        pub mMutationBits: u32,
        pub mActivePeerConnections: u32,
        pub mIsDocumentLoaded: bool,
        pub mIsHandlingResizeEvent: bool,
        pub mMayHavePaintEventListener: bool,
        pub mMayHaveTouchEventListener: bool,
        pub mMayHaveSelectionChangeEventListener: bool,
        pub mMayHaveMouseEnterLeaveEventListener: bool,
        pub mMayHavePointerEnterLeaveEventListener: bool,
        pub mInnerObjectsFreed: bool,
        pub mAudioCaptured: bool,
        pub mOuterWindow: root::nsCOMPtr,
        pub mFocusedNode: root::nsCOMPtr,
        pub mAudioContexts: root::nsTArray<*mut root::mozilla::dom::AudioContext>,
        pub mTabGroup: root::RefPtr<root::mozilla::dom::TabGroup>,
        pub mWindowID: u64,
        pub mHasNotifiedGlobalCreated: bool,
        pub mMarkedCCGeneration: u32,
        pub mTopInnerWindow: root::nsCOMPtr,
        pub mHasTriedToCacheTopInnerWindow: bool,
        pub mNumOfIndexedDBDatabases: u32,
        pub mNumOfOpenWebSockets: u32,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsPIDOMWindowInner_COMTypeInfo {
        pub _address: u8,
    }
    pub type nsPIDOMWindowInner_ServiceWorkerRegistrationTable = [u64; 4usize];
    #[test]
    fn bindgen_test_layout_nsPIDOMWindowInner() {
        assert_eq!(
            ::std::mem::size_of::<nsPIDOMWindowInner>(),
            200usize,
            concat!("Size of: ", stringify!(nsPIDOMWindowInner))
        );
        assert_eq!(
            ::std::mem::align_of::<nsPIDOMWindowInner>(),
            8usize,
            concat!("Alignment of ", stringify!(nsPIDOMWindowInner))
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mChromeEventHandler as *const _
                    as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mChromeEventHandler)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mDoc as *const _ as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mDoc)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mDocumentURI as *const _ as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mDocumentURI)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mDocBaseURI as *const _ as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mDocBaseURI)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mParentTarget as *const _ as usize
            },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mParentTarget)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mPerformance as *const _ as usize
            },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mPerformance)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mTimeoutManager as *const _ as usize
            },
            56usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mTimeoutManager)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mNavigator as *const _ as usize
            },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mNavigator)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mServiceWorkerRegistrationTable
                    as *const _ as usize
            },
            72usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mServiceWorkerRegistrationTable)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mMutationBits as *const _ as usize
            },
            104usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mMutationBits)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mActivePeerConnections as *const _
                    as usize
            },
            108usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mActivePeerConnections)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mIsDocumentLoaded as *const _
                    as usize
            },
            112usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mIsDocumentLoaded)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mIsHandlingResizeEvent as *const _
                    as usize
            },
            113usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mIsHandlingResizeEvent)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mMayHavePaintEventListener
                    as *const _ as usize
            },
            114usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mMayHavePaintEventListener)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mMayHaveTouchEventListener
                    as *const _ as usize
            },
            115usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mMayHaveTouchEventListener)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mMayHaveSelectionChangeEventListener
                    as *const _ as usize
            },
            116usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mMayHaveSelectionChangeEventListener)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mMayHaveMouseEnterLeaveEventListener
                    as *const _ as usize
            },
            117usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mMayHaveMouseEnterLeaveEventListener)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>()))
                    .mMayHavePointerEnterLeaveEventListener as *const _ as usize
            },
            118usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mMayHavePointerEnterLeaveEventListener)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mInnerObjectsFreed as *const _
                    as usize
            },
            119usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mInnerObjectsFreed)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mAudioCaptured as *const _ as usize
            },
            120usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mAudioCaptured)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mOuterWindow as *const _ as usize
            },
            128usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mOuterWindow)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mFocusedNode as *const _ as usize
            },
            136usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mFocusedNode)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mAudioContexts as *const _ as usize
            },
            144usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mAudioContexts)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mTabGroup as *const _ as usize
            },
            152usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mTabGroup)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mWindowID as *const _ as usize
            },
            160usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mWindowID)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mHasNotifiedGlobalCreated as *const _
                    as usize
            },
            168usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mHasNotifiedGlobalCreated)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mMarkedCCGeneration as *const _
                    as usize
            },
            172usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mMarkedCCGeneration)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mTopInnerWindow as *const _ as usize
            },
            176usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mTopInnerWindow)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mHasTriedToCacheTopInnerWindow
                    as *const _ as usize
            },
            184usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mHasTriedToCacheTopInnerWindow)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mNumOfIndexedDBDatabases as *const _
                    as usize
            },
            188usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mNumOfIndexedDBDatabases)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowInner>())).mNumOfOpenWebSockets as *const _
                    as usize
            },
            192usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowInner),
                "::",
                stringify!(mNumOfOpenWebSockets)
            )
        );
    }
    #[repr(C)]
    pub struct nsPIDOMWindowOuter {
        pub _base: root::mozIDOMWindowProxy,
        pub mChromeEventHandler: root::nsCOMPtr,
        pub mDoc: root::nsCOMPtr,
        pub mDocumentURI: root::nsCOMPtr,
        pub mDocBaseURI: root::nsCOMPtr,
        pub mParentTarget: root::nsCOMPtr,
        pub mFrameElement: root::nsCOMPtr,
        pub mDocShell: root::nsCOMPtr,
        pub mModalStateDepth: u32,
        pub mIsActive: bool,
        pub mIsBackground: bool,
        /// The suspended types can be "disposable" or "permanent". This varable only
        /// stores the value about permanent suspend.
        /// - disposable
        /// To pause all playing media in that window, but doesn't affect the media
        /// which starts after that.
        ///
        /// - permanent
        /// To pause all media in that window, and also affect the media which starts
        /// after that.
        pub mMediaSuspend: root::SuspendTypes,
        pub mAudioMuted: bool,
        pub mAudioVolume: f32,
        pub mDesktopModeViewport: bool,
        pub mIsRootOuterWindow: bool,
        pub mInnerWindow: *mut root::nsPIDOMWindowInner,
        pub mTabGroup: root::RefPtr<root::mozilla::dom::TabGroup>,
        pub mWindowID: u64,
        pub mMarkedCCGeneration: u32,
        pub mServiceWorkersTestingEnabled: bool,
        pub mLargeAllocStatus: root::mozilla::dom::LargeAllocStatus,
        pub mOpenerForInitialContentBrowser: root::nsCOMPtr,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsPIDOMWindowOuter_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsPIDOMWindowOuter() {
        assert_eq!(
            ::std::mem::size_of::<nsPIDOMWindowOuter>(),
            128usize,
            concat!("Size of: ", stringify!(nsPIDOMWindowOuter))
        );
        assert_eq!(
            ::std::mem::align_of::<nsPIDOMWindowOuter>(),
            8usize,
            concat!("Alignment of ", stringify!(nsPIDOMWindowOuter))
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mChromeEventHandler as *const _
                    as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mChromeEventHandler)
            )
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mDoc as *const _ as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mDoc)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mDocumentURI as *const _ as usize
            },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mDocumentURI)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mDocBaseURI as *const _ as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mDocBaseURI)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mParentTarget as *const _ as usize
            },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mParentTarget)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mFrameElement as *const _ as usize
            },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mFrameElement)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mDocShell as *const _ as usize
            },
            56usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mDocShell)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mModalStateDepth as *const _ as usize
            },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mModalStateDepth)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mIsActive as *const _ as usize
            },
            68usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mIsActive)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mIsBackground as *const _ as usize
            },
            69usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mIsBackground)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mMediaSuspend as *const _ as usize
            },
            72usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mMediaSuspend)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mAudioMuted as *const _ as usize
            },
            76usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mAudioMuted)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mAudioVolume as *const _ as usize
            },
            80usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mAudioVolume)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mDesktopModeViewport as *const _
                    as usize
            },
            84usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mDesktopModeViewport)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mIsRootOuterWindow as *const _
                    as usize
            },
            85usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mIsRootOuterWindow)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mInnerWindow as *const _ as usize
            },
            88usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mInnerWindow)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mTabGroup as *const _ as usize
            },
            96usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mTabGroup)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mWindowID as *const _ as usize
            },
            104usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mWindowID)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mMarkedCCGeneration as *const _
                    as usize
            },
            112usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mMarkedCCGeneration)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mServiceWorkersTestingEnabled
                    as *const _ as usize
            },
            116usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mServiceWorkersTestingEnabled)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mLargeAllocStatus as *const _
                    as usize
            },
            117usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mLargeAllocStatus)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsPIDOMWindowOuter>())).mOpenerForInitialContentBrowser
                    as *const _ as usize
            },
            120usize,
            concat!(
                "Offset of field: ",
                stringify!(nsPIDOMWindowOuter),
                "::",
                stringify!(mOpenerForInitialContentBrowser)
            )
        );
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsContentList {
        _unused: [u8; 0],
    }
    impl Clone for nsContentList {
        fn clone(&self) -> Self {
            *self
        }
    }
    /// The signature of the timer callback function passed to initWithFuncCallback.
    /// This is the function that will get called when the timer expires if the
    /// timer is initialized via initWithFuncCallback.
    ///
    /// @param aTimer the timer which has expired
    /// @param aClosure opaque parameter passed to initWithFuncCallback
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsITimer {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsITimer_COMTypeInfo {
        pub _address: u8,
    }
    pub const nsITimer_TYPE_ONE_SHOT: root::nsITimer__bindgen_ty_1 = 0;
    pub const nsITimer_TYPE_REPEATING_SLACK: root::nsITimer__bindgen_ty_1 = 1;
    pub const nsITimer_TYPE_REPEATING_PRECISE: root::nsITimer__bindgen_ty_1 = 2;
    pub const nsITimer_TYPE_REPEATING_PRECISE_CAN_SKIP: root::nsITimer__bindgen_ty_1 = 3;
    pub const nsITimer_TYPE_REPEATING_SLACK_LOW_PRIORITY: root::nsITimer__bindgen_ty_1 = 4;
    pub const nsITimer_TYPE_ONE_SHOT_LOW_PRIORITY: root::nsITimer__bindgen_ty_1 = 5;
    pub type nsITimer__bindgen_ty_1 = u32;
    #[test]
    fn bindgen_test_layout_nsITimer() {
        assert_eq!(
            ::std::mem::size_of::<nsITimer>(),
            8usize,
            concat!("Size of: ", stringify!(nsITimer))
        );
        assert_eq!(
            ::std::mem::align_of::<nsITimer>(),
            8usize,
            concat!("Alignment of ", stringify!(nsITimer))
        );
    }
    impl Clone for nsITimer {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIRunnable {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIRunnable_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsIRunnable() {
        assert_eq!(
            ::std::mem::size_of::<nsIRunnable>(),
            8usize,
            concat!("Size of: ", stringify!(nsIRunnable))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIRunnable>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIRunnable))
        );
    }
    impl Clone for nsIRunnable {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIEventTarget {
        pub _base: root::nsISupports,
        pub mVirtualThread: *mut root::PRThread,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIEventTarget_COMTypeInfo {
        pub _address: u8,
    }
    pub const nsIEventTarget_DISPATCH_NORMAL: root::nsIEventTarget__bindgen_ty_1 = 0;
    pub const nsIEventTarget_DISPATCH_SYNC: root::nsIEventTarget__bindgen_ty_1 = 1;
    pub const nsIEventTarget_DISPATCH_AT_END: root::nsIEventTarget__bindgen_ty_1 = 2;
    pub type nsIEventTarget__bindgen_ty_1 = u32;
    #[test]
    fn bindgen_test_layout_nsIEventTarget() {
        assert_eq!(
            ::std::mem::size_of::<nsIEventTarget>(),
            16usize,
            concat!("Size of: ", stringify!(nsIEventTarget))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIEventTarget>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIEventTarget))
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIEventTarget>())).mVirtualThread as *const _ as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIEventTarget),
                "::",
                stringify!(mVirtualThread)
            )
        );
    }
    impl Clone for nsIEventTarget {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIObserver {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIObserver_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsIObserver() {
        assert_eq!(
            ::std::mem::size_of::<nsIObserver>(),
            8usize,
            concat!("Size of: ", stringify!(nsIObserver))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIObserver>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIObserver))
        );
    }
    impl Clone for nsIObserver {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsICancelableRunnable {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsICancelableRunnable_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsICancelableRunnable() {
        assert_eq!(
            ::std::mem::size_of::<nsICancelableRunnable>(),
            8usize,
            concat!("Size of: ", stringify!(nsICancelableRunnable))
        );
        assert_eq!(
            ::std::mem::align_of::<nsICancelableRunnable>(),
            8usize,
            concat!("Alignment of ", stringify!(nsICancelableRunnable))
        );
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsINamed {
        pub _base: root::nsISupports,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsINamed_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsINamed() {
        assert_eq!(
            ::std::mem::size_of::<nsINamed>(),
            8usize,
            concat!("Size of: ", stringify!(nsINamed))
        );
        assert_eq!(
            ::std::mem::align_of::<nsINamed>(),
            8usize,
            concat!("Alignment of ", stringify!(nsINamed))
        );
    }
    impl Clone for nsINamed {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsISerialEventTarget {
        pub _base: root::nsIEventTarget,
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsISerialEventTarget_COMTypeInfo {
        pub _address: u8,
    }
    #[test]
    fn bindgen_test_layout_nsISerialEventTarget() {
        assert_eq!(
            ::std::mem::size_of::<nsISerialEventTarget>(),
            16usize,
            concat!("Size of: ", stringify!(nsISerialEventTarget))
        );
        assert_eq!(
            ::std::mem::align_of::<nsISerialEventTarget>(),
            8usize,
            concat!("Alignment of ", stringify!(nsISerialEventTarget))
        );
    }
    impl Clone for nsISerialEventTarget {
        fn clone(&self) -> Self {
            *self
        }
    }
    pub type nsRunnableMethod_BaseType = u8;
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsRunnableMethod_ReturnTypeEnforcer {
        pub _address: u8,
    }
    pub type nsRunnableMethod_ReturnTypeEnforcer_ReturnTypeIsSafe = ::std::os::raw::c_int;
    pub type nsRunnableMethod_check = root::nsRunnableMethod_ReturnTypeEnforcer;
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIIOService {
        _unused: [u8; 0],
    }
    impl Clone for nsIIOService {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIStringBundleService {
        _unused: [u8; 0],
    }
    impl Clone for nsIStringBundleService {
        fn clone(&self) -> Self {
            *self
        }
    }
    /// Data used to track the expiration state of an object. We promise that this
    /// is 32 bits so that objects that includes this as a field can pad and align
    /// efficiently.
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsExpirationState {
        pub _bitfield_1: root::__BindgenBitfieldUnit<[u8; 4usize], u32>,
        pub __bindgen_align: [u32; 0usize],
    }
    pub const nsExpirationState_NOT_TRACKED: root::nsExpirationState__bindgen_ty_1 = 15;
    pub const nsExpirationState_MAX_INDEX_IN_GENERATION: root::nsExpirationState__bindgen_ty_1 =
        268435455;
    pub type nsExpirationState__bindgen_ty_1 = u32;
    #[test]
    fn bindgen_test_layout_nsExpirationState() {
        assert_eq!(
            ::std::mem::size_of::<nsExpirationState>(),
            4usize,
            concat!("Size of: ", stringify!(nsExpirationState))
        );
        assert_eq!(
            ::std::mem::align_of::<nsExpirationState>(),
            4usize,
            concat!("Alignment of ", stringify!(nsExpirationState))
        );
    }
    impl Clone for nsExpirationState {
        fn clone(&self) -> Self {
            *self
        }
    }
    impl nsExpirationState {
        #[inline]
        pub fn mGeneration(&self) -> u32 {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u32) }
        }
        #[inline]
        pub fn set_mGeneration(&mut self, val: u32) {
            unsafe {
                let val: u32 = ::std::mem::transmute(val);
                self._bitfield_1.set(0usize, 4u8, val as u64)
            }
        }
        #[inline]
        pub fn mIndexInGeneration(&self) -> u32 {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 28u8) as u32) }
        }
        #[inline]
        pub fn set_mIndexInGeneration(&mut self, val: u32) {
            unsafe {
                let val: u32 = ::std::mem::transmute(val);
                self._bitfield_1.set(4usize, 28u8, val as u64)
            }
        }
        #[inline]
        pub fn new_bitfield_1(
            mGeneration: u32,
            mIndexInGeneration: u32,
        ) -> root::__BindgenBitfieldUnit<[u8; 4usize], u32> {
            let mut __bindgen_bitfield_unit: root::__BindgenBitfieldUnit<
                [u8; 4usize],
                u32,
            > = Default::default();
            __bindgen_bitfield_unit.set(0usize, 4u8, {
                let mGeneration: u32 = unsafe { ::std::mem::transmute(mGeneration) };
                mGeneration as u64
            });
            __bindgen_bitfield_unit.set(4usize, 28u8, {
                let mIndexInGeneration: u32 = unsafe { ::std::mem::transmute(mIndexInGeneration) };
                mIndexInGeneration as u64
            });
            __bindgen_bitfield_unit
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsBaseContentList {
        _unused: [u8; 0],
    }
    impl Clone for nsBaseContentList {
        fn clone(&self) -> Self {
            *self
        }
    }
    /// Right now our identifier map entries contain information for 'name'
    /// and 'id' mappings of a given string. This is so that
    /// nsHTMLDocument::ResolveName only has to do one hash lookup instead
    /// of two. It's not clear whether this still matters for performance.
    ///
    /// We also store the document.all result list here. This is mainly so that
    /// when all elements with the given ID are removed and we remove
    /// the ID's nsIdentifierMapEntry, the document.all result is released too.
    /// Perhaps the document.all results should have their own hashtable
    /// in nsHTMLDocument.
    #[repr(C)]
    pub struct nsIdentifierMapEntry {
        pub _base: root::PLDHashEntryHdr,
        pub mKey: root::nsIdentifierMapEntry_AtomOrString,
        pub mIdContentList: [u64; 3usize],
        pub mNameContentList: root::RefPtr<root::nsBaseContentList>,
        pub mChangeCallbacks: u64,
        pub mImageElement: root::RefPtr<root::nsIdentifierMapEntry_Element>,
    }
    pub type nsIdentifierMapEntry_Element = root::mozilla::dom::Element;
    pub use self::super::root::mozilla::net::ReferrerPolicy as nsIdentifierMapEntry_ReferrerPolicy;
    /// @see nsIDocument::IDTargetObserver, this is just here to avoid include
    /// hell.
    pub type nsIdentifierMapEntry_IDTargetObserver = ::std::option::Option<
        unsafe extern "C" fn(
            aOldElement: *mut root::nsIdentifierMapEntry_Element,
            aNewelement: *mut root::nsIdentifierMapEntry_Element,
            aData: *mut ::std::os::raw::c_void,
        ) -> bool,
    >;
    #[repr(C)]
    pub struct nsIdentifierMapEntry_AtomOrString {
        pub mAtom: root::RefPtr<root::nsAtom>,
        pub mString: ::nsstring::nsStringRepr,
    }
    #[test]
    fn bindgen_test_layout_nsIdentifierMapEntry_AtomOrString() {
        assert_eq!(
            ::std::mem::size_of::<nsIdentifierMapEntry_AtomOrString>(),
            24usize,
            concat!("Size of: ", stringify!(nsIdentifierMapEntry_AtomOrString))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIdentifierMapEntry_AtomOrString>(),
            8usize,
            concat!(
                "Alignment of ",
                stringify!(nsIdentifierMapEntry_AtomOrString)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIdentifierMapEntry_AtomOrString>())).mAtom as *const _
                    as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIdentifierMapEntry_AtomOrString),
                "::",
                stringify!(mAtom)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIdentifierMapEntry_AtomOrString>())).mString as *const _
                    as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIdentifierMapEntry_AtomOrString),
                "::",
                stringify!(mString)
            )
        );
    }
    pub type nsIdentifierMapEntry_KeyType = *const root::nsIdentifierMapEntry_AtomOrString;
    pub type nsIdentifierMapEntry_KeyTypePointer = *const root::nsIdentifierMapEntry_AtomOrString;
    pub const nsIdentifierMapEntry_ALLOW_MEMMOVE: root::nsIdentifierMapEntry__bindgen_ty_1 = 0;
    pub type nsIdentifierMapEntry__bindgen_ty_1 = u32;
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIdentifierMapEntry_ChangeCallback {
        pub mCallback: root::nsIdentifierMapEntry_IDTargetObserver,
        pub mData: *mut ::std::os::raw::c_void,
        pub mForImage: bool,
    }
    #[test]
    fn bindgen_test_layout_nsIdentifierMapEntry_ChangeCallback() {
        assert_eq!(
            ::std::mem::size_of::<nsIdentifierMapEntry_ChangeCallback>(),
            24usize,
            concat!("Size of: ", stringify!(nsIdentifierMapEntry_ChangeCallback))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIdentifierMapEntry_ChangeCallback>(),
            8usize,
            concat!(
                "Alignment of ",
                stringify!(nsIdentifierMapEntry_ChangeCallback)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIdentifierMapEntry_ChangeCallback>())).mCallback
                    as *const _ as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIdentifierMapEntry_ChangeCallback),
                "::",
                stringify!(mCallback)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIdentifierMapEntry_ChangeCallback>())).mData as *const _
                    as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIdentifierMapEntry_ChangeCallback),
                "::",
                stringify!(mData)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIdentifierMapEntry_ChangeCallback>())).mForImage
                    as *const _ as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIdentifierMapEntry_ChangeCallback),
                "::",
                stringify!(mForImage)
            )
        );
    }
    impl Clone for nsIdentifierMapEntry_ChangeCallback {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIdentifierMapEntry_ChangeCallbackEntry {
        pub _base: root::PLDHashEntryHdr,
        pub mKey: root::nsIdentifierMapEntry_ChangeCallback,
    }
    pub type nsIdentifierMapEntry_ChangeCallbackEntry_KeyType =
        root::nsIdentifierMapEntry_ChangeCallback;
    pub type nsIdentifierMapEntry_ChangeCallbackEntry_KeyTypePointer =
        *const root::nsIdentifierMapEntry_ChangeCallback;
    pub const nsIdentifierMapEntry_ChangeCallbackEntry_ALLOW_MEMMOVE:
        root::nsIdentifierMapEntry_ChangeCallbackEntry__bindgen_ty_1 = 1;
    pub type nsIdentifierMapEntry_ChangeCallbackEntry__bindgen_ty_1 = u32;
    #[test]
    fn bindgen_test_layout_nsIdentifierMapEntry_ChangeCallbackEntry() {
        assert_eq!(
            ::std::mem::size_of::<nsIdentifierMapEntry_ChangeCallbackEntry>(),
            32usize,
            concat!(
                "Size of: ",
                stringify!(nsIdentifierMapEntry_ChangeCallbackEntry)
            )
        );
        assert_eq!(
            ::std::mem::align_of::<nsIdentifierMapEntry_ChangeCallbackEntry>(),
            8usize,
            concat!(
                "Alignment of ",
                stringify!(nsIdentifierMapEntry_ChangeCallbackEntry)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIdentifierMapEntry_ChangeCallbackEntry>())).mKey
                    as *const _ as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIdentifierMapEntry_ChangeCallbackEntry),
                "::",
                stringify!(mKey)
            )
        );
    }
    impl Clone for nsIdentifierMapEntry_ChangeCallbackEntry {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[test]
    fn bindgen_test_layout_nsIdentifierMapEntry() {
        assert_eq!(
            ::std::mem::size_of::<nsIdentifierMapEntry>(),
            80usize,
            concat!("Size of: ", stringify!(nsIdentifierMapEntry))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIdentifierMapEntry>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIdentifierMapEntry))
        );
        assert_eq!(
            unsafe { &(*(::std::ptr::null::<nsIdentifierMapEntry>())).mKey as *const _ as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIdentifierMapEntry),
                "::",
                stringify!(mKey)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIdentifierMapEntry>())).mIdContentList as *const _ as usize
            },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIdentifierMapEntry),
                "::",
                stringify!(mIdContentList)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIdentifierMapEntry>())).mNameContentList as *const _
                    as usize
            },
            56usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIdentifierMapEntry),
                "::",
                stringify!(mNameContentList)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIdentifierMapEntry>())).mChangeCallbacks as *const _
                    as usize
            },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIdentifierMapEntry),
                "::",
                stringify!(mChangeCallbacks)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIdentifierMapEntry>())).mImageElement as *const _ as usize
            },
            72usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIdentifierMapEntry),
                "::",
                stringify!(mImageElement)
            )
        );
    }
    pub const nsCSSPropertyID_eCSSProperty_COUNT_no_shorthands: root::nsCSSPropertyID =
        nsCSSPropertyID::eCSSProperty_all;
    pub const nsCSSPropertyID_eCSSProperty_COUNT_DUMMY: root::nsCSSPropertyID =
        nsCSSPropertyID::eCSSProperty_z_index;
    pub const nsCSSPropertyID_eCSSProperty_COUNT: root::nsCSSPropertyID =
        nsCSSPropertyID::eCSSPropertyAlias_WordWrap;
    pub const nsCSSPropertyID_eCSSProperty_COUNT_DUMMY2: root::nsCSSPropertyID =
        nsCSSPropertyID::eCSSProperty_transition;
    pub const nsCSSPropertyID_eCSSProperty_COUNT_with_aliases: root::nsCSSPropertyID =
        nsCSSPropertyID::eCSSPropertyExtra_no_properties;
    pub const nsCSSPropertyID_eCSSProperty_COUNT_DUMMY3: root::nsCSSPropertyID =
        nsCSSPropertyID::eCSSPropertyAlias_WebkitMaskSize;
    #[repr(i32)]
    #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
    pub enum nsCSSPropertyID {
        eCSSProperty_UNKNOWN = -1,
        eCSSProperty_align_content = 0,
        eCSSProperty_align_items = 1,
        eCSSProperty_align_self = 2,
        eCSSProperty_animation_delay = 3,
        eCSSProperty_animation_direction = 4,
        eCSSProperty_animation_duration = 5,
        eCSSProperty_animation_fill_mode = 6,
        eCSSProperty_animation_iteration_count = 7,
        eCSSProperty_animation_name = 8,
        eCSSProperty_animation_play_state = 9,
        eCSSProperty_animation_timing_function = 10,
        eCSSProperty__moz_appearance = 11,
        eCSSProperty_backface_visibility = 12,
        eCSSProperty_background_attachment = 13,
        eCSSProperty_background_blend_mode = 14,
        eCSSProperty_background_clip = 15,
        eCSSProperty_background_color = 16,
        eCSSProperty_background_image = 17,
        eCSSProperty_background_origin = 18,
        eCSSProperty_background_position_x = 19,
        eCSSProperty_background_position_y = 20,
        eCSSProperty_background_repeat = 21,
        eCSSProperty_background_size = 22,
        eCSSProperty__moz_binding = 23,
        eCSSProperty_block_size = 24,
        eCSSProperty_border_block_end_color = 25,
        eCSSProperty_border_block_end_style = 26,
        eCSSProperty_border_block_end_width = 27,
        eCSSProperty_border_block_start_color = 28,
        eCSSProperty_border_block_start_style = 29,
        eCSSProperty_border_block_start_width = 30,
        eCSSProperty_border_bottom_color = 31,
        eCSSProperty_border_bottom_left_radius = 32,
        eCSSProperty_border_bottom_right_radius = 33,
        eCSSProperty_border_bottom_style = 34,
        eCSSProperty_border_bottom_width = 35,
        eCSSProperty_border_collapse = 36,
        eCSSProperty_border_image_outset = 37,
        eCSSProperty_border_image_repeat = 38,
        eCSSProperty_border_image_slice = 39,
        eCSSProperty_border_image_source = 40,
        eCSSProperty_border_image_width = 41,
        eCSSProperty_border_inline_end_color = 42,
        eCSSProperty_border_inline_end_style = 43,
        eCSSProperty_border_inline_end_width = 44,
        eCSSProperty_border_inline_start_color = 45,
        eCSSProperty_border_inline_start_style = 46,
        eCSSProperty_border_inline_start_width = 47,
        eCSSProperty_border_left_color = 48,
        eCSSProperty_border_left_style = 49,
        eCSSProperty_border_left_width = 50,
        eCSSProperty_border_right_color = 51,
        eCSSProperty_border_right_style = 52,
        eCSSProperty_border_right_width = 53,
        eCSSProperty_border_spacing = 54,
        eCSSProperty_border_top_color = 55,
        eCSSProperty_border_top_left_radius = 56,
        eCSSProperty_border_top_right_radius = 57,
        eCSSProperty_border_top_style = 58,
        eCSSProperty_border_top_width = 59,
        eCSSProperty_bottom = 60,
        eCSSProperty__moz_box_align = 61,
        eCSSProperty_box_decoration_break = 62,
        eCSSProperty__moz_box_direction = 63,
        eCSSProperty__moz_box_flex = 64,
        eCSSProperty__moz_box_ordinal_group = 65,
        eCSSProperty__moz_box_orient = 66,
        eCSSProperty__moz_box_pack = 67,
        eCSSProperty_box_shadow = 68,
        eCSSProperty_box_sizing = 69,
        eCSSProperty_caption_side = 70,
        eCSSProperty_caret_color = 71,
        eCSSProperty_clear = 72,
        eCSSProperty_clip = 73,
        eCSSProperty_clip_path = 74,
        eCSSProperty_clip_rule = 75,
        eCSSProperty_color = 76,
        eCSSProperty_color_adjust = 77,
        eCSSProperty_color_interpolation = 78,
        eCSSProperty_color_interpolation_filters = 79,
        eCSSProperty_column_count = 80,
        eCSSProperty_column_fill = 81,
        eCSSProperty_column_gap = 82,
        eCSSProperty_column_rule_color = 83,
        eCSSProperty_column_rule_style = 84,
        eCSSProperty_column_rule_width = 85,
        eCSSProperty_column_span = 86,
        eCSSProperty_column_width = 87,
        eCSSProperty_contain = 88,
        eCSSProperty_content = 89,
        eCSSProperty__moz_context_properties = 90,
        eCSSProperty__moz_control_character_visibility = 91,
        eCSSProperty_counter_increment = 92,
        eCSSProperty_counter_reset = 93,
        eCSSProperty_cursor = 94,
        eCSSProperty_direction = 95,
        eCSSProperty_display = 96,
        eCSSProperty_dominant_baseline = 97,
        eCSSProperty_empty_cells = 98,
        eCSSProperty_fill = 99,
        eCSSProperty_fill_opacity = 100,
        eCSSProperty_fill_rule = 101,
        eCSSProperty_filter = 102,
        eCSSProperty_flex_basis = 103,
        eCSSProperty_flex_direction = 104,
        eCSSProperty_flex_grow = 105,
        eCSSProperty_flex_shrink = 106,
        eCSSProperty_flex_wrap = 107,
        eCSSProperty_float_ = 108,
        eCSSProperty__moz_float_edge = 109,
        eCSSProperty_flood_color = 110,
        eCSSProperty_flood_opacity = 111,
        eCSSProperty_font_family = 112,
        eCSSProperty_font_feature_settings = 113,
        eCSSProperty_font_kerning = 114,
        eCSSProperty_font_language_override = 115,
        eCSSProperty_font_optical_sizing = 116,
        eCSSProperty_font_size = 117,
        eCSSProperty_font_size_adjust = 118,
        eCSSProperty__moz_font_smoothing_background_color = 119,
        eCSSProperty_font_stretch = 120,
        eCSSProperty_font_style = 121,
        eCSSProperty_font_synthesis = 122,
        eCSSProperty_font_variant_alternates = 123,
        eCSSProperty_font_variant_caps = 124,
        eCSSProperty_font_variant_east_asian = 125,
        eCSSProperty_font_variant_ligatures = 126,
        eCSSProperty_font_variant_numeric = 127,
        eCSSProperty_font_variant_position = 128,
        eCSSProperty_font_variation_settings = 129,
        eCSSProperty_font_weight = 130,
        eCSSProperty__moz_force_broken_image_icon = 131,
        eCSSProperty_grid_auto_columns = 132,
        eCSSProperty_grid_auto_flow = 133,
        eCSSProperty_grid_auto_rows = 134,
        eCSSProperty_grid_column_end = 135,
        eCSSProperty_grid_column_gap = 136,
        eCSSProperty_grid_column_start = 137,
        eCSSProperty_grid_row_end = 138,
        eCSSProperty_grid_row_gap = 139,
        eCSSProperty_grid_row_start = 140,
        eCSSProperty_grid_template_areas = 141,
        eCSSProperty_grid_template_columns = 142,
        eCSSProperty_grid_template_rows = 143,
        eCSSProperty_height = 144,
        eCSSProperty_hyphens = 145,
        eCSSProperty_initial_letter = 146,
        eCSSProperty_image_orientation = 147,
        eCSSProperty__moz_image_region = 148,
        eCSSProperty_image_rendering = 149,
        eCSSProperty_ime_mode = 150,
        eCSSProperty_inline_size = 151,
        eCSSProperty_isolation = 152,
        eCSSProperty_justify_content = 153,
        eCSSProperty_justify_items = 154,
        eCSSProperty_justify_self = 155,
        eCSSProperty__x_lang = 156,
        eCSSProperty_left = 157,
        eCSSProperty_letter_spacing = 158,
        eCSSProperty_lighting_color = 159,
        eCSSProperty_line_height = 160,
        eCSSProperty_list_style_image = 161,
        eCSSProperty_list_style_position = 162,
        eCSSProperty_list_style_type = 163,
        eCSSProperty_margin_block_end = 164,
        eCSSProperty_margin_block_start = 165,
        eCSSProperty_margin_bottom = 166,
        eCSSProperty_margin_inline_end = 167,
        eCSSProperty_margin_inline_start = 168,
        eCSSProperty_margin_left = 169,
        eCSSProperty_margin_right = 170,
        eCSSProperty_margin_top = 171,
        eCSSProperty_marker_end = 172,
        eCSSProperty_marker_mid = 173,
        eCSSProperty_marker_start = 174,
        eCSSProperty_mask_clip = 175,
        eCSSProperty_mask_composite = 176,
        eCSSProperty_mask_image = 177,
        eCSSProperty_mask_mode = 178,
        eCSSProperty_mask_origin = 179,
        eCSSProperty_mask_position_x = 180,
        eCSSProperty_mask_position_y = 181,
        eCSSProperty_mask_repeat = 182,
        eCSSProperty_mask_size = 183,
        eCSSProperty_mask_type = 184,
        eCSSProperty__moz_math_display = 185,
        eCSSProperty__moz_math_variant = 186,
        eCSSProperty_max_block_size = 187,
        eCSSProperty_max_height = 188,
        eCSSProperty_max_inline_size = 189,
        eCSSProperty_max_width = 190,
        eCSSProperty_min_block_size = 191,
        eCSSProperty__moz_min_font_size_ratio = 192,
        eCSSProperty_min_height = 193,
        eCSSProperty_min_inline_size = 194,
        eCSSProperty_min_width = 195,
        eCSSProperty_mix_blend_mode = 196,
        eCSSProperty_object_fit = 197,
        eCSSProperty_object_position = 198,
        eCSSProperty_offset_block_end = 199,
        eCSSProperty_offset_block_start = 200,
        eCSSProperty_offset_inline_end = 201,
        eCSSProperty_offset_inline_start = 202,
        eCSSProperty_opacity = 203,
        eCSSProperty_order = 204,
        eCSSProperty__moz_orient = 205,
        eCSSProperty__moz_osx_font_smoothing = 206,
        eCSSProperty_outline_color = 207,
        eCSSProperty_outline_offset = 208,
        eCSSProperty__moz_outline_radius_bottomleft = 209,
        eCSSProperty__moz_outline_radius_bottomright = 210,
        eCSSProperty__moz_outline_radius_topleft = 211,
        eCSSProperty__moz_outline_radius_topright = 212,
        eCSSProperty_outline_style = 213,
        eCSSProperty_outline_width = 214,
        eCSSProperty_overflow_clip_box_block = 215,
        eCSSProperty_overflow_clip_box_inline = 216,
        eCSSProperty_overflow_x = 217,
        eCSSProperty_overflow_y = 218,
        eCSSProperty_padding_block_end = 219,
        eCSSProperty_padding_block_start = 220,
        eCSSProperty_padding_bottom = 221,
        eCSSProperty_padding_inline_end = 222,
        eCSSProperty_padding_inline_start = 223,
        eCSSProperty_padding_left = 224,
        eCSSProperty_padding_right = 225,
        eCSSProperty_padding_top = 226,
        eCSSProperty_page_break_after = 227,
        eCSSProperty_page_break_before = 228,
        eCSSProperty_page_break_inside = 229,
        eCSSProperty_paint_order = 230,
        eCSSProperty_perspective = 231,
        eCSSProperty_perspective_origin = 232,
        eCSSProperty_pointer_events = 233,
        eCSSProperty_position = 234,
        eCSSProperty_quotes = 235,
        eCSSProperty_resize = 236,
        eCSSProperty_right = 237,
        eCSSProperty_rotate = 238,
        eCSSProperty_ruby_align = 239,
        eCSSProperty_ruby_position = 240,
        eCSSProperty__moz_script_level = 241,
        eCSSProperty__moz_script_min_size = 242,
        eCSSProperty__moz_script_size_multiplier = 243,
        eCSSProperty_scroll_behavior = 244,
        eCSSProperty_overscroll_behavior_x = 245,
        eCSSProperty_overscroll_behavior_y = 246,
        eCSSProperty_scroll_snap_coordinate = 247,
        eCSSProperty_scroll_snap_destination = 248,
        eCSSProperty_scroll_snap_points_x = 249,
        eCSSProperty_scroll_snap_points_y = 250,
        eCSSProperty_scroll_snap_type_x = 251,
        eCSSProperty_scroll_snap_type_y = 252,
        eCSSProperty_shape_image_threshold = 253,
        eCSSProperty_shape_outside = 254,
        eCSSProperty_shape_rendering = 255,
        eCSSProperty__x_span = 256,
        eCSSProperty__moz_stack_sizing = 257,
        eCSSProperty_stop_color = 258,
        eCSSProperty_stop_opacity = 259,
        eCSSProperty_stroke = 260,
        eCSSProperty_stroke_dasharray = 261,
        eCSSProperty_stroke_dashoffset = 262,
        eCSSProperty_stroke_linecap = 263,
        eCSSProperty_stroke_linejoin = 264,
        eCSSProperty_stroke_miterlimit = 265,
        eCSSProperty_stroke_opacity = 266,
        eCSSProperty_stroke_width = 267,
        eCSSProperty__x_system_font = 268,
        eCSSProperty__moz_tab_size = 269,
        eCSSProperty_table_layout = 270,
        eCSSProperty_text_align = 271,
        eCSSProperty_text_align_last = 272,
        eCSSProperty_text_anchor = 273,
        eCSSProperty_text_combine_upright = 274,
        eCSSProperty_text_decoration_color = 275,
        eCSSProperty_text_decoration_line = 276,
        eCSSProperty_text_decoration_style = 277,
        eCSSProperty_text_emphasis_color = 278,
        eCSSProperty_text_emphasis_position = 279,
        eCSSProperty_text_emphasis_style = 280,
        eCSSProperty__webkit_text_fill_color = 281,
        eCSSProperty_text_indent = 282,
        eCSSProperty_text_justify = 283,
        eCSSProperty_text_orientation = 284,
        eCSSProperty_text_overflow = 285,
        eCSSProperty_text_rendering = 286,
        eCSSProperty_text_shadow = 287,
        eCSSProperty__moz_text_size_adjust = 288,
        eCSSProperty__webkit_text_stroke_color = 289,
        eCSSProperty__webkit_text_stroke_width = 290,
        eCSSProperty_scale = 291,
        eCSSProperty_text_transform = 292,
        eCSSProperty__x_text_zoom = 293,
        eCSSProperty_top = 294,
        eCSSProperty__moz_top_layer = 295,
        eCSSProperty_touch_action = 296,
        eCSSProperty_transform = 297,
        eCSSProperty_transform_box = 298,
        eCSSProperty_transform_origin = 299,
        eCSSProperty_transform_style = 300,
        eCSSProperty_transition_delay = 301,
        eCSSProperty_transition_duration = 302,
        eCSSProperty_transition_property = 303,
        eCSSProperty_transition_timing_function = 304,
        eCSSProperty_translate = 305,
        eCSSProperty_unicode_bidi = 306,
        eCSSProperty__moz_user_focus = 307,
        eCSSProperty__moz_user_input = 308,
        eCSSProperty__moz_user_modify = 309,
        eCSSProperty__moz_user_select = 310,
        eCSSProperty_vector_effect = 311,
        eCSSProperty_vertical_align = 312,
        eCSSProperty_visibility = 313,
        eCSSProperty_white_space = 314,
        eCSSProperty_width = 315,
        eCSSProperty_will_change = 316,
        eCSSProperty__moz_window_dragging = 317,
        eCSSProperty__moz_window_shadow = 318,
        eCSSProperty__moz_window_opacity = 319,
        eCSSProperty__moz_window_transform = 320,
        eCSSProperty__moz_window_transform_origin = 321,
        eCSSProperty_word_break = 322,
        eCSSProperty_word_spacing = 323,
        eCSSProperty_overflow_wrap = 324,
        eCSSProperty_writing_mode = 325,
        eCSSProperty_z_index = 326,
        eCSSProperty_all = 327,
        eCSSProperty_animation = 328,
        eCSSProperty_background = 329,
        eCSSProperty_background_position = 330,
        eCSSProperty_border = 331,
        eCSSProperty_border_block_end = 332,
        eCSSProperty_border_block_start = 333,
        eCSSProperty_border_bottom = 334,
        eCSSProperty_border_color = 335,
        eCSSProperty_border_image = 336,
        eCSSProperty_border_inline_end = 337,
        eCSSProperty_border_inline_start = 338,
        eCSSProperty_border_left = 339,
        eCSSProperty_border_radius = 340,
        eCSSProperty_border_right = 341,
        eCSSProperty_border_style = 342,
        eCSSProperty_border_top = 343,
        eCSSProperty_border_width = 344,
        eCSSProperty_column_rule = 345,
        eCSSProperty_columns = 346,
        eCSSProperty_flex = 347,
        eCSSProperty_flex_flow = 348,
        eCSSProperty_font = 349,
        eCSSProperty_font_variant = 350,
        eCSSProperty_grid = 351,
        eCSSProperty_grid_area = 352,
        eCSSProperty_grid_column = 353,
        eCSSProperty_grid_gap = 354,
        eCSSProperty_grid_row = 355,
        eCSSProperty_grid_template = 356,
        eCSSProperty_list_style = 357,
        eCSSProperty_margin = 358,
        eCSSProperty_marker = 359,
        eCSSProperty_mask = 360,
        eCSSProperty_mask_position = 361,
        eCSSProperty_outline = 362,
        eCSSProperty__moz_outline_radius = 363,
        eCSSProperty_overflow = 364,
        eCSSProperty_overflow_clip_box = 365,
        eCSSProperty_padding = 366,
        eCSSProperty_place_content = 367,
        eCSSProperty_place_items = 368,
        eCSSProperty_place_self = 369,
        eCSSProperty_overscroll_behavior = 370,
        eCSSProperty_scroll_snap_type = 371,
        eCSSProperty_text_decoration = 372,
        eCSSProperty_text_emphasis = 373,
        eCSSProperty__webkit_text_stroke = 374,
        eCSSProperty_transition = 375,
        eCSSPropertyAlias_WordWrap = 376,
        eCSSPropertyAlias_MozTransform = 377,
        eCSSPropertyAlias_MozTransformOrigin = 378,
        eCSSPropertyAlias_MozPerspectiveOrigin = 379,
        eCSSPropertyAlias_MozPerspective = 380,
        eCSSPropertyAlias_MozTransformStyle = 381,
        eCSSPropertyAlias_MozBackfaceVisibility = 382,
        eCSSPropertyAlias_MozBorderImage = 383,
        eCSSPropertyAlias_MozTransition = 384,
        eCSSPropertyAlias_MozTransitionDelay = 385,
        eCSSPropertyAlias_MozTransitionDuration = 386,
        eCSSPropertyAlias_MozTransitionProperty = 387,
        eCSSPropertyAlias_MozTransitionTimingFunction = 388,
        eCSSPropertyAlias_MozAnimation = 389,
        eCSSPropertyAlias_MozAnimationDelay = 390,
        eCSSPropertyAlias_MozAnimationDirection = 391,
        eCSSPropertyAlias_MozAnimationDuration = 392,
        eCSSPropertyAlias_MozAnimationFillMode = 393,
        eCSSPropertyAlias_MozAnimationIterationCount = 394,
        eCSSPropertyAlias_MozAnimationName = 395,
        eCSSPropertyAlias_MozAnimationPlayState = 396,
        eCSSPropertyAlias_MozAnimationTimingFunction = 397,
        eCSSPropertyAlias_MozBoxSizing = 398,
        eCSSPropertyAlias_MozFontFeatureSettings = 399,
        eCSSPropertyAlias_MozFontLanguageOverride = 400,
        eCSSPropertyAlias_MozPaddingEnd = 401,
        eCSSPropertyAlias_MozPaddingStart = 402,
        eCSSPropertyAlias_MozMarginEnd = 403,
        eCSSPropertyAlias_MozMarginStart = 404,
        eCSSPropertyAlias_MozBorderEnd = 405,
        eCSSPropertyAlias_MozBorderEndColor = 406,
        eCSSPropertyAlias_MozBorderEndStyle = 407,
        eCSSPropertyAlias_MozBorderEndWidth = 408,
        eCSSPropertyAlias_MozBorderStart = 409,
        eCSSPropertyAlias_MozBorderStartColor = 410,
        eCSSPropertyAlias_MozBorderStartStyle = 411,
        eCSSPropertyAlias_MozBorderStartWidth = 412,
        eCSSPropertyAlias_MozHyphens = 413,
        eCSSPropertyAlias_MozColumnCount = 414,
        eCSSPropertyAlias_MozColumnFill = 415,
        eCSSPropertyAlias_MozColumnGap = 416,
        eCSSPropertyAlias_MozColumnRule = 417,
        eCSSPropertyAlias_MozColumnRuleColor = 418,
        eCSSPropertyAlias_MozColumnRuleStyle = 419,
        eCSSPropertyAlias_MozColumnRuleWidth = 420,
        eCSSPropertyAlias_MozColumnSpan = 421,
        eCSSPropertyAlias_MozColumnWidth = 422,
        eCSSPropertyAlias_MozColumns = 423,
        eCSSPropertyAlias_WebkitAnimation = 424,
        eCSSPropertyAlias_WebkitAnimationDelay = 425,
        eCSSPropertyAlias_WebkitAnimationDirection = 426,
        eCSSPropertyAlias_WebkitAnimationDuration = 427,
        eCSSPropertyAlias_WebkitAnimationFillMode = 428,
        eCSSPropertyAlias_WebkitAnimationIterationCount = 429,
        eCSSPropertyAlias_WebkitAnimationName = 430,
        eCSSPropertyAlias_WebkitAnimationPlayState = 431,
        eCSSPropertyAlias_WebkitAnimationTimingFunction = 432,
        eCSSPropertyAlias_WebkitFilter = 433,
        eCSSPropertyAlias_WebkitTextSizeAdjust = 434,
        eCSSPropertyAlias_WebkitTransform = 435,
        eCSSPropertyAlias_WebkitTransformOrigin = 436,
        eCSSPropertyAlias_WebkitTransformStyle = 437,
        eCSSPropertyAlias_WebkitBackfaceVisibility = 438,
        eCSSPropertyAlias_WebkitPerspective = 439,
        eCSSPropertyAlias_WebkitPerspectiveOrigin = 440,
        eCSSPropertyAlias_WebkitTransition = 441,
        eCSSPropertyAlias_WebkitTransitionDelay = 442,
        eCSSPropertyAlias_WebkitTransitionDuration = 443,
        eCSSPropertyAlias_WebkitTransitionProperty = 444,
        eCSSPropertyAlias_WebkitTransitionTimingFunction = 445,
        eCSSPropertyAlias_WebkitBorderRadius = 446,
        eCSSPropertyAlias_WebkitBorderTopLeftRadius = 447,
        eCSSPropertyAlias_WebkitBorderTopRightRadius = 448,
        eCSSPropertyAlias_WebkitBorderBottomLeftRadius = 449,
        eCSSPropertyAlias_WebkitBorderBottomRightRadius = 450,
        eCSSPropertyAlias_WebkitBackgroundClip = 451,
        eCSSPropertyAlias_WebkitBackgroundOrigin = 452,
        eCSSPropertyAlias_WebkitBackgroundSize = 453,
        eCSSPropertyAlias_WebkitBorderImage = 454,
        eCSSPropertyAlias_WebkitBoxShadow = 455,
        eCSSPropertyAlias_WebkitBoxSizing = 456,
        eCSSPropertyAlias_WebkitBoxFlex = 457,
        eCSSPropertyAlias_WebkitBoxOrdinalGroup = 458,
        eCSSPropertyAlias_WebkitBoxOrient = 459,
        eCSSPropertyAlias_WebkitBoxDirection = 460,
        eCSSPropertyAlias_WebkitBoxAlign = 461,
        eCSSPropertyAlias_WebkitBoxPack = 462,
        eCSSPropertyAlias_WebkitFlexDirection = 463,
        eCSSPropertyAlias_WebkitFlexWrap = 464,
        eCSSPropertyAlias_WebkitFlexFlow = 465,
        eCSSPropertyAlias_WebkitOrder = 466,
        eCSSPropertyAlias_WebkitFlex = 467,
        eCSSPropertyAlias_WebkitFlexGrow = 468,
        eCSSPropertyAlias_WebkitFlexShrink = 469,
        eCSSPropertyAlias_WebkitFlexBasis = 470,
        eCSSPropertyAlias_WebkitJustifyContent = 471,
        eCSSPropertyAlias_WebkitAlignItems = 472,
        eCSSPropertyAlias_WebkitAlignSelf = 473,
        eCSSPropertyAlias_WebkitAlignContent = 474,
        eCSSPropertyAlias_WebkitUserSelect = 475,
        eCSSPropertyAlias_WebkitMask = 476,
        eCSSPropertyAlias_WebkitMaskClip = 477,
        eCSSPropertyAlias_WebkitMaskComposite = 478,
        eCSSPropertyAlias_WebkitMaskImage = 479,
        eCSSPropertyAlias_WebkitMaskOrigin = 480,
        eCSSPropertyAlias_WebkitMaskPosition = 481,
        eCSSPropertyAlias_WebkitMaskPositionX = 482,
        eCSSPropertyAlias_WebkitMaskPositionY = 483,
        eCSSPropertyAlias_WebkitMaskRepeat = 484,
        eCSSPropertyAlias_WebkitMaskSize = 485,
        eCSSPropertyExtra_no_properties = 486,
        eCSSPropertyExtra_all_properties = 487,
        eCSSPropertyExtra_x_none_value = 488,
        eCSSPropertyExtra_x_auto_value = 489,
        eCSSPropertyExtra_variable = 490,
        eCSSProperty_DOM = 491,
    }
    #[repr(i32)]
    #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
    pub enum nsCSSFontDesc {
        eCSSFontDesc_UNKNOWN = -1,
        eCSSFontDesc_Family = 0,
        eCSSFontDesc_Style = 1,
        eCSSFontDesc_Weight = 2,
        eCSSFontDesc_Stretch = 3,
        eCSSFontDesc_Src = 4,
        eCSSFontDesc_UnicodeRange = 5,
        eCSSFontDesc_FontFeatureSettings = 6,
        eCSSFontDesc_FontVariationSettings = 7,
        eCSSFontDesc_FontLanguageOverride = 8,
        eCSSFontDesc_Display = 9,
        eCSSFontDesc_COUNT = 10,
    }
    #[repr(i32)]
    #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
    pub enum nsCSSCounterDesc {
        eCSSCounterDesc_UNKNOWN = -1,
        eCSSCounterDesc_System = 0,
        eCSSCounterDesc_Symbols = 1,
        eCSSCounterDesc_AdditiveSymbols = 2,
        eCSSCounterDesc_Negative = 3,
        eCSSCounterDesc_Prefix = 4,
        eCSSCounterDesc_Suffix = 5,
        eCSSCounterDesc_Range = 6,
        eCSSCounterDesc_Pad = 7,
        eCSSCounterDesc_Fallback = 8,
        eCSSCounterDesc_SpeakAs = 9,
        eCSSCounterDesc_COUNT = 10,
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct RawServoAuthorStyles {
        _unused: [u8; 0],
    }
    impl Clone for RawServoAuthorStyles {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct RawServoStyleSet {
        _unused: [u8; 0],
    }
    impl Clone for RawServoStyleSet {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct RawServoSourceSizeList {
        _unused: [u8; 0],
    }
    impl Clone for RawServoSourceSizeList {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct RustString {
        _unused: [u8; 0],
    }
    impl Clone for RustString {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct RawServoStyleSheetContents {
        _unused: [u8; 0],
    }
    impl Clone for RawServoStyleSheetContents {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct RawServoDeclarationBlock {
        _unused: [u8; 0],
    }
    impl Clone for RawServoDeclarationBlock {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct RawServoStyleRule {
        _unused: [u8; 0],
    }
    impl Clone for RawServoStyleRule {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct RawServoAnimationValue {
        _unused: [u8; 0],
    }
    impl Clone for RawServoAnimationValue {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct RawServoMediaList {
        _unused: [u8; 0],
    }
    impl Clone for RawServoMediaList {
        fn clone(&self) -> Self {
            *self
        }
    }
    pub mod nsStyleTransformMatrix {
        #[allow(unused_imports)]
        use self::super::super::root;
        #[repr(u8)]
        #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
        pub enum MatrixTransformOperator {
            Interpolate = 0,
            Accumulate = 1,
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsCSSPropertyIDSet {
        _unused: [u8; 0],
    }
    impl Clone for nsCSSPropertyIDSet {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsSimpleContentList {
        _unused: [u8; 0],
    }
    impl Clone for nsSimpleContentList {
        fn clone(&self) -> Self {
            *self
        }
    }
    pub type RawGeckoNode = root::nsINode;
    pub type RawGeckoElement = root::mozilla::dom::Element;
    pub type RawGeckoDocument = root::nsIDocument;
    pub type RawGeckoPresContext = root::nsPresContext;
    pub type RawGeckoXBLBinding = root::nsXBLBinding;
    pub type RawGeckoURLExtraData = root::mozilla::URLExtraData;
    pub type RawGeckoServoAnimationValueList =
        root::nsTArray<root::RefPtr<root::RawServoAnimationValue>>;
    pub type RawGeckoKeyframeList = root::nsTArray<root::mozilla::Keyframe>;
    pub type RawGeckoPropertyValuePairList = root::nsTArray<root::mozilla::PropertyValuePair>;
    pub type RawGeckoComputedKeyframeValuesList =
        root::nsTArray<root::mozilla::ComputedKeyframeValues>;
    pub type RawGeckoStyleAnimationList = root::nsStyleAutoArray<root::mozilla::StyleAnimation>;
    pub type RawGeckoFontFaceRuleList = root::nsTArray<root::nsFontFaceRuleContainer>;
    pub type RawGeckoAnimationPropertySegment = root::mozilla::AnimationPropertySegment;
    pub type RawGeckoComputedTiming = root::mozilla::ComputedTiming;
    pub type RawGeckoServoStyleRuleList = root::nsTArray<*const root::RawServoStyleRule>;
    pub type RawGeckoCSSPropertyIDList = root::nsTArray<root::nsCSSPropertyID>;
    pub type RawGeckoGfxMatrix4x4 = [root::mozilla::gfx::Float; 16usize];
    pub type RawGeckoStyleChildrenIterator = root::mozilla::dom::StyleChildrenIterator;
    pub type ServoStyleContextBorrowed = *const root::mozilla::ServoStyleContext;
    pub type ServoStyleContextBorrowedOrNull = *const root::mozilla::ServoStyleContext;
    pub type ServoComputedDataBorrowed = *const root::ServoComputedData;
    pub type RawGeckoNodeBorrowed = *const root::RawGeckoNode;
    pub type RawGeckoNodeBorrowedOrNull = *const root::RawGeckoNode;
    pub type RawGeckoElementBorrowed = *const root::RawGeckoElement;
    pub type RawGeckoElementBorrowedOrNull = *const root::RawGeckoElement;
    pub type RawGeckoDocumentBorrowed = *const root::RawGeckoDocument;
    pub type RawGeckoDocumentBorrowedOrNull = *const root::RawGeckoDocument;
    pub type RawGeckoXBLBindingBorrowed = *const root::RawGeckoXBLBinding;
    pub type RawGeckoXBLBindingBorrowedOrNull = *const root::RawGeckoXBLBinding;
    pub type RawGeckoPresContextOwned = *mut root::RawGeckoPresContext;
    pub type RawGeckoPresContextBorrowed = *const root::RawGeckoPresContext;
    pub type RawGeckoPresContextBorrowedMut = *mut root::RawGeckoPresContext;
    pub type RawGeckoServoAnimationValueListBorrowedMut =
        *mut root::RawGeckoServoAnimationValueList;
    pub type RawGeckoServoAnimationValueListBorrowed = *const root::RawGeckoServoAnimationValueList;
    pub type RawGeckoKeyframeListBorrowedMut = *mut root::RawGeckoKeyframeList;
    pub type RawGeckoKeyframeListBorrowed = *const root::RawGeckoKeyframeList;
    pub type RawGeckoPropertyValuePairListBorrowedMut = *mut root::RawGeckoPropertyValuePairList;
    pub type RawGeckoPropertyValuePairListBorrowed = *const root::RawGeckoPropertyValuePairList;
    pub type RawGeckoComputedKeyframeValuesListBorrowedMut =
        *mut root::RawGeckoComputedKeyframeValuesList;
    pub type RawGeckoStyleAnimationListBorrowedMut = *mut root::RawGeckoStyleAnimationList;
    pub type RawGeckoStyleAnimationListBorrowed = *const root::RawGeckoStyleAnimationList;
    pub type RawGeckoFontFaceRuleListBorrowedMut = *mut root::RawGeckoFontFaceRuleList;
    pub type RawGeckoAnimationPropertySegmentBorrowed =
        *const root::RawGeckoAnimationPropertySegment;
    pub type RawGeckoComputedTimingBorrowed = *const root::RawGeckoComputedTiming;
    pub type RawGeckoServoStyleRuleListBorrowedMut = *mut root::RawGeckoServoStyleRuleList;
    pub type RawGeckoCSSPropertyIDListBorrowed = *const root::RawGeckoCSSPropertyIDList;
    pub type RawGeckoStyleChildrenIteratorBorrowedMut = *mut root::RawGeckoStyleChildrenIterator;
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsHTMLCSSStyleSheet {
        _unused: [u8; 0],
    }
    impl Clone for nsHTMLCSSStyleSheet {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsHTMLStyleSheet {
        _unused: [u8; 0],
    }
    impl Clone for nsHTMLStyleSheet {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIBFCacheEntry {
        _unused: [u8; 0],
    }
    impl Clone for nsIBFCacheEntry {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIDocumentEncoder {
        _unused: [u8; 0],
    }
    impl Clone for nsIDocumentEncoder {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIStructuredCloneContainer {
        _unused: [u8; 0],
    }
    impl Clone for nsIStructuredCloneContainer {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsSMILAnimationController {
        _unused: [u8; 0],
    }
    impl Clone for nsSMILAnimationController {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    pub struct nsIDocument {
        pub _base: root::nsINode,
        pub _base_1: root::mozilla::dom::DocumentOrShadowRoot,
        pub _base_2: root::mozilla::dom::DispatcherTrait,
        pub mDeprecationWarnedAbout: u64,
        pub mDocWarningWarnedAbout: u64,
        pub mServoSelectorCache: root::mozilla::UniquePtr<root::nsIDocument_SelectorCache>,
        pub mGeckoSelectorCache: root::mozilla::UniquePtr<root::nsIDocument_SelectorCache>,
        pub mReferrer: root::nsCString,
        pub mLastModified: ::nsstring::nsStringRepr,
        pub mDocumentURI: root::nsCOMPtr,
        pub mOriginalURI: root::nsCOMPtr,
        pub mChromeXHRDocURI: root::nsCOMPtr,
        pub mDocumentBaseURI: root::nsCOMPtr,
        pub mChromeXHRDocBaseURI: root::nsCOMPtr,
        pub mCachedURLData: root::RefPtr<root::mozilla::URLExtraData>,
        pub mDocumentLoadGroup: root::nsWeakPtr,
        pub mReferrerPolicySet: bool,
        pub mReferrerPolicy: root::nsIDocument_ReferrerPolicyEnum,
        pub mBlockAllMixedContent: bool,
        pub mBlockAllMixedContentPreloads: bool,
        pub mUpgradeInsecureRequests: bool,
        pub mUpgradeInsecurePreloads: bool,
        pub mDocumentContainer: u64,
        pub mCharacterSet: root::mozilla::NotNull<*const root::nsIDocument_Encoding>,
        pub mCharacterSetSource: i32,
        pub mParentDocument: *mut root::nsIDocument,
        pub mCachedRootElement: *mut root::mozilla::dom::Element,
        pub mNodeInfoManager: *mut root::nsNodeInfoManager,
        pub mCSSLoader: root::RefPtr<root::mozilla::css::Loader>,
        pub mStyleImageLoader: root::RefPtr<root::mozilla::css::ImageLoader>,
        pub mAttrStyleSheet: root::RefPtr<root::nsHTMLStyleSheet>,
        pub mStyleAttrStyleSheet: root::RefPtr<root::nsHTMLCSSStyleSheet>,
        pub mImageTracker: root::RefPtr<root::mozilla::dom::ImageTracker>,
        pub mActivityObservers: u64,
        pub mLinksToUpdate: root::nsIDocument_LinksToUpdateList,
        pub mAnimationController: root::RefPtr<root::nsSMILAnimationController>,
        pub mPropertyTable: root::nsPropertyTable,
        pub mExtraPropertyTables: root::nsTArray<root::nsAutoPtr<root::nsPropertyTable>>,
        pub mChildrenCollection: root::nsCOMPtr,
        pub mFontFaceSet: root::RefPtr<root::mozilla::dom::FontFaceSet>,
        pub mLastFocusTime: root::mozilla::TimeStamp,
        pub mDocumentState: root::mozilla::EventStates,
        pub mReadyForIdle: root::RefPtr<root::mozilla::dom::Promise>,
        pub _bitfield_1: root::__BindgenBitfieldUnit<[u8; 7usize], u8>,
        pub mCompatMode: root::nsCompatibility,
        pub mReadyState: root::nsIDocument_ReadyState,
        pub mStyleBackendType: root::mozilla::StyleBackendType,
        pub mVisibilityState: root::mozilla::dom::VisibilityState,
        pub mType: root::nsIDocument_Type,
        pub mDefaultElementType: u8,
        pub mAllowXULXBL: root::nsIDocument_Tri,
        pub mScriptGlobalObject: root::nsCOMPtr,
        pub mOriginalDocument: root::nsCOMPtr,
        pub mBidiOptions: u32,
        pub mSandboxFlags: u32,
        pub mContentLanguage: root::nsCString,
        pub mChannel: root::nsCOMPtr,
        pub mContentType: root::nsCString,
        pub mSecurityInfo: root::nsCOMPtr,
        pub mFailedChannel: root::nsCOMPtr,
        pub mPartID: u32,
        pub mMarkedCCGeneration: u32,
        pub mPresShell: *mut root::nsIPresShell,
        pub mSubtreeModifiedTargets: root::nsCOMArray,
        pub mSubtreeModifiedDepth: u32,
        pub mDisplayDocument: root::nsCOMPtr,
        pub mEventsSuppressed: u32,
        /// https://html.spec.whatwg.org/#ignore-destructive-writes-counter
        pub mIgnoreDestructiveWritesCounter: u32,
        /// The current frame request callback handle
        pub mFrameRequestCallbackCounter: i32,
        pub mStaticCloneCount: u32,
        pub mBlockedTrackingNodes: root::nsTArray<root::nsWeakPtr>,
        pub mWindow: *mut root::nsPIDOMWindowInner,
        pub mCachedEncoder: root::nsCOMPtr,
        pub mFrameRequestCallbacks: root::nsTArray<root::nsIDocument_FrameRequest>,
        pub mBFCacheEntry: *mut root::nsIBFCacheEntry,
        pub mBaseTarget: ::nsstring::nsStringRepr,
        pub mStateObjectContainer: root::nsCOMPtr,
        pub mStateObjectCached: root::nsCOMPtr,
        pub mInSyncOperationCount: u32,
        pub mXPathEvaluator: root::mozilla::UniquePtr<root::mozilla::dom::XPathEvaluator>,
        pub mAnonymousContents: root::nsTArray<root::RefPtr<root::mozilla::dom::AnonymousContent>>,
        pub mBlockDOMContentLoaded: u32,
        pub mDOMMediaQueryLists: root::mozilla::LinkedList,
        pub mUseCounters: [u64; 2usize],
        pub mChildDocumentUseCounters: [u64; 2usize],
        pub mNotifiedPageForUseCounter: [u64; 2usize],
        pub mIncCounters: u16,
        pub mUserHasInteracted: bool,
        pub mUserHasActivatedInteraction: bool,
        pub mPageUnloadingEventTimeStamp: root::mozilla::TimeStamp,
        pub mDocGroup: root::RefPtr<root::mozilla::dom::DocGroup>,
        pub mTrackingScripts: [u64; 4usize],
        pub mBufferedCSPViolations: root::nsTArray<root::nsCOMPtr>,
        pub mAncestorPrincipals: root::nsTArray<root::nsCOMPtr>,
        pub mAncestorOuterWindowIDs: root::nsTArray<u64>,
        pub mServoRestyleRoot: root::nsCOMPtr,
        pub mServoRestyleRootDirtyBits: u32,
        pub mThrowOnDynamicMarkupInsertionCounter: u32,
        pub mIgnoreOpensDuringUnloadCounter: u32,
    }
    pub type nsIDocument_GlobalObject = root::mozilla::dom::GlobalObject;
    pub type nsIDocument_Encoding = root::mozilla::Encoding;
    pub type nsIDocument_NotNull<T> = root::mozilla::NotNull<T>;
    pub use self::super::root::mozilla::net::ReferrerPolicy as nsIDocument_ReferrerPolicyEnum;
    pub type nsIDocument_Element = root::mozilla::dom::Element;
    pub type nsIDocument_FullscreenRequest = root::mozilla::dom::FullscreenRequest;
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct nsIDocument_COMTypeInfo {
        pub _address: u8,
    }
    #[repr(C)]
    pub struct nsIDocument_PageUnloadingEventTimeStamp {
        pub mDocument: root::nsCOMPtr,
        pub mSet: bool,
    }
    #[test]
    fn bindgen_test_layout_nsIDocument_PageUnloadingEventTimeStamp() {
        assert_eq!(
            ::std::mem::size_of::<nsIDocument_PageUnloadingEventTimeStamp>(),
            16usize,
            concat!(
                "Size of: ",
                stringify!(nsIDocument_PageUnloadingEventTimeStamp)
            )
        );
        assert_eq!(
            ::std::mem::align_of::<nsIDocument_PageUnloadingEventTimeStamp>(),
            8usize,
            concat!(
                "Alignment of ",
                stringify!(nsIDocument_PageUnloadingEventTimeStamp)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIDocument_PageUnloadingEventTimeStamp>())).mDocument
                    as *const _ as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIDocument_PageUnloadingEventTimeStamp),
                "::",
                stringify!(mDocument)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIDocument_PageUnloadingEventTimeStamp>())).mSet as *const _
                    as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIDocument_PageUnloadingEventTimeStamp),
                "::",
                stringify!(mSet)
            )
        );
    }
    /// This gets fired when the element that an id refers to changes.
    /// This fires at difficult times. It is generally not safe to do anything
    /// which could modify the DOM in any way. Use
    /// nsContentUtils::AddScriptRunner.
    /// @return true to keep the callback in the callback set, false
    /// to remove it.
    pub type nsIDocument_IDTargetObserver = ::std::option::Option<
        unsafe extern "C" fn(
            aOldElement: *mut root::nsIDocument_Element,
            aNewelement: *mut root::nsIDocument_Element,
            aData: *mut ::std::os::raw::c_void,
        ) -> bool,
    >;
    #[repr(C)]
    pub struct nsIDocument_SelectorCacheKey {
        pub mKey: ::nsstring::nsStringRepr,
        pub mState: root::nsExpirationState,
    }
    #[test]
    fn bindgen_test_layout_nsIDocument_SelectorCacheKey() {
        assert_eq!(
            ::std::mem::size_of::<nsIDocument_SelectorCacheKey>(),
            24usize,
            concat!("Size of: ", stringify!(nsIDocument_SelectorCacheKey))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIDocument_SelectorCacheKey>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIDocument_SelectorCacheKey))
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIDocument_SelectorCacheKey>())).mKey as *const _ as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIDocument_SelectorCacheKey),
                "::",
                stringify!(mKey)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIDocument_SelectorCacheKey>())).mState as *const _ as usize
            },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIDocument_SelectorCacheKey),
                "::",
                stringify!(mState)
            )
        );
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIDocument_SelectorCacheKeyDeleter {
        _unused: [u8; 0],
    }
    impl Clone for nsIDocument_SelectorCacheKeyDeleter {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIDocument_SelectorCache {
        pub _bindgen_opaque_blob: [u64; 16usize],
    }
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsIDocument_SelectorCache_SelectorList {
        pub mIsServo: bool,
        pub __bindgen_anon_1: root::nsIDocument_SelectorCache_SelectorList__bindgen_ty_1,
    }
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIDocument_SelectorCache_SelectorList__bindgen_ty_1 {
        pub mGecko: root::__BindgenUnionField<*mut root::nsCSSSelectorList>,
        pub mServo: root::__BindgenUnionField<*mut root::RawServoSelectorList>,
        pub bindgen_union_field: u64,
    }
    #[test]
    fn bindgen_test_layout_nsIDocument_SelectorCache_SelectorList__bindgen_ty_1() {
        assert_eq!(
            ::std::mem::size_of::<nsIDocument_SelectorCache_SelectorList__bindgen_ty_1>(),
            8usize,
            concat!(
                "Size of: ",
                stringify!(nsIDocument_SelectorCache_SelectorList__bindgen_ty_1)
            )
        );
        assert_eq!(
            ::std::mem::align_of::<nsIDocument_SelectorCache_SelectorList__bindgen_ty_1>(),
            8usize,
            concat!(
                "Alignment of ",
                stringify!(nsIDocument_SelectorCache_SelectorList__bindgen_ty_1)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIDocument_SelectorCache_SelectorList__bindgen_ty_1>()))
                    .mGecko as *const _ as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIDocument_SelectorCache_SelectorList__bindgen_ty_1),
                "::",
                stringify!(mGecko)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIDocument_SelectorCache_SelectorList__bindgen_ty_1>()))
                    .mServo as *const _ as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIDocument_SelectorCache_SelectorList__bindgen_ty_1),
                "::",
                stringify!(mServo)
            )
        );
    }
    impl Clone for nsIDocument_SelectorCache_SelectorList__bindgen_ty_1 {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[test]
    fn bindgen_test_layout_nsIDocument_SelectorCache_SelectorList() {
        assert_eq!(
            ::std::mem::size_of::<nsIDocument_SelectorCache_SelectorList>(),
            16usize,
            concat!(
                "Size of: ",
                stringify!(nsIDocument_SelectorCache_SelectorList)
            )
        );
        assert_eq!(
            ::std::mem::align_of::<nsIDocument_SelectorCache_SelectorList>(),
            8usize,
            concat!(
                "Alignment of ",
                stringify!(nsIDocument_SelectorCache_SelectorList)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIDocument_SelectorCache_SelectorList>())).mIsServo
                    as *const _ as usize
            },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIDocument_SelectorCache_SelectorList),
                "::",
                stringify!(mIsServo)
            )
        );
    }
    #[test]
    fn bindgen_test_layout_nsIDocument_SelectorCache() {
        assert_eq!(
            ::std::mem::size_of::<nsIDocument_SelectorCache>(),
            128usize,
            concat!("Size of: ", stringify!(nsIDocument_SelectorCache))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIDocument_SelectorCache>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIDocument_SelectorCache))
        );
    }
    impl Clone for nsIDocument_SelectorCache {
        fn clone(&self) -> Self {
            *self
        }
    }
    pub const nsIDocument_additionalSheetType_eAgentSheet: root::nsIDocument_additionalSheetType =
        0;
    pub const nsIDocument_additionalSheetType_eUserSheet: root::nsIDocument_additionalSheetType = 1;
    pub const nsIDocument_additionalSheetType_eAuthorSheet: root::nsIDocument_additionalSheetType =
        2;
    pub const nsIDocument_additionalSheetType_AdditionalSheetTypeCount:
        root::nsIDocument_additionalSheetType = 3;
    pub type nsIDocument_additionalSheetType = u32;
    pub const nsIDocument_ReadyState_READYSTATE_UNINITIALIZED: root::nsIDocument_ReadyState = 0;
    pub const nsIDocument_ReadyState_READYSTATE_LOADING: root::nsIDocument_ReadyState = 1;
    pub const nsIDocument_ReadyState_READYSTATE_INTERACTIVE: root::nsIDocument_ReadyState = 3;
    pub const nsIDocument_ReadyState_READYSTATE_COMPLETE: root::nsIDocument_ReadyState = 4;
    pub type nsIDocument_ReadyState = u32;
    /// Enumerate all subdocuments.
    /// The enumerator callback should return true to continue enumerating, or
    /// false to stop.  This will never get passed a null aDocument.
    pub type nsIDocument_nsSubDocEnumFunc = ::std::option::Option<
        unsafe extern "C" fn(aDocument: *mut root::nsIDocument, aData: *mut ::std::os::raw::c_void)
            -> bool,
    >;
    /// Collect all the descendant documents for which |aCalback| returns true.
    /// The callback function must not mutate any state for the given document.
    pub type nsIDocument_nsDocTestFunc =
        ::std::option::Option<unsafe extern "C" fn(aDocument: *const root::nsIDocument) -> bool>;
    /// A class that represents an external resource load that has begun but
    /// doesn't have a document yet.  Observers can be registered on this object,
    /// and will be notified after the document is created.  Observers registered
    /// after the document has been created will NOT be notified.  When observers
    /// are notified, the subject will be the newly-created document, the topic
    /// will be "external-resource-document-created", and the data will be null.
    /// If document creation fails for some reason, observers will still be
    /// notified, with a null document pointer.
    #[repr(C)]
    #[derive(Debug)]
    pub struct nsIDocument_ExternalResourceLoad {
        pub _base: root::nsISupports,
        pub mObservers: [u64; 10usize],
    }
    #[test]
    fn bindgen_test_layout_nsIDocument_ExternalResourceLoad() {
        assert_eq!(
            ::std::mem::size_of::<nsIDocument_ExternalResourceLoad>(),
            88usize,
            concat!("Size of: ", stringify!(nsIDocument_ExternalResourceLoad))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIDocument_ExternalResourceLoad>(),
            8usize,
            concat!(
                "Alignment of ",
                stringify!(nsIDocument_ExternalResourceLoad)
            )
        );
        assert_eq!(
            unsafe {
                &(*(::std::ptr::null::<nsIDocument_ExternalResourceLoad>())).mObservers as *const _
                    as usize
            },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(nsIDocument_ExternalResourceLoad),
                "::",
                stringify!(mObservers)
            )
        );
    }
    pub type nsIDocument_ActivityObserverEnumerator = ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut root::nsISupports, arg2: *mut ::std::os::raw::c_void),
    >;
    #[repr(u32)]
    #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
    pub enum nsIDocument_DocumentTheme {
        Doc_Theme_Uninitialized = 0,
        Doc_Theme_None = 1,
        Doc_Theme_Neutral = 2,
        Doc_Theme_Dark = 3,
        Doc_Theme_Bright = 4,
    }
    pub type nsIDocument_FrameRequestCallbackList =
        root::nsTArray<root::RefPtr<root::mozilla::dom::FrameRequestCallback>>;
    pub const nsIDocument_DeprecatedOperations_eEnablePrivilege:
        root::nsIDocument_DeprecatedOperations = 0;
    pub const nsIDocument_DeprecatedOperations_eDOMExceptionCode:
        root::nsIDocument_DeprecatedOperations = 1;
    pub const nsIDocument_DeprecatedOperations_eMutationEvent:
        root::nsIDocument_DeprecatedOperations = 2;
    pub const nsIDocument_DeprecatedOperations_eComponents: root::nsIDocument_DeprecatedOperations =
        3;
    pub const nsIDocument_DeprecatedOperations_ePrefixedVisibilityAPI:
        root::nsIDocument_DeprecatedOperations = 4;
    pub const nsIDocument_DeprecatedOperations_eNodeIteratorDetach:
        root::nsIDocument_DeprecatedOperations = 5;
    pub const nsIDocument_DeprecatedOperations_eLenientThis:
        root::nsIDocument_DeprecatedOperations = 6;
    pub const nsIDocument_DeprecatedOperations_eGetSetUserData:
        root::nsIDocument_DeprecatedOperations = 7;
    pub const nsIDocument_DeprecatedOperations_eMozGetAsFile:
        root::nsIDocument_DeprecatedOperations = 8;
    pub const nsIDocument_DeprecatedOperations_eUseOfCaptureEvents:
        root::nsIDocument_DeprecatedOperations = 9;
    pub const nsIDocument_DeprecatedOperations_eUseOfReleaseEvents:
        root::nsIDocument_DeprecatedOperations = 10;
    pub const nsIDocument_DeprecatedOperations_eUseOfDOM3LoadMethod:
        root::nsIDocument_DeprecatedOperations = 11;
    pub const nsIDocument_DeprecatedOperations_eChromeUseOfDOM3LoadMethod:
        root::nsIDocument_DeprecatedOperations = 12;
    pub const nsIDocument_DeprecatedOperations_eShowModalDialog:
        root::nsIDocument_DeprecatedOperations = 13;
    pub const nsIDocument_DeprecatedOperations_eSyncXMLHttpRequest:
        root::nsIDocument_DeprecatedOperations = 14;
    pub const nsIDocument_DeprecatedOperations_eWindow_Cc_ontrollers:
        root::nsIDocument_DeprecatedOperations = 15;
    pub const nsIDocument_DeprecatedOperations_eImportXULIntoContent:
        root::nsIDocument_DeprecatedOperations = 16;
    pub const nsIDocument_DeprecatedOperations_ePannerNodeDoppler:
        root::nsIDocument_DeprecatedOperations = 17;
    pub const nsIDocument_DeprecatedOperations_eNavigatorGetUserMedia:
        root::nsIDocument_DeprecatedOperations = 18;
    pub const nsIDocument_DeprecatedOperations_eWebrtcDeprecatedPrefix:
        root::nsIDocument_DeprecatedOperations = 19;
    pub const nsIDocument_DeprecatedOperations_eRTCPeerConnectionGetStreams:
        root::nsIDocument_DeprecatedOperations = 20;
    pub const nsIDocument_DeprecatedOperations_eAppCache: root::nsIDocument_DeprecatedOperations =
        21;
    pub const nsIDocument_DeprecatedOperations_eAppCacheInsecure:
        root::nsIDocument_DeprecatedOperations = 22;
    pub const nsIDocument_DeprecatedOperations_ePrefixedImageSmoothingEnabled:
        root::nsIDocument_DeprecatedOperations = 23;
    pub const nsIDocument_DeprecatedOperations_ePrefixedFullscreenAPI:
        root::nsIDocument_DeprecatedOperations = 24;
    pub const nsIDocument_DeprecatedOperations_eLenientSetter:
        root::nsIDocument_DeprecatedOperations = 25;
    pub const nsIDocument_DeprecatedOperations_eFileLastModifiedDate:
        root::nsIDocument_DeprecatedOperations = 26;
    pub const nsIDocument_DeprecatedOperations_eImageBitmapRenderingContext_TransferImageBitmap:
        root::nsIDocument_DeprecatedOperations = 27;
    pub const nsIDocument_DeprecatedOperations_eURLCreateObjectURL_MediaStream:
        root::nsIDocument_DeprecatedOperations = 28;
    pub const nsIDocument_DeprecatedOperations_eXMLBaseAttribute:
        root::nsIDocument_DeprecatedOperations = 29;
    pub const nsIDocument_DeprecatedOperations_eWindowContentUntrusted:
        root::nsIDocument_DeprecatedOperations = 30;
    pub const nsIDocument_DeprecatedOperations_eRegisterProtocolHandlerInsecure:
        root::nsIDocument_DeprecatedOperations = 31;
    pub const nsIDocument_DeprecatedOperations_eMixedDisplayObjectSubrequest:
        root::nsIDocument_DeprecatedOperations = 32;
    pub const nsIDocument_DeprecatedOperations_eMotionEvent:
        root::nsIDocument_DeprecatedOperations = 33;
    pub const nsIDocument_DeprecatedOperations_eOrientationEvent:
        root::nsIDocument_DeprecatedOperations = 34;
    pub const nsIDocument_DeprecatedOperations_eProximityEvent:
        root::nsIDocument_DeprecatedOperations = 35;
    pub const nsIDocument_DeprecatedOperations_eAmbientLightEvent:
        root::nsIDocument_DeprecatedOperations = 36;
    pub const nsIDocument_DeprecatedOperations_eDeprecatedOperationCount:
        root::nsIDocument_DeprecatedOperations = 37;
    pub type nsIDocument_DeprecatedOperations = u32;
    pub const nsIDocument_DocumentWarnings_eIgnoringWillChangeOverBudget:
        root::nsIDocument_DocumentWarnings = 0;
    pub const nsIDocument_DocumentWarnings_ePreventDefaultFromPassiveListener:
        root::nsIDocument_DocumentWarnings = 1;
    pub const nsIDocument_DocumentWarnings_eSVGRefLoop: root::nsIDocument_DocumentWarnings = 2;
    pub const nsIDocument_DocumentWarnings_eSVGRefChainLengthExceeded:
        root::nsIDocument_DocumentWarnings = 3;
    pub const nsIDocument_DocumentWarnings_eDocumentWarningCount:
        root::nsIDocument_DocumentWarnings = 4;
    pub type nsIDocument_DocumentWarnings = u32;
    pub const nsIDocument_ElementCallbackType_eConnected: root::nsIDocument_ElementCallbackType = 0;
    pub const nsIDocument_ElementCallbackType_eDisconnected: root::nsIDocument_ElementCallbackType =
        1;
    pub const nsIDocument_ElementCallbackType_eAdopted: root::nsIDocument_ElementCallbackType = 2;
    pub const nsIDocument_ElementCallbackType_eAttributeChanged:
        root::nsIDocument_ElementCallbackType = 3;
    pub type nsIDocument_ElementCallbackType = u32;
    pub type nsIDocument_LinksToUpdateList = [u64; 3usize];
    pub const nsIDocument_eScopedStyle_Unknown: root::nsIDocument__bindgen_ty_1 = 0;
    pub const nsIDocument_eScopedStyle_Disabled: root::nsIDocument__bindgen_ty_1 = 1;
    pub const nsIDocument_eScopedStyle_Enabled: root::nsIDocument__bindgen_ty_1 = 2;
    pub type nsIDocument__bindgen_ty_1 = u32;
    #[repr(u32)]
    #[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)]
    pub enum nsIDocument_Type {
        eUnknown = 0,
        eHTML = 1,
        eXHTML = 2,
        eGenericXML = 3,
        eSVG = 4,
        eXUL = 5,
    }
    pub const nsIDocument_Tri_eTriUnset: root::nsIDocument_Tri = 0;
    pub const nsIDocument_Tri_eTriFalse: root::nsIDocument_Tri = 1;
    pub const nsIDocument_Tri_eTriTrue: root::nsIDocument_Tri = 2;
    pub type nsIDocument_Tri = u32;
    #[repr(C)]
    #[derive(Debug, Copy)]
    pub struct nsIDocument_FrameRequest {
        _unused: [u8; 0],
    }
    impl Clone for nsIDocument_FrameRequest {
        fn clone(&self) -> Self {
            *self
        }
    }
    pub const nsIDocument_kSegmentSize: usize = 128;
    #[test]
    fn bindgen_test_layout_nsIDocument() {
        assert_eq!(
            ::std::mem::size_of::<nsIDocument>(),
            928usize,
            concat!("Size of: ", stringify!(nsIDocument))
        );
        assert_eq!(
            ::std::mem::align_of::<nsIDocument>(),
            8usize,
            concat!("Alignment of ", stringify!(nsIDocument))
        );
    }
    impl nsIDocument {
        #[inline]
        pub fn mBidiEnabled(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mBidiEnabled(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(0usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mMathMLEnabled(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mMathMLEnabled(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(1usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mIsInitialDocumentInWindow(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mIsInitialDocumentInWindow(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(2usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mIgnoreDocGroupMismatches(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
        }
        #[inline]
        pub fn set_mIgnoreDocGroupMismatches(&mut self, val: bool) {
            unsafe {
                let val: u8 = ::std::mem::transmute(val);
                self._bitfield_1.set(3usize, 1u8, val as u64)
            }
        }
        #[inline]
        pub fn mLoadedAsData(&self) -> bool {
            unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
        }
        #[inline]