
#line 1 "hb-ot-shape-complex-indic-machine.rl"
/*
 * Copyright © 2011,2012  Google, Inc.
 *
 *  This is part of HarfBuzz, a text shaping library.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE COPYRIGHT HOLDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * THE COPYRIGHT HOLDER SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE COPYRIGHT HOLDER HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * Google Author(s): Behdad Esfahbod
 */

#ifndef HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH
#define HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH

#include "hb.hh"


#line 36 "hb-ot-shape-complex-indic-machine.hh"
static const unsigned char _indic_syllable_machine_trans_keys[] = {
	8u, 8u, 4u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 
	5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 4u, 8u, 6u, 6u, 16u, 16u, 
	4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 
	16u, 16u, 4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 
	4u, 8u, 4u, 13u, 8u, 8u, 4u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 
	7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 4u, 8u, 
	6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 
	4u, 8u, 6u, 6u, 16u, 16u, 4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 
	4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 8u, 8u, 4u, 8u, 5u, 7u, 7u, 7u, 
	5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 
	7u, 7u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 
	6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 13u, 4u, 8u, 4u, 13u, 
	4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 8u, 8u, 4u, 8u, 5u, 7u, 
	7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 
	5u, 7u, 7u, 7u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 
	4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 13u, 4u, 8u, 
	4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 4u, 13u, 
	5u, 8u, 8u, 8u, 1u, 19u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 
	3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 
	3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 5u, 10u, 5u, 10u, 
	5u, 10u, 10u, 10u, 10u, 10u, 10u, 10u, 5u, 10u, 3u, 10u, 5u, 10u, 3u, 10u, 
	4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 
	3u, 10u, 4u, 10u, 4u, 10u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 
	3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 
	3u, 17u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 
	1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 
	1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 5u, 10u, 5u, 10u, 5u, 10u, 10u, 10u, 
	10u, 10u, 10u, 10u, 5u, 10u, 3u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 
	3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 
	4u, 10u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 
	1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 
	3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 4u, 8u, 3u, 17u, 3u, 17u, 
	4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 
	4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 
	4u, 17u, 5u, 10u, 5u, 10u, 5u, 10u, 10u, 10u, 10u, 10u, 10u, 10u, 5u, 10u, 
	3u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 
	3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 4u, 10u, 3u, 17u, 3u, 17u, 
	1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 
	3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 
	1u, 16u, 1u, 16u, 4u, 13u, 3u, 17u, 4u, 8u, 3u, 17u, 3u, 17u, 4u, 17u, 
	1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 
	1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 
	5u, 10u, 5u, 10u, 5u, 10u, 10u, 10u, 10u, 10u, 10u, 10u, 5u, 10u, 3u, 10u, 
	5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 
	4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 4u, 10u, 3u, 17u, 3u, 17u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 
	3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 
	1u, 16u, 3u, 17u, 1u, 17u, 3u, 17u, 1u, 17u, 4u, 13u, 5u, 10u, 10u, 10u, 
	10u, 10u, 10u, 10u, 5u, 10u, 1u, 16u, 3u, 10u, 5u, 10u, 5u, 10u, 10u, 10u, 
	10u, 10u, 10u, 10u, 5u, 10u, 1u, 16u, 0
};

static const char _indic_syllable_machine_key_spans[] = {
	1, 5, 3, 1, 4, 3, 1, 4, 
	3, 1, 4, 3, 1, 5, 1, 1, 
	5, 1, 1, 5, 1, 1, 5, 1, 
	1, 10, 5, 10, 5, 10, 5, 10, 
	5, 10, 1, 5, 3, 1, 4, 3, 
	1, 4, 3, 1, 4, 3, 1, 5, 
	1, 1, 5, 1, 1, 5, 1, 1, 
	5, 1, 1, 10, 5, 10, 5, 10, 
	5, 10, 5, 10, 1, 5, 3, 1, 
	4, 3, 1, 4, 3, 1, 4, 3, 
	1, 5, 1, 1, 5, 1, 1, 5, 
	1, 1, 5, 1, 1, 10, 5, 10, 
	5, 10, 5, 10, 5, 1, 5, 3, 
	1, 4, 3, 1, 4, 3, 1, 4, 
	3, 1, 5, 1, 1, 5, 1, 1, 
	5, 1, 1, 5, 1, 1, 10, 5, 
	10, 5, 10, 5, 10, 5, 10, 10, 
	4, 1, 19, 15, 15, 14, 16, 15, 
	15, 14, 16, 15, 15, 14, 16, 15, 
	15, 14, 16, 15, 15, 14, 6, 6, 
	6, 1, 1, 1, 6, 8, 6, 8, 
	7, 6, 8, 7, 6, 8, 7, 6, 
	8, 7, 7, 15, 15, 16, 16, 16, 
	15, 15, 16, 16, 16, 15, 15, 16, 
	16, 16, 15, 15, 16, 16, 16, 15, 
	15, 15, 15, 14, 16, 15, 15, 14, 
	16, 15, 15, 14, 16, 15, 15, 14, 
	16, 15, 15, 14, 6, 6, 6, 1, 
	1, 1, 6, 8, 6, 8, 7, 6, 
	8, 7, 6, 8, 7, 6, 8, 7, 
	7, 15, 15, 16, 16, 16, 15, 15, 
	16, 16, 16, 15, 15, 16, 16, 16, 
	15, 15, 16, 16, 16, 5, 15, 15, 
	14, 16, 15, 15, 14, 16, 15, 15, 
	14, 16, 15, 15, 14, 16, 15, 15, 
	14, 6, 6, 6, 1, 1, 1, 6, 
	8, 6, 8, 7, 6, 8, 7, 6, 
	8, 7, 6, 8, 7, 7, 15, 15, 
	16, 16, 16, 15, 15, 16, 16, 16, 
	15, 15, 16, 16, 16, 15, 15, 16, 
	16, 16, 10, 15, 5, 15, 15, 14, 
	16, 15, 15, 14, 16, 15, 15, 14, 
	16, 15, 15, 14, 16, 15, 15, 14, 
	6, 6, 6, 1, 1, 1, 6, 8, 
	6, 8, 7, 6, 8, 7, 6, 8, 
	7, 6, 8, 7, 7, 15, 15, 16, 
	16, 16, 15, 15, 16, 16, 16, 15, 
	15, 16, 16, 16, 15, 15, 16, 16, 
	16, 15, 17, 15, 17, 10, 6, 1, 
	1, 1, 6, 16, 8, 6, 6, 1, 
	1, 1, 6, 16
};

static const short _indic_syllable_machine_index_offsets[] = {
	0, 2, 8, 12, 14, 19, 23, 25, 
	30, 34, 36, 41, 45, 47, 53, 55, 
	57, 63, 65, 67, 73, 75, 77, 83, 
	85, 87, 98, 104, 115, 121, 132, 138, 
	149, 155, 166, 168, 174, 178, 180, 185, 
	189, 191, 196, 200, 202, 207, 211, 213, 
	219, 221, 223, 229, 231, 233, 239, 241, 
	243, 249, 251, 253, 264, 270, 281, 287, 
	298, 304, 315, 321, 332, 334, 340, 344, 
	346, 351, 355, 357, 362, 366, 368, 373, 
	377, 379, 385, 387, 389, 395, 397, 399, 
	405, 407, 409, 415, 417, 419, 430, 436, 
	447, 453, 464, 470, 481, 487, 489, 495, 
	499, 501, 506, 510, 512, 517, 521, 523, 
	528, 532, 534, 540, 542, 544, 550, 552, 
	554, 560, 562, 564, 570, 572, 574, 585, 
	591, 602, 608, 619, 625, 636, 642, 653, 
	664, 669, 671, 691, 707, 723, 738, 755, 
	771, 787, 802, 819, 835, 851, 866, 883, 
	899, 915, 930, 947, 963, 979, 994, 1001, 
	1008, 1015, 1017, 1019, 1021, 1028, 1037, 1044, 
	1053, 1061, 1068, 1077, 1085, 1092, 1101, 1109, 
	1116, 1125, 1133, 1141, 1157, 1173, 1190, 1207, 
	1224, 1240, 1256, 1273, 1290, 1307, 1323, 1339, 
	1356, 1373, 1390, 1406, 1422, 1439, 1456, 1473, 
	1489, 1505, 1521, 1537, 1552, 1569, 1585, 1601, 
	1616, 1633, 1649, 1665, 1680, 1697, 1713, 1729, 
	1744, 1761, 1777, 1793, 1808, 1815, 1822, 1829, 
	1831, 1833, 1835, 1842, 1851, 1858, 1867, 1875, 
	1882, 1891, 1899, 1906, 1915, 1923, 1930, 1939, 
	1947, 1955, 1971, 1987, 2004, 2021, 2038, 2054, 
	2070, 2087, 2104, 2121, 2137, 2153, 2170, 2187, 
	2204, 2220, 2236, 2253, 2270, 2287, 2293, 2309, 
	2325, 2340, 2357, 2373, 2389, 2404, 2421, 2437, 
	2453, 2468, 2485, 2501, 2517, 2532, 2549, 2565, 
	2581, 2596, 2603, 2610, 2617, 2619, 2621, 2623, 
	2630, 2639, 2646, 2655, 2663, 2670, 2679, 2687, 
	2694, 2703, 2711, 2718, 2727, 2735, 2743, 2759, 
	2775, 2792, 2809, 2826, 2842, 2858, 2875, 2892, 
	2909, 2925, 2941, 2958, 2975, 2992, 3008, 3024, 
	3041, 3058, 3075, 3086, 3102, 3108, 3124, 3140, 
	3155, 3172, 3188, 3204, 3219, 3236, 3252, 3268, 
	3283, 3300, 3316, 3332, 3347, 3364, 3380, 3396, 
	3411, 3418, 3425, 3432, 3434, 3436, 3438, 3445, 
	3454, 3461, 3470, 3478, 3485, 3494, 3502, 3509, 
	3518, 3526, 3533, 3542, 3550, 3558, 3574, 3590, 
	3607, 3624, 3641, 3657, 3673, 3690, 3707, 3724, 
	3740, 3756, 3773, 3790, 3807, 3823, 3839, 3856, 
	3873, 3890, 3906, 3924, 3940, 3958, 3969, 3976, 
	3978, 3980, 3982, 3989, 4006, 4015, 4022, 4029, 
	4031, 4033, 4035, 4042
};

static const short _indic_syllable_machine_indicies[] = {
	1, 0, 2, 3, 3, 4, 1, 0, 
	5, 5, 4, 0, 4, 0, 6, 6, 
	7, 1, 0, 8, 8, 7, 0, 7, 
	0, 9, 9, 10, 1, 0, 11, 11, 
	10, 0, 10, 0, 12, 12, 13, 1, 
	0, 14, 14, 13, 0, 13, 0, 15, 
	0, 0, 0, 1, 0, 16, 0, 17, 
	0, 18, 12, 12, 13, 1, 0, 19, 
	0, 20, 0, 21, 9, 9, 10, 1, 
	0, 22, 0, 23, 0, 24, 6, 6, 
	7, 1, 0, 25, 0, 26, 0, 2, 
	3, 3, 4, 1, 0, 0, 0, 0, 
	27, 0, 28, 3, 3, 4, 1, 0, 
	28, 3, 3, 4, 1, 0, 0, 0, 
	0, 29, 0, 30, 3, 3, 4, 1, 
	0, 30, 3, 3, 4, 1, 0, 0, 
	0, 0, 31, 0, 32, 3, 3, 4, 
	1, 0, 32, 3, 3, 4, 1, 0, 
	0, 0, 0, 33, 0, 34, 3, 3, 
	4, 1, 0, 34, 3, 3, 4, 1, 
	0, 0, 0, 0, 35, 0, 37, 36, 
	38, 39, 39, 40, 37, 36, 41, 41, 
	40, 36, 40, 36, 42, 42, 43, 37, 
	36, 44, 44, 43, 36, 43, 36, 45, 
	45, 46, 37, 36, 47, 47, 46, 36, 
	46, 36, 48, 48, 49, 37, 36, 50, 
	50, 49, 36, 49, 36, 51, 36, 36, 
	36, 37, 36, 52, 36, 53, 36, 54, 
	48, 48, 49, 37, 36, 55, 36, 56, 
	36, 57, 45, 45, 46, 37, 36, 58, 
	36, 59, 36, 60, 42, 42, 43, 37, 
	36, 61, 36, 62, 36, 38, 39, 39, 
	40, 37, 36, 36, 36, 36, 63, 36, 
	64, 39, 39, 40, 37, 36, 64, 39, 
	39, 40, 37, 36, 36, 36, 36, 65, 
	36, 66, 39, 39, 40, 37, 36, 66, 
	39, 39, 40, 37, 36, 36, 36, 36, 
	67, 36, 68, 39, 39, 40, 37, 36, 
	68, 39, 39, 40, 37, 36, 36, 36, 
	36, 69, 36, 70, 39, 39, 40, 37, 
	36, 70, 39, 39, 40, 37, 36, 36, 
	36, 36, 71, 36, 73, 72, 74, 75, 
	75, 76, 73, 72, 78, 78, 76, 77, 
	76, 77, 79, 79, 80, 73, 72, 81, 
	81, 80, 72, 80, 72, 82, 82, 83, 
	73, 72, 84, 84, 83, 72, 83, 72, 
	85, 85, 86, 73, 72, 87, 87, 86, 
	72, 86, 72, 88, 72, 72, 72, 73, 
	72, 89, 72, 90, 72, 91, 85, 85, 
	86, 73, 72, 92, 72, 93, 72, 94, 
	82, 82, 83, 73, 72, 95, 72, 96, 
	72, 97, 79, 79, 80, 73, 72, 98, 
	72, 99, 72, 74, 75, 75, 76, 73, 
	72, 72, 72, 72, 100, 72, 101, 75, 
	75, 76, 73, 72, 101, 75, 75, 76, 
	73, 72, 72, 72, 72, 102, 72, 103, 
	75, 75, 76, 73, 72, 103, 75, 75, 
	76, 73, 72, 72, 72, 72, 104, 72, 
	105, 75, 75, 76, 73, 72, 105, 75, 
	75, 76, 73, 72, 72, 72, 72, 106, 
	72, 107, 75, 75, 76, 73, 72, 109, 
	108, 110, 111, 111, 112, 109, 108, 113, 
	113, 112, 108, 112, 108, 114, 114, 115, 
	109, 108, 116, 116, 115, 108, 115, 108, 
	117, 117, 118, 109, 108, 119, 119, 118, 
	108, 118, 108, 120, 120, 121, 109, 108, 
	122, 122, 121, 108, 121, 108, 123, 108, 
	108, 108, 109, 108, 124, 108, 125, 108, 
	126, 120, 120, 121, 109, 108, 127, 108, 
	128, 108, 129, 117, 117, 118, 109, 108, 
	130, 108, 131, 108, 132, 114, 114, 115, 
	109, 108, 133, 108, 134, 108, 110, 111, 
	111, 112, 109, 108, 108, 108, 108, 135, 
	108, 136, 111, 111, 112, 109, 108, 136, 
	111, 111, 112, 109, 108, 108, 108, 108, 
	137, 108, 138, 111, 111, 112, 109, 108, 
	138, 111, 111, 112, 109, 108, 108, 108, 
	108, 139, 108, 140, 111, 111, 112, 109, 
	108, 140, 111, 111, 112, 109, 108, 108, 
	108, 108, 141, 108, 142, 111, 111, 112, 
	109, 108, 142, 111, 111, 112, 109, 108, 
	108, 108, 108, 143, 108, 107, 75, 75, 
	76, 73, 72, 72, 72, 72, 144, 72, 
	78, 78, 76, 1, 0, 146, 145, 148, 
	149, 150, 151, 152, 153, 76, 73, 147, 
	154, 155, 155, 144, 147, 156, 157, 158, 
	159, 160, 147, 162, 163, 164, 165, 4, 
	1, 161, 166, 161, 161, 35, 161, 161, 
	161, 167, 161, 168, 163, 169, 169, 4, 
	1, 161, 166, 161, 161, 161, 161, 161, 
	161, 167, 161, 163, 169, 169, 4, 1, 
	161, 166, 161, 161, 161, 161, 161, 161, 
	167, 161, 170, 161, 161, 161, 17, 171, 
	161, 1, 161, 166, 161, 161, 161, 161, 
	161, 170, 161, 172, 173, 174, 175, 4, 
	1, 161, 166, 161, 161, 33, 161, 161, 
	161, 167, 161, 176, 173, 177, 177, 4, 
	1, 161, 166, 161, 161, 161, 161, 161, 
	161, 167, 161, 173, 177, 177, 4, 1, 
	161, 166, 161, 161, 161, 161, 161, 161, 
	167, 161, 178, 161, 161, 161, 17, 179, 
	161, 1, 161, 166, 161, 161, 161, 161, 
	161, 178, 161, 180, 181, 182, 183, 4, 
	1, 161, 166, 161, 161, 31, 161, 161, 
	161, 167, 161, 184, 181, 185, 185, 4, 
	1, 161, 166, 161, 161, 161, 161, 161, 
	161, 167, 161, 181, 185, 185, 4, 1, 
	161, 166, 161, 161, 161, 161, 161, 161, 
	167, 161, 186, 161, 161, 161, 17, 187, 
	161, 1, 161, 166, 161, 161, 161, 161, 
	161, 186, 161, 188, 189, 190, 191, 4, 
	1, 161, 166, 161, 161, 29, 161, 161, 
	161, 167, 161, 192, 189, 193, 193, 4, 
	1, 161, 166, 161, 161, 161, 161, 161, 
	161, 167, 161, 189, 193, 193, 4, 1, 
	161, 166, 161, 161, 161, 161, 161, 161, 
	167, 161, 194, 161, 161, 161, 17, 195, 
	161, 1, 161, 166, 161, 161, 161, 161, 
	161, 194, 161, 196, 197, 198, 199, 4, 
	1, 161, 166, 161, 161, 27, 161, 161, 
	161, 167, 161, 200, 197, 201, 201, 4, 
	1, 161, 166, 161, 161, 161, 161, 161, 
	161, 167, 161, 197, 201, 201, 4, 1, 
	161, 166, 161, 161, 161, 161, 161, 161, 
	167, 161, 17, 202, 161, 1, 161, 166, 
	161, 203, 203, 161, 1, 161, 166, 161, 
	204, 161, 161, 205, 161, 166, 161, 166, 
	161, 206, 161, 207, 161, 204, 161, 161, 
	161, 161, 166, 161, 17, 161, 203, 203, 
	161, 1, 161, 166, 161, 203, 202, 161, 
	1, 161, 166, 161, 208, 26, 209, 210, 
	7, 1, 161, 166, 161, 26, 209, 210, 
	7, 1, 161, 166, 161, 209, 209, 7, 
	1, 161, 166, 161, 211, 23, 212, 213, 
	10, 1, 161, 166, 161, 23, 212, 213, 
	10, 1, 161, 166, 161, 212, 212, 10, 
	1, 161, 166, 161, 214, 20, 215, 216, 
	13, 1, 161, 166, 161, 20, 215, 216, 
	13, 1, 161, 166, 161, 215, 215, 13, 
	1, 161, 166, 161, 217, 17, 203, 218, 
	161, 1, 161, 166, 161, 17, 203, 218, 
	161, 1, 161, 166, 161, 197, 201, 201, 
	4, 1, 161, 166, 161, 196, 197, 201, 
	201, 4, 1, 161, 166, 161, 161, 161, 
	161, 161, 161, 167, 161, 196, 197, 198, 
	201, 4, 1, 161, 166, 161, 161, 27, 
	161, 161, 161, 167, 161, 194, 161, 219, 
	161, 203, 203, 161, 1, 161, 166, 161, 
	161, 161, 161, 161, 194, 161, 194, 161, 
	161, 161, 203, 203, 161, 1, 161, 166, 
	161, 161, 161, 161, 161, 194, 161, 194, 
	161, 161, 161, 203, 195, 161, 1, 161, 
	166, 161, 161, 161, 161, 161, 194, 161, 
	188, 189, 193, 193, 4, 1, 161, 166, 
	161, 161, 161, 161, 161, 161, 167, 161, 
	188, 189, 190, 193, 4, 1, 161, 166, 
	161, 161, 29, 161, 161, 161, 167, 161, 
	186, 161, 220, 161, 203, 203, 161, 1, 
	161, 166, 161, 161, 161, 161, 161, 186, 
	161, 186, 161, 161, 161, 203, 203, 161, 
	1, 161, 166, 161, 161, 161, 161, 161, 
	186, 161, 186, 161, 161, 161, 203, 187, 
	161, 1, 161, 166, 161, 161, 161, 161, 
	161, 186, 161, 180, 181, 185, 185, 4, 
	1, 161, 166, 161, 161, 161, 161, 161, 
	161, 167, 161, 180, 181, 182, 185, 4, 
	1, 161, 166, 161, 161, 31, 161, 161, 
	161, 167, 161, 178, 161, 221, 161, 203, 
	203, 161, 1, 161, 166, 161, 161, 161, 
	161, 161, 178, 161, 178, 161, 161, 161, 
	203, 203, 161, 1, 161, 166, 161, 161, 
	161, 161, 161, 178, 161, 178, 161, 161, 
	161, 203, 179, 161, 1, 161, 166, 161, 
	161, 161, 161, 161, 178, 161, 172, 173, 
	177, 177, 4, 1, 161, 166, 161, 161, 
	161, 161, 161, 161, 167, 161, 172, 173, 
	174, 177, 4, 1, 161, 166, 161, 161, 
	33, 161, 161, 161, 167, 161, 170, 161, 
	222, 161, 203, 203, 161, 1, 161, 166, 
	161, 161, 161, 161, 161, 170, 161, 170, 
	161, 161, 161, 203, 203, 161, 1, 161, 
	166, 161, 161, 161, 161, 161, 170, 161, 
	170, 161, 161, 161, 203, 171, 161, 1, 
	161, 166, 161, 161, 161, 161, 161, 170, 
	161, 162, 163, 169, 169, 4, 1, 161, 
	166, 161, 161, 161, 161, 161, 161, 167, 
	161, 162, 163, 164, 169, 4, 1, 161, 
	166, 161, 161, 35, 161, 161, 161, 167, 
	161, 224, 225, 226, 227, 40, 37, 223, 
	228, 223, 223, 71, 223, 223, 223, 229, 
	223, 230, 225, 231, 227, 40, 37, 223, 
	228, 223, 223, 223, 223, 223, 223, 229, 
	223, 225, 231, 227, 40, 37, 223, 228, 
	223, 223, 223, 223, 223, 223, 229, 223, 
	232, 223, 223, 223, 53, 233, 223, 37, 
	223, 228, 223, 223, 223, 223, 223, 232, 
	223, 234, 235, 236, 237, 40, 37, 223, 
	228, 223, 223, 69, 223, 223, 223, 229, 
	223, 238, 235, 239, 239, 40, 37, 223, 
	228, 223, 223, 223, 223, 223, 223, 229, 
	223, 235, 239, 239, 40, 37, 223, 228, 
	223, 223, 223, 223, 223, 223, 229, 223, 
	240, 223, 223, 223, 53, 241, 223, 37, 
	223, 228, 223, 223, 223, 223, 223, 240, 
	223, 242, 243, 244, 245, 40, 37, 223, 
	228, 223, 223, 67, 223, 223, 223, 229, 
	223, 246, 243, 247, 247, 40, 37, 223, 
	228, 223, 223, 223, 223, 223, 223, 229, 
	223, 243, 247, 247, 40, 37, 223, 228, 
	223, 223, 223, 223, 223, 223, 229, 223, 
	248, 223, 223, 223, 53, 249, 223, 37, 
	223, 228, 223, 223, 223, 223, 223, 248, 
	223, 250, 251, 252, 253, 40, 37, 223, 
	228, 223, 223, 65, 223, 223, 223, 229, 
	223, 254, 251, 255, 255, 40, 37, 223, 
	228, 223, 223, 223, 223, 223, 223, 229, 
	223, 251, 255, 255, 40, 37, 223, 228, 
	223, 223, 223, 223, 223, 223, 229, 223, 
	256, 223, 223, 223, 53, 257, 223, 37, 
	223, 228, 223, 223, 223, 223, 223, 256, 
	223, 258, 259, 260, 261, 40, 37, 223, 
	228, 223, 223, 63, 223, 223, 223, 229, 
	223, 262, 259, 263, 263, 40, 37, 223, 
	228, 223, 223, 223, 223, 223, 223, 229, 
	223, 259, 263, 263, 40, 37, 223, 228, 
	223, 223, 223, 223, 223, 223, 229, 223, 
	53, 264, 223, 37, 223, 228, 223, 265, 
	265, 223, 37, 223, 228, 223, 266, 223, 
	223, 267, 223, 228, 223, 228, 223, 268, 
	223, 269, 223, 266, 223, 223, 223, 223, 
	228, 223, 53, 223, 265, 265, 223, 37, 
	223, 228, 223, 265, 264, 223, 37, 223, 
	228, 223, 270, 62, 271, 272, 43, 37, 
	223, 228, 223, 62, 271, 272, 43, 37, 
	223, 228, 223, 271, 271, 43, 37, 223, 
	228, 223, 273, 59, 274, 275, 46, 37, 
	223, 228, 223, 59, 274, 275, 46, 37, 
	223, 228, 223, 274, 274, 46, 37, 223, 
	228, 223, 276, 56, 277, 278, 49, 37, 
	223, 228, 223, 56, 277, 278, 49, 37, 
	223, 228, 223, 277, 277, 49, 37, 223, 
	228, 223, 279, 53, 265, 280, 223, 37, 
	223, 228, 223, 53, 265, 280, 223, 37, 
	223, 228, 223, 259, 263, 263, 40, 37, 
	223, 228, 223, 258, 259, 263, 263, 40, 
	37, 223, 228, 223, 223, 223, 223, 223, 
	223, 229, 223, 258, 259, 260, 263, 40, 
	37, 223, 228, 223, 223, 63, 223, 223, 
	223, 229, 223, 256, 223, 281, 223, 265, 
	265, 223, 37, 223, 228, 223, 223, 223, 
	223, 223, 256, 223, 256, 223, 223, 223, 
	265, 265, 223, 37, 223, 228, 223, 223, 
	223, 223, 223, 256, 223, 256, 223, 223, 
	223, 265, 257, 223, 37, 223, 228, 223, 
	223, 223, 223, 223, 256, 223, 250, 251, 
	255, 255, 40, 37, 223, 228, 223, 223, 
	223, 223, 223, 223, 229, 223, 250, 251, 
	252, 255, 40, 37, 223, 228, 223, 223, 
	65, 223, 223, 223, 229, 223, 248, 223, 
	282, 223, 265, 265, 223, 37, 223, 228, 
	223, 223, 223, 223, 223, 248, 223, 248, 
	223, 223, 223, 265, 265, 223, 37, 223, 
	228, 223, 223, 223, 223, 223, 248, 223, 
	248, 223, 223, 223, 265, 249, 223, 37, 
	223, 228, 223, 223, 223, 223, 223, 248, 
	223, 242, 243, 247, 247, 40, 37, 223, 
	228, 223, 223, 223, 223, 223, 223, 229, 
	223, 242, 243, 244, 247, 40, 37, 223, 
	228, 223, 223, 67, 223, 223, 223, 229, 
	223, 240, 223, 283, 223, 265, 265, 223, 
	37, 223, 228, 223, 223, 223, 223, 223, 
	240, 223, 240, 223, 223, 223, 265, 265, 
	223, 37, 223, 228, 223, 223, 223, 223, 
	223, 240, 223, 240, 223, 223, 223, 265, 
	241, 223, 37, 223, 228, 223, 223, 223, 
	223, 223, 240, 223, 234, 235, 239, 239, 
	40, 37, 223, 228, 223, 223, 223, 223, 
	223, 223, 229, 223, 234, 235, 236, 239, 
	40, 37, 223, 228, 223, 223, 69, 223, 
	223, 223, 229, 223, 232, 223, 284, 223, 
	265, 265, 223, 37, 223, 228, 223, 223, 
	223, 223, 223, 232, 223, 232, 223, 223, 
	223, 265, 265, 223, 37, 223, 228, 223, 
	223, 223, 223, 223, 232, 223, 232, 223, 
	223, 223, 265, 233, 223, 37, 223, 228, 
	223, 223, 223, 223, 223, 232, 223, 70, 
	39, 39, 40, 37, 223, 224, 225, 231, 
	227, 40, 37, 223, 228, 223, 223, 223, 
	223, 223, 223, 229, 223, 286, 151, 287, 
	287, 76, 73, 285, 154, 285, 285, 285, 
	285, 285, 285, 158, 285, 151, 287, 287, 
	76, 73, 285, 154, 285, 285, 285, 285, 
	285, 285, 158, 285, 288, 285, 285, 285, 
	90, 289, 285, 73, 285, 154, 285, 285, 
	285, 285, 285, 288, 285, 290, 291, 292, 
	293, 76, 73, 285, 154, 285, 285, 106, 
	285, 285, 285, 158, 285, 294, 291, 295, 
	295, 76, 73, 285, 154, 285, 285, 285, 
	285, 285, 285, 158, 285, 291, 295, 295, 
	76, 73, 285, 154, 285, 285, 285, 285, 
	285, 285, 158, 285, 296, 285, 285, 285, 
	90, 297, 285, 73, 285, 154, 285, 285, 
	285, 285, 285, 296, 285, 298, 299, 300, 
	301, 76, 73, 285, 154, 285, 285, 104, 
	285, 285, 285, 158, 285, 302, 299, 303, 
	303, 76, 73, 285, 154, 285, 285, 285, 
	285, 285, 285, 158, 285, 299, 303, 303, 
	76, 73, 285, 154, 285, 285, 285, 285, 
	285, 285, 158, 285, 304, 285, 285, 285, 
	90, 305, 285, 73, 285, 154, 285, 285, 
	285, 285, 285, 304, 285, 306, 307, 308, 
	309, 76, 73, 285, 154, 285, 285, 102, 
	285, 285, 285, 158, 285, 310, 307, 311, 
	311, 76, 73, 285, 154, 285, 285, 285, 
	285, 285, 285, 158, 285, 307, 311, 311, 
	76, 73, 285, 154, 285, 285, 285, 285, 
	285, 285, 158, 285, 312, 285, 285, 285, 
	90, 313, 285, 73, 285, 154, 285, 285, 
	285, 285, 285, 312, 285, 314, 315, 316, 
	317, 76, 73, 285, 154, 285, 285, 100, 
	285, 285, 285, 158, 285, 318, 315, 319, 
	319, 76, 73, 285, 154, 285, 285, 285, 
	285, 285, 285, 158, 285, 315, 319, 319, 
	76, 73, 285, 154, 285, 285, 285, 285, 
	285, 285, 158, 285, 90, 320, 285, 73, 
	285, 154, 285, 321, 321, 285, 73, 285, 
	154, 285, 322, 285, 285, 323, 285, 154, 
	285, 154, 285, 324, 285, 325, 285, 322, 
	285, 285, 285, 285, 154, 285, 90, 285, 
	321, 321, 285, 73, 285, 154, 285, 321, 
	320, 285, 73, 285, 154, 285, 326, 99, 
	327, 328, 80, 73, 285, 154, 285, 99, 
	327, 328, 80, 73, 285, 154, 285, 327, 
	327, 80, 73, 285, 154, 285, 329, 96, 
	330, 331, 83, 73, 285, 154, 285, 96, 
	330, 331, 83, 73, 285, 154, 285, 330, 
	330, 83, 73, 285, 154, 285, 332, 93, 
	333, 334, 86, 73, 285, 154, 285, 93, 
	333, 334, 86, 73, 285, 154, 285, 333, 
	333, 86, 73, 285, 154, 285, 335, 90, 
	321, 336, 285, 73, 285, 154, 285, 90, 
	321, 336, 285, 73, 285, 154, 285, 315, 
	319, 319, 76, 73, 285, 154, 285, 314, 
	315, 319, 319, 76, 73, 285, 154, 285, 
	285, 285, 285, 285, 285, 158, 285, 314, 
	315, 316, 319, 76, 73, 285, 154, 285, 
	285, 100, 285, 285, 285, 158, 285, 312, 
	285, 337, 285, 321, 321, 285, 73, 285, 
	154, 285, 285, 285, 285, 285, 312, 285, 
	312, 285, 285, 285, 321, 321, 285, 73, 
	285, 154, 285, 285, 285, 285, 285, 312, 
	285, 312, 285, 285, 285, 321, 313, 285, 
	73, 285, 154, 285, 285, 285, 285, 285, 
	312, 285, 306, 307, 311, 311, 76, 73, 
	285, 154, 285, 285, 285, 285, 285, 285, 
	158, 285, 306, 307, 308, 311, 76, 73, 
	285, 154, 285, 285, 102, 285, 285, 285, 
	158, 285, 304, 285, 338, 285, 321, 321, 
	285, 73, 285, 154, 285, 285, 285, 285, 
	285, 304, 285, 304, 285, 285, 285, 321, 
	321, 285, 73, 285, 154, 285, 285, 285, 
	285, 285, 304, 285, 304, 285, 285, 285, 
	321, 305, 285, 73, 285, 154, 285, 285, 
	285, 285, 285, 304, 285, 298, 299, 303, 
	303, 76, 73, 285, 154, 285, 285, 285, 
	285, 285, 285, 158, 285, 298, 299, 300, 
	303, 76, 73, 285, 154, 285, 285, 104, 
	285, 285, 285, 158, 285, 296, 285, 339, 
	285, 321, 321, 285, 73, 285, 154, 285, 
	285, 285, 285, 285, 296, 285, 296, 285, 
	285, 285, 321, 321, 285, 73, 285, 154, 
	285, 285, 285, 285, 285, 296, 285, 296, 
	285, 285, 285, 321, 297, 285, 73, 285, 
	154, 285, 285, 285, 285, 285, 296, 285, 
	290, 291, 295, 295, 76, 73, 285, 154, 
	285, 285, 285, 285, 285, 285, 158, 285, 
	290, 291, 292, 295, 76, 73, 285, 154, 
	285, 285, 106, 285, 285, 285, 158, 285, 
	288, 285, 340, 285, 321, 321, 285, 73, 
	285, 154, 285, 285, 285, 285, 285, 288, 
	285, 288, 285, 285, 285, 321, 321, 285, 
	73, 285, 154, 285, 285, 285, 285, 285, 
	288, 285, 288, 285, 285, 285, 321, 289, 
	285, 73, 285, 154, 285, 285, 285, 285, 
	285, 288, 285, 107, 75, 75, 76, 73, 
	341, 341, 341, 341, 144, 341, 150, 151, 
	287, 287, 76, 73, 285, 154, 285, 285, 
	285, 285, 285, 285, 158, 285, 107, 75, 
	75, 76, 73, 341, 343, 344, 345, 346, 
	112, 109, 342, 347, 342, 342, 143, 342, 
	342, 342, 348, 342, 349, 344, 346, 346, 
	112, 109, 342, 347, 342, 342, 342, 342, 
	342, 342, 348, 342, 344, 346, 346, 112, 
	109, 342, 347, 342, 342, 342, 342, 342, 
	342, 348, 342, 350, 342, 342, 342, 125, 
	351, 342, 109, 342, 347, 342, 342, 342, 
	342, 342, 350, 342, 352, 353, 354, 355, 
	112, 109, 342, 347, 342, 342, 141, 342, 
	342, 342, 348, 342, 356, 353, 357, 357, 
	112, 109, 342, 347, 342, 342, 342, 342, 
	342, 342, 348, 342, 353, 357, 357, 112, 
	109, 342, 347, 342, 342, 342, 342, 342, 
	342, 348, 342, 358, 342, 342, 342, 125, 
	359, 342, 109, 342, 347, 342, 342, 342, 
	342, 342, 358, 342, 360, 361, 362, 363, 
	112, 109, 342, 347, 342, 342, 139, 342, 
	342, 342, 348, 342, 364, 361, 365, 365, 
	112, 109, 342, 347, 342, 342, 342, 342, 
	342, 342, 348, 342, 361, 365, 365, 112, 
	109, 342, 347, 342, 342, 342, 342, 342, 
	342, 348, 342, 366, 342, 342, 342, 125, 
	367, 342, 109, 342, 347, 342, 342, 342, 
	342, 342, 366, 342, 368, 369, 370, 371, 
	112, 109, 342, 347, 342, 342, 137, 342, 
	342, 342, 348, 342, 372, 369, 373, 373, 
	112, 109, 342, 347, 342, 342, 342, 342, 
	342, 342, 348, 342, 369, 373, 373, 112, 
	109, 342, 347, 342, 342, 342, 342, 342, 
	342, 348, 342, 374, 342, 342, 342, 125, 
	375, 342, 109, 342, 347, 342, 342, 342, 
	342, 342, 374, 342, 376, 377, 378, 379, 
	112, 109, 342, 347, 342, 342, 135, 342, 
	342, 342, 348, 342, 380, 377, 381, 381, 
	112, 109, 342, 347, 342, 342, 342, 342, 
	342, 342, 348, 342, 377, 381, 381, 112, 
	109, 342, 347, 342, 342, 342, 342, 342, 
	342, 348, 342, 125, 382, 342, 109, 342, 
	347, 342, 383, 383, 342, 109, 342, 347, 
	342, 384, 342, 342, 385, 342, 347, 342, 
	347, 342, 386, 342, 387, 342, 384, 342, 
	342, 342, 342, 347, 342, 125, 342, 383, 
	383, 342, 109, 342, 347, 342, 383, 382, 
	342, 109, 342, 347, 342, 388, 134, 389, 
	390, 115, 109, 342, 347, 342, 134, 389, 
	390, 115, 109, 342, 347, 342, 389, 389, 
	115, 109, 342, 347, 342, 391, 131, 392, 
	393, 118, 109, 342, 347, 342, 131, 392, 
	393, 118, 109, 342, 347, 342, 392, 392, 
	118, 109, 342, 347, 342, 394, 128, 395, 
	396, 121, 109, 342, 347, 342, 128, 395, 
	396, 121, 109, 342, 347, 342, 395, 395, 
	121, 109, 342, 347, 342, 397, 125, 383, 
	398, 342, 109, 342, 347, 342, 125, 383, 
	398, 342, 109, 342, 347, 342, 377, 381, 
	381, 112, 109, 342, 347, 342, 376, 377, 
	381, 381, 112, 109, 342, 347, 342, 342, 
	342, 342, 342, 342, 348, 342, 376, 377, 
	378, 381, 112, 109, 342, 347, 342, 342, 
	135, 342, 342, 342, 348, 342, 374, 342, 
	399, 342, 383, 383, 342, 109, 342, 347, 
	342, 342, 342, 342, 342, 374, 342, 374, 
	342, 342, 342, 383, 383, 342, 109, 342, 
	347, 342, 342, 342, 342, 342, 374, 342, 
	374, 342, 342, 342, 383, 375, 342, 109, 
	342, 347, 342, 342, 342, 342, 342, 374, 
	342, 368, 369, 373, 373, 112, 109, 342, 
	347, 342, 342, 342, 342, 342, 342, 348, 
	342, 368, 369, 370, 373, 112, 109, 342, 
	347, 342, 342, 137, 342, 342, 342, 348, 
	342, 366, 342, 400, 342, 383, 383, 342, 
	109, 342, 347, 342, 342, 342, 342, 342, 
	366, 342, 366, 342, 342, 342, 383, 383, 
	342, 109, 342, 347, 342, 342, 342, 342, 
	342, 366, 342, 366, 342, 342, 342, 383, 
	367, 342, 109, 342, 347, 342, 342, 342, 
	342, 342, 366, 342, 360, 361, 365, 365, 
	112, 109, 342, 347, 342, 342, 342, 342, 
	342, 342, 348, 342, 360, 361, 362, 365, 
	112, 109, 342, 347, 342, 342, 139, 342, 
	342, 342, 348, 342, 358, 342, 401, 342, 
	383, 383, 342, 109, 342, 347, 342, 342, 
	342, 342, 342, 358, 342, 358, 342, 342, 
	342, 383, 383, 342, 109, 342, 347, 342, 
	342, 342, 342, 342, 358, 342, 358, 342, 
	342, 342, 383, 359, 342, 109, 342, 347, 
	342, 342, 342, 342, 342, 358, 342, 352, 
	353, 357, 357, 112, 109, 342, 347, 342, 
	342, 342, 342, 342, 342, 348, 342, 352, 
	353, 354, 357, 112, 109, 342, 347, 342, 
	342, 141, 342, 342, 342, 348, 342, 350, 
	342, 402, 342, 383, 383, 342, 109, 342, 
	347, 342, 342, 342, 342, 342, 350, 342, 
	350, 342, 342, 342, 383, 383, 342, 109, 
	342, 347, 342, 342, 342, 342, 342, 350, 
	342, 350, 342, 342, 342, 383, 351, 342, 
	109, 342, 347, 342, 342, 342, 342, 342, 
	350, 342, 343, 344, 346, 346, 112, 109, 
	342, 347, 342, 342, 342, 342, 342, 342, 
	348, 342, 148, 149, 150, 151, 403, 287, 
	76, 73, 285, 154, 155, 155, 144, 285, 
	285, 148, 158, 285, 162, 404, 164, 165, 
	4, 1, 161, 166, 161, 161, 35, 161, 
	161, 161, 167, 161, 170, 149, 150, 151, 
	405, 406, 76, 407, 161, 408, 161, 155, 
	144, 161, 161, 170, 158, 161, 107, 409, 
	409, 76, 407, 161, 166, 161, 161, 144, 
	161, 410, 161, 161, 411, 161, 408, 161, 
	408, 161, 412, 161, 207, 161, 410, 161, 
	161, 161, 161, 408, 161, 170, 161, 222, 
	107, 409, 409, 76, 407, 161, 166, 161, 
	161, 161, 161, 161, 170, 161, 414, 413, 
	415, 415, 413, 146, 413, 416, 413, 415, 
	415, 413, 146, 413, 416, 413, 417, 413, 
	413, 418, 413, 416, 413, 416, 413, 419, 
	413, 420, 413, 417, 413, 413, 413, 413, 
	416, 413, 148, 341, 341, 341, 341, 341, 
	341, 341, 341, 341, 155, 341, 341, 341, 
	341, 148, 341, 0
};

static const short _indic_syllable_machine_trans_targs[] = {
	138, 160, 166, 2, 167, 3, 5, 170, 
	6, 8, 173, 9, 11, 176, 12, 14, 
	15, 159, 17, 18, 175, 20, 21, 172, 
	23, 24, 169, 179, 183, 184, 188, 189, 
	193, 194, 198, 199, 138, 222, 228, 36, 
	229, 37, 39, 232, 40, 42, 235, 43, 
	45, 238, 46, 48, 49, 221, 51, 52, 
	237, 54, 55, 234, 57, 58, 231, 241, 
	245, 246, 250, 251, 255, 256, 260, 262, 
	138, 283, 289, 70, 290, 138, 71, 73, 
	293, 74, 76, 296, 77, 79, 299, 80, 
	82, 83, 282, 85, 86, 298, 88, 89, 
	295, 91, 92, 292, 302, 306, 307, 311, 
	312, 316, 317, 321, 138, 346, 352, 103, 
	353, 104, 106, 356, 107, 109, 359, 110, 
	112, 362, 113, 115, 116, 345, 118, 119, 
	361, 121, 122, 358, 124, 125, 355, 365, 
	369, 370, 374, 375, 379, 380, 384, 385, 
	323, 138, 398, 138, 139, 201, 263, 265, 
	322, 324, 285, 325, 386, 387, 301, 396, 
	403, 138, 140, 142, 33, 200, 162, 178, 
	141, 32, 143, 196, 144, 146, 31, 195, 
	145, 30, 147, 191, 148, 150, 29, 190, 
	149, 28, 151, 186, 152, 154, 27, 185, 
	153, 26, 155, 181, 156, 158, 25, 180, 
	157, 1, 165, 0, 161, 164, 163, 138, 
	168, 4, 22, 171, 7, 19, 174, 10, 
	16, 177, 13, 182, 187, 192, 197, 138, 
	202, 204, 67, 261, 224, 240, 203, 66, 
	205, 258, 206, 208, 65, 257, 207, 64, 
	209, 253, 210, 212, 63, 252, 211, 62, 
	213, 248, 214, 216, 61, 247, 215, 60, 
	217, 243, 218, 220, 59, 242, 219, 35, 
	227, 34, 223, 226, 225, 138, 230, 38, 
	56, 233, 41, 53, 236, 44, 50, 239, 
	47, 244, 249, 254, 259, 138, 264, 100, 
	266, 319, 267, 269, 99, 318, 268, 98, 
	270, 314, 271, 273, 97, 313, 272, 96, 
	274, 309, 275, 277, 95, 308, 276, 94, 
	278, 304, 279, 281, 93, 303, 280, 69, 
	288, 68, 284, 287, 286, 138, 291, 72, 
	90, 294, 75, 87, 297, 78, 84, 300, 
	81, 305, 310, 315, 320, 138, 138, 326, 
	328, 134, 133, 348, 364, 327, 329, 382, 
	330, 332, 132, 381, 331, 131, 333, 377, 
	334, 336, 130, 376, 335, 129, 337, 372, 
	338, 340, 128, 371, 339, 127, 341, 367, 
	342, 344, 126, 366, 343, 102, 351, 101, 
	347, 350, 349, 138, 354, 105, 123, 357, 
	108, 120, 360, 111, 117, 363, 114, 368, 
	373, 378, 383, 135, 388, 389, 395, 390, 
	392, 136, 391, 394, 393, 138, 397, 137, 
	400, 399, 402, 401, 138
};

static const char _indic_syllable_machine_trans_actions[] = {
	1, 0, 2, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	0, 2, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 0, 2, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 0, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	4, 0, 2, 0, 2, 5, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 6, 2, 6, 2, 
	6, 2, 6, 2, 7, 0, 2, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 0, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	6, 8, 0, 11, 2, 2, 6, 0, 
	12, 12, 0, 2, 6, 2, 6, 2, 
	0, 13, 2, 0, 0, 2, 0, 2, 
	2, 0, 2, 2, 2, 0, 0, 2, 
	2, 0, 2, 2, 2, 0, 0, 2, 
	2, 0, 2, 2, 2, 0, 0, 2, 
	2, 0, 2, 2, 2, 0, 0, 2, 
	2, 0, 2, 0, 0, 0, 0, 14, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 0, 2, 2, 2, 2, 15, 
	2, 0, 0, 2, 0, 2, 2, 0, 
	2, 2, 2, 0, 0, 2, 2, 0, 
	2, 2, 2, 0, 0, 2, 2, 0, 
	2, 2, 2, 0, 0, 2, 2, 0, 
	2, 2, 2, 0, 0, 2, 2, 0, 
	2, 0, 0, 0, 0, 16, 2, 0, 
	0, 2, 0, 0, 2, 0, 0, 2, 
	0, 2, 2, 2, 2, 17, 6, 0, 
	6, 2, 6, 0, 0, 6, 6, 0, 
	6, 2, 6, 0, 0, 6, 6, 0, 
	6, 2, 6, 0, 0, 6, 6, 0, 
	6, 2, 6, 0, 0, 6, 6, 0, 
	2, 0, 0, 0, 0, 18, 2, 0, 
	0, 2, 0, 0, 2, 0, 0, 2, 
	0, 2, 2, 2, 2, 19, 20, 2, 
	0, 0, 0, 0, 2, 2, 2, 2, 
	2, 0, 0, 2, 2, 0, 2, 2, 
	2, 0, 0, 2, 2, 0, 2, 2, 
	2, 0, 0, 2, 2, 0, 2, 2, 
	2, 0, 0, 2, 2, 0, 2, 0, 
	0, 0, 0, 21, 2, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 2, 
	2, 2, 2, 0, 0, 22, 22, 0, 
	0, 0, 0, 0, 0, 23, 2, 0, 
	0, 0, 0, 0, 24
};

static const char _indic_syllable_machine_to_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 9, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0
};

static const char _indic_syllable_machine_from_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 10, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0
};

static const short _indic_syllable_machine_eof_trans[] = {
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 73, 73, 78, 78, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	73, 73, 73, 73, 73, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 73, 
	1, 146, 0, 162, 162, 162, 162, 162, 
	162, 162, 162, 162, 162, 162, 162, 162, 
	162, 162, 162, 162, 162, 162, 162, 162, 
	162, 162, 162, 162, 162, 162, 162, 162, 
	162, 162, 162, 162, 162, 162, 162, 162, 
	162, 162, 162, 162, 162, 162, 162, 162, 
	162, 162, 162, 162, 162, 162, 162, 162, 
	162, 162, 162, 162, 162, 162, 162, 162, 
	162, 224, 224, 224, 224, 224, 224, 224, 
	224, 224, 224, 224, 224, 224, 224, 224, 
	224, 224, 224, 224, 224, 224, 224, 224, 
	224, 224, 224, 224, 224, 224, 224, 224, 
	224, 224, 224, 224, 224, 224, 224, 224, 
	224, 224, 224, 224, 224, 224, 224, 224, 
	224, 224, 224, 224, 224, 224, 224, 224, 
	224, 224, 224, 224, 224, 224, 224, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 342, 286, 342, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 286, 162, 162, 162, 162, 162, 
	162, 162, 162, 162, 414, 414, 414, 414, 
	414, 414, 414, 342
};

static const int indic_syllable_machine_start = 138;
static const int indic_syllable_machine_first_final = 138;
static const int indic_syllable_machine_error = -1;

static const int indic_syllable_machine_en_main = 138;


#line 36 "hb-ot-shape-complex-indic-machine.rl"



#line 93 "hb-ot-shape-complex-indic-machine.rl"


#define found_syllable(syllable_type) \
  HB_STMT_START { \
    if (0) fprintf (stderr, "syllable %d..%d %s\n", ts, te, #syllable_type); \
    for (unsigned int i = ts; i < te; i++) \
      info[i].syllable() = (syllable_serial << 4) | syllable_type; \
    syllable_serial++; \
    if (unlikely (syllable_serial == 16)) syllable_serial = 1; \
  } HB_STMT_END

static void
find_syllables (hb_buffer_t *buffer)
{
  unsigned int p, pe, eof, ts, te, act;
  int cs;
  hb_glyph_info_t *info = buffer->info;
  
#line 1014 "hb-ot-shape-complex-indic-machine.hh"
	{
	cs = indic_syllable_machine_start;
	ts = 0;
	te = 0;
	act = 0;
	}

#line 113 "hb-ot-shape-complex-indic-machine.rl"


  p = 0;
  pe = eof = buffer->len;

  unsigned int syllable_serial = 1;
  
#line 1030 "hb-ot-shape-complex-indic-machine.hh"
	{
	int _slen;
	int _trans;
	const unsigned char *_keys;
	const short *_inds;
	if ( p == pe )
		goto _test_eof;
_resume:
	switch ( _indic_syllable_machine_from_state_actions[cs] ) {
	case 10:
#line 1 "NONE"
	{ts = p;}
	break;
#line 1044 "hb-ot-shape-complex-indic-machine.hh"
	}

	_keys = _indic_syllable_machine_trans_keys + (cs<<1);
	_inds = _indic_syllable_machine_indicies + _indic_syllable_machine_index_offsets[cs];

	_slen = _indic_syllable_machine_key_spans[cs];
	_trans = _inds[ _slen > 0 && _keys[0] <=( info[p].indic_category()) &&
		( info[p].indic_category()) <= _keys[1] ?
		( info[p].indic_category()) - _keys[0] : _slen ];

_eof_trans:
	cs = _indic_syllable_machine_trans_targs[_trans];

	if ( _indic_syllable_machine_trans_actions[_trans] == 0 )
		goto _again;

	switch ( _indic_syllable_machine_trans_actions[_trans] ) {
	case 2:
#line 1 "NONE"
	{te = p+1;}
	break;
	case 14:
#line 84 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (consonant_syllable); }}
	break;
	case 16:
#line 85 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (vowel_syllable); }}
	break;
	case 21:
#line 86 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (standalone_cluster); }}
	break;
	case 24:
#line 87 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (symbol_cluster); }}
	break;
	case 18:
#line 88 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (broken_cluster); }}
	break;
	case 11:
#line 89 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (non_indic_cluster); }}
	break;
	case 13:
#line 84 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (consonant_syllable); }}
	break;
	case 15:
#line 85 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (vowel_syllable); }}
	break;
	case 20:
#line 86 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (standalone_cluster); }}
	break;
	case 23:
#line 87 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (symbol_cluster); }}
	break;
	case 17:
#line 88 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (broken_cluster); }}
	break;
	case 19:
#line 89 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (non_indic_cluster); }}
	break;
	case 1:
#line 84 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (consonant_syllable); }}
	break;
	case 3:
#line 85 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (vowel_syllable); }}
	break;
	case 7:
#line 86 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (standalone_cluster); }}
	break;
	case 8:
#line 87 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (symbol_cluster); }}
	break;
	case 4:
#line 88 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (broken_cluster); }}
	break;
	case 5:
#line 1 "NONE"
	{	switch( act ) {
	case 1:
	{{p = ((te))-1;} found_syllable (consonant_syllable); }
	break;
	case 5:
	{{p = ((te))-1;} found_syllable (broken_cluster); }
	break;
	case 6:
	{{p = ((te))-1;} found_syllable (non_indic_cluster); }
	break;
	}
	}
	break;
	case 22:
#line 1 "NONE"
	{te = p+1;}
#line 84 "hb-ot-shape-complex-indic-machine.rl"
	{act = 1;}
	break;
	case 6:
#line 1 "NONE"
	{te = p+1;}
#line 88 "hb-ot-shape-complex-indic-machine.rl"
	{act = 5;}
	break;
	case 12:
#line 1 "NONE"
	{te = p+1;}
#line 89 "hb-ot-shape-complex-indic-machine.rl"
	{act = 6;}
	break;
#line 1167 "hb-ot-shape-complex-indic-machine.hh"
	}

_again:
	switch ( _indic_syllable_machine_to_state_actions[cs] ) {
	case 9:
#line 1 "NONE"
	{ts = 0;}
	break;
#line 1176 "hb-ot-shape-complex-indic-machine.hh"
	}

	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	if ( _indic_syllable_machine_eof_trans[cs] > 0 ) {
		_trans = _indic_syllable_machine_eof_trans[cs] - 1;
		goto _eof_trans;
	}
	}

	}

#line 121 "hb-ot-shape-complex-indic-machine.rl"

}

#endif /* HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH */
