/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class AuthPanel
extends Panel
implements ActionListener {
    String passwordParam;
    Label titleLabel;
    Label retryLabel;
    Label promptLabel;
    TextField passwordField;
    Button okButton;

    public AuthPanel(VncViewer vncViewer) {
        this.readParameters(vncViewer);
        if (!this.isInteractionNecessary()) {
            return;
        }
        this.titleLabel = new Label("VNC Authentication", 1);
        this.titleLabel.setFont(new Font("Helvetica", 1, 18));
        this.promptLabel = new Label("Password:", 1);
        this.passwordField = new TextField(10);
        this.passwordField.setForeground(Color.black);
        ((Component)this.passwordField).setBackground(Color.white);
        this.passwordField.setEchoChar('*');
        this.okButton = new Button("OK");
        this.retryLabel = new Label("", 1);
        this.retryLabel.setFont(new Font("Courier", 1, 16));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.titleLabel, gridBagConstraints);
        this.add(this.titleLabel);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.retryLabel, gridBagConstraints);
        this.add(this.retryLabel);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.promptLabel, gridBagConstraints);
        this.add(this.promptLabel);
        gridBagLayout.setConstraints(this.passwordField, gridBagConstraints);
        this.add(this.passwordField);
        this.passwordField.addActionListener(this);
        gridBagConstraints.ipady = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        gridBagConstraints.ipadx = 40;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.add(this.okButton);
        this.okButton.addActionListener(this);
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.passwordField || actionEvent.getSource() == this.okButton) {
            this.passwordField.setEnabled(false);
            this.notify();
        }
    }

    public boolean isInteractionNecessary() {
        return this.passwordParam == null;
    }

    public void moveFocusToDefaultField() {
        this.passwordField.requestFocus();
    }

    private void readParameters(VncViewer vncViewer) {
        String string = vncViewer.readParameter("ENCPASSWORD", false);
        if (string == null) {
            this.passwordParam = vncViewer.readParameter("PASSWORD", false);
        } else {
            Object object;
            Object object2;
            byte[] byArray = new byte[8];
            int n = string.length() / 2;
            if (n > 8) {
                n = 8;
            }
            int n2 = 0;
            while (n2 < n) {
                object2 = string.substring(n2 * 2, n2 * 2 + 2);
                object = new Integer(Integer.parseInt((String)object2, 16));
                byArray[n2] = ((Integer)object).byteValue();
                ++n2;
            }
            object2 = new byte[]{23, 82, 107, 6, 35, 78, 88, 7};
            object = new DesCipher((byte[])object2);
            ((DesCipher)object).decrypt(byArray, 0, byArray, 0);
            this.passwordParam = new String(byArray);
        }
    }

    public void retry() {
        this.retryLabel.setText("Sorry. Try again.");
        this.passwordField.setEnabled(true);
        this.passwordField.setText("");
        this.moveFocusToDefaultField();
    }

    public synchronized boolean tryAuthenticate(RfbProto rfbProto) throws Exception {
        int n;
        String string = this.passwordParam;
        if (string == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
            string = this.passwordField.getText();
        }
        byte[] byArray = new byte[16];
        rfbProto.readFully(byArray);
        if (string.length() > 8) {
            string = string.substring(0, 8);
        }
        if ((n = string.indexOf(0)) != -1) {
            string = string.substring(0, n);
        }
        byte[] byArray2 = new byte[8];
        System.arraycopy(string.getBytes(), 0, byArray2, 0, string.length());
        DesCipher desCipher = new DesCipher(byArray2);
        desCipher.encrypt(byArray, 0, byArray, 0);
        desCipher.encrypt(byArray, 8, byArray, 8);
        rfbProto.os.write(byArray);
        int n2 = rfbProto.is.readInt();
        switch (n2) {
            case 0: {
                System.out.println("VNC authentication succeeded");
                return true;
            }
            case 1: {
                System.out.println("VNC authentication failed");
                break;
            }
            case 2: {
                throw new Exception("VNC authentication failed - too many tries");
            }
            default: {
                throw new Exception("Unknown VNC authentication result " + n2);
            }
        }
        return false;
    }
}

