/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.zip.Inflater;

class VncCanvas
extends Canvas
implements KeyListener,
MouseListener,
MouseMotionListener {
    VncViewer viewer;
    RfbProto rfb;
    ColorModel cm8;
    ColorModel cm24;
    Color[] colors;
    int bytesPixel;
    Image memImage;
    Graphics memGraphics;
    Image rawPixelsImage;
    MemoryImageSource pixelsSource;
    byte[] pixels8;
    int[] pixels24;
    byte[] zlibBuf;
    int zlibBufLen = 0;
    Inflater zlibInflater;
    static final int tightZlibBufferSize = 512;
    Inflater[] tightInflaters;
    Rectangle jpegRect;
    boolean inputEnabled;
    private Color hextile_bg;
    private Color hextile_fg;
    boolean showSoftCursor = false;
    MemoryImageSource softCursorSource;
    Image softCursor;
    int cursorX = 0;
    int cursorY = 0;
    int cursorWidth;
    int cursorHeight;
    int origCursorWidth;
    int origCursorHeight;
    int hotX;
    int hotY;
    int origHotX;
    int origHotY;

    VncCanvas(VncViewer vncViewer) throws IOException {
        this.viewer = vncViewer;
        this.rfb = this.viewer.rfb;
        this.tightInflaters = new Inflater[4];
        this.cm8 = new DirectColorModel(8, 7, 56, 192);
        this.cm24 = new DirectColorModel(24, 0xFF0000, 65280, 255);
        this.colors = new Color[256];
        int n = 0;
        while (n < 256) {
            this.colors[n] = new Color(this.cm8.getRGB(n));
            ++n;
        }
        this.setPixelFormat();
        this.inputEnabled = false;
        if (!this.viewer.options.viewOnly) {
            this.enableInput(true);
        }
        this.addKeyListener(this);
    }

    synchronized void createSoftCursor() {
        if (this.softCursorSource == null) {
            return;
        }
        int n = this.viewer.options.scaleCursor;
        if (n == 0 || !this.inputEnabled) {
            n = 100;
        }
        int n2 = this.cursorX - this.hotX;
        int n3 = this.cursorY - this.hotY;
        int n4 = this.cursorWidth;
        int n5 = this.cursorHeight;
        this.cursorWidth = (this.origCursorWidth * n + 50) / 100;
        this.cursorHeight = (this.origCursorHeight * n + 50) / 100;
        this.hotX = (this.origHotX * n + 50) / 100;
        this.hotY = (this.origHotY * n + 50) / 100;
        this.softCursor = Toolkit.getDefaultToolkit().createImage(this.softCursorSource);
        if (n != 100) {
            this.softCursor = this.softCursor.getScaledInstance(this.cursorWidth, this.cursorHeight, 4);
        }
        if (this.showSoftCursor) {
            n2 = Math.min(n2, this.cursorX - this.hotX);
            n3 = Math.min(n3, this.cursorY - this.hotY);
            n4 = Math.max(n4, this.cursorWidth);
            n5 = Math.max(n5, this.cursorHeight);
            this.repaint(this.viewer.deferCursorUpdates, n2, n3, n4, n5);
        }
    }

    synchronized MemoryImageSource decodeCursorShape(int n, int n2, int n3) throws IOException {
        int n4 = (n2 + 7) / 8;
        int n5 = n4 * n3;
        int[] nArray = new int[n2 * n3];
        if (n == -240) {
            byte[] byArray = new byte[6];
            this.rfb.readFully(byArray);
            int[] nArray2 = new int[]{0xFF000000 | (byArray[3] & 0xFF) << 16 | (byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF, 0xFF000000 | (byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF};
            byte[] byArray2 = new byte[n5];
            this.rfb.readFully(byArray2);
            byte[] byArray3 = new byte[n5];
            this.rfb.readFully(byArray3);
            int n6 = 0;
            int n7 = 0;
            while (n7 < n3) {
                int n8;
                int n9;
                int n10 = 0;
                while (n10 < n2 / 8) {
                    byte by = byArray2[n7 * n4 + n10];
                    byte by2 = byArray3[n7 * n4 + n10];
                    n9 = 7;
                    while (n9 >= 0) {
                        n8 = (by2 >> n9 & 1) != 0 ? nArray2[by >> n9 & 1] : 0;
                        nArray[n6++] = n8;
                        --n9;
                    }
                    ++n10;
                }
                n9 = 7;
                while (n9 >= 8 - n2 % 8) {
                    n8 = (byArray3[n7 * n4 + n10] >> n9 & 1) != 0 ? nArray2[byArray2[n7 * n4 + n10] >> n9 & 1] : 0;
                    nArray[n6++] = n8;
                    --n9;
                }
                ++n7;
            }
        } else {
            byte[] byArray = new byte[n2 * n3 * this.bytesPixel];
            this.rfb.readFully(byArray);
            byte[] byArray4 = new byte[n5];
            this.rfb.readFully(byArray4);
            int n11 = 0;
            int n12 = 0;
            while (n12 < n3) {
                int n13;
                int n14;
                int n15 = 0;
                while (n15 < n2 / 8) {
                    byte by = byArray4[n12 * n4 + n15];
                    n14 = 7;
                    while (n14 >= 0) {
                        n13 = (by >> n14 & 1) != 0 ? (this.bytesPixel == 1 ? this.cm8.getRGB(byArray[n11]) : 0xFF000000 | (byArray[n11 * 4 + 1] & 0xFF) << 16 | (byArray[n11 * 4 + 2] & 0xFF) << 8 | byArray[n11 * 4 + 3] & 0xFF) : 0;
                        nArray[n11++] = n13;
                        --n14;
                    }
                    ++n15;
                }
                n14 = 7;
                while (n14 >= 8 - n2 % 8) {
                    n13 = (byArray4[n12 * n4 + n15] >> n14 & 1) != 0 ? (this.bytesPixel == 1 ? this.cm8.getRGB(byArray[n11]) : 0xFF000000 | (byArray[n11 * 4 + 1] & 0xFF) << 16 | (byArray[n11 * 4 + 2] & 0xFF) << 8 | byArray[n11 * 4 + 3] & 0xFF) : 0;
                    nArray[n11++] = n13;
                    --n14;
                }
                ++n12;
            }
        }
        return new MemoryImageSource(n2, n3, nArray, 0, n2);
    }

    void decodeGradientData(int n, int n2, int n3, int n4, byte[] byArray) {
        byte[] byArray2 = new byte[n3 * 3];
        byte[] byArray3 = new byte[n3 * 3];
        byte[] byArray4 = new byte[3];
        int[] nArray = new int[3];
        int n5 = n2 * this.rfb.framebufferWidth + n;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = 0;
            while (n7 < 3) {
                byArray4[n7] = (byte)(byArray2[n7] + byArray[n6 * n3 * 3 + n7]);
                byArray3[n7] = byArray4[n7];
                ++n7;
            }
            this.pixels24[n5++] = (byArray4[0] & 0xFF) << 16 | (byArray4[1] & 0xFF) << 8 | byArray4[2] & 0xFF;
            int n8 = 1;
            while (n8 < n3) {
                n7 = 0;
                while (n7 < 3) {
                    nArray[n7] = (byArray2[n8 * 3 + n7] & 0xFF) + (byArray4[n7] & 0xFF) - (byArray2[(n8 - 1) * 3 + n7] & 0xFF);
                    if (nArray[n7] > 255) {
                        nArray[n7] = 255;
                    } else if (nArray[n7] < 0) {
                        nArray[n7] = 0;
                    }
                    byArray4[n7] = (byte)(nArray[n7] + byArray[(n6 * n3 + n8) * 3 + n7]);
                    byArray3[n8 * 3 + n7] = byArray4[n7];
                    ++n7;
                }
                this.pixels24[n5++] = (byArray4[0] & 0xFF) << 16 | (byArray4[1] & 0xFF) << 8 | byArray4[2] & 0xFF;
                ++n8;
            }
            System.arraycopy(byArray3, 0, byArray2, 0, n3 * 3);
            n5 += this.rfb.framebufferWidth - n3;
            ++n6;
        }
    }

    void decodeMonoData(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) {
        int n5 = n2 * this.rfb.framebufferWidth + n;
        int n6 = (n3 + 7) / 8;
        int n7 = 0;
        while (n7 < n4) {
            int n8;
            int n9 = 0;
            while (n9 < n3 / 8) {
                byte by = byArray[n7 * n6 + n9];
                n8 = 7;
                while (n8 >= 0) {
                    this.pixels8[n5++] = byArray2[by >> n8 & 1];
                    --n8;
                }
                ++n9;
            }
            n8 = 7;
            while (n8 >= 8 - n3 % 8) {
                this.pixels8[n5++] = byArray2[byArray[n7 * n6 + n9] >> n8 & 1];
                --n8;
            }
            n5 += this.rfb.framebufferWidth - n3;
            ++n7;
        }
    }

    void decodeMonoData(int n, int n2, int n3, int n4, byte[] byArray, int[] nArray) {
        int n5 = n2 * this.rfb.framebufferWidth + n;
        int n6 = (n3 + 7) / 8;
        int n7 = 0;
        while (n7 < n4) {
            int n8;
            int n9 = 0;
            while (n9 < n3 / 8) {
                byte by = byArray[n7 * n6 + n9];
                n8 = 7;
                while (n8 >= 0) {
                    this.pixels24[n5++] = nArray[by >> n8 & 1];
                    --n8;
                }
                ++n9;
            }
            n8 = 7;
            while (n8 >= 8 - n3 % 8) {
                this.pixels24[n5++] = nArray[byArray[n7 * n6 + n9] >> n8 & 1];
                --n8;
            }
            n5 += this.rfb.framebufferWidth - n3;
            ++n7;
        }
    }

    public synchronized void enableInput(boolean bl) {
        if (bl && !this.inputEnabled) {
            this.inputEnabled = true;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            if (this.viewer.showControls) {
                this.viewer.buttonPanel.enableRemoteAccessControls(true);
            }
            this.createSoftCursor();
        } else if (!bl && this.inputEnabled) {
            this.inputEnabled = false;
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
            if (this.viewer.showControls) {
                this.viewer.buttonPanel.enableRemoteAccessControls(false);
            }
            this.createSoftCursor();
        }
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    void handleCoRRERect(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.rfb.is.readInt();
        byte[] byArray = new byte[this.bytesPixel];
        this.rfb.readFully(byArray);
        Color color = this.bytesPixel == 1 ? this.colors[byArray[0] & 0xFF] : new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
        this.memGraphics.setColor(color);
        this.memGraphics.fillRect(n, n2, n3, n4);
        byte[] byArray2 = new byte[n5 * (this.bytesPixel + 4)];
        this.rfb.readFully(byArray2);
        if (this.rfb.rec != null) {
            this.rfb.rec.writeIntBE(n5);
            this.rfb.rec.write(byArray);
            this.rfb.rec.write(byArray2);
        }
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5) {
            if (this.bytesPixel == 1) {
                color = this.colors[byArray2[n6++] & 0xFF];
            } else {
                color = new Color(byArray2[n6 + 2] & 0xFF, byArray2[n6 + 1] & 0xFF, byArray2[n6] & 0xFF);
                n6 += 4;
            }
            int n8 = n + (byArray2[n6++] & 0xFF);
            int n9 = n2 + (byArray2[n6++] & 0xFF);
            int n10 = byArray2[n6++] & 0xFF;
            int n11 = byArray2[n6++] & 0xFF;
            this.memGraphics.setColor(color);
            this.memGraphics.fillRect(n8, n9, n10, n11);
            ++n7;
        }
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void handleCopyRect(int n, int n2, int n3, int n4) throws IOException {
        this.rfb.readCopyRect();
        this.memGraphics.copyArea(this.rfb.copyRectSrcX, this.rfb.copyRectSrcY, n3, n4, n - this.rfb.copyRectSrcX, n2 - this.rfb.copyRectSrcY);
        this.scheduleRepaint(n, n2, n3, n4);
    }

    synchronized void handleCursorShapeUpdate(int n, int n2, int n3, int n4, int n5) throws IOException {
        this.softCursorFree();
        if (n4 * n5 == 0) {
            return;
        }
        if (this.viewer.options.ignoreCursorUpdates) {
            int n6 = (n4 + 7) / 8;
            int n7 = n6 * n5;
            if (n == -240) {
                this.rfb.is.skipBytes(6 + n7 * 2);
            } else {
                this.rfb.is.skipBytes(n4 * n5 + n7);
            }
            return;
        }
        this.softCursorSource = this.decodeCursorShape(n, n4, n5);
        this.origCursorWidth = n4;
        this.origCursorHeight = n5;
        this.origHotX = n2;
        this.origHotY = n3;
        this.createSoftCursor();
        this.showSoftCursor = true;
        this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
    }

    void handleHextileRect(int n, int n2, int n3, int n4) throws IOException {
        this.hextile_bg = new Color(0);
        this.hextile_fg = new Color(0);
        int n5 = n2;
        while (n5 < n2 + n4) {
            int n6 = 16;
            if (n2 + n4 - n5 < 16) {
                n6 = n2 + n4 - n5;
            }
            int n7 = n;
            while (n7 < n + n3) {
                int n8 = 16;
                if (n + n3 - n7 < 16) {
                    n8 = n + n3 - n7;
                }
                this.handleHextileSubrect(n7, n5, n8, n6);
                n7 += 16;
            }
            this.scheduleRepaint(n, n2, n3, n4);
            n5 += 16;
        }
    }

    void handleHextileSubrect(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.rfb.is.readUnsignedByte();
        if (this.rfb.rec != null) {
            this.rfb.rec.writeByte(n5);
        }
        if ((n5 & 1) != 0) {
            this.handleRawRect(n, n2, n3, n4, false);
            return;
        }
        byte[] byArray = new byte[this.bytesPixel];
        if ((n5 & 2) != 0) {
            this.rfb.readFully(byArray);
            this.hextile_bg = this.bytesPixel == 1 ? this.colors[byArray[0] & 0xFF] : new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
            if (this.rfb.rec != null) {
                this.rfb.rec.write(byArray);
            }
        }
        this.memGraphics.setColor(this.hextile_bg);
        this.memGraphics.fillRect(n, n2, n3, n4);
        if ((n5 & 4) != 0) {
            this.rfb.readFully(byArray);
            this.hextile_fg = this.bytesPixel == 1 ? this.colors[byArray[0] & 0xFF] : new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
            if (this.rfb.rec != null) {
                this.rfb.rec.write(byArray);
            }
        }
        if ((n5 & 8) == 0) {
            return;
        }
        int n6 = this.rfb.is.readUnsignedByte();
        int n7 = n6 * 2;
        if ((n5 & 0x10) != 0) {
            n7 += n6 * this.bytesPixel;
        }
        byte[] byArray2 = new byte[n7];
        this.rfb.readFully(byArray2);
        if (this.rfb.rec != null) {
            this.rfb.rec.writeByte(n6);
            this.rfb.rec.write(byArray2);
        }
        int n8 = 0;
        if ((n5 & 0x10) == 0) {
            this.memGraphics.setColor(this.hextile_fg);
            int n9 = 0;
            while (n9 < n6) {
                int n10 = byArray2[n8++] & 0xFF;
                int n11 = byArray2[n8++] & 0xFF;
                int n12 = n + (n10 >> 4);
                int n13 = n2 + (n10 & 0xF);
                int n14 = (n11 >> 4) + 1;
                int n15 = (n11 & 0xF) + 1;
                this.memGraphics.fillRect(n12, n13, n14, n15);
                ++n9;
            }
        } else if (this.bytesPixel == 1) {
            int n16 = 0;
            while (n16 < n6) {
                this.hextile_fg = this.colors[byArray2[n8++] & 0xFF];
                int n17 = byArray2[n8++] & 0xFF;
                int n18 = byArray2[n8++] & 0xFF;
                int n19 = n + (n17 >> 4);
                int n20 = n2 + (n17 & 0xF);
                int n21 = (n18 >> 4) + 1;
                int n22 = (n18 & 0xF) + 1;
                this.memGraphics.setColor(this.hextile_fg);
                this.memGraphics.fillRect(n19, n20, n21, n22);
                ++n16;
            }
        } else {
            int n23 = 0;
            while (n23 < n6) {
                this.hextile_fg = new Color(byArray2[n8 + 2] & 0xFF, byArray2[n8 + 1] & 0xFF, byArray2[n8] & 0xFF);
                n8 += 4;
                int n24 = byArray2[n8++] & 0xFF;
                int n25 = byArray2[n8++] & 0xFF;
                int n26 = n + (n24 >> 4);
                int n27 = n2 + (n24 & 0xF);
                int n28 = (n25 >> 4) + 1;
                int n29 = (n25 & 0xF) + 1;
                this.memGraphics.setColor(this.hextile_fg);
                this.memGraphics.fillRect(n26, n27, n28, n29);
                ++n23;
            }
        }
    }

    void handleRRERect(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.rfb.is.readInt();
        byte[] byArray = new byte[this.bytesPixel];
        this.rfb.readFully(byArray);
        Color color = this.bytesPixel == 1 ? this.colors[byArray[0] & 0xFF] : new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
        this.memGraphics.setColor(color);
        this.memGraphics.fillRect(n, n2, n3, n4);
        byte[] byArray2 = new byte[n5 * (this.bytesPixel + 8)];
        this.rfb.readFully(byArray2);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray2));
        if (this.rfb.rec != null) {
            this.rfb.rec.writeIntBE(n5);
            this.rfb.rec.write(byArray);
            this.rfb.rec.write(byArray2);
        }
        int n6 = 0;
        while (n6 < n5) {
            if (this.bytesPixel == 1) {
                color = this.colors[dataInputStream.readUnsignedByte()];
            } else {
                dataInputStream.skip(4L);
                color = new Color(byArray2[n6 * 12 + 2] & 0xFF, byArray2[n6 * 12 + 1] & 0xFF, byArray2[n6 * 12] & 0xFF);
            }
            int n7 = n + dataInputStream.readUnsignedShort();
            int n8 = n2 + dataInputStream.readUnsignedShort();
            int n9 = dataInputStream.readUnsignedShort();
            int n10 = dataInputStream.readUnsignedShort();
            this.memGraphics.setColor(color);
            this.memGraphics.fillRect(n7, n8, n9, n10);
            ++n6;
        }
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void handleRawRect(int n, int n2, int n3, int n4) throws IOException {
        this.handleRawRect(n, n2, n3, n4, true);
    }

    void handleRawRect(int n, int n2, int n3, int n4, boolean bl) throws IOException {
        if (this.bytesPixel == 1) {
            int n5 = n2;
            while (n5 < n2 + n4) {
                this.rfb.readFully(this.pixels8, n5 * this.rfb.framebufferWidth + n, n3);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(this.pixels8, n5 * this.rfb.framebufferWidth + n, n3);
                }
                ++n5;
            }
        } else {
            byte[] byArray = new byte[n3 * 4];
            int n6 = n2;
            while (n6 < n2 + n4) {
                this.rfb.readFully(byArray);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(byArray);
                }
                int n7 = n6 * this.rfb.framebufferWidth + n;
                int n8 = 0;
                while (n8 < n3) {
                    this.pixels24[n7 + n8] = (byArray[n8 * 4 + 2] & 0xFF) << 16 | (byArray[n8 * 4 + 1] & 0xFF) << 8 | byArray[n8 * 4] & 0xFF;
                    ++n8;
                }
                ++n6;
            }
        }
        this.handleUpdatedPixels(n, n2, n3, n4);
        if (bl) {
            this.scheduleRepaint(n, n2, n3, n4);
        }
    }

    void handleTightRect(int n, int n2, int n3, int n4) throws Exception {
        int n5;
        byte[] byArray;
        int n6;
        int n7 = this.rfb.is.readUnsignedByte();
        if (this.rfb.rec != null) {
            if (this.rfb.recordFromBeginning || n7 == 128 || n7 == 144) {
                this.rfb.rec.writeByte(n7);
            } else {
                this.rfb.rec.writeByte(n7 | 0xF);
            }
        }
        int n8 = 0;
        while (n8 < 4) {
            if ((n7 & 1) != 0 && this.tightInflaters[n8] != null) {
                this.tightInflaters[n8] = null;
            }
            n7 >>= 1;
            ++n8;
        }
        if (n7 > 9) {
            throw new Exception("Incorrect tight subencoding: " + n7);
        }
        if (n7 == 8) {
            if (this.bytesPixel == 1) {
                int n9 = this.rfb.is.readUnsignedByte();
                this.memGraphics.setColor(this.colors[n9]);
                if (this.rfb.rec != null) {
                    this.rfb.rec.writeByte(n9);
                }
            } else {
                byte[] byArray2 = new byte[3];
                this.rfb.readFully(byArray2);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(byArray2);
                }
                Color color = new Color(0xFF000000 | (byArray2[0] & 0xFF) << 16 | (byArray2[1] & 0xFF) << 8 | byArray2[2] & 0xFF);
                this.memGraphics.setColor(color);
            }
            this.memGraphics.fillRect(n, n2, n3, n4);
            this.scheduleRepaint(n, n2, n3, n4);
            return;
        }
        if (n7 == 9) {
            byte[] byArray3 = new byte[this.rfb.readCompactLen()];
            this.rfb.readFully(byArray3);
            if (this.rfb.rec != null) {
                if (!this.rfb.recordFromBeginning) {
                    this.rfb.recordCompactLen(byArray3.length);
                }
                this.rfb.rec.write(byArray3);
            }
            Image image = Toolkit.getDefaultToolkit().createImage(byArray3);
            Rectangle rectangle = this.jpegRect = new Rectangle(n, n2, n3, n4);
            synchronized (rectangle) {
                Toolkit.getDefaultToolkit().prepareImage(image, -1, -1, this);
                try {
                    this.jpegRect.wait(3000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new Exception("Interrupted while decoding JPEG image");
                }
            }
            this.jpegRect = null;
            return;
        }
        int n10 = 0;
        int n11 = n3;
        byte[] byArray4 = new byte[2];
        int[] nArray = new int[256];
        boolean bl = false;
        if ((n7 & 4) != 0) {
            n6 = this.rfb.is.readUnsignedByte();
            if (this.rfb.rec != null) {
                this.rfb.rec.writeByte(n6);
            }
            if (n6 == 1) {
                n10 = this.rfb.is.readUnsignedByte() + 1;
                if (this.rfb.rec != null) {
                    this.rfb.rec.writeByte(n10 - 1);
                }
                if (this.bytesPixel == 1) {
                    if (n10 != 2) {
                        throw new Exception("Incorrect tight palette size: " + n10);
                    }
                    this.rfb.readFully(byArray4);
                    if (this.rfb.rec != null) {
                        this.rfb.rec.write(byArray4);
                    }
                } else {
                    byArray = new byte[n10 * 3];
                    this.rfb.readFully(byArray);
                    if (this.rfb.rec != null) {
                        this.rfb.rec.write(byArray);
                    }
                    n5 = 0;
                    while (n5 < n10) {
                        nArray[n5] = (byArray[n5 * 3] & 0xFF) << 16 | (byArray[n5 * 3 + 1] & 0xFF) << 8 | byArray[n5 * 3 + 2] & 0xFF;
                        ++n5;
                    }
                }
                if (n10 == 2) {
                    n11 = (n3 + 7) / 8;
                }
            } else if (n6 == 2) {
                bl = true;
            } else if (n6 != 0) {
                throw new Exception("Incorrect tight filter id: " + n6);
            }
        }
        if (n10 == 0 && this.bytesPixel == 4) {
            n11 *= 3;
        }
        if ((n6 = n4 * n11) < 12) {
            if (n10 != 0) {
                byArray = new byte[n6];
                this.rfb.readFully(byArray);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(byArray);
                }
                if (n10 == 2) {
                    if (this.bytesPixel == 1) {
                        this.decodeMonoData(n, n2, n3, n4, byArray, byArray4);
                    } else {
                        this.decodeMonoData(n, n2, n3, n4, byArray, nArray);
                    }
                } else {
                    n5 = 0;
                    int n12 = n2;
                    while (n12 < n2 + n4) {
                        int n13 = n;
                        while (n13 < n + n3) {
                            this.pixels24[n12 * this.rfb.framebufferWidth + n13] = nArray[byArray[n5++] & 0xFF];
                            ++n13;
                        }
                        ++n12;
                    }
                }
            } else if (bl) {
                byArray = new byte[n3 * n4 * 3];
                this.rfb.readFully(byArray);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(byArray);
                }
                this.decodeGradientData(n, n2, n3, n4, byArray);
            } else if (this.bytesPixel == 1) {
                int n14 = n2;
                while (n14 < n2 + n4) {
                    this.rfb.readFully(this.pixels8, n14 * this.rfb.framebufferWidth + n, n3);
                    if (this.rfb.rec != null) {
                        this.rfb.rec.write(this.pixels8, n14 * this.rfb.framebufferWidth + n, n3);
                    }
                    ++n14;
                }
            } else {
                byArray = new byte[n3 * 3];
                int n15 = n2;
                while (n15 < n2 + n4) {
                    this.rfb.readFully(byArray);
                    if (this.rfb.rec != null) {
                        this.rfb.rec.write(byArray);
                    }
                    int n16 = n15 * this.rfb.framebufferWidth + n;
                    n5 = 0;
                    while (n5 < n3) {
                        this.pixels24[n16 + n5] = (byArray[n5 * 3] & 0xFF) << 16 | (byArray[n5 * 3 + 1] & 0xFF) << 8 | byArray[n5 * 3 + 2] & 0xFF;
                        ++n5;
                    }
                    ++n15;
                }
            }
        } else {
            int n17;
            int n18 = this.rfb.readCompactLen();
            byte[] byArray5 = new byte[n18];
            this.rfb.readFully(byArray5);
            if (this.rfb.rec != null && this.rfb.recordFromBeginning) {
                this.rfb.rec.write(byArray5);
            }
            if (this.tightInflaters[n17 = n7 & 3] == null) {
                this.tightInflaters[n17] = new Inflater();
            }
            Inflater inflater = this.tightInflaters[n17];
            inflater.setInput(byArray5);
            byte[] byArray6 = new byte[n6];
            inflater.inflate(byArray6);
            if (this.rfb.rec != null && !this.rfb.recordFromBeginning) {
                this.rfb.recordCompressedData(byArray6);
            }
            if (n10 != 0) {
                if (n10 == 2) {
                    if (this.bytesPixel == 1) {
                        this.decodeMonoData(n, n2, n3, n4, byArray6, byArray4);
                    } else {
                        this.decodeMonoData(n, n2, n3, n4, byArray6, nArray);
                    }
                } else {
                    int n19 = 0;
                    int n20 = n2;
                    while (n20 < n2 + n4) {
                        int n21 = n;
                        while (n21 < n + n3) {
                            this.pixels24[n20 * this.rfb.framebufferWidth + n21] = nArray[byArray6[n19++] & 0xFF];
                            ++n21;
                        }
                        ++n20;
                    }
                }
            } else if (bl) {
                this.decodeGradientData(n, n2, n3, n4, byArray6);
            } else if (this.bytesPixel == 1) {
                int n22 = n2 * this.rfb.framebufferWidth + n;
                int n23 = 0;
                while (n23 < n4) {
                    System.arraycopy(byArray6, n23 * n3, this.pixels8, n22, n3);
                    n22 += this.rfb.framebufferWidth;
                    ++n23;
                }
            } else {
                int n24 = 0;
                int n25 = 0;
                while (n25 < n4) {
                    inflater.inflate(byArray6);
                    int n26 = (n2 + n25) * this.rfb.framebufferWidth + n;
                    int n27 = 0;
                    while (n27 < n3) {
                        this.pixels24[n26 + n27] = (byArray6[n24] & 0xFF) << 16 | (byArray6[n24 + 1] & 0xFF) << 8 | byArray6[n24 + 2] & 0xFF;
                        n24 += 3;
                        ++n27;
                    }
                    ++n25;
                }
            }
        }
        this.handleUpdatedPixels(n, n2, n3, n4);
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void handleUpdatedPixels(int n, int n2, int n3, int n4) {
        this.pixelsSource.newPixels(n, n2, n3, n4);
        this.memGraphics.setClip(n, n2, n3, n4);
        this.memGraphics.drawImage(this.rawPixelsImage, 0, 0, null);
        this.memGraphics.setClip(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    void handleZlibRect(int n, int n2, int n3, int n4) throws Exception {
        int n5 = this.rfb.is.readInt();
        if (this.zlibBuf == null || this.zlibBufLen < n5) {
            this.zlibBufLen = n5 * 2;
            this.zlibBuf = new byte[this.zlibBufLen];
        }
        this.rfb.readFully(this.zlibBuf, 0, n5);
        if (this.rfb.rec != null && this.rfb.recordFromBeginning) {
            this.rfb.rec.writeIntBE(n5);
            this.rfb.rec.write(this.zlibBuf, 0, n5);
        }
        if (this.zlibInflater == null) {
            this.zlibInflater = new Inflater();
        }
        this.zlibInflater.setInput(this.zlibBuf, 0, n5);
        if (this.bytesPixel == 1) {
            int n6 = n2;
            while (n6 < n2 + n4) {
                this.zlibInflater.inflate(this.pixels8, n6 * this.rfb.framebufferWidth + n, n3);
                if (this.rfb.rec != null && !this.rfb.recordFromBeginning) {
                    this.rfb.rec.write(this.pixels8, n6 * this.rfb.framebufferWidth + n, n3);
                }
                ++n6;
            }
        } else {
            byte[] byArray = new byte[n3 * 4];
            int n7 = n2;
            while (n7 < n2 + n4) {
                this.zlibInflater.inflate(byArray);
                int n8 = n7 * this.rfb.framebufferWidth + n;
                int n9 = 0;
                while (n9 < n3) {
                    this.pixels24[n8 + n9] = (byArray[n9 * 4 + 2] & 0xFF) << 16 | (byArray[n9 * 4 + 1] & 0xFF) << 8 | byArray[n9 * 4] & 0xFF;
                    ++n9;
                }
                if (this.rfb.rec != null && !this.rfb.recordFromBeginning) {
                    this.rfb.rec.write(byArray);
                }
                ++n7;
            }
        }
        this.handleUpdatedPixels(n, n2, n3, n4);
        this.scheduleRepaint(n, n2, n3, n4);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0xA0) == 0) {
            return true;
        }
        if ((n & 0x20) != 0 && this.jpegRect != null) {
            Rectangle rectangle = this.jpegRect;
            synchronized (rectangle) {
                this.memGraphics.drawImage(image, this.jpegRect.x, this.jpegRect.y, null);
                this.scheduleRepaint(this.jpegRect.x, this.jpegRect.y, this.jpegRect.width, this.jpegRect.height);
                this.jpegRect.notify();
            }
        }
        return false;
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.processLocalKeyEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.processLocalKeyEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, true);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, true);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, false);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, false);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        Rectangle rectangle;
        Image image = this.memImage;
        synchronized (image) {
            graphics.drawImage(this.memImage, 0, 0, null);
        }
        if (this.showSoftCursor && (rectangle = new Rectangle(n2 = this.cursorX - this.hotX, n = this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight)).intersects(graphics.getClipBounds())) {
            graphics.drawImage(this.softCursor, n2, n, null);
        }
    }

    public void processLocalKeyEvent(KeyEvent keyEvent) {
        if (this.viewer.rfb != null && this.rfb.inNormalProtocol) {
            if (!this.inputEnabled) {
                if ((keyEvent.getKeyChar() == 'r' || keyEvent.getKeyChar() == 'R') && keyEvent.getID() == 401) {
                    try {
                        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            } else {
                RfbProto rfbProto = this.rfb;
                synchronized (rfbProto) {
                    try {
                        this.rfb.writeKeyEvent(keyEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this.rfb.notify();
                }
            }
        }
        keyEvent.consume();
    }

    public void processLocalMouseEvent(MouseEvent mouseEvent, boolean bl) {
        if (this.viewer.rfb != null && this.rfb.inNormalProtocol) {
            if (bl) {
                this.softCursorMove(mouseEvent.getX(), mouseEvent.getY());
            }
            RfbProto rfbProto = this.rfb;
            synchronized (rfbProto) {
                try {
                    this.rfb.writePointerEvent(mouseEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.rfb.notify();
            }
        }
    }

    public void processNormalProtocol() throws Exception {
        int n;
        this.viewer.checkRecordingStatus();
        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
        block20: while (true) {
            n = this.rfb.readServerMessageType();
            switch (n) {
                case 0: {
                    this.rfb.readFramebufferUpdate();
                    boolean bl = false;
                    int n2 = 0;
                    while (n2 < this.rfb.updateNRects) {
                        this.rfb.readFramebufferUpdateRectHdr();
                        int n3 = this.rfb.updateRectX;
                        int n4 = this.rfb.updateRectY;
                        int n5 = this.rfb.updateRectW;
                        int n6 = this.rfb.updateRectH;
                        if (this.rfb.updateRectEncoding == -224) break;
                        if (this.rfb.updateRectEncoding == -223) {
                            this.rfb.setFramebufferSize(n5, n6);
                            this.updateFramebufferSize();
                            break;
                        }
                        if (this.rfb.updateRectEncoding == -240 || this.rfb.updateRectEncoding == -239) {
                            this.handleCursorShapeUpdate(this.rfb.updateRectEncoding, n3, n4, n5, n6);
                        } else if (this.rfb.updateRectEncoding == -232) {
                            this.softCursorMove(n3, n4);
                            bl = true;
                        } else {
                            this.rfb.startTiming();
                            switch (this.rfb.updateRectEncoding) {
                                case 0: {
                                    this.handleRawRect(n3, n4, n5, n6);
                                    break;
                                }
                                case 1: {
                                    this.handleCopyRect(n3, n4, n5, n6);
                                    break;
                                }
                                case 2: {
                                    this.handleRRERect(n3, n4, n5, n6);
                                    break;
                                }
                                case 4: {
                                    this.handleCoRRERect(n3, n4, n5, n6);
                                    break;
                                }
                                case 5: {
                                    this.handleHextileRect(n3, n4, n5, n6);
                                    break;
                                }
                                case 6: {
                                    this.handleZlibRect(n3, n4, n5, n6);
                                    break;
                                }
                                case 7: {
                                    this.handleTightRect(n3, n4, n5, n6);
                                    break;
                                }
                                default: {
                                    throw new Exception("Unknown RFB rectangle encoding " + this.rfb.updateRectEncoding);
                                }
                            }
                            this.rfb.stopTiming();
                        }
                        ++n2;
                    }
                    n2 = 0;
                    if (this.viewer.checkRecordingStatus()) {
                        n2 = 1;
                    }
                    if (this.viewer.deferUpdateRequests > 0 && this.rfb.is.available() == 0 && !bl) {
                        RfbProto rfbProto = this.rfb;
                        synchronized (rfbProto) {
                            try {
                                this.rfb.wait(this.viewer.deferUpdateRequests);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (this.viewer.options.eightBitColors != (this.bytesPixel == 1)) {
                        this.setPixelFormat();
                        n2 = 1;
                    }
                    this.viewer.autoSelectEncodings();
                    this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, (n2 ^ 1) != 0);
                    continue block20;
                }
                case 1: {
                    throw new Exception("Can't handle SetColourMapEntries message");
                }
                case 2: {
                    Toolkit.getDefaultToolkit().beep();
                    continue block20;
                }
                case 3: {
                    String string = this.rfb.readServerCutText();
                    this.viewer.clipboard.setCutText(string);
                    continue block20;
                }
            }
            break;
        }
        throw new Exception("Unknown RFB message type " + n);
    }

    void resizeDesktopFrame() {
        Dimension dimension;
        this.setSize(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
        Insets insets = this.viewer.desktopScrollPane.getInsets();
        this.viewer.desktopScrollPane.setSize(this.rfb.framebufferWidth + 2 * Math.min(insets.left, insets.right), this.rfb.framebufferHeight + 2 * Math.min(insets.top, insets.bottom));
        this.viewer.vncFrame.pack();
        Dimension dimension2 = this.viewer.vncFrame.getToolkit().getScreenSize();
        Dimension dimension3 = dimension = this.viewer.vncFrame.getSize();
        dimension2.height -= 30;
        dimension2.width -= 30;
        boolean bl = false;
        if (dimension.height > dimension2.height) {
            dimension3.height = dimension2.height;
            bl = true;
        }
        if (dimension.width > dimension2.width) {
            dimension3.width = dimension2.width;
            bl = true;
        }
        if (bl) {
            ((Component)this.viewer.vncFrame).setSize(dimension3);
        }
        this.viewer.desktopScrollPane.doLayout();
    }

    void scheduleRepaint(int n, int n2, int n3, int n4) {
        this.repaint(this.viewer.deferScreenUpdates, n, n2, n3, n4);
    }

    public void setPixelFormat() throws IOException {
        if (this.viewer.options.eightBitColors) {
            this.rfb.writeSetPixelFormat(8, 8, false, true, 7, 7, 3, 0, 3, 6);
            this.bytesPixel = 1;
        } else {
            this.rfb.writeSetPixelFormat(32, 24, false, true, 255, 255, 255, 16, 8, 0);
            this.bytesPixel = 4;
        }
        this.updateFramebufferSize();
    }

    synchronized void softCursorFree() {
        if (this.showSoftCursor) {
            this.showSoftCursor = false;
            this.softCursor = null;
            this.softCursorSource = null;
            this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
        }
    }

    synchronized void softCursorMove(int n, int n2) {
        int n3 = this.cursorX;
        int n4 = this.cursorY;
        this.cursorX = n;
        this.cursorY = n2;
        if (this.showSoftCursor) {
            this.repaint(this.viewer.deferCursorUpdates, n3 - this.hotX, n4 - this.hotY, this.cursorWidth, this.cursorHeight);
            this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    void updateFramebufferSize() {
        int n = this.rfb.framebufferWidth;
        int n2 = this.rfb.framebufferHeight;
        if (this.memImage == null) {
            this.memImage = this.viewer.vncContainer.createImage(n, n2);
            this.memGraphics = this.memImage.getGraphics();
        } else if (this.memImage.getWidth(null) != n || this.memImage.getHeight(null) != n2) {
            Image image = this.memImage;
            synchronized (image) {
                this.memImage = this.viewer.vncContainer.createImage(n, n2);
                this.memGraphics = this.memImage.getGraphics();
            }
        }
        if (this.bytesPixel == 1) {
            this.pixels24 = null;
            this.pixels8 = new byte[n * n2];
            this.pixelsSource = new MemoryImageSource(n, n2, this.cm8, this.pixels8, 0, n);
        } else {
            this.pixels8 = null;
            this.pixels24 = new int[n * n2];
            this.pixelsSource = new MemoryImageSource(n, n2, this.cm24, this.pixels24, 0, n);
        }
        this.pixelsSource.setAnimated(true);
        this.rawPixelsImage = Toolkit.getDefaultToolkit().createImage(this.pixelsSource);
        if (this.viewer.inSeparateFrame) {
            if (this.viewer.desktopScrollPane != null) {
                this.resizeDesktopFrame();
            }
        } else {
            this.setSize(n, n2);
        }
        this.viewer.moveFocusToDesktop();
    }
}

