/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public class VncViewer
extends Applet
implements Runnable,
WindowListener {
    boolean inAnApplet = true;
    boolean inSeparateFrame = false;
    String[] mainArgs;
    RfbProto rfb;
    Thread rfbThread;
    Frame vncFrame;
    Container vncContainer;
    ScrollPane desktopScrollPane;
    GridBagLayout gridbag;
    ButtonPanel buttonPanel;
    Label connStatusLabel;
    VncCanvas vc;
    OptionsFrame options;
    ClipboardFrame clipboard;
    RecordingFrame rec;
    Object recordingSync;
    String sessionFileName;
    boolean recordingActive;
    boolean recordingStatusChanged;
    String cursorUpdatesDef;
    String eightBitColorsDef;
    String socketFactory;
    String host;
    int port;
    String passwordParam;
    boolean showControls;
    boolean offerRelogin;
    boolean showOfflineDesktop;
    int deferScreenUpdates;
    int deferCursorUpdates;
    int deferUpdateRequests;
    public static Applet refApplet;
    int[] encodingsSaved;
    int nEncodingsSaved;

    String askPassword() throws Exception {
        this.showConnectionStatus(null);
        AuthPanel authPanel = new AuthPanel(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.ipady = 50;
        this.gridbag.setConstraints(authPanel, gridBagConstraints);
        this.vncContainer.add(authPanel);
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
        } else {
            this.validate();
        }
        authPanel.moveFocusToDefaultField();
        String string = authPanel.getPassword();
        this.vncContainer.remove(authPanel);
        return string;
    }

    void autoSelectEncodings() {
        this.setEncodings(true);
    }

    boolean checkRecordingStatus() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingStatusChanged) {
                this.recordingStatusChanged = false;
                if (this.sessionFileName != null) {
                    this.startRecording();
                    boolean bl = true;
                    Object var3_3 = null;
                    return bl;
                }
                this.stopRecording();
            }
        }
        return false;
    }

    void connectAndAuthenticate() throws Exception {
        int n;
        this.showConnectionStatus("Initializing...");
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
            this.vncFrame.show();
        } else {
            this.validate();
        }
        this.showConnectionStatus("Connecting to " + this.host + ", port " + this.port + "...");
        this.rfb = new RfbProto(this.host, this.port, this);
        this.showConnectionStatus("Connected to server");
        this.rfb.readVersionMsg();
        this.showConnectionStatus("RFB server supports protocol version " + this.rfb.serverMajor + "." + this.rfb.serverMinor);
        this.rfb.writeVersionMsg();
        this.showConnectionStatus("Using RFB protocol version " + this.rfb.clientMajor + "." + this.rfb.clientMinor);
        int n2 = this.rfb.negotiateSecurity();
        if (n2 == 16) {
            this.showConnectionStatus("Enabling TightVNC protocol extensions");
            this.rfb.initCapabilities();
            this.rfb.setupTunneling();
            n = this.rfb.negotiateAuthenticationTight();
        } else {
            n = n2;
        }
        switch (n) {
            case 1: {
                this.showConnectionStatus("No authentication needed");
                this.rfb.authenticateNone();
                break;
            }
            case 2: {
                this.showConnectionStatus("Performing standard VNC authentication");
                if (this.passwordParam != null) {
                    this.rfb.authenticateVNC(this.passwordParam);
                    break;
                }
                String string = this.askPassword();
                this.rfb.authenticateVNC(string);
                break;
            }
            default: {
                throw new Exception("Unknown authentication scheme " + n);
            }
        }
    }

    void createCanvas(int n, int n2) throws IOException {
        this.vc = null;
        try {
            Class<?> clazz = Class.forName("java.awt.Graphics2D");
            clazz = Class.forName("VncCanvas2");
            Class[] classArray = new Class[]{this.getClass(), Integer.TYPE, Integer.TYPE};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this, new Integer(n), new Integer(n2)};
            this.vc = (VncCanvas)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            System.out.println("Warning: Java 2D API is not available");
        }
        if (this.vc == null) {
            this.vc = new VncCanvas(this, n, n2);
        }
    }

    public void destroy() {
        System.out.println("Destroying applet");
        this.vncContainer.removeAll();
        this.options.dispose();
        this.clipboard.dispose();
        if (this.rec != null) {
            this.rec.dispose();
        }
        if (this.rfb != null && !this.rfb.closed()) {
            this.rfb.close();
        }
        if (this.inSeparateFrame) {
            this.vncFrame.dispose();
        }
    }

    public synchronized void disconnect() {
        System.out.println("Disconnect");
        if (this.rfb != null && !this.rfb.closed()) {
            this.rfb.close();
        }
        this.options.dispose();
        this.clipboard.dispose();
        if (this.rec != null) {
            this.rec.dispose();
        }
        if (this.inAnApplet) {
            this.showMessage("Disconnected");
        } else {
            System.exit(0);
        }
    }

    void doProtocolInitialisation() throws IOException {
        this.rfb.writeClientInit();
        this.rfb.readServerInit();
        System.out.println("Desktop name is " + this.rfb.desktopName);
        System.out.println("Desktop size is " + this.rfb.framebufferWidth + " x " + this.rfb.framebufferHeight);
        this.setEncodings();
        this.showConnectionStatus(null);
    }

    public void enableInput(boolean bl) {
        this.vc.enableInput(bl);
    }

    public synchronized void fatalError(String string) {
        System.out.println(string);
        if (this.inAnApplet) {
            Thread.currentThread().stop();
        } else {
            System.exit(1);
        }
    }

    public synchronized void fatalError(String string, Exception exception) {
        if (this.rfb != null && this.rfb.closed()) {
            System.out.println("RFB thread finished");
            return;
        }
        System.out.println(string);
        exception.printStackTrace();
        if (this.rfb != null) {
            this.rfb.close();
        }
        if (this.inAnApplet) {
            this.showMessage(string);
        } else {
            System.exit(1);
        }
    }

    public void init() {
        this.readParameters();
        refApplet = this;
        if (this.inSeparateFrame) {
            this.vncFrame = new Frame("TightVNC");
            if (!this.inAnApplet) {
                this.vncFrame.add("Center", this);
            }
            this.vncContainer = this.vncFrame;
        } else {
            this.vncContainer = this;
        }
        this.recordingSync = new Object();
        this.options = new OptionsFrame(this);
        this.clipboard = new ClipboardFrame(this);
        if (RecordingFrame.checkSecurity()) {
            this.rec = new RecordingFrame(this);
        }
        this.sessionFileName = null;
        this.recordingActive = false;
        this.recordingStatusChanged = false;
        this.cursorUpdatesDef = null;
        this.eightBitColorsDef = null;
        if (this.inSeparateFrame) {
            this.vncFrame.addWindowListener(this);
        }
        this.rfbThread = new Thread(this);
        this.rfbThread.start();
    }

    public static void main(String[] stringArray) {
        VncViewer vncViewer = new VncViewer();
        vncViewer.mainArgs = stringArray;
        vncViewer.inAnApplet = false;
        vncViewer.inSeparateFrame = true;
        vncViewer.init();
        vncViewer.start();
    }

    void moveFocusToDesktop() {
        if (this.vncContainer != null && this.vc != null && this.vncContainer.isAncestorOf(this.vc)) {
            this.vc.requestFocus();
        }
    }

    void processNormalProtocol() throws Exception {
        try {
            this.vc.processNormalProtocol();
        }
        catch (Exception exception) {
            if (this.rfbThread == null) {
                System.out.println("Ignoring RFB socket exceptions because applet is stopping");
            }
            throw exception;
        }
    }

    int readIntParameter(String string, int n) {
        int n2;
        block2: {
            String string2 = this.readParameter(string, false);
            n2 = n;
            if (string2 == null) break block2;
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n2;
    }

    public String readParameter(String string, boolean bl) {
        if (this.inAnApplet) {
            String string2 = this.getParameter(string);
            if (string2 == null && bl) {
                this.fatalError(String.valueOf(string) + " parameter not specified");
            }
            return string2;
        }
        int n = 0;
        while (n < this.mainArgs.length) {
            if (this.mainArgs[n].equalsIgnoreCase(string)) {
                try {
                    return this.mainArgs[n + 1];
                }
                catch (Exception exception) {
                    if (bl) {
                        this.fatalError(String.valueOf(string) + " parameter not specified");
                    }
                    return null;
                }
            }
            n += 2;
        }
        if (bl) {
            this.fatalError(String.valueOf(string) + " parameter not specified");
        }
        return null;
    }

    void readParameters() {
        this.host = this.readParameter("HOST", this.inAnApplet ^ true);
        if (this.host == null) {
            this.host = this.getCodeBase().getHost();
            if (this.host.equals("")) {
                this.fatalError("HOST parameter not specified");
            }
        }
        String string = this.readParameter("PORT", true);
        this.port = Integer.parseInt(string);
        this.readPasswordParameters();
        if (this.inAnApplet && (string = this.readParameter("Open New Window", false)) != null && string.equalsIgnoreCase("Yes")) {
            this.inSeparateFrame = true;
        }
        this.showControls = true;
        string = this.readParameter("Show Controls", false);
        if (string != null && string.equalsIgnoreCase("No")) {
            this.showControls = false;
        }
        this.offerRelogin = true;
        string = this.readParameter("Offer Relogin", false);
        if (string != null && string.equalsIgnoreCase("No")) {
            this.offerRelogin = false;
        }
        this.showOfflineDesktop = false;
        string = this.readParameter("Show Offline Desktop", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.showOfflineDesktop = true;
        }
        this.deferScreenUpdates = this.readIntParameter("Defer screen updates", 20);
        this.deferCursorUpdates = this.readIntParameter("Defer cursor updates", 10);
        this.deferUpdateRequests = this.readIntParameter("Defer update requests", 50);
        this.socketFactory = this.readParameter("SocketFactory", false);
    }

    private void readPasswordParameters() {
        String string = this.readParameter("ENCPASSWORD", false);
        if (string == null) {
            this.passwordParam = this.readParameter("PASSWORD", false);
        } else {
            Object object;
            Object object2;
            byte[] byArray = new byte[8];
            int n = string.length() / 2;
            if (n > 8) {
                n = 8;
            }
            int n2 = 0;
            while (n2 < n) {
                object2 = string.substring(n2 * 2, n2 * 2 + 2);
                object = new Integer(Integer.parseInt((String)object2, 16));
                byArray[n2] = ((Integer)object).byteValue();
                ++n2;
            }
            object2 = new byte[]{23, 82, 107, 6, 35, 78, 88, 7};
            object = new DesCipher((byte[])object2);
            ((DesCipher)object).decrypt(byArray, 0, byArray, 0);
            this.passwordParam = new String(byArray);
        }
    }

    public void run() {
        this.gridbag = new GridBagLayout();
        this.vncContainer.setLayout(this.gridbag);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        if (this.showControls) {
            this.buttonPanel = new ButtonPanel(this);
            this.gridbag.setConstraints(this.buttonPanel, gridBagConstraints);
            this.vncContainer.add(this.buttonPanel);
        }
        try {
            Serializable serializable;
            this.connectAndAuthenticate();
            this.doProtocolInitialisation();
            if (this.options.autoScale && this.inSeparateFrame) {
                try {
                    serializable = this.vncContainer.getToolkit().getScreenSize();
                }
                catch (Exception exception) {
                    serializable = new Dimension(0, 0);
                }
                this.createCanvas(((Dimension)serializable).width - 32, ((Dimension)serializable).height - 32);
            } else {
                this.createCanvas(0, 0);
            }
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            if (this.inSeparateFrame) {
                serializable = new Panel();
                ((Container)serializable).setLayout(new FlowLayout(0, 0, 0));
                ((Container)serializable).add(this.vc);
                this.desktopScrollPane = new ScrollPane(0);
                gridBagConstraints.fill = 1;
                this.gridbag.setConstraints(this.desktopScrollPane, gridBagConstraints);
                this.desktopScrollPane.add((Component)serializable);
                this.vncFrame.add(this.desktopScrollPane);
                this.vncFrame.setTitle(this.rfb.desktopName);
                this.vncFrame.pack();
                this.vc.resizeDesktopFrame();
            } else {
                this.gridbag.setConstraints(this.vc, gridBagConstraints);
                this.add(this.vc);
                this.validate();
            }
            if (this.showControls) {
                this.buttonPanel.enableButtons();
            }
            this.moveFocusToDesktop();
            this.processNormalProtocol();
        }
        catch (NoRouteToHostException noRouteToHostException) {
            this.fatalError("Network error: no route to server: " + this.host, noRouteToHostException);
        }
        catch (UnknownHostException unknownHostException) {
            this.fatalError("Network error: server name unknown: " + this.host, unknownHostException);
        }
        catch (ConnectException connectException) {
            this.fatalError("Network error: could not connect to server: " + this.host + ":" + this.port, connectException);
        }
        catch (EOFException eOFException) {
            if (this.showOfflineDesktop) {
                eOFException.printStackTrace();
                System.out.println("Network error: remote side closed connection");
                if (this.vc != null) {
                    this.vc.enableInput(false);
                }
                if (this.inSeparateFrame) {
                    this.vncFrame.setTitle(String.valueOf(this.rfb.desktopName) + " [disconnected]");
                }
                if (this.rfb != null && !this.rfb.closed()) {
                    this.rfb.close();
                }
                if (this.showControls && this.buttonPanel != null) {
                    this.buttonPanel.disableButtonsOnDisconnect();
                    if (this.inSeparateFrame) {
                        this.vncFrame.pack();
                    } else {
                        this.validate();
                    }
                }
            } else {
                this.fatalError("Network error: remote side closed connection", eOFException);
            }
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (string != null && string.length() != 0) {
                this.fatalError("Network Error: " + string, iOException);
            } else {
                this.fatalError(iOException.toString(), iOException);
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string != null && string.length() != 0) {
                this.fatalError("Error: " + string, exception);
            }
            this.fatalError(exception.toString(), exception);
        }
    }

    void setCutText(String string) {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeClientCutText(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void setEncodings() {
        this.setEncodings(false);
    }

    void setEncodings(boolean bl) {
        if (this.options == null || this.rfb == null || !this.rfb.inNormalProtocol) {
            return;
        }
        int n = this.options.preferredEncoding;
        if (n == -1) {
            long l = this.rfb.kbitsPerSecond();
            if (this.nEncodingsSaved < 1) {
                System.out.println("Using Tight/ZRLE encodings");
                n = 7;
            } else if (l > 2000L && this.encodingsSaved[0] != 5) {
                System.out.println("Throughput " + l + " kbit/s - changing to Hextile encoding");
                n = 5;
            } else if (l < 1000L && this.encodingsSaved[0] != 7) {
                System.out.println("Throughput " + l + " kbit/s - changing to Tight/ZRLE encodings");
                n = 7;
            } else {
                if (bl) {
                    return;
                }
                n = this.encodingsSaved[0];
            }
        } else if (bl) {
            return;
        }
        int[] nArray = new int[20];
        int n2 = 0;
        nArray[n2++] = n;
        if (this.options.useCopyRect) {
            nArray[n2++] = 1;
        }
        if (n != 7) {
            nArray[n2++] = 7;
        }
        if (n != 16) {
            nArray[n2++] = 16;
        }
        if (n != 5) {
            nArray[n2++] = 5;
        }
        if (n != 6) {
            nArray[n2++] = 6;
        }
        if (n != 4) {
            nArray[n2++] = 4;
        }
        if (n != 2) {
            nArray[n2++] = 2;
        }
        if (this.options.compressLevel >= 0 && this.options.compressLevel <= 9) {
            nArray[n2++] = -256 + this.options.compressLevel;
        }
        if (this.options.jpegQuality >= 0 && this.options.jpegQuality <= 9) {
            nArray[n2++] = -32 + this.options.jpegQuality;
        }
        if (this.options.requestCursorUpdates) {
            nArray[n2++] = -240;
            nArray[n2++] = -239;
            if (!this.options.ignoreCursorUpdates) {
                nArray[n2++] = -232;
            }
        }
        nArray[n2++] = -224;
        nArray[n2++] = -223;
        boolean bl2 = false;
        if (n2 != this.nEncodingsSaved) {
            bl2 = true;
        } else {
            int n3 = 0;
            while (n3 < n2) {
                if (nArray[n3] != this.encodingsSaved[n3]) {
                    bl2 = true;
                    break;
                }
                ++n3;
            }
        }
        if (bl2) {
            try {
                this.rfb.writeSetEncodings(nArray, n2);
                if (this.vc != null) {
                    this.vc.softCursorFree();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.encodingsSaved = nArray;
            this.nEncodingsSaved = n2;
        }
    }

    void setRecordingStatus(String string) {
        Object object = this.recordingSync;
        synchronized (object) {
            this.sessionFileName = string;
            this.recordingStatusChanged = true;
        }
    }

    void showConnectionStatus(String string) {
        if (string == null) {
            if (this.vncContainer.isAncestorOf(this.connStatusLabel)) {
                this.vncContainer.remove(this.connStatusLabel);
            }
            return;
        }
        System.out.println(string);
        if (this.connStatusLabel == null) {
            this.connStatusLabel = new Label("Status: " + string);
            this.connStatusLabel.setFont(new Font("Helvetica", 0, 12));
        } else {
            this.connStatusLabel.setText("Status: " + string);
        }
        if (!this.vncContainer.isAncestorOf(this.connStatusLabel)) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(20, 30, 20, 30);
            this.gridbag.setConstraints(this.connStatusLabel, gridBagConstraints);
            this.vncContainer.add(this.connStatusLabel);
        }
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
        } else {
            this.validate();
        }
    }

    void showMessage(String string) {
        this.vncContainer.removeAll();
        Label label = new Label(string, 1);
        label.setFont(new Font("Helvetica", 0, 12));
        if (this.offerRelogin) {
            Panel panel = new Panel(new GridLayout(0, 1));
            Panel panel2 = new Panel(new FlowLayout(0));
            panel2.add(panel);
            this.vncContainer.setLayout(new FlowLayout(0, 30, 16));
            this.vncContainer.add(panel2);
            Panel panel3 = new Panel(new FlowLayout(1));
            panel3.add(label);
            panel.add(panel3);
            panel.add(new ReloginPanel(this));
        } else {
            this.vncContainer.setLayout(new FlowLayout(0, 30, 30));
            this.vncContainer.add(label);
        }
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
        } else {
            this.validate();
        }
    }

    protected void startRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (!this.recordingActive) {
                this.cursorUpdatesDef = this.options.choices[3].getSelectedItem();
                this.eightBitColorsDef = this.options.choices[5].getSelectedItem();
                this.options.choices[3].select("Disable");
                this.options.choices[3].setEnabled(false);
                this.options.setEncodings();
                this.options.choices[5].select("No");
                this.options.choices[5].setEnabled(false);
                this.options.setColorFormat();
            } else {
                this.rfb.closeSession();
            }
            System.out.println("Recording the session in " + this.sessionFileName);
            this.rfb.startSession(this.sessionFileName);
            this.recordingActive = true;
        }
    }

    public void stop() {
        System.out.println("Stopping applet");
        this.rfbThread = null;
    }

    protected void stopRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingActive) {
                this.options.choices[3].select(this.cursorUpdatesDef);
                this.options.choices[3].setEnabled(true);
                this.options.setEncodings();
                this.options.choices[5].select(this.eightBitColorsDef);
                this.options.choices[5].setEnabled(true);
                this.options.setColorFormat();
                this.rfb.closeSession();
                System.out.println("Session recording stopped.");
            }
            this.sessionFileName = null;
            this.recordingActive = false;
        }
    }

    public void update(Graphics graphics) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.out.println("Closing window");
        if (this.rfb != null) {
            this.disconnect();
        }
        this.vncContainer.hide();
        if (!this.inAnApplet) {
            System.exit(0);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

