/*
 * Decompiled with CFR 0.152.
 */
package com.uchuhimo.konf.source;

import com.uchuhimo.konf.source.ParseException;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0003\u00a8\u0006\u0006"}, d2={"parseDuration", "", "input", "", "toDuration", "Ljava/time/Duration;", "konf-core"})
public final class UtilsKt {
    @NotNull
    public static final Duration toDuration(@NotNull String $this$toDuration) {
        Duration duration;
        Intrinsics.checkParameterIsNotNull($this$toDuration, "$this$toDuration");
        try {
            Duration duration2 = Duration.parse($this$toDuration);
            Intrinsics.checkExpressionValueIsNotNull(duration2, "Duration.parse(this)");
            duration = duration2;
        }
        catch (DateTimeParseException e) {
            Duration duration3 = Duration.ofNanos(UtilsKt.parseDuration($this$toDuration));
            Intrinsics.checkExpressionValueIsNotNull(duration3, "Duration.ofNanos(parseDuration(this))");
            duration = duration3;
        }
        return duration;
    }

    public static final long parseDuration(@NotNull String input) {
        long l;
        TimeUnit timeUnit;
        String originalUnitString;
        Intrinsics.checkParameterIsNotNull(input, "input");
        String string = input;
        boolean bl = false;
        String s = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String unitString = originalUnitString = com.uchuhimo.konf.UtilsKt.getUnits(s);
        CharSequence charSequence = s;
        int n = 0;
        int n2 = s.length() - unitString.length();
        boolean bl2 = false;
        String string2 = charSequence;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        charSequence = string3;
        n = 0;
        String string4 = charSequence;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String numberString = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        charSequence = numberString;
        n = 0;
        if (charSequence.length() == 0) {
            throw (Throwable)new ParseException("No number in duration value '" + input + '\'');
        }
        if (unitString.length() > 2 && !StringsKt.endsWith$default(unitString, "s", false, 2, null)) {
            unitString = unitString + "s";
        }
        if (Intrinsics.areEqual(unitString, "") || Intrinsics.areEqual(unitString, "ms") || Intrinsics.areEqual(unitString, "millis") || Intrinsics.areEqual(unitString, "milliseconds")) {
            timeUnit = TimeUnit.MILLISECONDS;
        } else if (Intrinsics.areEqual(unitString, "us") || Intrinsics.areEqual(unitString, "micros") || Intrinsics.areEqual(unitString, "microseconds")) {
            timeUnit = TimeUnit.MICROSECONDS;
        } else if (Intrinsics.areEqual(unitString, "ns") || Intrinsics.areEqual(unitString, "nanos") || Intrinsics.areEqual(unitString, "nanoseconds")) {
            timeUnit = TimeUnit.NANOSECONDS;
        } else if (Intrinsics.areEqual(unitString, "d") || Intrinsics.areEqual(unitString, "days")) {
            timeUnit = TimeUnit.DAYS;
        } else if (Intrinsics.areEqual(unitString, "h") || Intrinsics.areEqual(unitString, "hours")) {
            timeUnit = TimeUnit.HOURS;
        } else if (Intrinsics.areEqual(unitString, "s") || Intrinsics.areEqual(unitString, "seconds")) {
            timeUnit = TimeUnit.SECONDS;
        } else if (Intrinsics.areEqual(unitString, "m") || Intrinsics.areEqual(unitString, "minutes")) {
            timeUnit = TimeUnit.MINUTES;
        } else {
            throw (Throwable)new ParseException("Could not parse time unit '" + originalUnitString + "' (try ns, us, ms, s, m, h, d)");
        }
        TimeUnit units = timeUnit;
        try {
            long l2;
            CharSequence charSequence2 = numberString;
            Object object = "[+-]?[0-9]+";
            bl2 = false;
            object = new Regex((String)object);
            bl2 = false;
            if (((Regex)object).matches(charSequence2)) {
                l2 = units.toNanos(Long.parseLong(numberString));
            } else {
                long nanosInUnit = units.toNanos(1L);
                l2 = (long)(Double.parseDouble(numberString) * (double)nanosInUnit);
            }
            l = l2;
        }
        catch (NumberFormatException e) {
            throw (Throwable)new ParseException("Could not parse duration number '" + numberString + '\'');
        }
        return l;
    }
}

