/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.parser.node.AbstractExecutor;
import org.apache.velocity.util.introspection.Introspector;
import org.slf4j.Logger;

public class PublicFieldExecutor
extends AbstractExecutor {
    private final Introspector introspector;
    private Field field = null;

    public PublicFieldExecutor(Logger log, Introspector introspector, Class clazz, String property) {
        this.log = log;
        this.introspector = introspector;
        if (StringUtils.isNotEmpty(property)) {
            this.discover(clazz, property);
        }
    }

    @Override
    public boolean isAlive() {
        return this.getField() != null;
    }

    public Field getField() {
        return this.field;
    }

    protected void setField(Field field) {
        this.field = field;
    }

    protected Introspector getIntrospector() {
        return this.introspector;
    }

    protected void discover(Class clazz, String property) {
        try {
            this.setField(this.introspector.getField(clazz, property));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Exception while looking for public field '" + property;
            this.log.error(msg, e);
            throw new VelocityException(msg, e);
        }
    }

    @Override
    public Object execute(Object o) throws IllegalAccessException, InvocationTargetException {
        return this.isAlive() ? this.getField().get(o) : null;
    }
}

