/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.velocity.util.introspection.Converter;
import org.apache.velocity.util.introspection.IntrospectionUtils;
import org.apache.velocity.util.introspection.TypeConversionHandler;

public class TypeConversionHandlerImpl
implements TypeConversionHandler {
    static Map<Pair<String, String>, Converter> standardConverterMap = new HashMap<Pair<String, String>, Converter>();
    static Converter toString;
    static Converter cacheMiss;
    static final long minByte = -128L;
    static final long maxByte = 127L;
    static final long minShort = -32768L;
    static final long maxShort = 32767L;
    static final long minInt = Integer.MIN_VALUE;
    static final long maxInt = Integer.MAX_VALUE;
    static final double minLong = -9.223372036854776E18;
    static final double maxLong = 9.223372036854776E18;
    Map<Pair<String, String>, Converter> converterCacheMap = new ConcurrentHashMap<Pair<String, String>, Converter>();
    static final String BOOLEAN_TYPE = "boolean";
    static final String BYTE_TYPE = "byte";
    static final String SHORT_TYPE = "short";
    static final String INTEGER_TYPE = "int";
    static final String LONG_TYPE = "long";
    static final String FLOAT_TYPE = "float";
    static final String DOUBLE_TYPE = "double";
    static final String CHARACTER_TYPE = "char";
    static final String BOOLEAN_CLASS = "java.lang.Boolean";
    static final String BYTE_CLASS = "java.lang.Byte";
    static final String SHORT_CLASS = "java.lang.Short";
    static final String INTEGER_CLASS = "java.lang.Integer";
    static final String LONG_CLASS = "java.lang.Long";
    static final String FLOAT_CLASS = "java.lang.Float";
    static final String DOUBLE_CLASS = "java.lang.Double";
    static final String NUMBER_CLASS = "java.lang.Number";
    static final String CHARACTER_CLASS = "java.lang.Character";
    static final String STRING_CLASS = "java.lang.String";
    static final String LOCALE_CLASS = "java.util.Locale";

    @Override
    public boolean isExplicitlyConvertible(Type formal, Class actual, boolean possibleVarArg) {
        Class formalClass = IntrospectionUtils.getTypeClass(formal);
        if (formalClass != null && formalClass == actual || IntrospectionUtils.isMethodInvocationConvertible(formal, actual, possibleVarArg) || this.getNeededConverter(formal, actual) != null) {
            return true;
        }
        if (possibleVarArg && TypeUtils.isArrayType(formal)) {
            if (actual.isArray()) {
                actual = actual.getComponentType();
            }
            return this.isExplicitlyConvertible(TypeUtils.getArrayComponentType(formal), actual, false);
        }
        return false;
    }

    @Override
    public Converter getNeededConverter(Type formal, Class actual) {
        if (actual == null) {
            return null;
        }
        Pair<String, String> key = Pair.of(formal.getTypeName(), actual.getTypeName());
        Converter converter = standardConverterMap.get(key);
        if (converter == null && (converter = this.converterCacheMap.get(key)) == null) {
            Class formalClass = IntrospectionUtils.getTypeClass(formal);
            if (formal == String.class) {
                converter = toString;
            } else if (formalClass != null && formalClass.isEnum() && actual == String.class) {
                final Class enumClass = formalClass;
                converter = new Converter(){

                    public Object convert(Object o) {
                        return Enum.valueOf(enumClass, (String)o);
                    }
                };
            }
            this.converterCacheMap.put(key, converter == null ? cacheMiss : converter);
        }
        return converter == cacheMiss ? null : converter;
    }

    @Override
    public void addConverter(Type formal, Class actual, Converter converter) {
        Pair<String, String> key = Pair.of(formal.getTypeName(), actual.getTypeName());
        this.converterCacheMap.put(key, converter);
        Class formalClass = IntrospectionUtils.getTypeClass(formal);
        if (formalClass != null) {
            if (formalClass.isPrimitive()) {
                key = Pair.of(IntrospectionUtils.getBoxedClass(formalClass).getTypeName(), actual.getTypeName());
                this.converterCacheMap.put(key, converter);
            } else {
                Class unboxedFormal = IntrospectionUtils.getUnboxedClass(formalClass);
                if (unboxedFormal != formalClass) {
                    key = Pair.of(unboxedFormal.getTypeName(), actual.getTypeName());
                    this.converterCacheMap.put(key, converter);
                }
            }
        }
    }

    static {
        cacheMiss = new Converter<Object>(){

            @Override
            public Object convert(Object o) {
                return o;
            }
        };
        Converter<Boolean> numberToBool = new Converter<Boolean>(){

            @Override
            public Boolean convert(Object o) {
                return o == null ? null : Boolean.valueOf(((Number)o).intValue() != 0);
            }
        };
        standardConverterMap.put(Pair.of(BOOLEAN_CLASS, BYTE_CLASS), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_CLASS, SHORT_CLASS), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_CLASS, INTEGER_CLASS), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_CLASS, LONG_CLASS), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_CLASS, FLOAT_CLASS), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_CLASS, DOUBLE_CLASS), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_CLASS, NUMBER_CLASS), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_CLASS, BYTE_TYPE), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_CLASS, SHORT_TYPE), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_CLASS, INTEGER_TYPE), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_CLASS, LONG_TYPE), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_CLASS, FLOAT_TYPE), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_CLASS, DOUBLE_TYPE), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_TYPE, BYTE_CLASS), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_TYPE, SHORT_CLASS), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_TYPE, INTEGER_CLASS), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_TYPE, LONG_CLASS), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_TYPE, FLOAT_CLASS), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_TYPE, DOUBLE_CLASS), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_TYPE, NUMBER_CLASS), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_TYPE, BYTE_TYPE), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_TYPE, SHORT_TYPE), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_TYPE, INTEGER_TYPE), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_TYPE, LONG_TYPE), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_TYPE, FLOAT_TYPE), numberToBool);
        standardConverterMap.put(Pair.of(BOOLEAN_TYPE, DOUBLE_TYPE), numberToBool);
        Converter<Boolean> charToBoolean = new Converter<Boolean>(){

            @Override
            public Boolean convert(Object o) {
                return o == null ? null : Boolean.valueOf(((Character)o).charValue() != '\u0000');
            }
        };
        standardConverterMap.put(Pair.of(BOOLEAN_CLASS, CHARACTER_CLASS), charToBoolean);
        standardConverterMap.put(Pair.of(BOOLEAN_CLASS, CHARACTER_TYPE), charToBoolean);
        standardConverterMap.put(Pair.of(BOOLEAN_TYPE, CHARACTER_CLASS), charToBoolean);
        standardConverterMap.put(Pair.of(BOOLEAN_TYPE, CHARACTER_TYPE), charToBoolean);
        Converter<Boolean> stringToBoolean = new Converter<Boolean>(){

            @Override
            public Boolean convert(Object o) {
                return Boolean.valueOf(String.valueOf(o));
            }
        };
        standardConverterMap.put(Pair.of(BOOLEAN_CLASS, STRING_CLASS), stringToBoolean);
        standardConverterMap.put(Pair.of(BOOLEAN_TYPE, STRING_CLASS), stringToBoolean);
        Converter<Byte> narrowingToByte = new Converter<Byte>(){

            @Override
            public Byte convert(Object o) {
                if (o == null) {
                    return null;
                }
                long l = ((Number)o).longValue();
                if (l < -128L || l > 127L) {
                    throw new NumberFormatException("value out of range for byte type: " + l);
                }
                return ((Number)o).byteValue();
            }
        };
        standardConverterMap.put(Pair.of(BYTE_CLASS, SHORT_CLASS), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_CLASS, INTEGER_CLASS), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_CLASS, LONG_CLASS), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_CLASS, FLOAT_CLASS), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_CLASS, DOUBLE_CLASS), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_CLASS, NUMBER_CLASS), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_CLASS, SHORT_TYPE), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_CLASS, INTEGER_TYPE), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_CLASS, LONG_TYPE), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_CLASS, FLOAT_TYPE), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_CLASS, DOUBLE_TYPE), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_TYPE, SHORT_CLASS), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_TYPE, INTEGER_CLASS), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_TYPE, LONG_CLASS), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_TYPE, FLOAT_CLASS), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_TYPE, DOUBLE_CLASS), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_TYPE, NUMBER_CLASS), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_TYPE, SHORT_TYPE), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_TYPE, INTEGER_TYPE), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_TYPE, LONG_TYPE), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_TYPE, FLOAT_TYPE), narrowingToByte);
        standardConverterMap.put(Pair.of(BYTE_TYPE, DOUBLE_TYPE), narrowingToByte);
        Converter<Byte> stringToByte = new Converter<Byte>(){

            @Override
            public Byte convert(Object o) {
                return Byte.valueOf(String.valueOf(o));
            }
        };
        standardConverterMap.put(Pair.of(BYTE_CLASS, STRING_CLASS), stringToByte);
        standardConverterMap.put(Pair.of(BYTE_TYPE, STRING_CLASS), stringToByte);
        Converter<Short> narrowingToShort = new Converter<Short>(){

            @Override
            public Short convert(Object o) {
                if (o == null) {
                    return null;
                }
                long l = ((Number)o).longValue();
                if (l < -32768L || l > 32767L) {
                    throw new NumberFormatException("value out of range for short type: " + l);
                }
                return ((Number)o).shortValue();
            }
        };
        standardConverterMap.put(Pair.of(SHORT_CLASS, INTEGER_CLASS), narrowingToShort);
        standardConverterMap.put(Pair.of(SHORT_CLASS, LONG_CLASS), narrowingToShort);
        standardConverterMap.put(Pair.of(SHORT_CLASS, FLOAT_CLASS), narrowingToShort);
        standardConverterMap.put(Pair.of(SHORT_CLASS, DOUBLE_CLASS), narrowingToShort);
        standardConverterMap.put(Pair.of(SHORT_CLASS, NUMBER_CLASS), narrowingToShort);
        standardConverterMap.put(Pair.of(SHORT_CLASS, INTEGER_TYPE), narrowingToShort);
        standardConverterMap.put(Pair.of(SHORT_CLASS, LONG_TYPE), narrowingToShort);
        standardConverterMap.put(Pair.of(SHORT_CLASS, FLOAT_TYPE), narrowingToShort);
        standardConverterMap.put(Pair.of(SHORT_CLASS, DOUBLE_TYPE), narrowingToShort);
        standardConverterMap.put(Pair.of(SHORT_TYPE, INTEGER_CLASS), narrowingToShort);
        standardConverterMap.put(Pair.of(SHORT_TYPE, LONG_CLASS), narrowingToShort);
        standardConverterMap.put(Pair.of(SHORT_TYPE, FLOAT_CLASS), narrowingToShort);
        standardConverterMap.put(Pair.of(SHORT_TYPE, DOUBLE_CLASS), narrowingToShort);
        standardConverterMap.put(Pair.of(SHORT_TYPE, NUMBER_CLASS), narrowingToShort);
        standardConverterMap.put(Pair.of(SHORT_TYPE, INTEGER_TYPE), narrowingToShort);
        standardConverterMap.put(Pair.of(SHORT_TYPE, LONG_TYPE), narrowingToShort);
        standardConverterMap.put(Pair.of(SHORT_TYPE, FLOAT_TYPE), narrowingToShort);
        standardConverterMap.put(Pair.of(SHORT_TYPE, DOUBLE_TYPE), narrowingToShort);
        Converter<Short> stringToShort = new Converter<Short>(){

            @Override
            public Short convert(Object o) {
                return Short.valueOf(String.valueOf(o));
            }
        };
        standardConverterMap.put(Pair.of(SHORT_CLASS, STRING_CLASS), stringToShort);
        standardConverterMap.put(Pair.of(SHORT_TYPE, STRING_CLASS), stringToShort);
        Converter<Integer> narrowingToInteger = new Converter<Integer>(){

            @Override
            public Integer convert(Object o) {
                if (o == null) {
                    return null;
                }
                long l = ((Number)o).longValue();
                if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                    throw new NumberFormatException("value out of range for integer type: " + l);
                }
                return ((Number)o).intValue();
            }
        };
        standardConverterMap.put(Pair.of(INTEGER_CLASS, LONG_CLASS), narrowingToInteger);
        standardConverterMap.put(Pair.of(INTEGER_CLASS, FLOAT_CLASS), narrowingToInteger);
        standardConverterMap.put(Pair.of(INTEGER_CLASS, DOUBLE_CLASS), narrowingToInteger);
        standardConverterMap.put(Pair.of(INTEGER_CLASS, NUMBER_CLASS), narrowingToInteger);
        standardConverterMap.put(Pair.of(INTEGER_CLASS, LONG_TYPE), narrowingToInteger);
        standardConverterMap.put(Pair.of(INTEGER_CLASS, FLOAT_TYPE), narrowingToInteger);
        standardConverterMap.put(Pair.of(INTEGER_CLASS, DOUBLE_TYPE), narrowingToInteger);
        standardConverterMap.put(Pair.of(INTEGER_TYPE, LONG_CLASS), narrowingToInteger);
        standardConverterMap.put(Pair.of(INTEGER_TYPE, FLOAT_CLASS), narrowingToInteger);
        standardConverterMap.put(Pair.of(INTEGER_TYPE, DOUBLE_CLASS), narrowingToInteger);
        standardConverterMap.put(Pair.of(INTEGER_TYPE, NUMBER_CLASS), narrowingToInteger);
        standardConverterMap.put(Pair.of(INTEGER_TYPE, LONG_TYPE), narrowingToInteger);
        standardConverterMap.put(Pair.of(INTEGER_TYPE, FLOAT_TYPE), narrowingToInteger);
        standardConverterMap.put(Pair.of(INTEGER_TYPE, DOUBLE_TYPE), narrowingToInteger);
        Converter<Integer> wideningToInteger = new Converter<Integer>(){

            @Override
            public Integer convert(Object o) {
                if (o == null) {
                    return null;
                }
                return ((Number)o).intValue();
            }
        };
        standardConverterMap.put(Pair.of(INTEGER_CLASS, SHORT_CLASS), wideningToInteger);
        standardConverterMap.put(Pair.of(INTEGER_CLASS, SHORT_TYPE), wideningToInteger);
        Converter<Integer> stringToInteger = new Converter<Integer>(){

            @Override
            public Integer convert(Object o) {
                return Integer.valueOf(String.valueOf(o));
            }
        };
        standardConverterMap.put(Pair.of(INTEGER_CLASS, STRING_CLASS), stringToInteger);
        standardConverterMap.put(Pair.of(INTEGER_TYPE, STRING_CLASS), stringToInteger);
        Converter<Long> narrowingToLong = new Converter<Long>(){

            @Override
            public Long convert(Object o) {
                if (o == null) {
                    return null;
                }
                double d = ((Number)o).doubleValue();
                if (d < -9.223372036854776E18 || d > 9.223372036854776E18) {
                    throw new NumberFormatException("value out of range for long type: " + d);
                }
                return ((Number)o).longValue();
            }
        };
        standardConverterMap.put(Pair.of(LONG_CLASS, FLOAT_CLASS), narrowingToLong);
        standardConverterMap.put(Pair.of(LONG_CLASS, DOUBLE_CLASS), narrowingToLong);
        standardConverterMap.put(Pair.of(LONG_CLASS, NUMBER_CLASS), narrowingToLong);
        standardConverterMap.put(Pair.of(LONG_CLASS, FLOAT_TYPE), narrowingToLong);
        standardConverterMap.put(Pair.of(LONG_CLASS, DOUBLE_TYPE), narrowingToLong);
        standardConverterMap.put(Pair.of(LONG_TYPE, FLOAT_CLASS), narrowingToLong);
        standardConverterMap.put(Pair.of(LONG_TYPE, DOUBLE_CLASS), narrowingToLong);
        standardConverterMap.put(Pair.of(LONG_TYPE, NUMBER_CLASS), narrowingToLong);
        standardConverterMap.put(Pair.of(LONG_TYPE, FLOAT_TYPE), narrowingToLong);
        standardConverterMap.put(Pair.of(LONG_TYPE, DOUBLE_TYPE), narrowingToLong);
        Converter<Long> wideningToLong = new Converter<Long>(){

            @Override
            public Long convert(Object o) {
                if (o == null) {
                    return null;
                }
                return ((Number)o).longValue();
            }
        };
        standardConverterMap.put(Pair.of(LONG_CLASS, SHORT_CLASS), wideningToLong);
        standardConverterMap.put(Pair.of(LONG_CLASS, INTEGER_CLASS), wideningToLong);
        standardConverterMap.put(Pair.of(LONG_CLASS, SHORT_TYPE), wideningToLong);
        standardConverterMap.put(Pair.of(LONG_CLASS, INTEGER_TYPE), wideningToLong);
        Converter<Long> stringToLong = new Converter<Long>(){

            @Override
            public Long convert(Object o) {
                return Long.valueOf(String.valueOf(o));
            }
        };
        standardConverterMap.put(Pair.of(LONG_CLASS, STRING_CLASS), stringToLong);
        standardConverterMap.put(Pair.of(LONG_TYPE, STRING_CLASS), stringToLong);
        Converter<Float> narrowingToFloat = new Converter<Float>(){

            @Override
            public Float convert(Object o) {
                return o == null ? null : Float.valueOf(((Number)o).floatValue());
            }
        };
        standardConverterMap.put(Pair.of(FLOAT_CLASS, DOUBLE_CLASS), narrowingToFloat);
        standardConverterMap.put(Pair.of(FLOAT_CLASS, NUMBER_CLASS), narrowingToFloat);
        standardConverterMap.put(Pair.of(FLOAT_CLASS, DOUBLE_TYPE), narrowingToFloat);
        standardConverterMap.put(Pair.of(FLOAT_TYPE, DOUBLE_CLASS), narrowingToFloat);
        standardConverterMap.put(Pair.of(FLOAT_TYPE, NUMBER_CLASS), narrowingToFloat);
        standardConverterMap.put(Pair.of(FLOAT_TYPE, DOUBLE_TYPE), narrowingToFloat);
        Converter<Float> toFloat = new Converter<Float>(){

            @Override
            public Float convert(Object o) {
                if (o == null) {
                    return null;
                }
                return Float.valueOf(((Number)o).floatValue());
            }
        };
        standardConverterMap.put(Pair.of(FLOAT_CLASS, SHORT_CLASS), toFloat);
        standardConverterMap.put(Pair.of(FLOAT_CLASS, INTEGER_CLASS), toFloat);
        standardConverterMap.put(Pair.of(FLOAT_CLASS, LONG_CLASS), toFloat);
        standardConverterMap.put(Pair.of(FLOAT_CLASS, SHORT_TYPE), toFloat);
        standardConverterMap.put(Pair.of(FLOAT_CLASS, INTEGER_TYPE), toFloat);
        standardConverterMap.put(Pair.of(FLOAT_CLASS, LONG_TYPE), toFloat);
        Converter<Float> stringToFloat = new Converter<Float>(){

            @Override
            public Float convert(Object o) {
                return Float.valueOf(String.valueOf(o));
            }
        };
        standardConverterMap.put(Pair.of(FLOAT_CLASS, STRING_CLASS), stringToFloat);
        standardConverterMap.put(Pair.of(FLOAT_TYPE, STRING_CLASS), stringToFloat);
        Converter<Double> toDouble = new Converter<Double>(){

            @Override
            public Double convert(Object o) {
                if (o == null) {
                    return null;
                }
                return ((Number)o).doubleValue();
            }
        };
        standardConverterMap.put(Pair.of(DOUBLE_CLASS, SHORT_CLASS), toDouble);
        standardConverterMap.put(Pair.of(DOUBLE_CLASS, INTEGER_CLASS), toDouble);
        standardConverterMap.put(Pair.of(DOUBLE_CLASS, LONG_CLASS), toDouble);
        standardConverterMap.put(Pair.of(DOUBLE_CLASS, FLOAT_CLASS), toDouble);
        standardConverterMap.put(Pair.of(DOUBLE_CLASS, NUMBER_CLASS), toDouble);
        standardConverterMap.put(Pair.of(DOUBLE_CLASS, SHORT_TYPE), toDouble);
        standardConverterMap.put(Pair.of(DOUBLE_CLASS, INTEGER_TYPE), toDouble);
        standardConverterMap.put(Pair.of(DOUBLE_CLASS, LONG_TYPE), toDouble);
        standardConverterMap.put(Pair.of(DOUBLE_CLASS, FLOAT_TYPE), toDouble);
        standardConverterMap.put(Pair.of(DOUBLE_TYPE, NUMBER_CLASS), toDouble);
        Converter<Double> stringToDouble = new Converter<Double>(){

            @Override
            public Double convert(Object o) {
                return Double.valueOf(String.valueOf(o));
            }
        };
        standardConverterMap.put(Pair.of(DOUBLE_CLASS, STRING_CLASS), stringToDouble);
        standardConverterMap.put(Pair.of(DOUBLE_TYPE, STRING_CLASS), stringToDouble);
        Converter<Byte> booleanToByte = new Converter<Byte>(){

            @Override
            public Byte convert(Object o) {
                return o == null ? null : Byte.valueOf((Boolean)o != false ? (byte)1 : 0);
            }
        };
        standardConverterMap.put(Pair.of(BYTE_CLASS, BOOLEAN_CLASS), booleanToByte);
        standardConverterMap.put(Pair.of(BYTE_CLASS, BOOLEAN_TYPE), booleanToByte);
        standardConverterMap.put(Pair.of(BYTE_TYPE, BOOLEAN_CLASS), booleanToByte);
        standardConverterMap.put(Pair.of(BYTE_TYPE, BOOLEAN_TYPE), booleanToByte);
        Converter<Short> booleanToShort = new Converter<Short>(){

            @Override
            public Short convert(Object o) {
                return o == null ? null : Short.valueOf((Boolean)o != false ? (short)1 : 0);
            }
        };
        standardConverterMap.put(Pair.of(SHORT_CLASS, BOOLEAN_CLASS), booleanToShort);
        standardConverterMap.put(Pair.of(SHORT_CLASS, BOOLEAN_TYPE), booleanToShort);
        standardConverterMap.put(Pair.of(SHORT_TYPE, BOOLEAN_CLASS), booleanToShort);
        standardConverterMap.put(Pair.of(SHORT_TYPE, BOOLEAN_TYPE), booleanToShort);
        Converter<Integer> booleanToInteger = new Converter<Integer>(){

            @Override
            public Integer convert(Object o) {
                return o == null ? null : ((Boolean)o != false ? Integer.valueOf(1) : Integer.valueOf(0));
            }
        };
        standardConverterMap.put(Pair.of(INTEGER_CLASS, BOOLEAN_CLASS), booleanToInteger);
        standardConverterMap.put(Pair.of(INTEGER_CLASS, BOOLEAN_TYPE), booleanToInteger);
        standardConverterMap.put(Pair.of(INTEGER_TYPE, BOOLEAN_CLASS), booleanToInteger);
        standardConverterMap.put(Pair.of(INTEGER_TYPE, BOOLEAN_TYPE), booleanToInteger);
        Converter<Long> booleanToLong = new Converter<Long>(){

            @Override
            public Long convert(Object o) {
                return o == null ? null : Long.valueOf((Boolean)o != false ? 1L : 0L);
            }
        };
        standardConverterMap.put(Pair.of(LONG_CLASS, BOOLEAN_CLASS), booleanToLong);
        standardConverterMap.put(Pair.of(LONG_CLASS, BOOLEAN_TYPE), booleanToLong);
        standardConverterMap.put(Pair.of(LONG_TYPE, BOOLEAN_CLASS), booleanToLong);
        standardConverterMap.put(Pair.of(LONG_TYPE, BOOLEAN_TYPE), booleanToLong);
        toString = new Converter<String>(){

            @Override
            public String convert(Object o) {
                return String.valueOf(o);
            }
        };
        Converter<Locale> stringToLocale = new Converter<Locale>(){

            @Override
            public Locale convert(Object o) {
                return o == null ? null : LocaleUtils.toLocale((String)o);
            }
        };
        standardConverterMap.put(Pair.of(LOCALE_CLASS, STRING_CLASS), stringToLocale);
    }
}

