/*
 * Decompiled with CFR 0.152.
 */
package org.berndpruenster.netlayer.tor;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.berndpruenster.netlayer.tor.OsType;
import org.berndpruenster.netlayer.tor.TorKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0003\u001a\f\u0010\t\u001a\u00020\u0001*\u00020\u0005H\u0000\u00a8\u0006\n"}, d2={"cleanInstallOneFile", "", "readFrom", "Ljava/io/InputStream;", "fileToWriteTo", "Ljava/io/File;", "extractContentFromArchive", "destinationDirectory", "archiveInputStream", "log", "tor"})
public final class FileUtilitiesKt {
    public static final void log(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.isDirectory()) {
            Object[] $receiver$iv = $receiver.listFiles();
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                File it = (File)element$iv;
                FileUtilitiesKt.log(it);
            }
        } else {
            TorKt.getLogger().info($receiver.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void cleanInstallOneFile(@NotNull InputStream readFrom, @NotNull File fileToWriteTo) {
        Intrinsics.checkParameterIsNotNull((Object)readFrom, (String)"readFrom");
        Intrinsics.checkParameterIsNotNull((Object)fileToWriteTo, (String)"fileToWriteTo");
        if (fileToWriteTo.exists() && !fileToWriteTo.delete()) {
            throw (Throwable)new RuntimeException("Could not remove existing file " + fileToWriteTo.getName());
        }
        Object object = fileToWriteTo;
        object = new FileOutputStream((File)object);
        int n = 8192;
        object = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
        n = 0;
        try {
            BufferedOutputStream out = (BufferedOutputStream)object;
            long l = ByteStreamsKt.copyTo$default((InputStream)readFrom, (OutputStream)out, (int)0, (int)2, null);
        }
        catch (Exception exception) {
            try {
                n = 1;
                try {
                    object.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            catch (Throwable throwable) {
                if (n == 0) {
                    object.close();
                }
                throw throwable;
            }
        }
        object.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void extractContentFromArchive(@NotNull File destinationDirectory, @NotNull InputStream archiveInputStream) {
        Intrinsics.checkParameterIsNotNull((Object)destinationDirectory, (String)"destinationDirectory");
        Intrinsics.checkParameterIsNotNull((Object)archiveInputStream, (String)"archiveInputStream");
        Closeable closeable = (Closeable)new TarArchiveInputStream((InputStream)new XZCompressorInputStream(archiveInputStream));
        boolean bl = false;
        try {
            TarArchiveInputStream tarIn = (TarArchiveInputStream)closeable;
            ArchiveEntry entry = tarIn.getNextEntry();
            while (entry != null) {
                File f = new File(destinationDirectory.getCanonicalPath() + File.separator + StringsKt.replace$default((String)entry.getName(), (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null));
                if (entry.isDirectory()) {
                    if (!f.exists() && !f.mkdirs()) {
                        throw (Throwable)new IOException("could not create directory " + f);
                    }
                } else {
                    if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
                        throw (Throwable)new IOException("could not create directory  " + f.getParentFile());
                    }
                    if (f.exists() && !f.delete()) {
                        throw (Throwable)new RuntimeException("Could not delete file " + f.getAbsolutePath() + " in preparation for overwriting it");
                    }
                    if (!f.createNewFile()) {
                        throw (Throwable)new RuntimeException("Could not create file " + f);
                    }
                    Closeable closeable2 = new FileOutputStream(f);
                    boolean bl2 = false;
                    try {
                        FileOutputStream outStream = (FileOutputStream)closeable2;
                        ByteStreamsKt.copyTo$default((InputStream)((InputStream)tarIn), (OutputStream)outStream, (int)0, (int)2, null);
                        ArchiveEntry archiveEntry = entry;
                        if (archiveEntry == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.apache.commons.compress.archivers.tar.TarArchiveEntry");
                        }
                        int mode = ((TarArchiveEntry)archiveEntry).getMode();
                        if ((mode & 0x40) > 0) {
                            f.setExecutable(true, (mode & 1) == 0);
                        }
                        if (Intrinsics.areEqual((Object)((Object)OsType.Companion.getCurrent()), (Object)((Object)OsType.MACOS))) {
                            f.setExecutable(true, true);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Exception exception) {
                        try {
                            bl2 = true;
                            try {
                                closeable2.close();
                                throw (Throwable)exception;
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            throw (Throwable)exception;
                        }
                        catch (Throwable throwable) {
                            if (bl2) throw throwable;
                            closeable2.close();
                            throw throwable;
                        }
                    }
                    closeable2.close();
                }
                entry = (ArchiveEntry)tarIn.getNextTarEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            try {
                bl = true;
                try {
                    closeable.close();
                    throw (Throwable)exception;
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            catch (Throwable throwable) {
                if (bl) throw throwable;
                closeable.close();
                throw throwable;
            }
        }
        closeable.close();
    }
}

