/*
 * Decompiled with CFR 0.152.
 */
package org.berndpruenster.netlayer.tor;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.berndpruenster.netlayer.tor.HiddenServiceSocketAddress;
import org.berndpruenster.netlayer.tor.HsContainer;
import org.berndpruenster.netlayer.tor.Tor;
import org.berndpruenster.netlayer.tor.TorCtlException;
import org.berndpruenster.netlayer.tor.TorEventHandler;
import org.berndpruenster.netlayer.tor.TorSocketsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ)\u0010\u001c\u001a\u00020\u00142!\u0010\u001d\u001a\u001d\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u0010J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\b\u0010\u001f\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR/\u0010\u000e\u001a#\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u0007"}, d2={"Lorg/berndpruenster/netlayer/tor/HiddenServiceSocket;", "Ljava/net/ServerSocket;", "internalPort", "", "hiddenServiceDir", "", "hiddenServicePort", "tor", "Lorg/berndpruenster/netlayer/tor/Tor;", "(ILjava/lang/String;ILorg/berndpruenster/netlayer/tor/Tor;)V", "getHiddenServiceDir", "()Ljava/lang/String;", "getHiddenServicePort", "()I", "listeners", "", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "socket", "", "mgr", "serviceName", "getServiceName", "socketAddress", "Ljava/net/SocketAddress;", "getSocketAddress", "()Ljava/net/SocketAddress;", "addReadyListener", "listener", "close", "toString"})
public final class HiddenServiceSocket
extends ServerSocket {
    private final Tor mgr;
    private final List<Function1<HiddenServiceSocket, Unit>> listeners;
    @NotNull
    private final String serviceName;
    @NotNull
    private final SocketAddress socketAddress;
    @NotNull
    private final String hiddenServiceDir;
    private final int hiddenServicePort;

    @NotNull
    public final String getServiceName() {
        return this.serviceName;
    }

    @NotNull
    public final SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addReadyListener(@NotNull Function1<? super HiddenServiceSocket, Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        List<Function1<HiddenServiceSocket, Unit>> list = this.listeners;
        synchronized (list) {
            boolean bl = this.listeners.add(listener);
        }
    }

    @Override
    @NotNull
    public String toString() {
        return "HiddenServiceSocket[addr=" + this.serviceName + ",port=" + this.hiddenServicePort + ']';
    }

    @Override
    public void close() {
        super.close();
        try {
            this.mgr.unpublishHiddenService(this.hiddenServiceDir);
        }
        catch (TorCtlException e) {
            throw (Throwable)new IOException(e);
        }
    }

    @NotNull
    public final String getHiddenServiceDir() {
        return this.hiddenServiceDir;
    }

    public final int getHiddenServicePort() {
        return this.hiddenServicePort;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public HiddenServiceSocket(int internalPort, @NotNull String hiddenServiceDir, int hiddenServicePort, @Nullable Tor tor) {
        void name;
        List list;
        Intrinsics.checkParameterIsNotNull((Object)hiddenServiceDir, (String)"hiddenServiceDir");
        this.hiddenServiceDir = hiddenServiceDir;
        this.hiddenServicePort = hiddenServicePort;
        this.mgr = TorSocketsKt.access$getTorInstance(tor);
        HiddenServiceSocket hiddenServiceSocket = this;
        hiddenServiceSocket.listeners = list = (List)new ArrayList();
        HsContainer hsContainer = this.mgr.publishHiddenService$tor(this.hiddenServiceDir, this.hiddenServicePort, internalPort);
        String string = hsContainer.component1$tor();
        TorEventHandler handler = hsContainer.component2$tor();
        this.serviceName = name;
        this.socketAddress = new HiddenServiceSocketAddress(this.serviceName, this.hiddenServicePort);
        this.bind(new InetSocketAddress("127.0.0.1", internalPort));
        handler.attachReadyListeners(this, this.listeners);
    }

    @JvmOverloads
    public /* synthetic */ HiddenServiceSocket(int n, String string, int n2, Tor tor, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        if ((n3 & 8) != 0) {
            tor = null;
        }
        this(n, string, n2, tor);
    }

    @JvmOverloads
    public HiddenServiceSocket(int internalPort, @NotNull String hiddenServiceDir, int hiddenServicePort) {
        this(internalPort, hiddenServiceDir, hiddenServicePort, null, 8, null);
    }

    @JvmOverloads
    public HiddenServiceSocket(int internalPort, @NotNull String hiddenServiceDir) {
        this(internalPort, hiddenServiceDir, 0, null, 12, null);
    }
}

