/*
 * Decompiled with CFR 0.152.
 */
package org.berndpruenster.netlayer.tor;

import com.runjva.sourceforge.jsocks.protocol.Authentication;
import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.freehaven.tor.control.ConfigEntry;
import org.berndpruenster.netlayer.tor.Control;
import org.berndpruenster.netlayer.tor.FileUtilitiesKt;
import org.berndpruenster.netlayer.tor.HsContainer;
import org.berndpruenster.netlayer.tor.OsType;
import org.berndpruenster.netlayer.tor.TorContext;
import org.berndpruenster.netlayer.tor.TorController;
import org.berndpruenster.netlayer.tor.TorCtlException;
import org.berndpruenster.netlayer.tor.TorEventHandler;
import org.berndpruenster.netlayer.tor.TorKt;
import org.berndpruenster.netlayer.tor.WriteObserver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 *2\u00020\u0001:\u0001*B!\b\u0005\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0016\u001a\u00020\r2\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0018H\u0003J\u0014\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0006H\u0007J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006J%\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b%J\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\u0006H\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006+"}, d2={"Lorg/berndpruenster/netlayer/tor/Tor;", "", "context", "Lorg/berndpruenster/netlayer/tor/TorContext;", "bridgeLines", "", "", "(Lorg/berndpruenster/netlayer/tor/TorContext;Ljava/util/Collection;)V", "bridgeConfig", "", "getContext", "()Lorg/berndpruenster/netlayer/tor/TorContext;", "control", "Lorg/berndpruenster/netlayer/tor/Control;", "getControl", "()Lorg/berndpruenster/netlayer/tor/Control;", "eventHandler", "Lorg/berndpruenster/netlayer/tor/TorEventHandler;", "workingDirectory", "Ljava/io/File;", "getWorkingDirectory", "()Ljava/io/File;", "bootstrap", "secondsBeforeTimeOut", "", "numberOfRetries", "getProxy", "Lcom/runjva/sourceforge/jsocks/protocol/Socks5Proxy;", "streamID", "isHiddenServiceAvailable", "", "onionUrl", "publishHiddenService", "Lorg/berndpruenster/netlayer/tor/HsContainer;", "hsDirName", "hiddenServicePort", "localPort", "publishHiddenService$tor", "shutdown", "", "unpublishHiddenService", "hsDir", "Companion", "tor"})
public abstract class Tor {
    private final TorEventHandler eventHandler;
    private final List<String> bridgeConfig;
    private final Control control;
    @NotNull
    private final TorContext context;
    @Nullable
    private static Tor default;
    public static final Companion Companion;

    private final Control getControl() {
        if (!this.control.getRunning$tor()) {
            throw (Throwable)new TorCtlException("Tor has already been shutdown!", null, 2, null);
        }
        return this.control;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Control bootstrap(int secondsBeforeTimeOut, int numberOfRetries) throws InterruptedException, IOException {
        TorController control = null;
        try {
            int n = 1;
            int n2 = numberOfRetries;
            if (n <= n2) {
                while (true) {
                    void retryCount;
                    control = this.context.installAndStartTorOp$tor(this.bridgeConfig, this.eventHandler);
                    control.enableNetwork();
                    int n3 = 1;
                    int n4 = secondsBeforeTimeOut;
                    if (n3 <= n4) {
                        while (true) {
                            void secondsWaited;
                            if (control.getBootstrapped()) {
                                Control control2 = new Control(control);
                                return control2;
                            }
                            Thread.sleep(1000L, 0);
                            if (secondsWaited == n4) break;
                            ++secondsWaited;
                        }
                    }
                    control.shutdown();
                    this.context.deleteAllFilesButHS$tor();
                    if (retryCount == n2) break;
                    ++retryCount;
                }
            }
            throw (Throwable)new TorCtlException("Could not setup Tor", null, 2, null);
        }
        finally {
            block10: {
                TorController torController = control;
                if (torController != null && torController.getBootstrapped()) break block10;
                this.context.deleteAllFilesButHS$tor();
                TorController torController2 = control;
                if (torController2 != null) {
                    torController2.shutdown();
                }
            }
        }
    }

    static /* bridge */ /* synthetic */ Control bootstrap$default(Tor tor, int n, int n2, int n3, Object object) throws InterruptedException, IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bootstrap");
        }
        if ((n3 & 1) != 0) {
            n = 240;
        }
        if ((n3 & 2) != 0) {
            n2 = 5;
        }
        return tor.bootstrap(n, n2);
    }

    @JvmOverloads
    @NotNull
    public final Socks5Proxy getProxy(@Nullable String streamID) throws TorCtlException {
        Socks5Proxy proxy;
        block3: {
            String authValue;
            BigInteger bigInteger;
            String string;
            try {
                proxy = new Socks5Proxy("127.0.0.1", this.getControl().getProxyPort$tor());
            }
            catch (IOException e) {
                throw (Throwable)new TorCtlException(null, (Throwable)e, 1, null);
            }
            proxy.resolveAddrLocally(false);
            String string2 = streamID;
            if (string2 == null) break block3;
            String it = string = string2;
            String string3 = streamID;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            BigInteger bigInteger2 = bigInteger;
            BigInteger bigInteger3 = bigInteger;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            bigInteger2(messageDigest.digest(byArray2));
            string3 = authValue = bigInteger3.toString(26);
            charset = Charsets.UTF_8;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray3 = string4.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] hash = byArray3;
            proxy.setAuthenticationMethod(2, new Authentication(authValue, hash){
                final /* synthetic */ String $authValue;
                final /* synthetic */ byte[] $hash;

                @NotNull
                public final Closeable[] doSocksAuthentication(int $noName_0, Socket proxySocket) {
                    TorKt.getLogger().debug("using Stream " + this.$authValue);
                    OutputStream out = proxySocket.getOutputStream();
                    out.write(new byte[]{(byte)1, (byte)this.$hash.length});
                    out.write(this.$hash);
                    out.write(new byte[]{(byte)1, (byte)0});
                    out.flush();
                    byte[] status = new byte[2];
                    proxySocket.getInputStream().read(status);
                    if (status[1] != (byte)0) {
                        throw (Throwable)new IOException("auth error: " + status[1]);
                    }
                    Object[] elements$iv = new Closeable[]{proxySocket.getInputStream(), out};
                    return (Closeable[])elements$iv;
                }
                {
                    this.$authValue = string;
                    this.$hash = byArray;
                }
            });
        }
        return proxy;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Socks5Proxy getProxy$default(Tor tor, String string, int n, Object object) throws TorCtlException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getProxy");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return tor.getProxy(string);
    }

    @JvmOverloads
    @NotNull
    public final Socks5Proxy getProxy() throws TorCtlException {
        return Tor.getProxy$default(this, null, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final HsContainer publishHiddenService$tor(@NotNull String hsDirName, int hiddenServicePort, int localPort) throws IOException, TorCtlException {
        Intrinsics.checkParameterIsNotNull((Object)hsDirName, (String)"hsDirName");
        Control control = this.getControl();
        synchronized (control) {
            List<ConfigEntry> currentHiddenServices = this.getControl().getHiddenServices();
            File hiddenServiceDirectory = this.context.getHiddenServiceDirectory$tor(hsDirName);
            List config = new ArrayList();
            for (ConfigEntry service : currentHiddenServices) {
                if (service.is_default) continue;
                if (Intrinsics.areEqual((Object)service.key, (Object)"HiddenServiceDir") && Intrinsics.areEqual((Object)service.value, (Object)hiddenServiceDirectory.getCanonicalPath())) {
                    throw (Throwable)new TorCtlException("Hidden Service " + hiddenServiceDirectory.getCanonicalPath() + " is already published", null, 2, null);
                }
                config.add("" + service.key + ' ' + service.value);
            }
            TorKt.getLogger().debug("Creating hidden service " + hsDirName);
            File hostnameFile = this.context.getHostNameFile$tor(hsDirName);
            if (!hostnameFile.getParentFile().exists() && !hostnameFile.getParentFile().mkdirs()) {
                throw (Throwable)new TorCtlException("Could not create hostnameFile parent directory", null, 2, null);
            }
            if (!hostnameFile.exists() && !hostnameFile.createNewFile()) {
                throw (Throwable)new TorCtlException("Could not create hostnameFile", null, 2, null);
            }
            try {
                if (OsType.Companion.getCurrent().isUnixoid()) {
                    Set perms = SetsKt.mutableSetOf((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE});
                    Files.setPosixFilePermissions(hiddenServiceDirectory.toPath(), perms);
                }
            }
            catch (Exception e) {
                TorKt.getLogger().error("could not set permissions, hidden service " + hsDirName + " will most probably not work", (Throwable)e);
            }
            this.getControl().enableHiddenServiceEvents();
            WriteObserver hostNameFileObserver = this.context.generateWriteObserver(hostnameFile);
            config.addAll(CollectionsKt.listOf((Object[])new String[]{"HiddenServiceDir " + hostnameFile.getParentFile().getCanonicalPath(), "HiddenServicePort " + hiddenServicePort + " 127.0.0.1:" + localPort}));
            this.getControl().saveConfig(config);
            if (!hostNameFileObserver.poll(30000, TimeUnit.MILLISECONDS)) {
                FileUtilitiesKt.log(hostnameFile.getParentFile());
                throw (Throwable)new RuntimeException("Wait for hidden service hostname file to be created expired.");
            }
            Object object = FilesKt.readBytes((File)hostnameFile);
            Charset charset = Charsets.UTF_8;
            object = new String((byte[])object, charset);
            String hostname = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
            TorKt.getLogger().debug("PUBLISH: Hidden service config has completed: " + config);
            HsContainer hsContainer = new HsContainer(hostname, this.eventHandler);
            return hsContainer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unpublishHiddenService(@NotNull String hsDir) throws TorCtlException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)hsDir, (String)"hsDir");
        Control control = this.getControl();
        synchronized (control) {
            List<ConfigEntry> currentHiddenServices = this.getControl().getHiddenServices();
            File hiddenServiceDirectory = this.context.getHiddenServiceDirectory$tor(hsDir);
            List conf = new ArrayList();
            boolean removeNext = false;
            for (ConfigEntry service : currentHiddenServices) {
                if (removeNext) {
                    removeNext = false;
                    continue;
                }
                if (service.is_default) continue;
                if (Intrinsics.areEqual((Object)service.key, (Object)"HiddenServiceDir") && Intrinsics.areEqual((Object)service.value, (Object)hiddenServiceDirectory.getCanonicalPath())) {
                    removeNext = true;
                    continue;
                }
                conf.add("" + service.key + ' ' + service.value);
            }
            TorKt.getLogger().debug("UNPUBL Hidden service config has completed: " + conf);
            this.getControl().saveConfig(conf);
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean isHiddenServiceAvailable(@NotNull String onionUrl) {
        Intrinsics.checkParameterIsNotNull((Object)onionUrl, (String)"onionUrl");
        return this.getControl().hsAvailable(onionUrl);
    }

    @NotNull
    public final File getWorkingDirectory() {
        return this.context.getWorkingDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        Control control = this.getControl();
        synchronized (control) {
            this.getControl().shutdown$tor();
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    protected final TorContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    protected Tor(@NotNull TorContext context, @Nullable Collection<String> bridgeLines) throws TorCtlException {
        List list;
        Tor tor;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.eventHandler = new TorEventHandler();
        Tor tor2 = this;
        Collection<String> collection = bridgeLines;
        if (collection != null) {
            void $receiver$iv$iv;
            void $receiver$iv;
            object = collection;
            tor = tor2;
            void var4_5 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                String it = (String)element$iv$iv;
                if (!(it.length() > 10)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            tor2 = tor;
            list = list2;
        } else {
            list = CollectionsKt.emptyList();
        }
        tor2.bridgeConfig = list;
        tor = this;
        try {
            Tor tor3 = tor;
            object = Tor.bootstrap$default(this, 0, 0, 3, null);
        }
        catch (Exception $receiver$iv$iv) {
            void e;
            Tor tor4 = tor;
            throw (Throwable)new TorCtlException(null, (Throwable)e, 1, null);
        }
        tor3.control = object;
    }

    public /* synthetic */ Tor(TorContext torContext, Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) throws TorCtlException {
        if ((n & 2) != 0) {
            collection = null;
        }
        this(torContext, collection);
    }

    static {
        Companion = new Companion(null);
    }

    @Nullable
    public static final Tor getDefault() {
        return Companion.getDefault();
    }

    public static final void setDefault(@Nullable Tor tor) {
        Companion.setDefault(tor);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fR&\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lorg/berndpruenster/netlayer/tor/Tor$Companion;", "", "()V", "default", "Lorg/berndpruenster/netlayer/tor/Tor;", "default$annotations", "getDefault", "()Lorg/berndpruenster/netlayer/tor/Tor;", "setDefault", "(Lorg/berndpruenster/netlayer/tor/Tor;)V", "clear", "", "clear$tor", "tor"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void default$annotations() {
        }

        @Nullable
        public final Tor getDefault() {
            return default;
        }

        public final void setDefault(@Nullable Tor tor) {
            default = tor;
        }

        public final void clear$tor() {
            this.setDefault(null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

