/*
 * Decompiled with CFR 0.152.
 */
package org.berndpruenster.netlayer.tor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.freehaven.tor.control.EventHandler;
import net.freehaven.tor.control.TorControlConnection;
import org.berndpruenster.netlayer.tor.FileUtilitiesKt;
import org.berndpruenster.netlayer.tor.OsType;
import org.berndpruenster.netlayer.tor.TorContext;
import org.berndpruenster.netlayer.tor.TorContext$WhenMappings;
import org.berndpruenster.netlayer.tor.TorController;
import org.berndpruenster.netlayer.tor.TorEventHandler;
import org.berndpruenster.netlayer.tor.TorKt;
import org.berndpruenster.netlayer.tor.WriteObserver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 62\u00020\u0001:\u00016B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003H&J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\rH&J\u0015\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b(J\u0016\u0010)\u001a\u00020\u001c2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+H\u0005J#\u0010,\u001a\u00020-2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+2\u0006\u0010.\u001a\u00020/H\u0001\u00a2\u0006\u0002\b0J\b\u00101\u001a\u00020\u001cH\u0016J\u0015\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u000204H\u0000\u00a2\u0006\u0002\b5R\u0014\u0010\u0005\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\rX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0012\u0010\u0012\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0014\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u0012\u0010\u0016\u001a\u00020\rX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\u0018\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0007\u00a8\u00067"}, d2={"Lorg/berndpruenster/netlayer/tor/TorContext;", "", "workingDirectory", "Ljava/io/File;", "(Ljava/io/File;)V", "cookieFile", "getCookieFile$tor", "()Ljava/io/File;", "geoIpFile", "getGeoIpFile$tor", "geoIpv6File", "getGeoIpv6File$tor", "pathToRC", "", "getPathToRC", "()Ljava/lang/String;", "pathToTorExecutable", "getPathToTorExecutable", "processId", "getProcessId", "torExecutableFile", "getTorExecutableFile$tor", "torExecutableFileName", "getTorExecutableFileName", "torrcFile", "getTorrcFile$tor", "getWorkingDirectory", "deleteAllFilesButHS", "", "deleteAllFilesButHS$tor", "generateWriteObserver", "Lorg/berndpruenster/netlayer/tor/WriteObserver;", "file", "getAssetOrResourceByName", "Ljava/io/InputStream;", "fileName", "getHiddenServiceDirectory", "hsDir", "getHiddenServiceDirectory$tor", "getHostNameFile", "getHostNameFile$tor", "installAndConfigureFiles", "bridgeConfig", "", "installAndStartTorOp", "Lorg/berndpruenster/netlayer/tor/TorController;", "eventHandler", "Lorg/berndpruenster/netlayer/tor/TorEventHandler;", "installAndStartTorOp$tor", "installFiles", "setEnvAndWD", "processBuilder", "Ljava/lang/ProcessBuilder;", "setEnvAndWD$tor", "Companion", "tor"})
public abstract class TorContext {
    @NotNull
    private final File geoIpFile;
    @NotNull
    private final File geoIpv6File;
    @NotNull
    private final File torrcFile;
    @NotNull
    private final File cookieFile;
    @NotNull
    private final File workingDirectory;
    @NotNull
    private static final String FILE_TORRC_NATIVE = "torrc.native";
    private static final List<String> EVENTS;
    public static final Companion Companion;

    @NotNull
    protected abstract String getPathToTorExecutable();

    @NotNull
    public abstract String getPathToRC();

    @NotNull
    protected abstract String getTorExecutableFileName();

    @NotNull
    public abstract String getProcessId();

    @NotNull
    public final File getGeoIpFile$tor() {
        return this.geoIpFile;
    }

    @NotNull
    public final File getGeoIpv6File$tor() {
        return this.geoIpv6File;
    }

    @NotNull
    public final File getTorrcFile$tor() {
        return this.torrcFile;
    }

    @NotNull
    public final File getTorExecutableFile$tor() {
        return new File(this.workingDirectory, this.getTorExecutableFileName());
    }

    @NotNull
    public final File getCookieFile$tor() {
        return this.cookieFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installFiles() {
        Closeable closeable;
        Closeable closeable2;
        Closeable closeable3;
        InputStream str22;
        File dotTorDir;
        Thread.sleep(1000L, 0);
        File[] fileArray = this.workingDirectory.listFiles();
        if (fileArray != null) {
            Object[] $receiver$iv = fileArray;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                File it = (File)element$iv;
                String string = it.getAbsolutePath();
                String string2 = this.torrcFile.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"torrcFile.absolutePath");
                if (!StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) continue;
                it.delete();
            }
        }
        if ((dotTorDir = new File(this.workingDirectory, ".tor")).exists()) {
            FilesKt.deleteRecursively((File)dotTorDir);
        }
        if (!this.workingDirectory.exists() && !this.workingDirectory.mkdirs()) {
            throw (Throwable)new RuntimeException("Could not create root directory " + this.workingDirectory + '!');
        }
        Closeable closeable4 = this.getAssetOrResourceByName("geoip");
        boolean bl = false;
        try {
            str22 = (InputStream)closeable4;
            FileUtilitiesKt.cleanInstallOneFile(str22, this.geoIpFile);
            str22 = Unit.INSTANCE;
            closeable3 = closeable4;
        }
        catch (Exception str22) {
            try {
                bl = true;
                try {
                    Closeable closeable5 = closeable4;
                    if (closeable5 != null) {
                        closeable5.close();
                    }
                }
                catch (Exception $i$a$2$use) {
                    // empty catch block
                }
                throw (Throwable)str22;
            }
            catch (Throwable str22) {
                if (!bl) {
                    Closeable closeable6 = closeable4;
                    if (closeable6 != null) {
                        closeable6.close();
                    }
                }
                throw str22;
            }
        }
        if (closeable3 != null) {
            closeable3.close();
        }
        closeable4 = this.getAssetOrResourceByName("geoip6");
        bl = false;
        try {
            str22 = (InputStream)closeable4;
            FileUtilitiesKt.cleanInstallOneFile(str22, this.geoIpv6File);
            str22 = Unit.INSTANCE;
            closeable2 = closeable4;
        }
        catch (Exception str32) {
            try {
                bl = true;
                try {
                    Closeable closeable7 = closeable4;
                    if (closeable7 != null) {
                        closeable7.close();
                    }
                }
                catch (Exception $i$a$3$use) {
                    // empty catch block
                }
                throw (Throwable)str32;
            }
            catch (Throwable str32) {
                if (!bl) {
                    Closeable closeable8 = closeable4;
                    if (closeable8 != null) {
                        closeable8.close();
                    }
                }
                throw str32;
            }
        }
        if (closeable2 != null) {
            closeable2.close();
        }
        closeable4 = this.getAssetOrResourceByName("torrc");
        bl = false;
        try {
            str22 = (InputStream)closeable4;
            FileUtilitiesKt.cleanInstallOneFile(str22, this.torrcFile);
            Unit unit = Unit.INSTANCE;
            closeable = closeable4;
        }
        catch (Exception exception) {
            try {
                bl = true;
                try {
                    Closeable closeable9 = closeable4;
                    if (closeable9 != null) {
                        closeable9.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    Closeable closeable10 = closeable4;
                    if (closeable10 != null) {
                        closeable10.close();
                    }
                }
                throw throwable;
            }
        }
        if (closeable != null) {
            closeable.close();
        }
    }

    public final void setEnvAndWD$tor(@NotNull ProcessBuilder processBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)processBuilder, (String)"processBuilder");
        processBuilder.directory(this.workingDirectory);
        Map<String, String> environment = processBuilder.environment();
        environment.put("HOME", this.workingDirectory.getAbsolutePath());
        switch (TorContext$WhenMappings.$EnumSwitchMapping$0[OsType.Companion.getCurrent().ordinal()]) {
            case 1: 
            case 2: {
                environment.put("LD_LIBRARY_PATH", this.workingDirectory.getAbsolutePath());
            }
        }
    }

    @NotNull
    public final File getHostNameFile$tor(@NotNull String hsDir) {
        Intrinsics.checkParameterIsNotNull((Object)hsDir, (String)"hsDir");
        return new File(this.getHiddenServiceDirectory$tor(hsDir).getCanonicalPath() + "/" + "hostname");
    }

    public final void deleteAllFilesButHS$tor() {
        Thread.sleep(1000L);
        File[] fileArray = this.workingDirectory.listFiles();
        if (fileArray != null) {
            Object[] $receiver$iv = fileArray;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                File it = (File)element$iv;
                if (it.isDirectory()) {
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"hiddenservice") ^ true)) continue;
                    FilesKt.deleteRecursively((File)it);
                    continue;
                }
                if (it.delete()) continue;
                throw (Throwable)new RuntimeException("Could not delete file " + it.getAbsolutePath());
            }
        }
    }

    @NotNull
    public abstract WriteObserver generateWriteObserver(@NotNull File var1);

    @NotNull
    public abstract InputStream getAssetOrResourceByName(@NotNull String var1);

    @NotNull
    public final File getHiddenServiceDirectory$tor(@NotNull String hsDir) {
        Intrinsics.checkParameterIsNotNull((Object)hsDir, (String)"hsDir");
        return new File(this.workingDirectory, "/hiddenservice/" + hsDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final TorController installAndStartTorOp$tor(@NotNull List<String> bridgeConfig, @NotNull TorEventHandler eventHandler) throws IOException {
        Intrinsics.checkParameterIsNotNull(bridgeConfig, (String)"bridgeConfig");
        Intrinsics.checkParameterIsNotNull((Object)eventHandler, (String)"eventHandler");
        this.installAndConfigureFiles(bridgeConfig);
        TorKt.getLogger().info("Starting Tor");
        File cookieFile = this.cookieFile;
        if (!cookieFile.getParentFile().exists() && !cookieFile.getParentFile().mkdirs()) {
            throw (Throwable)new RuntimeException("Could not create cookieFile parent directory");
        }
        if (!cookieFile.exists() && !cookieFile.createNewFile()) {
            throw (Throwable)new RuntimeException("Could not create cookieFile");
        }
        File workingDirectory = this.workingDirectory;
        WriteObserver cookieObserver = this.generateWriteObserver(cookieFile);
        String torPath = this.getTorExecutableFile$tor().getAbsolutePath();
        String configPath = this.torrcFile.getAbsolutePath();
        String pid = this.getProcessId();
        Object[] objectArray = new String[5];
        String string = torPath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"torPath");
        objectArray[0] = string;
        objectArray[1] = "-f";
        String string2 = configPath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"configPath");
        objectArray[2] = string2;
        objectArray[3] = "__OwningControllerProcess";
        objectArray[4] = pid;
        List cmd = CollectionsKt.listOf((Object[])objectArray);
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        this.setEnvAndWD$tor(processBuilder);
        Process torProcess = null;
        TorControlConnection ctrlCon = null;
        try {
            torProcess = processBuilder.start();
            CountDownLatch controlPortCountDownLatch = new CountDownLatch(1);
            AtomicReference port = new AtomicReference();
            InputStream inputStream = torProcess.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"torProcess.inputStream");
            TorContext.Companion.parseBootstrap(inputStream, controlPortCountDownLatch, port);
            InputStream inputStream2 = torProcess.getErrorStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"torProcess.errorStream");
            TorContext.Companion.forwardErr(inputStream2);
            if (Intrinsics.areEqual((Object)((Object)OsType.Companion.getCurrent()), (Object)((Object)OsType.WIN)) ^ true) {
                int exit = torProcess.waitFor();
                torProcess = null;
                if (exit != 0) {
                    throw (Throwable)new IOException("Tor exited with value " + exit);
                }
            }
            if (!cookieObserver.poll(3000, TimeUnit.MILLISECONDS)) {
                FileUtilitiesKt.log(workingDirectory);
                throw (Throwable)new IOException("Auth cookie not created");
            }
            controlPortCountDownLatch.await();
            Object v = port.get();
            Intrinsics.checkExpressionValueIsNotNull(v, (String)"port.get()");
            Socket sock = new Socket("127.0.0.1", ((Number)v).intValue());
            ctrlCon = new TorController(sock);
            ctrlCon.authenticate(FilesKt.readBytes((File)cookieFile));
            ctrlCon.takeOwnership();
            ctrlCon.resetConf((Collection)CollectionsKt.listOf((Object)"__OwningControllerProcess"));
            ctrlCon.setEventHandler((EventHandler)eventHandler);
            ctrlCon.setEvents(TorContext.Companion.getEVENTS());
            TorController torController = (TorController)ctrlCon;
            return torController;
        }
        catch (Exception e) {
            try {
                throw (Throwable)new IOException(e);
            }
            catch (Throwable throwable) {
                block10: {
                    if (ctrlCon != null) break block10;
                    Process process = torProcess;
                    if (process != null) {
                        process.destroy();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void installAndConfigureFiles(@NotNull List<String> bridgeConfig) throws IOException, InterruptedException {
        PrintWriter printWriter;
        Intrinsics.checkParameterIsNotNull(bridgeConfig, (String)"bridgeConfig");
        this.installFiles();
        Closeable closeable = new FileWriter(this.torrcFile, true);
        PrintWriter printWriter2 = printWriter;
        PrintWriter printWriter3 = printWriter;
        int n = 8192;
        BufferedWriter bufferedWriter = closeable instanceof BufferedWriter ? (BufferedWriter)closeable : new BufferedWriter((Writer)closeable, n);
        printWriter2(bufferedWriter);
        closeable = printWriter3;
        n = 0;
        try {
            PrintWriter confWriter = (PrintWriter)closeable;
            confWriter.println();
            confWriter.println("CookieAuthFile " + this.cookieFile.getAbsolutePath());
            confWriter.println("DataDirectory " + this.workingDirectory.getAbsolutePath());
            confWriter.println("GeoIPFile " + this.geoIpFile.getName());
            confWriter.println("GeoIPv6File " + this.geoIpv6File.getName());
            Closeable closeable2 = this.getAssetOrResourceByName(this.getPathToRC());
            Charset charset = Charsets.UTF_8;
            closeable2 = new InputStreamReader((InputStream)closeable2, charset);
            int n2 = 8192;
            closeable2 = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n2);
            n2 = 0;
            try {
                BufferedReader reader2 = (BufferedReader)closeable2;
                confWriter.println();
                TextStreamsKt.forEachLine((Reader)reader2, (Function1)((Function1)new Function1<String, Unit>(confWriter){
                    final /* synthetic */ PrintWriter $confWriter$inlined;
                    {
                        this.$confWriter$inlined = printWriter;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.$confWriter$inlined.println(it);
                    }
                }));
                reader2 = Unit.INSTANCE;
            }
            catch (Exception reader2) {
                try {
                    n2 = 1;
                    try {
                        closeable2.close();
                    }
                    catch (Exception $i$a$1$use) {
                        // empty catch block
                    }
                    throw (Throwable)reader2;
                }
                catch (Throwable reader2) {
                    if (n2 == 0) {
                        closeable2.close();
                    }
                    throw reader2;
                }
            }
            closeable2.close();
            if (!bridgeConfig.isEmpty()) {
                confWriter.println();
                confWriter.println("UseBridges 1");
            }
            Iterable $receiver$iv = bridgeConfig;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                confWriter.print("Bridge ");
                confWriter.println(it);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            try {
                n = 1;
                try {
                    closeable.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            catch (Throwable throwable) {
                if (n == 0) {
                    closeable.close();
                }
                throw throwable;
            }
        }
        closeable.close();
    }

    @NotNull
    public final File getWorkingDirectory() {
        return this.workingDirectory;
    }

    protected TorContext(@NotNull File workingDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)workingDirectory, (String)"workingDirectory");
        this.workingDirectory = workingDirectory;
        this.geoIpFile = new File(this.workingDirectory, "geoip");
        this.geoIpv6File = new File(this.workingDirectory, "geoip6");
        this.torrcFile = new File(this.workingDirectory, "torrc");
        this.cookieFile = new File(this.workingDirectory, ".tor/control_auth_cookie");
    }

    static {
        Companion = new Companion(null);
        FILE_TORRC_NATIVE = FILE_TORRC_NATIVE;
        EVENTS = CollectionsKt.listOf((Object[])new String[]{"CIRC", "WARN", "ERR"});
    }

    @NotNull
    protected static final String getFILE_TORRC_NATIVE() {
        return Companion.getFILE_TORRC_NATIVE();
    }

    private static final List<String> getEVENTS() {
        return TorContext.Companion.getEVENTS();
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\u00058\u0004X\u0085D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/berndpruenster/netlayer/tor/TorContext$Companion;", "", "()V", "EVENTS", "", "", "EVENTS$annotations", "getEVENTS", "()Ljava/util/List;", "FILE_TORRC_NATIVE", "FILE_TORRC_NATIVE$annotations", "getFILE_TORRC_NATIVE", "()Ljava/lang/String;", "forwardErr", "", "inputStream", "Ljava/io/InputStream;", "parseBootstrap", "latch", "Ljava/util/concurrent/CountDownLatch;", "port", "Ljava/util/concurrent/atomic/AtomicReference;", "", "tor"})
    public static final class Companion {
        @JvmStatic
        protected static /* synthetic */ void FILE_TORRC_NATIVE$annotations() {
        }

        @NotNull
        protected final String getFILE_TORRC_NATIVE() {
            return FILE_TORRC_NATIVE;
        }

        @JvmStatic
        private static /* synthetic */ void EVENTS$annotations() {
        }

        private final List<String> getEVENTS() {
            return EVENTS;
        }

        private final void parseBootstrap(InputStream inputStream, CountDownLatch latch, AtomicReference<Integer> port) {
            new Thread(new Runnable(inputStream, port, latch){
                final /* synthetic */ InputStream $inputStream;
                final /* synthetic */ AtomicReference $port;
                final /* synthetic */ CountDownLatch $latch;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    BufferedReader bufferedReader;
                    Thread.currentThread().setName("NFO");
                    Closeable closeable = this.$inputStream;
                    BufferedReader bufferedReader2 = bufferedReader;
                    BufferedReader bufferedReader3 = bufferedReader;
                    Charset charset = Charsets.UTF_8;
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)closeable, charset);
                    bufferedReader2(inputStreamReader);
                    closeable = bufferedReader3;
                    boolean bl = false;
                    try {
                        BufferedReader reader = (BufferedReader)closeable;
                        TextStreamsKt.forEachLine((Reader)reader, (Function1)((Function1)new Function1<String, Unit>(this){
                            final /* synthetic */ parseBootstrap.1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull String it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                TorKt.getLogger().debug((Function0)new Function0<String>(it){
                                    final /* synthetic */ String $it;
                                    {
                                        this.$it = string;
                                        super(0);
                                    }

                                    @NotNull
                                    public final String invoke() {
                                        return this.$it;
                                    }
                                });
                                if (StringsKt.contains$default((CharSequence)it, (CharSequence)"Control listener listening on port ", (boolean)false, (int)2, null)) {
                                    String string = it;
                                    int n = StringsKt.lastIndexOf$default((CharSequence)it, (String)" ", (int)0, (boolean)false, (int)6, null) + 1;
                                    int n2 = it.length() - 1;
                                    AtomicReference atomicReference = this.this$0.$port;
                                    String string2 = string.substring(n, n2);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                    String string3 = string2;
                                    atomicReference.set(Integer.parseInt(string3));
                                    this.this$0.$latch.countDown();
                                }
                            }
                        }));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Exception exception) {
                        try {
                            bl = true;
                            try {
                                closeable.close();
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            throw (Throwable)exception;
                        }
                        catch (Throwable throwable) {
                            if (!bl) {
                                closeable.close();
                            }
                            throw throwable;
                        }
                    }
                    closeable.close();
                }
                {
                    this.$inputStream = inputStream;
                    this.$port = atomicReference;
                    this.$latch = countDownLatch;
                }
            }).start();
        }

        private final void forwardErr(InputStream inputStream) {
            new Thread(new Runnable(inputStream){
                final /* synthetic */ InputStream $inputStream;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    BufferedReader bufferedReader;
                    Thread.currentThread().setName("ERR");
                    Closeable closeable = this.$inputStream;
                    BufferedReader bufferedReader2 = bufferedReader;
                    BufferedReader bufferedReader3 = bufferedReader;
                    Charset charset = Charsets.UTF_8;
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)closeable, charset);
                    bufferedReader2(inputStreamReader);
                    closeable = bufferedReader3;
                    boolean bl = false;
                    try {
                        BufferedReader reader = (BufferedReader)closeable;
                        TextStreamsKt.forEachLine((Reader)reader, (Function1)forwardErr.1.1.INSTANCE);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Exception exception) {
                        try {
                            bl = true;
                            try {
                                closeable.close();
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            throw (Throwable)exception;
                        }
                        catch (Throwable throwable) {
                            if (!bl) {
                                closeable.close();
                            }
                            throw throwable;
                        }
                    }
                    closeable.close();
                }
                {
                    this.$inputStream = inputStream;
                }
            }).start();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

