/*
 Legal Notice: Some portions of the source code contained in this file were
 derived from the source code of Encryption for the Masses 2.02a, which is
 Copyright (c) 1998-2000 Paul Le Roux and which is governed by the 'License
 Agreement for Encryption for the Masses'. Modifications and additions to
 the original source code (contained in this file) and all other portions of
 this file are Copyright (c) 2003-2009 TrueCrypt Foundation and are governed
 by the TrueCrypt License 2.7 the full text of which is contained in the
 file License.txt included in TrueCrypt binary and source code distribution
 packages. */

#include "Tcdefs.h"
#include "Crc.h"
#include "Crypto.h"
#include "Common/Endian.h"
#include "Tests.h"
#include "Xts.h"
#include <string.h>
#include "Pkcs5.h"

typedef struct {
	unsigned __int8 key1[32];
	unsigned __int8 key2[32];
	unsigned __int8 dataUnitNo[8];
	unsigned int blockNo;
	unsigned __int8 plaintext[ENCRYPTION_DATA_UNIT_SIZE];
	unsigned __int8 ciphertext[ENCRYPTION_DATA_UNIT_SIZE];
} XTS_TEST;

#define XTS_TEST_COUNT 5

XTS_TEST XTS_vectors[XTS_TEST_COUNT] = {
/* XTS-AES-256 */
{
	// IEEE 1619 - Vector 10

	{ 0x27, 0x18, 0x28, 0x18, 0x28, 0x45, 0x90, 0x45, 0x23, 0x53, 0x60, 0x28, 0x74, 0x71, 0x35, 0x26, 0x62, 0x49, 0x77, 0x57, 0x24, 0x70, 0x93, 0x69, 0x99, 0x59, 0x57, 0x49, 0x66, 0x96, 0x76, 0x27 },
	{ 0x31, 0x41, 0x59, 0x26, 0x53, 0x58, 0x97, 0x93, 0x23, 0x84, 0x62, 0x64, 0x33, 0x83, 0x27, 0x95, 0x02, 0x88, 0x41, 0x97, 0x16, 0x93, 0x99, 0x37, 0x51, 0x05, 0x82, 0x09, 0x74, 0x94, 0x45, 0x92 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff },
	0,
	{ 
		0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
		0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
		0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
		0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
		0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
		0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
		0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
		0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
		0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
		0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
		0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
		0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
		0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
		0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
		0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
		0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff 
	},
	{ 
		0x1c, 0x3b, 0x3a, 0x10, 0x2f, 0x77, 0x03, 0x86, 0xe4, 0x83, 0x6c, 0x99, 0xe3, 0x70, 0xcf, 0x9b, 0xea, 0x00, 0x80, 0x3f, 0x5e, 0x48, 0x23, 0x57, 0xa4, 0xae, 0x12, 0xd4, 0x14, 0xa3, 0xe6, 0x3b,
		0x5d, 0x31, 0xe2, 0x76, 0xf8, 0xfe, 0x4a, 0x8d, 0x66, 0xb3, 0x17, 0xf9, 0xac, 0x68, 0x3f, 0x44, 0x68, 0x0a, 0x86, 0xac, 0x35, 0xad, 0xfc, 0x33, 0x45, 0xbe, 0xfe, 0xcb, 0x4b, 0xb1, 0x88, 0xfd,
		0x57, 0x76, 0x92, 0x6c, 0x49, 0xa3, 0x09, 0x5e, 0xb1, 0x08, 0xfd, 0x10, 0x98, 0xba, 0xec, 0x70, 0xaa, 0xa6, 0x69, 0x99, 0xa7, 0x2a, 0x82, 0xf2, 0x7d, 0x84, 0x8b, 0x21, 0xd4, 0xa7, 0x41, 0xb0,
		0xc5, 0xcd, 0x4d, 0x5f, 0xff, 0x9d, 0xac, 0x89, 0xae, 0xba, 0x12, 0x29, 0x61, 0xd0, 0x3a, 0x75, 0x71, 0x23, 0xe9, 0x87, 0x0f, 0x8a, 0xcf, 0x10, 0x00, 0x02, 0x08, 0x87, 0x89, 0x14, 0x29, 0xca,
		0x2a, 0x3e, 0x7a, 0x7d, 0x7d, 0xf7, 0xb1, 0x03, 0x55, 0x16, 0x5c, 0x8b, 0x9a, 0x6d, 0x0a, 0x7d, 0xe8, 0xb0, 0x62, 0xc4, 0x50, 0x0d, 0xc4, 0xcd, 0x12, 0x0c, 0x0f, 0x74, 0x18, 0xda, 0xe3, 0xd0,
		0xb5, 0x78, 0x1c, 0x34, 0x80, 0x3f, 0xa7, 0x54, 0x21, 0xc7, 0x90, 0xdf, 0xe1, 0xde, 0x18, 0x34, 0xf2, 0x80, 0xd7, 0x66, 0x7b, 0x32, 0x7f, 0x6c, 0x8c, 0xd7, 0x55, 0x7e, 0x12, 0xac, 0x3a, 0x0f,
		0x93, 0xec, 0x05, 0xc5, 0x2e, 0x04, 0x93, 0xef, 0x31, 0xa1, 0x2d, 0x3d, 0x92, 0x60, 0xf7, 0x9a, 0x28, 0x9d, 0x6a, 0x37, 0x9b, 0xc7, 0x0c, 0x50, 0x84, 0x14, 0x73, 0xd1, 0xa8, 0xcc, 0x81, 0xec,
		0x58, 0x3e, 0x96, 0x45, 0xe0, 0x7b, 0x8d, 0x96, 0x70, 0x65, 0x5b, 0xa5, 0xbb, 0xcf, 0xec, 0xc6, 0xdc, 0x39, 0x66, 0x38, 0x0a, 0xd8, 0xfe, 0xcb, 0x17, 0xb6, 0xba, 0x02, 0x46, 0x9a, 0x02, 0x0a,
		0x84, 0xe1, 0x8e, 0x8f, 0x84, 0x25, 0x20, 0x70, 0xc1, 0x3e, 0x9f, 0x1f, 0x28, 0x9b, 0xe5, 0x4f, 0xbc, 0x48, 0x14, 0x57, 0x77, 0x8f, 0x61, 0x60, 0x15, 0xe1, 0x32, 0x7a, 0x02, 0xb1, 0x40, 0xf1,
		0x50, 0x5e, 0xb3, 0x09, 0x32, 0x6d, 0x68, 0x37, 0x8f, 0x83, 0x74, 0x59, 0x5c, 0x84, 0x9d, 0x84, 0xf4, 0xc3, 0x33, 0xec, 0x44, 0x23, 0x88, 0x51, 0x43, 0xcb, 0x47, 0xbd, 0x71, 0xc5, 0xed, 0xae,
		0x9b, 0xe6, 0x9a, 0x2f, 0xfe, 0xce, 0xb1, 0xbe, 0xc9, 0xde, 0x24, 0x4f, 0xbe, 0x15, 0x99, 0x2b, 0x11, 0xb7, 0x7c, 0x04, 0x0f, 0x12, 0xbd, 0x8f, 0x6a, 0x97, 0x5a, 0x44, 0xa0, 0xf9, 0x0c, 0x29,
		0xa9, 0xab, 0xc3, 0xd4, 0xd8, 0x93, 0x92, 0x72, 0x84, 0xc5, 0x87, 0x54, 0xcc, 0xe2, 0x94, 0x52, 0x9f, 0x86, 0x14, 0xdc, 0xd2, 0xab, 0xa9, 0x91, 0x92, 0x5f, 0xed, 0xc4, 0xae, 0x74, 0xff, 0xac,
		0x6e, 0x33, 0x3b, 0x93, 0xeb, 0x4a, 0xff, 0x04, 0x79, 0xda, 0x9a, 0x41, 0x0e, 0x44, 0x50, 0xe0, 0xdd, 0x7a, 0xe4, 0xc6, 0xe2, 0x91, 0x09, 0x00, 0x57, 0x5d, 0xa4, 0x01, 0xfc, 0x07, 0x05, 0x9f,
		0x64, 0x5e, 0x8b, 0x7e, 0x9b, 0xfd, 0xef, 0x33, 0x94, 0x30, 0x54, 0xff, 0x84, 0x01, 0x14, 0x93, 0xc2, 0x7b, 0x34, 0x29, 0xea, 0xed, 0xb4, 0xed, 0x53, 0x76, 0x44, 0x1a, 0x77, 0xed, 0x43, 0x85,
		0x1a, 0xd7, 0x7f, 0x16, 0xf5, 0x41, 0xdf, 0xd2, 0x69, 0xd5, 0x0d, 0x6a, 0x5f, 0x14, 0xfb, 0x0a, 0xab, 0x1c, 0xbb, 0x4c, 0x15, 0x50, 0xbe, 0x97, 0xf7, 0xab, 0x40, 0x66, 0x19, 0x3c, 0x4c, 0xaa,
		0x77, 0x3d, 0xad, 0x38, 0x01, 0x4b, 0xd2, 0x09, 0x2f, 0xa7, 0x55, 0xc8, 0x24, 0xbb, 0x5e, 0x54, 0xc4, 0xf3, 0x6f, 0xfd, 0xa9, 0xfc, 0xea, 0x70, 0xb9, 0xc6, 0xe6, 0x93, 0xe1, 0x48, 0xc1, 0x51 
	}
},
{
	// IEEE 1619 - Vector 11

	{ 0x27, 0x18, 0x28, 0x18, 0x28, 0x45, 0x90, 0x45, 0x23, 0x53, 0x60, 0x28, 0x74, 0x71, 0x35, 0x26, 0x62, 0x49, 0x77, 0x57, 0x24, 0x70, 0x93, 0x69, 0x99, 0x59, 0x57, 0x49, 0x66, 0x96, 0x76, 0x27 },
	{ 0x31, 0x41, 0x59, 0x26, 0x53, 0x58, 0x97, 0x93, 0x23, 0x84, 0x62, 0x64, 0x33, 0x83, 0x27, 0x95, 0x02, 0x88, 0x41, 0x97, 0x16, 0x93, 0x99, 0x37, 0x51, 0x05, 0x82, 0x09, 0x74, 0x94, 0x45, 0x92 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff },
	0,                                                                                                                                                                                               
	{ 
		0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
		0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
		0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
		0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
		0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
		0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
		0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
		0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
		0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
		0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
		0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
		0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
		0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
		0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
		0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
		0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff 
	},
	{ 
		0x77, 0xa3, 0x12, 0x51, 0x61, 0x8a, 0x15, 0xe6, 0xb9, 0x2d, 0x1d, 0x66, 0xdf, 0xfe, 0x7b, 0x50, 0xb5, 0x0b, 0xad, 0x55, 0x23, 0x05, 0xba, 0x02, 0x17, 0xa6, 0x10, 0x68, 0x8e, 0xff, 0x7e, 0x11,
		0xe1, 0xd0, 0x22, 0x54, 0x38, 0xe0, 0x93, 0x24, 0x2d, 0x6d, 0xb2, 0x74, 0xfd, 0xe8, 0x01, 0xd4, 0xca, 0xe0, 0x6f, 0x20, 0x92, 0xc7, 0x28, 0xb2, 0x47, 0x85, 0x59, 0xdf, 0x58, 0xe8, 0x37, 0xc2,
		0x46, 0x9e, 0xe4, 0xa4, 0xfa, 0x79, 0x4e, 0x4b, 0xbc, 0x7f, 0x39, 0xbc, 0x02, 0x6e, 0x3c, 0xb7, 0x2c, 0x33, 0xb0, 0x88, 0x8f, 0x25, 0xb4, 0xac, 0xf5, 0x6a, 0x2a, 0x98, 0x04, 0xf1, 0xce, 0x6d,
		0x3d, 0x6e, 0x1d, 0xc6, 0xca, 0x18, 0x1d, 0x4b, 0x54, 0x61, 0x79, 0xd5, 0x55, 0x44, 0xaa, 0x77, 0x60, 0xc4, 0x0d, 0x06, 0x74, 0x15, 0x39, 0xc7, 0xe3, 0xcd, 0x9d, 0x2f, 0x66, 0x50, 0xb2, 0x01,
		0x3f, 0xd0, 0xee, 0xb8, 0xc2, 0xb8, 0xe3, 0xd8, 0xd2, 0x40, 0xcc, 0xae, 0x2d, 0x4c, 0x98, 0x32, 0x0a, 0x74, 0x42, 0xe1, 0xc8, 0xd7, 0x5a, 0x42, 0xd6, 0xe6, 0xcf, 0xa4, 0xc2, 0xec, 0xa1, 0x79,
		0x8d, 0x15, 0x8c, 0x7a, 0xec, 0xdf, 0x82, 0x49, 0x0f, 0x24, 0xbb, 0x9b, 0x38, 0xe1, 0x08, 0xbc, 0xda, 0x12, 0xc3, 0xfa, 0xf9, 0xa2, 0x11, 0x41, 0xc3, 0x61, 0x3b, 0x58, 0x36, 0x7f, 0x92, 0x2a,
		0xaa, 0x26, 0xcd, 0x22, 0xf2, 0x3d, 0x70, 0x8d, 0xae, 0x69, 0x9a, 0xd7, 0xcb, 0x40, 0xa8, 0xad, 0x0b, 0x6e, 0x27, 0x84, 0x97, 0x3d, 0xcb, 0x60, 0x56, 0x84, 0xc0, 0x8b, 0x8d, 0x69, 0x98, 0xc6,
		0x9a, 0xac, 0x04, 0x99, 0x21, 0x87, 0x1e, 0xbb, 0x65, 0x30, 0x1a, 0x46, 0x19, 0xca, 0x80, 0xec, 0xb4, 0x85, 0xa3, 0x1d, 0x74, 0x42, 0x23, 0xce, 0x8d, 0xdc, 0x23, 0x94, 0x82, 0x8d, 0x6a, 0x80,
		0x47, 0x0c, 0x09, 0x2f, 0x5b, 0xa4, 0x13, 0xc3, 0x37, 0x8f, 0xa6, 0x05, 0x42, 0x55, 0xc6, 0xf9, 0xdf, 0x44, 0x95, 0x86, 0x2b, 0xbb, 0x32, 0x87, 0x68, 0x1f, 0x93, 0x1b, 0x68, 0x7c, 0x88, 0x8a,
		0xbf, 0x84, 0x4d, 0xfc, 0x8f, 0xc2, 0x83, 0x31, 0xe5, 0x79, 0x92, 0x8c, 0xd1, 0x2b, 0xd2, 0x39, 0x0a, 0xe1, 0x23, 0xcf, 0x03, 0x81, 0x8d, 0x14, 0xde, 0xdd, 0xe5, 0xc0, 0xc2, 0x4c, 0x8a, 0xb0,
		0x18, 0xbf, 0xca, 0x75, 0xca, 0x09, 0x6f, 0x2d, 0x53, 0x1f, 0x3d, 0x16, 0x19, 0xe7, 0x85, 0xf1, 0xad, 0xa4, 0x37, 0xca, 0xb9, 0x2e, 0x98, 0x05, 0x58, 0xb3, 0xdc, 0xe1, 0x47, 0x4a, 0xfb, 0x75,
		0xbf, 0xed, 0xbf, 0x8f, 0xf5, 0x4c, 0xb2, 0x61, 0x8e, 0x02, 0x44, 0xc9, 0xac, 0x0d, 0x3c, 0x66, 0xfb, 0x51, 0x59, 0x8c, 0xd2, 0xdb, 0x11, 0xf9, 0xbe, 0x39, 0x79, 0x1a, 0xbe, 0x44, 0x7c, 0x63,
		0x09, 0x4f, 0x7c, 0x45, 0x3b, 0x7f, 0xf8, 0x7c, 0xb5, 0xbb, 0x36, 0xb7, 0xc7, 0x9e, 0xfb, 0x08, 0x72, 0xd1, 0x70, 0x58, 0xb8, 0x3b, 0x15, 0xab, 0x08, 0x66, 0xad, 0x8a, 0x58, 0x65, 0x6c, 0x5a,
		0x7e, 0x20, 0xdb, 0xdf, 0x30, 0x8b, 0x24, 0x61, 0xd9, 0x7c, 0x0e, 0xc0, 0x02, 0x4a, 0x27, 0x15, 0x05, 0x52, 0x49, 0xcf, 0x3b, 0x47, 0x8d, 0xdd, 0x47, 0x40, 0xde, 0x65, 0x4f, 0x75, 0xca, 0x68,
		0x6e, 0x0d, 0x73, 0x45, 0xc6, 0x9e, 0xd5, 0x0c, 0xdc, 0x2a, 0x8b, 0x33, 0x2b, 0x1f, 0x88, 0x24, 0x10, 0x8a, 0xc9, 0x37, 0xeb, 0x05, 0x05, 0x85, 0x60, 0x8e, 0xe7, 0x34, 0x09, 0x7f, 0xc0, 0x90,
		0x54, 0xfb, 0xff, 0x89, 0xee, 0xae, 0xea, 0x79, 0x1f, 0x4a, 0x7a, 0xb1, 0xf9, 0x86, 0x82, 0x94, 0xa4, 0xf9, 0xe2, 0x7b, 0x42, 0xaf, 0x81, 0x00, 0xcb, 0x9d, 0x59, 0xce, 0xf9, 0x64, 0x58, 0x03 
	}
},
{
	// IEEE 1619 - Vector 12

	{ 0x27, 0x18, 0x28, 0x18, 0x28, 0x45, 0x90, 0x45, 0x23, 0x53, 0x60, 0x28, 0x74, 0x71, 0x35, 0x26, 0x62, 0x49, 0x77, 0x57, 0x24, 0x70, 0x93, 0x69, 0x99, 0x59, 0x57, 0x49, 0x66, 0x96, 0x76, 0x27 },
	{ 0x31, 0x41, 0x59, 0x26, 0x53, 0x58, 0x97, 0x93, 0x23, 0x84, 0x62, 0x64, 0x33, 0x83, 0x27, 0x95, 0x02, 0x88, 0x41, 0x97, 0x16, 0x93, 0x99, 0x37, 0x51, 0x05, 0x82, 0x09, 0x74, 0x94, 0x45, 0x92 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff },
	0,                                                                                                                                                                                       
	{ 
		0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
		0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
		0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
		0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
		0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
		0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
		0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
		0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
		0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
		0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
		0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
		0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
		0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
		0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
		0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
		0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff 
	},
	{ 
		0xe3, 0x87, 0xaa, 0xa5, 0x8b, 0xa4, 0x83, 0xaf, 0xa7, 0xe8, 0xeb, 0x46, 0x97, 0x78, 0x31, 0x7e, 0xcf, 0x4c, 0xf5, 0x73, 0xaa, 0x9d, 0x4e, 0xac, 0x23, 0xf2, 0xcd, 0xf9, 0x14, 0xe4, 0xe2, 0x00,
		0xa8, 0xb4, 0x90, 0xe4, 0x2e, 0xe6, 0x46, 0x80, 0x2d, 0xc6, 0xee, 0x2b, 0x47, 0x1b, 0x27, 0x81, 0x95, 0xd6, 0x09, 0x18, 0xec, 0xec, 0xb4, 0x4b, 0xf7, 0x99, 0x66, 0xf8, 0x3f, 0xab, 0xa0, 0x49,
		0x92, 0x98, 0xeb, 0xc6, 0x99, 0xc0, 0xc8, 0x63, 0x47, 0x15, 0xa3, 0x20, 0xbb, 0x4f, 0x07, 0x5d, 0x62, 0x2e, 0x74, 0xc8, 0xc9, 0x32, 0x00, 0x4f, 0x25, 0xb4, 0x1e, 0x36, 0x10, 0x25, 0xb5, 0xa8,
		0x78, 0x15, 0x39, 0x1f, 0x61, 0x08, 0xfc, 0x4a, 0xfa, 0x6a, 0x05, 0xd9, 0x30, 0x3c, 0x6b, 0xa6, 0x8a, 0x12, 0x8a, 0x55, 0x70, 0x5d, 0x41, 0x59, 0x85, 0x83, 0x2f, 0xde, 0xaa, 0xe6, 0xc8, 0xe1,
		0x91, 0x10, 0xe8, 0x4d, 0x1b, 0x1f, 0x19, 0x9a, 0x26, 0x92, 0x11, 0x9e, 0xdc, 0x96, 0x13, 0x26, 0x58, 0xf0, 0x9d, 0xa7, 0xc6, 0x23, 0xef, 0xce, 0xc7, 0x12, 0x53, 0x7a, 0x3d, 0x94, 0xc0, 0xbf,
		0x5d, 0x7e, 0x35, 0x2e, 0xc9, 0x4a, 0xe5, 0x79, 0x7f, 0xdb, 0x37, 0x7d, 0xc1, 0x55, 0x11, 0x50, 0x72, 0x1a, 0xdf, 0x15, 0xbd, 0x26, 0xa8, 0xef, 0xc2, 0xfc, 0xaa, 0xd5, 0x68, 0x81, 0xfa, 0x9e,
		0x62, 0x46, 0x2c, 0x28, 0xf3, 0x0a, 0xe1, 0xce, 0xac, 0xa9, 0x3c, 0x34, 0x5c, 0xf2, 0x43, 0xb7, 0x3f, 0x54, 0x2e, 0x20, 0x74, 0xa7, 0x05, 0xbd, 0x26, 0x43, 0xbb, 0x9f, 0x7c, 0xc7, 0x9b, 0xb6,
		0xe7, 0x09, 0x1e, 0xa6, 0xe2, 0x32, 0xdf, 0x0f, 0x9a, 0xd0, 0xd6, 0xcf, 0x50, 0x23, 0x27, 0x87, 0x6d, 0x82, 0x20, 0x7a, 0xbf, 0x21, 0x15, 0xcd, 0xac, 0xf6, 0xd5, 0xa4, 0x8f, 0x6c, 0x18, 0x79,
		0xa6, 0x5b, 0x11, 0x5f, 0x0f, 0x8b, 0x3c, 0xb3, 0xc5, 0x9d, 0x15, 0xdd, 0x8c, 0x76, 0x9b, 0xc0, 0x14, 0x79, 0x5a, 0x18, 0x37, 0xf3, 0x90, 0x1b, 0x58, 0x45, 0xeb, 0x49, 0x1a, 0xdf, 0xef, 0xe0,
		0x97, 0xb1, 0xfa, 0x30, 0xa1, 0x2f, 0xc1, 0xf6, 0x5b, 0xa2, 0x29, 0x05, 0x03, 0x15, 0x39, 0x97, 0x1a, 0x10, 0xf2, 0xf3, 0x6c, 0x32, 0x1b, 0xb5, 0x13, 0x31, 0xcd, 0xef, 0xb3, 0x9e, 0x39, 0x64,
		0xc7, 0xef, 0x07, 0x99, 0x94, 0xf5, 0xb6, 0x9b, 0x2e, 0xdd, 0x83, 0xa7, 0x1e, 0xf5, 0x49, 0x97, 0x1e, 0xe9, 0x3f, 0x44, 0xea, 0xc3, 0x93, 0x8f, 0xcd, 0xd6, 0x1d, 0x01, 0xfa, 0x71, 0x79, 0x9d,
		0xa3, 0xa8, 0x09, 0x1c, 0x4c, 0x48, 0xaa, 0x9e, 0xd2, 0x63, 0xff, 0x07, 0x49, 0xdf, 0x95, 0xd4, 0x4f, 0xef, 0x6a, 0x0b, 0xb5, 0x78, 0xec, 0x69, 0x45, 0x6a, 0xa5, 0x40, 0x8a, 0xe3, 0x2c, 0x7a,
		0xf0, 0x8a, 0xd7, 0xba, 0x89, 0x21, 0x28, 0x7e, 0x3b, 0xbe, 0xe3, 0x1b, 0x76, 0x7b, 0xe0, 0x6a, 0x0e, 0x70, 0x5c, 0x86, 0x4a, 0x76, 0x91, 0x37, 0xdf, 0x28, 0x29, 0x22, 0x83, 0xea, 0x81, 0xa2,
		0x48, 0x02, 0x41, 0xb4, 0x4d, 0x99, 0x21, 0xcd, 0xbe, 0xc1, 0xbc, 0x28, 0xdc, 0x1f, 0xda, 0x11, 0x4b, 0xd8, 0xe5, 0x21, 0x7a, 0xc9, 0xd8, 0xeb, 0xaf, 0xa7, 0x20, 0xe9, 0xda, 0x4f, 0x9a, 0xce,
		0x23, 0x1c, 0xc9, 0x49, 0xe5, 0xb9, 0x6f, 0xe7, 0x6f, 0xfc, 0x21, 0x06, 0x3f, 0xdd, 0xc8, 0x3a, 0x6b, 0x86, 0x79, 0xc0, 0x0d, 0x35, 0xe0, 0x95, 0x76, 0xa8, 0x75, 0x30, 0x5b, 0xed, 0x5f, 0x36,
		0xed, 0x24, 0x2c, 0x89, 0x00, 0xdd, 0x1f, 0xa9, 0x65, 0xbc, 0x95, 0x0d, 0xfc, 0xe0, 0x9b, 0x13, 0x22, 0x63, 0xa1, 0xee, 0xf5, 0x2d, 0xd6, 0x88, 0x8c, 0x30, 0x9f, 0x5a, 0x7d, 0x71, 0x28, 0x26 
	}
},
{
	// IEEE 1619 - Vector 13

	{ 0x27, 0x18, 0x28, 0x18, 0x28, 0x45, 0x90, 0x45, 0x23, 0x53, 0x60, 0x28, 0x74, 0x71, 0x35, 0x26, 0x62, 0x49, 0x77, 0x57, 0x24, 0x70, 0x93, 0x69, 0x99, 0x59, 0x57, 0x49, 0x66, 0x96, 0x76, 0x27 },
	{ 0x31, 0x41, 0x59, 0x26, 0x53, 0x58, 0x97, 0x93, 0x23, 0x84, 0x62, 0x64, 0x33, 0x83, 0x27, 0x95, 0x02, 0x88, 0x41, 0x97, 0x16, 0x93, 0x99, 0x37, 0x51, 0x05, 0x82, 0x09, 0x74, 0x94, 0x45, 0x92 },
	{ 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff },
	0,                                                                                                                                                                                               
	{ 
		0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
		0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
		0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
		0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
		0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
		0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
		0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
		0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
		0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
		0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
		0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
		0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
		0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
		0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
		0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
		0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff 
	},
	{ 
		0xbf, 0x53, 0xd2, 0xda, 0xde, 0x78, 0xe8, 0x22, 0xa4, 0xd9, 0x49, 0xa9, 0xbc, 0x67, 0x66, 0xb0, 0x1b, 0x06, 0xa8, 0xef, 0x70, 0xd2, 0x67, 0x48, 0xc6, 0xa7, 0xfc, 0x36, 0xd8, 0x0a, 0xe4, 0xc5,
		0x52, 0x0f, 0x7c, 0x4a, 0xb0, 0xac, 0x85, 0x44, 0x42, 0x4f, 0xa4, 0x05, 0x16, 0x2f, 0xef, 0x5a, 0x6b, 0x7f, 0x22, 0x94, 0x98, 0x06, 0x36, 0x18, 0xd3, 0x9f, 0x00, 0x03, 0xcb, 0x5f, 0xb8, 0xd1,
		0xc8, 0x6b, 0x64, 0x34, 0x97, 0xda, 0x1f, 0xf9, 0x45, 0xc8, 0xd3, 0xbe, 0xde, 0xca, 0x4f, 0x47, 0x97, 0x02, 0xa7, 0xa7, 0x35, 0xf0, 0x43, 0xdd, 0xb1, 0xd6, 0xaa, 0xad, 0xe3, 0xc4, 0xa0, 0xac,
		0x7c, 0xa7, 0xf3, 0xfa, 0x52, 0x79, 0xbe, 0xf5, 0x6f, 0x82, 0xcd, 0x7a, 0x2f, 0x38, 0x67, 0x2e, 0x82, 0x48, 0x14, 0xe1, 0x07, 0x00, 0x30, 0x0a, 0x05, 0x5e, 0x16, 0x30, 0xb8, 0xf1, 0xcb, 0x0e,
		0x91, 0x9f, 0x5e, 0x94, 0x20, 0x10, 0xa4, 0x16, 0xe2, 0xbf, 0x48, 0xcb, 0x46, 0x99, 0x3d, 0x3c, 0xb6, 0xa5, 0x1c, 0x19, 0xba, 0xcf, 0x86, 0x47, 0x85, 0xa0, 0x0b, 0xc2, 0xec, 0xff, 0x15, 0xd3,
		0x50, 0x87, 0x5b, 0x24, 0x6e, 0xd5, 0x3e, 0x68, 0xbe, 0x6f, 0x55, 0xbd, 0x7e, 0x05, 0xcf, 0xc2, 0xb2, 0xed, 0x64, 0x32, 0x19, 0x8a, 0x64, 0x44, 0xb6, 0xd8, 0xc2, 0x47, 0xfa, 0xb9, 0x41, 0xf5,
		0x69, 0x76, 0x8b, 0x5c, 0x42, 0x93, 0x66, 0xf1, 0xd3, 0xf0, 0x0f, 0x03, 0x45, 0xb9, 0x61, 0x23, 0xd5, 0x62, 0x04, 0xc0, 0x1c, 0x63, 0xb2, 0x2c, 0xe7, 0x8b, 0xaf, 0x11, 0x6e, 0x52, 0x5e, 0xd9,
		0x0f, 0xde, 0xa3, 0x9f, 0xa4, 0x69, 0x49, 0x4d, 0x38, 0x66, 0xc3, 0x1e, 0x05, 0xf2, 0x95, 0xff, 0x21, 0xfe, 0xa8, 0xd4, 0xe6, 0xe1, 0x3d, 0x67, 0xe4, 0x7c, 0xe7, 0x22, 0xe9, 0x69, 0x8a, 0x1c,
		0x10, 0x48, 0xd6, 0x8e, 0xbc, 0xde, 0x76, 0xb8, 0x6f, 0xcf, 0x97, 0x6e, 0xab, 0x8a, 0xa9, 0x79, 0x02, 0x68, 0xb7, 0x06, 0x8e, 0x01, 0x7a, 0x8b, 0x9b, 0x74, 0x94, 0x09, 0x51, 0x4f, 0x10, 0x53,
		0x02, 0x7f, 0xd1, 0x6c, 0x37, 0x86, 0xea, 0x1b, 0xac, 0x5f, 0x15, 0xcb, 0x79, 0x71, 0x1e, 0xe2, 0xab, 0xe8, 0x2f, 0x5c, 0xf8, 0xb1, 0x3a, 0xe7, 0x30, 0x30, 0xef, 0x5b, 0x9e, 0x44, 0x57, 0xe7,
		0x5d, 0x13, 0x04, 0xf9, 0x88, 0xd6, 0x2d, 0xd6, 0xfc, 0x4b, 0x94, 0xed, 0x38, 0xba, 0x83, 0x1d, 0xa4, 0xb7, 0x63, 0x49, 0x71, 0xb6, 0xcd, 0x8e, 0xc3, 0x25, 0xd9, 0xc6, 0x1c, 0x00, 0xf1, 0xdf,
		0x73, 0x62, 0x7e, 0xd3, 0x74, 0x5a, 0x5e, 0x84, 0x89, 0xf3, 0xa9, 0x5c, 0x69, 0x63, 0x9c, 0x32, 0xcd, 0x6e, 0x1d, 0x53, 0x7a, 0x85, 0xf7, 0x5c, 0xc8, 0x44, 0x72, 0x6e, 0x8a, 0x72, 0xfc, 0x00,
		0x77, 0xad, 0x22, 0x00, 0x0f, 0x1d, 0x50, 0x78, 0xf6, 0xb8, 0x66, 0x31, 0x8c, 0x66, 0x8f, 0x1a, 0xd0, 0x3d, 0x5a, 0x5f, 0xce, 0xd5, 0x21, 0x9f, 0x2e, 0xab, 0xbd, 0x0a, 0xa5, 0xc0, 0xf4, 0x60,
		0xd1, 0x83, 0xf0, 0x44, 0x04, 0xa0, 0xd6, 0xf4, 0x69, 0x55, 0x8e, 0x81, 0xfa, 0xb2, 0x4a, 0x16, 0x79, 0x05, 0xab, 0x4c, 0x78, 0x78, 0x50, 0x2a, 0xd3, 0xe3, 0x8f, 0xdb, 0xe6, 0x2a, 0x41, 0x55,
		0x6c, 0xec, 0x37, 0x32, 0x57, 0x59, 0x53, 0x3c, 0xe8, 0xf2, 0x5f, 0x36, 0x7c, 0x87, 0xbb, 0x55, 0x78, 0xd6, 0x67, 0xae, 0x93, 0xf9, 0xe2, 0xfd, 0x99, 0xbc, 0xbc, 0x5f, 0x2f, 0xbb, 0xa8, 0x8c,
		0xf6, 0x51, 0x61, 0x39, 0x42, 0x0f, 0xcf, 0xf3, 0xb7, 0x36, 0x1d, 0x86, 0x32, 0x2c, 0x4b, 0xd8, 0x4c, 0x82, 0xf3, 0x35, 0xab, 0xb1, 0x52, 0xc4, 0xa9, 0x34, 0x11, 0x37, 0x3a, 0xaa, 0x82, 0x20 
	}
},
{
	// IEEE 1619 - Vector 14

	/* This vector must always be the last one in XTS_vectors[] because TestSectorBufEncryption() relies on it. */

	{ 0x27, 0x18, 0x28, 0x18, 0x28, 0x45, 0x90, 0x45, 0x23, 0x53, 0x60, 0x28, 0x74, 0x71, 0x35, 0x26, 0x62, 0x49, 0x77, 0x57, 0x24, 0x70, 0x93, 0x69, 0x99, 0x59, 0x57, 0x49, 0x66, 0x96, 0x76, 0x27 },
	{ 0x31, 0x41, 0x59, 0x26, 0x53, 0x58, 0x97, 0x93, 0x23, 0x84, 0x62, 0x64, 0x33, 0x83, 0x27, 0x95, 0x02, 0x88, 0x41, 0x97, 0x16, 0x93, 0x99, 0x37, 0x51, 0x05, 0x82, 0x09, 0x74, 0x94, 0x45, 0x92 },
	{ 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff },
	0, 
	{ 
		0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 
		0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 
		0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 
		0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, 
		0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f, 
		0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf, 
		0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf, 
		0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff, 
		0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 
		0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 
		0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 
		0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, 
		0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f, 
		0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf, 
		0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf, 
		0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff 
	},
	{ 
		0x64, 0x49, 0x7e, 0x5a, 0x83, 0x1e, 0x4a, 0x93, 0x2c, 0x09, 0xbe, 0x3e, 0x53, 0x93, 0x37, 0x6d, 0xaa, 0x59, 0x95, 0x48, 0xb8, 0x16, 0x03, 0x1d, 0x22, 0x4b, 0xbf, 0x50, 0xa8, 0x18, 0xed, 0x23, 
		0x50, 0xea, 0xe7, 0xe9, 0x60, 0x87, 0xc8, 0xa0, 0xdb, 0x51, 0xad, 0x29, 0x0b, 0xd0, 0x0c, 0x1a, 0xc1, 0x62, 0x08, 0x57, 0x63, 0x5b, 0xf2, 0x46, 0xc1, 0x76, 0xab, 0x46, 0x3b, 0xe3, 0x0b, 0x80, 
		0x8d, 0xa5, 0x48, 0x08, 0x1a, 0xc8, 0x47, 0xb1, 0x58, 0xe1, 0x26, 0x4b, 0xe2, 0x5b, 0xb0, 0x91, 0x0b, 0xbc, 0x92, 0x64, 0x71, 0x08, 0x08, 0x94, 0x15, 0xd4, 0x5f, 0xab, 0x1b, 0x3d, 0x26, 0x04, 
		0xe8, 0xa8, 0xef, 0xf1, 0xae, 0x40, 0x20, 0xcf, 0xa3, 0x99, 0x36, 0xb6, 0x68, 0x27, 0xb2, 0x3f, 0x37, 0x1b, 0x92, 0x20, 0x0b, 0xe9, 0x02, 0x51, 0xe6, 0xd7, 0x3c, 0x5f, 0x86, 0xde, 0x5f, 0xd4, 
		0xa9, 0x50, 0x78, 0x19, 0x33, 0xd7, 0x9a, 0x28, 0x27, 0x2b, 0x78, 0x2a, 0x2e, 0xc3, 0x13, 0xef, 0xdf, 0xcc, 0x06, 0x28, 0xf4, 0x3d, 0x74, 0x4c, 0x2d, 0xc2, 0xff, 0x3d, 0xcb, 0x66, 0x99, 0x9b, 
		0x50, 0xc7, 0xca, 0x89, 0x5b, 0x0c, 0x64, 0x79, 0x1e, 0xea, 0xa5, 0xf2, 0x94, 0x99, 0xfb, 0x1c, 0x02, 0x6f, 0x84, 0xce, 0x5b, 0x5c, 0x72, 0xba, 0x10, 0x83, 0xcd, 0xdb, 0x5c, 0xe4, 0x54, 0x34, 
		0x63, 0x16, 0x65, 0xc3, 0x33, 0xb6, 0x0b, 0x11, 0x59, 0x3f, 0xb2, 0x53, 0xc5, 0x17, 0x9a, 0x2c, 0x8d, 0xb8, 0x13, 0x78, 0x2a, 0x00, 0x48, 0x56, 0xa1, 0x65, 0x30, 0x11, 0xe9, 0x3f, 0xb6, 0xd8, 
		0x76, 0xc1, 0x83, 0x66, 0xdd, 0x86, 0x83, 0xf5, 0x34, 0x12, 0xc0, 0xc1, 0x80, 0xf9, 0xc8, 0x48, 0x59, 0x2d, 0x59, 0x3f, 0x86, 0x09, 0xca, 0x73, 0x63, 0x17, 0xd3, 0x56, 0xe1, 0x3e, 0x2b, 0xff, 
		0x3a, 0x9f, 0x59, 0xcd, 0x9a, 0xeb, 0x19, 0xcd, 0x48, 0x25, 0x93, 0xd8, 0xc4, 0x61, 0x28, 0xbb, 0x32, 0x42, 0x3b, 0x37, 0xa9, 0xad, 0xfb, 0x48, 0x2b, 0x99, 0x45, 0x3f, 0xbe, 0x25, 0xa4, 0x1b, 
		0xf6, 0xfe, 0xb4, 0xaa, 0x0b, 0xef, 0x5e, 0xd2, 0x4b, 0xf7, 0x3c, 0x76, 0x29, 0x78, 0x02, 0x54, 0x82, 0xc1, 0x31, 0x15, 0xe4, 0x01, 0x5a, 0xac, 0x99, 0x2e, 0x56, 0x13, 0xa3, 0xb5, 0xc2, 0xf6, 
		0x85, 0xb8, 0x47, 0x95, 0xcb, 0x6e, 0x9b, 0x26, 0x56, 0xd8, 0xc8, 0x81, 0x57, 0xe5, 0x2c, 0x42, 0xf9, 0x78, 0xd8, 0x63, 0x4c, 0x43, 0xd0, 0x6f, 0xea, 0x92, 0x8f, 0x28, 0x22, 0xe4, 0x65, 0xaa, 
		0x65, 0x76, 0xe9, 0xbf, 0x41, 0x93, 0x84, 0x50, 0x6c, 0xc3, 0xce, 0x3c, 0x54, 0xac, 0x1a, 0x6f, 0x67, 0xdc, 0x66, 0xf3, 0xb3, 0x01, 0x91, 0xe6, 0x98, 0x38, 0x0b, 0xc9, 0x99, 0xb0, 0x5a, 0xbc, 
		0xe1, 0x9d, 0xc0, 0xc6, 0xdc, 0xc2, 0xdd, 0x00, 0x1e, 0xc5, 0x35, 0xba, 0x18, 0xde, 0xb2, 0xdf, 0x1a, 0x10, 0x10, 0x23, 0x10, 0x83, 0x18, 0xc7, 0x5d, 0xc9, 0x86, 0x11, 0xa0, 0x9d, 0xc4, 0x8a, 
		0x0a, 0xcd, 0xec, 0x67, 0x6f, 0xab, 0xdf, 0x22, 0x2f, 0x07, 0xe0, 0x26, 0xf0, 0x59, 0xb6, 0x72, 0xb5, 0x6e, 0x5c, 0xbc, 0x8e, 0x1d, 0x21, 0xbb, 0xd8, 0x67, 0xdd, 0x92, 0x72, 0x12, 0x05, 0x46, 
		0x81, 0xd7, 0x0e, 0xa7, 0x37, 0x13, 0x4c, 0xdf, 0xce, 0x93, 0xb6, 0xf8, 0x2a, 0xe2, 0x24, 0x23, 0x27, 0x4e, 0x58, 0xa0, 0x82, 0x1c, 0xc5, 0x50, 0x2e, 0x2d, 0x0a, 0xb4, 0x58, 0x5e, 0x94, 0xde, 
		0x69, 0x75, 0xbe, 0x5e, 0x0b, 0x4e, 0xfc, 0xe5, 0x1c, 0xd3, 0xe7, 0x0c, 0x25, 0xa1, 0xfb, 0xbb, 0xd6, 0x09, 0xd2, 0x73, 0xad, 0x5b, 0x0d, 0x59, 0x63, 0x1c, 0x53, 0x1f, 0x6a, 0x0a, 0x57, 0xb9 
	}
} };	// XTS_TEST XTS_vectors[]


BOOL XTSAesTest (PCRYPTO_INFO ci)
{
	unsigned __int8 p[ENCRYPTION_DATA_UNIT_SIZE];
	UINT64_STRUCT dataUnitNo;
	int i;

	for (i = 0; i < XTS_TEST_COUNT; i++)
	{
		ci->ea = EAGetByName ("AES");
		if (ci->ea == 0)
			return FALSE;

		ci->mode = XTS;

		if (EAInit (ci->ea, XTS_vectors[i].key1, ci->ks) != ERR_SUCCESS)
			return FALSE;

		memcpy (&ci->k2, XTS_vectors[i].key2, sizeof (XTS_vectors[i].key2));

		if (!EAInitMode (ci))
			return FALSE;

		memcpy (p, XTS_vectors[i].plaintext, sizeof (p));

		dataUnitNo.Value = BE64 (*((unsigned __int64 *) XTS_vectors[i].dataUnitNo));

		EncryptBufferXTS (p, sizeof (p), &dataUnitNo, XTS_vectors[i].blockNo, (unsigned char *) (ci->ks), (unsigned char *) ci->ks2, AES);

		if (memcmp (XTS_vectors[i].ciphertext, p, sizeof (p)) != 0)
			return FALSE;
	}

	return TRUE;
}

/* Blowfish Test Vectors (deprecated/legacy) */

/* Blowfish test vectors from www.counterpane.com/blowfish.html */

#define BF_TEST_COUNT 34

typedef struct {
	unsigned char key[8];
	unsigned char plaintext[8];
	unsigned char ciphertext[8];
	} BF_TEST;

BF_TEST bf_ecb_vectors[BF_TEST_COUNT] = {
"\x00\x00\x00\x00\x00\x00\x00\x00","\x00\x00\x00\x00\x00\x00\x00\x00","\x4E\xF9\x97\x45\x61\x98\xDD\x78",
"\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF","\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF","\x51\x86\x6F\xD5\xB8\x5E\xCB\x8A",
"\x30\x00\x00\x00\x00\x00\x00\x00","\x10\x00\x00\x00\x00\x00\x00\x01","\x7D\x85\x6F\x9A\x61\x30\x63\xF2",
"\x11\x11\x11\x11\x11\x11\x11\x11","\x11\x11\x11\x11\x11\x11\x11\x11","\x24\x66\xDD\x87\x8B\x96\x3C\x9D",
"\x01\x23\x45\x67\x89\xAB\xCD\xEF","\x11\x11\x11\x11\x11\x11\x11\x11","\x61\xF9\xC3\x80\x22\x81\xB0\x96",
"\x11\x11\x11\x11\x11\x11\x11\x11","\x01\x23\x45\x67\x89\xAB\xCD\xEF","\x7D\x0C\xC6\x30\xAF\xDA\x1E\xC7",
"\x00\x00\x00\x00\x00\x00\x00\x00","\x00\x00\x00\x00\x00\x00\x00\x00","\x4E\xF9\x97\x45\x61\x98\xDD\x78",
"\xFE\xDC\xBA\x98\x76\x54\x32\x10","\x01\x23\x45\x67\x89\xAB\xCD\xEF","\x0A\xCE\xAB\x0F\xC6\xA0\xA2\x8D",
"\x7C\xA1\x10\x45\x4A\x1A\x6E\x57","\x01\xA1\xD6\xD0\x39\x77\x67\x42","\x59\xC6\x82\x45\xEB\x05\x28\x2B",
"\x01\x31\xD9\x61\x9D\xC1\x37\x6E","\x5C\xD5\x4C\xA8\x3D\xEF\x57\xDA","\xB1\xB8\xCC\x0B\x25\x0F\x09\xA0",
"\x07\xA1\x13\x3E\x4A\x0B\x26\x86","\x02\x48\xD4\x38\x06\xF6\x71\x72","\x17\x30\xE5\x77\x8B\xEA\x1D\xA4",
"\x38\x49\x67\x4C\x26\x02\x31\x9E","\x51\x45\x4B\x58\x2D\xDF\x44\x0A","\xA2\x5E\x78\x56\xCF\x26\x51\xEB",
"\x04\xB9\x15\xBA\x43\xFE\xB5\xB6","\x42\xFD\x44\x30\x59\x57\x7F\xA2","\x35\x38\x82\xB1\x09\xCE\x8F\x1A",
"\x01\x13\xB9\x70\xFD\x34\xF2\xCE","\x05\x9B\x5E\x08\x51\xCF\x14\x3A","\x48\xF4\xD0\x88\x4C\x37\x99\x18",
"\x01\x70\xF1\x75\x46\x8F\xB5\xE6","\x07\x56\xD8\xE0\x77\x47\x61\xD2","\x43\x21\x93\xB7\x89\x51\xFC\x98",
"\x43\x29\x7F\xAD\x38\xE3\x73\xFE","\x76\x25\x14\xB8\x29\xBF\x48\x6A","\x13\xF0\x41\x54\xD6\x9D\x1A\xE5",
"\x07\xA7\x13\x70\x45\xDA\x2A\x16","\x3B\xDD\x11\x90\x49\x37\x28\x02","\x2E\xED\xDA\x93\xFF\xD3\x9C\x79",
"\x04\x68\x91\x04\xC2\xFD\x3B\x2F","\x26\x95\x5F\x68\x35\xAF\x60\x9A","\xD8\x87\xE0\x39\x3C\x2D\xA6\xE3",
"\x37\xD0\x6B\xB5\x16\xCB\x75\x46","\x16\x4D\x5E\x40\x4F\x27\x52\x32","\x5F\x99\xD0\x4F\x5B\x16\x39\x69",
"\x1F\x08\x26\x0D\x1A\xC2\x46\x5E","\x6B\x05\x6E\x18\x75\x9F\x5C\xCA","\x4A\x05\x7A\x3B\x24\xD3\x97\x7B",
"\x58\x40\x23\x64\x1A\xBA\x61\x76","\x00\x4B\xD6\xEF\x09\x17\x60\x62","\x45\x20\x31\xC1\xE4\xFA\xDA\x8E",
"\x02\x58\x16\x16\x46\x29\xB0\x07","\x48\x0D\x39\x00\x6E\xE7\x62\xF2","\x75\x55\xAE\x39\xF5\x9B\x87\xBD",
"\x49\x79\x3E\xBC\x79\xB3\x25\x8F","\x43\x75\x40\xC8\x69\x8F\x3C\xFA","\x53\xC5\x5F\x9C\xB4\x9F\xC0\x19",
"\x4F\xB0\x5E\x15\x15\xAB\x73\xA7","\x07\x2D\x43\xA0\x77\x07\x52\x92","\x7A\x8E\x7B\xFA\x93\x7E\x89\xA3",
"\x49\xE9\x5D\x6D\x4C\xA2\x29\xBF","\x02\xFE\x55\x77\x81\x17\xF1\x2A","\xCF\x9C\x5D\x7A\x49\x86\xAD\xB5",
"\x01\x83\x10\xDC\x40\x9B\x26\xD6","\x1D\x9D\x5C\x50\x18\xF7\x28\xC2","\xD1\xAB\xB2\x90\x65\x8B\xC7\x78",
"\x1C\x58\x7F\x1C\x13\x92\x4F\xEF","\x30\x55\x32\x28\x6D\x6F\x29\x5A","\x55\xCB\x37\x74\xD1\x3E\xF2\x01",
"\x01\x01\x01\x01\x01\x01\x01\x01","\x01\x23\x45\x67\x89\xAB\xCD\xEF","\xFA\x34\xEC\x48\x47\xB2\x68\xB2",
"\x1F\x1F\x1F\x1F\x0E\x0E\x0E\x0E","\x01\x23\x45\x67\x89\xAB\xCD\xEF","\xA7\x90\x79\x51\x08\xEA\x3C\xAE",
"\xE0\xFE\xE0\xFE\xF1\xFE\xF1\xFE","\x01\x23\x45\x67\x89\xAB\xCD\xEF","\xC3\x9E\x07\x2D\x9F\xAC\x63\x1D",
"\x00\x00\x00\x00\x00\x00\x00\x00","\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF","\x01\x49\x33\xE0\xCD\xAF\xF6\xE4",
"\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF","\x00\x00\x00\x00\x00\x00\x00\x00","\xF2\x1E\x9A\x77\xB7\x1C\x49\xBC",
"\x01\x23\x45\x67\x89\xAB\xCD\xEF","\x00\x00\x00\x00\x00\x00\x00\x00","\x24\x59\x46\x88\x57\x54\x36\x9A",
"\xFE\xDC\xBA\x98\x76\x54\x32\x10","\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF","\x6B\x5C\x5A\x9C\x5D\x9E\x0A\x5A"
};


#define TRIPLEDES_TEST_COUNT 1

typedef struct {
	unsigned char key[24];
	unsigned char plaintext[8];
	unsigned char ciphertext[8];
	} TRIPLEDES_TEST;

TRIPLEDES_TEST tripledes_vectors[TRIPLEDES_TEST_COUNT] = {
0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0xfe, 0xdc, 0xba, 0x98,
0x76, 0x54, 0x32, 0x10, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67,
                              
0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xe7,

0xde, 0x0b, 0x7c, 0x06, 0xae, 0x5e, 0x0e, 0xd5
};

/* CAST-128 Test Vectors from RFC2144 (deprecated/legacy) */

#define CAST_TEST_COUNT 1

typedef struct {
	unsigned char key[16];
	unsigned char plaintext[8];
	unsigned char ciphertext[8];
	} CAST_TEST;


CAST_TEST cast_ecb_vectors[CAST_TEST_COUNT] = {
	"\x01\x23\x45\x67\x12\x34\x56\x78\x23\x45\x67\x89\x34\x56\x78\x9A",
	"\x01\x23\x45\x67\x89\xAB\xCD\xEF",
	"\x23\x8B\x4F\xE5\x84\x7E\x44\xB2"
	};

// AES ECB test vectors FIPS-197

#define AES_TEST_COUNT 1

typedef struct {
	unsigned char key[32];
	unsigned char plaintext[16];
	unsigned char ciphertext[16];
	} AES_TEST;

AES_TEST aes_ecb_vectors[AES_TEST_COUNT] = {
0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,

0x00,0x11,0x22,0x33,0x44,0x55,0x66,0x77,0x88,0x99,0xaa,0xbb,0xcc,0xdd,0xee,0xff,

0x8e,0xa2,0xb7,0xca,0x51,0x67,0x45,0xbf,0xea,0xfc,0x49,0x90,0x4b,0x49,0x60,0x89
};

// Serpent ECB test vectors

#define SERPENT_TEST_COUNT 1

typedef struct {
	unsigned char key[32];
	unsigned char plaintext[16];
	unsigned char ciphertext[16];
	} SERPENT_TEST;

SERPENT_TEST serpent_vectors[SERPENT_TEST_COUNT] = {
0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,

0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
0xde, 0x26, 0x9f, 0xf8, 0x33, 0xe4, 0x32, 0xb8, 0x5b, 0x2e, 0x88, 0xd2, 0x70, 0x1c, 0xe7, 0x5c
};

// Twofish ECB test vectors

#define TWOFISH_TEST_COUNT 1

typedef struct {
	unsigned char key[32];
	unsigned char plaintext[16];
	unsigned char ciphertext[16];
	} TWOFISH_TEST;

TWOFISH_TEST twofish_vectors[TWOFISH_TEST_COUNT] = {
0xD4, 0x3B, 0xB7, 0x55, 0x6E, 0xA3, 0x2E, 0x46, 0xF2, 0xA2, 0x82, 0xB7, 0xD4, 0x5B, 0x4E, 0x0D,
0x57, 0xFF, 0x73, 0x9D, 0x4D, 0xC9, 0x2C, 0x1B, 0xD7, 0xFC, 0x01, 0x70, 0x0C, 0xC8, 0x21, 0x6F,

0x90, 0xAF, 0xE9, 0x1B, 0xB2, 0x88, 0x54, 0x4F, 0x2C, 0x32, 0xDC, 0x23, 0x9B, 0x26, 0x35, 0xE6,
0x6C, 0xB4, 0x56, 0x1C, 0x40, 0xBF, 0x0A, 0x97, 0x05, 0x93, 0x1C, 0xB6, 0xD4, 0x08, 0xE7, 0xFA
};

/* Test vectors from FIPS 198a, RFC 4231, RFC 2104, RFC 2202, and other sources. */

char *hmac_sha512_test_keys[] =
{
	"\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b",
	"Jefe",
	"\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa",
	"\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19",
	"\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa",
	"\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa",
};

char *hmac_sha512_test_data[] =
{
	"Hi There",
	"what do ya want for nothing?",
	"\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd",
	"\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd",
	"Test Using Larger Than Block-Size Key - Hash Key First",
	"This is a test using a larger than block-size key and a larger than block-size data. The key needs to be hashed before being used by the HMAC algorithm.",
};

char *hmac_sha512_test_vectors[] =
{
	"\x87\xaa\x7c\xde\xa5\xef\x61\x9d\x4f\xf0\xb4\x24\x1a\x1d\x6c\xb0\x23\x79\xf4\xe2\xce\x4e\xc2\x78\x7a\xd0\xb3\x05\x45\xe1\x7c\xde\xda\xa8\x33\xb7\xd6\xb8\xa7\x02\x03\x8b\x27\x4e\xae\xa3\xf4\xe4\xbe\x9d\x91\x4e\xeb\x61\xf1\x70\x2e\x69\x6c\x20\x3a\x12\x68\x54",
	"\x16\x4b\x7a\x7b\xfc\xf8\x19\xe2\xe3\x95\xfb\xe7\x3b\x56\xe0\xa3\x87\xbd\x64\x22\x2e\x83\x1f\xd6\x10\x27\x0c\xd7\xea\x25\x05\x54\x97\x58\xbf\x75\xc0\x5a\x99\x4a\x6d\x03\x4f\x65\xf8\xf0\xe6\xfd\xca\xea\xb1\xa3\x4d\x4a\x6b\x4b\x63\x6e\x07\x0a\x38\xbc\xe7\x37",
	"\xfa\x73\xb0\x08\x9d\x56\xa2\x84\xef\xb0\xf0\x75\x6c\x89\x0b\xe9\xb1\xb5\xdb\xdd\x8e\xe8\x1a\x36\x55\xf8\x3e\x33\xb2\x27\x9d\x39\xbf\x3e\x84\x82\x79\xa7\x22\xc8\x06\xb4\x85\xa4\x7e\x67\xc8\x07\xb9\x46\xa3\x37\xbe\xe8\x94\x26\x74\x27\x88\x59\xe1\x32\x92\xfb",
	"\xb0\xba\x46\x56\x37\x45\x8c\x69\x90\xe5\xa8\xc5\xf6\x1d\x4a\xf7\xe5\x76\xd9\x7f\xf9\x4b\x87\x2d\xe7\x6f\x80\x50\x36\x1e\xe3\xdb\xa9\x1c\xa5\xc1\x1a\xa2\x5e\xb4\xd6\x79\x27\x5c\xc5\x78\x80\x63\xa5\xf1\x97\x41\x12\x0c\x4f\x2d\xe2\xad\xeb\xeb\x10\xa2\x98\xdd",
	"\x80\xb2\x42\x63\xc7\xc1\xa3\xeb\xb7\x14\x93\xc1\xdd\x7b\xe8\xb4\x9b\x46\xd1\xf4\x1b\x4a\xee\xc1\x12\x1b\x01\x37\x83\xf8\xf3\x52\x6b\x56\xd0\x37\xe0\x5f\x25\x98\xbd\x0f\xd2\x21\x5d\x6a\x1e\x52\x95\xe6\x4f\x73\xf6\x3f\x0a\xec\x8b\x91\x5a\x98\x5d\x78\x65\x98",
	"\xe3\x7b\x6a\x77\x5d\xc8\x7d\xba\xa4\xdf\xa9\xf9\x6e\x5e\x3f\xfd\xde\xbd\x71\xf8\x86\x72\x89\x86\x5d\xf5\xa3\x2d\x20\xcd\xc9\x44\xb6\x02\x2c\xac\x3c\x49\x82\xb1\x0d\x5e\xeb\x55\xc3\xe4\xde\x15\x13\x46\x76\xfb\x6d\xe0\x44\x60\x65\xc9\x74\x40\xfa\x8c\x6a\x58",
};

char *hmac_sha1_test_keys[] =
{
	// Deprecated/legacy
	"\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5a\x5b\x5c\x5d\x5e\x5f\x60\x61\x62\x63\x64\x65\x66\x67\x68\x69\x6a\x6b\x6c\x6d\x6e\x6f\x70\x71\x72\x73\x74\x75\x76\x77\x78\x79\x7a\x7b\x7c\x7d\x7e\x7f\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f\xa0\xa1\xa2\xa3\xa4\xa5\xa6\xa7\xa8\xa9\xaa\xab\xac\xad\xae\xaf\xb0\xb1\xb2\xb3",
	"\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b",
	"Jefe",
	"\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA"
};

char *hmac_sha1_test_data[] =
{
	// Deprecated/legacy
	"Sample #3",
	"Hi There",
	"what do ya want for nothing?",
	"\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD"
      "\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD"
	"\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD"
};

char *hmac_sha1_test_vectors[] =
{
	// Deprecated/legacy
	"\xbc\xf4\x1e\xab\x8b\xb2\xd8\x02\xf3\xd0\x5c\xaf\x7c\xb0\x92\xec\xf8\xd1\xa3\xaa",
	"\xb6\x17\x31\x86\x55\x05\x72\x64\xe2\x8b\xc0\xb6\xfb\x37\x8c\x8e\xf1\x46\xbe\x00",
	"\xef\xfc\xdf\x6a\xe5\xeb\x2f\xa2\xd2\x74\x16\xd5\xf1\x84\xdf\x9c\x25\x9a\x7c\x79",
	"\x12\x5d\x73\x42\xb9\xac\x11\xcd\x91\xa3\x9a\xf4\x8a\xa1\x7b\x4f\x63\xf1\x75\xd3"
};

char *hmac_ripemd160_test_keys[] =
{
	"\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xaa\xbb\xcc\xdd\xee\xff\x01\x23\x45\x67",
	"\x01\x23\x45\x67\x89\xab\xcd\xef\xfe\xdc\xba\x98\x76\x54\x32\x10\x00\x11\x22\x33",
};

char *hmac_ripemd160_test_data[] =
{
	"message digest",
	"12345678901234567890123456789012345678901234567890123456789012345678901234567890",
};

char *hmac_ripemd160_test_vectors[] =
{
	"\xf8\x36\x62\xcc\x8d\x33\x9c\x22\x7e\x60\x0f\xcd\x63\x6c\x57\xd2\x57\x1b\x1c\x34",
	"\x85\xf1\x64\x70\x3e\x61\xa6\x31\x31\xbe\x7e\x45\x95\x8e\x07\x94\x12\x39\x04\xf9",
};

char *hmac_whirlpool_test_key =
{
	"\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xAA\xBB\xCC\xDD\xEE\xFF\x01\x23\x45\x67\x89\xAB\xCD\xEF\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xAA\xBB\xCC\xDD\xEE\xFF\x01\x23\x45\x67\x89\xAB\xCD\xEF\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xAA\xBB\xCC\xDD\xEE\xFF"
};

char *hmac_whirlpool_test_data =
{
	"abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq"
};

char *hmac_whirlpool_test_vectors =
{
	"\x03\x91\xd2\x80\x00\xb6\x62\xbb\xb8\xe6\x23\x3e\xe8\x6c\xf2\xb2\x84\x74\x4c\x73"
	"\x8b\x58\x00\xba\x28\x12\xed\x52\x6f\xe3\x15\x3a\xb1\xba\xe7\xe2\x36\xbe\x96\x54"
	"\x49\x3f\x19\xfa\xce\xa6\x44\x1f\x60\xf5\xf0\x18\x93\x09\x11\xa5\xe5\xce\xd8\xf2"
	"\x6a\xbf\xa4\x02"
};

unsigned char ks_tmp[MAX_EXPANDED_KEY]; 

void CipherInit2(int cipher, void* key, void* ks, int key_len) 
{
	switch (cipher)
	{
	case BLOWFISH:
		/* Deprecated/legacy */
		BlowfishSetKey (ks, key_len,  key); 
		break;

	case AES:
		CipherInit(cipher,key,ks);
		break;

	case CAST:
		/* Deprecated/legacy */
		CipherInit(cipher,key,ks);
		break;

	case SERPENT:
		CipherInit(cipher,key,ks);
		break;

	case TRIPLEDES:
		/* Deprecated/legacy */
		CipherInit(cipher,key,ks);
		break;

	case TWOFISH:
		CipherInit(cipher,key,ks);
		break;

	default:			
		/* Unknown/wrong ID */
		TC_THROW_FATAL_EXCEPTION;
	}
}


/* Deprecated/legacy */
typedef struct {
	unsigned __int8 key1[32];
	unsigned __int8 key2[16];
	unsigned __int8 index[16];
	unsigned __int8 plaintext[16];
	unsigned __int8 ciphertext[16];
} LRW_TEST;

#define LRW_TEST_COUNT 2

/* Deprecated/legacy */
LRW_TEST lrw_vectors[LRW_TEST_COUNT] = {
	{
		{ 0xf8, 0xd4, 0x76, 0xff, 0xd6, 0x46, 0xee, 0x6c, 0x23, 0x84, 0xcb, 0x1c, 0x77, 0xd6, 0x19, 0x5d,
		  0xfe, 0xf1, 0xa9, 0xf3, 0x7b, 0xbc, 0x8d, 0x21, 0xa7, 0x9c, 0x21, 0xf8, 0xcb, 0x90, 0x02, 0x89 },
		{ 0xa8, 0x45, 0x34, 0x8e, 0xc8, 0xc5, 0xb5, 0xf1, 0x26, 0xf5, 0x0e, 0x76, 0xfe, 0xfd, 0x1b, 0x1e },
		{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 },
		{ 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46 },
		{ 0xbd, 0x06, 0xb8, 0xe1, 0xdb, 0x98, 0x89, 0x9e, 0xc4, 0x98, 0xe4, 0x91, 0xcf, 0x1c, 0x70, 0x2b }
	},
	{
		{ 0xfb, 0x76, 0x15, 0xb2, 0x3d, 0x80, 0x89, 0x1d, 0xd4, 0x70, 0x98, 0x0b, 0xc7, 0x95, 0x84, 0xc8,
		  0xb2, 0xfb, 0x64, 0xce, 0x60, 0x97, 0x87, 0x8d, 0x17, 0xfc, 0xe4, 0x5a, 0x49, 0xe8, 0x30, 0xb7 },
		{ 0x6e, 0x78, 0x17, 0xe7, 0x2d, 0x5e, 0x12, 0xd4, 0x60, 0x64, 0x04, 0x7a, 0xf1, 0x2f, 0x9e, 0x0c },
		{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00 },
		{ 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46 },
		{ 0x5b, 0x90, 0x8e, 0xc1, 0xab, 0xdd, 0x67, 0x5f, 0x3d, 0x69, 0x8a, 0x95, 0x53, 0xc8, 0x9c, 0xe5 }
	}
};


BOOL LRWAesTest (PCRYPTO_INFO ci)
{
	/* Deprecated/legacy */

	unsigned __int8 p[16];
	int i;

	for (i = 0; i < LRW_TEST_COUNT; i++)
	{
		ci->ea = EAGetByName ("AES");
		if (ci->ea == 0)
			return FALSE;

		ci->mode = LRW;

		if (EAInit (ci->ea, lrw_vectors[i].key1, ci->ks) != ERR_SUCCESS)
			return FALSE;

		memcpy (&ci->k2, lrw_vectors[i].key2, sizeof (lrw_vectors[i].key2));
		if (!EAInitMode (ci))
			return FALSE;

		memcpy (p, lrw_vectors[i].plaintext, sizeof (p));

		EncryptBufferLRW128 (p, sizeof (p), BE64(((unsigned __int64 *)(lrw_vectors[i].index))[1]), ci);

		if (memcmp (lrw_vectors[i].ciphertext, p, sizeof (p)) != 0)
			return FALSE;
	}

	return TRUE;
}


BOOL TestSectorBufEncryption (PCRYPTO_INFO ci)
{
	unsigned char buf [ENCRYPTION_DATA_UNIT_SIZE * 4];
	unsigned int i;
	char name[64];
	unsigned __int32 crc;
	UINT64_STRUCT unitNo;
	TC_LARGEST_COMPILER_UINT nbrUnits;
	unsigned __int64 writeOffset;
	int testCase = 0;
	int nTestsPerformed = 0;

	static unsigned char key1[] =
	{ 
		0x27, 0x18, 0x28, 0x18, 0x28, 0x45, 0x90, 0x45, 0x23, 0x53, 0x60, 0x28, 0x74, 0x71, 0x35, 0x26, 0x62, 0x49, 0x77, 0x57, 0x24, 0x70, 0x93, 0x69, 0x99, 0x59, 0x57, 0x49, 0x66, 0x96, 0x76, 0x27,
		0x31, 0x41, 0x59, 0x26, 0x53, 0x58, 0x97, 0x93, 0x23, 0x84, 0x62, 0x64, 0x33, 0x83, 0x27, 0x95, 0x02, 0x88, 0x41, 0x97, 0x16, 0x93, 0x99, 0x37, 0x51, 0x05, 0x82, 0x09, 0x74, 0x94, 0x45, 0x92,
		0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13
	};

	if (!TestLegacySectorBufEncryption (ci))
		return FALSE;


	/* Encryption/decryption of data units (typically, volume data sectors) */

	nbrUnits = sizeof (buf) / ENCRYPTION_DATA_UNIT_SIZE;

	ci->mode = XTS;	// Other modes of operation are tested in TestLegacySectorBufEncryption()

	/* The buffer can accommodate 4 data units and we'll test 4 cases by "scrolling". The data unit 0xFFFFFFFFFF
	will "move" from the start of the buffer to its end. For a 512-byte data unit, the byte offset 562949953420800
	corresponds to the data unit 0xFFFFFFFFFF. */
	for (writeOffset = 562949953420800LL; 
		writeOffset > 562949953420800LL - nbrUnits * ENCRYPTION_DATA_UNIT_SIZE; 
		writeOffset -= ENCRYPTION_DATA_UNIT_SIZE)
	{
		unitNo.Value = writeOffset / ENCRYPTION_DATA_UNIT_SIZE;

		// Test all EAs that support this mode of operation
		for (ci->ea = EAGetFirst (); ci->ea != 0; ci->ea = EAGetNext (ci->ea))
		{
			if (!EAIsModeSupported (ci->ea, ci->mode))
				continue;

			EAGetName (name, ci->ea);

			if (EAInit (ci->ea, key1, ci->ks) != ERR_SUCCESS)
				return FALSE;

			for (i = 0; i < sizeof (ci->k2); i++)
				ci->k2[i] = (unsigned char) i;

			memcpy (&ci->k2, XTS_vectors[XTS_TEST_COUNT-1].key2, sizeof (XTS_vectors[XTS_TEST_COUNT-1].key2));

			if (!EAInitMode (ci))
				return FALSE;

			// Each data unit will contain the same plaintext
			for (i = 0; i < nbrUnits; i++)
			{
				memcpy ((unsigned char *) buf + i * ENCRYPTION_DATA_UNIT_SIZE, 
					XTS_vectors[XTS_TEST_COUNT-1].plaintext, 
					ENCRYPTION_DATA_UNIT_SIZE);
			}

			EncryptDataUnits (buf, &unitNo, nbrUnits, ci);

			crc = GetCrc32 (buf, sizeof (buf));

			if (strcmp (name, "AES") == 0)
			{
				// Verify the ciphertext of the "moving" data unit using the IEEE test vector #14
				if (memcmp (XTS_vectors[XTS_TEST_COUNT-1].ciphertext,
					(unsigned char *) buf + testCase * ENCRYPTION_DATA_UNIT_SIZE,
					ENCRYPTION_DATA_UNIT_SIZE) != 0)
				{
					return FALSE;
				}

				// CRC of all data units in the buffer for each test case
				switch (testCase)
				{
				case 0: 
					if (crc != 0x888f2990)
						return FALSE;
					nTestsPerformed++;
					break;
				case 1:
					if (crc != 0xea28ea34)
						return FALSE;
					nTestsPerformed++;
					break;
				case 2:
					if (crc != 0xe058f5a2)
						return FALSE;
					nTestsPerformed++;
					break;
				case 3:
					if (crc != 0x10473dc9)
						return FALSE;
					nTestsPerformed++;
					break;
				}
			}
			else if (strcmp (name, "Serpent") == 0)
			{
				switch (testCase)
				{
				case 0:
					if (crc != 0x7edfecb3)
						return FALSE;
					nTestsPerformed++;
					break;
				case 1:
					if (crc != 0x357baaaa)
						return FALSE;
					nTestsPerformed++;
					break;
				case 2:
					if (crc != 0xc7b9fca5)
						return FALSE;
					nTestsPerformed++;
					break;
				case 3:
					if (crc != 0xb5263e0c)
						return FALSE;
					nTestsPerformed++;
					break;
				}
			}
			else if (strcmp (name, "Twofish") == 0)
			{
				switch (testCase)
				{
				case 0:
					if (crc != 0x91525124)
						return FALSE;
					nTestsPerformed++;
					break;
				case 1:
					if (crc != 0x2895cc47)
						return FALSE;
					nTestsPerformed++;
					break;
				case 2:
					if (crc != 0x6bee346d)
						return FALSE;
					nTestsPerformed++;
					break;
				case 3:
					if (crc != 0xb1c45759)
						return FALSE;
					nTestsPerformed++;
					break;
				}
			}
			else if (strcmp (name, "AES-Twofish") == 0)
			{
				switch (testCase)
				{
				case 0:
					if (crc != 0x6cea7fa2)
						return FALSE;
					nTestsPerformed++;
					break;
				case 1:
					if (crc != 0x69052c4c)
						return FALSE;
					nTestsPerformed++;
					break;
				case 2:
					if (crc != 0x88db8de5)
						return FALSE;
					nTestsPerformed++;
					break;
				case 3:
					if (crc != 0xf16fd8c5)
						return FALSE;
					nTestsPerformed++;
					break;
				}
			}
			else if (strcmp (name, "AES-Twofish-Serpent") == 0)
			{
				switch (testCase)
				{
				case 0:
					if (crc != 0xa2d7d82a)
						return FALSE;
					nTestsPerformed++;
					break;
				case 1:
					if (crc != 0xdbf76412)
						return FALSE;
					nTestsPerformed++;
					break;
				case 2:
					if (crc != 0xdf0ea03e)
						return FALSE;
					nTestsPerformed++;
					break;
				case 3:
					if (crc != 0xdadedff7)
						return FALSE;
					nTestsPerformed++;
					break;
				}
			}
			else if (strcmp (name, "Serpent-AES") == 0)
			{
				switch (testCase)
				{
				case 0:
					if (crc != 0x6dd133b3)
						return FALSE;
					nTestsPerformed++;
					break;
				case 1:
					if (crc != 0x0e5717d2)
						return FALSE;
					nTestsPerformed++;
					break;
				case 2:
					if (crc != 0x39f83cd9)
						return FALSE;
					nTestsPerformed++;
					break;
				case 3:
					if (crc != 0x8a79fa2c)
						return FALSE;
					nTestsPerformed++;
					break;
				}
			}
			else if (strcmp (name, "Serpent-Twofish-AES") == 0)
			{
				switch (testCase)
				{
				case 0:
					if (crc != 0xe536daf8)
						return FALSE;
					nTestsPerformed++;
					break;
				case 1:
					if (crc != 0x3ae89e7f)
						return FALSE;
					nTestsPerformed++;
					break;
				case 2:
					if (crc != 0x2cc1301a)
						return FALSE;
					nTestsPerformed++;
					break;
				case 3:
					if (crc != 0xcac7bdc7)
						return FALSE;
					nTestsPerformed++;
					break;
				}
			}
			else if (strcmp (name, "Twofish-Serpent") == 0)
			{
				switch (testCase)
				{
				case 0:
					if (crc != 0x2686c859)
						return FALSE;
					nTestsPerformed++;
					break;
				case 1:
					if (crc != 0x8a201780)
						return FALSE;
					nTestsPerformed++;
					break;
				case 2:
					if (crc != 0x8dd13796)
						return FALSE;
					nTestsPerformed++;
					break;
				case 3:
					if (crc != 0xe95196cb)
						return FALSE;
					nTestsPerformed++;
					break;
				}
			}

			if (crc == 0x9f5edd58)
				return FALSE;

			DecryptDataUnits (buf, &unitNo, nbrUnits, ci);

			if (GetCrc32 (buf, sizeof (buf)) != 0x9f5edd58)
				return FALSE;

			nTestsPerformed++;
		}
		testCase++;
	}

	/* Encryption/decryption of a buffer (typically, a volume header) */

	nbrUnits = sizeof (buf) / ENCRYPTION_DATA_UNIT_SIZE;

	// Test all EAs that support this mode of operation
	for (ci->ea = EAGetFirst (); ci->ea != 0; ci->ea = EAGetNext (ci->ea))
	{
		if (!EAIsModeSupported (ci->ea, ci->mode))
			continue;

		EAGetName (name, ci->ea);

		if (EAInit (ci->ea, key1, ci->ks) != ERR_SUCCESS)
			return FALSE;

		memcpy (&ci->k2, XTS_vectors[XTS_TEST_COUNT-1].key2, sizeof (XTS_vectors[XTS_TEST_COUNT-1].key2));

		if (!EAInitMode (ci))
			return FALSE;

		// Each data unit will contain the same plaintext
		for (i = 0; i < nbrUnits; i++)
		{
			memcpy ((unsigned char *) buf + i * ENCRYPTION_DATA_UNIT_SIZE, 
				XTS_vectors[XTS_TEST_COUNT-1].plaintext, 
				ENCRYPTION_DATA_UNIT_SIZE);
		}

		EncryptBuffer (buf, sizeof (buf), ci);

		crc = GetCrc32 (buf, sizeof (buf));

		if (strcmp (name, "AES") == 0)
		{
			if (crc != 0x33b91fab)
				return FALSE;
			nTestsPerformed++;
		}
		else if (strcmp (name, "Serpent") == 0)
		{
			if (crc != 0x3494d480)
				return FALSE;
			nTestsPerformed++;
		}
		else if (strcmp (name, "Twofish") == 0)
		{
			if (crc != 0xc4d65b46)
				return FALSE;
			nTestsPerformed++;
		}
		else if (strcmp (name, "AES-Twofish") == 0)
		{
			if (crc != 0x14ce7385)
				return FALSE;
			nTestsPerformed++;
		}
		else if (strcmp (name, "AES-Twofish-Serpent") == 0)
		{
			if (crc != 0x0ec81bf7)
				return FALSE;
			nTestsPerformed++;
		}
		else if (strcmp (name, "Serpent-AES") == 0)
		{
			if (crc != 0x42f919ad)
				return FALSE;
			nTestsPerformed++;
		}
		else if (strcmp (name, "Serpent-Twofish-AES") == 0)
		{
			if (crc != 0x208d5c58)
				return FALSE;
			nTestsPerformed++;
		}
		else if (strcmp (name, "Twofish-Serpent") == 0)
		{
			if (crc != 0xbe78cec1)
				return FALSE;
			nTestsPerformed++;
		}

		if (crc == 0x9f5edd58)
			return FALSE;

		DecryptBuffer (buf, sizeof (buf), ci);

		if (GetCrc32 (buf, sizeof (buf)) != 0x9f5edd58)
			return FALSE;

		nTestsPerformed++;
	}

	return (nTestsPerformed == 80);
}


BOOL TestLegacySectorBufEncryption (PCRYPTO_INFO ci)
{
	unsigned char buf [ENCRYPTION_DATA_UNIT_SIZE * 2];
	unsigned int i;
	char name[64];
	unsigned __int32 crc;
	UINT64_STRUCT unitNo;
	TC_LARGEST_COMPILER_UINT nbrUnits;
	int blockSize;
	BOOL lrw64InitDone = FALSE;
	BOOL lrw128InitDone = FALSE;
	int nTestsPerformed = 0;

	unitNo.Value = 0x0234567890ABCDEFull;
	nbrUnits = sizeof (buf) / ENCRYPTION_DATA_UNIT_SIZE;

	for (i = 0; i < sizeof (buf); i++)
		buf[i] = (unsigned char) i;

	for (i = 0; i < sizeof (ci->k2); i++)
		ci->k2[i] = (unsigned char) i;

	// Test all EAs
	for (ci->ea = EAGetFirst (); ci->ea != 0; ci->ea = EAGetNext (ci->ea))
	{
		EAGetName (name, ci->ea);
		blockSize = CipherGetBlockSize (EAGetFirstCipher (ci->ea));

		if (EAInit (ci->ea, (unsigned char *)buf, ci->ks) == ERR_CIPHER_INIT_FAILURE)
			return FALSE;

		// Test all deprecated modes of operation
		for (ci->mode = EAGetFirstMode (ci->ea);
			ci->mode != 0;
			ci->mode = EAGetNextMode (ci->ea, ci->mode))
		{
			// Skip modes that are not deprecated
			if (ci->mode == XTS)
				continue;

			if (ci->mode == LRW
				&& (blockSize == 8 && !lrw64InitDone || blockSize == 16 && !lrw128InitDone ))
			{
				if (!EAInitMode (ci))
					return FALSE;

				if (blockSize == 8)
					lrw64InitDone = TRUE;
				else if (blockSize == 16)
					lrw128InitDone = TRUE;
			}

			EncryptDataUnits (buf, &unitNo, nbrUnits, ci);
			crc = GetCrc32 (buf, sizeof (buf));

			switch (ci->mode)
			{
			case LRW:		// Deprecated/legacy
				if (strcmp (name, "AES") == 0)
				{
					if (crc != 0x5237acf9)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Blowfish") == 0)	// Deprecated/legacy
				{
					if (crc != 0xf94d5300)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "CAST5") == 0)		// Deprecated/legacy
				{
					if (crc != 0x33971e82)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Serpent") == 0)
				{
					if (crc != 0x7fb86805)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Triple DES") == 0)	// Deprecated/legacy
				{
					if (crc != 0x2b20bb84)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Twofish") == 0)
				{
					if (crc != 0xa9de0f0b)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "AES-Twofish") == 0)
				{
					if (crc != 0x4ed0fd80)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "AES-Twofish-Serpent") == 0)
				{
					if (crc != 0xea04b3cf)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Serpent-AES") == 0)
				{
					if (crc != 0x0d33596a)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Serpent-Twofish-AES") == 0)
				{
					if (crc != 0x2845d0e3)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Twofish-Serpent") == 0)
				{
					if (crc != 0xca65c5cd)
						return FALSE;
					nTestsPerformed++;
				}
				break;

			case CBC:		// Deprecated/legacy
			case INNER_CBC:	// Deprecated/legacy
			case OUTER_CBC:	// Deprecated/legacy
				if (strcmp (name, "AES") == 0)
				{
					if (crc != 0x2274f53d)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Blowfish") == 0)	// Deprecated/legacy
				{
					if (crc != 0x033899a1)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "CAST5") == 0)		// Deprecated/legacy
				{
					if (crc != 0x331cecc7)	
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Serpent") == 0)
				{
					if (crc != 0x42dff3d4)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Triple DES") == 0)	// Deprecated/legacy
				{
					if (crc != 0xfe497d0c)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "AES-Blowfish") == 0)	// Deprecated/legacy
				{
					if (crc != 0xa7a80c84)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "AES-Blowfish-Serpent") == 0)	// Deprecated/legacy
				{
					if (crc != 0xa0584562)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "AES-Twofish") == 0)
				{
					if (crc != 0x3c226444)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "AES-Twofish-Serpent") == 0)
				{
					if (crc != 0x5e5e77fd)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Serpent-AES") == 0)
				{
					if (crc != 0x57c612d5)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Serpent-Twofish-AES") == 0)
				{
					if (crc != 0x081e045a)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Twofish-Serpent") == 0)
				{
					if (crc != 0xa7b659f3)
						return FALSE;
					nTestsPerformed++;
				}
				break;
			}

			if (crc == 0xb70b4c26)
				return FALSE;

			DecryptDataUnits (buf, &unitNo, nbrUnits, ci);

			if (GetCrc32 (buf, sizeof (buf)) != 0xb70b4c26)
				return FALSE;

			nTestsPerformed++;

			EncryptBuffer (buf, sizeof (buf), ci);
			crc = GetCrc32 (buf, sizeof (buf));

			switch (ci->mode)
			{
			case LRW:		// Deprecated/legacy
				if (strcmp (name, "AES") == 0)
				{
					if (crc != 0x5ae1e3d8)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Blowfish") == 0)	// Deprecated/legacy
				{
					if (crc != 0x2738426f)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "AES-Twofish-Serpent") == 0)
				{
					if (crc != 0x14f2948a)
						return FALSE;
					nTestsPerformed++;
				}
				break;

			case CBC:		// Deprecated/legacy
			case INNER_CBC:	// Deprecated/legacy
			case OUTER_CBC:	// Deprecated/legacy
				if (strcmp (name, "AES") == 0)
				{
					if (crc != 0x960f740e)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Blowfish") == 0)	// Deprecated/legacy
				{
					if (crc != 0x7e1cfabb)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "CAST5") == 0)	// Deprecated/legacy
				{
					if (crc != 0xeaae21c8)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Serpent") == 0)
				{
					if (crc != 0xa8139d62)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Triple DES") == 0)	// Deprecated/legacy
				{
					if (crc != 0xecf5d7d0)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "AES-Blowfish") == 0)	// Deprecated/legacy
				{
					if (crc != 0xb70171b6)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "AES-Blowfish-Serpent") == 0)	// Deprecated/legacy
				{
					if (crc != 0x1e749a87)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "AES-Twofish") == 0)
				{
					if (crc != 0xb4b8bb9b)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "AES-Twofish-Serpent") == 0)
				{
					if (crc != 0x76b6c1cb)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Serpent-AES") == 0)
				{
					if (crc != 0x634f12ed)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Serpent-Twofish-AES") == 0)
				{
					if (crc != 0xe54bc1b9)
						return FALSE;
					nTestsPerformed++;
				}
				else if (strcmp (name, "Twofish-Serpent") == 0)
				{
					if (crc != 0x21cdb382)
						return FALSE;
					nTestsPerformed++;
				}
				break;
			}

			if (crc == 0xb70b4c26)
				return FALSE;

			DecryptBuffer (buf, sizeof (buf), ci);

			if (GetCrc32 (buf, sizeof (buf)) != 0xb70b4c26)
				return FALSE;

			nTestsPerformed++;
		}
	}
	return (nTestsPerformed == 86);
}


BOOL AutoTestAlgorithms (void)
{
	PCRYPTO_INFO ci;
	char key[32];
	unsigned char tmp[16];
	BOOL bFailed = FALSE;
	int i;

	ci = crypto_open ();
	if (!ci)
		return FALSE;

	memset (ci, 0, sizeof (*ci));

	/* Blowfish (deprecated/legacy) */

	for (i=0;i<BF_TEST_COUNT;i++)
	{		
		memcpy(key, bf_ecb_vectors[i].key, 8);
		memcpy(tmp, bf_ecb_vectors[i].plaintext, 8);
		CipherInit2(BLOWFISH, key, ks_tmp, 8);

		((uint32 *)tmp)[0] = BE32 (((uint32 *)tmp)[0]);
		((uint32 *)tmp)[1] = BE32 (((uint32 *)tmp)[1]);

		BlowfishEncryptLE (tmp,tmp,(BF_KEY *)ks_tmp,1);
		BlowfishEncryptLE (tmp,tmp,(BF_KEY *)ks_tmp,0);
		BlowfishEncryptLE (tmp,tmp,(BF_KEY *)ks_tmp,1);

		((uint32 *)tmp)[0] = BE32 (((uint32 *)tmp)[0]);
		((uint32 *)tmp)[1] = BE32 (((uint32 *)tmp)[1]);

		if (memcmp(bf_ecb_vectors[i].ciphertext,tmp,8)!=0)
			break;
	}

	if (i != BF_TEST_COUNT)
		bFailed = TRUE;

	/* CAST5 (deprecated/legacy) */

	for (i=0;i<CAST_TEST_COUNT;i++)
	{			
		int cipher = CAST;
		memcpy(key, cast_ecb_vectors[i].key, 16);
		memcpy(tmp, cast_ecb_vectors[i].plaintext, 8);
		CipherInit2(cipher, key, ks_tmp, 16);

		EncipherBlock(cipher, tmp, ks_tmp);
		DecipherBlock(cipher, tmp, ks_tmp);
		EncipherBlock(cipher, tmp, ks_tmp);

		if (memcmp(cast_ecb_vectors[i].ciphertext, tmp,8)!=0)
			break;
	}

	if (i!=CAST_TEST_COUNT)
		bFailed = TRUE;


	/* Triple DES (TECB, EDE) - deprecated/legacy */

	for (i = 0; i < TRIPLEDES_TEST_COUNT; i++)
	{			
		int cipher = TRIPLEDES;
		memcpy(key, tripledes_vectors[i].key, sizeof(tripledes_vectors->key));
		memcpy(tmp, tripledes_vectors[i].plaintext, sizeof(tripledes_vectors->plaintext));

		CipherInit(cipher, key, ks_tmp);

		EncipherBlock(cipher, tmp, ks_tmp);
		if (memcmp(tripledes_vectors[i].ciphertext, tmp, sizeof(tripledes_vectors->ciphertext)) != 0)
			break;

		DecipherBlock(cipher, tmp, ks_tmp);
		if (memcmp(tripledes_vectors[i].plaintext, tmp, sizeof(tripledes_vectors->plaintext)) != 0)
			break;
	}
	if (i != TRIPLEDES_TEST_COUNT)
		bFailed = TRUE;


	/* AES */

	for (i = 0; i < AES_TEST_COUNT; i++)
	{			
		int cipher = AES;
		memcpy(key, aes_ecb_vectors[i].key, 32);
		memcpy(tmp, aes_ecb_vectors[i].plaintext, 16);
		CipherInit(cipher, key, ks_tmp);

		EncipherBlock(cipher, tmp, ks_tmp);
		if (memcmp(aes_ecb_vectors[i].ciphertext, tmp, 16) != 0)
			break;

		DecipherBlock(cipher, tmp, ks_tmp);
		if (memcmp(aes_ecb_vectors[i].plaintext, tmp, 16) != 0)
			break;
	}
	if (i != AES_TEST_COUNT)
		bFailed = TRUE;


	/* Serpent */

	for (i = 0; i < SERPENT_TEST_COUNT; i++)
	{			
		int cipher = SERPENT;
		memcpy(key, serpent_vectors[i].key, 32);
		memcpy(tmp, serpent_vectors[i].plaintext, 16);
		CipherInit(cipher, key, ks_tmp);

		EncipherBlock(cipher, tmp, ks_tmp);
		if (memcmp(serpent_vectors[i].ciphertext, tmp, 16) != 0)
			break;

		DecipherBlock(cipher, tmp, ks_tmp);
		if (memcmp(serpent_vectors[i].plaintext, tmp, 16) != 0)
			break;
	}
	if (i != SERPENT_TEST_COUNT)
		bFailed = TRUE;


	/* Twofish */

	for (i = 0; i < TWOFISH_TEST_COUNT; i++)
	{			
		int cipher = TWOFISH;
		memcpy(key, twofish_vectors[i].key, 32);
		memcpy(tmp, twofish_vectors[i].plaintext, 16);
		CipherInit(cipher, key, ks_tmp);

		EncipherBlock(cipher, tmp, ks_tmp);
		if (memcmp(twofish_vectors[i].ciphertext, tmp, 16) != 0)
			break;

		DecipherBlock(cipher, tmp, ks_tmp);
		if (memcmp(twofish_vectors[i].plaintext, tmp, 16) != 0)
			break;
	}
	if (i != TWOFISH_TEST_COUNT)
		bFailed = TRUE;

	
	/* PKCS #5 and HMACs */
	if (!test_pkcs5 ())
		bFailed = TRUE;

	/* CRC-32 */
	if (!crc32_selftests ())
		bFailed = TRUE;

	/* GF multiplicator */
#if 0
	if (!GfMulSelfTest ())
		bFailed = TRUE;
#endif

	/* XTS-AES */
	if (!XTSAesTest (ci))
		bFailed = TRUE;

	/* LRW-AES (deprecated/legacy) */
	if (!LRWAesTest (ci))
		bFailed = TRUE;

	/* Sector and buffer related algorithms */
	if (!TestSectorBufEncryption (ci))
		bFailed = TRUE;
	
	crypto_close (ci);
	return !bFailed;
}

BOOL test_hmac_sha512 ()
{
	unsigned int i;
	int nTestsPerformed = 0;

	for (i = 0; i < sizeof (hmac_sha512_test_data) / sizeof(char *); i++)
	{
		char digest[SHA512_DIGESTSIZE];
		hmac_sha512 (hmac_sha512_test_keys[i], strlen (hmac_sha512_test_keys[i]), hmac_sha512_test_data[i], strlen (hmac_sha512_test_data[i]), digest, SHA512_DIGESTSIZE);
		if (memcmp (digest, hmac_sha512_test_vectors[i], SHA512_DIGESTSIZE) != 0)
			return FALSE;
		else
			nTestsPerformed++;
	}

	return (nTestsPerformed == 6);
}

BOOL test_hmac_sha1 ()
{
	// Deprecated/legacy

	int nTestsPerformed = 0;
	int i;

	for (i = 0; i < 3; i++)
	{
		char digest[SHA1_DIGESTSIZE];
		hmac_sha1 (hmac_sha1_test_keys[i], strlen (hmac_sha1_test_keys[i]), hmac_sha1_test_data[i], strlen (hmac_sha1_test_data[i]), digest, SHA1_DIGESTSIZE);
		if (memcmp (digest, hmac_sha1_test_vectors[i], SHA1_DIGESTSIZE) != 0)
			return FALSE;
		else
			nTestsPerformed++;
	}

	return (nTestsPerformed == 3);
}

BOOL test_hmac_ripemd160 ()
{
	int nTestsPerformed = 0;
	unsigned int i;

	for (i = 0; i < sizeof (hmac_ripemd160_test_data) / sizeof(char *); i++)
	{
		char digest[RIPEMD160_DIGESTSIZE];
		hmac_ripemd160 (hmac_ripemd160_test_keys[i], RIPEMD160_DIGESTSIZE, hmac_ripemd160_test_data[i], strlen (hmac_ripemd160_test_data[i]), digest);
		if (memcmp (digest, hmac_ripemd160_test_vectors[i], RIPEMD160_DIGESTSIZE) != 0)
			return FALSE;
		else
			nTestsPerformed++;
	}

	return (nTestsPerformed == 2);
}

BOOL test_hmac_whirlpool ()
{
	unsigned char digest[WHIRLPOOL_DIGESTSIZE];

	hmac_whirlpool (hmac_whirlpool_test_key, 64, hmac_whirlpool_test_data, strlen (hmac_whirlpool_test_data), digest, WHIRLPOOL_DIGESTSIZE);
	if (memcmp (digest, hmac_whirlpool_test_vectors, WHIRLPOOL_DIGESTSIZE) != 0)
		return FALSE;

	return TRUE;
}

BOOL test_pkcs5 ()
{
	char dk[144];

	/* HMAC-SHA-512 tests */
	if (!test_hmac_sha512())
		return FALSE;

	/* HMAC-SHA-1 tests (deprecated/legacy)  */
	if (test_hmac_sha1() == FALSE)
		return FALSE;

	/* HMAC-RIPEMD-160 tests */
	if (test_hmac_ripemd160() == FALSE)
		return FALSE;

	/* HMAC-Whirlpool tests */
	if (test_hmac_whirlpool() == FALSE)
		return FALSE;

	/* PKCS-5 test 1 with HMAC-SHA-512 used as the PRF */
	derive_key_sha512 ("password", 8, "\x12\x34\x56\x78", 4, 5, dk, 4);
	if (memcmp (dk, "\x13\x64\xae\xf8", 4) != 0)
		return FALSE;

	/* PKCS-5 test 2 with HMAC-SHA-512 used as the PRF (derives a key longer than the underlying
	hash output size and block size) */
	derive_key_sha512 ("password", 8, "\x12\x34\x56\x78", 4, 5, dk, 144);
	if (memcmp (dk, "\x13\x64\xae\xf8\x0d\xf5\x57\x6c\x30\xd5\x71\x4c\xa7\x75\x3f\xfd\x00\xe5\x25\x8b\x39\xc7\x44\x7f\xce\x23\x3d\x08\x75\xe0\x2f\x48\xd6\x30\xd7\x00\xb6\x24\xdb\xe0\x5a\xd7\x47\xef\x52\xca\xa6\x34\x83\x47\xe5\xcb\xe9\x87\xf1\x20\x59\x6a\xe6\xa9\xcf\x51\x78\xc6\xb6\x23\xa6\x74\x0d\xe8\x91\xbe\x1a\xd0\x28\xcc\xce\x16\x98\x9a\xbe\xfb\xdc\x78\xc9\xe1\x7d\x72\x67\xce\xe1\x61\x56\x5f\x96\x68\xe6\xe1\xdd\xf4\xbf\x1b\x80\xe0\x19\x1c\xf4\xc4\xd3\xdd\xd5\xd5\x57\x2d\x83\xc7\xa3\x37\x87\xf4\x4e\xe0\xf6\xd8\x6d\x65\xdc\xa0\x52\xa3\x13\xbe\x81\xfc\x30\xbe\x7d\x69\x58\x34\xb6\xdd\x41\xc6", 144) != 0)
		return FALSE;

	/* PKCS-5 test 1 with HMAC-SHA-1 (deprecated/legacy) used as the PRF (derives a key longer than the underlying hash) */
	derive_key_sha1 ("password", 8, "\x12\x34\x56\x78", 4, 5, dk, 48);
	if (memcmp (dk, "\x5c\x75\xce\xf0\x1a\x96\x0d\xf7\x4c\xb6\xb4\x9b\x9e\x38\xe6\xb5\x3b\x11\x80\xe3\x2f\xf7\xe0\xdd\xaa\xca\x8f\x81\x27\xf6\x9f\x4f\x1d\xc8\x2f\x48\x2d\xdb\x1a\x0a\xca\x90\xcb\x80\xb9\x2e\x90\x9e", 48) != 0)
		return FALSE;

	/* PKCS-5 test 2 with HMAC-SHA-1 (deprecated/legacy) used as the PRF */
	derive_key_sha1 ("password", 8, "\x12\x34\x56\x78", 4, 5, dk, 4);
	if (memcmp (dk, "\x5c\x75\xce\xf0", 4) != 0)
		return FALSE;

#if 0	// This test is disabled because it uses 1200 iterations (to prevent startup slowdown)
	/* PKCS-5 test 3 with HMAC-SHA-1 (deprecated/legacy) used as the PRF */
	derive_key_sha1 ("password", 8, "ATHENA.MIT.EDUraeburn", 21, 1200, dk, 16);
	if (memcmp (dk, "\x5c\x08\xeb\x61\xfd\xf7\x1e\x4e\x4e\xc3\xcf\x6b\xa1\xf5\x51\x2b", 16) != 0)
		return FALSE;
#endif

	/* PKCS-5 test 1 with HMAC-RIPEMD-160 used as the PRF */
	derive_key_ripemd160 ("password", 8, "\x12\x34\x56\x78", 4, 5, dk, 4);
	if (memcmp (dk, "\x7a\x3d\x7c\x03", 4) != 0)
		return FALSE;

	/* PKCS-5 test 2 with HMAC-RIPEMD-160 used as the PRF (derives a key longer than the underlying hash) */
	derive_key_ripemd160 ("password", 8, "\x12\x34\x56\x78", 4, 5, dk, 48);
	if (memcmp (dk, "\x7a\x3d\x7c\x03\xe7\x26\x6b\xf8\x3d\x78\xfb\x29\xd2\x64\x1f\x56\xea\xf0\xe5\xf5\xcc\xc4\x3a\x31\xa8\x84\x70\xbf\xbd\x6f\x8e\x78\x24\x5a\xc0\x0a\xf6\xfa\xf0\xf6\xe9\x00\x47\x5f\x73\xce\xe1\x43", 48) != 0)
		return FALSE;

	/* PKCS-5 test 1 with HMAC-Whirlpool used as the PRF */
	derive_key_whirlpool ("password", 8, "\x12\x34\x56\x78", 4, 5, dk, 4);
	if (memcmp (dk, "\x50\x7c\x36\x6f", 4) != 0)
		return FALSE;

	/* PKCS-5 test 2 with HMAC-Whirlpool used as the PRF (derives a key longer than the underlying hash) */
	derive_key_whirlpool ("password", 8, "\x12\x34\x56\x78", 4, 5, dk, 96);
	if (memcmp (dk, "\x50\x7c\x36\x6f\xee\x10\x2e\x9a\xe2\x8a\xd5\x82\x72\x7d\x27\x0f\xe8\x4d\x7f\x68\x7a\xcf\xb5\xe7\x43\x67\xaa\x98\x93\x52\x2b\x09\x6e\x42\xdf\x2c\x59\x4a\x91\x6d\x7e\x10\xae\xb2\x1a\x89\x8f\xb9\x8f\xe6\x31\xa9\xd8\x9f\x98\x26\xf4\xda\xcd\x7d\x65\x65\xde\x10\x95\x91\xb4\x84\x26\xae\x43\xa1\x00\x5b\x1e\xb8\x38\x97\xa4\x1e\x4b\xd2\x65\x64\xbc\xfa\x1f\x35\x85\xdb\x4f\x97\x65\x6f\xbd\x24", 96) != 0)
		return FALSE;

	return TRUE;
}
