/*
 Copyright (c) 2008-2009 TrueCrypt Foundation. All rights reserved.

 Governed by the TrueCrypt License 2.7 the full text of which is contained
 in the file License.txt included in TrueCrypt binary and source code
 distribution packages.
*/

#ifndef TC_HEADER_Core_CoreSolaris
#define TC_HEADER_Core_CoreSolaris

#include "System.h"
#include "Core/Unix/CoreUnix.h"

namespace TrueCrypt
{
	class CoreSolaris : public CoreUnix
	{
	public:
		CoreSolaris ();
		virtual ~CoreSolaris ();

		virtual HostDeviceList GetHostDevices (bool pathListOnly = false) const; 

	protected:
		virtual DevicePath AttachFileToLoopDevice (const FilePath &filePath, bool readOnly) const;
		virtual void DetachLoopDevice (const DevicePath &devicePath) const;
		virtual MountedFilesystemList GetMountedFilesystems (const DevicePath &devicePath = DevicePath(), const DirectoryPath &mountPoint = DirectoryPath()) const;
		virtual void MountFilesystem (const DevicePath &devicePath, const DirectoryPath &mountPoint, const string &filesystemType, bool readOnly, const string &systemMountOptions) const;

	private:
		CoreSolaris (const CoreSolaris &);
		CoreSolaris &operator= (const CoreSolaris &);
	};
}

#endif // TC_HEADER_Core_CoreSolaris
