def edit():
    # The code executed if the edit button is clicked.
    #
    # s = ScriptObj();
    
def create():
    # The new scriptobj is created here.
    #
    # Make sure to add the new Object to the Scene
    #
    # s = ScriptObj();
    # scene = Scene();
    # scene.add( s );
    #
    # If the "edit" button of the scriptobject is enabled
    # (set_has_editbutton(1)) ensure that you set the path
    # to the appropriate script. Use _App.filename as script
    # path if the edit method is located in the same file as
    # the create method. (this is the normal case)
    # i.e.: s.set_script_path(_App.filename);
    

def povpass1():
    # This code is executed in the first phase of
    # povray export (declare object)
    #
    # Use set_pov_pass1( pov_pass1_string) to
    # write the declaration of the object into the
    # povray file:
    #
    # The declaration looks something like this:
    # 
    # #declare obj_ScriptObj_0 =
    #  'pov_pass1_string'
    # photons, translation, rotation,size etc.
    # }
    #
    # i.e. your pov_pass1_string looks something
    # like this:
    # sphere {
    #    <0,0,0>, 1.000000
    #
    # The transformation (translation, rotation, scale)
    # etc. is inserted by Truevision. Make sure that
    # you DO NOT close the curly brace

    # my_pov_pass1_string = "sphere { <0,0,0>, 1.00000";
    # s = ScriptObj();
    # s.set_pov_pass1(my_pov_pass1_string);
    
def povpass2():
    # This code is executed in the second phase of
    # povray export (use object)
    #
    # This is not used yet! And probably will never
    # be used :-)

def register():
    # Registers this script as a plug-in in truevision
    # If you don't want to register this script make sure
    # it is not located in the plug-ins directory
    # (python/plug-ins/)
    #
    # Use _App.register_script(..) to register a plug-in. The
    # arguments are:
    # 1) path to the script file
    # 2) Description
    # 3) Help message
    # 4) Author/s
    # 5) Copyright
    # 6) Year
    # 7) affected objects (not used)
    # 8) menu path (the top level menus are: <load>, <save>,
    #    <import>, <export>, <edit>, <view> and <scripts>
    #
    # i.e.: _App.register_script(_App.filename, "Template script", "Help me with this plugin", "Christian", "Christian", "2005", "*", "<help_menu>/About_Python");
    
##################
# Main
##################

try:
    run_mode = _App.run_mode;
    if run_mode == 0:
        register();
    elif run_mode == 1:
        create();
    elif run_mode == 2:
        edit();
    elif run_mode == 3:
        povpass1();
    elif run_mode == 4:
        povpass2();
        
except AttributeError:
    create();

    
