//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// atmosphere.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TV_ATMOS_H
#define TV_ATMOS_H
#include "object3d.h"
using namespace std;
// Definition
// Background color objects
class Background : public Object3D {
	private:
		TvWidget_pigment *color;

	public:
		Background( app_objs *appref );
		~Background();
		void add_to_tree( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *sel, GtkTreeIter *parent, GtkTreeIter *sibling, const gchar *pixmap = NULL ) { Object3D::add_to_tree( view, store, sel, parent, sibling, "object_bkgd.xpm" ); }

		void edit_widget( GtkWidget *wid );
		void destroy_editor();
		void pref_changed();
		void flush() { color->flush(); }
		
		void output_to_povray_pass1( ofstream & file );
		void save( ofstream & file );
		bool load ( ifstream & file, char *tag );
};


// Skysphere object
class SkySphere : public Object3D_with_material {
	private:

	public:
		SkySphere( app_objs *appref );

		void edit_widget( GtkWidget *wid );		
		void output_to_povray_pass1( ofstream & file );
		virtual void output_to_povray_pass2( ofstream & file ) { if ( !render->value() ) return; file << "\n\tsky_sphere {"; get_underscore_name( file ); file << "}"; }
		void save( ofstream & file );
		bool load ( ifstream & file, char *tag );
};


// Athmospheric media object
class AtmosMedia : public Object3D_with_material {
	private:

	public:
		AtmosMedia( app_objs *appref );

		void edit_widget( GtkWidget *wid );		
		void output_to_povray_pass1( ofstream & file );
		void output_to_povray_pass2( ofstream & file ) {}
		void save( ofstream & file );
		bool load ( ifstream & file, char *tag );
};

#endif
