//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// bicubic.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TV_BICUBIC_H
#define TV_BICUBIC_H
using namespace std;
#include "object3d.h"


// Definition
class Bicubic : public Object3D_with_material {
	#define SENDER ((Bicubic*)data)
	friend void sign_bicubic_current_point_changed( GtkWidget *wid, gpointer data ) { SENDER->current_point_changed(); }
	friend void sign_bicubic_current_point_num_changed( GtkWidget *wid, gpointer data ) { SENDER->current_point_num_changed(); }
	#undef SENDER

	private:
		ObjParam_point *location;
		ObjParam_scale *size;
		ObjParam_rotation *rotation;
		ObjParam_bool_activator *edit;
		ObjParam_float *flatness;
		ObjParam_int *ustep, *vstep;
		ObjParam_bool *preprocess;
	
		GtkWidget *patch_edit_box;
		ObjParam_int *current_point_num;
		ObjParam_point *current_point;
		bool in_undo;
		bool in_update;
	
		float control_points[16][3];

	public:
		Bicubic( app_objs *appref );
		Bicubic( Bicubic & ref );
		~Bicubic();
		Object3D *duplicate_yourself() { Bicubic *res = new Bicubic( *this ); return res; }

		void display( glview *view, bool set_col = true );
		void edit_widget( GtkWidget *wid );
		void destroy_editor();
		void pref_changed();
		
		void mouse_drag( struct drag_info *drag );
		float *get_location() { return location->get(); }
		Rotation *get_rotation() { return rotation->get_rotation(); }
		
		void output_to_povray_pass1( ofstream & file );
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );
		
		void current_point_num_changed();		
		void current_point_changed();
		virtual bool pick_test( int name );
		void undo( Object3D *copy );
		void push_undo_item() { if ( !in_undo && !in_update ) Object3D::push_undo_item(); }

		// Access methods
		virtual void set_location(float *data) { location->set(data[0], data[1], data[2]); location->update_widget();}
		void set_rotation(float *data) {rotation->set(data[0], data[1], data[2]); rotation->update_widget(); rotation->flush();}
		void set_size(float *data) { size->set(data[0], data[1], data[2]); size->update_widget();}
		float* get_rot(float* val) { float _x, _y, _z; rotation->get(_x, _y, _z); val[0] = _x; val[1] = _y; val[2] = _z; return (float*)val;}
		float* get_size() { return size->get(); }
		float* get_control_point(int index) { if(index < 17 && index > 0)return ((float*)control_points[index-1]); }
		void set_control_point(int index, float *data) { if(index < 1 || index > 17) {return;} control_points[index-1][0] = data[0];
		control_points[index-1][1] = data[1];
		control_points[index-1][2] = data[2];}
		bool is_edit() { return edit->value(); }
		void set_edit(bool e) { edit->set(e); }
		bool is_preprocess() { return preprocess->value(); }
		void set_preprocess(bool e) { preprocess->set(e); }
		float get_flatness() { return flatness->value(); }
		void set_flatness(float fn) { flatness->set(fn); }
		int get_ustep() { return ustep->value(); }
		void set_ustep(int u) { ustep->set(u); }
		int get_vstep() { return vstep->value(); }
		void set_vstep(int v) { vstep->set(v); }
};
#endif
