//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// blob.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
//*******************************************************************************************
#ifndef TV_BLOB_H
#define TV_BLOB_H
using namespace std;
#include "object3d.h"
#include "obj3dcsg.h"



class Blob : public ObjCSG {

	#define SENDER ((Blob*)data)
	friend void sign_blob_add_sphere( GtkWidget *wid, gpointer data ) { SENDER->add_sphere(); }
	friend void sign_blob_add_cylinder( GtkWidget *wid, gpointer data ) { SENDER->add_cylinder(); }
	friend bool BlobTestFunc( gpointer data, float x, float y, float z ) { return SENDER->is_inside( x, y, z ); }
	#undef SENDER

	private:
		ObjParam_float *threshold;
		ObjParam_bool *sturm, *hierarchy;
		ObjParam_bool *evaluate;

	public:
		Blob( app_objs *appref );
		Blob *duplicate_yourself() { Blob *res = new Blob( *this ); return res; }		
		Blob( Blob & ref );
		~Blob() { delete threshold; delete sturm; delete hierarchy; }
		virtual void pref_changed();
		void add_to_tree( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *sel, GtkTreeIter *parent, GtkTreeIter *sibling, const gchar *pixmap = NULL ) { ObjCSG::add_to_tree( view, store, sel, parent, sibling, "object_blob.xpm" ); }
		virtual void edit_widget( GtkWidget *wid );
		virtual void destroy_editor();
		void output_to_povray_pass1( ofstream & file )	;
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );
		void display( glview *view, bool set_color = true );

		void add_sphere();
		void add_cylinder();
		
		void paste_object( Object3D *obj ) {}
			
		bool is_inside( float x, float y, float z );
		virtual bool is_group() { return false; }
};

#endif
