//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// camera.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TV_CAMERA_H
#define TV_CAMERA_H
using namespace std;
#include "object3d.h"

// Definition
// Camera object
class Camera : public Object3D {

	#define SENDER ((Camera*)data)
	friend void sign_camera_mode( GtkWidget *wid, gpointer data ) { SENDER->mode_changed(); }
	#undef SENDER
	
	private:
		// Basic parameters
		ObjParam_point *location;
		ObjParam_point *look_at;
		ObjParam_bool *frustum;
		ObjParam_float_angle *roll;
		ObjParam_float *angle, *aratio;
		ObjParam_option_combo *cam_mode;

		// Blur
		ObjParam_bool_activator *blur;
		ObjParam_int *blur_sample;
		ObjParam_point_virtual *focal_point;
		ObjParam_float *aperture, *confidence, *variance;
		ObjParam_float *h_angle, *v_angle;
		
		// Normal
		ObjParam_texref *normal;

	public:
		Camera( app_objs *appref );
		void add_to_tree( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *sel, GtkTreeIter *parent, GtkTreeIter *sibling, const gchar *pixmap = NULL ) { Object3D::add_to_tree( view, store, sel, parent, sibling, "object_camera.xpm" ); }
		void destroy() {}

		void display( glview *view, bool set_color = true );
		void edit_widget( GtkWidget *wid );
		void destroy_editor();
		void pref_changed();
		void mouse_drag( struct drag_info *drag );

		void output_to_povray_pass1( ofstream & file ) {}	
		void output_to_povray_pass2( ofstream & file );
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );
		
		float get_angle() { return angle->value(); }
		float get_aspect() { return aratio->value(); }
		float get_roll() { return roll->value(); }
		TvWidget_point *get_camera_location() { return location; }
		TvWidget_point *get_lookat() { return look_at; }
		
		void mode_changed();
};

#endif
