//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// cylinder.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TV_CYLINDER_H
#define TV_CYLINDER_H
using namespace std;
#include "object3d.h"

// Definition
// Cylinder object
class Cylinder : public Object3D_with_material {
	public:
		ObjParam_point_virtual *base_point;
		ObjParam_point_virtual *cap_point;
		ObjParam_point *location;
		ObjParam_float *radius;
		ObjParam_scale *size;
		ObjParam_rotation *rotation;
		ObjParam_bool *open;

	public:
		Cylinder( app_objs *appref );
		Cylinder( Cylinder & ref );
		~Cylinder();
		Object3D *duplicate_yourself() { Cylinder *res = new Cylinder( *this ); return res; }
		virtual void add_to_tree( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *sel, GtkTreeIter *parent, GtkTreeIter *sibling, const gchar *pixmap = NULL ) { Object3D::add_to_tree( view, store, sel, parent, sibling, "object_cylinder.xpm" ); }

		void display( glview *view, bool set_color = true );
		virtual void edit_widget( GtkWidget *wid );
		virtual void destroy_editor();
		virtual void pref_changed();
		
		void mouse_drag( struct drag_info *drag );
		float *get_location() { return location->get(); }
		Rotation *get_rotation() { return rotation->get_rotation(); }
		
		virtual void output_to_povray_pass1( ofstream & file );
		virtual void save( ofstream & file );
		virtual bool load( ifstream & file, char *tag );

		// Access methods
		virtual void set_location(float *data) { location->set(data[0], data[1], data[2]); }
		void set_radius(float data) { radius->set(data);}
		
		void set_rotation(float *data) {rotation->set(data[0], data[1], data[2]); rotation->update_widget(); rotation->flush();}
		void set_size(float *data) { size->set(data[0], data[1], data[2]);}
		float* get_base_point() { return cap_point->get(); }
		float* get_cap_point() { return base_point->get(); }
		void set_base_point(float *data){ base_point->set(data[0], data[1], data[2]);}
		void set_cap_point(float *data){ cap_point->set(data[0], data[1], data[2]);}
		float get_radius() { return radius->value(); }
		float* get_rot(float* val) { float _x, _y, _z; rotation->get(_x, _y, _z); val[0] = _x; val[1] = _y; val[2] = _z;	return (float*)val;} 
		float* get_size() { return size->get(); }
		bool is_open() { return open->value(); }
		void set_open( bool op ) { open->set( op ); }
};


// Definition
class BlobCylinder : public Cylinder {
	private:
		ObjParam_float *strength;

	public:
		BlobCylinder( app_objs *appref );
		BlobCylinder( BlobCylinder & ref );
		~BlobCylinder();
		Object3D *duplicate_yourself() { BlobCylinder *res = new BlobCylinder( *this ); return res; }

		void edit_widget( GtkWidget *wid );
		void destroy_editor();
		void pref_changed();
		
		void output_to_povray_pass1( ofstream & file );
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );		
		float get_strength_radius();
		float get_strength( float x, float y, float z );
		bool changed() { return location->changed() || base_point->changed() || cap_point->changed() || size->changed() || rotation->changed() || strength->changed(); }
		void unchange() { location->unchange(); base_point->unchange(); cap_point->unchange(); size->unchange(); rotation->unchange(); strength->unchange(); }

};
#endif
