//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// density.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef DENSITY_H
#define DENSITY_H
using namespace std;
#include "material.h"
#include "mapedit.h"

//****************************************************
// Density class :
// Used to modify media in pov material interiors & in atmospheric
// media.
//****************************************************
class PovTexDensity : public MaterialItem {
	#define SENDER ((PovTexDensity*)data)
	friend void sign_density_delete( GtkWidget *wid, gpointer data ) { SENDER->del_density(); }
	friend void sign_density_type_changed( GtkWidget *wid, gpointer data ) { SENDER->type_changed(); }
	friend MapItem *mapedit_density_feeder_col( gpointer data );
	friend MapItem *mapedit_feeder_dens( gpointer data );

	friend void sign_density_densblocktype_changed( gpointer data ) { SENDER->set_densblock_items(); }
	#undef SENDER

	private:
		static int count;
		int num;
		bool is_mother;
		gpointer mother;
		void (*suicidal_func)(gpointer, gpointer);

		TvWidget_option_combo *type;
		TvWidget_blockpattern *blockpattern;
		TvWidget_transformation_rb *transformation;
		TvWidget_noise_rb *noise;
		TvWidget_warp_rb *warp;
		TvWidget_blendmap *blendmap;
		TvWidget_blendmap_mod *blendmap_mod;
		TvWidget_map_editor *map_editor;
		PovTexDensity *blockdens1, *blockdens2, *blockdens3;

		GtkWidget *changing_box, *changing_box2;
		GtkWidget *vbox;

		void set_changing_box();
		void type_changed();
		void set_densblock_items();

	public:
		PovTexDensity( app_objs *appref, char *sname, void (*suicidal_func)(gpointer, gpointer), gpointer mother, bool is_mother = true );
		PovTexDensity( PovTexDensity & res );
		virtual MaterialItem *duplicate_yourself() { PovTexDensity *res = new PovTexDensity( *this ); return res; }
		void set_params( void (*suicidal_func)(gpointer, gpointer), gpointer mother, bool is_mother = true );
		virtual ~PovTexDensity();
		

		void edit_widget( GtkWidget *box );
		void destroy_widget();
		virtual void add_to_tree( GtkTreeView *view, GtkTreeStore *store, GtkTreeSelection *selection, GtkTreeIter *parent, GtkTreeIter *sibling = NULL  );
		void remove_from_tree();
		void delete_yourself() { del_density(); }
		void flush();
		void output_to_povray( ofstream & file, bool inmap = false  );
		void save( ofstream & file);
		bool load( ifstream & file, char * tag );
		void del_density() { suicidal_func( mother, this ); }
		
		bool paste( MaterialItem *item );
		void save_node_state();
};


//****************************************************
// MapItem density class
// To be used in density maps
//****************************************************
class MapItem_density : public MapItem {
	protected:
		PovTexDensity *density;
		static int obj_count;
		void refresh_name() { name = density->get_name(); }

	public:
		MapItem_density( float val, guint8 c, app_objs *appref );
		MapItem_density( MapItem_density & res );
		virtual MapItem *duplicate_yourself() { MapItem_density *res = new MapItem_density( *this ); return res; }
		~MapItem_density() { delete density; }

		void add_to_tree ( GtkTreeView *view, GtkTreeStore *store, GtkTreeSelection *selection, GtkTreeIter *parent, GtkTreeIter *sibling = NULL  ) { density->add_to_tree( view, store, selection, parent, sibling ); }
		void remove_from_tree() { density->remove_from_tree(); }
		void output_to_povray( ofstream & file ) { density->output_to_povray( file, true ); }
		void save( ofstream & file );
		bool load( ifstream & file, char * ltag );
		void save_node_state() { density->save_node_state(); }
};

#endif
