//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// dlgutils.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//******************************************************************************************
#ifndef TV_DLGUTILS_H
#define TV_DLGUTILS_H
using namespace std;
#include "GL/gl.h"
#include "GL/glu.h"
//#include "gtkgl/gtkglarea.h"
#include <iostream>
#include "gnome.h"

// General functions to be used in gtk / gnome dialog boxes
// Temporary files creation
// Splash screen object
// Display list manager
// Help browser helper

//************************************
// Dialogs functions
//************************************
// Notebooks
// create a new page in a gtk notebook
GtkWidget *dlg_new_page( GtkWidget *notebook, const char *lab );

// Frames
// create simple / double box frames
// created boxes are returned to box1 & box2 pointers
// parent is the box the frame is to be packed in
GtkWidget * dlg_double_box( GtkWidget *parent, GtkWidget* &vbox1, GtkWidget* &vbox2, bool packed = false );
GtkWidget * dlg_double_box_frame( const char *titre, GtkWidget *parent, GtkWidget* &vbox1, GtkWidget* &vbox2 );
GtkWidget * dlg_simple_box_frame( const char *titre, GtkWidget *parent );

GtkWidget *new_table( GtkWidget *parent, const char *titre, int rows );
GtkWidget *new_table_no_frame( GtkWidget *parent, int rows );

char *tv_get_pixmap( char *pix );
char *tv_get_data( char *pix );


//************************************
// Temp Files
//************************************
// create a temporary file
// not fully implemented : still created in the current directory
char *get_temp_filename();

//************************************
// Temp directory
//************************************
// create a temporary dir (under /tmp
// not fully implemented : still created in the current directory
char *get_temp_directory();

//************************************
// Copy files
//************************************
void cp( char* from, char* to);

//************************************
// Ends with...
//************************************
int ends_with( char* str, char *tok);

//**************************************
// Extracts the filename (path/filname)
//**************************************
char* extract_filename( char *str );

//*************************************************************
// Splash screen
// create & destroy a window displayed during
// loading.
//
// set_status( char * ) -> set the message in the status bar
//*************************************************************
class SplashScreen {
	friend void sign_splash_closed( GtkWidget *wid, GdkEvent *ev, gpointer data ) { ((SplashScreen*)data)->splash = NULL; }

	private:
		GtkWidget *splash;
		GtkWidget *statusbar;

	public:
		SplashScreen( GnomeProgram *app );
		~SplashScreen();
		void set_status( char *message );
};




//******************************************************************
// Display Lists
// manage OpenGL display lists
//
// create() -> create the display list OpenGL id
// begin() & end() -> used to create objects to be stored in
// exec() -> execute the list if still valid
// invalidate() -> make the list invalid
//******************************************************************
class GlDisplayList {
	private:
		int num;
		bool valid;

	public:
		GlDisplayList() { num = -1; valid = false; }
		~GlDisplayList() { if ( num != -1 ) glDeleteLists( num, 1 ); }
		void create() { num = glGenLists( 1 ); }

		bool exec() { if ( ! valid ) return valid; glCallList( num ); return valid; }
		void begin() { if ( num == -1 ) create(); glNewList( num, GL_COMPILE_AND_EXECUTE ); }
		void end() { glEndList(); valid = true; }
		void invalidate() { valid = false; }
};


// Help raiser :)



#endif
