//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// fog.h
//
// Christian Spoer <spoer@gmx.de>
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Christian Spoer <spoer@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
//*******************************************************************************************
#ifndef TV_FOG_H
#define TV_FOG_H
using namespace std;
#include "object3d.h"

// Definition
// Fog-Object (constant & ground)

class Fog : public Object3D {
	private:
		ObjParam_rotation *rotation;
		ObjParam_float *distance;
		ObjParam_color *color;
		ObjParam_float *transmit, *filter;
		
		ObjParam_bool_activator *use_turbu;
		ObjParam_point *turbulence;
		ObjParam_float *turbu_dep;
		ObjParam_int *octaves;
		ObjParam_float *omega;
		ObjParam_float *lambda;		
	
		ObjParam_bool_activator *ground_fog;
		ObjParam_float *fog_offset;
		ObjParam_float *fog_alt;
	
	public:
		Fog( app_objs *appref );
		Fog( Fog & ref );
		~Fog();
		Object3D *duplicate_yourself() { Fog *res = new Fog( *this ); return res; }
		void add_to_tree( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *sel, GtkTreeIter *parent, GtkTreeIter *sibling, const gchar *pixmap = NULL ) { Object3D::add_to_tree( view, store, sel, parent, sibling, "object_fig.xpm" ); }

		void display( glview *view, bool set_color = true  );
		void edit_widget( GtkWidget *wid );
		void destroy_editor();
		void pref_changed();
		void mouse_drag( struct drag_info *drag );
		Rotation *get_rotation() { return rotation->get_rotation(); }
		
		void output_to_povray_pass1( ofstream & file );
		virtual void output_to_povray_pass2( ofstream & file ) { if ( !render->value() ) return; file << "\n\tfog {"; get_underscore_name( file ); file << "}"; }
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );
};
#endif
