//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// glview2d.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef GLVIEW2D_H
#define GLVIEW2D_H
using namespace std;
#include "glview.h"

// Classe 2D
class glview2d : public glview {	
	#define SENDER ((glview2d*)obj)
	friend void sign_toggle_grid( GtkWidget *wid, gpointer obj ) { SENDER->grid->toggle(); }
	friend void sign_toggle_labels( GtkWidget *wid, gpointer obj ) { SENDER->label->toggle(); }		
	#undef SENDER

	private:
		// Grid & Labels
		TvWidget_bool *grid;
		GtkWidget *menu_grid;
		static GlDisplayList labels2D_lists[3];
		GtkWidget *menu_labels;

		// Zoom
		static TvWidget_float *common_zoom;
		TvWidget_float *local_zoom;
		TvWidget_float *zoom;

		void refresh();
		void pref_changed();

		void mouse_moved( GdkEventMotion *ev );
		virtual void mouse_scrolled( GdkEventScroll *ev );
		void set_viewport();
		void add_menu();
		void draw_labels();
		void reset_view( int type );
		void set_rotate();
	    void key_press( GdkEventKey *ev );

	public:
		glview2d( app_objs *appref,  ViewType mode, GtkWidget *box, GtkWidget *f1, GtkWidget *f2 );
		~glview2d();
		
		void save( ofstream & file );
		bool load( ifstream & file, char * tag );
		void clear( ViewType cltype );
		
		void reset_home();
};

#endif
