//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// glview3d.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef GLVIEW3D_H
#define GLVIEW3D_H
using namespace std;
#include "glview.h"
#include "dlgutils.h"

class glview3d : public glview {
	// Callback
	#define SENDER ((glview3d*)obj)	
	friend gint sign_toggle_3Dlabels( GtkWidget *wid, gpointer obj ) { SENDER->label->toggle(); return TRUE; }
	friend gint sign_toggle_grids( GtkWidget *wid, gpointer obj ) { SENDER->toggle_grids(); return TRUE; }
	#undef SENDER

	protected:		
		TvWidget_float *zoom;
		
		// Menus
		void add_menu();
		GtkWidget *menu_labels;
		GtkWidget *menu_grids[3];

		// Axis, Labels, Grids
		GlDisplayList label_list;
		void draw_label();
		TvWidget_bool *grids[3];

	    // Fonctions
	    void mouse_moved( GdkEventMotion *ev );
		virtual void mouse_scrolled( GdkEventScroll *ev );
	    void toggle_grids();
	    void key_press( GdkEventKey *ev );

	public:
		glview3d( app_objs *appref,  GtkWidget *box, GtkWidget *f1,  GtkWidget *f2);
		void init_3dview();
		~glview3d();
		virtual void refresh();
		void pref_changed();
		
		virtual void save( ofstream & file );
		virtual bool load( ifstream & file, char *tag );
		void clear( ViewType cltype );
		void display_objects();
		virtual void set_viewport();
		virtual void reset_home();
};


class glcamview : public glview3d {
    private:

    public:
	glcamview( app_objs *appref, GtkWidget *box, GtkWidget *f1,  GtkWidget *f2);
	~glcamview() {}
		
	void refresh();		
	void set_viewport();
	void save( ofstream & file );
	bool load( ifstream & file, char *tag );
	void reset_home() {};
};

#endif
