//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// heightfield.h
//
// Kent Gustavsson  <oden@gmx.net>
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2001 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
//*******************************************************************************************
#ifndef TV_HEIGHTFIELD_H
#define TV_HEIGHTFIELD_H
using namespace std;
#include "object3d.h"

// Dfinition
class Heightfield : public Object3D_with_material {
	private:
		ObjParam_point *location;
		ObjParam_scale *size;
		ObjParam_rotation *rotation;
		ObjParam_bool *smooth;
		ObjParam_float *water_level;
		ObjParam_bool *hierarchy;
		ObjParam_file *bitmap;
		ObjParam_bool *preview;

	public:
		Heightfield( app_objs *appref );
		Heightfield( Heightfield & ref );
		~Heightfield();
		Object3D *duplicate_yourself() { Heightfield *res = new Heightfield( *this ); return res; }
		void add_to_tree( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *sel, GtkTreeIter *parent, GtkTreeIter *sibling, const gchar *pixmap = NULL ) { Object3D::add_to_tree( view, store, sel, parent, sibling, "object_hf.xpm" ); }

		void display( glview *view, bool setcol );
		void edit_widget( GtkWidget *wid );
		void destroy_editor();
		void pref_changed();
		
		void mouse_drag( struct drag_info *drag );
		float *get_location() { return location->get(); }
		Rotation *get_rotation() { return rotation->get_rotation(); }
		
		void output_to_povray_pass1( ofstream & file );
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );

		void set_filename( char* fn ) { bitmap->set( fn ); }
		char* get_filename() { return bitmap->value(); }
};
#endif
