//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// interface.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2001 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef INTERFACE_H
#define INTERFACE_H
using namespace std;
#include "main.h"
#include "viewmanager.h"
#include "proppanel.h"
#include "scene.h"
#include "undo.h"
#include "preferences.h"
#include "povfe.h"
#include "matlist.h"
#include "matlib.h"

#ifdef HAVE_TV_PYTHON
#include "include/pyengine.h"
#endif

#define INTERF_DEF Interface *interf = (Interface*)(app_ref->interf);

//*******************************************************************
// Class Interface
//
// manage GUI, ie menus, toolbar
//*******************************************************************
class Interface : private app_object {
	#define SENDER ((Interface*)data)
	friend void sign_interface_recent_file( GtkWidget *wid, gpointer data ) { ((Interface*)data)->load_recent_file( wid ); }
	friend void sign_interf_hide_panel( GtkWidget *wid, gpointer data ) { ((Interface*)data)->hide_panel(); }

	// Menu callbacks
	friend void interf_sign_menu_new( GtkAction *action, gpointer data ) { ((Scene*)(SENDER->app_ref->scene))->new_scene( ); }
	friend void interf_sign_menu_open( GtkWidget *wid, gpointer data ) { ((Scene*)(SENDER->app_ref->scene))->load_as( ); }
	friend void interf_sign_menu_save( GtkWidget *wid, gpointer data ) { ((Scene*)(SENDER->app_ref->scene))->save( );}
	friend void interf_sign_menu_saveas( GtkWidget *wid, gpointer data ) { ((Scene*)(SENDER->app_ref->scene))->save_as( );}
	friend void interf_sign_menu_exportpov( GtkWidget *wid, gpointer data ) { ((Scene*)(SENDER->app_ref->scene))->export_to_povray( ); }
	friend void interf_sign_menu_exportpack( GtkWidget *wid, gpointer data ) { ((Scene*)(SENDER->app_ref->scene))->export_scene_pack( ); }
	friend void interf_sign_menu_loadobj( GtkWidget *wid, gpointer data ) { ((ObjectList*)(SENDER->app_ref->obj3dlist))->load_object(); }
	friend void interf_sign_menu_saveobj( GtkWidget *wid, gpointer data ) { ((ObjectList*)(SENDER->app_ref->obj3dlist))->save_object(); }
	friend void interf_sign_menu_exit( GtkWidget *wid, gpointer data ) { app_exit( NULL, NULL, NULL ); }

	friend void interf_sign_menu_undo( GtkWidget *wid, gpointer data ) { ((UndoRedoManager*)(SENDER->app_ref->undoman))->undo(); }
	friend void interf_sign_menu_redo( GtkWidget *wid, gpointer data ) { ((UndoRedoManager*)(SENDER->app_ref->undoman))->redo(); }
	friend void interf_sign_menu_cut( GtkWidget *wid, gpointer data ) { sign_objlist_cut_object( NULL, (gpointer)(SENDER->app_ref->obj3dlist) ); }
	friend void interf_sign_menu_copy( GtkWidget *wid, gpointer data ) { sign_objlist_copy_object( NULL, (gpointer)(SENDER->app_ref->obj3dlist) ); }
	friend void interf_sign_menu_paste( GtkWidget *wid, gpointer data ) { sign_objlist_paste_object( NULL, (gpointer)(SENDER->app_ref->obj3dlist) ); }
	friend void interf_sign_menu_prefs( GtkWidget *wid, gpointer data ) { ((Preferences*)(SENDER->app_ref->prefer))->raise_dlg(); }
	
	friend void interf_sign_menu_render( GtkWidget *wid, gpointer data ) { ((PovrayFE*)(SENDER->app_ref->povfe))->render_run(); }
	friend void interf_sign_menu_stop( GtkWidget *wid, gpointer data ) { ((PovrayFE*)(SENDER->app_ref->povfe))->stop_render(); }
	friend void interf_sign_menu_frontend( GtkWidget *wid, gpointer data ) {((PovrayFE*)(SENDER->app_ref->povfe))->raise_render_box(); }
	friend void interf_sign_menu_options( GtkWidget *wid, gpointer data ) { ((PovrayFE*)(SENDER->app_ref->povfe))->raise_options_box(); }
	
	friend void interf_sign_menu_fullscreen( GtkWidget *wid, gpointer data ) { SENDER->toggle_fullscreen(); }
	friend void interf_sign_menu_matedit( GtkWidget *wid, gpointer data ) { ((MatList*)(SENDER->app_ref->matlist))->raise_texeditor(); }
	friend void interf_sign_menu_matlib( GtkWidget *wid, gpointer data ) { ((MatLib*)(SENDER->app_ref->matlib))->raise_dlg_box(); }
	
	friend void interf_sign_menu_script( GtkWidget *wid, gpointer data ) { ((PyEngine*)(SENDER->app_ref->python_engine))->load_as(); }

	friend void interf_sign_menu_help( GtkWidget *wid, gpointer data ) { truevision_help_display( "truevision.xml",  NULL, NULL );		}
	friend void interf_sign_menu_helpon( GtkWidget *wid, gpointer data ) { ((ObjectList*)(SENDER->app_ref->obj3dlist))->help_on_current_object(); }
	friend void interf_sign_menu_website( GtkWidget *wid, gpointer data ) { display_homepage(); }
	friend void interf_sign_menu_about( GtkWidget *wid, gpointer data ) { about(); }
	
	friend void interf_sign_toolbar_pointer( GtkAction *action, gpointer data ) { SENDER->vmanager->sign_pmode_change( action ); }
	#undef SENDER
	
	private:
		app_objs * app_ref;
		ViewManager *vmanager;
		PropPanel *panel;

		GtkWidget *win, *vbox, *paned, *side_panel_box, *hide_button;
		GtkWidget *toolbar;
		GtkAccelGroup *accels;

		// Recent files
		GtkMenuItem *recent_files;
		GtkWidget *recent_files_widgets[10];
		void set_recent_files();
	
		void hide_panel( bool change = true );
		bool fullscreen;
	
		void register_tv_stock_icons();
	
		// Status bar
		GtkWidget *progress_bar;
		GtkWidget *status;

	public:
		Interface( app_objs *app_ref );
	
		// Preferences
		void flush_pref();
		void pref_changed();
	
		// Attributes
		GdkWindow *get_gdkwin() { return win->window; }
		GtkWidget *get_gtkwin() { return win; }
		GtkAccelGroup *get_accels() { return accels; }
		
		// Save & Load
		void save( ofstream & file );
		void clear() { vmanager->clear(); }
		bool load( ifstream & file, char * tag );
		
		// Set information systems
		void set_status( char *mesg ) { gtk_label_set_text( GTK_LABEL(status), mesg ); update_appbar(); }
		void clear_status() { gtk_label_set_text( GTK_LABEL(status), NULL ); }
		void set_progress( float val ) {  gtk_progress_bar_set_fraction( GTK_PROGRESS_BAR(progress_bar), val ); update_appbar(); }
		void update_appbar() { while ( gtk_events_pending() ) gtk_main_iteration(); }
		void set_hourglass( bool set );

		// Recent files		
		void recent_file_push( char *filename );
		void recent_file_pop( char *filename );
		void load_recent_file( GtkWidget *wid );
		
		// Fullscreen
		void toggle_fullscreen();
		
		// temp
		//void jitter();
}; 

#endif
