//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// interior.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2001 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef INTERIOR_H
#define INTERIOR_H
using namespace std;
#include "material.h"
#include "media.h"
#include <vector>

class PovTexInterior : public MaterialItem {
	#define SENDER ((PovTexInterior*)data)
	friend void sign_int_addmedia( GtkWidget *wid, gpointer data ) { SENDER->add_media(); }
	friend void sign_int_media_suicide( gpointer data, gpointer victim  ) { SENDER->delete_media( (PovTexMedia*)victim ); }
	#undef SENDER

	private:
		TvWidget_bool_activator *interior;
		TvWidget_float *ior;
		TvWidget_float *fade_power;
		TvWidget_float *fade_distance;
		TvWidget_color *fade_color;
		TvWidget_bool_activator *fade;
		TvWidget_float *caustics;
		TvWidget_float *dispersion;
		TvWidget_int *dispersion_samples;
		vector<PovTexMedia*> media_liste;		

	public:
		PovTexInterior( app_objs *appref, char *sname );
		PovTexInterior( PovTexInterior & ref );
		MaterialItem *duplicate_yourself() { PovTexInterior *res = new PovTexInterior( *this ); return res; }
		virtual ~PovTexInterior();

		void edit_widget( GtkWidget *box );
		void destroy_widget();
		void add_to_tree( GtkTreeView *view, GtkTreeStore *store, GtkTreeSelection *selection, GtkTreeIter *parent, GtkTreeIter *sibling = NULL  );
		void flush();
		void output_to_povray( ofstream & file );
		void output_to_povray_media( ofstream & file );
		bool is_used() { return interior->value(); }
		void add_media();
		void delete_media( PovTexMedia *media );
		void save( ofstream & file );
		bool load( ifstream & file, char * tag );
		virtual void remove_from_tree();
		
		bool paste( MaterialItem *item );
		void save_node_state();
};

#endif
