//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// isosurface.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TV_ISOSURFACE_H
#define TV_ISOSURFACE_H
using namespace std;
#include "object3d.h"

// Definition
// Box object
class IsoSurface : public Object3D_with_material {

	#define SENDER ((IsoSurface*)data)
	friend bool IsoSurfaceTestFunc( gpointer data, float x, float y, float z ) { return SENDER->is_inside( x, y, z ); }
	#undef SENDER

	private:
		ObjParam_point *location;
		ObjParam_scale *size;
		ObjParam_rotation *rotation;
		ObjParam_point *corner1, *corner2;
		ObjParam_bool *show_bb, *preview;
		ObjParam_float *threshold;
		ObjParam_function *function;
		ObjParam_bool *open;
		ObjParam_float *accuracy;
		ObjParam_float *max_gradient;
		ObjParam_bool *all_intersections;

	public:
		IsoSurface( app_objs *appref );
		IsoSurface( IsoSurface & ref );
		~IsoSurface();
		Object3D *duplicate_yourself() { IsoSurface *res = new IsoSurface( *this ); return res; }

		void display( glview *view, bool set_color = true );
		void edit_widget( GtkWidget *wid );
		void destroy_editor();
		void pref_changed();
		
		void mouse_drag( struct drag_info *drag );
		float *get_location() { return location->get(); }
		Rotation *get_rotation() { return rotation->get_rotation(); }
		
		void output_to_povray_pass1( ofstream & file );
		void output_to_povray_pass2( ofstream & file ) { if (  function->value() != NULL ) Object3D_with_material::output_to_povray_pass2( file ); }
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );
		
		bool is_inside( float x, float y, float z );
};
#endif
